/*
 * Decompiled with CFR 0.152.
 */
package de.jave.calculus;

import de.jave.calculus.SimpleNode;
import java.util.Stack;

final class JJTCalculusState {
    private Stack nodes = new Stack();
    private Stack marks = new Stack();
    private int sp = 0;
    private int mk = 0;

    JJTCalculusState() {
    }

    final void pushNode(SimpleNode n) {
        this.nodes.push(n);
        ++this.sp;
    }

    final SimpleNode popNode() {
        if (--this.sp < this.mk) {
            this.mk = (Integer)this.marks.pop();
        }
        return (SimpleNode)this.nodes.pop();
    }

    final int nodeArity() {
        return this.sp - this.mk;
    }

    final void clearNodeScope(SimpleNode n) {
        while (this.sp > this.mk) {
            this.popNode();
        }
        this.mk = (Integer)this.marks.pop();
    }

    final void openNodeScope(SimpleNode n) {
        this.marks.push(new Integer(this.mk));
        this.mk = this.sp;
    }

    final void closeNodeScope(SimpleNode n, int num) {
        this.mk = (Integer)this.marks.pop();
        while (num-- > 0) {
            SimpleNode c = this.popNode();
            n.jjtAddChild(c, num);
        }
        this.pushNode(n);
    }

    final void closeNodeScope(SimpleNode n, boolean condition) {
        if (condition) {
            int a = this.nodeArity();
            this.mk = (Integer)this.marks.pop();
            while (a-- > 0) {
                SimpleNode c = this.popNode();
                n.jjtAddChild(c, a);
            }
            this.pushNode(n);
            return;
        }
        this.mk = (Integer)this.marks.pop();
    }
}

