/*
 * Decompiled with CFR 0.152.
 */
package de.jave.calculus;

import de.jave.calculus.Calculus;
import de.jave.calculus.ParseException;
import de.jave.calculus.SimpleNode;
import de.jave.calculus.TokenMgrError;
import de.jave.jave.pixelplate.PixelPlate;
import de.jave.jave.pixelplate.PixelPlateMode;
import de.jave.lib.CharacterPlate;
import java.awt.Point;

public final class CalculusTool {
    public static final void plotFunction(String formula, PixelPlateMode plotMode, int plateWidth, int plateHeight, double minX, double maxX, double minY, double maxY, CharacterPlate cp) throws ParseException {
        PixelPlate plate = new PixelPlate(0, 0, plateWidth, plateHeight);
        plate.setMode(plotMode);
        int virtualWidth = plate.getVirtualWidth();
        int virtualHeight = plate.getVirtualHeight();
        double xStep = (maxX - minX) / (double)virtualWidth;
        double littleDX = xStep / 256.0;
        boolean lastValueOk = false;
        Point last = new Point();
        double lastY = 0.0;
        SimpleNode tree = null;
        try {
            tree = Calculus.getParseTree(formula);
        }
        catch (ParseException parseException) {
            ParseException e = parseException;
            throw parseException;
        }
        catch (TokenMgrError tokenMgrError) {
            throw new ParseException();
        }
        for (double x = minX; x <= maxX; x += xStep) {
            double y = 0.0;
            try {
                double d;
                y = tree.evaluate(x);
                if (d <= maxY && y >= minY) {
                    Point p = CalculusTool.getPointFor(x, y, minX, maxX, minY, maxY, virtualWidth, virtualHeight);
                    if (lastValueOk) {
                        plate.drawLineBresenham(p.x, p.y, last.x, last.y);
                    } else if (x == minX) {
                        plate.set(p.x, p.y);
                    } else {
                        double tendenzY = 0.0;
                        try {
                            tendenzY = Calculus.compute(formula, x + littleDX);
                        }
                        catch (TokenMgrError tokenMgrError) {
                            throw new ParseException();
                        }
                        if ((double)p.y > tendenzY) {
                            plate.drawLineBresenham(p.x, p.y, p.x, virtualHeight - 1);
                        } else if ((double)p.y < tendenzY) {
                            plate.drawLineBresenham(p.x, p.y, p.x, 0);
                        }
                    }
                    lastValueOk = true;
                    last.x = p.x;
                    last.y = p.y;
                    lastY = y;
                    continue;
                }
                if (lastValueOk) {
                    double tendenzY = 0.0;
                    try {
                        tendenzY = Calculus.compute(formula, x - xStep + littleDX);
                    }
                    catch (TokenMgrError tokenMgrError) {
                        throw new ParseException();
                    }
                    if (tendenzY < lastY) {
                        plate.drawLineBresenham(last.x, last.y, last.x, virtualHeight - 1);
                    } else if (tendenzY > lastY) {
                        plate.drawLineBresenham(last.x, last.y, last.x, 0);
                    }
                }
                lastValueOk = false;
                lastY = y;
                continue;
            }
            catch (Exception e) {
                System.out.println(e);
                lastValueOk = false;
            }
        }
        plate.convert();
        plate.pasteResultInto(cp);
    }

    public static final Point getPointFor(double x, double y, double minX, double maxX, double minY, double maxY, int virtualWidth, int virtualHeight) {
        int xx = (int)((x - minX) / (maxX - minX) * (double)virtualWidth);
        int yy = virtualHeight - (int)((y - minY) / (maxY - minY) * (double)virtualHeight);
        return new Point(xx, yy);
    }

    public static final CharacterPlate createAxis(PixelPlateMode axisMode, double axisX, double axisY, int plateWidth, int plateHeight, double minX, double maxX, double minY, double maxY) {
        PixelPlate plate = new PixelPlate(0, 0, plateWidth, plateHeight);
        plate.setMode(axisMode);
        int virtualWidth = plate.getVirtualWidth();
        int virtualHeight = plate.getVirtualHeight();
        Point p1 = CalculusTool.getPointFor(minX, axisY, minX, maxX, minY, maxY, virtualWidth, virtualHeight);
        Point p2 = CalculusTool.getPointFor(maxX, axisY, minX, maxX, minY, maxY, virtualWidth, virtualHeight);
        plate.drawLineBresenham(p1.x, p1.y, p2.x, p2.y);
        p1 = CalculusTool.getPointFor(axisX, minY, minX, maxX, minY, maxY, virtualWidth, virtualHeight);
        p2 = CalculusTool.getPointFor(axisX, maxY, minX, maxX, minY, maxY, virtualWidth, virtualHeight);
        plate.drawLineBresenham(p1.x, p1.y, p2.x, p2.y);
        plate.convert();
        CharacterPlate cp = new CharacterPlate(plate.getWidth(), plate.getHeight());
        plate.pasteResultInto(cp);
        return cp;
    }
}

