/*
 * Decompiled with CFR 0.152.
 */
package de.jave.asciimation.export.swf;

import de.jave.asciimation.export.AbstractAnimationExported;
import de.jave.asciimation.export.AnimationExportOptions;
import de.jave.asciimation.export.actionscript.ActionScriptAnimationExportFormat;
import de.jave.asciimation.export.actionscript.ActionScriptAnimationExporter;
import de.jave.javeplayer.AnimationMetaData;
import de.jave.javeplayer.AnimationProperties;
import de.jave.lib.CharacterPlate;
import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import net.disy.commons.core.exception.MessageException;
import net.disy.commons.core.message.Message;
import net.disy.commons.core.message.MessageType;
import net.disy.commons.core.util.Ensure;

public final class SwfAnimationExporter
extends AbstractAnimationExported {
    private AnimationExportOptions options;
    private ActionScriptAnimationExporter actionscriptExporter;
    private File actionScriptFile;
    private Dimension maxFrameSize;

    public SwfAnimationExporter(AnimationExportOptions options) {
        Ensure.ensureArgumentNotNull(options);
        this.options = options;
    }

    public final void init(Dimension maxFrameSize, AnimationProperties animationProperties, int frameCount, AnimationMetaData metaData) throws Exception {
        this.maxFrameSize = maxFrameSize;
        AnimationExportOptions actionScriptExportOptions = new AnimationExportOptions(this.options.getPreferences());
        actionScriptExportOptions.setFormat(new ActionScriptAnimationExportFormat());
        this.actionScriptFile = File.createTempFile("animation", ".as");
        actionScriptExportOptions.setOutputFile(this.actionScriptFile);
        actionScriptExportOptions.getAdditionalOptions().setLoop(this.options.getAdditionalOptions().isLoop());
        this.actionscriptExporter = new ActionScriptAnimationExporter(actionScriptExportOptions);
        this.actionscriptExporter.init(maxFrameSize, animationProperties, frameCount, metaData);
    }

    public final void writeFrame(CharacterPlate content) throws Exception {
        this.actionscriptExporter.writeFrame(content);
    }

    public final void finish() throws Exception {
        String line;
        this.actionscriptExporter.finish();
        String mtascPath = this.options.getAdditionalOptions().getMtascCompilerBinaryFile().getAbsolutePath();
        String asPath = this.actionScriptFile.getAbsolutePath();
        String outputPath = this.options.getFile().getAbsolutePath();
        Dimension platePixelSize = this.calculateExpectedPlatePixelSize(this.maxFrameSize);
        Object fps = null;
        String command = mtascPath + " -v -swf " + outputPath + " -main -header " + platePixelSize.width + ":" + platePixelSize.height + ":" + "20" + " " + asPath;
        System.out.println(command);
        Process process = Runtime.getRuntime().exec(command);
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        while ((line = reader.readLine()) != null) {
            System.out.println(line);
        }
        reader.close();
        int result = process.waitFor();
        this.cleanup();
        if (result != 0) {
            throw new MessageException(new Message("Unable to compile SWF file. External compiler exited with error code " + result + ".", MessageType.ERROR));
        }
    }

    private void cleanup() {
        this.actionScriptFile.delete();
    }

    public final void rollBack() {
    }
}

