/*
 * Decompiled with CFR 0.152.
 */
package de.jave.asciimation.export.onetext;

import de.jave.asciimation.export.AbstractAnimationExported;
import de.jave.asciimation.export.AnimationExportOptions;
import de.jave.javeplayer.AnimationMetaData;
import de.jave.javeplayer.AnimationProperties;
import de.jave.lib.CharacterPlate;
import de.jave.lib.io.IoUtilities;
import java.awt.Dimension;
import java.io.BufferedWriter;
import java.io.FileWriter;
import net.disy.commons.core.util.Ensure;

public final class OneTextAnimationExporter
extends AbstractAnimationExported {
    private final AnimationExportOptions options;
    private BufferedWriter bw;

    public OneTextAnimationExporter(AnimationExportOptions options) {
        Ensure.ensureArgumentNotNull(options);
        this.options = options;
    }

    public final void init(Dimension maxFrameSize, AnimationProperties animationProperties, int frameCount, AnimationMetaData metaData) throws Exception {
        this.bw = new BufferedWriter(new FileWriter(this.options.getFile()));
    }

    public final void writeFrame(CharacterPlate content) throws Exception {
        String[] lines = content.toStringArray();
        for (int i = 0; i < lines.length; ++i) {
            this.bw.write(lines[i]);
            this.bw.newLine();
        }
        this.bw.newLine();
    }

    public final void finish() throws Exception {
        IoUtilities.close(this.bw);
    }

    public final void rollBack() {
        IoUtilities.close(this.bw);
    }
}

