/*
 * Decompiled with CFR 0.152.
 */
package de.jave.asciimation.export.multipletexts;

import de.jave.asciimation.export.AbstractAnimationExported;
import de.jave.asciimation.export.AnimationExportOptions;
import de.jave.javeplayer.AnimationMetaData;
import de.jave.javeplayer.AnimationProperties;
import de.jave.lib.CharacterPlate;
import de.jave.text.TextTools;
import java.awt.Dimension;
import java.io.BufferedWriter;
import java.io.FileWriter;
import net.disy.commons.core.io.IOUtilities;
import net.disy.commons.core.util.Ensure;

public final class MultipleTextsAnimationExporter
extends AbstractAnimationExported {
    private final AnimationExportOptions options;
    private int frameCount = 0;
    private int ciffers = 4;

    public MultipleTextsAnimationExporter(AnimationExportOptions options) {
        Ensure.ensureArgumentNotNull(options);
        this.options = options;
    }

    public final void init(Dimension maxFrameSize, AnimationProperties animationProperties, int frameCount, AnimationMetaData metaData) throws Exception {
        this.ciffers = 1;
        --frameCount;
        while (frameCount >= 10) {
            frameCount /= 10;
            ++this.ciffers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeFrame(CharacterPlate content) throws Exception {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(this.options.getFileNameWithoutExtension() + "_" + TextTools.fillFront(String.valueOf(this.frameCount), '0', this.ciffers) + ".txt"));
            String[] lines = content.toStringArray();
            for (int i = 0; i < lines.length; ++i) {
                writer.write(lines[i]);
                writer.newLine();
            }
        }
        catch (Throwable throwable) {
            IOUtilities.close(writer);
            throw throwable;
        }
        IOUtilities.close(writer);
        ++this.frameCount;
    }

    public final void finish() throws Exception {
    }

    public final void rollBack() {
    }
}

