/*
 * Decompiled with CFR 0.152.
 */
package de.jave.asciimation.export;

import de.jave.asciimation.export.AnimationExportFormatPage;
import de.jave.asciimation.export.AnimationExportOptions;
import de.jave.asciimation.export.AnimationExportWizardModel;
import de.jave.asciimation.export.IAnimationExportFormat;
import de.jave.jave.preferences.AnimationExportPreferences;
import java.awt.Component;
import java.awt.Font;
import java.util.HashMap;
import java.util.Map;
import net.disy.commons.core.io.FileModel;
import net.disy.commons.core.util.Ensure;
import net.disy.commons.swing.dialog.wizard.AbstractWizardConfiguration;
import net.disy.commons.swing.dialog.wizard.IWizardPage;
import net.disy.commons.swing.dialog.wizard.WizardDialog;

public final class AnimationExportWizard
extends AbstractWizardConfiguration {
    private final String title;
    private AnimationExportFormatPage exportFormatPage;
    private final AnimationExportWizardModel model;
    private final Map optionsPageCache = new HashMap();
    private final IWizardPage optionalStartPage;

    public static final AnimationExportOptions showOptionsDialogs(Component parent, FileModel currentDirectoryModel, String title, IWizardPage optionalStartPage, Font displayFont, AnimationExportPreferences preferences) {
        AnimationExportWizardModel model = new AnimationExportWizardModel(currentDirectoryModel, displayFont, preferences);
        AnimationExportWizard wizard = new AnimationExportWizard(title, model, optionalStartPage);
        WizardDialog wizardDialog = new WizardDialog(parent, wizard);
        wizardDialog.show();
        if (wizardDialog.isCanceled()) {
            return null;
        }
        return model.getExportOptions();
    }

    public AnimationExportWizard(String title, AnimationExportWizardModel model, IWizardPage optionalStartPage) {
        Ensure.ensureArgumentNotNull(title);
        Ensure.ensureArgumentNotNull(model);
        this.title = title;
        this.model = model;
        this.optionalStartPage = optionalStartPage;
    }

    public final void addPages() {
        this.exportFormatPage = new AnimationExportFormatPage(this.title, this.model);
        this.exportFormatPage.setWizard(this);
        if (this.optionalStartPage != null) {
            this.optionalStartPage.setWizard(this);
        }
    }

    public final IWizardPage getStartingPage() {
        if (this.optionalStartPage != null) {
            return this.optionalStartPage;
        }
        return this.exportFormatPage;
    }

    public final IWizardPage getNextPage(IWizardPage page) {
        if (page == this.exportFormatPage) {
            IAnimationExportFormat format = this.model.getExportOptions().getFormat();
            if (format == null) {
                return null;
            }
            if (!this.optionsPageCache.containsKey(format)) {
                IWizardPage optionsPage = format.createOptionsPage(this.model);
                optionsPage.setWizard(this);
                this.optionsPageCache.put(format, optionsPage);
            }
            return (IWizardPage)this.optionsPageCache.get(format);
        }
        if (page == this.optionalStartPage) {
            return this.exportFormatPage;
        }
        return null;
    }

    public final IWizardPage getPreviousPage(IWizardPage page) {
        if (page == this.exportFormatPage) {
            return this.optionalStartPage;
        }
        if (page == this.optionalStartPage) {
            return null;
        }
        return this.exportFormatPage;
    }

    public final boolean performFinish(Component parentComponent) {
        return true;
    }

    public final boolean isHelpAvailable() {
        return false;
    }

    public final boolean performCancel(Component parentComponent) {
        return true;
    }
}

