/*
 * Decompiled with CFR 0.152.
 */
package de.jave.asciimation.editor;

import de.jave.asciimation.editor.AnimationEditorAdditionalControlsPanel;
import de.jave.asciimation.editor.AnimationEditorModel;
import de.jave.asciimation.editor.AnimationEditorToolBarFactory;
import de.jave.asciimation.editor.CurrentFrameIndexModel;
import de.jave.jave.Plate;
import de.jave.jave.preferences.AnimationExportPreferences;
import de.jave.jave.preferences.JaveApplicationPreferences;
import de.jave.jave.version.JaveTitleProvider;
import de.jave.javeplayer.AnimationMetaData;
import de.jave.javeplayer.JaveAnimationFile;
import de.jave.lib.Toolbox;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.disy.commons.core.io.FileModel;
import net.disy.commons.core.message.Message;
import net.disy.commons.core.message.MessageType;
import net.disy.commons.core.model.BooleanModel;
import net.disy.commons.core.util.Ensure;
import net.disy.commons.swing.dialog.message.MessageDialogFactory;
import net.disy.commons.swing.showhide.ShowHideContentPanel;

public final class AnimationEditorPanel {
    private final FileModel currentDirectoryModel;
    private final JaveApplicationPreferences preferences;
    private final BooleanModel showAdditionalControlsModel = new BooleanModel(true);
    private final AnimationEditorAdditionalControlsPanel additionalControlsPanel;
    private final AnimationEditorModel model;
    private final AnimationExportPreferences animationExportPreferences;
    private final JComponent content;

    public AnimationEditorPanel(AnimationEditorModel model, FileModel currentDirectoryModel, Plate plate, JaveApplicationPreferences preferences, AnimationExportPreferences animationExportPreferences) {
        Ensure.ensureArgumentNotNull(model);
        Ensure.ensureArgumentNotNull(animationExportPreferences);
        this.animationExportPreferences = animationExportPreferences;
        this.model = model;
        this.preferences = preferences;
        this.currentDirectoryModel = currentDirectoryModel;
        this.additionalControlsPanel = new AnimationEditorAdditionalControlsPanel(model);
        model.addChangeListener(new ChangeListener(){

            public final void stateChanged(ChangeEvent e) {
                AnimationEditorPanel.this.refresh();
            }
        });
        this.content = this.createGui();
        if (model.getAnimationFile() == null) {
            JaveAnimationFile animationFile = this.createNewAnimationFile();
            this.setAnimationFile(animationFile);
            model.setModified(false);
        }
        this.refresh();
    }

    public final JComponent getContent() {
        return this.content;
    }

    private JaveAnimationFile createNewAnimationFile() {
        JaveAnimationFile animationFile = new JaveAnimationFile();
        AnimationMetaData metaData = new AnimationMetaData();
        metaData.setDate(Toolbox.getDateString());
        metaData.setSoftware(JaveTitleProvider.JAVE + " (Animation Editor)");
        metaData.setAuthorName(this.preferences.getAuthorName());
        metaData.setAuthorEmail(this.preferences.getAuthorMail());
        animationFile.setMetaData(metaData);
        return animationFile;
    }

    private final JComponent createGui() {
        JPanel toolbarPanel = AnimationEditorToolBarFactory.createAnimationEditorToolBar(this.model, this.showAdditionalControlsModel, this.currentDirectoryModel, this.preferences.getDisplayFontModel(), this.animationExportPreferences);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new ShowHideContentPanel(this.showAdditionalControlsModel, this.additionalControlsPanel.getContent()).getContent(), "Center");
        panel.add((Component)toolbarPanel, "North");
        return panel;
    }

    public final void setCurrentFrame(int index) {
        if (index == -1) {
            index = 0;
        }
        this.model.getCurrentFrameIndexModel().setCurrentFrameIndex(index);
    }

    public final void refresh() {
        this.setCurrentFrame(this.model.getCurrentFrameIndexModel().getCurrentFrameIndex());
    }

    public final void doDeleteFrame(Component parentComponent) {
        JaveAnimationFile animationFile = this.model.getAnimationFile();
        if (animationFile.getFrameCount() == 1) {
            MessageDialogFactory.showMessageDialog(parentComponent, new Message("Delete frame", "There is only one frame. It can not be deleted.", MessageType.INFORMATION));
            return;
        }
        int currentFrameIndex = this.model.getCurrentFrameIndexModel().getCurrentFrameIndex();
        if (currentFrameIndex < 0 || currentFrameIndex >= animationFile.getFrameCount()) {
            return;
        }
        this.model.deleteFrame(currentFrameIndex);
        if (currentFrameIndex == animationFile.getFrameCount()) {
            this.model.navigatePrevious();
        }
        if (animationFile.getFrameCount() == 0) {
            this.setCurrentFrame(0);
        }
    }

    public final void setAnimationFile(JaveAnimationFile animationFile) {
        this.model.setAnimationFile(animationFile);
    }

    public final CurrentFrameIndexModel getCurrentFrameIndexModel() {
        return this.model.getCurrentFrameIndexModel();
    }

    public final AnimationEditorModel getModel() {
        return this.model;
    }
}

