/*
 * Decompiled with CFR 0.152.
 */
package de.jave.ascii.plate.ruler;

import de.jave.ascii.plate.ruler.AbstractRuler;
import de.jave.ascii.plate.ruler.AsciiRulerProperties;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import javax.swing.JComponent;
import net.disy.commons.swing.layout.util.LayoutDirection;

public final class AsciiTextAreaVerticalRuler
extends AbstractRuler {
    private static final AffineTransform ROTATE_LEFT = new AffineTransform(0.0f, -1.0f, 1.0f, 0.0f, 0.0f, 0.0f);

    public AsciiTextAreaVerticalRuler(AsciiRulerProperties properties, JComponent mainComponent) {
        super(mainComponent, properties, LayoutDirection.VERTICAL);
    }

    public final Dimension getPreferredSize() {
        if (this.getProperties().isVerticalRulerVisible()) {
            return new Dimension(11, this.getMainComponent().getSize().height);
        }
        return new Dimension(0, 0);
    }

    protected final void paintComponent(Graphics graphics) {
        if (!this.getProperties().isVerticalRulerVisible()) {
            return;
        }
        Graphics2D g = (Graphics2D)graphics;
        Rectangle clipBounds = g.getClipBounds();
        g.setColor(this.getProperties().getBackgroundColor());
        g.fillRect(clipBounds.x, clipBounds.y, clipBounds.width, clipBounds.height);
        double characterHeight = this.getProperties().getCharacterHeight();
        g.setColor(this.getProperties().getForegroundColor());
        g.setFont(this.getProperties().getFont());
        Point origin = this.getProperties().getPlateOrigin();
        int startCharacterIndex = (int)((double)(clipBounds.y - origin.y) / characterHeight);
        if (startCharacterIndex < 0) {
            startCharacterIndex = 0;
        }
        int endCharacterIndex = (int)((double)(clipBounds.y - origin.y + clipBounds.height) / characterHeight);
        if (this.getProperties().getDocumentSize() != null && this.getProperties().getDocumentSize().height <= endCharacterIndex) {
            endCharacterIndex = this.getProperties().getDocumentSize().height - 1;
        }
        int width = this.getSize().width;
        for (int characterIndex = startCharacterIndex; characterIndex <= endCharacterIndex + 1; ++characterIndex) {
            int y = origin.y + (int)((double)characterIndex * characterHeight);
            if (characterIndex % 10 == 0) {
                g.drawLine(width - 4, y, width - 1, y);
                AffineTransform previousTransformation = g.getTransform();
                g.transform(ROTATE_LEFT);
                String label = String.valueOf(characterIndex);
                int stringWidth = g.getFontMetrics().stringWidth(label);
                g.drawString(label, -y - stringWidth - 2, 9);
                g.setTransform(previousTransformation);
                continue;
            }
            if (characterIndex % 5 == 0) {
                g.drawLine(width - 5, y, width - 1, y);
                continue;
            }
            g.drawLine(width - 2, y, width - 1, y);
        }
        Point mousePoint = this.getMousePoint();
        if (mousePoint != null) {
            g.setColor(this.getProperties().getBackgroundColor());
            g.setXORMode(this.getProperties().getForegroundColor());
            g.drawLine(clipBounds.x, mousePoint.y, clipBounds.x + clipBounds.width, mousePoint.y);
            g.setPaintMode();
        }
    }
}

