/*
 * Decompiled with CFR 0.152.
 */
package de.jave.ascii.plate.ruler;

import de.jave.ascii.plate.ruler.AbstractRuler;
import de.jave.ascii.plate.ruler.AsciiRulerProperties;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import net.disy.commons.swing.layout.util.LayoutDirection;

public final class AsciiTextAreaHorizontalRuler
extends AbstractRuler {
    public AsciiTextAreaHorizontalRuler(AsciiRulerProperties properties, JComponent mainComponent) {
        super(mainComponent, properties, LayoutDirection.HORIZONTAL);
    }

    public final Dimension getPreferredSize() {
        if (this.getProperties().isHorizontalRulerVisible()) {
            return new Dimension(this.getMainComponent().getSize().width, 11);
        }
        return new Dimension(0, 0);
    }

    protected final void paintComponent(Graphics g) {
        Point mousePoint;
        if (!this.getProperties().isHorizontalRulerVisible()) {
            return;
        }
        Rectangle clipBounds = g.getClipBounds();
        g.setColor(this.getProperties().getBackgroundColor());
        g.fillRect(clipBounds.x, clipBounds.y, clipBounds.width, clipBounds.height);
        double characterWidth = this.getProperties().getCharacterWidth();
        g.setColor(this.getProperties().getForegroundColor());
        g.setFont(this.getProperties().getFont());
        Point origin = this.getProperties().getPlateOrigin();
        int startCharacterIndex = (int)((double)(clipBounds.x - origin.x) / characterWidth);
        if (startCharacterIndex < 0) {
            startCharacterIndex = 0;
        }
        int endCharacterIndex = (int)((double)(clipBounds.x - origin.x + clipBounds.width) / characterWidth);
        if (this.getProperties().getDocumentSize() != null && this.getProperties().getDocumentSize().width <= endCharacterIndex) {
            endCharacterIndex = this.getProperties().getDocumentSize().width - 1;
        }
        int height = this.getSize().height;
        for (int characterIndex = startCharacterIndex; characterIndex <= endCharacterIndex + 1; ++characterIndex) {
            int x = origin.x + (int)((double)characterIndex * characterWidth);
            if (characterIndex % 10 == 0) {
                g.drawLine(x, height - 5, x, height - 1);
                g.drawString(String.valueOf(characterIndex), x + 2, 8);
                continue;
            }
            if (characterIndex % 5 == 0) {
                g.drawLine(x, height - 4, x, height - 1);
                continue;
            }
            g.drawLine(x, height - 2, x, height - 1);
        }
        if (this.getProperties().isPrintMarginColumnVisible()) {
            int x = (int)((double)this.getProperties().getPrintMarginColumn() * characterWidth);
            g.drawLine(x - 2, 0, x + 2, 0);
            g.drawLine(x - 1, 1, x + 1, 1);
            g.drawLine(x - 1, 2, x + 1, 2);
            g.drawLine(x, 3, x, height);
        }
        if ((mousePoint = this.getMousePoint()) != null) {
            g.setColor(this.getProperties().getBackgroundColor());
            g.setXORMode(this.getProperties().getForegroundColor());
            g.drawLine(mousePoint.x, clipBounds.y, mousePoint.x, clipBounds.y + clipBounds.height);
            g.setPaintMode();
        }
    }
}

