/*
 * Decompiled with CFR 0.152.
 */
package de.jave.ascii.plate.ruler;

import de.jave.ascii.plate.CharacterMetrics;
import de.jave.ascii.plate.CharacterSizeModel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.SystemColor;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.disy.commons.core.model.AbstractChangeableModel;
import net.disy.commons.core.util.Ensure;
import net.disy.commons.core.util.ObjectUtilities;
import net.disy.commons.swing.fontchooser.model.FontModel;
import net.disy.commons.swing.layout.util.LayoutDirection;

public final class AsciiRulerProperties
extends AbstractChangeableModel {
    private int printMarginColumn = 72;
    private boolean printMarginColumnVisible = false;
    private boolean horizontalRulerVisible = false;
    private boolean verticalRulerVisible = false;
    private boolean showMouseLocation = false;
    private Color backgroundColor = SystemColor.control;
    private Color foregroundColor = new Color(64, 64, 64);
    private static final Font rulerFont = new Font("Dialog", 0, 9);
    private final CharacterSizeModel characterSizeModel;
    private Point plateOrigin = new Point(0, 0);
    private Dimension documentSize = null;

    public AsciiRulerProperties(FontModel fontModel) {
        this(AsciiRulerProperties.createCharacterSizeModel(fontModel));
    }

    private static CharacterSizeModel createCharacterSizeModel(final FontModel fontModel) {
        final CharacterSizeModel sizeModel = new CharacterSizeModel();
        fontModel.addChangeListener(new ChangeListener(){

            public final void stateChanged(ChangeEvent e) {
                AsciiRulerProperties.updateSize(fontModel, sizeModel);
            }
        });
        AsciiRulerProperties.updateSize(fontModel, sizeModel);
        return sizeModel;
    }

    private static void updateSize(FontModel fontModel, CharacterSizeModel sizeModel) {
        sizeModel.setCharSize(CharacterMetrics.createCharacterMetrics(fontModel.getFont()));
    }

    public AsciiRulerProperties(CharacterSizeModel characterSizeModel) {
        this.characterSizeModel = characterSizeModel;
        characterSizeModel.addChangeListener(new ChangeListener(){

            public final void stateChanged(ChangeEvent e) {
                AsciiRulerProperties.this.fireChangeEvent();
            }
        });
    }

    public final double getCharacterWidth() {
        return this.characterSizeModel.getCharacterSize().getWidth();
    }

    public final double getCharacterHeight() {
        return this.characterSizeModel.getCharacterSize().getHeight();
    }

    public final boolean isPrintMarginColumnVisible() {
        return this.printMarginColumnVisible;
    }

    public final void setPrintMarginColumnVisible(boolean printMarginColumnVisible) {
        if (this.printMarginColumnVisible == printMarginColumnVisible) {
            return;
        }
        this.printMarginColumnVisible = printMarginColumnVisible;
        this.fireChangeEvent();
    }

    public final Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public final Font getFont() {
        return rulerFont;
    }

    public final Color getForegroundColor() {
        return this.foregroundColor;
    }

    public final int getPrintMarginColumn() {
        return this.printMarginColumn;
    }

    public final boolean isHorizontalRulerVisible() {
        return this.horizontalRulerVisible;
    }

    public final void setHorizontalRulerVisible(boolean horizontalRulerVisible) {
        if (this.horizontalRulerVisible == horizontalRulerVisible) {
            return;
        }
        this.horizontalRulerVisible = horizontalRulerVisible;
        this.fireChangeEvent();
    }

    public final void setVerticalRulerVisible(boolean verticalRulerVisible) {
        if (this.verticalRulerVisible == verticalRulerVisible) {
            return;
        }
        this.verticalRulerVisible = verticalRulerVisible;
        this.fireChangeEvent();
    }

    public final boolean isVerticalRulerVisible() {
        return this.verticalRulerVisible;
    }

    public final void setPlateOrigin(Point plateOrigin) {
        Ensure.ensureArgumentNotNull(plateOrigin);
        if (this.plateOrigin.equals(plateOrigin)) {
            return;
        }
        this.plateOrigin = plateOrigin;
        this.fireChangeEvent();
    }

    public final Point getPlateOrigin() {
        return this.plateOrigin;
    }

    public final void setDocumentSize(Dimension documentSize) {
        if (ObjectUtilities.equals(this.documentSize, documentSize)) {
            return;
        }
        this.documentSize = documentSize;
        this.fireChangeEvent();
    }

    public final Dimension getDocumentSize() {
        return this.documentSize;
    }

    public final void setShowMouseLocation(boolean showMouseLocation) {
        if (this.showMouseLocation == showMouseLocation) {
            return;
        }
        this.showMouseLocation = showMouseLocation;
        this.fireChangeEvent();
    }

    public final boolean isShowMouseLocation() {
        return this.showMouseLocation;
    }

    public final boolean isRulerVisible(LayoutDirection direction) {
        if (direction == LayoutDirection.HORIZONTAL) {
            return this.isHorizontalRulerVisible();
        }
        return this.isVerticalRulerVisible();
    }
}

