/*
 * Decompiled with CFR 0.152.
 */
package de.jave.ascii.plate.ruler;

import de.jave.ascii.plate.ruler.AsciiRulerProperties;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.disy.commons.core.util.Ensure;
import net.disy.commons.swing.layout.util.LayoutDirection;

abstract class AbstractRuler
extends JComponent {
    private AsciiRulerProperties properties;
    private JComponent mainComponent;
    private Point mousePoint;

    public AbstractRuler(JComponent mainComponent, final AsciiRulerProperties properties, final LayoutDirection direction) {
        Ensure.ensureArgumentNotNull(mainComponent);
        Ensure.ensureArgumentNotNull(properties);
        this.setVisible(properties.isRulerVisible(direction));
        this.properties = properties;
        this.mainComponent = mainComponent;
        this.properties.addChangeListener(new ChangeListener(){

            public final void stateChanged(ChangeEvent e) {
                if (AbstractRuler.this.isVisible() != properties.isRulerVisible(direction)) {
                    AbstractRuler.this.setVisible(properties.isRulerVisible(direction));
                }
                AbstractRuler.this.repaint();
            }
        });
        mainComponent.addMouseMotionListener(new MouseMotionListener(){

            public final void mouseMoved(MouseEvent e) {
                AbstractRuler.this.mousePoint = e.getPoint();
                AbstractRuler.this.handleMouseEvent(e);
            }

            public final void mouseDragged(MouseEvent e) {
                AbstractRuler.this.mousePoint = e.getPoint();
                AbstractRuler.this.handleMouseEvent(e);
            }
        });
        mainComponent.addMouseListener(new MouseAdapter(){

            public final void mouseExited(MouseEvent e) {
                AbstractRuler.this.mousePoint = null;
                AbstractRuler.this.handleMouseEvent(e);
            }
        });
    }

    private void handleMouseEvent(MouseEvent e) {
        if (this.properties.isShowMouseLocation()) {
            this.repaint();
        }
    }

    protected final Point getMousePoint() {
        if (this.properties.isShowMouseLocation()) {
            return this.mousePoint;
        }
        return null;
    }

    protected final JComponent getMainComponent() {
        return this.mainComponent;
    }

    protected final AsciiRulerProperties getProperties() {
        return this.properties;
    }
}

