/*
 * Decompiled with CFR 0.152.
 */
package de.jave.ascii.font;

import java.awt.Component;
import java.awt.Font;
import javax.swing.JOptionPane;
import net.disy.commons.core.util.Ensure;
import net.disy.commons.swing.action.SmartAction;
import net.disy.commons.swing.fontchooser.model.FontModel;
import net.disy.commons.swing.fontchooser.util.FontUtilities;
import net.disy.commons.swing.fontchooser.view.FontChooserDialog;
import net.disy.commons.swing.fontchooser.view.fixedwidth.FixedWidthFontChooserDialogFactory;

public final class ChooseDisplayFontAction
extends SmartAction {
    private final FontModel displayFontModel;

    public ChooseDisplayFontAction(FontModel displayFontModel) {
        super("Display font...");
        Ensure.ensureArgumentNotNull(displayFontModel);
        this.displayFontModel = displayFontModel;
    }

    protected final void execute(Component parentComponent) {
        int answer;
        FontChooserDialog dialog = FixedWidthFontChooserDialogFactory.getInstance().createFontChooserDialog(parentComponent, new FontModel(this.displayFontModel.getFontDescription()));
        dialog.show("Display font");
        if (dialog.isCanceled()) {
            return;
        }
        Font selectedFont = dialog.getFont();
        if (!FontUtilities.isFixedWidth(selectedFont) && (answer = JOptionPane.showConfirmDialog(parentComponent, "The chosen font does not seem to be a fixed width font.\nUsing proportional fonts is discouraged for Ascii art.\nDo you want to use the selected font anyway?", "Display font", 0)) == 1) {
            return;
        }
        this.displayFontModel.setFont(selectedFont);
    }
}

