package vgp.tutor.vectorField;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

import jv.object.PsDebug;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;
import jv.objectGui.PsTabPanel;
import jv.objectGui.PsMultiLineLabel;
import jv.project.PjProject_IP;

/**
 * Info panel of tutorial project on vector fields.
 *
 * @author		Konrad Polthier
 * @version		11.11.02, 1.01 revised (ep) Corrected hint text.<br>
 *					18.09.99, 1.00 created (kp)
 */
public class PjVectorField_IP extends PjProject_IP implements ActionListener, ItemListener {
	protected	PjVectorField				m_pjVectorfield;
	protected	PsTabPanel					m_tabPanel;
	protected	PsPanel						m_pPotential;

	protected	CheckboxGroup				m_gField;
	protected	Checkbox						m_cGradient;
	protected	Checkbox						m_cRotation;

	/**
	 * Create and layout the widgets of the panel.
	 */
	public PjVectorField_IP() {
		super();
		addTitle("Vector Field from Potentials");

		m_pPotential = new PsPanel();
		{
			PsMultiLineLabel lHints = new PsMultiLineLabel("Press 'a' and click into display to add a singularity.\n"
																		 +"Press 'p' while dragging one of the red singularities.\n"
																		 +"Use Method->Mark->MarkVertices and "
																		 +"Method->Delete->MarkedVertices to remove singularities.");
			m_pPotential.add(lHints);

			Panel pField = new Panel();
			pField.setLayout(new GridLayout(1, 2));
			{
					m_gField = new CheckboxGroup();
					m_cGradient	= new Checkbox("Gradient", m_gField, true);
					m_cGradient.addItemListener(this);
					pField.add(m_cGradient);
					m_cRotation		= new Checkbox("Rotation", m_gField, false);
					m_cRotation.addItemListener(this);
					pField.add(m_cRotation);
			}
			m_pPotential.add(pField);
		}
		m_tabPanel = new PsTabPanel();
		add(m_tabPanel);
		if (getClass() == PjVectorField_IP.class)
			init();
	}
	/**
	 * Set values of variables. Method is also used to reset the panel.
	 */
	public void init() {
		super.init();
	}
	/**
	 * Set parent of panel which supplies the data inspected by the panel.
	 */
	public void setParent(PsUpdateIf parent) {
		super.setParent(parent);
		m_pjVectorfield = (PjVectorField)parent;
		m_tabPanel.init(); // reset tab
		{
			m_pPotential.add(m_pjVectorfield.m_radius.getInfoPanel());
			m_tabPanel.addPanel("Potential", m_pPotential);
		}
		if (m_pjVectorfield.m_geom!=null && m_pjVectorfield.m_geom.getControlPanel()!=null) {
			m_tabPanel.addPanel("Grid", m_pjVectorfield.m_geom.getControlPanel());
		}
		if (m_pjVectorfield.m_vf!=null) {
			PsPanel pInfo = m_pjVectorfield.m_vf.getInfoPanel();
			if (pInfo != null) {
				pInfo.setBorderType(PsPanel.BORDER_NONE);
				m_tabPanel.addPanel("Vector Info", pInfo);
			}
		}
		// Refresh card layout and show named panel
		m_tabPanel.validate();
		m_tabPanel.setVisible("Potential");
	}
	/**
	 * Update the panel whenever the parent has changed somewhere else.
	 * Method is invoked from the parent or its superclasses.
	 */
	public boolean update(Object event) {
		if (PsDebug.NOTIFY) PsDebug.notify("PjVectorField_IP.update: called");
		if (event == m_pjVectorfield) {
			if (m_gField.getSelectedCheckbox()==m_cGradient &&
				 m_pjVectorfield.getFieldType()!=PjVectorField.GRADIENT)
				m_gField.setSelectedCheckbox(m_cRotation);
			else if (m_gField.getSelectedCheckbox()==m_cRotation &&
				 m_pjVectorfield.getFieldType()!=PjVectorField.ROTATION)
				m_gField.setSelectedCheckbox(m_cGradient);
			return true;
		}
		return super.update(event);
	}
	/**
	 * Handle action events invoked from buttons, menu items, text fields.
	 */
	public void actionPerformed(ActionEvent event) {
		if (m_pjVectorfield==null)
			return;
		// Object source = event.getSource();
	}
	/**
	 * Handle item state events invoked from choices, checkboxes, list items.
	 */
	public void itemStateChanged(ItemEvent event) {
		if (m_pjVectorfield == null)
			return;
		Object source = event.getSource();
		if (source == m_cGradient) {
			m_pjVectorfield.setFieldType(PjVectorField.GRADIENT);
			m_pjVectorfield.update(this);
		} else if (source == m_cRotation) {
			m_pjVectorfield.setFieldType(PjVectorField.ROTATION);
			m_pjVectorfield.update(this);
		}
	}
}
