package vgp.tutor.ruler;

import java.applet.Applet;
import java.awt.*;

import jv.object.*;
import jv.project.PvDisplayIf;
import jv.viewer.PvViewer;

/**
 * Applet demonstrates usage as ruler to measure in a scene.
 * 
 * @author		Steve Dugaro
 * @version		04.05.00, 1.00 created (spd)
 */
public class PaRuler extends Applet {
	/** frame if run standalone, null if run as applet. */
	public		Frame				m_frame			= null;
	/** 3D-viewer window for graphics output and which is embedded into the applet. */
	protected	PvViewer			m_viewer;

	/** Interface of applet to inform about author, version, and copyright. */
	public String getAppletInfo() {
		return "Name: "		+ this.getClass().getName()+ "\r\n" +
				 "Author: "		+ "Steve Dugaro" + "\r\n" +
				 "Version: "	+ "1.01" + "\r\n" +
				 "Applet demonstrates the use of a ruler to measure on a display." + "\r\n";
	}

	/**
	 * Configure and initialize the viewer, load system and user projects.
	 * One of the user projects must be selected here.
	 */
	public void init() {
		// Create viewer for viewing 3d geometries
		m_viewer = new PvViewer(this, m_frame);

		// Create and load a project
		PjRuler test = new PjRuler();
		m_viewer.addProject(test);
		m_viewer.selectProject(test);

		// Get 3d display from viewer and add it to applet
		setLayout(new BorderLayout());
		PvDisplayIf disp = m_viewer.getDisplay();

		add((Component)disp, BorderLayout.CENTER);
		add(m_viewer.getPanel(PsViewerIf.PROJECT), BorderLayout.EAST);
		validate();
		m_viewer.showPanel(PsViewerIf.MATERIAL);
	}
	/**
	 * Standalone application support. The main() method acts as the applet's
	 * entry point when it is run as a standalone application. It is ignored
	 * if the applet is run from within an HTML page.
	 */
	public static void main(String args[]) {
		PaRuler va	= new PaRuler();
		// Create toplevel window of application containing the applet
		Frame frame	= new jv.object.PsMainFrame(va, args);
		frame.pack();
		va.m_frame = frame;
		va.init();
		va.start();
		frame.setBounds(new Rectangle(420, 5, 640, 550));
		frame.setVisible(true);
	}
	
	/** Print info while initializing applet and viewer. */
	public void paint(Graphics g) {
		g.setColor(Color.blue);
		g.drawString("Geometry Browser, Version "+PsConfig.getVersion(), 20, 40);
		g.drawString("Loading Projects .....", 20, 60);
	}

	/**
	 * Does clean-up when applet is destroyed by the browser.
	 * Here we just close and dispose all our control windows.
	 */
	public void destroy()	{ m_viewer.destroy(); }

	/** Start viewer, e.g. start animation if requested */
	public void start()		{ m_viewer.start();	}

	/** Stop viewer, e.g. stop animation if requested */
	public void stop()		{ m_viewer.stop(); }
}
