@echo off
rem # USAGE:    At the JavaView installation directory call
rem #             bin\javaview.bat [options] [geometry-file]
rem #           - the geometry-file is optional
rem #           - use a relative path name to the geometry file
rem #           - each option pair must be enclosed in quotes like "key=value"
rem #
rem # EXAMPLES: Switch to base of your JavaView installation
rem #             cd c:\Programme\JavaView\
rem #           Then run JavaView with a command like
rem #             bin\javaview.bat sample.obj
rem #           or including options like in
rem #             bin\javaview.bat "control=show" "panel=material" sample.obj
rem #             bin\javaview.bat "language=de" sample.obj
rem #
rem # NOTES:    - you may have to edit the variables below
rem #           - On MS Windows 98 activate the section WINDOWS98 MODE and deactivate
rem #             all commands in the NORMAL MODE if there is a problem with
rem #             the environment stack. Sometimes the environment cannot store
rem #             the variables used for abbreviation.
rem #           - Optionally, put a link to this BAT file on your desktop,
rem #             and in the property panel of the link adjust the directory "Execute in .."
rem #             to the JavaView base directory such as "c:\JavaView\".
rem #
rem # PURPOSE:  launch JavaView, optionally with a 3d-geometry and command line args
rem #

rem # NORMAL MODE (for Windows NT and XP):
rem # 
rem # Adjust the base directory of JavaView to your installation.
rem # set jv_cb=c:\Programme\JavaView\
set jv_cb=.
rem # The variable jv_jar specifies the location of the JavaView archive "javaview.jar"
rem # The two archives "jvx.jar" and "vgpapp.jar" are optional.
set jv_jar=%jv_cb%/jars/javaview.jar;%jv_cb%/jars/jvx.jar;%jv_cb%/jars/vgpapp.jar;%jv_cb%
rem # 
rem # 1. Either use the Java virtual machine from Sun. This requires
rem #    the download and installation of the current JDK from java.sun.com (www.javasoft.com)
start "Java console for JavaView" /min java -cp %jv_jar% -Xmx256m javaview codebase=%jv_cb% %1 %2 %3 %4 %5 %6 %7 %8 %9
rem #    The following alternative command increases the memory available to the Java virtual machine
rem #    and should be used if Java runs out of memory during a JavaView session.
rem #    Here Java's default memory size of 64MB is increased to 512MB. Adjust to your hardware capacitiy.
rem # start "Java console for JavaView" /min java -cp %jv_jar% -Xmx512m javaview codebase=%jv_cb% %1 %2 %3 %4 %5 %6 %7 %8 %9
rem # 
rem # 2. Or use Java virtual machine from Microsoft which is preinstalled
rem #    on most MS-Windows systems until 2003. The file wjview.exe is located either in
rem #    c:\Windows\system or c:\Windows\system32 depending on the Windows version.
rem start wjview /cp:a %jv_jar% javaview.class codebase=%jv_cb% %1 %2 %3 %4 %5 %6 %7 %8 %9

rem # WINDOWS98 MODE:
rem # 
rem # Adjust the following commands to your personal settings.
rem # 
rem # 1. Either use the Java virtual machine from Sun. This requires
rem #    the download and installation of the current JDK from java.sun.com (www.javasoft.com)
rem start "Java console for JavaView" /min java -cp jars/javaview.jar;jars/jvx.jar;jars/vgpapp.jar;. javaview codebase=. %1 %2 %3 %4 %5 %6 %7 %8 %9
rem # 
rem # 2. Or use Java virtual machine from Microsoft which is preinstalled
rem #    on most MS-Windows systems until 2003. The file wjview.exe is located either in
rem #    c:\Windows\system or c:\Windows\system32 depending on the Windows version.
rem start wjview /cp:a jars/javaview.jar;jars/jvx.jar;jars/vgpapp.jar;. javaview.class codebase=. %1 %2 %3 %4 %5 %6 %7 %8 %9
