/*
 * Decompiled with CFR 0.152.
 */
package vgp.tutor.rootFinder;

import java.awt.Color;
import jv.function.PuFunction;
import jv.geom.PgPointSet;
import jv.geom.PgPolygon;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsDebug;
import jv.object.PsUpdateIf;
import jv.project.PgGeometryIf;
import jv.project.PjProject;
import jv.project.PvDisplayIf;
import jv.vecmath.PdVector;
import jvx.numeric.PnRootFinder;

public class PjRootFinder
extends PjProject {
    protected PgPolygon m_graph = new PgPolygon(2);
    protected PgPointSet m_root;
    protected PuFunction m_fx;
    private String m_defaultEquation = "u*cos(u+1.)-sin(u)";
    protected PuInteger m_discr;
    protected PuDouble m_xMin;
    protected PuDouble m_xMax;
    private static /* synthetic */ Class class$vgp$tutor$rootFinder$PjRootFinder;

    public void computeGraph() {
        int n = this.m_graph.getNumVertices();
        double d = this.m_xMin.getValue();
        double d2 = (this.m_xMax.getValue() - d) / ((double)n - 1.0);
        int n2 = 0;
        while (n2 < n) {
            double d3 = this.m_fx.eval(d);
            this.m_graph.setVertex(n2, d, d3);
            d += d2;
            ++n2;
        }
    }

    public PjRootFinder() {
        super("Root Finder");
        this.m_graph.setName("Graph of Function");
        this.m_root = new PgPointSet(2);
        this.m_root.setName("Roots of Function");
        this.m_discr = new PuInteger("Discr of Polygon", (PsUpdateIf)this);
        this.m_xMin = new PuDouble("xMin", (PsUpdateIf)this);
        this.m_xMax = new PuDouble("xMax", (PsUpdateIf)this);
        this.m_fx = new PuFunction(1, 1);
        this.m_fx.setName("Function Expression");
        this.m_fx.setParent((PsUpdateIf)this);
        if (((Object)((Object)this)).getClass() == (class$vgp$tutor$rootFinder$PjRootFinder != null ? class$vgp$tutor$rootFinder$PjRootFinder : (class$vgp$tutor$rootFinder$PjRootFinder = PjRootFinder.class$("vgp.tutor.rootFinder.PjRootFinder")))) {
            this.init();
        }
    }

    public void setEquation(String string) {
        this.m_fx.setExpression(string);
        this.m_fx.update((Object)this.m_fx);
    }

    public void findRoot() {
        int n = this.m_discr.getValue();
        PdVector pdVector = PnRootFinder.findRoots((PuFunction)this.m_fx, (double)this.m_xMin.getValue(), (double)this.m_xMax.getValue(), (int)n);
        if (pdVector == null) {
            PsDebug.warning((String)"roots not found.");
            return;
        }
        int n2 = pdVector.getSize();
        this.m_root.setNumVertices(n2);
        int n3 = 0;
        while (n3 < n2) {
            this.m_root.setVertex(n3, pdVector.getEntry(n3), 0.0);
            ++n3;
        }
    }

    public boolean update(Object object) {
        if (object == this.m_xMin) {
            this.computeGraph();
            this.findRoot();
            this.m_graph.update((Object)this.m_graph);
            this.m_root.update((Object)this.m_root);
            return true;
        }
        if (object == this.m_xMax) {
            this.computeGraph();
            this.findRoot();
            this.m_graph.update((Object)this.m_graph);
            this.m_root.update((Object)this.m_root);
            return true;
        }
        if (object == this.m_discr) {
            this.m_graph.setNumVertices(this.m_discr.getValue());
            this.computeGraph();
            this.findRoot();
            this.m_graph.update((Object)this.m_graph);
            this.m_root.update((Object)this.m_root);
            return true;
        }
        if (object == this.m_fx) {
            this.computeGraph();
            this.findRoot();
            this.m_graph.update((Object)this.m_graph);
            this.m_root.update((Object)this.m_root);
            return true;
        }
        return false;
    }

    public void start() {
        this.computeGraph();
        this.findRoot();
        this.addGeometry((PgGeometryIf)this.m_graph);
        this.addGeometry((PgGeometryIf)this.m_root);
        this.selectGeometry((PgGeometryIf)this.m_root);
        this.m_graph.update((Object)this.m_graph);
        this.m_root.update((Object)this.m_root);
        PvDisplayIf pvDisplayIf = this.getDisplay();
        if (pvDisplayIf != null) {
            pvDisplayIf.showGrid(true);
            pvDisplayIf.selectCamera(1);
            pvDisplayIf.setMajorMode(6);
        }
        super.start();
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void init() {
        super.init();
        this.m_xMin.setDefBounds(-20.0, 20.0, 0.1, 1.0);
        this.m_xMin.setDefValue(-10.0);
        this.m_xMin.init();
        this.m_xMax.setDefBounds(-20.0, 20.0, 0.1, 1.0);
        this.m_xMax.setDefValue(10.0);
        this.m_xMax.init();
        this.m_discr.setDefBounds(2, 200, 1, 5);
        this.m_discr.setDefValue(200);
        this.m_discr.init();
        this.m_graph.setNumVertices(this.m_discr.getValue());
        this.m_root.showIndices(true);
        this.m_root.setGlobalVertexColor(Color.blue);
        this.m_root.setGlobalVertexSize(4.0);
        this.setEquation(this.m_defaultEquation);
    }
}

