/*
 * Decompiled with CFR 0.152.
 */
package vgp.tutor.pick;

import jv.geom.PgElementSet;
import jv.geom.PgPolygon;
import jv.project.PgGeometryIf;
import jv.project.PjProject;
import jv.project.PvPickEvent;
import jv.vecmath.PdVector;
import jvx.geom.PgTube;

public class PjPickEvent
extends PjProject {
    protected boolean m_bShowTorus;
    protected boolean m_bShowTube;
    protected PgElementSet m_torus = new PgElementSet(3);
    protected PgTube m_tube;
    protected PgPolygon m_knot;
    private static /* synthetic */ Class class$vgp$tutor$pick$PjPickEvent;

    public PjPickEvent() {
        super("Pick Event");
        this.m_torus.setName("Torus");
        this.m_knot = new PgPolygon(3);
        this.m_knot.setName("Curve on Surface");
        this.m_tube = new PgTube(3);
        this.m_tube.setName("Tube around Curve");
        this.m_tube.setPolygon(this.m_knot);
        if (((Object)((Object)this)).getClass() == (class$vgp$tutor$pick$PjPickEvent != null ? class$vgp$tutor$pick$PjPickEvent : (class$vgp$tutor$pick$PjPickEvent = PjPickEvent.class$("vgp.tutor.pick.PjPickEvent")))) {
            this.init();
        }
    }

    public boolean update(Object object) {
        if (object == this.m_tube) {
            return super.update(null);
        }
        if (object == this.m_knot) {
            return this.m_tube.update((Object)this.m_knot);
        }
        return super.update(object);
    }

    public void start() {
        this.addGeometry((PgGeometryIf)this.m_torus);
        this.addGeometry((PgGeometryIf)this.m_knot);
        this.addGeometry((PgGeometryIf)this.m_tube);
        this.selectGeometry((PgGeometryIf)this.m_torus);
        super.start();
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void init() {
        super.init();
        this.m_bShowTorus = true;
        this.m_bShowTube = true;
        this.m_torus.showElements(false);
        this.m_torus.computeTorus(10, 10, 2.0, 1.0);
        this.m_torus.makeQuadrBnd(10, 10);
        this.m_torus.close();
        this.m_knot.init();
        this.m_tube.setDefThickness(0.2);
        this.m_tube.init();
        this.m_tube.setPolygon(this.m_knot);
        this.m_tube.generateTube();
    }

    public void pickInitial(PvPickEvent pvPickEvent) {
        PdVector pdVector;
        int n = this.m_knot.getNumVertices();
        if (n > 0 && PdVector.sqrDist((PdVector)(pdVector = this.m_knot.getVertex(n - 1)), (PdVector)pvPickEvent.getVertex()) < this.m_torus.getDiameter() / 100.0) {
            return;
        }
        this.m_knot.addVertex(pvPickEvent.getVertex());
        this.m_knot.update((Object)this.m_knot);
    }
}

