/*
 * Decompiled with CFR 0.152.
 */
package vgp.tutor.linear;

import java.awt.Color;
import jv.geom.PgPolygon;
import jv.geom.PgPolygonSet;
import jv.object.PsDebug;
import jv.object.PsUpdateIf;
import jv.project.PgGeometryIf;
import jv.project.PjProject;
import jv.project.PvDisplayIf;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public class PjLinear
extends PjProject {
    public static final int MODE_ADD = 0;
    public static final int MODE_SUB = 1;
    public static final int MODE_CROSS = 2;
    protected PgPolygonSet m_vectors = new PgPolygonSet(2);
    protected PgPolygon m_result;
    protected int m_mode;
    private static /* synthetic */ Class class$vgp$tutor$linear$PjLinear;

    public PjLinear() {
        super("Interactive Linear Algebra");
        this.m_vectors.setName("2 Vectors");
        this.m_result = new PgPolygon(3);
        this.m_result.setName("Result");
        if (((Object)((Object)this)).getClass() == (class$vgp$tutor$linear$PjLinear != null ? class$vgp$tutor$linear$PjLinear : (class$vgp$tutor$linear$PjLinear = PjLinear.class$("vgp.tutor.linear.PjLinear")))) {
            this.init();
        }
    }

    public int getMode() {
        return this.m_mode;
    }

    public int setMode(int n) {
        this.m_mode = n;
        PvDisplayIf pvDisplayIf = this.getDisplay();
        if (this.m_mode == 2 && pvDisplayIf != null) {
            pvDisplayIf.selectCamera(0);
        } else if (pvDisplayIf != null) {
            pvDisplayIf.selectCamera(1);
        }
        this.computeResult(this.m_mode);
        this.m_result.update((Object)this.m_result);
        return this.m_mode;
    }

    public void computeResult(int n) {
        PdVector pdVector = PdVector.copyNew((PdVector)this.m_vectors.getVertex(0));
        PdVector pdVector2 = PdVector.subNew((PdVector)this.m_vectors.getVertex(1), (PdVector)pdVector);
        PdVector pdVector3 = PdVector.subNew((PdVector)this.m_vectors.getVertex(2), (PdVector)pdVector);
        pdVector.setSize(3);
        pdVector2.setSize(3);
        pdVector3.setSize(3);
        PdVector pdVector4 = new PdVector(3);
        switch (this.m_mode) {
            case 0: {
                pdVector4.add(pdVector2, pdVector3);
                break;
            }
            case 1: {
                pdVector4.sub(pdVector2, pdVector3);
                break;
            }
            case 2: {
                pdVector4.cross(pdVector2, pdVector3);
                break;
            }
            default: {
                PsDebug.warning((String)("unknown mode = " + this.m_mode));
                return;
            }
        }
        this.m_result.setVertex(0, pdVector);
        pdVector4.add(pdVector);
        this.m_result.setVertex(1, pdVector4);
    }

    public boolean update(Object object) {
        if (object == this.m_vectors) {
            this.computeResult(this.m_mode);
            this.m_result.update((Object)this.m_result);
            return true;
        }
        return super.update(object);
    }

    public void start() {
        this.computeResult(this.m_mode);
        this.addGeometry((PgGeometryIf)this.m_result);
        this.addGeometry((PgGeometryIf)this.m_vectors);
        this.selectGeometry((PgGeometryIf)this.m_vectors);
        PvDisplayIf pvDisplayIf = this.getDisplay();
        if (pvDisplayIf != null) {
            pvDisplayIf.showGrid(true);
            pvDisplayIf.selectCamera(1);
            pvDisplayIf.setMajorMode(5);
        }
        super.start();
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void init() {
        super.init();
        this.m_vectors.init();
        this.m_vectors.setNumVertices(3);
        this.m_vectors.setVertex(0, 0.0, 0.0);
        this.m_vectors.setVertex(1, 0.5, 1.0);
        this.m_vectors.setVertex(2, -2.0, 2.0);
        this.m_vectors.setNumPolygons(2);
        this.m_vectors.setPolygon(0, new PiVector(0, 1));
        this.m_vectors.setPolygon(1, new PiVector(0, 2));
        this.m_vectors.getPolygon(0).setName("v");
        this.m_vectors.getPolygon(1).setName("w");
        this.m_vectors.showPolygonLabels(true);
        this.m_vectors.setGlobalPolygonColor(Color.blue);
        this.m_vectors.setGlobalPolygonSize(2.0);
        this.m_vectors.showPolygonEndArrow(true);
        this.m_vectors.setParent((PsUpdateIf)this);
        this.m_result.setNumVertices(2);
        this.m_result.setGlobalEdgeColor(Color.red);
        this.m_result.setGlobalEdgeSize(2.0);
        this.m_result.showPolygonEndArrow(true);
        this.setMode(0);
    }
}

