/*
 * Decompiled with CFR 0.152.
 */
package vgp.tutor.key;

import jv.anim.PsAnimation;
import jv.anim.PsKeyframe;
import jv.anim.PsTimeListenerIf;
import jv.loader.PgLoader;
import jv.number.PuString;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsUtil;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.project.PjProject;
import jv.project.PvViewerIf;

public class PjKeyframe
extends PjProject {
    private static String m_defaultModel = "models/cmc/Lawson_3_90_60_Anim.*.byu";
    private static int m_defaultNumKeys = 5;
    protected PsKeyframe[] m_keyframe;
    protected String m_fileName;
    protected int m_numKeys;
    protected PsAnimation m_anim = new PsAnimation();
    private static /* synthetic */ Class class$vgp$tutor$key$PjKeyframe;

    public void setFileName(String string, int n) {
        if (string != null) {
            this.m_fileName = string;
            this.m_numKeys = n;
            return;
        }
        this.m_fileName = PsConfig.getCodeBase() + m_defaultModel;
        this.m_numKeys = m_defaultNumKeys;
    }

    public PjKeyframe() {
        super("Keyframe Animation");
        this.m_anim.enableKeys(true);
        this.setAnimation(this.m_anim);
        if (((Object)((Object)this)).getClass() == (class$vgp$tutor$key$PjKeyframe != null ? class$vgp$tutor$key$PjKeyframe : (class$vgp$tutor$key$PjKeyframe = PjKeyframe.class$("vgp.tutor.key.PjKeyframe")))) {
            this.init();
        }
    }

    public boolean update(Object object) {
        return super.update(object);
    }

    public boolean load() {
        if (this.m_fileName == null) {
            PsDebug.warning((String)"missing file name to load");
            return false;
        }
        if (this.m_keyframe != null) {
            int n = 0;
            while (n < this.m_keyframe.length) {
                PgGeometry pgGeometry = this.m_keyframe[n].getDynamic();
                this.removeGeometry((PgGeometryIf)pgGeometry);
                this.m_anim.removeTimeListener((PsTimeListenerIf)this.m_keyframe[n]);
                this.m_keyframe[n].init();
                ++n;
            }
            this.m_keyframe = null;
        }
        double d = 0.0;
        double d2 = 100.0;
        double d3 = d;
        double d4 = (d2 - d) / ((double)this.m_numKeys - 1.0);
        String string = PsUtil.getFileName((String)this.m_fileName);
        String[] stringArray = PuString.splitString((String)this.m_fileName, (char)'*');
        if (stringArray == null || stringArray.length != 2) {
            PsDebug.warning((String)("wrong syntax, fileName = " + this.m_fileName));
            return false;
        }
        int n = String.valueOf(this.m_numKeys).length();
        int n2 = -1;
        int n3 = 0;
        while (n3 < this.m_numKeys) {
            int n4;
            String string2 = String.valueOf(n3 + 1);
            int n5 = string2.length();
            while (n5 < n) {
                string2 = "0" + string2;
                ++n5;
            }
            PgLoader pgLoader = new PgLoader();
            String string3 = stringArray[0] + string2 + stringArray[1];
            PgGeometry[] pgGeometryArray = pgLoader.loadGeometry(null, string3);
            if (pgGeometryArray == null || pgGeometryArray.length == 0) {
                PsDebug.warning((String)("failed loading file = " + string3));
                return false;
            }
            if (n3 == 0) {
                n2 = pgGeometryArray.length;
                this.m_keyframe = new PsKeyframe[n2];
                n4 = 0;
                while (n4 < n2) {
                    this.m_keyframe[n4] = new PsKeyframe();
                    ++n4;
                }
            } else if (n2 != pgGeometryArray.length) {
                PsDebug.warning((String)("different number of geometries in file = " + string3));
                return false;
            }
            n4 = 0;
            while (n4 < n2) {
                int n6 = this.m_keyframe[n4].addKey(pgGeometryArray[n4], d3);
                if (n6 == -1) {
                    PsDebug.warning((String)("geometry of different type: key=" + n3 + ", geom=" + n4));
                    return false;
                }
                ++n4;
            }
            d3 += d4;
            ++n3;
        }
        n3 = 0;
        while (n3 < n2) {
            this.m_keyframe[n3].setTime(d);
            if (n2 == 1) {
                this.m_keyframe[n3].setName(string);
            } else {
                this.m_keyframe[n3].setName(string + "[" + n3 + "]");
            }
            this.m_anim.addTimeListener((PsTimeListenerIf)this.m_keyframe[n3]);
            this.addGeometry((PgGeometryIf)this.m_keyframe[n3].getDynamic());
            ++n3;
        }
        this.selectGeometry((PgGeometryIf)this.m_keyframe[0].getDynamic());
        this.m_anim.setName(string);
        this.m_anim.update((Object)this.m_anim);
        return true;
    }

    public void start() {
        String string;
        PvViewerIf pvViewerIf = this.getViewer();
        if (this.m_fileName == null) {
            this.m_fileName = pvViewerIf.getParameter("Model");
            try {
                string = pvViewerIf.getParameter("Number");
                if (string != null) {
                    this.m_numKeys = Integer.parseInt(string);
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.m_numKeys = 1;
            }
        }
        if (this.m_fileName == null) {
            this.setFileName(PsConfig.getCodeBase() + m_defaultModel, m_defaultNumKeys);
        }
        if (this.load() && ((string = pvViewerIf.getParameter("Animation")) == null || string.equalsIgnoreCase("show"))) {
            this.m_anim.getAnimationPanel().setVisible(true);
        }
        super.start();
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void init() {
        super.init();
    }

    public String getFileName() {
        return this.m_fileName;
    }
}

