/*
 * Decompiled with CFR 0.152.
 */
package vgp.surface.rotation;

import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgPolygon;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PuReflect;

public class PgSurfaceOfRotation
extends PgElementSet {
    protected PgPolygon m_meridian;
    protected PdVector m_base;
    protected PdVector m_axis;
    protected PuDouble m_angle;
    protected PuDouble m_angleOffset;
    protected boolean m_bCloseTop;
    protected boolean m_bCloseBottom;
    protected PuInteger m_discr;
    private static /* synthetic */ Class class$vgp$surface$rotation$PgSurfaceOfRotation;

    public boolean isEnabledCloseBottom() {
        return this.m_bCloseBottom;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(super.toString());
        stringBuffer.append("\t ******* PgSurfaceOfRotation *********\n");
        if (this.m_meridian == null) {
            stringBuffer.append("\t m_meridian    = null\n");
        } else {
            stringBuffer.append(this.m_meridian.toString());
        }
        if (this.m_base == null) {
            stringBuffer.append("\t m_base    = null\n");
        } else {
            stringBuffer.append(this.m_base.toString());
        }
        if (this.m_axis == null) {
            stringBuffer.append("\t m_axis    = null\n");
        } else {
            stringBuffer.append(this.m_axis.toString());
        }
        return stringBuffer.toString();
    }

    public PgSurfaceOfRotation() {
        this(3);
    }

    public PgSurfaceOfRotation(int n) {
        super(n);
        this.setTag(7);
        this.m_base = new PdVector(n);
        this.m_axis = new PdVector(n);
        if (n == 3) {
            this.m_axis.set(0.0, 0.0, 1.0);
        } else if (n > 3) {
            this.m_axis.setConstant(1.0);
            this.m_axis.setEntry(0, 0.0);
            this.m_axis.setEntry(1, 0.0);
        }
        this.m_angle = new PuDouble(PsConfig.getMessage((boolean)true, (int)54000, (String)"Total Angle"), (PsUpdateIf)this);
        this.m_angleOffset = new PuDouble(PsConfig.getMessage((boolean)true, (int)54000, (String)"Offset Angle"), (PsUpdateIf)this);
        this.m_discr = new PuInteger(PsConfig.getMessage((boolean)true, (int)54000, (String)"Discretization"), (PsUpdateIf)this);
        if (((Object)((Object)this)).getClass() == (class$vgp$surface$rotation$PgSurfaceOfRotation != null ? class$vgp$surface$rotation$PgSurfaceOfRotation : (class$vgp$surface$rotation$PgSurfaceOfRotation = PgSurfaceOfRotation.class$("vgp.surface.rotation.PgSurfaceOfRotation")))) {
            this.init();
        }
    }

    public void setEnabledCloseTop(boolean bl) {
        this.m_bCloseTop = bl;
    }

    public boolean isEnabledCloseTop() {
        return this.m_bCloseTop;
    }

    public boolean update(Object object) {
        if (object == this.m_meridian) {
            this.computeSurface();
            return super.update((Object)this);
        }
        if (object == this.m_angle || object == this.m_angleOffset || object == this.m_discr) {
            this.computeSurface();
            return super.update((Object)this);
        }
        return super.update(object);
    }

    public PgPolygon getMeridian() {
        return this.m_meridian;
    }

    public boolean setMeridian(PgPolygon pgPolygon) {
        if (this.m_meridian == pgPolygon) {
            return true;
        }
        if (pgPolygon == null) {
            if (this.m_meridian != null) {
                this.m_meridian.removeUpdateListener((PsUpdateIf)this);
                this.m_meridian = null;
            }
            return false;
        }
        this.m_meridian = pgPolygon;
        this.m_meridian.addUpdateListener((PsUpdateIf)this);
        return true;
    }

    public void copy(PsObject psObject) {
        super.copy(psObject);
        if (!(psObject instanceof PgSurfaceOfRotation)) {
            return;
        }
        PgSurfaceOfRotation pgSurfaceOfRotation = (PgSurfaceOfRotation)psObject;
        PgPolygon pgPolygon = pgSurfaceOfRotation.getMeridian();
        if (pgPolygon != null) {
            this.m_meridian.copy((PsObject)pgPolygon);
        } else if (this.m_meridian != null) {
            this.m_meridian.removeUpdateListener((PsUpdateIf)this);
            this.m_meridian = null;
        }
        this.m_base.copy(pgSurfaceOfRotation.m_base);
        this.m_axis.copy(pgSurfaceOfRotation.m_axis);
        this.m_angle.copy(pgSurfaceOfRotation.m_angle);
        this.m_angleOffset.copy(pgSurfaceOfRotation.m_angleOffset);
        this.m_discr.copy(pgSurfaceOfRotation.m_discr);
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void setEnabledCloseBottom(boolean bl) {
        this.m_bCloseBottom = bl;
    }

    public boolean makeVertexTextureFromUV() {
        int n;
        if (((PgPointSet)this).m_numVertices == 0) {
            return true;
        }
        if (this.m_meridian == null) {
            return true;
        }
        int n2 = this.m_meridian.getNumVertices();
        if (((PgPointSet)this).m_numVertices != n2 * (n = this.m_discr.getValue())) {
            PsDebug.warning((String)"Product of u- and v-lines does not match numVertices.");
            return false;
        }
        this.assureVertexTextures();
        PdVector[] pdVectorArray = this.getVertexTextures();
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            double d = (double)n4 / ((double)n2 - 1.0);
            int n5 = 0;
            while (n5 < n) {
                double d2 = (double)n5 / ((double)n - 1.0);
                pdVectorArray[n3].m_data[0] = d;
                pdVectorArray[n3].m_data[1] = d2;
                ++n3;
                ++n5;
            }
            ++n4;
        }
        return true;
    }

    public void init() {
        super.init();
        this.m_base.setConstant(0.0);
        this.m_angle.setDefBounds(0.0, Math.PI * 2, 0.01, 0.1);
        this.m_angle.setDefValue(6.083185307179586);
        this.m_angle.init();
        this.m_angleOffset.setDefBounds(-Math.PI, Math.PI, 0.01, 0.1);
        this.m_angleOffset.setDefValue(0.1);
        this.m_angleOffset.init();
        this.m_discr.setDefBounds(3, 20, 1, 2);
        this.m_discr.setDefValue(8);
        this.m_discr.init();
        this.m_bCloseTop = false;
        this.m_bCloseBottom = false;
    }

    public Object clone() {
        PgSurfaceOfRotation pgSurfaceOfRotation = (PgSurfaceOfRotation)((Object)super.clone());
        if (pgSurfaceOfRotation == null) {
            return null;
        }
        if (this.m_meridian != null) {
            pgSurfaceOfRotation.m_meridian = (PgPolygon)this.m_meridian.clone();
            pgSurfaceOfRotation.m_meridian.addUpdateListener((PsUpdateIf)pgSurfaceOfRotation);
        }
        pgSurfaceOfRotation.m_base = (PdVector)this.m_base.clone();
        pgSurfaceOfRotation.m_axis = (PdVector)this.m_axis.clone();
        pgSurfaceOfRotation.m_angle = (PuDouble)this.m_angle.clone();
        pgSurfaceOfRotation.m_angleOffset = (PuDouble)this.m_angleOffset.clone();
        pgSurfaceOfRotation.m_discr = (PuInteger)this.m_discr.clone();
        return pgSurfaceOfRotation;
    }

    public boolean computeSurface() {
        int n = this.m_meridian.getNumVertices();
        int n2 = this.m_discr.getValue() + 1;
        this.setNumVertices(n * n2);
        PdMatrix pdMatrix = new PdMatrix(4);
        PuReflect.rotateLine((PdMatrix)pdMatrix, (PdVector)this.m_base, (PdVector)this.m_axis, (double)this.m_angleOffset.getValue());
        double d = this.m_angle.getValue() / ((double)n2 - 1.0);
        PdMatrix pdMatrix2 = new PdMatrix(4);
        PuReflect.rotateLine((PdMatrix)pdMatrix2, (PdVector)this.m_base, (PdVector)this.m_axis, (double)d);
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            PdVector pdVector = this.m_meridian.getVertex(n4);
            ((PgPointSet)this).m_vertex[n3].leftMultAffin(pdMatrix, pdVector, true);
            int n5 = 1;
            while (n5 < n2) {
                ((PgPointSet)this).m_vertex[n3 + 1].leftMultAffin(pdMatrix2, ((PgPointSet)this).m_vertex[n3], true);
                ++n3;
                ++n5;
            }
            ++n3;
            ++n4;
        }
        this.setDimOfElements(4);
        this.makeQuadrConn(n, n2);
        this.makeQuadrBnd(n, n2);
        this.makeElementNormals();
        this.makeVertexNormals();
        return true;
    }
}

