/*
 * Decompiled with CFR 0.152.
 */
package vgp.minimal.weier;

import jv.anim.PsAnimation;
import jv.anim.PsTimeEvent;
import jv.anim.PsTimeListenerIf;
import jv.object.PsDebug;
import jv.object.PsUpdateIf;
import jv.project.PgGeometryIf;
import jv.project.PjProject;
import jv.project.PvPickEvent;
import jv.project.PvViewerIf;
import vgp.minimal.weier.PgWeierstrass;
import vgp.minimal.weier.PgWeierstrassDescr;

public class PjWeierstrass
extends PjProject {
    public static final String BASE_SURFACE_NAME = "vgp.minimal.weier.PgWeierstrass_";
    protected PgWeierstrass m_geom;
    public static String[] m_surfaceFileName = new String[]{"Enneper", "KNoid", "KNoid2", "Catenoid", "Scherk", "Costa", "Costa2", "Chen"};
    protected static String[] m_surfaceName = new String[]{"Enneper", "K-noid", "Symmetry group of k-noid", "Catenoid - Helicoid", "Scherk's surface", "Costa's surface", "Costa's surface (closed)", "Chen's surface"};
    protected int m_selectedIndex = 0;
    protected String m_defaultName = m_surfaceName[this.m_selectedIndex];
    private static /* synthetic */ Class class$vgp$minimal$weier$PjWeierstrass;

    public PjWeierstrass() {
        super("PjWeierstrass");
        this.m_geom = new PgWeierstrass(3);
        this.m_geom.setParent((PsUpdateIf)this);
        PsAnimation psAnimation = new PsAnimation();
        psAnimation.addTimeListener((PsTimeListenerIf)this);
        psAnimation.setName("Associate Family");
        this.setAnimation(psAnimation);
        if (((Object)((Object)this)).getClass() == (class$vgp$minimal$weier$PjWeierstrass != null ? class$vgp$minimal$weier$PjWeierstrass : (class$vgp$minimal$weier$PjWeierstrass = PjWeierstrass.class$("vgp.minimal.weier.PjWeierstrass")))) {
            this.init();
        }
    }

    public boolean setTime(PsTimeEvent psTimeEvent) {
        PgWeierstrassDescr pgWeierstrassDescr = this.m_geom.getDescr();
        if (pgWeierstrassDescr != null) {
            double d = psTimeEvent.getTime();
            pgWeierstrassDescr.setConjugationAngle(d / 50.0 * Math.PI);
        }
        return true;
    }

    public boolean setSurfaceName(String string) {
        if (!this.m_geom.setSurfaceName(string, BASE_SURFACE_NAME) && !this.m_geom.setSurfaceName(this.m_defaultName, BASE_SURFACE_NAME)) {
            string = this.m_defaultName;
            PsDebug.warning((String)("PjWeierstrass.setSurfaceName: even could not find classes = " + BASE_SURFACE_NAME + ", " + this.m_defaultName));
            return false;
        }
        int n = 0;
        while (n < m_surfaceFileName.length) {
            if (m_surfaceFileName[n].equals(string)) {
                this.m_selectedIndex = n;
                break;
            }
            ++n;
        }
        PgWeierstrassDescr pgWeierstrassDescr = this.m_geom.getDescr();
        pgWeierstrassDescr.setMarkedBndNr(-1);
        this.m_geom.showMarkedBnd();
        this.m_geom.generateSurface(pgWeierstrassDescr);
        this.m_geom.computeSurface(pgWeierstrassDescr);
        return true;
    }

    public boolean update(Object object) {
        if (object == this) {
            this.m_geom.update((Object)this.m_geom);
            return super.update(object);
        }
        if (object == this.m_geom) {
            return true;
        }
        return super.update(object);
    }

    public void start() {
        PvViewerIf pvViewerIf = this.getViewer();
        if (pvViewerIf != null && pvViewerIf.getParameter("SurfaceName") != null) {
            this.setSurfaceName(pvViewerIf.getParameter("SurfaceName"));
        } else {
            this.setSurfaceName(this.m_defaultName);
        }
        this.m_geom.update((Object)this.m_geom);
        super.start();
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void init() {
        super.init();
        this.addGeometry((PgGeometryIf)this.m_geom);
        this.selectGeometry((PgGeometryIf)this.m_geom);
    }

    public void pickInitial(PvPickEvent pvPickEvent) {
        this.m_geom.markBnd(pvPickEvent.getElementInd());
    }
}

