/*
 * Decompiled with CFR 0.152.
 */
package vgp.minimal.weier;

import jv.number.PuComplex;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.vecmath.PiVector;
import vgp.minimal.weier.PgWeierstrassDescr;

public class PgWeierstrass_Scherk
extends PgWeierstrassDescr {
    protected PuInteger m_numULines = new PuInteger("Number of U-Lines", (PsUpdateIf)this);
    protected PuInteger m_numVLines = new PuInteger("Number of V-Lines", (PsUpdateIf)this);
    protected PuInteger m_symmetry = new PuInteger("Symmetry", (PsUpdateIf)this);
    protected PuDouble m_radius = new PuDouble("Height", (PsUpdateIf)this);
    private static /* synthetic */ Class class$vgp$minimal$weier$PgWeierstrass_Scherk;

    public void getReflections(PiVector piVector) {
        if (this.equals(piVector, 0)) {
            this.reflectPart(1, 0, 3, 0);
            int n = 1;
            while (n < 2 * this.m_symmetry.getValue()) {
                this.reflectPart(2 * n, 2 * n - 1, 0, 1);
                this.reflectPart(2 * n + 1, 2 * n, 3, 0);
                ++n;
            }
        }
        if (piVector == null) {
            this.returnUserReflections();
        }
    }

    public boolean markBnd() {
        return true;
    }

    public PgWeierstrass_Scherk() {
        if (((Object)((Object)this)).getClass() == (class$vgp$minimal$weier$PgWeierstrass_Scherk != null ? class$vgp$minimal$weier$PgWeierstrass_Scherk : (class$vgp$minimal$weier$PgWeierstrass_Scherk = PgWeierstrass_Scherk.class$("vgp.minimal.weier.PgWeierstrass_Scherk")))) {
            this.init();
        }
    }

    public PuComplex g(PiVector piVector, int n, PuComplex puComplex) {
        if (puComplex.abs() != 0.0) {
            return PuComplex.pow((PuComplex)puComplex, (double)((double)this.m_symmetry.getValue() - 1.0));
        }
        return PuComplex.ZERO;
    }

    public void getBndReflectType(PiVector piVector, int n, PiVector piVector2) {
        piVector2.m_data[0] = 1;
        piVector2.m_data[2] = 0;
        piVector2.m_data[3] = 0;
    }

    public int getDimOfElements() {
        return 4;
    }

    public boolean update(Object object) {
        if (object == this.m_numULines) {
            return ((PsObject)this).m_parent.update((Object)this);
        }
        if (object == this.m_numVLines) {
            return ((PsObject)this).m_parent.update((Object)this);
        }
        if (object == this.m_radius) {
            return ((PsObject)this).m_parent.update((Object)this);
        }
        if (object == this.m_symmetry) {
            this.m_numUserReflections = 0;
            this.m_userReflections = null;
            this.m_markedBndNr = -1;
            return ((PsObject)this).m_parent.update((Object)this);
        }
        return super.update(object);
    }

    public double getUMin(PiVector piVector, int n) {
        return 0.0;
    }

    public double getVMin(PiVector piVector, int n) {
        return 0.0;
    }

    public PuComplex f(PiVector piVector, int n, PuComplex puComplex) {
        if (puComplex.abs() != 0.0) {
            return PuComplex.inv((PuComplex)PuComplex.add((PuComplex)PuComplex.pow((PuComplex)puComplex, (double)((double)this.m_symmetry.getValue() * 2.0)), (PuComplex)PuComplex.ONE));
        }
        return PuComplex.ONE;
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public PuComplex transform(int n, PuComplex puComplex) {
        PuComplex puComplex2 = PuComplex.polarToRect((double)(1.0 - puComplex.re), (double)(-puComplex.im));
        PuComplex puComplex3 = PuComplex.sub((PuComplex)puComplex2, (PuComplex)PuComplex.ONE);
        PuComplex puComplex4 = PuComplex.add((PuComplex)PuComplex.ONE, (PuComplex)puComplex2);
        PuComplex puComplex5 = PuComplex.polarToRect((double)Math.pow(PuComplex.div((PuComplex)puComplex3, (PuComplex)puComplex4).abs(), 1.0 / (double)this.m_symmetry.getValue()), (double)(PuComplex.div((PuComplex)puComplex3, (PuComplex)puComplex4).arg() / (double)this.m_symmetry.getValue() - 1.5707963267948966 / (double)this.m_symmetry.getValue()));
        return puComplex5;
    }

    public int getNumULines(PiVector piVector, int n) {
        return this.m_numULines.getValue();
    }

    public int getNumVLines(PiVector piVector, int n) {
        return this.m_numVLines.getValue();
    }

    public void getConnections(PiVector piVector) {
        if (this.equals(piVector, 0)) {
            this.connectPart(4 * this.m_symmetry.getValue() - 1, 0, 0, 0);
        }
    }

    public boolean connectReflection(PiVector piVector, int n) {
        return piVector != null;
    }

    public String getName() {
        return "Scherk Surface";
    }

    public int getNumParts(PiVector piVector) {
        if (this.equals(piVector, 0)) {
            return 4 * this.m_symmetry.getValue();
        }
        return this.m_numUserReflections + 1;
    }

    public void init() {
        this.m_numULines.setDefBounds(3, 65, 1, 10);
        this.m_numULines.setDefValue(5);
        this.m_numULines.init();
        this.addParameter((PsObject)this.m_numULines);
        this.m_numVLines.setDefBounds(3, 65, 1, 10);
        this.m_numVLines.setDefValue(5);
        this.m_numVLines.init();
        this.addParameter((PsObject)this.m_numVLines);
        this.m_symmetry.setDefBounds(2, 10, 1, 5);
        this.m_symmetry.setDefValue(2);
        this.m_symmetry.init();
        this.addParameter((PsObject)this.m_symmetry);
        this.m_radius.setDefBounds(0.8, 0.999, 0.001, 0.01);
        this.m_radius.setDefValue(0.98);
        this.m_radius.init();
        this.addParameter((PsObject)this.m_radius);
        this.m_intDiscr.setDefBounds(1, 100, 1, 10);
        this.m_intDiscr.setDefValue(50);
        this.m_intDiscr.init();
        this.m_conjugation.setDefBounds(0.0, Math.PI * 2, 0.04908738521234052, 0.7853981633974483);
        this.m_conjugation.setDefValue(0.0);
        this.m_conjugation.init();
        this.addParameter((PsObject)this.m_conjugation);
        super.init();
    }

    public boolean partIsSubdivided(PiVector piVector, int n) {
        return piVector == null && n == 0;
    }

    public double getUMax(PiVector piVector, int n) {
        return this.m_radius.getValue();
    }

    public double getVMax(PiVector piVector, int n) {
        return 1.5707963267948966;
    }

    public PuComplex[] getFStart(int n) {
        PuComplex[] puComplexArray = new PuComplex[this.m_vertDim];
        puComplexArray[0] = new PuComplex(0.0, 0.0);
        puComplexArray[1] = new PuComplex(0.0, 0.0);
        puComplexArray[2] = new PuComplex(0.0, 0.0);
        return puComplexArray;
    }
}

