/*
 * Decompiled with CFR 0.152.
 */
package vgp.minimal.weier;

import jv.number.PuComplex;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.vecmath.PiVector;
import vgp.minimal.weier.PgWeierstrassDescr;

public class PgWeierstrass_Enneper
extends PgWeierstrassDescr {
    protected PuInteger m_numULines = new PuInteger("Number of U-lines", (PsUpdateIf)this);
    protected PuInteger m_numVLines = new PuInteger("Number of V-lines", (PsUpdateIf)this);
    protected PuInteger m_symmetry = new PuInteger("Symmetry", (PsUpdateIf)this);
    protected PuDouble m_uMax = new PuDouble("maximal radius", (PsUpdateIf)this);
    private static /* synthetic */ Class class$vgp$minimal$weier$PgWeierstrass_Enneper;

    public void getReflections() {
        int n = 0;
        while (n < 2 * this.m_symmetry.getValue()) {
            this.reflectPart(2 * n + 1, 2 * n, 2, 1);
            this.reflectPart(2 * n + 2, 2 * n + 1, 0, 0);
            ++n;
        }
    }

    public PgWeierstrass_Enneper() {
        if (((Object)((Object)this)).getClass() == (class$vgp$minimal$weier$PgWeierstrass_Enneper != null ? class$vgp$minimal$weier$PgWeierstrass_Enneper : (class$vgp$minimal$weier$PgWeierstrass_Enneper = PgWeierstrass_Enneper.class$("vgp.minimal.weier.PgWeierstrass_Enneper")))) {
            this.init();
        }
    }

    public PuComplex g(PiVector piVector, int n, PuComplex puComplex) {
        if (puComplex.abs() != 0.0) {
            return PuComplex.pow((PuComplex)puComplex, (double)((double)this.m_symmetry.getValue() - 1.0));
        }
        return PuComplex.ZERO;
    }

    public int getDimOfElements() {
        return 4;
    }

    public boolean update(Object object) {
        if (object == this.m_numULines) {
            return ((PsObject)this).m_parent.update((Object)this);
        }
        if (object == this.m_numVLines) {
            return ((PsObject)this).m_parent.update((Object)this);
        }
        if (object == this.m_uMax) {
            return ((PsObject)this).m_parent.update((Object)this);
        }
        if (object == this.m_symmetry) {
            return ((PsObject)this).m_parent.update((Object)this);
        }
        return super.update(object);
    }

    public double getUMin(PiVector piVector, int n) {
        return 0.0;
    }

    public double getVMin(PiVector piVector, int n) {
        return 0.0;
    }

    public PuComplex f(PiVector piVector, int n, PuComplex puComplex) {
        return PuComplex.ONE;
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public PuComplex transform(int n, PuComplex puComplex) {
        return PuComplex.polarToRect((double)puComplex.re, (double)puComplex.im);
    }

    public int getNumULines(PiVector piVector, int n) {
        return this.m_numULines.getValue();
    }

    public int getNumVLines(PiVector piVector, int n) {
        return this.m_numVLines.getValue();
    }

    public void getConnections() {
        this.connectPart(4 * this.m_symmetry.getValue() - 1, 0, 0, 0);
    }

    public String getName() {
        return "Enneper Surface";
    }

    public int getNumParts() {
        return 4 * this.m_symmetry.getValue();
    }

    public void init() {
        this.m_numULines.setDefBounds(3, 33, 1, 10);
        this.m_numULines.setDefValue(9);
        this.m_numULines.init();
        this.addParameter((PsObject)this.m_numULines);
        this.m_numVLines.setDefBounds(3, 9, 1, 5);
        this.m_numVLines.setDefValue(4);
        this.m_numVLines.init();
        this.addParameter((PsObject)this.m_numVLines);
        this.m_uMax.setDefBounds(0.0, 5.0, 0.1, 1.0);
        this.m_uMax.setDefValue(1.0);
        this.m_uMax.init();
        this.addParameter((PsObject)this.m_uMax);
        this.m_symmetry.setDefBounds(2, 10, 1, 5);
        this.m_symmetry.setDefValue(2);
        this.m_symmetry.init();
        this.addParameter((PsObject)this.m_symmetry);
        this.m_intDiscr.setDefBounds(1, 100, 1, 10);
        this.m_intDiscr.setDefValue(10);
        this.m_intDiscr.init();
        this.m_conjugation.setDefBounds(0.0, Math.PI * 2, 0.04908738521234052, 0.7853981633974483);
        this.m_conjugation.setDefValue(0.0);
        this.m_conjugation.init();
        this.addParameter((PsObject)this.m_conjugation);
        super.init();
    }

    public double getUMax(PiVector piVector, int n) {
        return this.m_uMax.getValue();
    }

    public double getVMax(PiVector piVector, int n) {
        return Math.PI / ((double)this.m_symmetry.getValue() * 2.0);
    }
}

