/*
 * Decompiled with CFR 0.152.
 */
package vgp.discrete.catenoid;

import java.awt.Component;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgVectorField;
import jv.object.PsConfig;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.project.PgGeometryIf;
import jv.project.PjProject;
import jv.project.PvDisplayIf;
import jv.project.PvPickListenerIf;
import jv.project.PvViewerIf;
import jv.vecmath.PdVector;
import jvx.numeric.PnAreaEnergy;
import jvx.numeric.PnEnergy;
import jvx.numeric.PnEnergyMinimizer;
import vgp.discrete.catenoid.PgCatenoid;
import vgp.discrete.harmonic.PgSurfacePair;

public class PjCatenoid
extends PjProject {
    protected PgElementSet m_square;
    protected PgCatenoid m_geom = new PgCatenoid();
    protected PgCatenoid m_surface;
    protected PgSurfacePair m_pair;
    protected PnEnergyMinimizer m_diri;
    protected PvDisplayIf m_dispSquare;
    private static /* synthetic */ Class class$vgp$discrete$catenoid$PjCatenoid;

    public PjCatenoid() {
        super("PjCatenoid");
        this.m_geom.setName("Discrete Catenoid Domain");
        this.m_geom.setDimOfElements(3);
        this.m_geom.computeSurface(5, 5);
        this.m_geom.addUpdateListener((PsUpdateIf)this);
        PgElementSet.triangulate((PgElementSet)this.m_geom);
        this.m_surface = new PgCatenoid();
        this.m_surface.setName("Discrete Catenoid Surface");
        this.m_surface.copy((PsObject)this.m_geom);
        this.m_pair = new PgSurfacePair(3, 3);
        this.m_pair.setSurface(this.m_geom, 0);
        this.m_pair.setSurface(this.m_surface, 1);
        this.m_pair.setName("Harmonic Map");
        this.m_pair.setParent((PsUpdateIf)this);
        this.m_diri = new PnEnergyMinimizer();
        this.m_diri.setParent((PsUpdateIf)this);
        this.m_diri.setSurface(this.m_pair.getSurface(0), this.m_pair.getSurface(1));
        this.m_diri.setEnergy((PnEnergy)new PnAreaEnergy());
        if (((Object)((Object)this)).getClass() == (class$vgp$discrete$catenoid$PjCatenoid != null ? class$vgp$discrete$catenoid$PjCatenoid : (class$vgp$discrete$catenoid$PjCatenoid = PjCatenoid.class$("vgp.discrete.catenoid.PjCatenoid")))) {
            this.init();
        }
    }

    public boolean update(Object object) {
        if (object == null) {
            return super.update(null);
        }
        if (object == this.m_pair) {
            PgGeometryIf pgGeometryIf = this.getGeometry();
            if (pgGeometryIf != null && pgGeometryIf != this.m_pair.getActiveSurface()) {
                this.removeGeometry(pgGeometryIf);
                this.addGeometry((PgGeometryIf)this.m_pair.getActiveSurface());
                this.selectGeometry((PgGeometryIf)this.m_pair.getActiveSurface());
            }
            this.m_diri.setSurface(this.m_pair.getSurface(0), this.m_pair.getSurface(1));
            PgVectorField pgVectorField = this.m_surface.getVectorField(PsConfig.getMessage((int)45053));
            if (pgVectorField != null && this.m_square != null) {
                this.m_geom.makeVertexNormals();
                PgVectorField pgVectorField2 = this.m_square.getVectorField("Normal component of EV");
                if (pgVectorField2 == null) {
                    pgVectorField2 = new PgVectorField(3);
                    pgVectorField2.setName("Normal component of EV");
                    this.m_square.addVectorField(pgVectorField2);
                    pgVectorField2.setGeometry((PgPointSet)this.m_square);
                }
                int n = pgVectorField.getNumVectors();
                pgVectorField2.setNumVectors(n);
                PdVector[] pdVectorArray = this.m_geom.getVertexNormals();
                int n2 = 0;
                while (n2 < n) {
                    PdVector pdVector = pgVectorField.getVector(n2);
                    PdVector pdVector2 = pgVectorField2.getVector(n2);
                    double d = PdVector.dot((PdVector)pdVectorArray[n2], (PdVector)pdVector);
                    pdVector2.set(0.0, 0.0, d);
                    ++n2;
                }
                this.m_square.update((Object)this.m_square);
            }
            super.update(null);
            return true;
        }
        if (object == this.m_diri) {
            PgElementSet pgElementSet = this.m_diri.getSurface();
            pgElementSet.update((Object)pgElementSet);
            return true;
        }
        if (object == this.m_geom) {
            this.m_surface.copy((PsObject)this.m_geom);
            this.m_pair.setSurface(this.m_surface, 1);
            this.m_surface.update((Object)this.m_surface);
            if (this.m_square != null) {
                this.m_square.computePlane(this.m_geom.getWaistDiscr(), this.m_geom.getProfileDiscr(), 0.0, 0.0, Math.PI, Math.PI);
                PgVectorField pgVectorField = this.m_square.getVectorField("Normal component of EV");
                if (pgVectorField != null) {
                    this.m_square.removeVectorField((PgGeometryIf)pgVectorField);
                }
                this.m_square.update((Object)this.m_square);
            }
            return true;
        }
        return super.update(object);
    }

    public void start() {
        this.addGeometry((PgGeometryIf)this.m_pair.getActiveSurface());
        this.selectGeometry((PgGeometryIf)this.m_pair.getActiveSurface());
        super.start();
    }

    public void showSquare(boolean bl) {
        if (this.m_dispSquare != null && this.m_dispSquare.getFrame() != null) {
            ((Component)this.m_dispSquare.getFrame()).setVisible(bl);
            return;
        }
        if (!bl) {
            return;
        }
        this.m_square = new PgElementSet(3);
        this.m_square.computePlane(this.m_geom.getWaistDiscr(), this.m_geom.getProfileDiscr(), 0.0, 0.0, Math.PI, Math.PI);
        PvViewerIf pvViewerIf = this.getViewer();
        this.m_dispSquare = pvViewerIf.newDisplay("Display Square", true);
        this.m_dispSquare.addPickListener((PvPickListenerIf)this);
        this.m_dispSquare.addGeometry((PgGeometryIf)this.m_square);
        this.m_dispSquare.selectCamera(0);
        this.addDisplay(this.m_dispSquare);
        ((Component)this.m_dispSquare.getFrame()).setVisible(bl);
        this.fitDisplays();
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void init() {
        super.init();
    }
}

