/*
 * Decompiled with CFR 0.152.
 */
package vgp.curve.subdivision;

import java.awt.Button;
import java.awt.Color;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgPolygon;
import jv.number.PuInteger;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.project.PjProject;
import jv.project.PvDisplayIf;
import jv.project.PvGeometryListenerIf;
import jv.project.PvPickEvent;
import jv.vecmath.PdBary;
import jv.vecmath.PdBaryDir;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.geom.PgPolygonOnElementSet;
import jvx.geom.PgTube;
import jvx.geom.PgVertexStar;
import jvx.geom.PwBary;
import jvx.geom.PwGeodesic;

public class PjSubdivisionCurve
extends PjProject {
    protected PgPolygonOnElementSet m_subdivcurve = new PgPolygonOnElementSet(null);
    protected PgPolygon m_subdivcurveGeom = new PgPolygon(3);
    protected PgPolygon m_origcurve;
    protected PgPointSet m_refpointGeom;
    protected PdVector[] m_refpointPoints;
    protected PiVector m_refpointElem;
    protected PdBary[] m_refpointBary;
    protected PuInteger m_numPoints;
    protected PuInteger m_depth;
    protected PgElementSet m_geometry;
    protected GeomListener m_geomlistener;
    protected boolean m_bUpdateSender = false;
    protected Button m_useGivenReferencePoints = null;
    protected boolean m_bReuseTriangleRuns = true;
    private static /* synthetic */ Class class$vgp$curve$subdivision$PjSubdivisionCurve;
    private static /* synthetic */ Class class$jv$geom$PgPointSet;

    public void setReuseTriangleRunsWhileIterating(boolean bl) {
        this.m_bReuseTriangleRuns = bl;
    }

    public PjSubdivisionCurve() {
        super("Subdivision Curves");
        this.m_subdivcurveGeom.setName("subdivision curve");
        this.m_origcurve = new PgPolygon(3);
        this.m_origcurve.setName("original geodesic polygon");
        this.m_refpointGeom = new PgPointSet(3);
        this.m_refpointGeom.setName("reference points of sdc");
        this.m_refpointGeom.addUpdateListener((PsUpdateIf)this);
        this.m_refpointElem = new PiVector(0);
        this.m_refpointBary = new PdBary[0];
        this.m_depth = new PuInteger("depth", (PsUpdateIf)this);
        this.m_numPoints = new PuInteger("#points", (PsUpdateIf)this);
        this.m_useGivenReferencePoints = new Button("Use selected geometry for reference points");
        this.m_geomlistener = new GeomListener(this);
        if (((Object)((Object)this)).getClass() == (class$vgp$curve$subdivision$PjSubdivisionCurve != null ? class$vgp$curve$subdivision$PjSubdivisionCurve : (class$vgp$curve$subdivision$PjSubdivisionCurve = PjSubdivisionCurve.class$("vgp.curve.subdivision.PjSubdivisionCurve")))) {
            this.init();
        }
    }

    public boolean getReuseTriangleRunsWhileIterating() {
        return this.m_bReuseTriangleRuns;
    }

    private static void addDirToBary(PdBary pdBary, PdBaryDir pdBaryDir, PdBary pdBary2) {
        int n = pdBary.getSize();
        int n2 = 0;
        while (n2 < n) {
            pdBary2.m_data[n2] = pdBary.m_data[n2] + pdBaryDir.m_data[n2];
            ++n2;
        }
    }

    private void computeCurve() {
        PjSubdivisionCurve.computeSubdivisionCurve(this.m_geometry, this.m_refpointElem, this.m_refpointBary, this.m_depth.getValue(), this.m_subdivcurve, this.m_subdivcurveGeom, this.m_bReuseTriangleRuns);
    }

    protected void makeDefaultRefPoints() {
        int n;
        int n2 = this.m_numPoints.getValue();
        int n3 = this.m_geometry.getNumElements();
        if (n3 == 0) {
            return;
        }
        if (n3 < n2) {
            this.m_refpointBary = new PdBary[2];
            this.m_refpointElem.setSize(2);
            n = 0;
            do {
                this.m_refpointBary[n] = new PdBary(3);
                this.m_refpointBary[n].copy(PdBary.TRIANGLE_VERTEX[n]);
                this.m_refpointElem.m_data[n] = 0;
            } while (++n < 2);
        } else {
            this.m_refpointBary = new PdBary[n2];
            this.m_refpointElem.setSize(n2);
            n = 0;
            while (n < n2) {
                int n4;
                boolean bl;
                block2: do {
                    n4 = (int)(Math.random() * (double)n3);
                    bl = false;
                    int n5 = 0;
                    while (n5 < n) {
                        if (this.m_refpointElem.m_data[n5] == n4) {
                            bl = true;
                            continue block2;
                        }
                        ++n5;
                    }
                } while (bl);
                this.m_refpointBary[n] = new PdBary(3);
                this.m_refpointBary[n].copy(PdBary.TRIANGLE_MID);
                this.m_refpointElem.m_data[n] = n4;
                ++n;
            }
        }
        n = this.m_geometry.getDimOfVertices();
        PdVector[] pdVectorArray = this.m_geometry.getVertices();
        PiVector[] piVectorArray = this.m_geometry.getElements();
        this.m_refpointGeom.setNumVertices(n2);
        PdVector pdVector = new PdVector(n);
        PdVector pdVector2 = new PdVector(n);
        int n6 = 0;
        while (n6 < n2) {
            pdVector.setConstant(0.0);
            int n7 = 0;
            do {
                pdVector2.copyArray(pdVectorArray[piVectorArray[this.m_refpointElem.m_data[n6]].m_data[n7]]);
                pdVector2.multScalar(this.m_refpointBary[n6].m_data[n7]);
                pdVector.add(pdVector2);
                this.m_refpointGeom.setVertex(n6, pdVector);
            } while (++n7 < 3);
            ++n6;
        }
        if (this.m_refpointPoints == null || this.m_refpointPoints.length != n2) {
            this.m_refpointPoints = PdVector.realloc((PdVector[])this.m_refpointPoints, (int)n2, (int)n);
        }
        n6 = 0;
        while (n6 < n2) {
            this.m_refpointPoints[n6].setSize(n);
            this.m_refpointPoints[n6].copy(this.m_refpointGeom.getVertex(n6));
            ++n6;
        }
        this.makeOrigCurve();
    }

    /*
     * Unable to fully structure code
     */
    private static void subdivideEdge(PgPolygonOnElementSet var0, PgPolygon var1_1, double var2_2, double var4_3, PdBary[] var6_4, PiVector var7_5, int var8_6, int var9_7, PiVector var10_8) {
        var0.getPolygon(var1_1);
        var11_9 = var1_1.getLength();
        var13_10 = var1_1.getVertices();
        var14_11 = new PdVector(var1_1.getDimOfVertices());
        var15_12 = new PdBaryDir(3);
        var16_13 = new double[]{var11_9 * var2_2, var11_9 * var4_3};
        var17_14 = new int[]{var8_6, var9_7};
        var18_15 = 0.0;
        var20_16 = 1.0;
        var22_17 = 0;
        var23_18 = 0;
        var24_19 = 0;
        var25_20 = new PdBary(3);
        var26_21 = new PdBary(3);
        ** GOTO lbl37
        {
            var14_11.sub(var13_10[++var22_17], var13_10[var22_17 - 1]);
            var20_16 = var14_11.length();
            var18_15 += var20_16;
            do {
                if (var18_15 < var16_13[var23_18]) continue block0;
                var27_22 = (var16_13[var23_18] - (var18_15 - var20_16)) / var20_16;
                var29_23 = var0.getElemInd(var22_17);
                var30_24 = var0.getElemInd(var22_17 - 1);
                var25_20.copy(var0.getBary(var22_17));
                var26_21.copy(var0.getBary(var22_17 - 1));
                var24_19 = PjSubdivisionCurve.equalizeElementIndex(var0, var22_17 - 1, var22_17, var10_8, var24_19);
                var15_12.sub(var0.getBary(var22_17), var0.getBary(var22_17 - 1));
                var15_12.multScalar(var27_22);
                PjSubdivisionCurve.addDirToBary(var0.getBary(var22_17 - 1), var15_12, var6_4[var17_14[var23_18]]);
                var7_5.m_data[var17_14[var23_18]] = var0.getElemInd(var22_17);
                var0.setVertex(var22_17, var29_23, var25_20);
                var0.setVertex(var22_17 - 1, var30_24, var26_21);
                --var22_17;
                var18_15 -= var20_16;
                ++var23_18;
lbl37:
                // 2 sources

            } while (var23_18 < 2);
        }
    }

    void useGivenReferencePoints() {
        PgGeometryIf pgGeometryIf = this.getSelectedGeometry();
        if (pgGeometryIf.getClass() != (class$jv$geom$PgPointSet != null ? class$jv$geom$PgPointSet : (class$jv$geom$PgPointSet = PjSubdivisionCurve.class$("jv.geom.PgPointSet")))) {
            return;
        }
        PgPointSet pgPointSet = (PgPointSet)pgGeometryIf;
        int n = pgPointSet.getNumVertices();
        int n2 = pgPointSet.getDimOfVertices();
        this.m_refpointPoints = new PdVector[n];
        this.m_refpointBary = new PdBary[n];
        int n3 = 0;
        while (n3 < n) {
            this.m_refpointPoints[n3] = new PdVector(n2);
            this.m_refpointBary[n3] = new PdBary(3);
            this.m_refpointBary[n3].copy(PdBary.TRIANGLE_MID);
            ++n3;
        }
        this.m_refpointElem.setSize(n);
        this.m_refpointGeom.copy((PsObject)pgPointSet);
        this.projectRefpointsToGeom();
        this.makeOrigCurve();
    }

    private void projectRefpointsToGeom() {
        int n;
        int n2 = this.m_refpointGeom.getNumVertices();
        if (n2 != (n = this.m_refpointPoints.length)) {
            this.m_refpointGeom.setNumVertices(n);
            int n3 = 0;
            while (n3 < n) {
                this.m_refpointGeom.setVertex(n3, this.m_refpointPoints[n3]);
                ++n3;
            }
            return;
        }
        PdVector pdVector = this.getDisplay().getCamera().getViewDir();
        PdVector pdVector2 = new PdVector(this.m_geometry.getDimOfVertices());
        PdVector[] pdVectorArray = this.m_geometry.getVertices();
        PiVector[] piVectorArray = this.m_geometry.getElements();
        int n4 = 0;
        while (n4 < n2) {
            if (this.m_refpointPoints[n4] == null || PdVector.sqrDist((PdVector)this.m_refpointGeom.getVertex(n4), (PdVector)this.m_refpointPoints[n4]) > 1.0E-10) {
                PvPickEvent pvPickEvent = this.m_geometry.intersectionWithLine(this.m_refpointGeom.getVertex(n4), pdVector);
                if (pvPickEvent != null) {
                    this.m_refpointElem.m_data[n4] = pvPickEvent.getElementInd();
                    this.m_refpointBary[n4].copy(pvPickEvent.getBary());
                }
                PdBary.getVertex((PdVector)pdVector2, (PdBary)this.m_refpointBary[n4], (PdVector)pdVectorArray[piVectorArray[this.m_refpointElem.m_data[n4]].m_data[0]], (PdVector)pdVectorArray[piVectorArray[this.m_refpointElem.m_data[n4]].m_data[1]], (PdVector)pdVectorArray[piVectorArray[this.m_refpointElem.m_data[n4]].m_data[2]]);
                this.m_refpointGeom.setVertex(n4, pdVector2);
                this.m_refpointPoints[n4].copy(pdVector2);
            }
            ++n4;
        }
    }

    public boolean update(Object object) {
        if (object == null) {
            return super.update(null);
        }
        if (object == this) {
            if (this.m_geometry != null) {
                this.m_bUpdateSender = true;
                this.computeCurve();
                this.m_subdivcurveGeom.update(null);
                this.m_refpointGeom.update(null);
                this.m_origcurve.update(null);
                this.m_bUpdateSender = false;
            }
        } else {
            if (object == this.m_geometry) {
                return super.update(null);
            }
            if (object == this.m_numPoints) {
                this.makeDefaultRefPoints();
                this.update((Object)this);
                return true;
            }
            if (object == this.m_depth) {
                if (this.m_geometry != null) {
                    this.m_bUpdateSender = true;
                    this.computeCurve();
                    this.m_subdivcurveGeom.update(null);
                    this.m_refpointGeom.update(null);
                    this.m_origcurve.update(null);
                    this.m_bUpdateSender = false;
                }
                return super.update(null);
            }
            if (object == this.m_subdivcurveGeom) {
                return super.update(null);
            }
            if (object == this.m_refpointGeom) {
                if (this.m_geometry != null && !this.m_bUpdateSender) {
                    this.m_bUpdateSender = true;
                    this.projectRefpointsToGeom();
                    this.makeOrigCurve();
                    this.computeCurve();
                    this.m_subdivcurveGeom.update(null);
                    this.m_refpointGeom.update(null);
                    this.m_origcurve.update(null);
                    this.m_bUpdateSender = false;
                }
                return super.update(null);
            }
            if (object == this.m_origcurve) {
                return super.update(null);
            }
        }
        return super.update(object);
    }

    public void setGeometry(PgGeometry pgGeometry) {
        PgElementSet pgElementSet;
        if (pgGeometry == this.m_geometry) {
            return;
        }
        if (!(pgGeometry instanceof PgElementSet)) {
            return;
        }
        if (this.m_geometry != null) {
            this.removeGeometry((PgGeometryIf)this.m_geometry);
        }
        if ((pgElementSet = (PgElementSet)pgGeometry).getDimOfElements() != 3 || pgElementSet.getNumElements() < 1) {
            PsDebug.warning((String)("rejecting " + pgGeometry.getName() + "; you have to triangulate and then select it again"));
            return;
        }
        this.m_geometry = pgElementSet;
        int n = this.m_geometry.getDimOfVertices();
        this.m_subdivcurveGeom.setDimOfVertices(n);
        this.m_refpointGeom.setDimOfVertices(n);
        this.m_subdivcurve.setGeometry(this.m_geometry);
        this.m_geometry.addUpdateListener((PsUpdateIf)this);
        this.makeDefaultRefPoints();
    }

    public PgGeometryIf getGeometry() {
        return this.m_geometry;
    }

    private static int equalizeElementIndex(PgPolygonOnElementSet pgPolygonOnElementSet, int n, int n2, PiVector piVector, int n3) {
        int n4;
        int n5;
        PgElementSet pgElementSet = pgPolygonOnElementSet.getGeometry();
        PiVector[] piVectorArray = pgElementSet.getElements();
        PiVector[] piVectorArray2 = pgElementSet.getNeighbours();
        int[] nArray = n <= n2 ? new int[]{n, n2} : new int[]{n2, n};
        PiVector[] piVectorArray3 = new PiVector[2];
        PgVertexStar[] pgVertexStarArray = new PgVertexStar[2];
        int[] nArray2 = new int[]{-1, -1};
        int n6 = 0;
        do {
            piVectorArray3[n6] = new PiVector();
            int n7 = pgPolygonOnElementSet.getElemInd(nArray[n6]);
            PdBary pdBary = pgPolygonOnElementSet.getBary(nArray[n6]);
            int n8 = PwBary.liesOnVertex((PdBary)pdBary);
            if (n8 >= 0) {
                pgVertexStarArray[n6] = new PgVertexStar();
                pgVertexStarArray[n6].makeVertexStar(pgElementSet, piVectorArray[n7].m_data[n8], n7);
                piVectorArray3[n6].setSize(pgVertexStarArray[n6].getSize());
                piVectorArray3[n6].copyArray(pgVertexStarArray[n6].getElement());
                continue;
            }
            nArray2[n6] = PwBary.getEdgeIndex((PdBary)pdBary);
            if (nArray2[n6] != -1) {
                piVectorArray3[n6].setSize(2);
                piVectorArray3[n6].m_data[0] = n7;
                piVectorArray3[n6].m_data[1] = piVectorArray2[n7].m_data[nArray2[n6]];
                continue;
            }
            piVectorArray3[n6].setSize(1);
            piVectorArray3[n6].m_data[0] = n7;
        } while (++n6 < 2);
        int[] nArray3 = new int[]{-1, -1};
        int n9 = -1;
        int n10 = piVectorArray3[0].getSize();
        int n11 = piVectorArray3[1].getSize();
        if (piVector == null || pgVertexStarArray[0] == null || pgVertexStarArray[1] == null) {
            n5 = 0;
            while (n5 < n10) {
                n4 = 0;
                while (n4 < n11) {
                    if (piVectorArray3[0].m_data[n5] == piVectorArray3[1].m_data[n4]) {
                        nArray3[0] = n5;
                        nArray3[1] = n4;
                        n9 = piVectorArray3[0].m_data[n5];
                        break;
                    }
                    ++n4;
                }
                ++n5;
            }
        } else {
            int n12;
            n5 = 0;
            n4 = 0;
            while (n4 == 0 && n3 < piVector.getSize()) {
                if (n5 == 0) {
                    n12 = 0;
                    while (n12 < n10) {
                        if (piVector.m_data[n3] == piVectorArray3[0].m_data[n12]) {
                            n5 = 1;
                            nArray3[0] = n12;
                            break;
                        }
                        ++n12;
                    }
                } else {
                    n5 = 0;
                    n12 = 0;
                    while (n12 < n10) {
                        if (piVector.m_data[n3] == piVectorArray3[0].m_data[n12]) {
                            n5 = 1;
                            nArray3[0] = n12;
                            break;
                        }
                        ++n12;
                    }
                    if (n5 == 0) {
                        n4 = 1;
                    }
                }
                ++n3;
            }
            n3 = n3 >= piVector.getSize() ? --n3 : (n3 -= 2);
            n9 = piVector.m_data[n3];
            n12 = 0;
            while (n12 < n11) {
                if (n9 == piVectorArray3[1].m_data[n12]) {
                    nArray3[1] = n12;
                    break;
                }
                ++n12;
            }
        }
        if (n9 < 0) {
            return -1;
        }
        n5 = 0;
        do {
            if (nArray3[n5] == 0) continue;
            if (pgVertexStarArray[n5] != null) {
                pgPolygonOnElementSet.setVertex(nArray[n5], n9, PdBary.TRIANGLE_VERTEX[pgVertexStarArray[n5].getVertexLocInd().getEntry(nArray3[n5])]);
                continue;
            }
            PjSubdivisionCurve.changeBarycentricOnEdge(pgPolygonOnElementSet.getBary(nArray[n5]), nArray2[n5], pgElementSet.getOppVertexLocInd(pgPolygonOnElementSet.getElemInd(nArray[n5]), nArray2[n5]));
            pgPolygonOnElementSet.setVertex(nArray[n5], n9, pgPolygonOnElementSet.getBary(nArray[n5]));
        } while (++n5 < 2);
        return n3;
    }

    public void start() {
        this.addGeometry((PgGeometryIf)this.m_subdivcurveGeom);
        this.addGeometry((PgGeometryIf)this.m_refpointGeom);
        this.addGeometry((PgGeometryIf)this.m_origcurve);
        PgElementSet pgElementSet = new PgElementSet(3);
        pgElementSet.setName("Torus");
        pgElementSet.computeTorus(30, 30, 2.0, 1.0);
        PgElementSet.triangulate((PgElementSet)pgElementSet);
        pgElementSet.makeElementNormals();
        pgElementSet.makeVertexNormals();
        pgElementSet.setGlobalElementColor(Color.lightGray);
        pgElementSet.close();
        if (this.getDisplay() != null) {
            this.getDisplay().addGeometryListener((PvGeometryListenerIf)this.m_geomlistener);
            this.m_geomlistener.setDisplay(this.getDisplay());
            this.getDisplay().getCamera().setFieldOfView(0.0);
            this.getDisplay().setEnabled3DLook(true);
        }
        this.addGeometry((PgGeometryIf)pgElementSet);
        this.selectGeometry((PgGeometryIf)this.m_refpointGeom);
        super.start();
    }

    private void makeOrigCurve() {
        this.m_subdivcurveGeom.setNumVertices(0);
        PjSubdivisionCurve.computeSubdivisionCurve(this.m_geometry, this.m_refpointElem, this.m_refpointBary, 0, new PgPolygonOnElementSet(this.m_geometry), this.m_origcurve, this.m_bReuseTriangleRuns);
        int n = this.m_origcurve.getNumVertices();
        PdVector[] pdVectorArray = this.m_origcurve.getVertices();
        int n2 = 0;
        while (n2 < n) {
            pdVectorArray[n2].clearTag(1);
            ++n2;
        }
    }

    public static PgPolygonOnElementSet computeSubdivisionCurve(PgElementSet pgElementSet, PiVector piVector, PdBary[] pdBaryArray, int n, PgPolygonOnElementSet pgPolygonOnElementSet, PgPolygon pgPolygon, boolean bl) {
        int n2;
        int n3;
        if (piVector.getSize() < 2) {
            return null;
        }
        if (pgPolygonOnElementSet == null) {
            pgPolygonOnElementSet = new PgPolygonOnElementSet(pgElementSet);
        } else {
            pgPolygonOnElementSet.setGeometry(pgElementSet);
        }
        if (pgPolygon == null) {
            pgPolygon = new PgPolygon(pgElementSet.getDimOfVertices());
        }
        double d = 0.25;
        double d2 = 0.75;
        PiVector[] piVectorArray = pgElementSet.getElements();
        int n4 = piVector.getSize();
        PiVector piVector2 = new PiVector();
        PgPolygonOnElementSet pgPolygonOnElementSet2 = null;
        int n5 = n4;
        int n6 = 0;
        while (n6 < n) {
            n5 = 2 * n5 - 2;
            ++n6;
        }
        int[][] nArrayArray = null;
        if (bl) {
            nArrayArray = new int[n5 - 1][];
            int n7 = 0;
            while (n7 < n4 - 1) {
                nArrayArray[n7] = PwGeodesic.getConnectingStrip((PgElementSet)pgElementSet, (int)piVector.m_data[n7], (int)piVector.m_data[n7 + 1]);
                if (nArrayArray[n7] == null || nArrayArray[n7].length < 1) {
                    PsDebug.warning((String)"could not connect reference points");
                    return null;
                }
                ++n7;
            }
        }
        int[] nArray = new int[]{};
        PiVector piVector3 = new PiVector(n5);
        PdBary[] pdBaryArray2 = new PdBary[n5];
        int n8 = 0;
        while (n8 < n4) {
            piVector3.m_data[n8] = piVector.m_data[n8];
            pdBaryArray2[n8] = new PdBary(3);
            pdBaryArray2[n8].copy(pdBaryArray[n8]);
            ++n8;
        }
        n8 = n4;
        while (n8 < n5) {
            pdBaryArray2[n8] = new PdBary(3);
            ++n8;
        }
        PdBary pdBary = new PdBary(3);
        PdBary pdBary2 = new PdBary(3);
        PgVertexStar pgVertexStar = new PgVertexStar();
        while (n4 < n5) {
            pdBaryArray2[2 * n4 - 2 - 1].copy(pdBaryArray2[n4 - 1]);
            piVector3.m_data[2 * n4 - 2 - 1] = piVector3.m_data[n4 - 1];
            n3 = (n4 - 2) * 2;
            n2 = n4 - 2;
            while (n2 >= 1) {
                pdBaryArray2[n3].copy(pdBaryArray2[n2]);
                piVector3.m_data[n3] = piVector3.m_data[n2];
                n3 -= 2;
                --n2;
            }
            n2 = 0;
            int n9 = piVector3.m_data[0];
            pdBary.copy(pdBaryArray2[0]);
            int n10 = 1;
            while (n10 < n4) {
                int n11 = n10 < n4 - 1 ? n2 + 2 : n2 + 1;
                if (bl) {
                    piVector2.setSize(nArrayArray[n10 - 1].length);
                    pdBary2.copy(pdBaryArray2[n11]);
                    System.arraycopy(nArrayArray[n10 - 1], 0, piVector2.m_data, 0, nArrayArray[n10 - 1].length);
                    pgPolygonOnElementSet2 = PwGeodesic.getShortest((PgElementSet)pgElementSet, (PdBary)pdBary, (int)n9, (PdBary)pdBaryArray2[n11], (int)piVector3.m_data[n11], (PiVector)piVector2, (PgPolygonOnElementSet)pgPolygonOnElementSet2);
                    n9 = piVector3.m_data[n11];
                    piVector3.m_data[n11] = piVector2.getLastEntry();
                    pdBary.copy(pdBary2);
                    if (nArrayArray[n10 - 1].length != piVector2.getSize()) {
                        nArrayArray[n10 - 1] = new int[piVector2.getSize()];
                    }
                    System.arraycopy(piVector2.m_data, 0, nArrayArray[n10 - 1], 0, nArrayArray[n10 - 1].length);
                } else {
                    piVector2.setSize(0);
                    pgPolygonOnElementSet2 = PwGeodesic.getShortest((PgElementSet)pgElementSet, (PdBary)pdBaryArray2[n2], (int)piVector3.m_data[n2], (PdBary)pdBaryArray2[n11], (int)piVector3.m_data[n11], (PiVector)piVector2, pgPolygonOnElementSet2);
                }
                PjSubdivisionCurve.subdivideEdge(pgPolygonOnElementSet2, pgPolygon, d, d2, pdBaryArray2, piVector3, n2, n2 + 1, piVector2);
                n2 += 2;
                ++n10;
            }
            if (bl) {
                n3 = (n4 - 2) * 2;
                n10 = n4 - 2;
                while (n10 >= 1) {
                    nArrayArray[n3] = nArrayArray[n10];
                    n3 -= 2;
                    --n10;
                }
                n3 = 0;
                while (nArrayArray[0][n3] != piVector3.m_data[0]) {
                    ++n3;
                }
                n10 = 0;
                while (n10 < n4 - 1) {
                    int n12 = 2 * n10;
                    int n13 = 0;
                    do {
                        if (nArray.length < n13 + 1) {
                            int[] nArray2 = nArray;
                            nArray = new int[n13 + 11];
                            System.arraycopy(nArray2, 0, nArray, 0, nArray2.length);
                        }
                        if (n13 >= nArray.length || n12 >= nArrayArray.length || n3 >= nArrayArray[n12].length) {
                            PsDebug.error((String)"computation error, aborting");
                            return null;
                        }
                        nArray[n13] = nArrayArray[n12][n3];
                        ++n3;
                    } while (nArray[++n13 - 1] != piVector3.m_data[n12 + 1]);
                    if (n10 < n4 - 2) {
                        nArrayArray[n12 + 1] = nArrayArray[n12];
                    }
                    nArrayArray[n12] = new int[n13];
                    System.arraycopy(nArray, 0, nArrayArray[n12], 0, n13);
                    if (n10 < n4 - 2) {
                        n13 = nArrayArray[n12 + 1].length - (n3 - 1);
                        if (nArray.length < n13) {
                            nArray = new int[n13 + 11];
                        }
                        System.arraycopy(nArrayArray[n12 + 1], n3 - 1, nArray, 0, n13);
                        --n13;
                        int n14 = nArrayArray[n12 + 1][nArrayArray[n12 + 1].length - 1];
                        int n15 = nArrayArray[n12 + 2][0];
                        if (n14 != n15) {
                            int n16 = -1;
                            int n17 = 0;
                            block11: do {
                                int n18 = 0;
                                do {
                                    if (piVectorArray[n14].m_data[n17] != piVectorArray[n15].m_data[n18]) continue;
                                    n16 = piVectorArray[n14].m_data[n17];
                                    n17 = 2;
                                    continue block11;
                                } while (++n18 < 3);
                            } while (++n17 < 3);
                            if (n16 < 0) {
                                PsDebug.error((String)"strips are not connected");
                                return null;
                            }
                            pgVertexStar.makeVertexStar(pgElementSet, n16, n14);
                            n17 = pgVertexStar.getFirstElemInd();
                            PiVector piVector4 = pgVertexStar.getElement();
                            int n19 = pgVertexStar.getSize();
                            while (piVector4.m_data[n17] != n15) {
                                if (nArray.length < n13 + 2) {
                                    int[] nArray3 = nArray;
                                    nArray = new int[n13 + 11];
                                    System.arraycopy(nArray3, 0, nArray, 0, nArray3.length);
                                }
                                nArray[n13] = piVector4.m_data[n17];
                                ++n13;
                                if (++n17 < n19) continue;
                                n17 -= n19;
                            }
                            nArray[n13] = piVector4.m_data[n17];
                        }
                        n3 = 0;
                        while (nArrayArray[n12 + 2][n3] != piVector3.m_data[n12 + 2]) {
                            ++n3;
                            if (nArray.length < ++n13 + 1) {
                                int[] nArray4 = nArray;
                                nArray = new int[n13 + 11];
                                System.arraycopy(nArray4, 0, nArray, 0, nArray4.length);
                            }
                            if (n13 >= nArray.length || n12 + 2 >= nArrayArray.length || n3 >= nArrayArray[n12 + 2].length) {
                                PsDebug.error((String)"sorry, computation failed");
                                return null;
                            }
                            nArray[n13] = nArrayArray[n12 + 2][n3];
                        }
                        nArrayArray[n12 + 1] = new int[++n13];
                        System.arraycopy(nArray, 0, nArrayArray[n12 + 1], 0, n13);
                    }
                    ++n10;
                }
            }
            n4 = 2 * n4 - 2;
        }
        pgPolygonOnElementSet.setNumVertices(1);
        n3 = 1;
        while (n3 < n5) {
            pgPolygonOnElementSet.setNumVertices(pgPolygonOnElementSet.getNumVertices() - 1);
            if (bl) {
                piVector2.setSize(nArrayArray[n3 - 1].length);
                pdBary.copy(pdBaryArray2[n3 - 1]);
                pdBary2.copy(pdBaryArray2[n3]);
                System.arraycopy(nArrayArray[n3 - 1], 0, piVector2.m_data, 0, nArrayArray[n3 - 1].length);
                pgPolygonOnElementSet.addPolygon(PwGeodesic.getShortest((PgElementSet)pgElementSet, (PdBary)pdBary, (int)piVector3.m_data[n3 - 1], (PdBary)pdBary2, (int)piVector3.m_data[n3], (PiVector)piVector2, null));
            } else {
                pgPolygonOnElementSet.addPolygon(PwGeodesic.getShortest((PgElementSet)pgElementSet, (PdBary)pdBaryArray2[n3 - 1], (int)piVector3.m_data[n3 - 1], (PdBary)pdBaryArray2[n3], (int)piVector3.m_data[n3]));
            }
            piVector3.m_data[n3 - 1] = pgPolygonOnElementSet.getNumVertices() - 1;
            ++n3;
        }
        pgPolygonOnElementSet.getPolygon(pgPolygon);
        PdVector[] pdVectorArray = pgPolygon.getVertices();
        n2 = 1;
        while (n2 < n5 - 1) {
            pdVectorArray[piVector3.m_data[n2 - 1]].setTag(1);
            ++n2;
        }
        return pgPolygonOnElementSet;
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static void changeBarycentricOnEdge(PdBary pdBary, int n, int n2) {
        double d = pdBary.m_data[(n + 1) % 3];
        double d2 = pdBary.m_data[(n + 2) % 3];
        pdBary.m_data[n2] = 0.0;
        pdBary.m_data[(n2 + 1) % 3] = d2;
        pdBary.m_data[(n2 + 2) % 3] = d;
    }

    public void init() {
        this.m_depth.setDefBounds(0, 50, 1, 5);
        this.m_depth.setDefValue(0);
        this.m_depth.init();
        this.m_numPoints.setDefBounds(2, 20, 1, 2);
        this.m_numPoints.setDefValue(5);
        this.m_numPoints.init();
        this.m_refpointGeom.setGlobalVertexSize(5.0);
        this.m_subdivcurveGeom.setGlobalEdgeSize(3.0);
        this.m_subdivcurveGeom.setGlobalEdgeColor(Color.blue);
        this.m_subdivcurveGeom.showVertices(false);
        this.m_origcurve.setGlobalEdgeSize(2.0);
        this.m_origcurve.setGlobalEdgeColor(Color.red);
        this.m_origcurve.showVertices(false);
        super.init();
    }

    public PgGeometryIf getSelectedGeometry() {
        return this.getDisplay().getSelectedGeometry();
    }

    public void removeGeometry() {
        this.m_geometry.removeUpdateListener((PsUpdateIf)this);
        this.m_subdivcurveGeom.setNumVertices(0);
        this.m_origcurve.setNumVertices(0);
        this.m_refpointGeom.setNumVertices(0);
        this.m_subdivcurveGeom.update(null);
        this.m_origcurve.update(null);
        this.m_refpointGeom.update(null);
        this.m_geometry = null;
    }

    class GeomListener
    implements PvGeometryListenerIf {
        PjSubdivisionCurve m_project;
        PvDisplayIf m_display;

        public void setDisplay(PvDisplayIf pvDisplayIf) {
            this.m_display = pvDisplayIf;
        }

        public GeomListener(PjSubdivisionCurve pjSubdivisionCurve2) {
            ((Object)((Object)PjSubdivisionCurve.this)).getClass();
            this.m_project = null;
            this.m_display = null;
            this.m_project = pjSubdivisionCurve2;
        }

        public void selectGeometry(PgGeometryIf pgGeometryIf) {
            if (pgGeometryIf == PjSubdivisionCurve.this.m_subdivcurve || pgGeometryIf == PjSubdivisionCurve.this.m_refpointGeom || pgGeometryIf == PjSubdivisionCurve.this.m_origcurve) {
                return;
            }
            if (!PsConfig.isApplication()) {
                this.m_display.selectGeometry((PgGeometryIf)PjSubdivisionCurve.this.m_refpointGeom);
                this.m_display.update((Object)this.m_display);
            }
        }

        public String getName() {
            return "Subdivion curve project - listener";
        }

        public void removeGeometry(PgGeometryIf pgGeometryIf) {
            if (pgGeometryIf == PjSubdivisionCurve.this.m_subdivcurveGeom || pgGeometryIf == PjSubdivisionCurve.this.m_refpointGeom || pgGeometryIf == PjSubdivisionCurve.this.m_origcurve) {
                if (this.m_display != null) {
                    this.m_display.addGeometry(pgGeometryIf);
                }
                return;
            }
            if (this.m_project != null && this.m_project.getGeometry() == pgGeometryIf) {
                this.m_project.removeGeometry();
            }
        }

        public void addGeometry(PgGeometryIf pgGeometryIf) {
            if (pgGeometryIf == PjSubdivisionCurve.this.m_subdivcurveGeom || pgGeometryIf == PjSubdivisionCurve.this.m_refpointGeom) {
                return;
            }
            if (pgGeometryIf instanceof PgElementSet && !(pgGeometryIf instanceof PgTube)) {
                PgElementSet pgElementSet = (PgElementSet)pgGeometryIf;
                pgElementSet.showElements(true);
                pgElementSet.showBoundaries(true);
                if (this.m_display != null) {
                    this.m_display.removeGeometry((PgGeometryIf)PjSubdivisionCurve.this.m_geometry);
                    this.m_display.fit();
                    this.m_display.update((Object)pgGeometryIf);
                    if ((pgElementSet.getDimOfVertices() == 3 || pgElementSet.getDimOfVertices() == 2) && pgElementSet.getDimOfElements() == 3 && this.m_project != null) {
                        this.m_project.setGeometry((PgGeometry)pgElementSet);
                        this.m_project.update((Object)this.m_project);
                        this.m_display.update((Object)this.m_display);
                    }
                }
            }
        }
    }
}

