/*
 * Decompiled with CFR 0.152.
 */
package vgp.curve.elastic;

import jv.geom.PgPolygon;
import jv.number.PuDouble;
import jv.object.PsUpdateIf;
import jv.project.PgGeometryIf;
import jv.project.PjProject;
import jv.project.PvDisplayIf;
import jv.project.PvPickEvent;
import jv.vecmath.PdVector;
import vgp.curve.elastic.PnElasticOde;

public class PjElasticCurve
extends PjProject {
    protected PgPolygon m_geom = new PgPolygon(2);
    protected PuDouble m_firstCurvature = new PuDouble("Curvature K", (PsUpdateIf)this);
    protected PuDouble m_secondCurvature = new PuDouble("Deriv.Curvature K'", (PsUpdateIf)this);
    protected PuDouble m_stepsize;
    protected PuDouble m_length2;
    protected PuDouble m_stepsize2;
    protected PdVector m_start;
    protected PuDouble m_firstDir = new PuDouble("Initial Direction", (PsUpdateIf)this);
    protected PuDouble m_a;
    protected PuDouble m_b;
    private static /* synthetic */ Class class$vgp$curve$elastic$PjElasticCurve;

    public PjElasticCurve() {
        super("Discrete Curves");
        this.m_stepsize = new PuDouble("Stepsize K", (PsUpdateIf)this);
        this.m_length2 = new PuDouble("Length", (PsUpdateIf)this);
        this.m_stepsize2 = new PuDouble("Stepsize", (PsUpdateIf)this);
        this.m_a = new PuDouble("Parameter a", (PsUpdateIf)this);
        this.m_b = new PuDouble("Parameter b", (PsUpdateIf)this);
        this.m_start = new PdVector(2);
        if (((Object)((Object)this)).getClass() == (class$vgp$curve$elastic$PjElasticCurve != null ? class$vgp$curve$elastic$PjElasticCurve : (class$vgp$curve$elastic$PjElasticCurve = PjElasticCurve.class$("vgp.curve.elastic.PjElasticCurve")))) {
            this.init();
        }
    }

    public boolean update(Object object) {
        if (object == this.m_firstCurvature) {
            this.compute();
            this.m_geom.update(null);
            return true;
        }
        if (object == this.m_secondCurvature) {
            this.compute();
            this.m_geom.update(null);
            return true;
        }
        if (object == this.m_firstDir) {
            this.compute();
            this.m_geom.update(null);
            return true;
        }
        if (object == this.m_stepsize) {
            this.compute();
            this.m_geom.update(null);
            return true;
        }
        if (object == this.m_stepsize2) {
            this.compute();
            this.m_geom.update(null);
            return true;
        }
        if (object == this.m_length2) {
            this.compute();
            this.m_geom.update(null);
            return true;
        }
        if (object == this.m_a) {
            this.compute();
            this.m_geom.update(null);
            return true;
        }
        if (object == this.m_b) {
            this.compute();
            this.m_geom.update(null);
            return true;
        }
        return false;
    }

    public void dragInitial(PvPickEvent pvPickEvent) {
        this.pickInitial(pvPickEvent);
    }

    public void start() {
        this.compute();
        this.m_geom.setName("Discrete Curve");
        this.m_geom.showVertices(false);
        this.addGeometry((PgGeometryIf)this.m_geom);
        this.selectGeometry((PgGeometryIf)this.m_geom);
        PvDisplayIf pvDisplayIf = this.getDisplay();
        if (pvDisplayIf != null) {
            pvDisplayIf.selectCamera(1);
            pvDisplayIf.setMajorMode(6);
        }
        this.m_geom.update(null);
        super.start();
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void init() {
        super.init();
        this.m_firstCurvature.setDefBounds(-5.0, 5.0, 0.01, 0.05);
        this.m_firstCurvature.setDefValue(0.23);
        this.m_firstCurvature.init();
        this.m_secondCurvature.setDefBounds(-5.0, 5.0, 0.01, 0.05);
        this.m_secondCurvature.setDefValue(0.5);
        this.m_secondCurvature.init();
        this.m_firstDir.setDefBounds(-Math.PI, Math.PI, 0.1, 0.5);
        this.m_firstDir.setDefValue(0.0);
        this.m_firstDir.init();
        this.m_stepsize.setDefBounds(0.005, 1.0, 0.005, 0.01);
        this.m_stepsize.setDefValue(0.1);
        this.m_stepsize.init();
        this.m_length2.setDefBounds(0.0, 100.0, 1.0, 5.0);
        this.m_length2.setDefValue(70.0);
        this.m_length2.init();
        this.m_stepsize2.setDefBounds(0.01, 1.0, 0.01, 0.05);
        this.m_stepsize2.setDefValue(0.3);
        this.m_stepsize2.init();
        this.m_a.setDefBounds(-3.0, 3.0, 0.005, 0.01);
        this.m_a.setDefValue(1.0);
        this.m_a.init();
        this.m_b.setDefBounds(-1.0, 1.0, 0.005, 0.01);
        this.m_b.setDefValue(0.18);
        this.m_b.init();
        this.m_start.set(0.0, 0.0);
    }

    public void compute() {
        PnElasticOde pnElasticOde = new PnElasticOde();
        double d = this.m_length2.getValue();
        double[] dArray = new double[]{this.m_start.getEntry(0), this.m_start.getEntry(1), Math.cos(this.m_firstDir.getValue()), Math.sin(this.m_firstDir.getValue())};
        pnElasticOde.setInitialData(0.0, dArray, this.m_stepsize2.getValue(), d, this.m_firstCurvature.getValue(), this.m_secondCurvature.getValue(), this.m_stepsize.getValue(), this.m_a.getValue(), this.m_b.getValue());
        pnElasticOde.solve(this.m_geom);
    }

    public void pickInitial(PvPickEvent pvPickEvent) {
        PdVector pdVector = pvPickEvent.getVertex();
        this.m_start.set(pdVector.getEntry(0), pdVector.getEntry(1));
        this.compute();
        this.m_geom.update(null);
    }
}

