/*
 * Decompiled with CFR 0.152.
 */
package dev.primitive;

import java.awt.Color;
import java.util.Enumeration;
import jv.function.PuFunction;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.number.PuDouble;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.project.PgGeometryIf;
import jv.project.PvDisplayIf;
import jv.vecmath.PdVector;
import jvx.surface.PgDomain;
import jvx.surface.PgDomainDescr;

public class PgGraphF
extends PgElementSet {
    protected static final int m_dimOfDomain = 2;
    protected static final int m_dimOfScalar = 1;
    protected PgDomain m_domain;
    protected PgElementSet m_scalar;
    protected PuFunction m_function;
    protected boolean m_bShowDomain;
    protected boolean m_bSynchronize;
    protected PuDouble m_offset;
    protected PuDouble m_scale;
    protected boolean m_bIsUpdateSender = false;
    private static /* synthetic */ Class class$dev$primitive$PgGraphF;

    public PgElementSet getScalar() {
        return this.m_scalar;
    }

    public PuDouble getScalingSlider() {
        return this.m_scale;
    }

    public boolean isEnabledSynchronization() {
        return this.m_bSynchronize;
    }

    public PgDomain getDomain() {
        return this.m_domain;
    }

    public boolean isShowingDomain() {
        return this.m_bShowDomain;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(super.toString());
        stringBuffer.append("\t ******* PgGraphF *********\n");
        stringBuffer.append(this.m_domain.toString());
        stringBuffer.append(this.m_scalar.toString());
        stringBuffer.append(this.m_function.toString());
        return stringBuffer.toString();
    }

    public PgGraphF() {
        super(3);
        this.setName("GraphF");
        this.setTag(7);
        this.m_bShowDomain = false;
        this.m_bSynchronize = false;
        this.m_domain = new PgDomain(2);
        this.m_domain.setParent((PsUpdateIf)this);
        this.m_domain.setName("Domain");
        this.m_domain.setVisible(this.m_bShowDomain);
        this.m_scalar = new PgElementSet(1);
        this.m_scalar.setParent((PsUpdateIf)this);
        this.m_scalar.setName("Scalar");
        this.m_function = new PuFunction(2, 1);
        this.m_function.setParent((PsUpdateIf)this);
        this.m_function.setName("Graph");
        this.m_offset = new PuDouble(PsConfig.getMessage((boolean)true, (int)54000, (String)"Offset"), (PsUpdateIf)this);
        this.m_offset.setDefBounds(-5.0, 5.0, 0.1, 1.0);
        this.m_offset.setDefValue(0.0);
        this.m_scale = new PuDouble(PsConfig.getMessage((boolean)true, (int)54000, (String)"Scale"), (PsUpdateIf)this);
        this.m_scale.setDefBounds(0.0, 5.0, 0.1, 1.0);
        this.m_scale.setDefValue(1.0);
        if (((Object)((Object)this)).getClass() == (class$dev$primitive$PgGraphF != null ? class$dev$primitive$PgGraphF : (class$dev$primitive$PgGraphF = PgGraphF.class$("dev.primitive.PgGraphF")))) {
            this.init();
        }
    }

    public double getScaling() {
        return this.m_scale.getValue();
    }

    public void setScaling(double d) {
        this.m_scale.setValue(d);
    }

    public boolean update(Object object) {
        if (this.m_bIsUpdateSender) {
            return true;
        }
        if (object == null) {
            return super.update(null);
        }
        if (object == this) {
            this.compute();
            if (this.m_bShowDomain != this.m_domain.isVisible() && this.getDisplays() != null) {
                this.m_domain.setVisible(this.m_bShowDomain);
                Enumeration enumeration = this.getDisplays();
                while (enumeration != null && enumeration.hasMoreElements()) {
                    PvDisplayIf pvDisplayIf = (PvDisplayIf)enumeration.nextElement();
                    if (this.m_bShowDomain) {
                        pvDisplayIf.addGeometry((PgGeometryIf)this.m_domain);
                        continue;
                    }
                    pvDisplayIf.removeGeometry((PgGeometryIf)this.m_domain);
                }
            }
            if (this.m_bSynchronize) {
                boolean bl = false;
                if (this.hasVertexColors()) {
                    this.m_domain.setVertexColors(this.getVertexColors());
                    this.m_domain.showVertexColors(this.isShowingVertexColors());
                    bl = true;
                }
                if (this.hasElementColors()) {
                    this.m_domain.setElementColors(this.getElementColors());
                    this.m_domain.showElementColors(this.isShowingElementColors());
                    bl = true;
                }
                if (bl) {
                    this.m_bIsUpdateSender = true;
                    this.m_domain.update((Object)this.m_domain);
                    this.m_bIsUpdateSender = false;
                }
            }
            return super.update(object);
        }
        if (object == this.m_domain) {
            return this.update((Object)this);
        }
        if (object == this.m_scalar) {
            return this.update((Object)this);
        }
        if (object == this.m_function) {
            return this.update((Object)this);
        }
        if (object == this.m_scale) {
            return this.update((Object)this);
        }
        if (object == this.m_offset) {
            return this.update((Object)this);
        }
        return super.update(object);
    }

    public void copy(PsObject psObject) {
        super.copy(psObject);
        if (!(psObject instanceof PgGraphF)) {
            return;
        }
        PgGraphF pgGraphF = (PgGraphF)psObject;
        this.m_domain.copy((PsObject)pgGraphF.m_domain);
        this.m_scalar.copy((PsObject)pgGraphF.m_scalar);
        this.m_function.copy((PsObject)pgGraphF.m_function);
        this.m_bShowDomain = pgGraphF.m_bShowDomain;
        this.m_bSynchronize = pgGraphF.m_bSynchronize;
        this.m_offset.copy(pgGraphF.m_offset);
        this.m_scale.copy(pgGraphF.m_scale);
    }

    public PuDouble getOffsetSlider() {
        return this.m_offset;
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public PuFunction getFunction() {
        return this.m_function;
    }

    public void setFunction(PuFunction puFunction) {
        if (puFunction == null) {
            PsDebug.warning((String)"missing argument function.");
            return;
        }
        if (puFunction.getNumFunctions() != 1) {
            PsDebug.warning((String)("number of functions must be 1, numFunctions = " + puFunction.getNumFunctions() + "."));
            return;
        }
        this.m_function.copy((PsObject)puFunction);
    }

    public boolean makeVertexTextureFromUV() {
        if (((PgPointSet)this).m_numVertices == 0) {
            return true;
        }
        int n = this.m_domain.getDescr().getNumULines();
        int n2 = this.m_domain.getDescr().getNumVLines();
        return this.makeVertexTextureFromUV(n, n2, 0);
    }

    public void init() {
        super.init();
        this.m_offset.init();
        this.m_scale.init();
        this.m_function.init();
        boolean bl = this.m_domain.isVisible();
        this.m_domain.init();
        this.m_domain.setVisible(bl);
        this.m_domain.setDimOfElements(4);
        this.m_domain.setGlobalElementColor(new Color(192, 140, 0));
        this.m_scalar.init();
        this.computeConnectivity();
    }

    public Object clone() {
        PgGraphF pgGraphF = (PgGraphF)((Object)super.clone());
        if (pgGraphF == null) {
            return null;
        }
        pgGraphF.m_domain = (PgDomain)this.m_domain.clone();
        pgGraphF.m_domain.setParent((PsUpdateIf)this);
        pgGraphF.m_scalar = (PgElementSet)this.m_scalar.clone();
        pgGraphF.m_scalar.setParent((PsUpdateIf)this);
        pgGraphF.m_function = (PuFunction)this.m_function.clone();
        pgGraphF.m_function.setParent((PsUpdateIf)pgGraphF);
        pgGraphF.m_offset = (PuDouble)this.m_offset.clone();
        pgGraphF.m_offset.setParent((PsUpdateIf)pgGraphF);
        pgGraphF.m_scale = (PuDouble)this.m_scale.clone();
        pgGraphF.m_scale.setParent((PsUpdateIf)pgGraphF);
        return pgGraphF;
    }

    public void setShowingDomain(boolean bl) {
        this.m_bShowDomain = bl;
    }

    public double getOffset() {
        return this.m_offset.getValue();
    }

    public void setOffset(double d) {
        this.m_offset.setValue(d);
    }

    private void computeConnectivity() {
        this.m_scalar.setNumVertices(this.m_domain.getNumVertices());
        this.m_scalar.copyElementSet((PgElementSet)this.m_domain);
        this.setNumVertices(this.m_domain.getNumVertices());
        this.copyConnectivity((PgElementSet)this.m_domain);
    }

    public void compute() {
        this.computeConnectivity();
        PdVector[] pdVectorArray = this.m_domain.getVertices();
        PdVector[] pdVectorArray2 = this.m_scalar.getVertices();
        PdVector pdVector = new PdVector(1);
        int n = 0;
        while (n < ((PgPointSet)this).m_numVertices) {
            this.m_function.eval(pdVector.m_data, pdVectorArray[n].m_data);
            pdVectorArray2[n].setEntry(0, pdVector.getEntry(0));
            ((PgPointSet)this).m_vertex[n].copy(0, pdVectorArray[n], 0, 2);
            ((PgPointSet)this).m_vertex[n].copy(2, pdVectorArray2[n], 0, 1);
            ++n;
        }
        double d = this.m_offset.getValue();
        double d2 = this.m_scale.getValue();
        int n2 = 0;
        while (n2 < ((PgPointSet)this).m_numVertices) {
            ((PgPointSet)this).m_vertex[n2].m_data[2] = d + d2 * ((PgPointSet)this).m_vertex[n2].m_data[2];
            ++n2;
        }
        this.makeVertexNormals();
        this.makeElementNormals();
        this.makeVertexTextureFromUV();
    }

    public void computeSample() {
        PgDomainDescr pgDomainDescr = this.m_domain.getDescr();
        pgDomainDescr.setMaxSize(-10.0, -10.0, 10.0, 10.0);
        pgDomainDescr.setSize(-Math.PI, -Math.PI, Math.PI, Math.PI);
        pgDomainDescr.setDiscrBounds(2, 2, 50, 50);
        pgDomainDescr.setDiscr(30, 30);
        this.m_domain.compute();
        this.m_function.setVariables(new String[]{"u", "v"});
        this.m_function.setExpression("2.+sin(u*v)");
        this.compute();
    }

    public void setEnabledSynchronization(boolean bl) {
        this.m_bSynchronize = bl;
    }
}

