/*
 * Decompiled with CFR 0.152.
 */
package dev.loader;

import java.io.BufferedReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.Writer;
import java.text.NumberFormat;
import java.util.BitSet;
import java.util.Date;
import jv.geom.PgPolygon;
import jv.geom.PgPolygonSet;
import jv.loader.PgLoader;
import jv.loader.PgLoaderIf;
import jv.loader.PvDisplayOption;
import jv.number.PuString;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.project.PgGeometryIf;
import jv.project.PgJvxSrc;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public class PgPolyLoader
implements PgLoaderIf {
    protected int m_indexFirstVertex = 0;
    protected PgJvxSrc[] m_geomArr;

    public void setGeometryOption(BitSet bitSet) {
    }

    public boolean isEnabledOptimization() {
        return false;
    }

    protected boolean parse(BufferedReader bufferedReader, PgJvxSrc pgJvxSrc) {
        StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedReader);
        streamTokenizer.ordinaryChars(47, 47);
        streamTokenizer.ordinaryChars(95, 95);
        streamTokenizer.eolIsSignificant(true);
        streamTokenizer.ordinaryChar(45);
        streamTokenizer.ordinaryChar(43);
        streamTokenizer.ordinaryChar(46);
        streamTokenizer.ordinaryChars(48, 48);
        streamTokenizer.ordinaryChars(49, 57);
        streamTokenizer.wordChars(94, 94);
        streamTokenizer.wordChars(38, 38);
        streamTokenizer.wordChars(36, 36);
        streamTokenizer.wordChars(40, 40);
        streamTokenizer.wordChars(41, 41);
        streamTokenizer.wordChars(126, 126);
        streamTokenizer.wordChars(64, 64);
        streamTokenizer.wordChars(45, 45);
        streamTokenizer.wordChars(43, 43);
        streamTokenizer.wordChars(42, 42);
        streamTokenizer.wordChars(48, 48);
        streamTokenizer.wordChars(49, 57);
        streamTokenizer.wordChars(46, 46);
        streamTokenizer.wordChars(44, 44);
        streamTokenizer.wordChars(59, 59);
        streamTokenizer.wordChars(95, 95);
        streamTokenizer.wordChars(58, 58);
        streamTokenizer.wordChars(95, 95);
        streamTokenizer.commentChar(35);
        try {
            do {
                streamTokenizer.nextToken();
            } while (streamTokenizer.ttype == 10);
            int n = Integer.parseInt(streamTokenizer.sval);
            streamTokenizer.nextToken();
            PdVector[] pdVectorArray = new PdVector[n];
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                pdVectorArray[n3] = new PdVector(n2);
                int n4 = 0;
                do {
                    streamTokenizer.nextToken();
                    if (streamTokenizer.ttype != 10 && streamTokenizer.ttype != -1) {
                        double d = PgLoader.parseDouble((String)streamTokenizer.sval);
                        pdVectorArray[n3].setEntry(n4, d);
                    }
                    ++n4;
                } while (streamTokenizer.ttype != 10 && streamTokenizer.ttype != -1);
                if (n3 == 0) {
                    n2 = pdVectorArray[n3].getSize();
                }
                ++n3;
            }
            if (n > 0) {
                pgJvxSrc.setDimOfVertices(pdVectorArray[0].getSize());
                pgJvxSrc.setNumVertices(n);
                pgJvxSrc.setVertices(pdVectorArray);
            }
        }
        catch (IOException iOException) {
            PsDebug.warning((String)("Exception thrown = " + iOException.toString() + "\n\tparsing broke abnormally in line=" + streamTokenizer.lineno() + ",\n\treading st.sval=" + streamTokenizer.sval + ",\n\tst.ttype=" + streamTokenizer.ttype));
            return false;
        }
        return true;
    }

    public PgJvxSrc[] read(BufferedReader bufferedReader) {
        if (!this.load(bufferedReader)) {
            return null;
        }
        return this.getGeometries();
    }

    public PgJvxSrc[][] getAnimations() {
        return null;
    }

    public PgJvxSrc[] getGeometries() {
        return this.m_geomArr;
    }

    public PvDisplayOption getDisplayOption() {
        return null;
    }

    public void setDisplayOption(PvDisplayOption pvDisplayOption) {
    }

    public void setAnimation(boolean bl) {
    }

    public static boolean writePgPolygonSetAsMultipleFiles(PgPolygonSet pgPolygonSet, String string) {
        int n;
        int n2 = n = pgPolygonSet.getNumPolygons();
        int n3 = 0;
        while (n2 > 0) {
            n2 /= 10;
            ++n3;
        }
        PgPolyLoader pgPolyLoader = new PgPolyLoader();
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMinimumIntegerDigits(n3);
        int n4 = pgPolygonSet.getDimOfVertices();
        PgPolygon pgPolygon = new PgPolygon(n4);
        PgJvxSrc[] pgJvxSrcArray = new PgJvxSrc[1];
        PdVector[] pdVectorArray = pgPolygonSet.getVertices();
        int n5 = 0;
        while (n5 < n) {
            PiVector piVector = pgPolygonSet.getPolygon(n5);
            int n6 = piVector.getSize();
            pgPolygon.setNumVertices(n6);
            PdVector[] pdVectorArray2 = pgPolygon.getVertices();
            int n7 = 0;
            while (n7 < n6) {
                pdVectorArray2[n7].copyArray(pdVectorArray[piVector.m_data[n7]]);
                ++n7;
            }
            pgPolygon.setClosed(pgPolygonSet.isClosed(n5));
            pgJvxSrcArray[0] = pgPolygon.getJvx();
            String string2 = string + numberFormat.format(n5) + ".poly";
            try {
                FileWriter fileWriter = new FileWriter(string2);
                pgPolyLoader.write(fileWriter, pgJvxSrcArray);
                fileWriter.close();
            }
            catch (IOException iOException) {
                PsDebug.warning((String)("could not write to file " + string2));
                return false;
            }
            ++n5;
        }
        return true;
    }

    public boolean write(Writer writer, PgJvxSrc[] pgJvxSrcArray) throws IOException {
        if (pgJvxSrcArray == null || pgJvxSrcArray.length == 0 || pgJvxSrcArray[0] == null) {
            PsDebug.warning((String)"missing geometry");
            return false;
        }
        PgJvxSrc pgJvxSrc = pgJvxSrcArray[0];
        writer.write("# Produced with JavaView v." + PsConfig.getVersion() + "\n");
        writer.write("# JavaView is " + PsConfig.getCopyright() + ", " + PsConfig.getHomepage() + "\n");
        writer.write("# by " + PsConfig.getAuthors() + "\n");
        writer.write("#     File Format = Poly (Tebis internal)\n");
        writer.write("#     Geometry    = " + pgJvxSrc.getName() + "\n");
        writer.write("#     Date        = " + new Date().toString() + "\n#\n");
        int n = pgJvxSrc.getNumVertices();
        writer.write("#     Number of Vertices    = " + n + "\n");
        writer.write("#\n# End of Header\n");
        PdVector[] pdVectorArray = pgJvxSrc.getVertices();
        writer.write(String.valueOf(n) + "\n");
        int n2 = 0;
        while (n2 < n) {
            writer.write(PuString.toString((double[])pdVectorArray[n2].m_data) + "\n");
            ++n2;
        }
        return true;
    }

    public boolean load(BufferedReader bufferedReader) {
        if (bufferedReader == null) {
            PsDebug.warning((String)"missing reader");
            return false;
        }
        PgJvxSrc pgJvxSrc = new PgJvxSrc();
        if (!this.parse(bufferedReader, pgJvxSrc)) {
            PsDebug.warning((String)"error during parsing of reader");
            return false;
        }
        pgJvxSrc.setType(31);
        pgJvxSrc.showVertices(true);
        pgJvxSrc.setGlobalVertexSize(1.0);
        pgJvxSrc.showPolygons(true);
        this.m_geomArr = new PgJvxSrc[]{pgJvxSrc};
        return true;
    }

    public int getFirstVertexIndex() {
        return this.m_indexFirstVertex;
    }

    public void setFirstVertexIndex(int n) {
        this.m_indexFirstVertex = n;
    }

    public boolean isAnimation() {
        return false;
    }

    public PgGeometryIf[] getSpecializedGeometries() {
        return null;
    }
}

