/*
 * Decompiled with CFR 0.152.
 */
package dev.loader;

import dev.primitive.PgCircleF;
import dev.primitive.PgCurveF;
import dev.primitive.PgGraphF;
import dev.primitive.PgPlotF;
import dev.primitive.PgPointF;
import dev.primitive.PgSegmentF;
import dev.primitive.PgSphere;
import dev.primitive.PuIntervalDescr;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Writer;
import java.util.BitSet;
import java.util.Date;
import jv.function.PuFunction;
import jv.loader.PgJvxLoader;
import jv.loader.PgLoaderIf;
import jv.loader.PsXmlLoader;
import jv.loader.PvDisplayOption;
import jv.number.PuDouble;
import jv.number.PuString;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.project.PgGeometryIf;
import jv.project.PgJvxSrc;
import jv.rsrc.PsAuthorInfo;
import jv.rsrc.PsGeometryInfo;
import jv.rsrc.PsXmlNode;
import jv.rsrc.PsXmlSrc;
import jv.thirdParty.expr.Expr;
import jv.thirdParty.expr.Parser;
import jv.thirdParty.expr.Syntax_error;
import jv.thirdParty.expr.Variable;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.surface.PgDomain;
import jvx.surface.PgDomainDescr;
import jvx.surface.PgParmSurface;

public class PgJvfLoader
implements PgLoaderIf {
    private int m_jvVersion = -1;
    protected boolean m_bIsEnabledOptimization = false;
    protected BitSet m_geometryOption;
    protected boolean m_bIsAnimation = false;
    protected PgJvxSrc[] m_geomArr;
    protected PgGeometryIf[] m_specialArr;
    private static final int UNKNOWN = -1;
    private static final int TRUE = 1;
    private static final int FALSE = 0;

    public void setGeometryOption(BitSet bitSet) {
        this.m_geometryOption = bitSet;
    }

    public boolean isEnabledOptimization() {
        return this.m_bIsEnabledOptimization;
    }

    protected static int parseFlag(PsXmlNode psXmlNode) {
        String string = psXmlNode.getAttribute("value");
        if (string == null) {
            return -1;
        }
        if (string.equalsIgnoreCase("true")) {
            return 1;
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected PgGeometryIf[] parseRsrcTree(PsXmlSrc psXmlSrc) {
        PsXmlNode psXmlNode = psXmlSrc.getRootNode();
        if (psXmlNode == null) {
            PsDebug.warning((String)"missing root node.");
            return null;
        }
        if (psXmlNode.getType() == null || !psXmlNode.getType().equalsIgnoreCase("jvf-model")) {
            PsDebug.warning((String)"missing <jvf-model> element,\nthis is not a valid JavaView geometry file.");
            return null;
        }
        String string = null;
        String string2 = null;
        PsXmlNode psXmlNode2 = PsXmlSrc.getRsrcNode((PsXmlNode)psXmlNode, (String)"version");
        if (psXmlNode2 == null) {
            string = "0.0";
            string2 = "dump";
        } else {
            string = psXmlNode2.getContent();
            string2 = psXmlNode2.getAttribute("type");
        }
        String string3 = PsXmlSrc.getRsrc((PsXmlNode)psXmlNode, (String)"title");
        PsXmlNode psXmlNode3 = PsXmlSrc.getRsrcNode((PsXmlNode)psXmlNode, (String)"authors");
        PsAuthorInfo psAuthorInfo = null;
        if (psXmlNode3 != null) {
            psAuthorInfo = new PsAuthorInfo();
            psAuthorInfo.setXmlNode(psXmlNode3);
        }
        PsXmlNode psXmlNode4 = PsXmlSrc.getRsrcNode((PsXmlNode)psXmlNode, (String)"description");
        PsGeometryInfo psGeometryInfo = null;
        if (psXmlNode4 != null) {
            psGeometryInfo = new PsGeometryInfo();
            psGeometryInfo.setXmlNode(psXmlNode4, null);
        }
        PgGeometryIf[] pgGeometryIfArray = null;
        String[] stringArray = new String[]{"tag", "name"};
        PsXmlNode psXmlNode5 = PsXmlSrc.getRsrcNode((PsXmlNode)psXmlNode, (String)"geometries");
        if (psXmlNode5 == null) {
            PsDebug.warning((String)"missing node 'geometries'.");
            return pgGeometryIfArray;
        }
        PuDouble[] puDoubleArray = this.parseParm(psXmlNode5);
        PsXmlNode[] psXmlNodeArray = PsXmlSrc.getRsrcNodes((PsXmlNode)psXmlNode5, (String)"geometry");
        if (psXmlNodeArray == null) return null;
        if (psXmlNodeArray.length == 0) {
            return null;
        }
        pgGeometryIfArray = new PgGeometryIf[psXmlNodeArray.length];
        int n = 0;
        while (n < psXmlNodeArray.length) {
            block268: {
                PgJvxSrc pgJvxSrc;
                block285: {
                    PdMatrix pdMatrix;
                    Object object;
                    block265: {
                        String string4;
                        block288: {
                            Object object2;
                            block289: {
                                int n2;
                                block287: {
                                    block286: {
                                        PsXmlNode psXmlNode6;
                                        int n3;
                                        PiVector[] piVectorArray;
                                        double d;
                                        PsXmlNode psXmlNode7;
                                        PdVector[] pdVectorArray;
                                        PsXmlNode psXmlNode8;
                                        String string5;
                                        PiVector[] piVectorArray2;
                                        PdVector[] pdVectorArray2;
                                        Object object3;
                                        Object object4;
                                        int n4;
                                        int n5;
                                        block280: {
                                            PsXmlNode psXmlNode9;
                                            block281: {
                                                PdVector[] pdVectorArray3;
                                                PsXmlNode psXmlNode10;
                                                block264: {
                                                    block283: {
                                                        block284: {
                                                            block263: {
                                                                block282: {
                                                                    Color[] colorArray;
                                                                    String[] stringArray2;
                                                                    block277: {
                                                                        PgParmSurface pgParmSurface;
                                                                        PuDouble[] puDoubleArray2;
                                                                        Object object5;
                                                                        double d2;
                                                                        block279: {
                                                                            PsXmlNode[] psXmlNodeArray2;
                                                                            block278: {
                                                                                block275: {
                                                                                    PsXmlNode[] psXmlNodeArray3;
                                                                                    PuFunction puFunction;
                                                                                    PsXmlNode psXmlNode11;
                                                                                    block276: {
                                                                                        block272: {
                                                                                            PuFunction puFunction2;
                                                                                            Object object6;
                                                                                            block274: {
                                                                                                PsXmlNode[] psXmlNodeArray4;
                                                                                                block273: {
                                                                                                    block269: {
                                                                                                        PsXmlNode[] psXmlNodeArray5;
                                                                                                        Object object7;
                                                                                                        block271: {
                                                                                                            PuFunction puFunction3;
                                                                                                            block270: {
                                                                                                                PsXmlNode[] psXmlNodeArray6;
                                                                                                                PsXmlNode psXmlNode12;
                                                                                                                Object object8;
                                                                                                                block266: {
                                                                                                                    block267: {
                                                                                                                        PsXmlNode psXmlNode13 = PsXmlSrc.getRsrcNode((PsXmlNode)psXmlNodeArray[n], (String)"sphere");
                                                                                                                        if (psXmlNode13 == null) break block266;
                                                                                                                        PgJvfLoader.parseDimension(psXmlNode13, 3);
                                                                                                                        object8 = new PgSphere();
                                                                                                                        pgGeometryIfArray[n] = object8;
                                                                                                                        if (psXmlNode13.hasChild("base")) {
                                                                                                                            psXmlNode12 = PsXmlLoader.parsePdVector((PsXmlNode)psXmlNode13, (String)"base", null);
                                                                                                                            ((PgSphere)((Object)object8)).setBase((PdVector)psXmlNode12);
                                                                                                                        }
                                                                                                                        if (psXmlNode13.hasChild("radius")) {
                                                                                                                            d2 = PgJvfLoader.getRsrcAsDoubleF(psXmlNode13, "radius");
                                                                                                                            ((PgSphere)((Object)object8)).setRadius(d2);
                                                                                                                        }
                                                                                                                        psXmlNode12 = ((PgSphere)((Object)object8)).getDomainDescr();
                                                                                                                        psXmlNodeArray6 = psXmlNode13.getChildren("var");
                                                                                                                        if (psXmlNodeArray6 != null && psXmlNodeArray6.length == 2) break block267;
                                                                                                                        PsDebug.warning((String)"missing var elements.");
                                                                                                                        break block268;
                                                                                                                    }
                                                                                                                    if (psXmlNodeArray6[0].hasChild("min")) {
                                                                                                                        d2 = PgJvfLoader.getRsrcAsDoubleF(psXmlNodeArray6[0], "min");
                                                                                                                        psXmlNode12.setUMin(d2);
                                                                                                                    }
                                                                                                                    if (psXmlNodeArray6[0].hasChild("max")) {
                                                                                                                        d2 = PgJvfLoader.getRsrcAsDoubleF(psXmlNodeArray6[0], "max");
                                                                                                                        psXmlNode12.setUMax(d2);
                                                                                                                    }
                                                                                                                    if (psXmlNodeArray6[0].hasChild("discr")) {
                                                                                                                        n5 = PsXmlSrc.getRsrcAsInteger((PsXmlNode)psXmlNodeArray6[0], (String)"discr");
                                                                                                                        psXmlNode12.setNumULines(n5);
                                                                                                                    }
                                                                                                                    if (psXmlNodeArray6[1].hasChild("min")) {
                                                                                                                        d2 = PgJvfLoader.getRsrcAsDoubleF(psXmlNodeArray6[1], "min");
                                                                                                                        psXmlNode12.setVMin(d2);
                                                                                                                    }
                                                                                                                    if (psXmlNodeArray6[1].hasChild("max")) {
                                                                                                                        d2 = PgJvfLoader.getRsrcAsDoubleF(psXmlNodeArray6[1], "max");
                                                                                                                        psXmlNode12.setVMax(d2);
                                                                                                                    }
                                                                                                                    if (psXmlNodeArray6[1].hasChild("discr")) {
                                                                                                                        n5 = PsXmlSrc.getRsrcAsInteger((PsXmlNode)psXmlNodeArray6[1], (String)"discr");
                                                                                                                        psXmlNode12.setNumVLines(n5);
                                                                                                                    }
                                                                                                                    ((PgSphere)((Object)object8)).compute();
                                                                                                                }
                                                                                                                if ((object8 = PsXmlSrc.getRsrcNode((PsXmlNode)psXmlNodeArray[n], (String)"circleF")) != null) {
                                                                                                                    int n6 = PgJvfLoader.parseDimension((PsXmlNode)object8, 2);
                                                                                                                    psXmlNodeArray6 = new PgCircleF(n6);
                                                                                                                    pgGeometryIfArray[n] = psXmlNodeArray6;
                                                                                                                    object7 = object8.getChild("baseF");
                                                                                                                    object6 = psXmlNodeArray6.getBaseF();
                                                                                                                    if (object6 != null) {
                                                                                                                        puFunction3 = object7.getAttribute("name");
                                                                                                                        if (puFunction3 != null) {
                                                                                                                            object6.setName((String)puFunction3);
                                                                                                                        }
                                                                                                                        object5 = object7.getContent();
                                                                                                                        String[] stringArray3 = PuString.splitString((String)object5, (char)';');
                                                                                                                        object6.setExpressions(stringArray3);
                                                                                                                    }
                                                                                                                    puFunction3 = object8.getChild("radiusF");
                                                                                                                    object5 = psXmlNodeArray6.getRadiusF();
                                                                                                                    if (object5 != null) {
                                                                                                                        String string6 = object7.getAttribute("name");
                                                                                                                        if (string6 != null) {
                                                                                                                            object5.setName(string6);
                                                                                                                        }
                                                                                                                        String string7 = puFunction3.getContent();
                                                                                                                        object5.setExpression(string7);
                                                                                                                    }
                                                                                                                    if ((puDoubleArray2 = this.parseParm((PsXmlNode)object8)) != null) {
                                                                                                                        n4 = 0;
                                                                                                                        while (n4 < puDoubleArray2.length) {
                                                                                                                            object6.addParameter(puDoubleArray2[n4]);
                                                                                                                            object5.addParameter(puDoubleArray2[n4]);
                                                                                                                            ++n4;
                                                                                                                        }
                                                                                                                    }
                                                                                                                    if (puDoubleArray != null) {
                                                                                                                        n4 = 0;
                                                                                                                        while (n4 < puDoubleArray.length) {
                                                                                                                            object6.addParameter(puDoubleArray[n4]);
                                                                                                                            object5.addParameter(puDoubleArray[n4]);
                                                                                                                            ++n4;
                                                                                                                        }
                                                                                                                    }
                                                                                                                    psXmlNodeArray6.compute();
                                                                                                                }
                                                                                                                if ((psXmlNode12 = PsXmlSrc.getRsrcNode((PsXmlNode)psXmlNodeArray[n], (String)"pointF")) != null) {
                                                                                                                    int n7 = PgJvfLoader.parseDimension(psXmlNode12, 2);
                                                                                                                    object7 = new PgPointF(n7);
                                                                                                                    pgGeometryIfArray[n] = object7;
                                                                                                                    object6 = psXmlNode12.getChild("baseF");
                                                                                                                    puFunction3 = ((PgPointF)((Object)object7)).getBaseF();
                                                                                                                    if (puFunction3 != null) {
                                                                                                                        object5 = object6.getAttribute("name");
                                                                                                                        if (object5 != null) {
                                                                                                                            puFunction3.setName((String)object5);
                                                                                                                        }
                                                                                                                        String string8 = object6.getContent();
                                                                                                                        String[] stringArray4 = PuString.splitString((String)string8, (char)';');
                                                                                                                        puFunction3.setExpressions(stringArray4);
                                                                                                                    }
                                                                                                                    if ((puDoubleArray2 = this.parseParm(psXmlNode12)) != null) {
                                                                                                                        n4 = 0;
                                                                                                                        while (n4 < puDoubleArray2.length) {
                                                                                                                            puFunction3.addParameter(puDoubleArray2[n4]);
                                                                                                                            ++n4;
                                                                                                                        }
                                                                                                                    }
                                                                                                                    if (puDoubleArray != null) {
                                                                                                                        n4 = 0;
                                                                                                                        while (n4 < puDoubleArray.length) {
                                                                                                                            puFunction3.addParameter(puDoubleArray[n4]);
                                                                                                                            ++n4;
                                                                                                                        }
                                                                                                                    }
                                                                                                                    ((PgPointF)((Object)object7)).compute();
                                                                                                                }
                                                                                                                if ((psXmlNodeArray6 = PsXmlSrc.getRsrcNode((PsXmlNode)psXmlNodeArray[n], (String)"segmentF")) != null) {
                                                                                                                    int n8 = PgJvfLoader.parseDimension((PsXmlNode)psXmlNodeArray6, 2);
                                                                                                                    object6 = new PgSegmentF(n8);
                                                                                                                    pgGeometryIfArray[n] = object6;
                                                                                                                    puFunction3 = psXmlNodeArray6.getChild("baseF");
                                                                                                                    object5 = ((PgSegmentF)((Object)object6)).getBaseF();
                                                                                                                    if (object5 != null) {
                                                                                                                        String string9 = puFunction3.getAttribute("name");
                                                                                                                        if (string9 != null) {
                                                                                                                            object5.setName(string9);
                                                                                                                        }
                                                                                                                        String string10 = puFunction3.getContent();
                                                                                                                        object4 = PuString.splitString((String)string10, (char)';');
                                                                                                                        object5.setExpressions((String[])object4);
                                                                                                                    }
                                                                                                                    PsXmlNode psXmlNode14 = psXmlNodeArray6.getChild("tipF");
                                                                                                                    PuFunction puFunction4 = ((PgSegmentF)((Object)object6)).getTipF();
                                                                                                                    if (puFunction4 != null) {
                                                                                                                        object4 = psXmlNode14.getAttribute("name");
                                                                                                                        if (object4 != null) {
                                                                                                                            puFunction4.setName((String)object4);
                                                                                                                        }
                                                                                                                        stringArray2 = psXmlNode14.getContent();
                                                                                                                        object3 = PuString.splitString((String)stringArray2, (char)';');
                                                                                                                        puFunction4.setExpressions((String[])object3);
                                                                                                                    }
                                                                                                                    if ((puDoubleArray2 = this.parseParm((PsXmlNode)psXmlNodeArray6)) != null) {
                                                                                                                        n4 = 0;
                                                                                                                        while (n4 < puDoubleArray2.length) {
                                                                                                                            object5.addParameter(puDoubleArray2[n4]);
                                                                                                                            puFunction4.addParameter(puDoubleArray2[n4]);
                                                                                                                            ++n4;
                                                                                                                        }
                                                                                                                    }
                                                                                                                    if (puDoubleArray != null) {
                                                                                                                        n4 = 0;
                                                                                                                        while (n4 < puDoubleArray.length) {
                                                                                                                            object5.addParameter(puDoubleArray[n4]);
                                                                                                                            puFunction4.addParameter(puDoubleArray[n4]);
                                                                                                                            ++n4;
                                                                                                                        }
                                                                                                                    }
                                                                                                                    ((PgSegmentF)((Object)object6)).compute();
                                                                                                                }
                                                                                                                if ((object7 = PsXmlSrc.getRsrcNode((PsXmlNode)psXmlNodeArray[n], (String)"plotF")) == null) break block269;
                                                                                                                PgJvfLoader.parseDimension((PsXmlNode)object7, 2);
                                                                                                                object6 = new PgPlotF();
                                                                                                                pgGeometryIfArray[n] = object6;
                                                                                                                puFunction3 = object7.getChildren("funExpr");
                                                                                                                object5 = ((PgPlotF)((Object)object6)).getFunction();
                                                                                                                if (puFunction3 != null && ((PsXmlNode[])puFunction3).length == 1) break block270;
                                                                                                                PsDebug.warning((String)"missing function elements.");
                                                                                                                break block268;
                                                                                                            }
                                                                                                            n4 = 0;
                                                                                                            while (n4 < ((PsXmlNode[])puFunction3).length) {
                                                                                                                String string11 = puFunction3[n4].getContent();
                                                                                                                object5.setExpression(n4, string11);
                                                                                                                String string12 = puFunction3[n4].getAttribute("name");
                                                                                                                if (string12 != null) {
                                                                                                                    object5.setExpressionName(n4, string12);
                                                                                                                }
                                                                                                                ++n4;
                                                                                                            }
                                                                                                            psXmlNodeArray5 = object7.getChildren("var");
                                                                                                            if (psXmlNodeArray5 != null && psXmlNodeArray5.length == 1) break block271;
                                                                                                            PsDebug.warning((String)"missing var elements.");
                                                                                                            break block268;
                                                                                                        }
                                                                                                        object5.setNumVariables(psXmlNodeArray5.length);
                                                                                                        String[] stringArray5 = new String[psXmlNodeArray5.length];
                                                                                                        n4 = 0;
                                                                                                        while (n4 < psXmlNodeArray5.length) {
                                                                                                            stringArray5[n4] = psXmlNodeArray5[n4].getAttribute("symbol");
                                                                                                            ++n4;
                                                                                                        }
                                                                                                        object5.setVariables(stringArray5);
                                                                                                        object4 = ((PgPlotF)((Object)object6)).getInterval();
                                                                                                        if (psXmlNodeArray5[0].hasChild("min")) {
                                                                                                            d2 = PgJvfLoader.getRsrcAsDoubleF(psXmlNodeArray5[0], "min");
                                                                                                            ((PuIntervalDescr)((Object)object4)).setUMin(d2);
                                                                                                        }
                                                                                                        if (psXmlNodeArray5[0].hasChild("max")) {
                                                                                                            d2 = PgJvfLoader.getRsrcAsDoubleF(psXmlNodeArray5[0], "max");
                                                                                                            ((PuIntervalDescr)((Object)object4)).setUMax(d2);
                                                                                                        }
                                                                                                        if (psXmlNodeArray5[0].hasChild("discr")) {
                                                                                                            n5 = PsXmlSrc.getRsrcAsInteger((PsXmlNode)psXmlNodeArray5[0], (String)"discr");
                                                                                                            ((PuIntervalDescr)((Object)object4)).setDiscr(n5);
                                                                                                        }
                                                                                                        if ((puDoubleArray2 = this.parseParm((PsXmlNode)object7)) != null) {
                                                                                                            n4 = 0;
                                                                                                            while (n4 < puDoubleArray2.length) {
                                                                                                                object5.addParameter(puDoubleArray2[n4]);
                                                                                                                ++n4;
                                                                                                            }
                                                                                                        }
                                                                                                        if (puDoubleArray != null) {
                                                                                                            n4 = 0;
                                                                                                            while (n4 < puDoubleArray.length) {
                                                                                                                object5.addParameter(puDoubleArray[n4]);
                                                                                                                ++n4;
                                                                                                            }
                                                                                                        }
                                                                                                        ((PgPlotF)((Object)object6)).compute();
                                                                                                    }
                                                                                                    if ((object6 = PsXmlSrc.getRsrcNode((PsXmlNode)psXmlNodeArray[n], (String)"curveF")) == null) break block272;
                                                                                                    int n9 = PgJvfLoader.parseDimension((PsXmlNode)object6, 2);
                                                                                                    object5 = new PgCurveF(n9);
                                                                                                    pgGeometryIfArray[n] = object5;
                                                                                                    psXmlNodeArray4 = object6.getChildren("funExpr");
                                                                                                    puFunction2 = ((PgCurveF)((Object)object5)).getFunction();
                                                                                                    if (psXmlNodeArray4 != null && psXmlNodeArray4.length == n9) break block273;
                                                                                                    PsDebug.warning((String)"missing function elements.");
                                                                                                    break block268;
                                                                                                }
                                                                                                n4 = 0;
                                                                                                while (n4 < psXmlNodeArray4.length) {
                                                                                                    object4 = psXmlNodeArray4[n4].getContent();
                                                                                                    puFunction2.setExpression(n4, (String)object4);
                                                                                                    stringArray2 = psXmlNodeArray4[n4].getAttribute("name");
                                                                                                    if (stringArray2 != null) {
                                                                                                        puFunction2.setExpressionName(n4, (String)stringArray2);
                                                                                                    }
                                                                                                    ++n4;
                                                                                                }
                                                                                                object4 = object6.getChildren("var");
                                                                                                if (object4 != null && ((PsXmlNode[])object4).length == 1) break block274;
                                                                                                PsDebug.warning((String)"missing var elements.");
                                                                                                break block268;
                                                                                            }
                                                                                            puFunction2.setNumVariables(((PsXmlNode[])object4).length);
                                                                                            stringArray2 = new String[((PsXmlNode[])object4).length];
                                                                                            n4 = 0;
                                                                                            while (n4 < ((PsXmlNode[])object4).length) {
                                                                                                stringArray2[n4] = object4[n4].getAttribute("symbol");
                                                                                                ++n4;
                                                                                            }
                                                                                            puFunction2.setVariables(stringArray2);
                                                                                            object3 = ((PgCurveF)((Object)object5)).getInterval();
                                                                                            if (object4[0].hasChild("min")) {
                                                                                                d2 = PgJvfLoader.getRsrcAsDoubleF((PsXmlNode)object4[0], "min");
                                                                                                ((PuIntervalDescr)((Object)object3)).setUMin(d2);
                                                                                            }
                                                                                            if (object4[0].hasChild("max")) {
                                                                                                d2 = PgJvfLoader.getRsrcAsDoubleF((PsXmlNode)object4[0], "max");
                                                                                                ((PuIntervalDescr)((Object)object3)).setUMax(d2);
                                                                                            }
                                                                                            if (object4[0].hasChild("discr")) {
                                                                                                n5 = PsXmlSrc.getRsrcAsInteger((PsXmlNode)object4[0], (String)"discr");
                                                                                                ((PuIntervalDescr)((Object)object3)).setDiscr(n5);
                                                                                            }
                                                                                            if ((puDoubleArray2 = this.parseParm((PsXmlNode)object6)) != null) {
                                                                                                n4 = 0;
                                                                                                while (n4 < puDoubleArray2.length) {
                                                                                                    puFunction2.addParameter(puDoubleArray2[n4]);
                                                                                                    ++n4;
                                                                                                }
                                                                                            }
                                                                                            if (puDoubleArray != null) {
                                                                                                n4 = 0;
                                                                                                while (n4 < puDoubleArray.length) {
                                                                                                    puFunction2.addParameter(puDoubleArray[n4]);
                                                                                                    ++n4;
                                                                                                }
                                                                                            }
                                                                                            ((PgCurveF)((Object)object5)).compute();
                                                                                        }
                                                                                        if ((psXmlNode11 = PsXmlSrc.getRsrcNode((PsXmlNode)psXmlNodeArray[n], (String)"graphF")) == null) break block275;
                                                                                        object5 = new PgGraphF();
                                                                                        pgGeometryIfArray[n] = object5;
                                                                                        PsXmlNode psXmlNode15 = psXmlNode11.getChild("funExpr");
                                                                                        puFunction = ((PgGraphF)((Object)object5)).getFunction();
                                                                                        if (psXmlNode15 != null) {
                                                                                            object4 = psXmlNode15.getContent();
                                                                                            puFunction.setExpression((String)object4);
                                                                                            stringArray2 = psXmlNode15.getAttribute("name");
                                                                                            if (stringArray2 != null) {
                                                                                                puFunction.setExpressionName((String)stringArray2);
                                                                                            }
                                                                                        }
                                                                                        if ((object4 = psXmlNode11.getChildren("var")) != null && ((PuFunction)object4).length == 2) break block276;
                                                                                        PsDebug.warning((String)"missing var elements.");
                                                                                        break block268;
                                                                                    }
                                                                                    puFunction.setNumVariables(((PsXmlNode[])object4).length);
                                                                                    stringArray2 = new String[((PsXmlNode[])object4).length];
                                                                                    n4 = 0;
                                                                                    while (n4 < ((PsXmlNode[])object4).length) {
                                                                                        stringArray2[n4] = object4[n4].getAttribute("symbol");
                                                                                        ++n4;
                                                                                    }
                                                                                    puFunction.setVariables(stringArray2);
                                                                                    object3 = psXmlNode11.getChildren("flag");
                                                                                    if (object3 != null) {
                                                                                        n4 = 0;
                                                                                        while (n4 < ((String[])object3).length) {
                                                                                            String string13 = object3[n4].getAttribute("name");
                                                                                            if (string13 == null) {
                                                                                                PsDebug.warning((String)"missing name of flag.");
                                                                                            } else {
                                                                                                boolean bl;
                                                                                                boolean bl2 = bl = PgJvfLoader.parseFlag((PsXmlNode)object3[n4]) == 1;
                                                                                                if (string13.equals("Domain.Visible")) {
                                                                                                    ((PgGraphF)((Object)object5)).setShowingDomain(bl);
                                                                                                } else if (string13.equals("Domain.SynchronizeColor")) {
                                                                                                    ((PgGraphF)((Object)object5)).setEnabledSynchronization(bl);
                                                                                                } else {
                                                                                                    PsDebug.warning((String)("unknown flag = " + string13));
                                                                                                }
                                                                                            }
                                                                                            ++n4;
                                                                                        }
                                                                                    }
                                                                                    if ((psXmlNodeArray3 = psXmlNode11.getChildren("ctrl")) != null) {
                                                                                        n4 = 0;
                                                                                        while (n4 < psXmlNodeArray3.length) {
                                                                                            String string14 = psXmlNodeArray3[n4].getAttribute("name");
                                                                                            if (string14 == null) {
                                                                                                PsDebug.warning((String)"missing name of ctrl.");
                                                                                            } else {
                                                                                                pdVectorArray2 = new PuDouble(string14, (PsUpdateIf)object5);
                                                                                                piVectorArray2 = psXmlNodeArray3[n4].getAttribute("symbol");
                                                                                                if (piVectorArray2 != null) {
                                                                                                    pdVectorArray2.setSymbol((String)piVectorArray2);
                                                                                                }
                                                                                                double d3 = PgJvfLoader.getRsrcAsDoubleF(psXmlNodeArray3[n4], "min");
                                                                                                double d4 = PgJvfLoader.getRsrcAsDoubleF(psXmlNodeArray3[n4], "max");
                                                                                                pdVectorArray2.setBounds(d3, d4);
                                                                                                pdVectorArray2.setDefBounds(d3, d4, (d4 - d3) / 100.0, (d4 - d3) / 10.0);
                                                                                                d2 = PgJvfLoader.getRsrcAsDoubleF(psXmlNodeArray3[n4], "value");
                                                                                                pdVectorArray2.setValue(d2);
                                                                                                pdVectorArray2.setDefValue(d2);
                                                                                                if (string14.equals("Domain.Offset")) {
                                                                                                    ((PgGraphF)((Object)object5)).getOffsetSlider().copy((PuDouble)pdVectorArray2);
                                                                                                }
                                                                                            }
                                                                                            ++n4;
                                                                                        }
                                                                                    }
                                                                                    if ((puDoubleArray2 = this.parseParm(psXmlNode11)) != null) {
                                                                                        n4 = 0;
                                                                                        while (n4 < puDoubleArray2.length) {
                                                                                            puFunction.addParameter(puDoubleArray2[n4]);
                                                                                            ++n4;
                                                                                        }
                                                                                    }
                                                                                    if (puDoubleArray != null) {
                                                                                        n4 = 0;
                                                                                        while (n4 < puDoubleArray.length) {
                                                                                            puFunction.addParameter(puDoubleArray[n4]);
                                                                                            ++n4;
                                                                                        }
                                                                                    }
                                                                                    PgDomain pgDomain = ((PgGraphF)((Object)object5)).getDomain();
                                                                                    pdVectorArray2 = pgDomain.getDescr();
                                                                                    if (object4[0].hasChild("min")) {
                                                                                        d2 = PgJvfLoader.getRsrcAsDoubleF((PsXmlNode)object4[0], "min");
                                                                                        pdVectorArray2.setUMin(d2);
                                                                                    }
                                                                                    if (object4[0].hasChild("max")) {
                                                                                        d2 = PgJvfLoader.getRsrcAsDoubleF((PsXmlNode)object4[0], "max");
                                                                                        pdVectorArray2.setUMax(d2);
                                                                                    }
                                                                                    if (object4[0].hasChild("discr")) {
                                                                                        n5 = PsXmlSrc.getRsrcAsInteger((PsXmlNode)object4[0], (String)"discr");
                                                                                        pdVectorArray2.setNumULines(n5);
                                                                                    }
                                                                                    if (object4[1].hasChild("min")) {
                                                                                        d2 = PgJvfLoader.getRsrcAsDoubleF((PsXmlNode)object4[1], "min");
                                                                                        pdVectorArray2.setVMin(d2);
                                                                                    }
                                                                                    if (object4[1].hasChild("max")) {
                                                                                        d2 = PgJvfLoader.getRsrcAsDoubleF((PsXmlNode)object4[1], "max");
                                                                                        pdVectorArray2.setVMax(d2);
                                                                                    }
                                                                                    if (object4[1].hasChild("discr")) {
                                                                                        n5 = PsXmlSrc.getRsrcAsInteger((PsXmlNode)object4[1], (String)"discr");
                                                                                        pdVectorArray2.setNumVLines(n5);
                                                                                    }
                                                                                    pgDomain.update((Object)pdVectorArray2);
                                                                                    ((PgGraphF)((Object)object5)).update(pgDomain);
                                                                                }
                                                                                if ((object5 = PsXmlSrc.getRsrcNode((PsXmlNode)psXmlNodeArray[n], (String)"surfaceF")) == null) break block277;
                                                                                pgParmSurface = new PgParmSurface();
                                                                                pgGeometryIfArray[n] = pgParmSurface;
                                                                                psXmlNodeArray2 = object5.getChildren("funExpr");
                                                                                object4 = pgParmSurface.getFunction();
                                                                                if (psXmlNodeArray2 != null && psXmlNodeArray2.length == 3) break block278;
                                                                                PsDebug.warning((String)"missing function elements.");
                                                                                break block268;
                                                                            }
                                                                            n4 = 0;
                                                                            while (n4 < psXmlNodeArray2.length) {
                                                                                stringArray2 = psXmlNodeArray2[n4].getContent();
                                                                                object4.setExpression(n4, (String)stringArray2);
                                                                                object3 = psXmlNodeArray2[n4].getAttribute("name");
                                                                                if (object3 != null) {
                                                                                    object4.setExpressionName(n4, (String)object3);
                                                                                }
                                                                                ++n4;
                                                                            }
                                                                            stringArray2 = object5.getChildren("var");
                                                                            if (stringArray2 != null && stringArray2.length == 2) break block279;
                                                                            PsDebug.warning((String)"missing var elements.");
                                                                            break block268;
                                                                        }
                                                                        object4.setNumVariables(stringArray2.length);
                                                                        object3 = new String[stringArray2.length];
                                                                        n4 = 0;
                                                                        while (n4 < stringArray2.length) {
                                                                            object3[n4] = stringArray2[n4].getAttribute("symbol");
                                                                            ++n4;
                                                                        }
                                                                        object4.setVariables((String[])object3);
                                                                        puDoubleArray2 = this.parseParm((PsXmlNode)object5);
                                                                        if (puDoubleArray2 != null) {
                                                                            n4 = 0;
                                                                            while (n4 < puDoubleArray2.length) {
                                                                                object4.addParameter(puDoubleArray2[n4]);
                                                                                ++n4;
                                                                            }
                                                                        }
                                                                        if (puDoubleArray != null) {
                                                                            n4 = 0;
                                                                            while (n4 < puDoubleArray.length) {
                                                                                object4.addParameter(puDoubleArray[n4]);
                                                                                ++n4;
                                                                            }
                                                                        }
                                                                        PgDomainDescr pgDomainDescr = pgParmSurface.getDomainDescr();
                                                                        if (stringArray2[0].hasChild("min")) {
                                                                            d2 = PgJvfLoader.getRsrcAsDoubleF((PsXmlNode)stringArray2[0], "min");
                                                                            pgDomainDescr.setUMin(d2);
                                                                        }
                                                                        if (stringArray2[0].hasChild("max")) {
                                                                            d2 = PgJvfLoader.getRsrcAsDoubleF((PsXmlNode)stringArray2[0], "max");
                                                                            pgDomainDescr.setUMax(d2);
                                                                        }
                                                                        if (stringArray2[0].hasChild("discr")) {
                                                                            n5 = PsXmlSrc.getRsrcAsInteger((PsXmlNode)stringArray2[0], (String)"discr");
                                                                            pgDomainDescr.setNumULines(n5);
                                                                        }
                                                                        if (stringArray2[1].hasChild("min")) {
                                                                            d2 = PgJvfLoader.getRsrcAsDoubleF((PsXmlNode)stringArray2[1], "min");
                                                                            pgDomainDescr.setVMin(d2);
                                                                        }
                                                                        if (stringArray2[1].hasChild("max")) {
                                                                            d2 = PgJvfLoader.getRsrcAsDoubleF((PsXmlNode)stringArray2[1], "max");
                                                                            pgDomainDescr.setVMax(d2);
                                                                        }
                                                                        if (stringArray2[1].hasChild("discr")) {
                                                                            n5 = PsXmlSrc.getRsrcAsInteger((PsXmlNode)stringArray2[1], (String)"discr");
                                                                            pgDomainDescr.setNumVLines(n5);
                                                                        }
                                                                        pgParmSurface.update((Object)pgDomainDescr);
                                                                        pgParmSurface.compute();
                                                                    }
                                                                    pgJvxSrc = pgGeometryIfArray[n].getJvx();
                                                                    if (psAuthorInfo != null) {
                                                                        pgJvxSrc.setAuthorInfo(psAuthorInfo);
                                                                    }
                                                                    if (psGeometryInfo != null) {
                                                                        pgJvxSrc.setGeometryInfo(psGeometryInfo);
                                                                    }
                                                                    pgJvxSrc.setVersion(string);
                                                                    pgJvxSrc.setVersionType(string2);
                                                                    pgJvxSrc.setTitle(string3);
                                                                    String string15 = psXmlNodeArray[n].getAttribute("name");
                                                                    if (string15 != null) {
                                                                        pgJvxSrc.setName(string15);
                                                                    }
                                                                    pgJvxSrc.setVisible(PgJvfLoader.parseVisibility(psXmlNodeArray[n].getAttribute("visible")) != 0);
                                                                    object4 = null;
                                                                    if (psXmlNodeArray[n].hasChild("labelAtt")) {
                                                                        stringArray2 = psXmlNodeArray[n].getChild("labelAtt");
                                                                        object4 = this.parseLabelAtt((PsXmlNode)stringArray2);
                                                                        if (object4 != null) {
                                                                            pgJvxSrc.setLabelAttribute(5, (PiVector)object4);
                                                                            pgJvxSrc.showName(object4.getEntry(5) == 1);
                                                                        }
                                                                        if (stringArray2.hasChild("color")) {
                                                                            object3 = PsXmlLoader.parseColorRGB((PsXmlNode)stringArray2, (String)"color");
                                                                            pgJvxSrc.setLabelColor(5, (Color)object3);
                                                                        }
                                                                    }
                                                                    if ((stringArray2 = psXmlNodeArray[n].getChild("material")) != null) {
                                                                        PsXmlNode psXmlNode16;
                                                                        object3 = stringArray2.getAttribute("shading");
                                                                        if (object3 != null && ((String)object3).equalsIgnoreCase("gouraud")) {
                                                                            pgJvxSrc.showSmoothLighting(true);
                                                                        } else {
                                                                            pgJvxSrc.showSmoothLighting(false);
                                                                        }
                                                                        if (stringArray2.hasChild("specular")) {
                                                                            Color color = PsXmlLoader.parseColorRGB((PsXmlNode)stringArray2.getChild("specular"), (String)"color");
                                                                            pgJvxSrc.setSpecularColor(color);
                                                                        }
                                                                        if ((psXmlNode16 = stringArray2.getChild("transparency")) != null) {
                                                                            double d5 = PgJvfLoader.getRsrcAsDoubleF((PsXmlNode)stringArray2, "transparency");
                                                                            pgJvxSrc.setTransparency(d5);
                                                                            if (this.m_jvVersion < 280000) {
                                                                                pgJvxSrc.showTransparency(true);
                                                                            } else {
                                                                                pgJvxSrc.showTransparency(PgJvfLoader.parseVisibility(psXmlNode16.getAttribute("visible")) == 1);
                                                                            }
                                                                        }
                                                                    }
                                                                    Object var42_81 = null;
                                                                    psXmlNode9 = PsXmlSrc.getRsrcNode((PsXmlNode)psXmlNodeArray[n], (String)"pointSet");
                                                                    if (psXmlNode9 == null) break block280;
                                                                    string5 = psXmlNode9.getAttribute("dim");
                                                                    if (string5 == null) {
                                                                        PsDebug.warning((String)("missing dimension of geometry[" + n + "]"));
                                                                        return null;
                                                                    }
                                                                    pgJvxSrc.setDimOfVertices(Integer.parseInt(string5));
                                                                    pgJvxSrc.showVertices(PgJvfLoader.parseVisibility(psXmlNode9.getAttribute("point")) != 0);
                                                                    pgJvxSrc.showVertexColors(PgJvfLoader.parseVisibility(psXmlNode9.getAttribute("color")) == 1);
                                                                    pgJvxSrc.showVertexNormals(PgJvfLoader.parseVisibility(psXmlNode9.getAttribute("normal")) == 1);
                                                                    pgJvxSrc.showVertexNormalArrow(PgJvfLoader.parseVisibility(psXmlNode9.getAttribute("normalArrow")) == 1);
                                                                    pgJvxSrc.showVertexSizes(PgJvfLoader.parseVisibility(psXmlNode9.getAttribute("thicknesses")) == 1);
                                                                    pgJvxSrc.showTaggedVertices(PgJvfLoader.parseVisibility(psXmlNode9.getAttribute("pointMark")) != 0);
                                                                    pgJvxSrc.showVertexOutline(PgJvfLoader.parseVisibility(psXmlNode9.getAttribute("pointOutline")) != 0);
                                                                    pgJvxSrc.setType(30);
                                                                    psXmlNode8 = PsXmlSrc.getRsrcNode((PsXmlNode)psXmlNode9, (String)"points");
                                                                    if (psXmlNode8 != null) {
                                                                        Color color;
                                                                        Color color2;
                                                                        pdVectorArray = PsXmlLoader.parseDoubleList((PsXmlNode)psXmlNode8, (String)"p", (String[])stringArray);
                                                                        if (pdVectorArray != null) {
                                                                            pgJvxSrc.setDimOfVertices(pdVectorArray[0].getSize());
                                                                            pgJvxSrc.setNumVertices(pdVectorArray.length);
                                                                            pgJvxSrc.setVertices(pdVectorArray);
                                                                        } else {
                                                                            psXmlNode7 = PgJvxLoader.parseFunList((PsXmlNode)psXmlNode8, (String)"pf", (String[])stringArray);
                                                                            if (psXmlNode7 != null) {
                                                                                pgJvxSrc.setDimOfVertices(psXmlNode7[0].length);
                                                                                pgJvxSrc.setNumVertices(((String[][])psXmlNode7).length);
                                                                                pgJvxSrc.setVertexFunctions((String[][])psXmlNode7);
                                                                            }
                                                                        }
                                                                        if (psXmlNode8.hasChild("thickness")) {
                                                                            d = PgJvfLoader.getRsrcAsDoubleF(psXmlNode8, "thickness");
                                                                            pgJvxSrc.setGlobalVertexSize(d);
                                                                        }
                                                                        if ((color2 = PsXmlLoader.parseColorRGB((PsXmlNode)psXmlNode8, (String)"color")) != null) {
                                                                            pgJvxSrc.setGlobalVertexColor(color2);
                                                                        }
                                                                        if ((color = PsXmlLoader.parseColorRGB((PsXmlNode)psXmlNode8, (String)"colorTag")) != null) {
                                                                            pgJvxSrc.setGlobalVertexTagColor(color);
                                                                        }
                                                                        if (psXmlNode8.hasChild("labelAtt")) {
                                                                            psXmlNode7 = psXmlNode8.getChild("labelAtt");
                                                                            object4 = this.parseLabelAtt(psXmlNode7);
                                                                            if (object4 != null) {
                                                                                pgJvxSrc.setLabelAttribute(0, (PiVector)object4);
                                                                                pgJvxSrc.showVertexLabels(object4.getEntry(5) == 1);
                                                                            }
                                                                            if (psXmlNode7.hasChild("color")) {
                                                                                Color color3 = PsXmlLoader.parseColorRGB((PsXmlNode)psXmlNode7, (String)"color");
                                                                                pgJvxSrc.setLabelColor(0, color3);
                                                                            }
                                                                        }
                                                                    }
                                                                    if ((pdVectorArray = PsXmlSrc.getRsrcNode((PsXmlNode)psXmlNode9, (String)"colors")) != null && (colorArray = PsXmlLoader.parseColorList((PsXmlNode)pdVectorArray, (String)"c")) != null) {
                                                                        pgJvxSrc.setVertexColors(colorArray);
                                                                    }
                                                                    if ((psXmlNode7 = PsXmlSrc.getRsrcNode((PsXmlNode)psXmlNode9, (String)"normals")) != null) {
                                                                        Color color;
                                                                        pdVectorArray2 = PsXmlLoader.parseDoubleList((PsXmlNode)psXmlNode7, (String)"n", null);
                                                                        if (pdVectorArray2 != null) {
                                                                            pgJvxSrc.setVertexNormals(pdVectorArray2);
                                                                        }
                                                                        if (psXmlNode7.hasChild("thickness")) {
                                                                            d = PgJvfLoader.getRsrcAsDoubleF(psXmlNode7, "thickness");
                                                                            pgJvxSrc.setGlobalVertexNormalSize(d);
                                                                        }
                                                                        if (psXmlNode7.hasChild("length")) {
                                                                            d = PgJvfLoader.getRsrcAsDoubleF(psXmlNode7, "length");
                                                                            pgJvxSrc.setGlobalVertexNormalLength(d);
                                                                        }
                                                                        if ((color = PsXmlLoader.parseColorRGB((PsXmlNode)psXmlNode7, (String)"color")) != null) {
                                                                            pgJvxSrc.setGlobalVertexNormalColor(color);
                                                                        }
                                                                    }
                                                                    if ((psXmlNode10 = PsXmlSrc.getRsrcNode((PsXmlNode)psXmlNode9, (String)"textures")) == null) break block281;
                                                                    pgJvxSrc.showVertexTexture(PgJvfLoader.parseVisibility(psXmlNode9.getAttribute("texture")) == 1);
                                                                    object = psXmlNode10.getAttribute("blend");
                                                                    if (object == null) break block282;
                                                                    if (((String)object).equals("replace")) {
                                                                        pgJvxSrc.setBlendingMode(0);
                                                                        break block263;
                                                                    } else if (((String)object).equals("material")) {
                                                                        pgJvxSrc.setBlendingMode(1);
                                                                        break block263;
                                                                    } else {
                                                                        PsDebug.warning((String)("Unknown texture attribute: blend = " + (String)object));
                                                                    }
                                                                    break block263;
                                                                }
                                                                pgJvxSrc.setBlendingMode(0);
                                                            }
                                                            piVectorArray = psXmlNode10.getAttribute("filter");
                                                            if (piVectorArray == null) break block283;
                                                            if (!piVectorArray.equals("direct")) break block284;
                                                            pgJvxSrc.setFilterType(0);
                                                            break block264;
                                                        }
                                                        if (piVectorArray.equals("linear")) {
                                                            pgJvxSrc.setFilterType(1);
                                                            break block264;
                                                        } else if (piVectorArray.equals("quadratic")) {
                                                            pgJvxSrc.setFilterType(2);
                                                            break block264;
                                                        } else {
                                                            PsDebug.warning((String)("Unknown texture attribute: filter = " + (String)piVectorArray));
                                                        }
                                                        break block264;
                                                    }
                                                    pgJvxSrc.setFilterType(0);
                                                }
                                                pdVectorArray2 = PsXmlLoader.parseDoubleList((PsXmlNode)psXmlNode10, (String)"t", null);
                                                if (pdVectorArray2 != null) {
                                                    pgJvxSrc.setVertexTextures(pdVectorArray2);
                                                }
                                                if ((string4 = psXmlNode10.getChild("image")) != null) {
                                                    object2 = PsXmlSrc.getRsrcNode((PsXmlNode)string4, (String)"url");
                                                    if (object2 != null) {
                                                        object3 = object2.getContent();
                                                    } else {
                                                        object3 = string4.getContent();
                                                        if (object3 != null) {
                                                            PsDebug.warning((String)"Found <image> element not conforming to jvx.dtd, bug from previous JavaView.\n\tSolution: save JVX scene again with JavaView v.2.50 or later.");
                                                        }
                                                    }
                                                    String string16 = string4.getAttribute("repeat");
                                                    if (string16 != null && !"no".equals(string16)) {
                                                        PsDebug.warning((String)"repeat mode in images not supported yet.");
                                                    }
                                                    if (object3 != null) {
                                                        pgJvxSrc.setTextureImageName((String)object3);
                                                    }
                                                }
                                                if ((object2 = psXmlNode10.getChild("imageCoords")) != null && (pdVectorArray3 = PsXmlLoader.parseDoubleList((PsXmlNode)object2, (String)"p", null)) != null) {
                                                    pgJvxSrc.setTextureImageBnd(pdVectorArray3);
                                                }
                                            }
                                            if ((object = PsXmlSrc.getRsrcNode((PsXmlNode)psXmlNode9, (String)"thicknesses")) != null && (pdVectorArray2 = PsXmlLoader.parseDoubleList((PsXmlNode)object, (String)"th", null)) != null) {
                                                piVectorArray = new PdVector(pdVectorArray2.length);
                                                n3 = 0;
                                                while (n3 < pdVectorArray2.length) {
                                                    piVectorArray.setEntry(n3, pdVectorArray2[n3].getEntry(0));
                                                    ++n3;
                                                }
                                                pgJvxSrc.setVertexSizes((PdVector)piVectorArray);
                                            }
                                        }
                                        if ((string5 = PsXmlSrc.getRsrcNode((PsXmlNode)psXmlNodeArray[n], (String)"lineSet")) != null) {
                                            Color[] colorArray;
                                            PsXmlNode psXmlNode17;
                                            pgJvxSrc.showPolygonStartArrow(PgJvfLoader.parseVisibility(string5.getAttribute("arrowStart")) == 1);
                                            pgJvxSrc.showPolygonEndArrow(PgJvfLoader.parseVisibility(string5.getAttribute("arrow")) == 1);
                                            pgJvxSrc.showPolygons(PgJvfLoader.parseVisibility(string5.getAttribute("line")) != 0);
                                            boolean bl = PgJvfLoader.parseVisibility(string5.getAttribute("color")) == 1;
                                            boolean bl3 = PgJvfLoader.parseVisibility(string5.getAttribute("colorFromPoints")) == 1;
                                            pgJvxSrc.showPolygonColors(bl);
                                            pgJvxSrc.showElementFromVertexColors(bl3);
                                            if (!bl && bl3 && PgJvfLoader.parseVisibility(string5.getAttribute("color")) == -1) {
                                                PsDebug.warning((String)"Found <colorFromPoints> attribute but missing <color> attribute.\n\tSolution: save JVX scene again with JavaView v.3.50 or later.");
                                                pgJvxSrc.showPolygonColors(true);
                                            }
                                            pgJvxSrc.showPolygonNormals(PgJvfLoader.parseVisibility(string5.getAttribute("normal")) == 1);
                                            pgJvxSrc.showPolygonNormalArrow(PgJvfLoader.parseVisibility(string5.getAttribute("normalArrow")) == 1);
                                            pgJvxSrc.showPolygonSizes(PgJvfLoader.parseVisibility(string5.getAttribute("thicknesses")) == 1);
                                            pgJvxSrc.showSmoothElementColors(PgJvfLoader.parseVisibility(string5.getAttribute("colorSmooth")) == 1);
                                            pgJvxSrc.showTaggedPolygons(PgJvfLoader.parseVisibility(string5.getAttribute("lineMark")) != 0);
                                            pgJvxSrc.setType(32);
                                            psXmlNode7 = PsXmlSrc.getRsrcNode((PsXmlNode)string5, (String)"lines");
                                            if (psXmlNode7 != null) {
                                                Color color;
                                                Color color4;
                                                PiVector[] piVectorArray3 = PsXmlLoader.parseIntegerList((PsXmlNode)psXmlNode7, (String)"l", (String[])stringArray);
                                                if (piVectorArray3 != null) {
                                                    pgJvxSrc.setDimOfPolygons(-1);
                                                    pgJvxSrc.setNumPolygons(piVectorArray3.length);
                                                    pgJvxSrc.setPolygons(piVectorArray3);
                                                }
                                                if (psXmlNode7.hasChild("thickness")) {
                                                    d = PgJvfLoader.getRsrcAsDoubleF(psXmlNode7, "thickness");
                                                    pgJvxSrc.setGlobalPolygonSize(d);
                                                }
                                                if ((color4 = PsXmlLoader.parseColorRGB((PsXmlNode)psXmlNode7, (String)"color")) != null) {
                                                    pgJvxSrc.setGlobalPolygonColor(color4);
                                                }
                                                if ((color = PsXmlLoader.parseColorRGB((PsXmlNode)psXmlNode7, (String)"colorTag")) != null) {
                                                    pgJvxSrc.setGlobalPolygonTagColor(color);
                                                }
                                                if (psXmlNode7.hasChild("labelAtt")) {
                                                    object = psXmlNode7.getChild("labelAtt");
                                                    object4 = this.parseLabelAtt(psXmlNode7);
                                                    if (object4 != null) {
                                                        pgJvxSrc.setLabelAttribute(2, (PiVector)object4);
                                                        pgJvxSrc.showPolygonLabels(object4.getEntry(5) == 1);
                                                    }
                                                    if (object.hasChild("color")) {
                                                        piVectorArray = PsXmlLoader.parseColorRGB((PsXmlNode)object, (String)"color");
                                                        pgJvxSrc.setLabelColor(2, (Color)piVectorArray);
                                                    }
                                                }
                                            }
                                            if ((psXmlNode17 = PsXmlSrc.getRsrcNode((PsXmlNode)string5, (String)"colors")) != null && (colorArray = PsXmlLoader.parseColorList((PsXmlNode)psXmlNode17, (String)"c")) != null) {
                                                pgJvxSrc.setPolygonColors(colorArray);
                                            }
                                            if ((object = PsXmlSrc.getRsrcNode((PsXmlNode)string5, (String)"normals")) != null) {
                                                Color color;
                                                pdVectorArray2 = PsXmlLoader.parseDoubleList((PsXmlNode)object, (String)"n", null);
                                                if (pdVectorArray2 != null) {
                                                    pgJvxSrc.setPolygonNormals(pdVectorArray2);
                                                }
                                                if (object.hasChild("thickness")) {
                                                    d = PgJvfLoader.getRsrcAsDoubleF((PsXmlNode)object, "thickness");
                                                    pgJvxSrc.setGlobalPolygonNormalSize(d);
                                                }
                                                if (object.hasChild("length")) {
                                                    d = PgJvfLoader.getRsrcAsDoubleF((PsXmlNode)object, "length");
                                                    pgJvxSrc.setGlobalPolygonNormalLength(d);
                                                }
                                                if ((color = PsXmlLoader.parseColorRGB((PsXmlNode)object, (String)"color")) != null) {
                                                    pgJvxSrc.setGlobalPolygonNormalColor(color);
                                                }
                                            }
                                            if ((piVectorArray = PsXmlSrc.getRsrcNode((PsXmlNode)string5, (String)"thicknesses")) != null && (pdVectorArray2 = PsXmlLoader.parseDoubleList((PsXmlNode)piVectorArray, (String)"th", null)) != null) {
                                                string4 = new PdVector(pdVectorArray2.length);
                                                n3 = 0;
                                                while (n3 < pdVectorArray2.length) {
                                                    string4.setEntry(n3, pdVectorArray2[n3].getEntry(0));
                                                    ++n3;
                                                }
                                                pgJvxSrc.setPolygonSizes((PdVector)string4);
                                            }
                                        }
                                        if ((psXmlNode8 = PsXmlSrc.getRsrcNode((PsXmlNode)psXmlNodeArray[n], (String)"faceSet")) != null) {
                                            PdVector[] pdVectorArray4;
                                            boolean bl;
                                            Color[] colorArray;
                                            PsXmlNode psXmlNode18;
                                            Color[] colorArray2;
                                            pgJvxSrc.showElements(PgJvfLoader.parseVisibility(psXmlNode8.getAttribute("face")) != 0);
                                            pgJvxSrc.showEdges(PgJvfLoader.parseVisibility(psXmlNode8.getAttribute("edge")) != 0);
                                            pgJvxSrc.showElementNormals(PgJvfLoader.parseVisibility(psXmlNode8.getAttribute("normal")) == 1);
                                            pgJvxSrc.showElementNormalArrow(PgJvfLoader.parseVisibility(psXmlNode8.getAttribute("normalArrow")) == 1);
                                            boolean bl4 = PgJvfLoader.parseVisibility(psXmlNode8.getAttribute("color")) == 1;
                                            boolean bl5 = PgJvfLoader.parseVisibility(psXmlNode8.getAttribute("colorFromPoints")) == 1;
                                            pgJvxSrc.showElementColors(bl4);
                                            pgJvxSrc.showElementFromVertexColors(bl5);
                                            if (!bl4 && bl5 && PgJvfLoader.parseVisibility(psXmlNode8.getAttribute("color")) == -1) {
                                                PsDebug.warning((String)"Found <colorFromPoints> attribute but missing <color> attribute.\n\tSolution: save JVX scene again with JavaView v.3.50 or later.");
                                                pgJvxSrc.showElementColors(true);
                                            }
                                            pgJvxSrc.showElementBackColor(PgJvfLoader.parseVisibility(psXmlNode8.getAttribute("colorBackGlobal")) == 1);
                                            pgJvxSrc.showElementBackColors(PgJvfLoader.parseVisibility(psXmlNode8.getAttribute("colorBackLocal")) == 1);
                                            pgJvxSrc.showSmoothElementColors(PgJvfLoader.parseVisibility(psXmlNode8.getAttribute("colorSmooth")) == 1);
                                            pgJvxSrc.showEdgeColors(PgJvfLoader.parseVisibility(psXmlNode8.getAttribute("colorEdge")) == 1);
                                            pgJvxSrc.showEdgeColorFromElements(PgJvfLoader.parseVisibility(psXmlNode8.getAttribute("colorEdgeInduced")) == 1);
                                            boolean bl6 = PgJvfLoader.parseVisibility(psXmlNode8.getAttribute("backface")) != 0;
                                            pgJvxSrc.showBackface(bl6);
                                            pgJvxSrc.showBoundaries(PgJvfLoader.parseVisibility(psXmlNode8.getAttribute("boundary")) == 1);
                                            pgJvxSrc.showSilhouette(PgJvfLoader.parseVisibility(psXmlNode8.getAttribute("silhouette")) == 1);
                                            pgJvxSrc.showTaggedElements(PgJvfLoader.parseVisibility(psXmlNode8.getAttribute("faceMark")) != 0);
                                            pgJvxSrc.showTaggedElements(PgJvfLoader.parseVisibility(psXmlNode8.getAttribute("faceMark")) != 0);
                                            pgJvxSrc.setType(33);
                                            object = PsXmlSrc.getRsrcNode((PsXmlNode)psXmlNode8, (String)"faces");
                                            if (object != null) {
                                                Color color;
                                                Color color5;
                                                Color color6;
                                                piVectorArray = PsXmlLoader.parseIntegerList((PsXmlNode)object, (String)"f", (String[])stringArray);
                                                if (piVectorArray != null) {
                                                    pgJvxSrc.setDimOfElements(-1);
                                                    pgJvxSrc.setNumElements(piVectorArray.length);
                                                    pgJvxSrc.setElements(piVectorArray);
                                                }
                                                if ((color6 = PsXmlLoader.parseColorRGB((PsXmlNode)object, (String)"color")) != null) {
                                                    pgJvxSrc.setGlobalElementColor(color6);
                                                }
                                                if ((color5 = PsXmlLoader.parseColorRGB((PsXmlNode)object, (String)"colorBack")) != null) {
                                                    pgJvxSrc.setGlobalElementBackColor(color5);
                                                }
                                                if ((color = PsXmlLoader.parseColorRGB((PsXmlNode)object, (String)"colorTag")) != null) {
                                                    pgJvxSrc.setGlobalElementTagColor(color);
                                                }
                                                if (object.hasChild("creaseAngle")) {
                                                    double d6 = PgJvfLoader.getRsrcAsDoubleF((PsXmlNode)object, "creaseAngle");
                                                    pgJvxSrc.setCreaseAngle(d6);
                                                }
                                                if (object.hasChild("labelAtt")) {
                                                    PsXmlNode psXmlNode19 = object.getChild("labelAtt");
                                                    object4 = this.parseLabelAtt(psXmlNode19);
                                                    if (object4 != null) {
                                                        pgJvxSrc.setLabelAttribute(3, (PiVector)object4);
                                                        pgJvxSrc.showElementLabels(object4.getEntry(5) == 1);
                                                    }
                                                    if (psXmlNode19.hasChild("color")) {
                                                        object2 = PsXmlLoader.parseColorRGB((PsXmlNode)psXmlNode19, (String)"color");
                                                        pgJvxSrc.setLabelColor(3, (Color)object2);
                                                    }
                                                }
                                            }
                                            if ((piVectorArray = PsXmlSrc.getRsrcNode((PsXmlNode)psXmlNode8, (String)"neighbours")) != null) {
                                                PiVector[] piVectorArray4 = PsXmlLoader.parseIntegerList((PsXmlNode)piVectorArray, (String)"nb", null);
                                                if (piVectorArray4 != null) {
                                                    pgJvxSrc.setNeighbours(piVectorArray4);
                                                }
                                            } else {
                                                this.m_bIsEnabledOptimization = true;
                                            }
                                            if ((string4 = PsXmlSrc.getRsrcNode((PsXmlNode)psXmlNode8, (String)"edges")) != null) {
                                                Color color;
                                                Color color7;
                                                piVectorArray2 = PsXmlLoader.parseIntegerList((PsXmlNode)string4, (String)"e", null);
                                                if (piVectorArray2 != null) {
                                                    pgJvxSrc.setEdges(piVectorArray2);
                                                }
                                                if (string4.hasChild("thickness")) {
                                                    d = PgJvfLoader.getRsrcAsDoubleF((PsXmlNode)string4, "thickness");
                                                    pgJvxSrc.setGlobalEdgeSize(d);
                                                }
                                                if ((color7 = PsXmlLoader.parseColorRGB((PsXmlNode)string4, (String)"color")) != null) {
                                                    pgJvxSrc.setGlobalEdgeColor(color7);
                                                }
                                                if ((color = PsXmlLoader.parseColorRGB((PsXmlNode)string4, (String)"colorTag")) != null) {
                                                    pgJvxSrc.setGlobalEdgeTagColor(color);
                                                }
                                                if ((object2 = string4.getChild("labelAtt")) != null) {
                                                    object4 = this.parseLabelAtt((PsXmlNode)object2);
                                                    if (object4 != null) {
                                                        pgJvxSrc.setLabelAttribute(1, (PiVector)object4);
                                                        pgJvxSrc.showEdgeLabels(object4.getEntry(5) == 1);
                                                    }
                                                    if (object2.hasChild("color")) {
                                                        Color color8 = PsXmlLoader.parseColorRGB((PsXmlNode)object2, (String)"color");
                                                        pgJvxSrc.setLabelColor(1, color8);
                                                    }
                                                }
                                            }
                                            if ((object2 = PsXmlSrc.getRsrcNode((PsXmlNode)psXmlNode8, (String)"colors")) != null && (colorArray2 = PsXmlLoader.parseColorList((PsXmlNode)object2, (String)"c")) != null) {
                                                pgJvxSrc.setElementColors(colorArray2);
                                            }
                                            if ((psXmlNode18 = PsXmlSrc.getRsrcNode((PsXmlNode)psXmlNode8, (String)"colorsBack")) != null && (colorArray = PsXmlLoader.parseColorList((PsXmlNode)psXmlNode18, (String)"c")) != null) {
                                                pgJvxSrc.setElementBackColors(colorArray);
                                            }
                                            if ((pdMatrix = PsXmlSrc.getRsrcNode((PsXmlNode)psXmlNode8, (String)"normals")) != null) {
                                                Color color;
                                                pdVectorArray2 = PsXmlLoader.parseDoubleList((PsXmlNode)pdMatrix, (String)"n", null);
                                                if (pdVectorArray2 != null) {
                                                    pgJvxSrc.setElementNormals(pdVectorArray2);
                                                }
                                                if (pdMatrix.hasChild("thickness")) {
                                                    d = PgJvfLoader.getRsrcAsDoubleF((PsXmlNode)pdMatrix, "thickness");
                                                    pgJvxSrc.setGlobalElementNormalSize(d);
                                                }
                                                if (pdMatrix.hasChild("length")) {
                                                    d = PgJvfLoader.getRsrcAsDoubleF((PsXmlNode)pdMatrix, "length");
                                                    pgJvxSrc.setGlobalElementNormalLength(d);
                                                }
                                                if ((color = PsXmlLoader.parseColorRGB((PsXmlNode)pdMatrix, (String)"color")) != null) {
                                                    pgJvxSrc.setGlobalElementNormalColor(color);
                                                }
                                            } else if ((!bl6 || pgJvxSrc.isShowingElementNormals()) && pgJvxSrc.getDimOfVertices() == 3) {
                                                pgJvxSrc.makeElementNormals();
                                            }
                                            PsXmlNode psXmlNode20 = PsXmlSrc.getRsrcNode((PsXmlNode)psXmlNode8, (String)"textures");
                                            boolean bl7 = bl = PgJvfLoader.parseVisibility(psXmlNode8.getAttribute("texture")) == 1;
                                            if (psXmlNode20 != null) {
                                                pgJvxSrc.showElementTexture(bl);
                                            } else {
                                                pgJvxSrc.showVertexTexture(bl);
                                            }
                                            if (psXmlNode20 != null) {
                                                PdVector[] pdVectorArray5;
                                                PiVector[] piVectorArray5;
                                                PdVector[][] pdVectorArray6;
                                                pdVectorArray4 = PsXmlLoader.parseDoubleList((PsXmlNode)psXmlNode20, (String)"t", null);
                                                int n10 = pgJvxSrc.getNumElements();
                                                if (pdVectorArray4 != null && n10 > 0) {
                                                    pgJvxSrc.assureElementTextures();
                                                    pdVectorArray6 = pgJvxSrc.getElementTextures();
                                                    n5 = 0;
                                                    piVectorArray5 = pgJvxSrc.getElements();
                                                    n3 = 0;
                                                    while (n3 < n10) {
                                                        int n11 = piVectorArray5[n3].getSize();
                                                        int n12 = 0;
                                                        while (n12 < n11) {
                                                            pdVectorArray6[n3][n12].copy(pdVectorArray4[n5++]);
                                                            ++n12;
                                                        }
                                                        ++n3;
                                                    }
                                                    if (n5 != pdVectorArray4.length) {
                                                        PsDebug.warning((String)"element texture coordinates do not match elements.");
                                                        pgJvxSrc.setElementTextures(null);
                                                    } else {
                                                        pgJvxSrc.setVertexTextures(null);
                                                    }
                                                }
                                                if ((pdVectorArray6 = psXmlNode20.getChild("image")) != null) {
                                                    piVectorArray5 = PsXmlSrc.getRsrcNode((PsXmlNode)pdVectorArray6, (String)"url");
                                                    if (piVectorArray5 != null) {
                                                        object3 = piVectorArray5.getContent();
                                                    } else {
                                                        object3 = pdVectorArray6.getContent();
                                                        if (object3 != null) {
                                                            PsDebug.warning((String)"Found <image> element not conforming to jvx.dtd, bug from previous JavaView.\n\tSolution: save JVX scene again with JavaView v.2.50 or later.");
                                                        }
                                                    }
                                                    String string17 = pdVectorArray6.getAttribute("repeat");
                                                    if (string17 != null && !"no".equals(string17)) {
                                                        PsDebug.warning((String)"repeat mode in images not supported yet.");
                                                    }
                                                    if (object3 != null) {
                                                        pgJvxSrc.setTextureImageName((String)object3);
                                                    }
                                                }
                                                if ((piVectorArray5 = psXmlNode20.getChild("imageCoords")) != null && (pdVectorArray5 = PsXmlLoader.parseDoubleList((PsXmlNode)piVectorArray5, (String)"p", null)) != null) {
                                                    pgJvxSrc.setTextureImageBnd(pdVectorArray5);
                                                }
                                            }
                                            if ((pdVectorArray4 = PsXmlSrc.getRsrcNode((PsXmlNode)psXmlNode8, (String)"boundaries")) != null) {
                                                Color color;
                                                Color color9;
                                                if (pdVectorArray4.hasChild("thickness")) {
                                                    d = PgJvfLoader.getRsrcAsDoubleF((PsXmlNode)pdVectorArray4, "thickness");
                                                    pgJvxSrc.setGlobalBndSize(d);
                                                }
                                                if ((color9 = PsXmlLoader.parseColorRGB((PsXmlNode)pdVectorArray4, (String)"color")) != null) {
                                                    pgJvxSrc.setGlobalBndColor(color9);
                                                }
                                                if ((color = PsXmlLoader.parseColorRGB((PsXmlNode)pdVectorArray4, (String)"colorTag")) != null) {
                                                    pgJvxSrc.setGlobalBndTagColor(color);
                                                }
                                            }
                                        }
                                        if ((pdVectorArray = PsXmlSrc.getRsrcNodes((PsXmlNode)psXmlNodeArray[n], (String)"vectorField")) != null && pdVectorArray.length > 0) {
                                            pgJvxSrc.setNumVectorFields(pdVectorArray.length);
                                            pgJvxSrc.showVectorFields(true);
                                            n4 = 0;
                                            while (n4 < pdVectorArray.length) {
                                                Color[] colorArray;
                                                pgJvxSrc.setVectorFieldName(n4, pdVectorArray[n4].getAttribute("name"));
                                                String string18 = pdVectorArray[n4].getAttribute("base");
                                                if (string18 != null) {
                                                    pgJvxSrc.setVectorElementBased(n4, string18.equals("element"));
                                                }
                                                pgJvxSrc.showVectorField(n4, PgJvfLoader.parseVisibility(pdVectorArray[n4].getAttribute("vector")) != 0);
                                                pgJvxSrc.showIndividualMaterial(n4, PgJvfLoader.parseVisibility(pdVectorArray[n4].getAttribute("material")) != 0);
                                                pgJvxSrc.showVectorArrows(n4, PgJvfLoader.parseVisibility(pdVectorArray[n4].getAttribute("arrow")) == 1);
                                                pgJvxSrc.showVectorColors(n4, PgJvfLoader.parseVisibility(pdVectorArray[n4].getAttribute("color")) == 1);
                                                PsXmlNode psXmlNode21 = PsXmlSrc.getRsrcNode((PsXmlNode)pdVectorArray[n4], (String)"vectors");
                                                if (psXmlNode21 != null) {
                                                    Color color;
                                                    pdVectorArray2 = PsXmlLoader.parseDoubleList((PsXmlNode)psXmlNode21, (String)"v", (String[])stringArray);
                                                    if (pdVectorArray2 != null && (n5 = pdVectorArray2.length) > 0) {
                                                        pgJvxSrc.setNumVectors(n4, n5, pdVectorArray2[0].getSize());
                                                        pgJvxSrc.setVectors(n4, pdVectorArray2);
                                                    }
                                                    if (psXmlNode21.hasChild("thickness")) {
                                                        d = PgJvfLoader.getRsrcAsDoubleF(psXmlNode21, "thickness");
                                                        pgJvxSrc.setGlobalVectorSize(n4, d);
                                                    }
                                                    if (psXmlNode21.hasChild("length")) {
                                                        d = PgJvfLoader.getRsrcAsDoubleF(psXmlNode21, "length");
                                                        pgJvxSrc.setGlobalVectorLength(n4, d);
                                                    }
                                                    if ((color = PsXmlLoader.parseColorRGB((PsXmlNode)psXmlNode21, (String)"color")) != null) {
                                                        pgJvxSrc.setGlobalVectorColor(n4, color);
                                                    }
                                                }
                                                if ((object = PsXmlSrc.getRsrcNode((PsXmlNode)pdVectorArray[n4], (String)"colors")) != null && (colorArray = PsXmlLoader.parseColorList((PsXmlNode)object, (String)"c")) != null) {
                                                    pgJvxSrc.setVectorColors(n4, colorArray);
                                                }
                                                ++n4;
                                            }
                                        }
                                        if ((psXmlNode7 = PsXmlSrc.getRsrcNode((PsXmlNode)psXmlNodeArray[n], (String)"primitive")) != null) {
                                            PsDebug.warning((String)"parsing of primitives not implemented yet.");
                                        }
                                        if ((psXmlNode6 = psXmlNodeArray[n].getChild("transform")) == null) break block285;
                                        if (psXmlNode6.hasChild("modelMat") && (object = PsXmlLoader.parsePdMatrix((PsXmlNode)psXmlNode6, (String)"modelMat")) != null) {
                                            pgJvxSrc.setModelMatrix((PdMatrix)object);
                                        }
                                        if ((object = psXmlNode6.getChild("ambient")) == null) break block285;
                                        piVectorArray = object.getAttribute("dim");
                                        string4 = object.getAttribute("space");
                                        object2 = object.getAttribute("projection");
                                        if (string4 == null || piVectorArray == null || object2 == null) break block265;
                                        n2 = Integer.parseInt((String)piVectorArray);
                                        if (!string4.equalsIgnoreCase("euclidean")) break block286;
                                        if (n2 == 1) {
                                            pgJvxSrc.setAmbientSpace(0);
                                        } else if (n2 == 2) {
                                            pgJvxSrc.setAmbientSpace(1);
                                        } else if (n2 == 3) {
                                            pgJvxSrc.setAmbientSpace(3);
                                        } else if (n2 == 4) {
                                            pgJvxSrc.setAmbientSpace(6);
                                        } else {
                                            if (n2 != 5) {
                                                PsDebug.warning((String)"combination of ambient space and dimension not allowed");
                                                return null;
                                            }
                                            pgJvxSrc.setAmbientSpace(9);
                                        }
                                        if (((String)object2).equalsIgnoreCase("parallel")) {
                                            pgJvxSrc.setAmbientProjection(0);
                                            break block265;
                                        } else {
                                            if (!((String)object2).equalsIgnoreCase("stereographic")) {
                                                PsDebug.warning((String)"combination of ambient space and projection not allowed");
                                                return null;
                                            }
                                            pgJvxSrc.setAmbientProjection(1);
                                        }
                                        break block265;
                                    }
                                    if (!string4.equalsIgnoreCase("spherical")) break block287;
                                    if (n2 == 2) {
                                        pgJvxSrc.setAmbientSpace(2);
                                    } else if (n2 == 3) {
                                        pgJvxSrc.setAmbientSpace(4);
                                    } else if (n2 == 4) {
                                        pgJvxSrc.setAmbientSpace(7);
                                    } else {
                                        if (n2 != 5) {
                                            PsDebug.warning((String)"combination of ambient space and dimension not allowed");
                                            return null;
                                        }
                                        pgJvxSrc.setAmbientSpace(10);
                                    }
                                    if (((String)object2).equalsIgnoreCase("parallel")) {
                                        pgJvxSrc.setAmbientProjection(0);
                                        break block265;
                                    } else {
                                        if (!((String)object2).equalsIgnoreCase("stereographic")) {
                                            PsDebug.warning((String)"combination of ambient space and projection not allowed");
                                            return null;
                                        }
                                        pgJvxSrc.setAmbientProjection(1);
                                    }
                                    break block265;
                                }
                                if (!string4.equalsIgnoreCase("hyperbolic")) break block288;
                                if (n2 == 3) {
                                    pgJvxSrc.setAmbientSpace(5);
                                } else if (n2 == 4) {
                                    pgJvxSrc.setAmbientSpace(8);
                                } else {
                                    if (n2 != 5) {
                                        PsDebug.warning((String)"combination of ambient space and dimension not allowed");
                                        return null;
                                    }
                                    pgJvxSrc.setAmbientSpace(11);
                                }
                                if (!((String)object2).equalsIgnoreCase("parallel")) break block289;
                                pgJvxSrc.setAmbientProjection(0);
                                break block265;
                            }
                            if (((String)object2).equalsIgnoreCase("poincare")) {
                                pgJvxSrc.setAmbientProjection(1);
                                break block265;
                            } else if (((String)object2).equalsIgnoreCase("klein")) {
                                pgJvxSrc.setAmbientProjection(2);
                                break block265;
                            } else {
                                if (!((String)object2).equalsIgnoreCase("uhs")) {
                                    PsDebug.warning((String)"combination of ambient space and projection not allowed");
                                    return null;
                                }
                                pgJvxSrc.setAmbientProjection(3);
                            }
                            break block265;
                        }
                        if (string4.equalsIgnoreCase("lorentz")) {
                            PsDebug.warning((String)("not implemented yet, ambient space = " + string4));
                            return null;
                        }
                        PsDebug.warning((String)("unknown ambient space = " + string4));
                        return null;
                    }
                    PdMatrix pdMatrix2 = PsXmlLoader.parsePdMatrix((PsXmlNode)object, (String)"ambientMat");
                    pdMatrix = PsXmlLoader.parsePdMatrix((PsXmlNode)object, (String)"ambientInvMat");
                    if (pdMatrix2 != null && pdMatrix != null) {
                        pgJvxSrc.setAmbientMatrix(pdMatrix2, pdMatrix);
                    }
                }
                pgGeometryIfArray[n].setJvx(pgJvxSrc);
            }
            ++n;
        }
        return pgGeometryIfArray;
    }

    public PgJvxSrc[] read(BufferedReader bufferedReader) {
        PsDebug.warning((String)"method is deprecated and not longer active.");
        return null;
    }

    private static boolean hasAttribute(String string, String string2) {
        return string != null && string.equalsIgnoreCase(string2);
    }

    protected PuDouble[] parseParm(PsXmlNode psXmlNode) {
        PsXmlNode[] psXmlNodeArray = psXmlNode.getChildren("parm");
        if (psXmlNodeArray == null) {
            return null;
        }
        PuDouble[] puDoubleArray = new PuDouble[psXmlNodeArray.length];
        int n = 0;
        while (n < psXmlNodeArray.length) {
            String string = psXmlNodeArray[n].getAttribute("name");
            if (string == null) {
                string = "Slider" + String.valueOf(PsObject.getNumObjects() + 1);
            }
            puDoubleArray[n] = new PuDouble(string);
            String string2 = psXmlNodeArray[n].getAttribute("symbol");
            puDoubleArray[n].setSymbol(string2);
            double d = PgJvfLoader.getRsrcAsDoubleF(psXmlNodeArray[n], "min");
            double d2 = PgJvfLoader.getRsrcAsDoubleF(psXmlNodeArray[n], "max");
            puDoubleArray[n].setBounds(d, d2);
            puDoubleArray[n].setDefBounds(d, d2, (d2 - d) / 100.0, (d2 - d) / 10.0);
            double d3 = PgJvfLoader.getRsrcAsDoubleF(psXmlNodeArray[n], "value");
            puDoubleArray[n].setValue(d3);
            puDoubleArray[n].setDefValue(d3);
            Variable variable = Variable.make((String)string2);
            variable.setValue(d3);
            ++n;
        }
        return puDoubleArray;
    }

    public PgJvxSrc[][] getAnimations() {
        return null;
    }

    public PgJvxSrc[] getGeometries() {
        return this.m_geomArr;
    }

    public PvDisplayOption getDisplayOption() {
        return null;
    }

    public void setDisplayOption(PvDisplayOption pvDisplayOption) {
    }

    public void setAnimation(boolean bl) {
        this.m_bIsAnimation = bl;
    }

    protected static int parseVisibility(String string) {
        if (string == null) {
            return -1;
        }
        if (string.equalsIgnoreCase("show")) {
            return 1;
        }
        return 0;
    }

    protected static int parseDimension(PsXmlNode psXmlNode, int n) {
        String string = psXmlNode.getAttribute("dim");
        if (string == null) {
            PsDebug.warning((String)("missing dimension of node " + String.valueOf(psXmlNode.getClass())));
            return n;
        }
        return Integer.parseInt(string);
    }

    public boolean write(Writer writer, PgJvxSrc[] pgJvxSrcArray) {
        if (pgJvxSrcArray == null || pgJvxSrcArray.length == 0) {
            PsDebug.warning((String)"missing geometries.");
            return false;
        }
        PsXmlSrc psXmlSrc = this.fillRsrcTree(null, pgJvxSrcArray);
        if (psXmlSrc == null) {
            PsDebug.warning((String)"failed to generate XML tree");
            return false;
        }
        try {
            return PsXmlSrc.write((Writer)writer, (PsXmlSrc)psXmlSrc);
        }
        catch (IOException iOException) {
            PsDebug.warning((String)"failed to write XML tree", (Object)iOException);
            return false;
        }
    }

    public boolean load(BufferedReader bufferedReader) {
        if (bufferedReader == null) {
            PsDebug.warning((String)"missing buffered reader");
            return false;
        }
        PsXmlSrc psXmlSrc = PsXmlLoader.read((BufferedReader)bufferedReader);
        if (psXmlSrc == null) {
            PsDebug.warning((String)"failed to parse XML stream");
            return false;
        }
        this.m_specialArr = this.parseRsrcTree(psXmlSrc);
        if (this.m_specialArr == null) {
            PsDebug.warning((String)"failed to interpret JVF tree");
            return false;
        }
        return true;
    }

    public static String[][] parseFunList(PsXmlNode psXmlNode, String string, String[] stringArray) {
        PsXmlNode[] psXmlNodeArray = PsXmlSrc.getRsrcNodes((PsXmlNode)psXmlNode, (String)string);
        if (psXmlNodeArray == null || psXmlNodeArray.length == 0) {
            return null;
        }
        String[][] stringArray2 = new String[psXmlNodeArray.length][];
        int n = 0;
        while (n < psXmlNodeArray.length) {
            String string2 = psXmlNodeArray[n].getContent();
            if (string2 != null) {
                String[] stringArray3 = PuString.splitString((String)string2, (char)' ');
                stringArray2[n] = new String[stringArray3.length];
                int n2 = 0;
                while (n2 < stringArray3.length) {
                    stringArray2[n][n2] = stringArray3[n2];
                    ++n2;
                }
            }
            ++n;
        }
        return stringArray2;
    }

    protected PiVector parseLabelAtt(PsXmlNode psXmlNode) {
        if (psXmlNode == null) {
            return null;
        }
        PiVector piVector = new PiVector(6);
        String string = psXmlNode.getAttribute("visible");
        if (string != null && "hide".equalsIgnoreCase(string)) {
            piVector.setEntry(5, 0);
        } else {
            piVector.setEntry(5, 1);
        }
        String string2 = psXmlNode.getAttribute("horAlign");
        if (string2 == null || "head".equalsIgnoreCase(string2)) {
            piVector.setEntry(2, 0);
        } else if ("center".equalsIgnoreCase(string2)) {
            piVector.setEntry(2, 1);
        } else if ("tail".equalsIgnoreCase(string2)) {
            piVector.setEntry(2, 2);
        }
        String string3 = psXmlNode.getAttribute("verAlign");
        if ("bottom".equalsIgnoreCase(string3)) {
            piVector.setEntry(3, 0);
        } else if (string3 == null || "middle".equalsIgnoreCase(string3)) {
            piVector.setEntry(3, 1);
        } else if ("top".equalsIgnoreCase(string3)) {
            piVector.setEntry(3, 2);
        } else if ("head".equalsIgnoreCase(string3)) {
            PsDebug.warning((String)"Encountered void use of attribute \"verAlign\".\n\tSave JVX file with a newer JavaView such as v.2.99.030");
            piVector.setEntry(3, 1);
        }
        String string4 = psXmlNode.getAttribute("font");
        if (string4 == null || "text".equalsIgnoreCase(string4)) {
            piVector.setEntry(4, 0);
        } else if ("fixed".equalsIgnoreCase(string4)) {
            piVector.setEntry(4, 1);
        } else if ("header2".equalsIgnoreCase(string4)) {
            piVector.setEntry(4, 3);
        } else if ("header4".equalsIgnoreCase(string4)) {
            piVector.setEntry(4, 4);
        } else if ("menu".equalsIgnoreCase(string4)) {
            piVector.setEntry(4, 2);
        } else if (string4 == null) {
            piVector.setEntry(4, 0);
        }
        try {
            PsXmlNode psXmlNode2;
            PsXmlNode psXmlNode3 = PsXmlSrc.getRsrcNode((PsXmlNode)psXmlNode, (String)"xOffset");
            if (psXmlNode3 != null) {
                piVector.setEntry(0, Integer.parseInt(psXmlNode3.getContent()));
            }
            if ((psXmlNode2 = PsXmlSrc.getRsrcNode((PsXmlNode)psXmlNode, (String)"yOffset")) != null) {
                piVector.setEntry(1, Integer.parseInt(psXmlNode2.getContent()));
            }
        }
        catch (NumberFormatException numberFormatException) {
            PsDebug.warning((String)"wrong format parsing offset");
            return null;
        }
        return piVector;
    }

    public boolean isAnimation() {
        return this.m_bIsAnimation;
    }

    public static double getRsrcAsDoubleF(PsXmlNode psXmlNode, String string) {
        String string2 = PsXmlSrc.getRsrc((PsXmlNode)psXmlNode, (String)string);
        if (PuString.isEmpty((String)string2)) {
            return 0.0;
        }
        try {
            double d = new Double(string2);
            return d;
        }
        catch (NumberFormatException numberFormatException) {
            try {
                Expr expr = Parser.parse((String)string2);
                Variable.make((String)"Pi").setValue(Math.PI);
                Variable.make((String)"pi").setValue(Math.PI);
                return expr.getValue();
            }
            catch (Syntax_error syntax_error) {
                PsDebug.warning((String)("wrong format, rsrc = " + string2));
                return 0.0;
            }
        }
    }

    public PgGeometryIf[] getSpecializedGeometries() {
        return this.m_specialArr;
    }

    protected PsXmlSrc fillRsrcTree(PsXmlSrc psXmlSrc, PgJvxSrc[] pgJvxSrcArray) {
        Object object;
        Object object2;
        PsXmlNode psXmlNode;
        PsXmlNode psXmlNode2;
        if (pgJvxSrcArray == null || pgJvxSrcArray.length == 0 || pgJvxSrcArray[0] == null) {
            return null;
        }
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        boolean bl4 = true;
        boolean bl5 = true;
        boolean bl6 = true;
        boolean bl7 = true;
        if (this.m_geometryOption != null) {
            bl = this.m_geometryOption.get(0);
            bl2 = this.m_geometryOption.get(1);
            bl3 = this.m_geometryOption.get(2);
            bl4 = this.m_geometryOption.get(3);
            bl5 = this.m_geometryOption.get(4);
            bl6 = this.m_geometryOption.get(5);
            bl7 = this.m_geometryOption.get(6);
        }
        if (psXmlSrc == null) {
            psXmlSrc = new PsXmlSrc();
        }
        if ((psXmlNode2 = psXmlSrc.getRootNode()) == null) {
            psXmlNode2 = new PsXmlNode("jvf-model");
            psXmlSrc.setRootNode(psXmlNode2);
        }
        PgJvxSrc pgJvxSrc = pgJvxSrcArray[0];
        psXmlSrc.setDocName("jvf-model");
        psXmlSrc.setDocType("http://www.javaview.de/rsrc/jvf.dtd");
        if (bl) {
            psXmlNode = psXmlNode2.addChild("meta");
            psXmlNode.addAttribute("generator", PsConfig.getProgram() + " v." + PsConfig.getVersion());
            psXmlNode = psXmlNode2.addChild("meta");
            object2 = PsConfig.getVersion((int)14);
            object = String.valueOf((int)object2[0]) + ".";
            if (object2[1] < 10) {
                object = (String)object + "0";
            }
            object = (String)object + String.valueOf((int)object2[1]);
            if (object2[2] != false) {
                object = (String)object + ".";
                if (object2[2] < 10) {
                    object = (String)object + "00";
                } else if (object2[2] < 100) {
                    object = (String)object + "0";
                }
                object = (String)object + String.valueOf((int)object2[2]);
            }
            psXmlNode.addAttribute("dtd", (String)object);
            psXmlNode = psXmlNode2.addChild("meta");
            psXmlNode.addAttribute("date", new Date().toString());
            PsXmlNode psXmlNode3 = psXmlNode2.addChild("version", pgJvxSrc.getVersion());
            psXmlNode3.addAttribute("type", pgJvxSrc.getVersionType());
            if (pgJvxSrc.getTitle() != null) {
                psXmlNode2.addChild("title", pgJvxSrc.getTitle());
            } else {
                psXmlNode2.addChild("title", pgJvxSrc.getName());
            }
        }
        if (bl2 && (psXmlNode = pgJvxSrc.getAuthors()) != null && psXmlNode.getNumAuthors() > 0 && (object2 = psXmlNode.getXmlNode()) != null) {
            psXmlNode2.addChild(object2);
        }
        if (bl3 && (psXmlNode = pgJvxSrc.getGeometryInfo()) != null && (object2 = psXmlNode.getXmlNode()) != null) {
            psXmlNode2.addChild(object2);
        }
        object2 = psXmlNode2.addChild("geometries");
        if (pgJvxSrcArray != null) {
            int n = 0;
            while (n < pgJvxSrcArray.length) {
                pgJvxSrc = pgJvxSrcArray[n];
                object = object2.addChild("geometry");
                object.addAttribute("name", pgJvxSrc.getName());
                if (!pgJvxSrc.isVisible()) {
                    object.addAttribute("visible", "hide");
                }
                if (pgJvxSrc.getType() == -1) {
                    PsDebug.error((String)("geom = " + pgJvxSrc.getName() + " has unknown geometry type, JVF may not conform to jvf.dtd."));
                }
                ++n;
            }
        }
        return psXmlSrc;
    }
}

