/*
 * Decompiled with CFR 0.152.
 */
package jvx.vector;

import java.awt.Color;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgVectorField;
import jv.number.PuDouble;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.vecmath.PdVector;
import jv.vecmath.PuMath;
import jvx.geom.PwCurvature;
import jvx.numeric.PnMassMatrix;
import jvx.project.PjWorkshop;

public class PwScalarField
extends PjWorkshop {
    protected static final String[] m_scalarFieldName = new String[]{PsConfig.getMessage((int)45070), PsConfig.getMessage((int)45071), PsConfig.getMessage((int)45072), PsConfig.getMessage((boolean)true, (int)45000, (String)"t-Height"), PsConfig.getMessage((int)45073), PsConfig.getMessage((int)45074), PsConfig.getMessage((int)45075), PsConfig.getMessage((int)45076), PsConfig.getMessage((int)45075) + " (" + PsConfig.getMessage((boolean)true, (int)45000, (String)"Absolute Value") + ")", PsConfig.getMessage((int)45076) + " (" + PsConfig.getMessage((boolean)true, (int)45000, (String)"Absolute Value") + ")", PsConfig.getMessage((boolean)true, (int)45000, (String)"Difference of Principal Curvatures"), PsConfig.getMessage((int)45077)};
    public static final int SCALAR_X_HEIGHT = 0;
    public static final int SCALAR_Y_HEIGHT = 1;
    public static final int SCALAR_Z_HEIGHT = 2;
    public static final int SCALAR_T_HEIGHT = 3;
    public static final int SCALAR_GAUSS_CURVATURE = 4;
    public static final int SCALAR_MEAN_CURVATURE = 5;
    public static final int SCALAR_MAX_PRINCIPAL = 6;
    public static final int SCALAR_MIN_PRINCIPAL = 7;
    public static final int SCALAR_MAX_PRINCIPAL_ABS = 8;
    public static final int SCALAR_MIN_PRINCIPAL_ABS = 9;
    public static final int SCALAR_DIFF_PRINCIPAL = 10;
    public static final int SCALAR_EXTREMALITY = 12;
    public static final int SCALAR_FUNCTION = 11;
    protected static final int m_numScalarTypes = 12;
    protected PgElementSet m_geom;
    protected PgVectorField m_scalar;
    protected int m_defScalarField = 5;
    protected int m_scalarType;
    protected int m_basisType;
    protected boolean m_bShowColor;
    protected boolean m_bShowGradient;
    protected PgVectorField m_gradient;
    protected boolean m_bUseTotalCurv;
    protected boolean m_bChopField;
    protected PuDouble m_chopMin = new PuDouble(PsConfig.getMessage((int)54520), (PsUpdateIf)this);
    protected PuDouble m_chopMax = new PuDouble(PsConfig.getMessage((int)54521), (PsUpdateIf)this);
    protected PdVector m_backupField;
    protected boolean m_bAdjustColoring;
    protected boolean m_bNonLinColoring;
    protected PuDouble m_colorMin;
    protected PuDouble m_colorMax = new PuDouble(PsConfig.getMessage((int)54522), (PsUpdateIf)this);
    protected boolean m_bUseGrayLevel;
    protected boolean m_bUseAbsValue;
    protected boolean m_bUseSymmetricInterval;
    private static double[] m_ColorMapCurvatureIntervals = new double[]{0.05, 0.1, 0.2, 0.4, 0.45, 0.55, 0.85};
    private static double[] m_ColorMapLinearIntervals = new double[]{0.1, 0.2, 0.35, 0.5, 0.65, 0.8, 0.9};
    private static double[] m_ColorMapOldIntervals = new double[]{0.1, 0.15, 0.4, 0.5, 0.75, 0.82, 0.88};
    private static /* synthetic */ Class class$jvx$vector$PwScalarField;

    protected void computeAbsField() {
        int n = this.m_geom.getNumVertices();
        PdVector[] pdVectorArray = this.m_scalar.getVectors();
        int n2 = 0;
        while (n2 < n) {
            if (pdVectorArray[n2].m_data[0] < 0.0) {
                pdVectorArray[n2].m_data[0] = -pdVectorArray[n2].m_data[0];
            }
            ++n2;
        }
    }

    protected void restoreField() {
        PdVector[] pdVectorArray = this.m_scalar.getVectors();
        int n = this.m_scalar.getNumVectors();
        int n2 = 0;
        while (n2 < n) {
            pdVectorArray[n2].m_data[0] = this.m_backupField.m_data[n2];
            ++n2;
        }
    }

    public static Color colorMapGray(double d) {
        if (d < 0.0) {
            d = 0.0;
        }
        if (d > 1.0) {
            d = 1.0;
        }
        float f = (float)d;
        return new Color(f, f, f);
    }

    public static Color colorMap(double d) {
        float f;
        float f2;
        if (d < 0.0) {
            d = 0.0;
        }
        if (d > 1.0) {
            d = 1.0;
        }
        if (d < m_ColorMapLinearIntervals[0]) {
            d /= m_ColorMapLinearIntervals[0];
            d *= m_ColorMapOldIntervals[0];
        } else {
            int n = m_ColorMapOldIntervals.length;
            int n2 = 1;
            while (n2 < n) {
                if (d < m_ColorMapLinearIntervals[n2]) {
                    d -= m_ColorMapLinearIntervals[n2 - 1];
                    d /= m_ColorMapLinearIntervals[n2] - m_ColorMapLinearIntervals[n2 - 1];
                    d *= m_ColorMapOldIntervals[n2] - m_ColorMapOldIntervals[n2 - 1];
                    d += m_ColorMapOldIntervals[n2 - 1];
                    break;
                }
                ++n2;
            }
        }
        if (d > 0.2) {
            f2 = 1.0f;
            f = (float)(0.75 - (d -= 0.2));
            if (f < 0.0f) {
                f += 1.0f;
            }
        } else {
            f = 0.75f;
            d *= 5.0;
            d = d * d * d;
            f2 = (float)d;
        }
        return Color.getHSBColor(f, f2, 1.0f);
    }

    public void reset() {
        super.reset();
        if (this.m_geom != null && this.m_geomSave != null) {
            this.m_geom.copy((PsObject)this.m_geomSave);
        }
        this.setGeometry(this.m_geom);
    }

    public PgVectorField computeGradient(PgVectorField pgVectorField) {
        int n = this.m_geom.getDimOfVertices();
        if (pgVectorField == null) {
            pgVectorField = new PgVectorField(n);
        }
        pgVectorField.setName(PsConfig.getMessage((int)45078) + " " + m_scalarFieldName[this.m_scalarType]);
        pgVectorField.computeGradient(this.m_geom, this.m_scalar.getVectors(), 0);
        this.m_geom.addVectorField(pgVectorField);
        return pgVectorField;
    }

    protected void showFunctionAsVertexLabels(boolean bl) {
        int n = this.m_geom.getNumVertices();
        PdVector[] pdVectorArray = this.m_geom.getVertices();
        PdVector[] pdVectorArray2 = this.m_scalar.getVectors();
        if (bl) {
            int n2 = 0;
            while (n2 < n) {
                pdVectorArray[n2].setName(Double.toString(pdVectorArray2[n2].m_data[0]));
                ++n2;
            }
            return;
        }
        int n3 = 0;
        while (n3 < n) {
            pdVectorArray[n3].setName(Integer.toString(n3));
            ++n3;
        }
    }

    public PwScalarField() {
        super(PsConfig.getMessage((int)54519));
        this.m_colorMin = new PuDouble(PsConfig.getMessage((int)54523), (PsUpdateIf)this);
        if (((Object)((Object)this)).getClass() == (class$jvx$vector$PwScalarField != null ? class$jvx$vector$PwScalarField : (class$jvx$vector$PwScalarField = PwScalarField.class$("jvx.vector.PwScalarField")))) {
            this.init();
        }
    }

    protected void chopField() {
        int n = this.m_scalar.getNumVectors();
        PdVector[] pdVectorArray = this.m_scalar.getVectors();
        double d = this.m_chopMin.getValue();
        double d2 = this.m_chopMax.getValue();
        int n2 = 0;
        while (n2 < n) {
            pdVectorArray[n2].m_data[0] = this.m_backupField.m_data[n2] < d ? d : (this.m_backupField.m_data[n2] > d2 ? d2 : this.m_backupField.m_data[n2]);
            ++n2;
        }
    }

    public static PgVectorField array2ScalarField(PgPointSet pgPointSet, double[] dArray, PgVectorField pgVectorField) {
        if (pgPointSet == null) {
            PsDebug.warning((String)"specified domain is null.");
            return pgVectorField;
        }
        int n = pgPointSet.getNumVertices();
        if (dArray == null || dArray.length != n) {
            PsDebug.warning((String)"length of array specifying a piecewise linear function, does not match with the number of vertices of the domain.");
            return pgVectorField;
        }
        if (pgVectorField == null) {
            pgVectorField = new PgVectorField(1);
        }
        pgVectorField.setBasedOn(0);
        if (pgPointSet != pgVectorField.getGeometry()) {
            pgVectorField.setGeometry(pgPointSet);
        }
        PdVector[] pdVectorArray = pgVectorField.getVectors();
        int n2 = 0;
        while (n2 < n) {
            pdVectorArray[n2].m_data[0] = dArray[n2];
            ++n2;
        }
        return pgVectorField;
    }

    public static Color colorMap_backup(double d) {
        float f;
        float f2;
        if (d < 0.0) {
            d = 0.0;
        }
        if (d > 1.0) {
            d = 1.0;
        }
        if (d < m_ColorMapLinearIntervals[0]) {
            d /= m_ColorMapLinearIntervals[0];
            d *= m_ColorMapOldIntervals[0];
        } else {
            int n = m_ColorMapOldIntervals.length;
            int n2 = 1;
            while (n2 < n) {
                if (d < m_ColorMapLinearIntervals[n2]) {
                    d -= m_ColorMapLinearIntervals[n2 - 1];
                    d /= m_ColorMapLinearIntervals[n2] - m_ColorMapLinearIntervals[n2 - 1];
                    d *= m_ColorMapOldIntervals[n2] - m_ColorMapOldIntervals[n2 - 1];
                    d += m_ColorMapOldIntervals[n2 - 1];
                    break;
                }
                ++n2;
            }
        }
        if (d > 0.2) {
            f2 = 1.0f;
            f = (float)(0.75 - (d -= 0.2));
            if (f < 0.0f) {
                f += 1.0f;
            }
        } else {
            f = 0.75f;
            d *= 5.0;
            d = d * d * d;
            f2 = (float)d;
        }
        return Color.getHSBColor(f, f2, 1.0f);
    }

    public boolean update(Object object) {
        if (object == this.m_geom) {
            if (this.isUpdateSender()) {
                return true;
            }
            if (this.isModal()) {
                return true;
            }
            this.setGeometry(this.m_geom);
            return true;
        }
        if (object == this) {
            this.computeScalar(this.m_geom, this.m_scalarType);
            this.adjustChopSliders();
            this.m_chopMin.update((Object)this.m_chopMin);
            this.m_chopMax.update((Object)this.m_chopMax);
            if (this.m_bAdjustColoring) {
                this.adjustColorSliders();
                this.m_colorMax.update((Object)this.m_colorMax);
                this.m_colorMin.update((Object)this.m_colorMin);
            }
            this.updateGradient();
            if (this.m_bShowColor) {
                this.updateColor();
            }
            if (this.m_bChopField) {
                this.chopField();
            }
            this.m_bUpdateSender = true;
            this.m_geom.update((Object)this.m_geom);
            this.m_bUpdateSender = false;
            return super.update((Object)this);
        }
        if (object == this.m_chopMin || object == this.m_chopMax) {
            if (!this.m_bChopField) {
                return true;
            }
            this.chopField();
            this.updateGradient();
            this.updateColor();
            this.m_scalar.update((Object)this.m_scalar);
            this.m_geom.update((Object)this.m_geom);
            return true;
        }
        if (object == this.m_colorMax || object == this.m_colorMin) {
            if (this.m_bUseSymmetricInterval) {
                if (object == this.m_colorMax) {
                    this.m_colorMin.setValue(-this.m_colorMax.getValue());
                    this.m_colorMin.updatePanels((Object)this.m_colorMin);
                } else {
                    this.m_colorMax.setValue(-this.m_colorMin.getValue());
                    this.m_colorMax.updatePanels((Object)this.m_colorMax);
                }
            }
            this.updateColor();
            this.m_geom.update((Object)this.m_geom);
            return true;
        }
        return super.update(object);
    }

    protected void symmetrizeColorSliders() {
        double d;
        if (this.m_bUseAbsValue) {
            return;
        }
        double d2 = this.m_colorMax.getMax();
        if (d2 < -(d = this.m_colorMax.getMin())) {
            this.m_colorMin.setBounds(d, -d);
            this.m_colorMax.setBounds(d, -d);
        } else {
            this.m_colorMin.setBounds(-d2, d2);
            this.m_colorMax.setBounds(-d2, d2);
        }
        d2 = this.m_colorMax.getValue();
        d = this.m_colorMin.getValue();
        if (d2 < -d) {
            this.m_colorMax.setValue(-d);
            return;
        }
        this.m_colorMin.setValue(-d2);
    }

    public void setGeometry(PgElementSet pgElementSet) {
        super.setGeometry((PgGeometry)pgElementSet);
        this.m_geom = pgElementSet;
        int n = this.m_geom.getNumVectorFields();
        this.m_scalar = null;
        int n2 = 0;
        while (n2 < n) {
            PgVectorField pgVectorField = this.m_geom.getVectorField(n2);
            if (pgVectorField.getDimOfVectors() == 1) {
                this.m_scalar = pgVectorField;
                this.m_scalarType = 11;
                break;
            }
            ++n2;
        }
        if (this.m_scalar == null) {
            this.m_scalar = new PgVectorField(1);
            this.m_scalar.setType(this.m_basisType);
            this.m_scalar.setGeometry((PgPointSet)this.m_geom);
            this.m_scalar.setVisible(false);
            this.m_geom.addVectorField(this.m_scalar);
        }
        this.computeScalar(this.m_geom, this.m_scalarType);
        this.adjustChopSliders();
        this.adjustColorSliders();
        this.m_chopMin.update((Object)this.m_chopMin);
        this.m_chopMax.update((Object)this.m_chopMax);
        this.m_colorMax.update((Object)this.m_colorMax);
        this.m_colorMin.update((Object)this.m_colorMin);
        this.m_geom.update((Object)this.m_geom);
    }

    protected void updateColor() {
        int n = this.m_scalar.getNumVectors();
        if (n <= 0) {
            return;
        }
        PdVector[] pdVectorArray = this.m_scalar.getVectors();
        double d = this.m_colorMax.getValue();
        double d2 = this.m_colorMin.getValue();
        double d3 = 0.0;
        if (d - d2 > 1.0E-10) {
            d3 = 1.0 / (d - d2);
        }
        if (this.m_bNonLinColoring) {
            int n2 = 0;
            while (n2 < n) {
                double d4 = (pdVectorArray[n2].m_data[0] - d2) * d3;
                if (d4 < 1.0 && d4 > 0.0) {
                    d4 = 1.0 - (Math.cos(Math.PI * d4) + 1.0) / 2.0;
                }
                if (!this.m_bUseGrayLevel) {
                    this.m_geom.setVertexColor(n2, PwScalarField.colorMapCurvature(d4));
                } else {
                    this.m_geom.setVertexColor(n2, PwScalarField.colorMapGray(d4));
                }
                ++n2;
            }
            return;
        }
        int n3 = 0;
        while (n3 < n) {
            double d5 = (pdVectorArray[n3].m_data[0] - d2) * d3;
            if (!this.m_bUseGrayLevel) {
                this.m_geom.setVertexColor(n3, PwScalarField.colorMap(d5));
            } else {
                this.m_geom.setVertexColor(n3, PwScalarField.colorMapGray(d5));
            }
            ++n3;
        }
    }

    protected void backupField() {
        PdVector[] pdVectorArray = this.m_scalar.getVectors();
        int n = this.m_scalar.getNumVectors();
        if (this.m_backupField == null) {
            this.m_backupField = new PdVector(n);
        } else if (this.m_backupField.m_data.length < n) {
            this.m_backupField.setSize(n);
        }
        int n2 = 0;
        while (n2 < n) {
            this.m_backupField.m_data[n2] = pdVectorArray[n2].m_data[0];
            ++n2;
        }
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public int getScalarType() {
        return this.m_scalarType;
    }

    public void setScalarType(int n) {
        this.m_scalarType = n;
    }

    public String getScalarName(int n) {
        return m_scalarFieldName[n];
    }

    public boolean computeScalar(PgElementSet pgElementSet, int n) {
        if (n < 0 || n >= 12) {
            PsDebug.warning((String)("scalar type out of bounds, type = " + n));
            return false;
        }
        PdVector pdVector = null;
        if (n == 0 || n == 1 || n == 2 || n == 3) {
            pdVector = new PdVector(pgElementSet.getDimOfVertices());
        }
        switch (n) {
            case 0: {
                pdVector.setEntry(0, 1.0);
                break;
            }
            case 1: {
                pdVector.setEntry(1, 1.0);
                break;
            }
            case 2: {
                pdVector.setEntry(2, 1.0);
                break;
            }
            case 3: {
                pdVector.setEntry(3, 1.0);
                break;
            }
            default: {
                return false;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
        }
        int n2 = pgElementSet.getNumVertices();
        PdVector[] pdVectorArray = this.m_scalar.getVectors();
        if (n == 0 || n == 1 || n == 2 || n == 3) {
            PdVector[] pdVectorArray2 = pgElementSet.getBounds();
            if (pdVectorArray2 == null) {
                PsDebug.warning((String)"missing bounding box");
                return false;
            }
            int n3 = 0;
            while (n3 < n2) {
                double d;
                pdVectorArray[n3].m_data[0] = d = PdVector.dot((PdVector)pdVector, (PdVector)pgElementSet.getVertex(n3));
                ++n3;
            }
        } else if (n == 4) {
            PdVector pdVector2 = new PdVector(n2);
            PwCurvature.getGaussCurvature(pgElementSet, pdVector2);
            int n4 = 0;
            while (n4 < n2) {
                pdVectorArray[n4].m_data[0] = pdVector2.m_data[n4];
                ++n4;
            }
            if (!this.m_bUseTotalCurv) {
                PnMassMatrix.multInvMassMatrix(this.m_geom, this.m_scalar.getVectors(), true);
            }
        } else if (n == 5) {
            PdVector pdVector3 = new PdVector(n2);
            PwCurvature.getMeanCurvature(pgElementSet, pdVector3);
            int n5 = 0;
            while (n5 < n2) {
                pdVectorArray[n5].m_data[0] = pdVector3.m_data[n5] / 2.0;
                ++n5;
            }
            if (!this.m_bUseTotalCurv) {
                PnMassMatrix.multInvMassMatrix(this.m_geom, this.m_scalar.getVectors(), true);
            }
        } else if (n == 6) {
            PdVector[] pdVectorArray3 = PdVector.realloc(null, (int)2, (int)n2);
            PwCurvature.getPrincipalCurvatures(pgElementSet, pdVectorArray3, null);
            int n6 = 0;
            while (n6 < n2) {
                pdVectorArray[n6].m_data[0] = pdVectorArray3[0].m_data[n6];
                ++n6;
            }
            if (!this.m_bUseTotalCurv) {
                PnMassMatrix.multInvMassMatrix(this.m_geom, this.m_scalar.getVectors(), true);
            }
        } else if (n == 7) {
            PdVector[] pdVectorArray4 = PdVector.realloc(null, (int)2, (int)n2);
            PwCurvature.getPrincipalCurvatures(pgElementSet, pdVectorArray4, null);
            int n7 = 0;
            while (n7 < n2) {
                pdVectorArray[n7].m_data[0] = pdVectorArray4[1].m_data[n7];
                ++n7;
            }
            if (!this.m_bUseTotalCurv) {
                PnMassMatrix.multInvMassMatrix(this.m_geom, this.m_scalar.getVectors(), true);
            }
        } else if (n == 8) {
            PdVector[] pdVectorArray5 = PdVector.realloc(null, (int)2, (int)n2);
            PwCurvature.getPrincipalCurvatures(pgElementSet, pdVectorArray5, null);
            int n8 = 0;
            while (n8 < n2) {
                pdVectorArray[n8].m_data[0] = Math.abs(pdVectorArray5[0].m_data[n8]) >= Math.abs(pdVectorArray5[1].m_data[n8]) ? pdVectorArray5[0].m_data[n8] : pdVectorArray5[1].m_data[n8];
                ++n8;
            }
            if (!this.m_bUseTotalCurv) {
                PnMassMatrix.multInvMassMatrix(this.m_geom, this.m_scalar.getVectors(), true);
            }
        } else if (n == 9) {
            PdVector[] pdVectorArray6 = PdVector.realloc(null, (int)2, (int)n2);
            PwCurvature.getPrincipalCurvatures(pgElementSet, pdVectorArray6, null);
            int n9 = 0;
            while (n9 < n2) {
                pdVectorArray[n9].m_data[0] = Math.abs(pdVectorArray6[0].m_data[n9]) >= Math.abs(pdVectorArray6[1].m_data[n9]) ? pdVectorArray6[1].m_data[n9] : pdVectorArray6[0].m_data[n9];
                ++n9;
            }
            if (!this.m_bUseTotalCurv) {
                PnMassMatrix.multInvMassMatrix(this.m_geom, this.m_scalar.getVectors(), true);
            }
        } else if (n == 10) {
            PdVector[] pdVectorArray7 = PdVector.realloc(null, (int)2, (int)n2);
            PwCurvature.getPrincipalCurvatures(pgElementSet, pdVectorArray7, null);
            int n10 = 0;
            while (n10 < n2) {
                pdVectorArray[n10].m_data[0] = Math.abs(Math.abs(pdVectorArray7[0].m_data[n10]) - Math.abs(pdVectorArray7[1].m_data[n10]));
                ++n10;
            }
            if (!this.m_bUseTotalCurv) {
                PnMassMatrix.multInvMassMatrix(this.m_geom, this.m_scalar.getVectors(), true);
            }
        } else if (n == 12) {
            // empty if block
        }
        this.m_scalar.setName(m_scalarFieldName[n]);
        this.backupField();
        if (this.m_bUseAbsValue) {
            this.computeAbsField();
        }
        return true;
    }

    protected void resetColors() {
        if (this.m_geomSave != null && this.m_geomSave instanceof PgElementSet) {
            PgElementSet pgElementSet = (PgElementSet)this.m_geomSave;
            this.m_geom.showElementColors(pgElementSet.isShowingElementColors());
            this.m_geom.showElementFromVertexColors(pgElementSet.isShowingElementFromVertexColors());
            this.m_geom.showElementBackColor(pgElementSet.isShowingElementBackColor());
        }
    }

    public void init() {
        super.init();
        this.m_scalarType = this.m_defScalarField;
        this.m_basisType = 0;
        this.m_bChopField = false;
        this.m_bUseTotalCurv = false;
        this.m_bShowGradient = false;
        this.m_bShowColor = true;
        this.m_bAdjustColoring = true;
        this.m_bUseGrayLevel = false;
        this.m_bUseAbsValue = false;
        this.m_bNonLinColoring = false;
        this.m_bUseSymmetricInterval = false;
        this.m_chopMax.init();
        this.m_chopMin.init();
        this.m_chopMax.setEnabled(this.m_bChopField);
        this.m_chopMin.setEnabled(this.m_bChopField);
        this.m_colorMax.init();
        this.m_colorMin.init();
        if (this.m_scalar != null) {
            this.m_scalar.init();
            this.m_scalar.setType(this.m_basisType);
        }
    }

    protected void updateGradient() {
        if (this.m_bShowGradient) {
            this.m_gradient = this.computeGradient(this.m_gradient);
            this.m_geom.addVectorField(this.m_gradient);
        }
        if (this.m_gradient != null) {
            this.m_gradient.setVisible(this.m_bShowGradient);
        }
    }

    public static double[] scalarField2Array(PgVectorField pgVectorField, double[] dArray) {
        if (pgVectorField == null) {
            PsDebug.warning((String)"given scalar field is null.");
            return dArray;
        }
        int n = pgVectorField.getNumVectors();
        if (dArray == null || dArray.length != n) {
            dArray = new double[n];
        }
        PdVector[] pdVectorArray = pgVectorField.getVectors();
        int n2 = 0;
        while (n2 < n) {
            dArray[n2] = pdVectorArray[n2].m_data[0];
            ++n2;
        }
        return dArray;
    }

    protected void adjustChopSliders() {
        int n = this.m_scalar.getNumVectors();
        if (n < 1) {
            return;
        }
        PdVector[] pdVectorArray = this.m_scalar.getVectors();
        int[] nArray = new int[n];
        PuMath.heapsort((int)n, (double[])PwScalarField.scalarField2Array(this.m_scalar, null), (int[])nArray);
        double d = 0.0;
        double d2 = pdVectorArray[nArray[n - 1 - n / 10]].m_data[0];
        if (!this.m_bUseAbsValue) {
            d = pdVectorArray[nArray[n / 10]].m_data[0];
        }
        double d3 = d2 - d;
        double d4 = pdVectorArray[nArray[n - 1]].m_data[0];
        double d5 = 0.0;
        if (!this.m_bUseAbsValue) {
            d5 = pdVectorArray[nArray[0]].m_data[0];
        }
        this.m_chopMin.setBounds(d5, d4, d3 / 100.0, d3 / 10.0);
        this.m_chopMax.setBounds(d5, d4, d3 / 100.0, d3 / 10.0);
        if (!this.m_bChopField) {
            this.m_chopMax.setValue(d2);
            this.m_chopMin.setValue(d);
        }
    }

    protected void adjustColorSliders() {
        double d;
        double d2;
        int n = this.m_scalar.getNumVectors();
        if (n < 1) {
            return;
        }
        PdVector[] pdVectorArray = this.m_scalar.getVectors();
        double d3 = 0.0;
        int n2 = this.m_scalarType;
        if (n2 == 4 || n2 == 5 || n2 == 6 || n2 == 7 || n2 == 10 || n2 == 12) {
            int[] nArray = new int[n];
            PuMath.heapsort((int)n, (double[])PwScalarField.scalarField2Array(this.m_scalar, null), (int[])nArray);
            d2 = pdVectorArray[nArray[n - 1 - n / 10]].m_data[0];
            if (!this.m_bUseAbsValue) {
                d3 = pdVectorArray[nArray[n / 10]].m_data[0];
            }
            if (this.m_bUseSymmetricInterval && !this.m_bUseAbsValue) {
                if (d2 < -d3) {
                    d2 = -d3;
                } else {
                    d3 = -d2;
                }
            }
            d = d2 - d3;
        } else {
            d2 = d3 = pdVectorArray[0].m_data[0];
            int n3 = 1;
            while (n3 < n) {
                if (pdVectorArray[n3].m_data[0] < d3) {
                    d3 = pdVectorArray[n3].m_data[0];
                } else if (pdVectorArray[n3].m_data[0] > d2) {
                    d2 = pdVectorArray[n3].m_data[0];
                }
                ++n3;
            }
            if (this.m_bUseAbsValue) {
                d3 = 0.0;
            }
            if (this.m_bUseSymmetricInterval && !this.m_bUseAbsValue) {
                if (d2 < -d3) {
                    d2 = -d3;
                } else {
                    d3 = -d2;
                }
            }
            d = d2 - d3;
        }
        this.m_colorMin.setBounds(d3 - d, d2 + d, d / 33.0, d / 3.0);
        this.m_colorMax.setBounds(d3 - d, d2 + d, d / 33.0, d / 3.0);
        this.m_colorMax.setValue(d2);
        this.m_colorMin.setValue(d3);
    }

    public void cancel() {
        this.resetColors();
        super.cancel();
    }

    private static final Color colorMapCurvature(double d) {
        float f;
        float f2;
        if (d < 0.0) {
            d = 0.0;
        }
        if (d > 1.0) {
            d = 1.0;
        }
        if (d < m_ColorMapCurvatureIntervals[0]) {
            d /= m_ColorMapCurvatureIntervals[0];
            d *= m_ColorMapOldIntervals[0];
        } else {
            int n = m_ColorMapOldIntervals.length;
            int n2 = 1;
            while (n2 < n) {
                if (d < m_ColorMapCurvatureIntervals[n2]) {
                    d -= m_ColorMapCurvatureIntervals[n2 - 1];
                    d /= m_ColorMapCurvatureIntervals[n2] - m_ColorMapCurvatureIntervals[n2 - 1];
                    d *= m_ColorMapOldIntervals[n2] - m_ColorMapOldIntervals[n2 - 1];
                    d += m_ColorMapOldIntervals[n2 - 1];
                    break;
                }
                ++n2;
            }
        }
        if (d > 0.2) {
            f2 = 1.0f;
            f = (float)(0.75 - (d -= 0.2));
            if (f < 0.0f) {
                f += 1.0f;
            }
        } else {
            f = 0.75f;
            d *= 5.0;
            d = d * d * d;
            f2 = (float)d;
        }
        return Color.getHSBColor(f, f2, 1.0f);
    }

    protected PgVectorField get3dVectorfield() {
        PgVectorField pgVectorField = new PgVectorField(3);
        pgVectorField.setBasedOn(0);
        pgVectorField.setGeometry((PgPointSet)this.m_geom);
        pgVectorField.setName("3d Field: " + this.m_scalar.getName());
        int n = this.m_geom.getNumVertices();
        this.m_geom.assureVertexNormals();
        PdVector[] pdVectorArray = this.m_geom.getVertexNormals();
        PdVector[] pdVectorArray2 = this.m_scalar.getVectors();
        PdVector[] pdVectorArray3 = pgVectorField.getVectors();
        int n2 = 0;
        while (n2 < n) {
            pdVectorArray3[n2].multScalar(pdVectorArray[n2], pdVectorArray2[n2].m_data[0]);
            ++n2;
        }
        return pgVectorField;
    }
}

