/*
 * Decompiled with CFR 0.152.
 */
package jvx.numeric;

import jv.geom.PgElementSet;
import jv.object.PsDebug;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuVectorGeom;
import jvx.numeric.PnEnergy;

public class PnVolumeEnergy
extends PnEnergy {
    protected int m_noe;
    protected PdVector m_origin;
    protected PdVector m_normal;
    protected PdVector[] m_v;
    private static /* synthetic */ Class class$jvx$numeric$PnVolumeEnergy;

    public boolean setSurface(PgElementSet pgElementSet, PgElementSet pgElementSet2) {
        if (pgElementSet2 == null) {
            PsDebug.warning((String)"missing surface geometry.");
            return false;
        }
        if (!super.setSurface(pgElementSet, pgElementSet2)) {
            return false;
        }
        if (this.m_surface.getDimOfElements() != 3) {
            PsDebug.warning((String)("surface=" + this.m_surface.getName() + " not triangulated"));
            PgElementSet.triangulate((PgElementSet)this.m_surface);
        }
        this.m_v = PdVector.realloc((PdVector[])this.m_v, (int)3, (int)this.m_dim);
        this.m_noe = this.m_surface.getNumElements();
        this.m_normal = new PdVector(this.m_dim);
        this.m_origin = new PdVector(this.m_dim);
        this.m_origin.setConstant(0.0);
        return true;
    }

    public PnVolumeEnergy() {
        if (((Object)((Object)this)).getClass() == (class$jvx$numeric$PnVolumeEnergy != null ? class$jvx$numeric$PnVolumeEnergy : (class$jvx$numeric$PnVolumeEnergy = PnVolumeEnergy.class$("jvx.numeric.PnVolumeEnergy")))) {
            this.init();
        }
    }

    public PdVector evalGradient(PdVector pdVector, PdVector pdVector2) {
        double d;
        int n;
        if (pdVector2 == null) {
            if (this.m_store == null || this.m_store.getSize() == 0 && pdVector.getSize() != 0) {
                PsDebug.warning((String)"PnEnergy not initialized, cannot evaluate gradient");
                return null;
            }
            pdVector2 = this.m_store;
        }
        pdVector2.setConstant(0.0);
        PiVector[] piVectorArray = this.m_surface.getElements();
        int n2 = 0;
        double d2 = 0.0;
        int n3 = 0;
        while (n3 < this.m_noe) {
            int n4 = 0;
            do {
                n2 = this.m_dim * piVectorArray[n3].getEntry(n4);
                n = 0;
                while (n < this.m_dim) {
                    this.m_v[n4].m_data[n] = pdVector.m_data[n2++];
                    ++n;
                }
            } while (++n4 < 3);
            this.m_normal.normalOfPlane(this.m_v[0], this.m_v[1], this.m_v[2]);
            d = -PuVectorGeom.distOfPointToPlane((PdVector)this.m_origin, (PdVector)this.m_v[0], (PdVector)this.m_normal);
            double d3 = PdVector.area((PdVector[])this.m_v);
            d2 += d3 * d / 3.0;
            ++n3;
        }
        n3 = 0;
        while (n3 < this.m_noe) {
            int n5 = 0;
            do {
                n2 = this.m_dim * piVectorArray[n3].getEntry(n5);
                n = 0;
                while (n < this.m_dim) {
                    this.m_v[n5].m_data[n] = pdVector.m_data[n2++];
                    ++n;
                }
            } while (++n5 < 3);
            this.m_normal.normalOfPlane(this.m_v[0], this.m_v[1], this.m_v[2]);
            d = d2 * PdVector.area((PdVector[])this.m_v) / 3.0;
            int n6 = 0;
            do {
                n2 = this.m_dim * piVectorArray[n3].getEntry(n6);
                int n7 = 0;
                while (n7 < this.m_dim) {
                    int n8 = n2++;
                    pdVector2.m_data[n8] = pdVector2.m_data[n8] + d * this.m_normal.m_data[n7];
                    ++n7;
                }
            } while (++n6 < 3);
            ++n3;
        }
        return this.constrainGradient(pdVector, pdVector2);
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void init() {
        super.init();
        this.m_v = null;
    }

    public double eval(PdVector pdVector) {
        PiVector[] piVectorArray = this.m_surface.getElements();
        int n = 0;
        double d = 0.0;
        int n2 = 0;
        while (n2 < this.m_noe) {
            int n3 = 0;
            do {
                n = this.m_dim * piVectorArray[n2].getEntry(n3);
                int n4 = 0;
                while (n4 < this.m_dim) {
                    this.m_v[n3].m_data[n4] = pdVector.m_data[n++];
                    ++n4;
                }
            } while (++n3 < 3);
            this.m_normal.normalOfPlane(this.m_v[0], this.m_v[1], this.m_v[2]);
            double d2 = -PuVectorGeom.distOfPointToPlane((PdVector)this.m_origin, (PdVector)this.m_v[0], (PdVector)this.m_normal);
            double d3 = PdVector.area((PdVector[])this.m_v);
            d += d3 * d2 / 3.0;
            ++n2;
        }
        return d * d;
    }

    public void initSurface(PgElementSet pgElementSet, PgElementSet pgElementSet2) {
    }
}

