/*
 * Decompiled with CFR 0.152.
 */
package jvx.numeric;

import jv.geom.PgElementSet;
import jv.geom.PgVectorField;
import jv.object.PsDebug;
import jv.vecmath.PdBary;
import jv.vecmath.PdBaryDir;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.geom.PwBary;
import jvx.numeric.PnGeodesicRK;

public class PnVertexRK
extends PnGeodesicRK {
    protected PdBaryDir[][] m_vec;

    public PnVertexRK(PgElementSet pgElementSet) {
        super(pgElementSet);
        if (pgElementSet.getDimOfElements() != 3) {
            throw new IllegalArgumentException("geometry is no triangulation");
        }
        this.m_vec = null;
    }

    public void setVectorField(PdBaryDir[][] pdBaryDirArray) {
        this.m_vec = pdBaryDirArray;
    }

    public void setVectorField(PgVectorField pgVectorField) {
        int n = pgVectorField.getNumVectors();
        int n2 = this.m_geom.getNumElements();
        this.m_vec = new PdBaryDir[n2][3];
        PdVector[] pdVectorArray = pgVectorField.getVectors();
        PiVector[] piVectorArray = this.m_geom.getElements();
        int n3 = 0;
        while (n3 < n2) {
            int n4 = piVectorArray[n3].getSize();
            int n5 = 0;
            while (n5 < n4) {
                int n6 = piVectorArray[n3].getEntry(n5);
                if (n6 < n) {
                    this.m_vec[n3][n5] = new PdBaryDir(3);
                    PwBary.projectOntoElement(this.m_geom, n3, pdVectorArray[n6], this.m_vec[n3][n5]);
                }
                ++n5;
            }
            ++n3;
        }
    }

    public void eval(int n, PdBary pdBary, PdBaryDir pdBaryDir) {
        if (pdBary == null || pdBary.getSize() < 3) {
            PsDebug.warning((String)"works only with triangle barys");
            return;
        }
        if (pdBaryDir == null) {
            PsDebug.warning((String)"output parameter is null - doing nothing");
            return;
        }
        pdBaryDir.setSize(3);
        int n2 = 0;
        do {
            pdBaryDir.m_data[n2] = 0.0;
            int n3 = 0;
            do {
                int n4 = n2;
                pdBaryDir.m_data[n4] = pdBaryDir.m_data[n4] + pdBary.m_data[n3] * this.m_vec[n][n3].m_data[n2];
            } while (++n3 < 3);
        } while (++n2 < 3);
        if (this.m_bInvert) {
            n2 = 0;
            do {
                pdBaryDir.m_data[n2] = -pdBaryDir.m_data[n2];
            } while (++n2 < 3);
        }
    }
}

