/*
 * Decompiled with CFR 0.152.
 */
package jvx.numeric;

import jv.geom.PgElementSet;
import jv.geom.PgVectorField;
import jv.object.PsDebug;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.numeric.PnDiriEnergy;

public class PnHodgeW
extends PnDiriEnergy {
    protected PgVectorField m_vf;
    protected PdVector[][] m_JgradFi;
    protected PiVector m_bndInd;
    protected PdVector m_areas = new PdVector(0);
    private static /* synthetic */ Class class$jvx$numeric$PnHodgeW;

    public boolean setSurface(PgElementSet pgElementSet, PgElementSet pgElementSet2) {
        int n;
        super.setSurface(pgElementSet, pgElementSet2);
        int n2 = pgElementSet.getNumElements();
        int n3 = pgElementSet.getDimOfVertices();
        if (this.m_JgradFi == null || this.m_JgradFi.length != n2) {
            this.m_JgradFi = new PdVector[n2][];
            n = 0;
            while (n < n2) {
                this.m_JgradFi[n] = PdVector.realloc(null, (int)3, (int)n3);
                ++n;
            }
        }
        this.computeJGradients();
        this.m_bndInd = new PiVector(this.m_nop - this.m_noiv);
        n = 0;
        int n4 = 0;
        while (n4 < this.m_nop) {
            if (this.m_invIndex[n4] == -1) {
                this.m_bndInd.setEntry(n, n4);
                ++n;
            }
            ++n4;
        }
        return true;
    }

    public PnHodgeW() {
        if (((Object)((Object)this)).getClass() == (class$jvx$numeric$PnHodgeW != null ? class$jvx$numeric$PnHodgeW : (class$jvx$numeric$PnHodgeW = PnHodgeW.class$("jvx.numeric.PnHodgeW")))) {
            this.init();
        }
    }

    public void setVectorField(PgVectorField pgVectorField) {
        this.m_vf = pgVectorField;
    }

    protected void computeJGradients() {
        if (this.m_domain == null) {
            PsDebug.warning((String)"Missing domain.");
            return;
        }
        int n = this.m_domain.getNumElements();
        PiVector[] piVectorArray = this.m_domain.getElements();
        PdVector[] pdVectorArray = this.m_domain.getVertices();
        this.m_areas.setSize(n);
        int n2 = 0;
        while (n2 < n) {
            int[] nArray = piVectorArray[n2].m_data;
            double d = this.m_domain.getAreaOfElement(n2);
            this.m_areas.setEntry(n2, d);
            int n3 = 0;
            do {
                this.m_JgradFi[n2][n3].sub(pdVectorArray[nArray[(n3 + 2) % 3]], pdVectorArray[nArray[(n3 + 1) % 3]]);
                this.m_JgradFi[n2][n3].multScalar(-1.0 / (2.0 * d));
            } while (++n3 < 3);
            ++n2;
        }
    }

    public PdVector evalGradient(PdVector pdVector, PdVector pdVector2) {
        int n;
        int n2;
        pdVector2 = super.evalGradient(pdVector, pdVector2);
        PdVector[] pdVectorArray = this.m_vf.getVectors();
        int n3 = this.m_domain.getNumElements();
        if (pdVectorArray != null && pdVectorArray.length == n3) {
            PiVector[] piVectorArray = this.m_domain.getElements();
            n2 = 0;
            while (n2 < n3) {
                int[] nArray = piVectorArray[n2].m_data;
                double d = this.m_areas.getEntry(n2);
                n = 0;
                do {
                    int n4 = nArray[n];
                    pdVector2.m_data[n4] = pdVector2.m_data[n4] - PdVector.dot((PdVector)this.m_JgradFi[n2][n], (PdVector)pdVectorArray[n2]) * d;
                } while (++n < 3);
                ++n2;
            }
        }
        if (this.m_zeroGradient) {
            int n5 = this.m_bndInd.getSize();
            n2 = 0;
            while (n2 < n5) {
                n = this.m_dim * this.m_bndInd.getEntry(n2);
                int n6 = 0;
                while (n6 < this.m_dim) {
                    pdVector2.m_data[n + n6] = 0.0;
                    ++n6;
                }
                ++n2;
            }
        }
        return pdVector2;
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void init() {
        super.init();
    }

    public PdVector[][] getJGradFi() {
        return this.m_JgradFi;
    }

    public double eval(PdVector pdVector) {
        double d = super.eval(pdVector);
        int n = this.m_domain.getNumElements();
        PiVector[] piVectorArray = this.m_domain.getElements();
        PdVector[] pdVectorArray = this.m_vf.getVectors();
        int n2 = this.m_domain.getDimOfVertices();
        PdVector pdVector2 = new PdVector(n2);
        if (pdVectorArray != null && pdVectorArray.length == n) {
            int n3 = 0;
            while (n3 < n) {
                pdVector2.setConstant(0.0);
                int n4 = 0;
                do {
                    int n5 = piVectorArray[n3].m_data[n4];
                    int n6 = 0;
                    while (n6 < n2) {
                        int n7 = n6;
                        pdVector2.m_data[n7] = pdVector2.m_data[n7] + pdVector.m_data[this.m_dim * n5] * this.m_JgradFi[n3][n4].m_data[n6];
                        ++n6;
                    }
                } while (++n4 < 3);
                double d2 = this.m_areas.getEntry(n3);
                d -= PdVector.dot((PdVector)pdVector2, (PdVector)pdVectorArray[n3]) * d2;
                ++n3;
            }
        }
        return d;
    }

    public void initSurface(PgElementSet pgElementSet, PgElementSet pgElementSet2) {
        if (this.m_stiffMatrix == null) {
            PsDebug.warning((String)"Missing m_stiffMatrix, call setSurface before.");
            return;
        }
        super.initSurface(pgElementSet, pgElementSet2);
    }
}

