/*
 * Decompiled with CFR 0.152.
 */
package jvx.numeric;

import jv.geom.PgElementSet;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuVectorGeom;
import jvx.geom.PwCurvature;
import jvx.numeric.PnEnergy;

public class PnGaussEnergy
extends PnEnergy {
    protected int m_noe;
    protected PdVector[] m_v;
    protected PdVector[] m_cVec;
    protected PdVector m_cLen;
    protected PdVector m_cSin;
    protected PdVector[] m_JcVec;
    protected PdVector m_grad;
    protected PdVector m_gauss;
    protected PgElementSet m_geomClone;
    private static /* synthetic */ Class class$jvx$numeric$PnGaussEnergy;

    public boolean setSurface(PgElementSet pgElementSet, PgElementSet pgElementSet2) {
        if (pgElementSet2 == null) {
            PsDebug.warning((String)"missing surface geometry.");
            return false;
        }
        if (!super.setSurface(pgElementSet, pgElementSet2)) {
            return false;
        }
        if (this.m_surface.getDimOfElements() != 3) {
            PsDebug.warning((String)("surface=" + this.m_surface.getName() + " not triangulated"));
            PgElementSet.triangulate((PgElementSet)this.m_surface);
        }
        if (this.m_geomClone == null) {
            this.m_geomClone = (PgElementSet)this.m_surface.clone();
        } else {
            this.m_geomClone.copy((PsObject)this.m_surface);
        }
        if (this.m_v == null || this.m_v[0].getSize() != this.m_dim) {
            this.m_v = PdVector.realloc((PdVector[])this.m_v, (int)3, (int)this.m_dim);
            this.m_cVec = PdVector.realloc((PdVector[])this.m_cVec, (int)3, (int)this.m_dim);
            this.m_cLen = new PdVector(3);
            this.m_cSin = new PdVector(3);
            this.m_JcVec = PdVector.realloc((PdVector[])this.m_JcVec, (int)3, (int)this.m_dim);
            this.m_grad = new PdVector(this.m_dim);
            this.m_gauss = new PdVector();
        }
        this.m_gauss.setSize(pgElementSet2.getNumVertices());
        this.m_noe = this.m_surface.getNumElements();
        return true;
    }

    public PnGaussEnergy() {
        if (((Object)((Object)this)).getClass() == (class$jvx$numeric$PnGaussEnergy != null ? class$jvx$numeric$PnGaussEnergy : (class$jvx$numeric$PnGaussEnergy = PnGaussEnergy.class$("jvx.numeric.PnGaussEnergy")))) {
            this.init();
        }
    }

    public PdVector evalGradient(PdVector pdVector, PdVector pdVector2) {
        if (pdVector2 == null) {
            if (this.m_store == null || this.m_store.getSize() == 0 && pdVector.getSize() != 0) {
                PsDebug.warning((String)"PnEnergy not initialized, cannot evaluate gradient");
                return null;
            }
            pdVector2 = this.m_store;
        }
        pdVector2.setConstant(0.0);
        PdVector[] pdVectorArray = this.m_geomClone.getVertices();
        int n = this.m_geomClone.getNumVertices();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < this.m_dim) {
                pdVectorArray[n3].m_data[n4] = pdVector.m_data[n2++];
                ++n4;
            }
            ++n3;
        }
        PwCurvature.getGaussCurvature(this.m_geomClone, this.m_gauss);
        PiVector[] piVectorArray = this.m_geomClone.getElements();
        PdVector pdVector3 = new PdVector(3);
        double[] dArray = pdVector3.m_data;
        boolean bl = false;
        int n5 = 0;
        while (n5 < this.m_noe) {
            int n6 = 0;
            do {
                n2 = this.m_dim * piVectorArray[n5].getEntry(n6);
                int n7 = 0;
                while (n7 < this.m_dim) {
                    this.m_v[n6].m_data[n7] = pdVector.m_data[n2++];
                    ++n7;
                }
            } while (++n6 < 3);
            PuVectorGeom.ctg((double[])dArray, (PdVector)this.m_v[0], (PdVector)this.m_v[1], (PdVector)this.m_v[2]);
            if (!bl && pdVector3.maxAbs() > 10000.0) {
                bl = true;
                PsDebug.warning((String)("ctg out of range, first in elem = " + n5));
            }
            n6 = 0;
            do {
                this.m_cVec[n6].sub(this.m_v[(n6 + 2) % 3], this.m_v[(n6 + 1) % 3]);
                this.m_cLen.setEntry(n6, this.m_cVec[n6].length());
            } while (++n6 < 3);
            double d = this.m_geomClone.getAreaOfElement(n5);
            int n8 = 0;
            do {
                this.m_cSin.setEntry(n8, 2.0 * d / (this.m_cLen.getEntry((n8 + 2) % 3) * this.m_cLen.getEntry((n8 + 1) % 3)));
            } while (++n8 < 3);
            n8 = 0;
            do {
                this.m_JcVec[(n8 + 1) % 3].blend(-dArray[n8], this.m_cVec[n8], dArray[(n8 + 2) % 3], this.m_cVec[(n8 + 2) % 3]);
            } while (++n8 < 3);
            int n9 = 0;
            do {
                n8 = piVectorArray[n5].getEntry(n9);
                n2 = this.m_dim * n8;
                this.m_grad.sub(this.m_cVec[(n9 + 2) % 3], this.m_cVec[(n9 + 1) % 3]);
                this.m_grad.blendBase(this.m_grad, dArray[n9], this.m_JcVec[n9]);
                this.m_grad.multScalar(-2.0 * this.m_cSin.getEntry(n9) * this.m_gauss.getEntry(n8) / (this.m_cLen.getEntry((n9 + 2) % 3) * this.m_cLen.getEntry((n9 + 1) % 3)));
                int n10 = 0;
                while (n10 < this.m_dim) {
                    int n11 = n2++;
                    pdVector2.m_data[n11] = pdVector2.m_data[n11] + this.m_grad.m_data[n10];
                    ++n10;
                }
                int n12 = piVectorArray[n5].getEntry((n9 + 1) % 3);
                n2 = this.m_dim * n8;
                this.m_grad.copy(this.m_JcVec[(n9 + 2) % 3]);
                this.m_grad.multScalar(2.0 * this.m_gauss.getEntry(n12) / (this.m_cLen.getEntry((n9 + 2) % 3) * this.m_cLen.getEntry((n9 + 2) % 3)));
                n10 = 0;
                while (n10 < this.m_dim) {
                    int n13 = n2++;
                    pdVector2.m_data[n13] = pdVector2.m_data[n13] + this.m_grad.m_data[n10];
                    ++n10;
                }
                n12 = piVectorArray[n5].getEntry((n9 + 2) % 3);
                n2 = this.m_dim * n8;
                this.m_grad.copy(this.m_JcVec[(n9 + 1) % 3]);
                this.m_grad.multScalar(2.0 * this.m_gauss.getEntry(n12) / (this.m_cLen.getEntry((n9 + 1) % 3) * this.m_cLen.getEntry((n9 + 1) % 3)));
                n10 = 0;
                while (n10 < this.m_dim) {
                    int n14 = n2++;
                    pdVector2.m_data[n14] = pdVector2.m_data[n14] + this.m_grad.m_data[n10];
                    ++n10;
                }
            } while (++n9 < 3);
            ++n5;
        }
        return this.constrainGradient(pdVector, pdVector2);
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void init() {
        super.init();
        this.m_v = null;
        this.m_cVec = null;
        this.m_cLen = null;
        this.m_cSin = null;
        this.m_JcVec = null;
        this.m_grad = null;
        this.m_gauss = null;
    }

    public double eval(PdVector pdVector) {
        PdVector[] pdVectorArray = this.m_geomClone.getVertices();
        int n = this.m_geomClone.getNumVertices();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < this.m_dim) {
                pdVectorArray[n3].m_data[n4] = pdVector.m_data[n2++];
                ++n4;
            }
            ++n3;
        }
        PwCurvature.getGaussCurvature(this.m_geomClone, this.m_gauss);
        double d = 0.0;
        int n5 = 0;
        while (n5 < n) {
            double d2 = this.m_gauss.getEntry(n5);
            d += d2 * d2;
            ++n5;
        }
        return d;
    }

    public void initSurface(PgElementSet pgElementSet, PgElementSet pgElementSet2) {
    }
}

