/*
 * Decompiled with CFR 0.152.
 */
package jvx.numeric;

import jv.geom.PgBndConstraint;
import jv.geom.PgBndPolygon;
import jv.geom.PgElementSet;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jvx.numeric.PnAlignmentEnergy;
import jvx.numeric.PnFunction;
import jvx.numeric.PnJacobi;
import jvx.numeric.PnMatrix;
import jvx.numeric.PnStiffDiriNonConforming;
import jvx.numeric.PnStiffMatrix;

public abstract class PnEnergy
extends PnFunction {
    protected PgElementSet m_domain;
    protected PgElementSet m_surface;
    protected int m_nop;
    protected int m_noiv;
    protected int m_dim;
    protected PnStiffMatrix m_stiffMatrix;
    protected PgBndPolygon[] m_bndList;
    protected PdVector m_store = new PdVector();
    private PdVector m_vertexGrad;
    private PdMatrix m_subConstrain;
    protected PdMatrix m_constrain;
    protected boolean m_bTangential;
    protected boolean m_bNormal;
    protected int[] m_index;
    protected int[] m_invIndex;
    protected boolean m_zeroGradient = true;
    protected boolean m_bUseConstrainMatrix = false;
    protected boolean m_bFixMarkedVertices = false;
    private static /* synthetic */ Class class$jvx$numeric$PnEnergy;

    private void projectOntoNull(double[] dArray, int n) {
        int n2 = 0;
        while (n2 < this.m_dim) {
            dArray[n + n2] = 0.0;
            ++n2;
        }
    }

    private void projectOntoNull(PdMatrix pdMatrix, int n, int n2) {
        int n3 = n * n2;
        int n4 = 0;
        while (n4 < n) {
            pdMatrix.m_data[n3 + n4][n3 + n4] = 0.0;
            ++n4;
        }
    }

    public void testEigenvalues() {
        PdMatrix pdMatrix = this.evalHessian(null);
        PsDebug.message((String)(PsConfig.getMessage((int)63006) + " Q \n" + pdMatrix.toString()));
        PdMatrix pdMatrix2 = this.m_surface.getL2Matrix(null);
        PsDebug.message((String)PsConfig.getMessage((int)63007));
        PsDebug.message((String)pdMatrix2.toString());
        PdMatrix pdMatrix3 = new PdMatrix(this.m_noiv);
        int n = 0;
        while (n < this.m_noiv) {
            int n2 = 0;
            while (n2 < this.m_noiv) {
                pdMatrix3.m_data[n][n2] = pdMatrix2.m_data[this.m_index[n]][this.m_index[n2]];
                ++n2;
            }
            ++n;
        }
        PsDebug.message((String)("S\n" + pdMatrix3.toString()));
        PdMatrix pdMatrix4 = new PdMatrix(this.m_noiv);
        PnMatrix.invert(pdMatrix4.m_data, pdMatrix3.m_data, this.m_noiv);
        PdMatrix pdMatrix5 = new PdMatrix(this.m_noiv);
        pdMatrix5.copy(pdMatrix4);
        pdMatrix5.rightMult(pdMatrix3);
        PsDebug.message((String)("SInv*S\n" + pdMatrix5.toString()));
        PdVector pdVector = new PdVector(this.m_noiv);
        PdVector[] pdVectorArray = PdVector.realloc(null, (int)this.m_noiv, (int)this.m_noiv);
        PnJacobi.computeEigenvectors(pdMatrix3, this.m_noiv, pdVector, pdVectorArray);
        n = 0;
        while (n < this.m_noiv) {
            pdVectorArray[n].multScalar(1.0 / Math.sqrt(pdVector.m_data[n]));
            ++n;
        }
        PdMatrix pdMatrix6 = new PdMatrix(this.m_noiv);
        pdMatrix6.setColumns(pdVectorArray);
        PsDebug.message((String)("m\n" + pdMatrix6.toString()));
        PdMatrix pdMatrix7 = new PdMatrix(this.m_noiv);
        PnMatrix.invert(pdMatrix7.m_data, pdMatrix6.m_data, this.m_noiv);
        PdMatrix pdMatrix8 = new PdMatrix(this.m_noiv);
        pdMatrix8.mult(pdMatrix7, pdMatrix4);
        PdMatrix pdMatrix9 = PdMatrix.expandComponents((PdMatrix)pdMatrix8, (int)this.m_dim);
        PdMatrix pdMatrix10 = PdMatrix.expandComponents((PdMatrix)pdMatrix6, (int)this.m_dim);
        PdMatrix pdMatrix11 = new PdMatrix(this.m_dim * this.m_noiv);
        pdMatrix11.mult(pdMatrix9, pdMatrix);
        PdMatrix pdMatrix12 = new PdMatrix(this.m_dim * this.m_noiv);
        pdMatrix12.mult(pdMatrix11, pdMatrix10);
        PsDebug.message((String)("mInv*SInv*Q*mBig\n" + pdMatrix12.toString()));
        pdVector = new PdVector(this.m_dim * this.m_noiv);
        pdVectorArray = PdVector.realloc(null, (int)(this.m_dim * this.m_noiv), (int)(this.m_dim * this.m_noiv));
        PnJacobi.computeEigenvectors(pdMatrix12, this.m_dim * this.m_noiv, pdVector, pdVectorArray);
        n = 0;
        while (n < this.m_dim * this.m_noiv) {
            pdVectorArray[n].leftMultMatrix(pdMatrix10);
            pdVectorArray[n].normalize();
            ++n;
        }
        PsDebug.message((String)PsConfig.getMessage((int)63008));
        PnJacobi.printEigenvectors(this.m_dim * this.m_noiv, pdVector, pdVectorArray);
    }

    public boolean setSurface(PgElementSet pgElementSet, PgElementSet pgElementSet2) {
        if (pgElementSet2 == null) {
            PsDebug.warning((String)"missing surface geometry");
            return false;
        }
        this.m_domain = pgElementSet;
        this.m_surface = pgElementSet2;
        int n = 0;
        int n2 = 0;
        this.m_dim = pgElementSet2.getDimOfVertices();
        this.m_nop = pgElementSet2.getNumVertices();
        this.m_bndList = pgElementSet2.getBoundaries();
        PdVector[] pdVectorArray = pgElementSet2.getVertices();
        this.m_store.setSize(this.m_dim * this.m_nop);
        if (this.m_bUseConstrainMatrix) {
            this.m_vertexGrad.setSize(this.m_dim);
        }
        pgElementSet2.markBoundary();
        int n3 = pgElementSet2.getNumBoundaryVertices();
        if (this.m_bUseConstrainMatrix) {
            n3 = 0;
        }
        this.m_noiv = this.m_nop - n3;
        this.m_index = new int[this.m_noiv];
        this.m_invIndex = new int[this.m_nop];
        n2 = 0;
        n = 0;
        while (n < this.m_nop) {
            if (!this.m_bUseConstrainMatrix && pdVectorArray[n].hasTag(14)) {
                this.m_invIndex[n] = -1;
            } else {
                this.m_invIndex[n] = n2;
                this.m_index[n2] = n;
                ++n2;
            }
            ++n;
        }
        if (this.m_noiv != n2) {
            PsDebug.warning((String)("error: m_noiv = " + this.m_noiv + " != " + n2 + " = ipos"));
            return false;
        }
        if (this.m_bUseConstrainMatrix) {
            this.m_subConstrain.setSize(this.m_dim);
            this.m_constrain.setSize(this.m_dim * this.m_nop);
            this.getConstrainMatrix(this.m_constrain);
        }
        return true;
    }

    public void setZeroGradientAtBounds(boolean bl) {
        this.m_zeroGradient = bl;
    }

    public boolean getZeroGradientAtBounds() {
        return this.m_zeroGradient;
    }

    private void projectOntoPlane(double[] dArray, int n, PdVector pdVector) {
        double d = 0.0;
        int n2 = 0;
        while (n2 < this.m_dim) {
            d += dArray[n + n2] * pdVector.m_data[n2];
            ++n2;
        }
        n2 = 0;
        while (n2 < this.m_dim) {
            int n3 = n + n2;
            dArray[n3] = dArray[n3] - d * pdVector.m_data[n2];
            ++n2;
        }
    }

    private void projectOntoPlane(PdMatrix pdMatrix, int n, int n2, PdVector pdVector) {
        this.m_subConstrain.adjoint(pdVector);
        int n3 = n * n2;
        int n4 = 0;
        while (n4 < n) {
            int n5 = 0;
            while (n5 < n) {
                double[] dArray = pdMatrix.m_data[n3 + n4];
                int n6 = n3 + n5;
                dArray[n6] = dArray[n6] - this.m_subConstrain.m_data[n4][n5];
                ++n5;
            }
            ++n4;
        }
    }

    public PnEnergy() {
        if (((Object)((Object)this)).getClass() == (class$jvx$numeric$PnEnergy != null ? class$jvx$numeric$PnEnergy : (class$jvx$numeric$PnEnergy = PnEnergy.class$("jvx.numeric.PnEnergy")))) {
            this.init();
        }
    }

    protected PdVector constrainGradient(PdVector pdVector, PdVector pdVector2) {
        int n;
        PdVector pdVector3;
        PdVector[] pdVectorArray;
        if (pdVector == null) {
            PsDebug.warning((String)"Missing coordinate array.");
            return null;
        }
        if (!(this.m_bTangential && this.m_bNormal || !this.m_surface.hasVertexNormals())) {
            pdVectorArray = this.m_surface.getVertexNormals();
            pdVector3 = new PdVector(this.m_dim);
            int n2 = 0;
            n = 0;
            while (n < this.m_nop) {
                int n3;
                pdVector3.set(pdVector2, n2, this.m_dim);
                double d = PdVector.dot((PdVector)pdVector3, (PdVector)pdVectorArray[n]);
                if (!this.m_bTangential) {
                    n3 = 0;
                    while (n3 < this.m_dim) {
                        pdVector2.m_data[n2 + n3] = d * pdVectorArray[n].m_data[n3];
                        ++n3;
                    }
                }
                if (!this.m_bNormal) {
                    n3 = 0;
                    while (n3 < this.m_dim) {
                        int n4 = n2 + n3;
                        pdVector2.m_data[n4] = pdVector2.m_data[n4] - d * pdVectorArray[n].m_data[n3];
                        ++n3;
                    }
                }
                n2 += this.m_dim;
                ++n;
            }
        }
        if (this.m_bFixMarkedVertices) {
            pdVectorArray = this.m_surface.getVertices();
            n = 0;
            while (n < this.m_nop) {
                if (pdVectorArray[n].hasTag(1)) {
                    this.projectOntoNull(pdVector2.m_data, this.m_dim * n);
                }
                ++n;
            }
        }
        if ((this.m_bndList == null || this.m_bndList.length == 0) && this.m_zeroGradient) {
            n = 0;
            while (n < this.m_nop) {
                if (this.m_invIndex[n] == -1) {
                    this.projectOntoNull(pdVector2.m_data, this.m_dim * n);
                }
                ++n;
            }
        } else {
            int n5 = 0;
            while (n5 < this.m_bndList.length) {
                if (!this.m_bndList[n5].hasTag(2)) {
                    PdVector pdVector4;
                    pdVector3 = this.m_bndList[n5].getBndConstraint();
                    if (pdVector3 == null) {
                        return pdVector2;
                    }
                    int n6 = this.m_bndList[n5].getNumVertices();
                    int[] nArray = this.m_bndList[n5].getVertexInd().m_data;
                    if (pdVector3.hasShape(3)) {
                        n = 0;
                        while (n < n6) {
                            this.projectOntoNull(pdVector2.m_data, this.m_dim * nArray[n]);
                            ++n;
                        }
                    } else if (pdVector3.hasShape(4)) {
                        pdVector4 = pdVector3.m_dir;
                        if (!(this instanceof PnAlignmentEnergy) && !(this.m_stiffMatrix instanceof PnStiffDiriNonConforming)) {
                            this.projectOntoNull(pdVector2.m_data, this.m_dim * nArray[0]);
                            if (nArray[0] != nArray[n6 - 1]) {
                                this.projectOntoNull(pdVector2.m_data, this.m_dim * nArray[n6 - 1]);
                            }
                            n = 1;
                            while (n < n6 - 1) {
                                this.projectOntoLine(pdVector2.m_data, this.m_dim * nArray[n], pdVector4);
                                ++n;
                            }
                        } else {
                            n = 0;
                            while (n < n6) {
                                this.projectOntoLine(pdVector2.m_data, this.m_dim * nArray[n], pdVector4);
                                ++n;
                            }
                        }
                    } else if (pdVector3.hasShape(5) || pdVector3.hasShape(11)) {
                        pdVector4 = pdVector3.m_dir;
                        PdVector pdVector5 = pdVector3.m_startDir;
                        PdVector pdVector6 = pdVector3.m_endDir;
                        if (pdVector5 == null) {
                            this.projectOntoPlane(pdVector2.m_data, this.m_dim * nArray[0], pdVector4);
                        } else if (pdVector5.sqrLength() > 1.0E-10) {
                            this.projectOntoLine(pdVector2.m_data, this.m_dim * nArray[0], pdVector5);
                        } else {
                            this.projectOntoNull(pdVector2.m_data, this.m_dim * nArray[0]);
                        }
                        if (nArray[0] != nArray[n6 - 1]) {
                            if (pdVector6 == null) {
                                this.projectOntoPlane(pdVector2.m_data, this.m_dim * nArray[n6 - 1], pdVector4);
                            } else if (pdVector6.sqrLength() > 1.0E-10) {
                                this.projectOntoLine(pdVector2.m_data, this.m_dim * nArray[n6 - 1], pdVector6);
                            } else {
                                this.projectOntoNull(pdVector2.m_data, this.m_dim * nArray[n6 - 1]);
                            }
                        }
                        n = 1;
                        while (n < n6 - 1) {
                            this.projectOntoPlane(pdVector2.m_data, this.m_dim * nArray[n], pdVector4);
                            ++n;
                        }
                    } else if (pdVector3.hasShape(6)) {
                        this.projectOntoNull(pdVector2.m_data, this.m_dim * nArray[0]);
                        if (nArray[0] != nArray[n6 - 1]) {
                            this.projectOntoNull(pdVector2.m_data, this.m_dim * nArray[n6 - 1]);
                        }
                        PsDebug.warning((String)"fixThread not implemented yet");
                    } else if (pdVector3.hasShape(13)) {
                        n = 0;
                        while (n < n6) {
                            this.projectOntoNull(pdVector2.m_data, this.m_dim * nArray[n]);
                            ++n;
                        }
                    } else {
                        PsDebug.warning((String)"no boundary condition found");
                    }
                }
                ++n5;
            }
        }
        return pdVector2;
    }

    public PdMatrix evalHessian(PdMatrix pdMatrix) {
        PsDebug.warning((String)"method not implemented by subclass");
        return null;
    }

    public void setEnabledConstrainMatrix(boolean bl) {
        this.m_bUseConstrainMatrix = bl;
        if (this.m_bUseConstrainMatrix) {
            this.m_vertexGrad = new PdVector();
            this.m_subConstrain = new PdMatrix();
            this.m_constrain = new PdMatrix();
            return;
        }
        this.m_vertexGrad = null;
        this.m_subConstrain = null;
        this.m_constrain = null;
    }

    protected PdMatrix getConstrainMatrix(PdMatrix pdMatrix) {
        if (pdMatrix == null) {
            pdMatrix = new PdMatrix(this.m_dim * this.m_nop);
        } else {
            pdMatrix.setSize(this.m_dim * this.m_nop);
        }
        pdMatrix.setIdentity();
        if ((this.m_bndList == null || this.m_bndList.length == 0) && this.m_zeroGradient) {
            int n = 0;
            while (n < this.m_nop) {
                if (this.m_invIndex[n] == -1) {
                    this.projectOntoNull(pdMatrix, this.m_dim, n);
                }
                ++n;
            }
        } else {
            int n = 0;
            while (n < this.m_bndList.length) {
                PgBndConstraint pgBndConstraint;
                if (!this.m_bndList[n].hasTag(2) && (pgBndConstraint = this.m_bndList[n].getBndConstraint()) != null) {
                    int n2 = this.m_bndList[n].getNumVertices();
                    int[] nArray = this.m_bndList[n].getVertexInd().m_data;
                    if (pgBndConstraint.hasShape(3)) {
                        int n3 = 0;
                        while (n3 < n2) {
                            this.projectOntoNull(pdMatrix, this.m_dim, nArray[n3]);
                            ++n3;
                        }
                    } else if (pgBndConstraint.hasShape(4)) {
                        PdVector pdVector = pgBndConstraint.m_dir;
                        this.projectOntoNull(pdMatrix, this.m_dim, nArray[0]);
                        if (nArray[0] != nArray[n2 - 1]) {
                            this.projectOntoNull(pdMatrix, this.m_dim, nArray[n2 - 1]);
                        }
                        int n4 = 1;
                        while (n4 < n2 - 1) {
                            this.projectOntoLine(pdMatrix, this.m_dim, nArray[n4], pdVector);
                            ++n4;
                        }
                    } else if (pgBndConstraint.hasShape(5) || pgBndConstraint.hasShape(11)) {
                        PdVector pdVector = pgBndConstraint.m_dir;
                        PdVector pdVector2 = pgBndConstraint.m_startDir;
                        PdVector pdVector3 = pgBndConstraint.m_endDir;
                        if (pdVector2 == null) {
                            this.projectOntoPlane(pdMatrix, this.m_dim, nArray[0], pdVector);
                        } else if (pdVector2.sqrLength() > 1.0E-10) {
                            this.projectOntoLine(pdMatrix, this.m_dim, nArray[0], pdVector2);
                        } else {
                            this.projectOntoNull(pdMatrix, this.m_dim, nArray[0]);
                        }
                        if (nArray[0] != nArray[n2 - 1]) {
                            if (pdVector3 == null) {
                                this.projectOntoPlane(pdMatrix, this.m_dim, nArray[n2 - 1], pdVector);
                            } else if (pdVector3.sqrLength() > 1.0E-10) {
                                this.projectOntoLine(pdMatrix, this.m_dim, nArray[n2 - 1], pdVector3);
                            } else {
                                this.projectOntoNull(pdMatrix, this.m_dim, nArray[n2 - 1]);
                            }
                        }
                        int n5 = 1;
                        while (n5 < n2 - 1) {
                            this.projectOntoPlane(pdMatrix, this.m_dim, nArray[n5], pdVector);
                            ++n5;
                        }
                    } else if (pgBndConstraint.hasShape(6)) {
                        this.projectOntoNull(pdMatrix, this.m_dim, nArray[0]);
                        if (nArray[0] != nArray[n2 - 1]) {
                            this.projectOntoNull(pdMatrix, this.m_dim, nArray[n2 - 1]);
                        }
                        PsDebug.warning((String)"fixThread not implemented yet");
                    } else if (pgBndConstraint.hasShape(13)) {
                        int n6 = 0;
                        while (n6 < n2) {
                            this.projectOntoNull(pdMatrix, this.m_dim, nArray[n6]);
                            ++n6;
                        }
                    } else {
                        PsDebug.warning((String)"no boundary condition found");
                    }
                }
                ++n;
            }
        }
        return pdMatrix;
    }

    public PdVector evalGradient(PdVector pdVector, PdVector pdVector2) {
        if (pdVector == null) {
            PsDebug.warning((String)"Missing coordinate array.");
            return null;
        }
        if (pdVector2 == null) {
            if (this.m_store == null || this.m_store.getSize() == 0 && pdVector.getSize() != 0) {
                PsDebug.warning((String)"PnEnergy not initialized, cannot evaluate gradient");
                return null;
            }
            pdVector2 = this.m_store;
        }
        pdVector2.setConstant(0.0);
        if (this.m_surface.getNumVertices() != this.m_nop) {
            return pdVector2;
        }
        if (this.m_stiffMatrix != null) {
            int n = 0;
            while (n < this.m_nop) {
                int n2 = 0;
                while (n2 < this.m_stiffMatrix.m_snoe.m_data[n]) {
                    int n3 = this.m_dim * this.m_stiffMatrix.m_sindx[n].m_data[n2];
                    if (n3 >= 0) {
                        int n4 = 0;
                        while (n4 < this.m_dim) {
                            int n5 = this.m_dim * n + n4;
                            pdVector2.m_data[n5] = pdVector2.m_data[n5] + 2.0 * this.m_stiffMatrix.m_stiff[n].m_data[n2] * pdVector.m_data[n3 + n4];
                            ++n4;
                        }
                    }
                    ++n2;
                }
                ++n;
            }
        }
        return this.constrainGradient(pdVector, pdVector2);
    }

    public PdVector[] getSpectrum(PdVector pdVector, PdVector[] pdVectorArray) {
        pdVector.setSize(this.m_dim * this.m_noiv);
        pdVectorArray = PdVector.realloc((PdVector[])pdVectorArray, (int)(this.m_dim * this.m_noiv), (int)(this.m_dim * this.m_noiv));
        PdMatrix pdMatrix = this.evalHessian(null);
        PdMatrix pdMatrix2 = this.m_surface.getL2Matrix(null);
        PdMatrix pdMatrix3 = new PdMatrix(this.m_noiv);
        int n = 0;
        while (n < this.m_noiv) {
            int n2 = 0;
            while (n2 < this.m_noiv) {
                pdMatrix3.m_data[n][n2] = pdMatrix2.m_data[this.m_index[n]][this.m_index[n2]];
                ++n2;
            }
            ++n;
        }
        PdMatrix pdMatrix4 = new PdMatrix(this.m_noiv);
        PnMatrix.invert(pdMatrix4.m_data, pdMatrix3.m_data, this.m_noiv);
        PdVector pdVector2 = new PdVector(this.m_noiv);
        PdVector[] pdVectorArray2 = PdVector.realloc(null, (int)this.m_noiv, (int)this.m_noiv);
        PnJacobi.computeEigenvectors(pdMatrix3, this.m_noiv, pdVector2, pdVectorArray2);
        if (PnJacobi.isInterrupted()) {
            PsDebug.warning((String)"Computation of spectrum aborted by user.");
            return null;
        }
        n = 0;
        while (n < this.m_noiv) {
            pdVectorArray2[n].multScalar(1.0 / Math.sqrt(pdVector2.m_data[n]));
            ++n;
        }
        PdMatrix pdMatrix5 = pdMatrix3;
        pdMatrix5.setColumns(pdVectorArray2);
        if (this.m_bUseConstrainMatrix) {
            pdMatrix5.leftMult(this.m_constrain, this.m_noiv);
        }
        PdMatrix pdMatrix6 = new PdMatrix(this.m_noiv);
        PnMatrix.invert(pdMatrix6.m_data, pdMatrix5.m_data, this.m_noiv);
        PdMatrix pdMatrix7 = PdMatrix.expandComponents((PdMatrix)pdMatrix5, (int)this.m_dim);
        PdMatrix pdMatrix8 = pdMatrix5;
        pdMatrix8.mult(pdMatrix6, pdMatrix4);
        PdMatrix pdMatrix9 = PdMatrix.expandComponents((PdMatrix)pdMatrix8, (int)this.m_dim);
        PdMatrix pdMatrix10 = new PdMatrix(this.m_dim * this.m_noiv);
        pdMatrix10.mult(pdMatrix9, pdMatrix);
        PdMatrix pdMatrix11 = pdMatrix9;
        pdMatrix11.mult(pdMatrix10, pdMatrix7);
        PnJacobi.computeEigenvectors(pdMatrix11, this.m_dim * this.m_noiv, pdVector, pdVectorArray);
        if (PnJacobi.isInterrupted()) {
            PsDebug.warning((String)"Computation of spectrum aborted by user.");
            return null;
        }
        n = 0;
        while (n < this.m_dim * this.m_noiv) {
            pdVectorArray[n].leftMultMatrix(pdMatrix7);
            pdVectorArray[n].normalize();
            ++n;
        }
        return pdVectorArray;
    }

    public boolean isEnabledConstrainMatrix() {
        return this.m_bUseConstrainMatrix;
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public int getNumOfVariables() {
        return this.m_dim * this.m_noiv;
    }

    public void init() {
        super.init();
        this.m_bTangential = true;
        this.m_bNormal = true;
    }

    private void projectOntoLine(double[] dArray, int n, PdVector pdVector) {
        double d = 0.0;
        int n2 = 0;
        while (n2 < this.m_dim) {
            d += dArray[n + n2] * pdVector.m_data[n2];
            ++n2;
        }
        n2 = 0;
        while (n2 < this.m_dim) {
            dArray[n + n2] = d * pdVector.m_data[n2];
            ++n2;
        }
    }

    public double eval(PdVector pdVector) {
        int n;
        int n2;
        if (this.m_stiffMatrix == null) {
            PsDebug.warning((String)"missing m_stiffMatrix, call setSurface before.");
            return 0.0;
        }
        this.m_store.setConstant(0.0);
        int n3 = 0;
        while (n3 < this.m_nop) {
            int n4 = 0;
            while (n4 < this.m_stiffMatrix.m_snoe.m_data[n3]) {
                n2 = this.m_dim * this.m_stiffMatrix.m_sindx[n3].m_data[n4];
                if (n2 >= 0) {
                    n = 0;
                    while (n < this.m_dim) {
                        int n5 = this.m_dim * n3 + n;
                        this.m_store.m_data[n5] = this.m_store.m_data[n5] + this.m_stiffMatrix.m_stiff[n3].m_data[n4] * pdVector.m_data[n2 + n];
                        ++n;
                    }
                }
                ++n4;
            }
            ++n3;
        }
        double d = 0.0;
        n3 = 0;
        while (n3 < this.m_nop) {
            if (this.m_stiffMatrix.m_snoe.m_data[n3] > 0 && (n2 = this.m_dim * n3) >= 0) {
                n = 0;
                while (n < this.m_dim) {
                    d += this.m_store.m_data[n2 + n] * pdVector.m_data[n2 + n];
                    ++n;
                }
            }
            ++n3;
        }
        return d;
    }

    private void projectOntoLine(PdMatrix pdMatrix, int n, int n2, PdVector pdVector) {
        this.m_subConstrain.adjoint(pdVector);
        int n3 = n * n2;
        int n4 = 0;
        while (n4 < n) {
            int n5 = 0;
            while (n5 < n) {
                pdMatrix.m_data[n3 + n4][n3 + n5] = this.m_subConstrain.m_data[n4][n5];
                ++n5;
            }
            ++n4;
        }
    }

    public void initSurface(PgElementSet pgElementSet, PgElementSet pgElementSet2) {
        if (this.m_stiffMatrix == null) {
            PsDebug.warning((String)"missing m_stiffMatrix, call setSurface before.");
            return;
        }
    }
}

