/*
 * Decompiled with CFR 0.152.
 */
package jvx.numeric;

import jv.geom.PgElementSet;
import jv.number.PuDouble;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsUpdateIf;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuVectorGeom;
import jvx.numeric.PnDiriEnergy;

public class PnAreaVolEnergy
extends PnDiriEnergy {
    protected int m_noe;
    protected PdVector m_origin;
    protected PdVector m_normal;
    protected PdVector[] m_v;
    protected PuDouble m_meanCurvature = new PuDouble(PsConfig.getMessage((int)54013), (PsUpdateIf)this);
    private static /* synthetic */ Class class$jvx$numeric$PnAreaVolEnergy;

    public boolean setSurface(PgElementSet pgElementSet, PgElementSet pgElementSet2) {
        if (pgElementSet2 == null) {
            PsDebug.warning((String)"missing surface geometry.");
            return false;
        }
        if (!super.setSurface(pgElementSet, pgElementSet2)) {
            return false;
        }
        if (this.m_surface.getDimOfElements() != 3) {
            PsDebug.warning((String)("surface=" + this.m_surface.getName() + " not triangulated"));
            PgElementSet.triangulate((PgElementSet)this.m_surface);
        }
        this.m_v = PdVector.realloc((PdVector[])this.m_v, (int)3, (int)this.m_dim);
        this.m_noe = this.m_surface.getNumElements();
        this.m_normal = new PdVector(this.m_dim);
        this.m_origin = new PdVector(this.m_dim);
        this.m_origin.setConstant(0.0);
        return true;
    }

    public PnAreaVolEnergy() {
        if (((Object)((Object)this)).getClass() == (class$jvx$numeric$PnAreaVolEnergy != null ? class$jvx$numeric$PnAreaVolEnergy : (class$jvx$numeric$PnAreaVolEnergy = PnAreaVolEnergy.class$("jvx.numeric.PnAreaVolEnergy")))) {
            this.init();
        }
    }

    public PdMatrix evalHessian(PdMatrix pdMatrix) {
        if (pdMatrix == null) {
            pdMatrix = new PdMatrix();
        }
        int n = this.m_index.length;
        pdMatrix.setSize(this.m_dim * n);
        pdMatrix.setConstant(0.0);
        int n2 = 0;
        while (n2 < n) {
            int n3 = 0;
            while (n3 < this.m_stiffMatrix.m_snoe.m_data[this.m_index[n2]]) {
                int n4 = this.m_invIndex[this.m_stiffMatrix.m_sindx[this.m_index[n2]].m_data[n3]];
                if (n4 != -1) {
                    if (n2 != 0 || n4 == 0) {
                        // empty if block
                    }
                    int n5 = 0;
                    while (n5 < this.m_dim) {
                        pdMatrix.m_data[n2 * this.m_dim + n5][n4 * this.m_dim + n5] = this.m_stiffMatrix.m_stiff[this.m_index[n2]].m_data[n3];
                        ++n5;
                    }
                }
                ++n3;
            }
            ++n2;
        }
        return pdMatrix;
    }

    public boolean update(Object object) {
        if (this.m_meanCurvature == object) {
            if (this.m_surface != null) {
                this.m_surface.update(null);
            }
            return true;
        }
        return super.update(object);
    }

    public PdVector evalGradient(PdVector pdVector, PdVector pdVector2) {
        if (pdVector == null) {
            PsDebug.warning((String)"Missing coordinate array.");
            return null;
        }
        if ((pdVector2 = super.evalGradient(pdVector, pdVector2)) == null) {
            return null;
        }
        PiVector[] piVectorArray = this.m_surface.getElements();
        int n = 0;
        double d = 2.0 * this.m_meanCurvature.getValue() / 3.0;
        int n2 = 0;
        while (n2 < this.m_noe) {
            int n3 = 0;
            do {
                n = this.m_dim * piVectorArray[n2].getEntry(n3);
                int n4 = 0;
                while (n4 < this.m_dim) {
                    this.m_v[n3].m_data[n4] = pdVector.m_data[n++];
                    ++n4;
                }
            } while (++n3 < 3);
            this.m_normal.normalOfPlane(this.m_v[0], this.m_v[1], this.m_v[2]);
            double d2 = d * PdVector.area((PdVector[])this.m_v);
            int n5 = 0;
            do {
                n = this.m_dim * piVectorArray[n2].getEntry(n5);
                int n6 = 0;
                while (n6 < this.m_dim) {
                    int n7 = n++;
                    pdVector2.m_data[n7] = pdVector2.m_data[n7] + d2 * this.m_normal.m_data[n6];
                    ++n6;
                }
            } while (++n5 < 3);
            ++n2;
        }
        return this.constrainGradient(pdVector, pdVector2);
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void init() {
        super.init();
        this.m_meanCurvature.setDefBounds(-10.0, 10.0, 0.01, 0.1);
        this.m_meanCurvature.setDefValue(0.0);
        this.m_meanCurvature.init();
        this.m_v = null;
    }

    public double eval(PdVector pdVector) {
        if (this.m_stiffMatrix == null) {
            PsDebug.warning((String)"missing m_stiffMatrix, call setSurface before.");
            return 0.0;
        }
        double d = super.eval(pdVector);
        PiVector[] piVectorArray = this.m_surface.getElements();
        int n = 0;
        double d2 = 0.0;
        int n2 = 0;
        while (n2 < this.m_noe) {
            int n3 = 0;
            do {
                n = this.m_dim * piVectorArray[n2].getEntry(n3);
                int n4 = 0;
                while (n4 < this.m_dim) {
                    this.m_v[n3].m_data[n4] = pdVector.m_data[n++];
                    ++n4;
                }
            } while (++n3 < 3);
            this.m_normal.normalOfPlane(this.m_v[0], this.m_v[1], this.m_v[2]);
            double d3 = -PuVectorGeom.distOfPointToPlane((PdVector)this.m_origin, (PdVector)this.m_v[0], (PdVector)this.m_normal);
            double d4 = PdVector.area((PdVector[])this.m_v);
            d2 += d4 * d3 / 3.0;
            ++n2;
        }
        return d + 2.0 * this.m_meanCurvature.getValue() * d2;
    }
}

