/*
 * Decompiled with CFR 0.152.
 */
package jvx.loader;

import jv.loader.PgLoader;
import jv.loader.PvDisplayOption;
import jv.number.PuString;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsUtil;
import jv.project.PgGeometryIf;
import jv.project.PvDisplayIf;
import jv.project.PvViewerIf;
import jv.rsrc.PsAuthorInfo;
import jv.rsrc.PsGeometryInfo;
import jv.rsrc.PsJavaView;
import jvx.project.PjWorkshop;

public class PsExportInfo
extends PjWorkshop {
    public static final int FILE_SIZE_USER = -1;
    public static final int FILE_SIZE_SCRN = 0;
    public static final int FILE_SIZE_PAL = 1;
    public static final int FILE_SIZE_NTSC = 2;
    public static final int FILE_SIZE_MED = 3;
    public static final int FILE_SIZE_BOOK = 4;
    public static final int FILE_SIZE_SGL = 5;
    public static final int FILE_SIZE_SML = 6;
    public static final int FILE_SIZE_TINY = 7;
    public static final int FILE_FORMAT_BYU = 0;
    public static final int FILE_FORMAT_FE = 1;
    public static final int FILE_FORMAT_JVX = 2;
    public static final int FILE_FORMAT_JVD = 3;
    public static final int FILE_FORMAT_MGS = 4;
    public static final int FILE_FORMAT_MPL = 5;
    public static final int FILE_FORMAT_OBJ = 6;
    public static final int FILE_FORMAT_OFF = 7;
    public static final int FILE_FORMAT_STL = 8;
    public static final int FILE_FORMAT_WRL = 9;
    public static final int FILE_FORMAT_HTML = 10;
    public static final int FILE_FORMAT_GIF = 11;
    public static final int FILE_FORMAT_PPM = 12;
    public static final int FILE_FORMAT_EPS = 13;
    public static final int FILE_FORMAT_PS = 14;
    public static final int GEOM_DATA_HEADER = 0;
    public static final int GEOM_DATA_AUTHOR = 1;
    public static final int GEOM_DATA_INFO = 2;
    public static final int GEOM_DATA_NORMALS = 3;
    public static final int GEOM_DATA_COLORS = 4;
    public static final int GEOM_DATA_TEXTURE = 5;
    public static final int GEOM_DATA_VECTORS = 6;
    protected int[] GEOM_DATA_FORMAT;
    protected String[] GEOM_DATA_FORMAT_EXT;
    protected int[] GEOM_FORMAT;
    protected String[] GEOM_FORMAT_EXT;
    protected int[] IMAGE_FORMAT;
    protected String[] IMAGE_FORMAT_EXT;
    protected static final int IMAGE_RATIO_LANDSCAPE = 0;
    protected static final int IMAGE_RATIO_PORTRAIT = 1;
    protected static final int IMAGE_RATIO_SQUARE = 2;
    protected int[] IMAGE_SIZE;
    protected int m_maxNumImageTypes;
    protected static String[] IMAGE_SIZE_EXT = new String[]{"_scrn", "_pal", "_ntsc", "_med", "_book", "_sgl", "_sml", "_tiny"};
    protected static String IMAGE_SIZE_EXT_USER = "_user";
    protected int[][] IMAGE_SIZE_LAND;
    protected int[][] IMAGE_SIZE_PORT;
    protected int[][] IMAGE_SIZE_SQUARE;
    protected static String m_baseDirectory;
    protected static String m_baseFileName;
    protected static int[] m_bFormatSelection;
    protected int[] m_dataFormat;
    protected static int[] m_exportedFields;
    protected int[] m_geomFormat;
    protected int[] m_imageFormat;
    protected static int[] m_exportedFile;
    protected PsAuthorInfo m_authorInfo;
    protected static PsGeometryInfo m_geometryInfo;
    protected String m_sceneTitle;
    protected static boolean m_bFilePerField;
    protected static boolean m_bConfigImage;
    protected static int m_defImageType;
    protected static int m_imageType;
    protected static String[] m_imageTypeExt;
    protected static String m_imageSuffix;
    protected static int m_imageRatio;
    protected static int m_imageWidth;
    protected static int m_imageHeight;
    protected static int GEOM_SAVE_ALL;
    protected static int GEOM_SAVE_VISIBLE;
    protected static int GEOM_SAVE_SELECTED;
    protected static int m_selectGeom;
    protected static boolean m_bCompress;
    protected static boolean m_bSaveAsFloat;
    private static /* synthetic */ Class class$jvx$loader$PsExportInfo;

    public void setBaseFileName(String string) {
        m_baseFileName = PsUtil.getFileBaseName((String)string);
    }

    public String getDataName(int n) {
        return this.GEOM_DATA_FORMAT_EXT[n];
    }

    public String getFileExtension(int n) {
        int n2 = this.GEOM_FORMAT_EXT.length;
        int n3 = 0;
        while (n3 < n2) {
            if (n == this.GEOM_FORMAT[n3]) {
                return this.GEOM_FORMAT_EXT[n3];
            }
            ++n3;
        }
        n3 = this.IMAGE_FORMAT_EXT.length;
        int n4 = 0;
        while (n4 < n3) {
            if (n == this.IMAGE_FORMAT[n4]) {
                return this.IMAGE_FORMAT_EXT[n4];
            }
            ++n4;
        }
        PsDebug.warning((String)("Unknown file format = " + n));
        return "";
    }

    private int getFileDialog(int n) {
        int n2 = -1;
        switch (n) {
            case 0: {
                n2 = 43;
                break;
            }
            case 1: {
                n2 = 44;
                break;
            }
            case 2: {
                n2 = 45;
                break;
            }
            case 3: {
                n2 = 59;
                break;
            }
            case 4: {
                n2 = 46;
                break;
            }
            case 5: {
                n2 = 47;
                break;
            }
            case 6: {
                n2 = 48;
                break;
            }
            case 7: {
                n2 = 49;
                break;
            }
            case 8: {
                n2 = 50;
                break;
            }
            case 9: {
                n2 = 51;
                break;
            }
            case 10: {
                n2 = 60;
                break;
            }
            case 11: {
                n2 = 52;
                break;
            }
            case 12: {
                n2 = 54;
                break;
            }
            case 13: {
                n2 = 57;
                break;
            }
            case 14: {
                n2 = 58;
                break;
            }
            default: {
                PsDebug.warning((String)("Unknown file format = " + String.valueOf(n)));
            }
        }
        return n2;
    }

    public void setViewer(PvViewerIf pvViewerIf) {
        super.setViewer(pvViewerIf);
        this.setDirectory(PsJavaView.getDirectory((int)4));
        this.setBaseFileName(PsJavaView.getFileName((int)4));
        PvDisplayIf pvDisplayIf = pvViewerIf.getDisplay();
        PgGeometryIf pgGeometryIf = null;
        if (pvDisplayIf != null) {
            pgGeometryIf = pvDisplayIf.getSelectedGeometry();
        }
        if (pgGeometryIf != null && pgGeometryIf.getAuthorInfo() != null && pgGeometryIf.getAuthorInfo().getNumAuthors() > 0) {
            this.m_authorInfo = pgGeometryIf.getAuthorInfo();
        } else if (PsJavaView.getAuthorInfo() != null && PsJavaView.getAuthorInfo().getNumAuthors() > 0) {
            this.m_authorInfo = (PsAuthorInfo)PsJavaView.getAuthorInfo().clone();
        }
        if (pgGeometryIf != null && pgGeometryIf.getGeometryInfo() != null) {
            m_geometryInfo = pgGeometryIf.getGeometryInfo();
        }
        if (pvDisplayIf != null && !PuString.isEmpty((String)pvDisplayIf.getSceneTitle())) {
            this.m_sceneTitle = pvDisplayIf.getSceneTitle();
            return;
        }
        if (pgGeometryIf != null) {
            if (pgGeometryIf.getTitle() != null) {
                this.m_sceneTitle = pgGeometryIf.getTitle();
                return;
            }
            this.m_sceneTitle = pgGeometryIf.getName();
        }
    }

    public void setEnabledConfigDisplay(boolean bl) {
        m_bConfigImage = bl;
    }

    public void setEnabledSaveAsFloat(boolean bl) {
        m_bSaveAsFloat = bl;
    }

    public boolean update(Object object) {
        if (object == null) {
            return super.update(null);
        }
        if (object == this) {
            super.update((Object)this);
        }
        return super.update(object);
    }

    public int[] getExportedFiles() {
        return m_exportedFile;
    }

    public void setExportedFiles(int[] nArray) {
        if (nArray == null) {
            m_exportedFile = new int[0];
            return;
        }
        m_exportedFile = (int[])nArray.clone();
    }

    public int[] getExportedDataFields() {
        return m_exportedFields;
    }

    public void setExportedDataFields(int[] nArray) {
        if (nArray == null) {
            m_exportedFields = new int[0];
            return;
        }
        m_exportedFields = (int[])nArray.clone();
    }

    public int[] getDataFields() {
        return this.m_dataFormat;
    }

    public void setDataFields(int[] nArray) {
        if (nArray == null) {
            this.m_dataFormat = new int[0];
            return;
        }
        this.m_dataFormat = (int[])nArray.clone();
    }

    public int[] getGeomFormat() {
        return this.m_geomFormat;
    }

    public void setGeomFormat(int[] nArray) {
        if (nArray == null) {
            this.m_geomFormat = new int[0];
            return;
        }
        this.m_geomFormat = (int[])nArray.clone();
    }

    public PsExportInfo() {
        super("Export Dialog");
        PsAuthorInfo psAuthorInfo;
        int[] nArray = new int[7];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        nArray[6] = 6;
        this.GEOM_DATA_FORMAT = nArray;
        this.GEOM_DATA_FORMAT_EXT = new String[]{"Header", "Author", "Info", "Normal", "Color", "Texture", "Vector"};
        int[] nArray2 = new int[11];
        nArray2[1] = 1;
        nArray2[2] = 2;
        nArray2[3] = 3;
        nArray2[4] = 4;
        nArray2[5] = 5;
        nArray2[6] = 6;
        nArray2[7] = 7;
        nArray2[8] = 8;
        nArray2[9] = 9;
        nArray2[10] = 10;
        this.GEOM_FORMAT = nArray2;
        this.GEOM_FORMAT_EXT = new String[]{"BYU", "FE", "JVX", "JVD", "MGS", "MPL", "OBJ", "OFF", "STL", "WRL", "HTML"};
        this.IMAGE_FORMAT = new int[]{11, 12, 13, 14};
        this.IMAGE_FORMAT_EXT = new String[]{"GIF", "PPM", "EPS", "PS"};
        int[] nArray3 = new int[9];
        nArray3[1] = 1;
        nArray3[2] = 2;
        nArray3[3] = 3;
        nArray3[4] = 4;
        nArray3[5] = 5;
        nArray3[6] = 6;
        nArray3[7] = 7;
        nArray3[8] = -1;
        this.IMAGE_SIZE = nArray3;
        this.m_maxNumImageTypes = 8;
        this.IMAGE_SIZE_LAND = new int[][]{{1280, 1024}, {720, 576}, {720, 480}, {640, 512}, {480, 384}, {320, 256}, {240, 192}, {160, 128}};
        this.IMAGE_SIZE_PORT = new int[][]{{768, 1024}, {432, 576}, {360, 480}, {384, 512}, {288, 384}, {192, 256}, {144, 192}, {96, 128}};
        this.IMAGE_SIZE_SQUARE = new int[][]{{1024, 1024}, {576, 576}, {480, 480}, {512, 512}, {384, 384}, {256, 256}, {160, 160}, {128, 128}};
        this.m_dataFormat = this.GEOM_DATA_FORMAT;
        this.m_geomFormat = this.GEOM_FORMAT;
        this.m_imageFormat = this.IMAGE_FORMAT;
        m_baseDirectory = PsJavaView.getDirectory((int)4);
        m_baseFileName = PsJavaView.getFileName((int)4);
        if (this.m_authorInfo == null && (psAuthorInfo = PsJavaView.getAuthorInfo()) != null && psAuthorInfo.getNumAuthors() > 0) {
            this.m_authorInfo = (PsAuthorInfo)PsJavaView.getAuthorInfo().clone();
        }
        if (((Object)((Object)this)).getClass() == (class$jvx$loader$PsExportInfo != null ? class$jvx$loader$PsExportInfo : (class$jvx$loader$PsExportInfo = PsExportInfo.class$("jvx.loader.PsExportInfo")))) {
            this.init();
        }
    }

    public String getDirectory() {
        return m_baseDirectory;
    }

    public void setDirectory(String string) {
        m_baseDirectory = string;
    }

    public PsGeometryInfo getGeometryInfo() {
        return m_geometryInfo;
    }

    public void setGeometryInfo(PsGeometryInfo psGeometryInfo) {
        m_geometryInfo = psGeometryInfo;
    }

    public int getImageType() {
        return m_imageType;
    }

    public void setImageType(int n) {
        if (n == m_imageType) {
            return;
        }
        if (n == -1) {
            m_imageType = -1;
            m_imageSuffix = IMAGE_SIZE_EXT_USER;
            return;
        }
        if (n >= 0 && n < this.m_maxNumImageTypes) {
            m_imageType = n;
            m_imageSuffix = IMAGE_SIZE_EXT[m_imageType];
            if (m_imageRatio == 0) {
                m_imageWidth = this.IMAGE_SIZE_LAND[m_imageType][0];
                m_imageHeight = this.IMAGE_SIZE_LAND[m_imageType][1];
                return;
            }
            if (m_imageRatio == 1) {
                m_imageWidth = this.IMAGE_SIZE_PORT[m_imageType][0];
                m_imageHeight = this.IMAGE_SIZE_PORT[m_imageType][1];
                return;
            }
            if (m_imageRatio == 2) {
                m_imageWidth = this.IMAGE_SIZE_SQUARE[m_imageType][0];
                m_imageHeight = this.IMAGE_SIZE_SQUARE[m_imageType][1];
                return;
            }
        } else {
            PsDebug.warning((String)("image type out of range, type = " + n));
            return;
        }
    }

    static {
        m_baseFileName = "geom";
        int[] nArray = new int[7];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        nArray[6] = 6;
        m_exportedFields = nArray;
        m_exportedFile = new int[]{2, 3};
        m_bFilePerField = false;
        m_bConfigImage = true;
        m_defImageType = 0;
        m_imageType = -1;
        m_imageTypeExt = IMAGE_SIZE_EXT;
        GEOM_SAVE_ALL = 1;
        GEOM_SAVE_VISIBLE = 2;
        GEOM_SAVE_SELECTED = 3;
        m_selectGeom = GEOM_SAVE_ALL;
        m_bCompress = false;
        m_bSaveAsFloat = false;
    }

    public PsAuthorInfo getAuthorInfo() {
        return this.m_authorInfo;
    }

    public void setEnabledCompress(boolean bl) {
        m_bCompress = bl;
    }

    public void setAuthorInfo(PsAuthorInfo psAuthorInfo) {
        this.m_authorInfo = psAuthorInfo;
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public boolean isEnabledConfigDisplay() {
        return m_bConfigImage;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void ok() {
        if (PsExportInfo.m_exportedFile == null || PsExportInfo.m_exportedFile.length == 0) {
            super.ok();
            return;
        }
        var1_1 = this.getViewer();
        if (var1_1 == null) {
            super.ok();
            return;
        }
        var2_2 = var1_1.getDisplay();
        v0 = var3_3 = PuString.isEmpty((String)this.m_sceneTitle) == false;
        if (var2_2 != null) {
            var4_4 /* !! */  = var2_2.getGeometries();
            var5_5 = var2_2.getSelectedGeometry();
            if (var4_4 /* !! */  != null) {
                var6_7 = 0;
                while (var6_7 < var4_4 /* !! */ .length) {
                    if (var4_4 /* !! */ [var6_7] != null && var4_4 /* !! */ [var6_7] != var5_5) {
                        if (var4_4 /* !! */ [var6_7].getAuthorInfo() == null) {
                            var4_4 /* !! */ [var6_7].setAuthorInfo(this.m_authorInfo);
                        }
                        if (var4_4 /* !! */ [var6_7].getGeometryInfo() == null) {
                            var4_4 /* !! */ [var6_7].setGeometryInfo(PsExportInfo.m_geometryInfo);
                        }
                        if (var3_3) {
                            var4_4 /* !! */ [var6_7].setTitle(this.m_sceneTitle);
                        }
                    }
                    ++var6_7;
                }
            }
            if (var5_5 != null) {
                var5_5.setAuthorInfo(this.m_authorInfo);
                var5_5.setGeometryInfo(PsExportInfo.m_geometryInfo);
                if (var3_3) {
                    var5_5.setTitle(this.m_sceneTitle);
                }
            }
            if (var3_3) {
                var2_2.setSceneTitle(this.m_sceneTitle);
            }
        }
        if (var2_2 == null) {
            PsDebug.warning((String)"missing display. Currently, export dialog requires a display.");
            super.ok();
            return;
        }
        var4_4 /* !! */  = PsExportInfo.m_baseDirectory + PsExportInfo.m_baseFileName;
        var5_6 = PsExportInfo.m_exportedFile.length;
        var6_8 = null;
        var7_9 = new PgLoader();
        var8_10 = 0;
        while (var8_10 < PsExportInfo.m_exportedFields.length) {
            var7_9.setTag(PsExportInfo.m_exportedFields[var8_10], true);
            ++var8_10;
        }
        if (PsExportInfo.m_exportedFields.length == 0) {
            var7_9.setTag(0, true);
            var7_9.setTag(0, false);
        }
        var8_10 = 0;
        while (var8_10 < var5_6) {
            var9_12 = this.getFileDialog(PsExportInfo.m_exportedFile[var8_10]);
            var10_13 = this.getFileExtension(PsExportInfo.m_exportedFile[var8_10]).toLowerCase();
            var11_14 = (String)var4_4 /* !! */  + "." + var10_13;
            var12_15 = null;
            switch (var9_12) {
                case 49: 
                case 59: 
                case 60: {
                    if (var2_2 == null) break;
                    var12_15 = new PvDisplayOption();
                    var12_15.setOptions(var2_2);
                    if (var3_3) {
                        var12_15.setName(this.m_sceneTitle);
                    }
                    if (this.m_authorInfo == null) break;
                    var12_15.setAuthorInfo(this.m_authorInfo);
                }
            }
            switch (var9_12) {
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: {
                    if (PsExportInfo.m_bCompress) {
                        var11_14 = var11_14 + ".zip";
                    }
                }
                case 60: {
                    var7_9.setDisplayOption(var12_15);
                    var13_16 = null;
                    var13_16 = PsExportInfo.m_selectGeom == PsExportInfo.GEOM_SAVE_ALL ? var2_2.getGeometries() : (PsExportInfo.m_selectGeom == PsExportInfo.GEOM_SAVE_VISIBLE ? var2_2.getVisibleGeometries() : new PgGeometryIf[]{var2_2.getSelectedGeometry()});
                    if (var13_16 != null && var13_16.length > 1 && var13_16[0] != (var14_17 = var2_2.getSelectedGeometry())) {
                        var15_18 = 0;
                        while (var15_18 < var13_16.length) {
                            if (var13_16[var15_18] == var14_17) {
                                var16_19 = var13_16[0];
                                var13_16[0] = var14_17;
                                var13_16[var15_18] = var16_19;
                                break;
                            }
                            ++var15_18;
                        }
                    }
                    PuString.m_bConvertDoubleToFloat = PsExportInfo.m_bSaveAsFloat;
                    var7_9.saveGeometry(var13_16, var11_14);
                    PuString.m_bConvertDoubleToFloat = false;
                    ** GOTO lbl101
                }
                case 59: {
                    var7_9.saveDisplay(new PvDisplayOption[]{var12_15}, var11_14);
                    ** GOTO lbl101
                }
                case 52: 
                case 54: 
                case 57: 
                case 58: {
                    var14_17 = var4_4 /* !! */ ;
                    if (PsExportInfo.m_imageSuffix != null) {
                        var14_17 = (String)var14_17 + PsExportInfo.m_imageSuffix;
                    }
                    var14_17 = (String)var14_17 + "." + var10_13;
                    if (this.isEnabledConfigDisplay()) {
                        var1_1.export(var9_12, (String)var14_17, PsExportInfo.m_imageWidth, PsExportInfo.m_imageHeight);
                    } else {
                        var1_1.export(var9_12, (String)var14_17);
                    }
lbl101:
                    // 4 sources

                    if (var10_13.equalsIgnoreCase("jvx")) {
                        var6_8 = var10_13;
                        break;
                    }
                    if (var6_8 != null || var10_13.equalsIgnoreCase("html") || var10_13.equalsIgnoreCase("eps") || var10_13.equalsIgnoreCase("ps") || var10_13.equalsIgnoreCase("jvd") || var10_13.equalsIgnoreCase("gif") || var10_13.equalsIgnoreCase("ppm")) break;
                    var6_8 = var10_13;
                }
            }
            ++var8_10;
        }
        if (var6_8 != null) {
            var4_4 /* !! */  = (String)var4_4 /* !! */  + "." + var6_8;
            PsJavaView.setFullFileName((int)4, (String)var4_4 /* !! */ );
            var8_11 = var1_1.getFrame();
            if (var8_11 != null) {
                var8_11.setTitle(PsConfig.getProgram() + " v" + PsConfig.getVersion() + ": " + (String)var4_4 /* !! */ );
            }
        }
        super.ok();
    }

    public void init() {
        super.init();
        m_imageRatio = 0;
        if (m_imageType == -1) {
            this.setImageType(m_defImageType);
        }
    }

    public boolean isEnabledSaveAsFloat() {
        return m_bSaveAsFloat;
    }

    public int[] getImageFormat() {
        return this.m_imageFormat;
    }

    public void setImageFormat(int[] nArray) {
        if (nArray == null) {
            this.m_imageFormat = new int[0];
            return;
        }
        this.m_imageFormat = (int[])nArray.clone();
    }

    public String getImageSuffix() {
        return m_imageSuffix;
    }

    public boolean isEnabledCompress() {
        return m_bCompress;
    }

    public void setImageSuffix(String string) {
        m_imageSuffix = string;
    }

    public String getBaseFileName() {
        return m_baseFileName;
    }
}

