/*
 * Decompiled with CFR 0.152.
 */
package jvx.loader;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.Writer;
import java.util.BitSet;
import java.util.Date;
import jv.loader.PgLoader;
import jv.loader.PgLoaderIf;
import jv.loader.PvDisplayOption;
import jv.number.PuString;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsUtil;
import jv.project.PgGeometryIf;
import jv.project.PgJvxSrc;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public final class PgOffLoader
implements PgLoaderIf {
    protected PvDisplayOption m_displayOption;
    protected boolean m_bIsAnimation = false;
    protected PgJvxSrc[] m_geomArr;
    protected PgJvxSrc[][] m_animArr;
    private static final String StrNL = "\n";

    public void setGeometryOption(BitSet bitSet) {
    }

    public boolean isEnabledOptimization() {
        return false;
    }

    protected PgJvxSrc parse(BufferedReader bufferedReader) {
        StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedReader);
        streamTokenizer.eolIsSignificant(false);
        streamTokenizer.ordinaryChars(47, 47);
        streamTokenizer.whitespaceChars(59, 59);
        streamTokenizer.commentChar(35);
        PgJvxSrc pgJvxSrc = this.parseGeom(streamTokenizer);
        return pgJvxSrc;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PgJvxSrc parseGeom(StreamTokenizer streamTokenizer) {
        try {
            block6: while (true) {
                switch (streamTokenizer.nextToken()) {
                    default: {
                        continue block6;
                    }
                    case -1: {
                        PsDebug.warning((String)"could not find magic keyword OFF");
                        return null;
                    }
                    case -3: 
                }
                if (streamTokenizer.sval.endsWith("OFF")) {
                    return this.parseOff(streamTokenizer);
                }
                if (streamTokenizer.sval.endsWith("VECT")) {
                    return this.parseVect(streamTokenizer);
                }
                if (streamTokenizer.sval.endsWith("LIST")) {
                    return this.parseList(streamTokenizer);
                }
                if (streamTokenizer.sval.endsWith("INST")) break;
            }
            return this.parseInst(streamTokenizer);
        }
        catch (IOException iOException) {
            PsDebug.warning((String)("Exception thrown in line=" + streamTokenizer.lineno() + ", Exception = " + iOException));
            return null;
        }
    }

    private PgJvxSrc parseList(StreamTokenizer streamTokenizer) {
        PsDebug.warning((String)"method parseList not implemented yet, send your geometry to JavaView authors.");
        return null;
    }

    private PgJvxSrc parseInst(StreamTokenizer streamTokenizer) {
        PgJvxSrc pgJvxSrc = null;
        PdMatrix pdMatrix = null;
        try {
            do {
                switch (streamTokenizer.nextToken()) {
                    default: {
                        PsDebug.warning((String)"identifier \"geom\" or \"transform\" expected in Inst");
                        return null;
                    }
                    case -3: 
                }
                if (streamTokenizer.sval.equals("geom")) {
                    pgJvxSrc = this.parseGeom(streamTokenizer);
                    continue;
                }
                if (streamTokenizer.sval.equals("transform")) {
                    pdMatrix = new PdMatrix(4);
                    int n = 0;
                    do {
                        int n2 = 0;
                        do {
                            pdMatrix.m_data[n2][n] = PgLoader.parseDouble((StreamTokenizer)streamTokenizer);
                        } while (++n2 < 4);
                    } while (++n < 4);
                    this.m_displayOption = new PvDisplayOption();
                    this.m_displayOption.setCameraMatrix(0, pdMatrix);
                    continue;
                }
                PsDebug.warning((String)"identifier \"geom\" or \"transform\" expected in Inst");
                return null;
            } while (pgJvxSrc == null || pdMatrix == null);
        }
        catch (IOException iOException) {
            PsDebug.warning((String)("Exception thrown in line=" + streamTokenizer.lineno() + ", Exception = " + iOException));
            return null;
        }
        return pgJvxSrc;
    }

    private PgJvxSrc parseOff(StreamTokenizer streamTokenizer) {
        int n = 4;
        int n2 = 200;
        double[] dArray = new double[n];
        int[] nArray = new int[n2];
        try {
            int n3;
            boolean bl;
            boolean bl2;
            boolean bl3;
            boolean bl4;
            int n4 = 3;
            PgJvxSrc pgJvxSrc = new PgJvxSrc();
            pgJvxSrc.setType(33);
            String string = streamTokenizer.sval;
            boolean bl5 = string.startsWith("ST");
            if (bl5) {
                string = string.substring(2);
            }
            if (bl4 = string.startsWith("C")) {
                string = string.substring(1);
            }
            if (bl3 = string.startsWith("N")) {
                string = string.substring(1);
            }
            if (bl2 = string.startsWith("4")) {
                string = string.substring(1);
            }
            if (bl = string.startsWith("n")) {
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype != -2) {
                    PsDebug.warning((String)("missing dim of vertices=" + streamTokenizer.lineno()));
                    return null;
                }
                n4 = (int)streamTokenizer.nval;
            }
            if (bl2) {
                ++n4;
            }
            streamTokenizer.nextToken();
            if (streamTokenizer.ttype != -2) {
                PsDebug.warning((String)("missing number of vertices=" + streamTokenizer.lineno()));
                return null;
            }
            pgJvxSrc.setDimOfVertices(n4);
            pgJvxSrc.setNumVertices((int)streamTokenizer.nval);
            streamTokenizer.nextToken();
            if (streamTokenizer.ttype != -2) {
                PsDebug.warning((String)("missing number of elements=" + streamTokenizer.lineno()));
                return null;
            }
            pgJvxSrc.setDimOfElements(-1);
            pgJvxSrc.setNumElements((int)streamTokenizer.nval);
            double d = -1.0;
            int n5 = 3;
            int n6 = 2;
            streamTokenizer.nextToken();
            if (streamTokenizer.ttype != -2) {
                PsDebug.warning((String)("missing number of edges=" + streamTokenizer.lineno()));
                return null;
            }
            int n7 = pgJvxSrc.getNumVertices();
            PdVector[] pdVectorArray = pgJvxSrc.getVertices();
            Color[] colorArray = null;
            PdVector[] pdVectorArray2 = null;
            PdVector[] pdVectorArray3 = null;
            if (bl4) {
                pgJvxSrc.assureVertexColors();
                colorArray = new Color[n7];
            }
            if (bl3) {
                pgJvxSrc.assureVertexNormals();
                pdVectorArray2 = pgJvxSrc.getVertexNormals();
            }
            if (bl5) {
                pgJvxSrc.assureVertexTextures();
                pdVectorArray3 = pgJvxSrc.getVertexTextures();
            }
            streamTokenizer.eolIsSignificant(true);
            int n8 = 0;
            n8 = 0;
            while (n8 < n7) {
                n3 = 0;
                while (n3 < n4) {
                    dArray[n3] = PgLoader.parseDouble((StreamTokenizer)streamTokenizer);
                    ++n3;
                }
                if (bl2) {
                    n3 = 0;
                    while (n3 < n4 - 1) {
                        int n9 = n3++;
                        dArray[n9] = dArray[n9] / dArray[n4 - 1];
                    }
                    pdVectorArray[n8].set(dArray, n4 - 1);
                } else {
                    pdVectorArray[n8].set(dArray, n4);
                }
                if (bl3) {
                    n3 = 0;
                    while (n3 < n5) {
                        dArray[n3] = PgLoader.parseDouble((StreamTokenizer)streamTokenizer);
                        ++n3;
                    }
                    pdVectorArray2[n8].set(dArray, n5);
                }
                if (bl4) {
                    n3 = 0;
                    do {
                        dArray[n3] = PgLoader.parseDouble((StreamTokenizer)streamTokenizer);
                        if (!(dArray[n3] > 1.0)) continue;
                        int n10 = n3;
                        dArray[n10] = dArray[n10] / 255.0;
                    } while (++n3 < 3);
                    colorArray[n8] = new Color((float)dArray[0], (float)dArray[1], (float)dArray[2]);
                    streamTokenizer.nextToken();
                    if (streamTokenizer.ttype == -2) {
                        streamTokenizer.pushBack();
                        d = PgLoader.parseDouble((StreamTokenizer)streamTokenizer);
                    }
                }
                if (bl5) {
                    n3 = 0;
                    while (n3 < n6) {
                        dArray[n3] = PgLoader.parseDouble((StreamTokenizer)streamTokenizer);
                        ++n3;
                    }
                    pdVectorArray3[n8].set(dArray, n6);
                }
                ++n8;
            }
            streamTokenizer.eolIsSignificant(false);
            if (colorArray != null) {
                pgJvxSrc.setVertexColors(colorArray);
                pgJvxSrc.showVertexColors(true);
            }
            if (pdVectorArray2 != null) {
                pgJvxSrc.setVertexNormals(pdVectorArray2);
            }
            if (pdVectorArray3 != null) {
                pgJvxSrc.setVertexTextures(pdVectorArray3);
                pgJvxSrc.showVertexTexture(true);
            }
            int n11 = pgJvxSrc.getNumElements();
            PiVector[] piVectorArray = pgJvxSrc.getElements();
            Color[] colorArray2 = null;
            streamTokenizer.eolIsSignificant(true);
            int n12 = 0;
            while (n12 < n11) {
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype == -1) {
                    PsDebug.warning((String)"premature end of file");
                    return null;
                }
                if (streamTokenizer.ttype == 10) continue;
                if (streamTokenizer.ttype != -2) {
                    PsDebug.warning((String)("missing size of face[" + n12 + "] at line=" + streamTokenizer.lineno()));
                    return null;
                }
                int n13 = (int)streamTokenizer.nval;
                n3 = 0;
                while (n3 < n13) {
                    streamTokenizer.nextToken();
                    nArray[n3] = (int)streamTokenizer.nval;
                    ++n3;
                }
                piVectorArray[n12].setSize(n13);
                piVectorArray[n12].set(nArray, n13);
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype != 10) {
                    if (colorArray2 == null) {
                        colorArray2 = new Color[n11];
                        int n14 = 0;
                        while (n14 < n12) {
                            colorArray2[n14] = Color.white;
                            ++n14;
                        }
                    }
                    streamTokenizer.pushBack();
                    n3 = 0;
                    do {
                        dArray[n3] = PgLoader.parseDouble((StreamTokenizer)streamTokenizer);
                        if (!(dArray[n3] > 1.0)) continue;
                        int n15 = n3;
                        dArray[n15] = dArray[n15] / 255.0;
                    } while (++n3 < 3);
                    colorArray2[n12] = new Color((float)dArray[0], (float)dArray[1], (float)dArray[2]);
                    streamTokenizer.nextToken();
                    if (streamTokenizer.ttype == -2) {
                        streamTokenizer.pushBack();
                        d = PgLoader.parseDouble((StreamTokenizer)streamTokenizer);
                    }
                } else if (colorArray2 != null) {
                    colorArray2[n12] = Color.white;
                }
                ++n12;
            }
            streamTokenizer.eolIsSignificant(false);
            if (colorArray2 != null) {
                pgJvxSrc.setElementColors(colorArray2);
                pgJvxSrc.showElementColors(true);
            } else if (colorArray != null) {
                pgJvxSrc.showElementColors(true);
                pgJvxSrc.showElementFromVertexColors(true);
                pgJvxSrc.showSmoothElementColors(true);
            }
            if (d > 0.0) {
                pgJvxSrc.setTransparency(d);
                pgJvxSrc.showTransparency(true);
            }
            return pgJvxSrc;
        }
        catch (IOException iOException) {
            PsDebug.warning((String)("Exception thrown in line=" + streamTokenizer.lineno() + ", Exception = " + iOException));
            return null;
        }
    }

    public PgJvxSrc[] read(BufferedReader bufferedReader) {
        if (bufferedReader == null) {
            PsDebug.warning((String)"missing reader");
            return null;
        }
        PgJvxSrc pgJvxSrc = this.parse(bufferedReader);
        if (pgJvxSrc == null) {
            PsDebug.warning((String)"error during parsing of reader");
            return null;
        }
        this.geomInitType(pgJvxSrc);
        return new PgJvxSrc[]{pgJvxSrc};
    }

    public PgJvxSrc[] read(String string) {
        BufferedReader bufferedReader = PsUtil.open((String)string);
        if (bufferedReader == null) {
            PsDebug.warning((String)("could not open = " + string));
            return null;
        }
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {}
        PgJvxSrc[] pgJvxSrcArray = this.read(bufferedReader);
        if (pgJvxSrcArray != null && pgJvxSrcArray.length > 0 && pgJvxSrcArray[0] != null) {
            if (pgJvxSrcArray.length == 1) {
                pgJvxSrcArray[0].setName(PsUtil.getFileBaseName((String)string));
            } else {
                int n = 0;
                while (n < pgJvxSrcArray.length) {
                    pgJvxSrcArray[n].setName(PsUtil.getFileBaseName((String)string) + "[" + n + "]");
                    ++n;
                }
            }
        }
        return pgJvxSrcArray;
    }

    public PgJvxSrc[][] getAnimations() {
        return this.m_animArr;
    }

    public PgJvxSrc[] getGeometries() {
        return this.m_geomArr;
    }

    public PvDisplayOption getDisplayOption() {
        return this.m_displayOption;
    }

    public void setDisplayOption(PvDisplayOption pvDisplayOption) {
        this.m_displayOption = pvDisplayOption;
    }

    public void setAnimation(boolean bl) {
        this.m_bIsAnimation = bl;
    }

    private PgJvxSrc parseVect(StreamTokenizer streamTokenizer) {
        PsDebug.warning((String)"method parseVect not implemented yet, send your geometry to JavaView authors.");
        return null;
    }

    public boolean write(Writer writer, PgJvxSrc[] pgJvxSrcArray) throws IOException {
        PdVector[] pdVectorArray;
        if (pgJvxSrcArray == null || pgJvxSrcArray.length == 0 || pgJvxSrcArray[0] == null) {
            PsDebug.warning((String)"missing geometry");
            return false;
        }
        PgJvxSrc pgJvxSrc = pgJvxSrcArray[0];
        if (pgJvxSrc.getType() != 33) {
            PsDebug.warning((String)"geometry is not an element set");
            return false;
        }
        String string = "";
        Color[] colorArray = pgJvxSrc.getVertexColors();
        if (colorArray != null) {
            string = string + "C";
        }
        if ((pdVectorArray = pgJvxSrc.getVertexNormals()) != null) {
            string = string + "N";
        }
        Color[] colorArray2 = pgJvxSrc.getElementColors();
        int n = pgJvxSrc.getNumVertices();
        int n2 = pgJvxSrc.getNumElements();
        writer.write("# Produced with JavaView v." + PsConfig.getVersion() + StrNL);
        writer.write("# JavaView is " + PsConfig.getCopyright() + ", " + PsConfig.getHomepage() + StrNL);
        writer.write("# by " + PsConfig.getAuthors() + StrNL);
        writer.write("#     File Format = GeomView OFF" + StrNL);
        writer.write("#     Geometry    = " + pgJvxSrc.getName() + StrNL);
        writer.write("#     Date        = " + new Date().toString() + StrNL);
        writer.write("#" + StrNL);
        writer.write("#     Number of Vertices = " + n + StrNL);
        writer.write("#     Number of Elements = " + n2 + StrNL);
        if (colorArray != null) {
            writer.write("#     Additional: Vertex Colors\n");
        }
        if (pdVectorArray != null) {
            writer.write("#     Additional: Vertex Normals\n");
        }
        if (colorArray2 != null) {
            writer.write("#     Additional: Element Colors\n");
        }
        writer.write("#\n# End of Header\n");
        writer.write(string + "OFF\n");
        writer.write(String.valueOf(pgJvxSrc.getNumVertices()) + " " + String.valueOf(pgJvxSrc.getNumElements()) + " 0\n");
        boolean bl = pgJvxSrc.isShowingTransparency();
        double d = pgJvxSrc.getTransparency();
        writer.write(PgOffLoader.writeVertices(n, pgJvxSrc.getVertices(), colorArray, pdVectorArray, bl, d));
        writer.write(PgOffLoader.writeElements(n2, pgJvxSrc.getElements(), colorArray2, bl, d));
        return true;
    }

    public boolean load(BufferedReader bufferedReader) {
        this.m_geomArr = this.read(bufferedReader);
        return this.m_geomArr != null;
    }

    public boolean isAnimation() {
        return this.m_bIsAnimation;
    }

    private void geomInitType(PgJvxSrc pgJvxSrc) {
        switch (pgJvxSrc.getType()) {
            case 30: {
                pgJvxSrc.showVertices(true);
                return;
            }
            case 33: {
                pgJvxSrc.assureNeighbours();
                pgJvxSrc.showEdges(true);
                pgJvxSrc.showElements(true);
                return;
            }
            case 32: {
                pgJvxSrc.showVertices(true);
                pgJvxSrc.showPolygons(true);
                pgJvxSrc.showEdges(true);
                return;
            }
        }
    }

    public PgGeometryIf[] getSpecializedGeometries() {
        return null;
    }

    protected static String writeVertices(int n, PdVector[] pdVectorArray, Color[] colorArray, PdVector[] pdVectorArray2, boolean bl, double d) {
        if (n <= 0 || pdVectorArray == null || n > pdVectorArray.length) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer("");
        int n2 = 0;
        while (n2 < n) {
            if (pdVectorArray[n2] == null || pdVectorArray[n2].getSize() == 0) {
                PsDebug.warning((String)("missing vertex, ind = " + n2));
                return null;
            }
            int n3 = pdVectorArray[n2].getSize();
            int n4 = 0;
            while (n4 < n3) {
                if (Math.abs(pdVectorArray[n2].m_data[n4]) > 1.0E-10) {
                    stringBuffer.append(" " + PuString.toString((float)((float)pdVectorArray[n2].m_data[n4])));
                } else {
                    stringBuffer.append(" 0.");
                }
                ++n4;
            }
            n4 = n3;
            while (n4 < 3) {
                stringBuffer.append(" 0.");
                ++n4;
            }
            if (pdVectorArray2 != null) {
                n3 = pdVectorArray2[n2].getSize();
                n4 = 0;
                while (n4 < n3) {
                    if (Math.abs(pdVectorArray2[n2].m_data[n4]) > 1.0E-10) {
                        stringBuffer.append(" " + PuString.toString((float)((float)pdVectorArray2[n2].m_data[n4])));
                    } else {
                        stringBuffer.append(" 0.");
                    }
                    ++n4;
                }
                n4 = n3;
                while (n4 < 3) {
                    stringBuffer.append(" 0.");
                    ++n4;
                }
            }
            if (colorArray != null) {
                stringBuffer.append(" " + colorArray[n2].getRed() + " " + colorArray[n2].getGreen() + " " + colorArray[n2].getBlue());
                if (bl && d > 0.0) {
                    stringBuffer.append(" " + String.valueOf(d));
                }
            }
            stringBuffer.append(StrNL);
            ++n2;
        }
        return stringBuffer.toString();
    }

    protected static String writeElements(int n, PiVector[] piVectorArray, Color[] colorArray, boolean bl, double d) {
        if (n <= 0 || piVectorArray == null || n > piVectorArray.length) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer("");
        int n2 = 0;
        while (n2 < n) {
            if (piVectorArray[n2] == null) {
                PsDebug.warning((String)("missing element, ind = " + n2));
                return null;
            }
            stringBuffer.append(String.valueOf(piVectorArray[n2].getSize()));
            int n3 = 0;
            while (n3 < piVectorArray[n2].m_data.length) {
                stringBuffer.append(" " + String.valueOf(piVectorArray[n2].m_data[n3]));
                ++n3;
            }
            if (colorArray != null) {
                stringBuffer.append(" " + colorArray[n2].getRed() + " " + colorArray[n2].getGreen() + " " + colorArray[n2].getBlue());
                if (bl && d > 0.0) {
                    stringBuffer.append(" " + String.valueOf(d));
                }
            }
            stringBuffer.append(StrNL);
            ++n2;
        }
        return stringBuffer.toString();
    }
}

