/*
 * Decompiled with CFR 0.152.
 */
package jvx.geom;

import java.awt.Color;
import java.util.Vector;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgVectorField;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.project.PvDisplayIf;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuReflect;
import jv.vecmath.PuVectorGeom;
import jvx.geom.PgVertexStar;
import jvx.geom.PuPriorityQueue;
import jvx.project.PjWorkshop;

public class PwVectorField
extends PjWorkshop {
    private static final double SINGULARITY_VERTEX_SIZE = 3.0;
    public static final int TYPE_ROTATION = 0;
    public static final int TYPE_GRADIENT = 1;
    public static final int TYPE_STRAIGHT = 2;
    public static final int TYPE_LINEAR = 3;
    public static final int TYPE_Z_K = 4;
    public static final int TYPE_1_Z_K = 5;
    protected int TYPE_MAX = 5;
    protected final String[] TYPE_STRINGS = new String[]{PsConfig.getMessage((int)54210), PsConfig.getMessage((int)54211), PsConfig.getMessage((int)54212), PsConfig.getMessage((int)54213), PsConfig.getMessage((int)54214), PsConfig.getMessage((int)54395)};
    private static final Color COLOR_NOTSELECTED = Color.yellow;
    private static final Color COLOR_SELECTED = Color.red;
    protected PgElementSet m_elemSet = null;
    protected PgPointSet m_pointSet = null;
    protected boolean m_bAllowConvert = true;
    protected PiVector m_centerType = null;
    protected PgPointSet m_centers = null;
    protected int m_dim = 0;
    protected PuInteger m_centerIndex;
    protected boolean m_bMakeTangential = true;
    protected int m_numVF = -1;
    protected PgVectorField m_saveVF = null;
    protected PgVectorField m_VF = null;
    protected PvDisplayIf m_disp;
    protected PuDouble m_slope;
    protected PuDouble m_principleA;
    protected PuDouble m_principleB;
    protected PuDouble m_angleExp;
    protected PuDouble m_slope2;
    protected PuDouble m_centerInfluence;
    protected PuDouble m_angleStraight;
    protected PuDouble m_xStretch;
    protected PuDouble m_yStretch;
    protected PuDouble m_rotation;
    protected PuDouble m_sheer;
    protected PuDouble m_decay;
    protected PuDouble m_decInner;
    protected PuDouble m_zkFact;
    protected PuInteger m_power;
    protected PuDouble m_1_zkFact;
    protected PuInteger m_1_zkPower;
    protected PuDouble m_scale;
    protected static final int P_INFL = 0;
    protected static final int P_ANGSTR = 1;
    protected static final int P_SLOP = 2;
    protected static final int P_PRINCA = 3;
    protected static final int P_PRINCB = 4;
    protected static final int P_ANGEXP = 5;
    protected static final int P_SLOP2 = 6;
    protected static final int P_XSTRETCH = 7;
    protected static final int P_YSTRETCH = 8;
    protected static final int P_ROTATION = 9;
    protected static final int P_SHEER = 10;
    protected static final int P_DECAY = 11;
    protected static final int P_DECINNER = 12;
    protected static final int P_ZKFACT = 13;
    protected static final int P_POWER = 14;
    protected static final int P_1_ZKFACT = 15;
    protected static final int P_1_ZKPOWER = 16;
    protected static final int NUM_PARAMS = 17;
    protected static final double[] P_DEF_VALUES;
    protected PdVector[] m_parameters = new PdVector[17];
    private static /* synthetic */ Class class$jvx$geom$PwVectorField;

    public void setCenterType(int n, int n2) {
        if (this.m_centers == null) {
            PsDebug.warning((String)"No centers.");
            return;
        }
        if (n < 0 || n >= this.m_centers.getNumVertices()) {
            PsDebug.warning((String)("Invalid center index = " + n + "."));
            return;
        }
        if (n2 < 0 || n2 > this.TYPE_MAX) {
            PsDebug.warning((String)("Invalid center type = " + n2 + "."));
            return;
        }
        this.m_centerType.setEntry(n, n2);
    }

    public void clearCenter() {
        if (this.m_centers == null) {
            PsDebug.warning((String)"No centers.");
            return;
        }
        this.m_centers.setNumVertices(0);
        this.m_centerType.setSize(0);
        int n = 0;
        do {
            this.m_parameters[n].setSize(0);
        } while (++n < 17);
        this.m_centerIndex.setBounds(0, 0, 0, 0);
    }

    public static void normalizeVectorField(PgVectorField pgVectorField) {
        if (pgVectorField == null) {
            return;
        }
        PdVector[] pdVectorArray = pgVectorField.getVectors();
        int n = 0;
        while (n < pdVectorArray.length) {
            pdVectorArray[n].normalize();
            ++n;
        }
    }

    public void fixVF() {
        if (this.m_VF == null) {
            return;
        }
        if (this.m_saveVF == null) {
            this.m_saveVF = new PgVectorField(this.m_dim);
        }
        this.m_saveVF.copy((PsObject)this.m_VF);
        this.clearCenter();
        this.m_scale.setValue(1.0);
    }

    public void calculateVF() {
        int n;
        int n2;
        if (this.m_centers == null) {
            PsDebug.warning((String)"No centers.");
            return;
        }
        if (this.m_VF == null) {
            PsDebug.warning((String)"No vector field selected.");
            return;
        }
        int n3 = this.m_saveVF.getNumVectors();
        int n4 = this.m_centers.getNumVertices();
        if (this.m_centerIndex.getValue() > 0 && this.m_centers.getNumVertices() > 0) {
            n2 = 0;
            while (n2 < n4) {
                this.m_centers.setVertexColor(n2, COLOR_NOTSELECTED);
                ++n2;
            }
            this.m_centers.setVertexColor(this.m_centerIndex.getValue() - 1, COLOR_SELECTED);
        }
        n2 = this.m_saveVF.getBasedOn();
        if (this.m_VF.getBasedOn() != n2) {
            this.m_VF.setBasedOn(n2);
            if (n2 == 1) {
                this.m_VF.setGeometry((PgPointSet)this.m_elemSet);
            } else {
                this.m_VF.setGeometry(this.m_pointSet);
            }
        }
        if ((n = this.m_VF.getNumVectors()) < 1) {
            return;
        }
        PdVector[] pdVectorArray = this.m_pointSet.getVertices();
        PiVector[] piVectorArray = null;
        PdVector[] pdVectorArray2 = null;
        PdVector[] pdVectorArray3 = null;
        if (this.m_elemSet != null) {
            piVectorArray = this.m_elemSet.getElements();
            pdVectorArray2 = this.m_elemSet.getElementNormals();
            pdVectorArray3 = this.m_elemSet.getVertexNormals();
        }
        PdVector[] pdVectorArray4 = this.m_VF.getVectors();
        PdVector[] pdVectorArray5 = this.m_saveVF.getVectors();
        PdVector pdVector = new PdVector(this.m_dim);
        PdVector pdVector2 = new PdVector(this.m_dim);
        PdVector pdVector3 = null;
        PdVector pdVector4 = null;
        int n5 = 0;
        while (n5 < n) {
            int n6;
            int n7;
            if (n5 < n3) {
                pdVectorArray4[n5].copy(pdVectorArray5[n5]);
            } else {
                pdVectorArray4[n5].setConstant(0.0);
            }
            if (n2 == 0) {
                pdVector3 = pdVectorArray[n5];
                if (pdVectorArray3 != null) {
                    pdVector4 = pdVectorArray3[n5];
                }
            } else if (n2 == 1) {
                pdVector3 = new PdVector(this.m_dim);
                n7 = piVectorArray[n5].getSize();
                n6 = 0;
                while (n6 < n7) {
                    pdVector3.add(pdVectorArray[piVectorArray[n5].getEntry(n6)]);
                    ++n6;
                }
                pdVector3.multScalar(1.0 / (double)n7);
                pdVector4 = pdVectorArray2[n5];
            }
            if (pdVector4 != null) {
                pdVector4.normalize();
            }
            if (this.m_bMakeTangential && this.m_dim > 2) {
                PuVectorGeom.projectOntoPlane((PdVector)pdVectorArray4[n5], (PdVector)pdVector4);
            }
            n7 = 0;
            while (n7 < n4) {
                PdVector pdVector5 = this.m_centers.getVertex(n7);
                n6 = this.m_centerType.getEntry(n7);
                switch (n6) {
                    case 2: {
                        double d6;
                        if (this.m_dim > 2) {
                            pdVector2.copy(pdVector5);
                            if (this.m_bMakeTangential && this.m_elemSet != null) {
                                PuVectorGeom.projectOntoPlane((PdVector)pdVector2, (PdVector)pdVector4);
                            }
                            if (pdVector2.length() > 1.0E-10) {
                                pdVector2.normalize();
                            }
                        } else {
                            d6 = this.m_parameters[1].getEntry(n7) / 180.0 * Math.PI;
                            pdVector2.setEntry(0, Math.cos(d6));
                            pdVector2.setEntry(1, Math.sin(d6));
                        }
                        pdVector2.multScalar(this.m_parameters[0].getEntry(n7));
                        pdVectorArray4[n5].add(pdVector2);
                        break;
                    }
                    case 0: {
                        double d13;
                        double d2;
                        double d3;
                        double d4;
                        double d5;
                        double d6;
                        pdVector2.sub(pdVector5, pdVector3);
                        if (this.m_dim > 2) {
                            pdVector2.multScalar(Math.exp(-2.0 * pdVector2.length() / Math.max(this.m_parameters[3].getEntry(n7), 1.0E-4)));
                            if (this.m_bMakeTangential && this.m_elemSet != null) {
                                PuVectorGeom.projectOntoPlane((PdVector)pdVector2, (PdVector)pdVector4);
                            }
                            pdVector2.multScalar(this.m_parameters[2].getEntry(n7));
                            if (this.m_elemSet != null) {
                                pdVector.cross(pdVector4, pdVector2);
                            } else {
                                pdVector.cross(pdVector5, pdVector2);
                            }
                            pdVector.setLength(pdVector2.length());
                        } else {
                            d6 = this.m_parameters[3].getEntry(n7);
                            if ((d6 *= d6) < 1.0E-10) {
                                d6 = 1.0E-10;
                            }
                            d5 = this.m_parameters[4].getEntry(n7);
                            if ((d5 *= d5) < 1.0E-10) {
                                d5 = 1.0E-10;
                            }
                            d4 = this.m_parameters[2].getEntry(n7);
                            double d7 = Math.sqrt(Math.exp(1.0));
                            d3 = this.m_parameters[5].getEntry(n7) / 180.0 * Math.PI;
                            d2 = Math.sin(d3);
                            d13 = Math.cos(d3);
                            double d8 = pdVector2.getEntry(0);
                            double d9 = pdVector2.getEntry(1);
                            double d10 = d8 * d13 + d9 * d2;
                            double d11 = d9 * d13 - d8 * d2;
                            double d12 = Math.exp(-0.5 * (d10 * d10 / d6 + d11 * d11 / d5));
                            pdVector.setEntry(0, -d4 * d7 / 2.0 * (d6 + d5) * (d10 * d2 / d6 + d11 * d13 / d5) * d12);
                            pdVector.setEntry(1, d4 * d7 / 2.0 * (d6 + d5) * (d10 * d13 / d6 - d11 * d2 / d5) * d12);
                        }
                        pdVectorArray4[n5].add(pdVector);
                        break;
                    }
                    case 1: {
                        pdVector2.sub(pdVector5, pdVector3);
                        pdVector2.multScalar(Math.exp(-2.0 * pdVector2.length() * 0.15));
                        if (this.m_bMakeTangential && this.m_dim > 2 && this.m_elemSet != null) {
                            PuVectorGeom.projectOntoPlane((PdVector)pdVector2, (PdVector)pdVector4);
                        }
                        pdVector2.multScalar(this.m_parameters[6].getEntry(n7));
                        pdVectorArray4[n5].add(pdVector2);
                        break;
                    }
                    case 3: {
                        if (this.m_dim != 2) break;
                        pdVector2.sub(pdVector3, pdVector5);
                        double d6 = pdVector2.getEntry(0);
                        double d5 = pdVector2.getEntry(1);
                        double d4 = this.m_parameters[11].getEntry(n7);
                        double d = Math.sqrt(d6 * d6 + d5 * d5) - this.m_parameters[12].getEntry(n7);
                        if (d < 0.0) {
                            d = 0.0;
                        }
                        double d3 = Math.exp(-d4 * d * d / 2.0);
                        double d2 = this.m_parameters[9].getEntry(n7);
                        double d13 = this.m_parameters[10].getEntry(n7);
                        pdVector.setEntry(0, this.m_parameters[7].getEntry(n7) * (d6 *= d3) - d2 * (d5 *= d3) + d13 * d5);
                        pdVector.setEntry(1, this.m_parameters[8].getEntry(n7) * d5 + d2 * d6);
                        pdVectorArray4[n5].add(pdVector);
                        break;
                    }
                    case 4: {
                        double d;
                        double d4;
                        if (this.m_dim != 2) break;
                        pdVector2.sub(pdVector5, pdVector3);
                        double d6 = pdVector2.getEntry(0) / 8.0;
                        double d5 = -pdVector2.getEntry(1) / 8.0;
                        int n8 = (int)this.m_parameters[14].getEntry(n7) - 1;
                        if (n8 == 0) {
                            d6 = 1.0;
                            d5 = 0.0;
                        } else if (n8 < 0) {
                            d6 = 0.0;
                            d5 = 0.0;
                        } else {
                            int n9 = 1;
                            while (n9 < n8) {
                                d4 = d5;
                                d5 = 2.0 * d6 * d5;
                                d6 = d6 * d6 - d4 * d4;
                                ++n9;
                            }
                            d = this.m_parameters[13].getEntry(n7);
                            d6 *= (double)(n8 + 1) * d;
                            d5 *= (double)(n8 + 1) * d;
                        }
                        pdVector.setEntry(0, d6);
                        pdVector.setEntry(1, d5);
                        pdVectorArray4[n5].add(pdVector);
                        break;
                    }
                    case 5: {
                        double d;
                        double d4;
                        if (this.m_dim != 2) break;
                        pdVector2.sub(pdVector5, pdVector3);
                        double d6 = pdVector2.getEntry(0);
                        double d5 = pdVector2.getEntry(1);
                        int n10 = (int)this.m_parameters[16].getEntry(n7) + 1;
                        if (n10 < 1) {
                            d6 = 0.0;
                            d5 = 0.0;
                        } else {
                            d = d6 * d6 + d5 * d5;
                            int n11 = 1;
                            while (n11 < n10) {
                                d *= d;
                                ++n11;
                            }
                            if (d < 1.0E-10) {
                                d6 = 0.0;
                                d5 = 0.0;
                            } else {
                                n11 = 1;
                                while (n11 < n10) {
                                    d4 = d5;
                                    d5 = 2.0 * d6 * d5;
                                    d6 = d6 * d6 - d4 * d4;
                                    ++n11;
                                }
                                double d14 = this.m_parameters[15].getEntry(n7);
                                d6 *= (double)(-(n10 - 1)) * d14 / d;
                                d5 *= (double)(-(n10 - 1)) * d14 / d;
                            }
                        }
                        pdVector.setEntry(0, d6);
                        pdVector.setEntry(1, d5);
                        pdVectorArray4[n5].add(pdVector);
                    }
                }
                ++n7;
            }
            pdVectorArray4[n5].multScalar(this.m_scale.getValue());
            ++n5;
        }
        if (this.m_VF.hasInspector("Info") && this.m_VF.getInspector("Info").isShowing()) {
            this.m_VF.getInspector("Info").update((Object)this.m_VF);
        }
    }

    public void setCenterInfluence(int n, double d) {
        if (this.m_centers == null) {
            PsDebug.warning((String)"No centers.");
            return;
        }
        if (n < 0 || n >= this.m_centers.getNumVertices()) {
            PsDebug.warning((String)("Invalid center index = " + n + "."));
            return;
        }
        this.m_parameters[0].setEntry(n, d);
    }

    public boolean update(Object object) {
        if (object == null) {
            return super.update(object);
        }
        if (this.m_bUpdateSender) {
            return super.update(null);
        }
        int n = this.m_centerIndex.getValue();
        if (object == this) {
            this.m_bUpdateSender = true;
            if (this.m_VF != null) {
                this.calculateVF();
                this.m_VF.update(null);
            }
            if (this.m_centers != null) {
                this.m_centers.update((Object)this.m_centers);
            }
            if (this.m_centerIndex != null) {
                this.m_centerIndex.update((Object)this.m_centerIndex);
            }
            if (this.m_VF != null) {
                this.calculateVF();
                this.m_VF.update(null);
            }
            if (this.m_pointSet != null) {
                this.m_pointSet.update(null);
            }
            this.m_bUpdateSender = false;
            return super.update((Object)this);
        }
        if (object == this.m_centers) {
            this.adaptParametersToSize();
            if (this.m_pointSet != null && this.m_VF != null) {
                this.calculateVF();
                this.m_VF.update(null);
                this.m_bUpdateSender = true;
                this.m_pointSet.update(null);
                this.m_bUpdateSender = false;
            }
            return super.update(null);
        }
        if (object == this.m_centerIndex) {
            if (this.m_pointSet != null && this.m_VF != null) {
                this.calculateVF();
                this.m_bUpdateSender = true;
                this.m_VF.update(null);
                this.m_pointSet.update(null);
                this.m_bUpdateSender = false;
            }
            this.m_bUpdateSender = true;
            this.m_centers.update((Object)this.m_centers);
            this.update((Object)this);
            this.m_bUpdateSender = false;
            return super.update(null);
        }
        if (object == this.m_pointSet) {
            this.updateStateFromGeometry();
            this.update((Object)this);
            return super.update(null);
        }
        if (object == this.m_centerInfluence) {
            if (n > 0) {
                this.m_parameters[0].setEntry(n - 1, this.m_centerInfluence.getValue());
            }
        } else if (object == this.m_angleStraight && n > 0) {
            if (n > 0) {
                this.m_parameters[1].setEntry(n - 1, this.m_angleStraight.getValue());
            }
        } else if (object == this.m_slope) {
            if (n > 0) {
                this.m_parameters[2].setEntry(n - 1, this.m_slope.getValue());
            }
        } else if (object == this.m_principleA) {
            if (n > 0) {
                this.m_parameters[3].setEntry(n - 1, this.m_principleA.getValue());
            }
        } else if (object == this.m_principleB) {
            if (n > 0) {
                this.m_parameters[4].setEntry(n - 1, this.m_principleB.getValue());
            }
        } else if (object == this.m_angleExp) {
            if (n > 0) {
                this.m_parameters[5].setEntry(n - 1, this.m_angleExp.getValue());
            }
        } else if (object == this.m_slope2) {
            if (n > 0) {
                this.m_parameters[6].setEntry(n - 1, this.m_slope2.getValue());
            }
        } else if (object == this.m_xStretch) {
            if (n > 0) {
                this.m_parameters[7].setEntry(n - 1, this.m_xStretch.getValue());
            }
        } else if (object == this.m_yStretch) {
            if (n > 0) {
                this.m_parameters[8].setEntry(n - 1, this.m_yStretch.getValue());
            }
        } else if (object == this.m_rotation) {
            if (n > 0) {
                this.m_parameters[9].setEntry(n - 1, this.m_rotation.getValue());
            }
        } else if (object == this.m_sheer) {
            if (n > 0) {
                this.m_parameters[10].setEntry(n - 1, this.m_sheer.getValue());
            }
        } else if (object == this.m_decay) {
            if (n > 0) {
                this.m_parameters[11].setEntry(n - 1, this.m_decay.getValue());
            }
        } else if (object == this.m_decInner) {
            if (n > 0) {
                this.m_parameters[12].setEntry(n - 1, this.m_decInner.getValue());
            }
        } else if (object == this.m_zkFact) {
            if (n > 0) {
                this.m_parameters[13].setEntry(n - 1, this.m_zkFact.getValue());
            }
        } else if (object == this.m_power) {
            if (n > 0) {
                this.m_parameters[14].setEntry(n - 1, this.m_power.getValue());
            }
        } else if (object == this.m_1_zkFact) {
            if (n > 0) {
                this.m_parameters[15].setEntry(n - 1, this.m_1_zkFact.getValue());
            }
        } else if (object == this.m_1_zkPower) {
            if (n > 0) {
                this.m_parameters[16].setEntry(n - 1, this.m_1_zkPower.getValue());
            }
        } else if (object != this.m_scale) {
            return super.update(object);
        }
        if (this.m_VF != null && this.m_pointSet != null) {
            this.calculateVF();
            this.m_bUpdateSender = true;
            this.m_VF.update(null);
            this.m_bUpdateSender = false;
        }
        this.m_bUpdateSender = true;
        this.m_pointSet.update(null);
        this.m_bUpdateSender = false;
        return super.update(null);
    }

    public void makeNewVF(int n) {
        if (this.m_pointSet == null) {
            PsDebug.warning((String)"No geometry set.");
            return;
        }
        if (n == 1 && this.m_elemSet == null) {
            PsDebug.warning((String)"No element set set.");
            return;
        }
        PgVectorField pgVectorField = new PgVectorField(this.m_dim, n);
        pgVectorField.setName(PsConfig.getMessage((int)45053) + "[" + PsObject.getNumObjects() + "]");
        pgVectorField.setGeometry(this.m_pointSet);
        this.m_pointSet.addVectorField(pgVectorField);
        if (this.m_pointSet.getNumVectorFields() == 1) {
            this.setSelectedVF(0);
        }
    }

    public boolean isEnabledConvert() {
        return this.m_bAllowConvert;
    }

    public static void rotateVectorField(PgVectorField pgVectorField) {
        if (pgVectorField == null) {
            return;
        }
        if (pgVectorField.getBasedOn() == 1) {
            PgPointSet pgPointSet = pgVectorField.getGeometry();
            if (pgPointSet == null || !(pgPointSet instanceof PgElementSet)) {
                return;
            }
            PgElementSet pgElementSet = (PgElementSet)pgPointSet;
            if (pgElementSet.getDimOfVertices() != 3) {
                return;
            }
            int n = pgElementSet.getNumElements();
            PdVector pdVector = new PdVector(3);
            pgElementSet.assureElementNormals();
            PdVector[] pdVectorArray = pgElementSet.getElementNormals();
            PdVector[] pdVectorArray2 = pgVectorField.getVectors();
            int n2 = 0;
            while (n2 < n) {
                pdVector.cross(pdVectorArray[n2], pdVectorArray2[n2]);
                pdVectorArray2[n2].copyArray(pdVector);
                ++n2;
            }
            return;
        }
        PgPointSet pgPointSet = pgVectorField.getGeometry();
        if (pgPointSet.getDimOfVertices() != 3) {
            return;
        }
        int n = pgPointSet.getNumVertices();
        PdVector pdVector = new PdVector(3);
        pgPointSet.assureVertexNormals();
        PdVector[] pdVectorArray = pgPointSet.getVertexNormals();
        PdVector[] pdVectorArray3 = pgVectorField.getVectors();
        int n3 = 0;
        while (n3 < n) {
            pdVector.cross(pdVectorArray[n3], pdVectorArray3[n3]);
            pdVectorArray3[n3].copyArray(pdVector);
            ++n3;
        }
    }

    public static void rotateVectorField(PgVectorField pgVectorField, double d) {
        if (pgVectorField == null) {
            return;
        }
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        PdVector pdVector = new PdVector(3);
        if (pgVectorField.getBasedOn() == 1) {
            PgPointSet pgPointSet = pgVectorField.getGeometry();
            if (pgPointSet == null || !(pgPointSet instanceof PgElementSet)) {
                return;
            }
            PgElementSet pgElementSet = (PgElementSet)pgPointSet;
            if (pgElementSet.getDimOfVertices() != 3) {
                return;
            }
            int n = pgElementSet.getNumElements();
            pgElementSet.assureElementNormals();
            PdVector[] pdVectorArray = pgElementSet.getElementNormals();
            PdVector[] pdVectorArray2 = pgVectorField.getVectors();
            int n2 = 0;
            while (n2 < n) {
                pdVector.cross(pdVectorArray[n2], pdVectorArray2[n2]);
                pdVector.multScalar(d3);
                pdVectorArray2[n2].multScalar(d2);
                pdVectorArray2[n2].add(pdVector);
                ++n2;
            }
            return;
        }
        PgPointSet pgPointSet = pgVectorField.getGeometry();
        if (pgPointSet.getDimOfVertices() != 3) {
            return;
        }
        int n = pgPointSet.getNumVertices();
        pgPointSet.assureVertexNormals();
        PdVector[] pdVectorArray = pgPointSet.getVertexNormals();
        PdVector[] pdVectorArray3 = pgVectorField.getVectors();
        int n3 = 0;
        while (n3 < n) {
            pdVector.cross(pdVectorArray[n3], pdVectorArray3[n3]);
            pdVector.multScalar(d3);
            pdVectorArray3[n3].multScalar(d2);
            pdVectorArray3[n3].add(pdVector);
            ++n3;
        }
    }

    private void adaptParametersToSize() {
        int n;
        int n2;
        int n3;
        if (this.m_centers.getNumVertices() > this.m_centerType.getSize()) {
            n3 = this.m_centerType.getSize();
            n2 = this.m_centers.getNumVertices();
            this.m_centerType.setSize(n2);
            n = 0;
            do {
                this.m_parameters[n].setSize(n2);
            } while (++n < 17);
            n = n3;
            while (n < n2) {
                this.m_centers.getVertex(n).setName("" + (n + 1));
                this.m_centerType.setEntry(n, 0);
                int n4 = 0;
                do {
                    this.m_parameters[n4].setEntry(n, P_DEF_VALUES[n4]);
                } while (++n4 < 17);
                ++n;
            }
            this.m_centerIndex.setBounds(1, n2, 1, 2);
        } else if (this.m_centers.getNumVertices() < this.m_centerType.getSize()) {
            n3 = this.m_centers.getNumVertices();
            this.m_centerType.setSize(n3);
            n2 = 0;
            do {
                this.m_parameters[n2].setSize(n3);
            } while (++n2 < 17);
            this.m_centerIndex.setBounds(1, n3, 1, 2);
        }
        n3 = this.m_centers.getNumVertices();
        n2 = this.m_centerIndex.getValue();
        n = 0;
        while (n < n3) {
            if (this.m_centers.hasTagVertex(n, 11)) {
                if (n2 == n + 1) break;
                this.m_centerIndex.setValue(n + 1);
                return;
            }
            ++n;
        }
    }

    public void addCenter(int n) {
        if (this.m_centers == null) {
            PsDebug.warning((String)"missing centers.");
            return;
        }
        PdVector pdVector = new PdVector(this.m_dim);
        pdVector.setConstant(Math.random() / 2.0);
        pdVector.setName("" + (this.m_centers.getNumVertices() + 1));
        this.m_centers.addVertex(pdVector);
        int n2 = this.m_centers.getNumVertices();
        this.m_centerType.setSize(n2);
        this.m_centerType.setEntry(n2 - 1, n);
        int n3 = 0;
        do {
            this.m_parameters[n3].setSize(n2);
            this.m_parameters[n3].setEntry(n2 - 1, P_DEF_VALUES[n3]);
        } while (++n3 < 17);
        this.m_centerIndex.setBounds(1, n2, 1, 2);
        if (this.m_centers.getNumVertices() == 1) {
            this.selectCenter(0);
        }
    }

    public void addCenter(int n, double d) {
        if (this.m_centers == null) {
            PsDebug.warning((String)"No centers.");
            return;
        }
        PdVector pdVector = new PdVector(this.m_dim);
        pdVector.setConstant(Math.random() / 2.0);
        pdVector.setName("" + (this.m_centers.getNumVertices() + 1));
        this.m_centers.addVertex(pdVector);
        int n2 = this.m_centers.getNumVertices();
        this.m_centerType.setSize(n2);
        this.m_centerType.setEntry(n2 - 1, n);
        int n3 = 0;
        do {
            this.m_parameters[n3].setSize(n2);
            this.m_parameters[n3].setEntry(n2 - 1, d);
        } while (++n3 < 17);
        this.m_centerIndex.setBounds(1, n2, 1, 2);
        if (this.m_centers.getNumVertices() == 1) {
            this.selectCenter(0);
        }
    }

    public boolean isEnabledUpdates() {
        return false;
    }

    public void addCenter(PdVector pdVector, int n, double d) {
        if (this.m_centers == null) {
            PsDebug.warning((String)"No centers.");
            return;
        }
        PdVector pdVector2 = new PdVector(this.m_dim);
        pdVector2.copy(pdVector);
        pdVector2.setName("" + (this.m_centers.getNumVertices() + 1));
        this.m_centers.addVertex(pdVector2);
        int n2 = this.m_centers.getNumVertices();
        this.m_centerType.setSize(n2);
        this.m_centerType.setEntry(n2 - 1, n);
        int n3 = 0;
        do {
            this.m_parameters[n3].setSize(n2);
            this.m_parameters[n3].setEntry(n2 - 1, d);
        } while (++n3 < 17);
        this.m_centerIndex.setBounds(1, n2, 1, 2);
        if (this.m_centers.getNumVertices() == 1) {
            this.selectCenter(0);
        }
    }

    public void addCenter(PdVector pdVector, int n) {
        if (this.m_centers == null) {
            PsDebug.warning((String)"missing centers.");
            return;
        }
        PdVector pdVector2 = new PdVector(this.m_dim);
        pdVector2.copy(pdVector);
        pdVector2.setName("" + (this.m_centers.getNumVertices() + 1));
        this.m_centers.addVertex(pdVector2);
        int n2 = this.m_centers.getNumVertices();
        this.m_centerType.setSize(n2);
        this.m_centerType.setEntry(n2 - 1, n);
        int n3 = 0;
        do {
            this.m_parameters[n3].setSize(n2);
            this.m_parameters[n3].setEntry(n2 - 1, P_DEF_VALUES[n3]);
        } while (++n3 < 17);
        this.m_centerIndex.setBounds(1, n2, 1, 2);
        if (this.m_centers.getNumVertices() == 1) {
            this.selectCenter(0);
        }
    }

    protected void convertToOtherBase() {
        if (this.m_VF == null || this.m_saveVF == null) {
            PsDebug.warning((String)"no vector field selected");
            return;
        }
        if (this.m_elemSet == null) {
            PsDebug.warning((String)"geometry is not an element set");
            return;
        }
        if (this.m_saveVF.getBasedOn() == 1) {
            this.m_saveVF.copy((PsObject)PwVectorField.getInterpolatedVertexBased(this.m_saveVF, null));
            return;
        }
        this.m_saveVF.copy((PsObject)PwVectorField.getInterpolatedElementBased(this.m_saveVF, null));
    }

    public void setMakeTangential(boolean bl) {
        this.m_bMakeTangential = bl;
    }

    public int getNumCenters() {
        if (this.m_centers == null) {
            return -1;
        }
        return this.m_centers.getNumVertices();
    }

    public void cancel() {
        if (this.m_saveVF != null) {
            this.m_VF.copy((PsObject)this.m_saveVF);
        }
        this.clearCenter();
        this.m_bUpdateSender = true;
        this.m_pointSet.update(null);
        this.m_bUpdateSender = false;
        this.removeGeometry();
        if (this.m_centers != null) {
            this.m_disp.removeGeometry((PgGeometryIf)this.m_centers);
        }
        this.update((Object)this);
        this.m_disp = null;
    }

    public int getSelectedVFIndex() {
        if (this.m_pointSet == null) {
            return -1;
        }
        return this.m_pointSet.getIndexOfVectorField(this.m_pointSet.getSelectedVectorField());
    }

    public void close() {
        this.fixVF();
        this.update((Object)this);
        this.cancel();
    }

    public void setDisplay(PvDisplayIf pvDisplayIf) {
        if (this.m_disp != null && this.m_centers != null) {
            this.m_disp.removeGeometry((PgGeometryIf)this.m_centers);
        }
        super.setDisplay(pvDisplayIf);
        this.m_disp = pvDisplayIf;
        if (this.m_disp != null && this.m_centers != null) {
            this.m_disp.addGeometry((PgGeometryIf)this.m_centers);
        }
    }

    public void reset() {
    }

    public static PgVectorField getInterpolatedElementBased(PgVectorField pgVectorField, PgVectorField pgVectorField2) {
        PgPointSet pgPointSet = pgVectorField.getGeometry();
        if (!(pgPointSet instanceof PgElementSet)) {
            PsDebug.warning((String)"underlying geometry of vector field is no element set");
            return null;
        }
        PgElementSet pgElementSet = (PgElementSet)pgPointSet;
        int n = pgVectorField.getBasedOn();
        int n2 = pgVectorField.getDimOfVectors();
        PdVector[] pdVectorArray = pgVectorField.getVectors();
        if (pgElementSet == null) {
            PsDebug.warning((String)"geometry of 'this' is no element set");
            return null;
        }
        if (pgVectorField2 == null) {
            pgVectorField2 = new PgVectorField(n2);
            pgVectorField2.setName(PsConfig.getMessage((int)45054) + " " + pgVectorField.getName());
        }
        if (n == 1) {
            pgVectorField2.copy((PsObject)pgVectorField);
            return pgVectorField2;
        }
        pgVectorField2.setBasedOn(1);
        pgVectorField2.setGeometry((PgPointSet)pgElementSet);
        int n3 = pgElementSet.getNumElements();
        PiVector[] piVectorArray = pgElementSet.getElements();
        int n4 = 0;
        while (n4 < n3) {
            PdVector pdVector = new PdVector(n2);
            pdVector.setConstant(0.0);
            int n5 = piVectorArray[n4].getSize();
            int n6 = 0;
            while (n6 < n5) {
                pdVector.add(pdVectorArray[piVectorArray[n4].getEntry(n6)]);
                ++n6;
            }
            pdVector.multScalar(1.0 / (double)n5);
            pgVectorField2.setVector(n4, pdVector);
            ++n4;
        }
        return pgVectorField2;
    }

    public static PgVectorField getInterpolatedVertexBased(PgVectorField pgVectorField, PgVectorField pgVectorField2) {
        PgPointSet pgPointSet = pgVectorField.getGeometry();
        if (!(pgPointSet instanceof PgElementSet)) {
            PsDebug.warning((String)"underlying geometry of vector field is no element set");
            return null;
        }
        PgElementSet pgElementSet = (PgElementSet)pgPointSet;
        int n = pgVectorField.getBasedOn();
        int n2 = pgVectorField.getDimOfVectors();
        PdVector[] pdVectorArray = pgVectorField.getVectors();
        if (pgElementSet == null) {
            PsDebug.warning((String)"geometry of 'this' is no element set");
            return null;
        }
        if (pgVectorField2 == null) {
            pgVectorField2 = new PgVectorField(n2);
            pgVectorField2.setName(PsConfig.getMessage((int)45054) + " " + pgVectorField.getName());
        }
        if (n == 0) {
            pgVectorField2.copy((PsObject)pgVectorField);
            return pgVectorField2;
        }
        pgVectorField2.setBasedOn(0);
        pgVectorField2.setGeometry((PgPointSet)pgElementSet);
        int n3 = pgElementSet.getNumVertices();
        PgVertexStar pgVertexStar = new PgVertexStar();
        PdVector pdVector = new PdVector(n2);
        int n4 = 0;
        while (n4 < n3) {
            PdVector pdVector2 = new PdVector(n2);
            pdVector2.setConstant(0.0);
            pgVertexStar.makeVertexStar(pgElementSet, n4, -1);
            PiVector piVector = pgVertexStar.getElement();
            int n5 = piVector.getSize();
            double d = 0.0;
            int n6 = 0;
            while (n6 < n5) {
                int n7 = piVector.m_data[n6];
                double d2 = pgElementSet.getAreaOfElement(n7);
                pdVector.copy(pdVectorArray[n7]);
                pdVector.multScalar(d2);
                pdVector2.add(pdVector);
                d += d2;
                ++n6;
            }
            if (d > 0.0) {
                pdVector2.multScalar(1.0 / d);
            }
            pgVectorField2.setVector(n4, pdVector2);
            ++n4;
        }
        return pgVectorField2;
    }

    public static PdVector[][] vectorFieldFromEigenVectors(PdVector[][] pdVectorArray, PgElementSet pgElementSet) {
        int n;
        int n2;
        int n3;
        double d;
        double d2;
        PdVector[] pdVectorArray2;
        int n4;
        int n5;
        int n6;
        if (pgElementSet == null) {
            PsDebug.warning((String)"Given geometry is null. No action.");
            return pdVectorArray;
        }
        int n7 = pgElementSet.getNumVertices();
        if (pdVectorArray.length < 2 || pdVectorArray[0].length < n7 || pdVectorArray[1].length < n7) {
            PsDebug.warning((String)"Given vectors do not have the necessary size.");
            return pdVectorArray;
        }
        PiVector[] piVectorArray = pgElementSet.getElements();
        PiVector[] piVectorArray2 = pgElementSet.getNeighbours();
        int n8 = pgElementSet.getNumElements();
        PdVector pdVector = new PdVector(3);
        boolean[] blArray = new boolean[n7];
        PdVector pdVector2 = new PdVector(3);
        PdVector[] pdVectorArray3 = PdVector.realloc(null, (int)2, (int)3);
        PdMatrix pdMatrix = new PdMatrix(3);
        Vector[] vectorArray = new Vector[n7];
        int n9 = 0;
        while (n9 < n7) {
            vectorArray[n9] = new Vector(6, 6);
            ++n9;
        }
        int n10 = 0;
        while (n10 < n8) {
            n6 = piVectorArray[n10].getSize();
            n5 = 0;
            while (n5 < n6) {
                if (piVectorArray2[n10].m_data[n5] <= n10) {
                    n9 = piVectorArray[n10].m_data[(n5 + 1) % n6];
                    int n11 = piVectorArray[n10].m_data[(n5 + 2) % n6];
                    vectorArray[n9].addElement(new Integer(n11));
                    vectorArray[n11].addElement(new Integer(n9));
                }
                ++n5;
            }
            ++n10;
        }
        PiVector[] piVectorArray3 = new PiVector[n7];
        n5 = 0;
        while (n5 < n7) {
            n6 = vectorArray[n5].size();
            piVectorArray3[n5] = new PiVector(n6);
            n4 = 0;
            while (n4 < n6) {
                piVectorArray3[n5].m_data[n4] = (Integer)vectorArray[n5].elementAt(n4);
                ++n4;
            }
            ++n5;
        }
        vectorArray = null;
        boolean[] blArray2 = new boolean[n7];
        int[] nArray = new int[n7];
        int[] nArray2 = new int[n7];
        PuPriorityQueue puPriorityQueue = new PuPriorityQueue(n7);
        int n12 = 0;
        puPriorityQueue.enqueue(0, 0.0);
        nArray2[0] = -1;
        block5: while (n12 < n7) {
            int n13;
            int n14 = puPriorityQueue.extractMin();
            if (n14 == -1) {
                n13 = 0;
                while (n13 < n7) {
                    if (!blArray2[n13]) {
                        puPriorityQueue.enqueue(n13, 0.0);
                        nArray2[n13] = n13;
                        continue block5;
                    }
                    ++n13;
                }
                continue;
            }
            nArray[n12++] = n14;
            blArray2[n14] = true;
            n6 = piVectorArray3[n14].getSize();
            n13 = 0;
            while (n13 < n6) {
                int n15 = piVectorArray3[n14].m_data[n13];
                if (!blArray2[n15]) {
                    double d3 = -Math.min(pdVectorArray[0][n14].length(), pdVectorArray[0][n15].length());
                    if (puPriorityQueue.isElement(n15)) {
                        if (puPriorityQueue.getKey(n15) > d3) {
                            puPriorityQueue.decreaseKey(n15, d3);
                            nArray2[n15] = n14;
                        }
                    } else {
                        puPriorityQueue.enqueue(n15, d3);
                        nArray2[n15] = n14;
                    }
                }
                ++n13;
            }
        }
        pgElementSet.makeVertexNormals();
        PdVector[] pdVectorArray4 = pdVectorArray2 = pgElementSet.getVertexNormals();
        PdVector[][] pdVectorArrayArray = new PdVector[][]{PdVector.realloc(null, (int)n7, (int)3), PdVector.realloc(null, (int)n7, (int)3)};
        int n16 = 0;
        do {
            int n17 = 0;
            while (n17 < n7) {
                pdVectorArrayArray[n16][n17].copyArray(pdVectorArray[n16][n17]);
                pdVectorArrayArray[n16][n17].normalize();
                ++n17;
            }
        } while (++n16 < 2);
        int n18 = 1;
        while (n18 < n7) {
            double d4;
            n5 = nArray[n18];
            n4 = nArray2[n5];
            pdVector2.cross(pdVectorArray4[n4], pdVectorArray4[n5]);
            d2 = PdVector.angleWithOrientation((PdVector)pdVectorArray4[n4], (PdVector)pdVectorArray4[n5], (PdVector)pdVector2);
            PuReflect.makeRotation((PdMatrix)pdMatrix, (PdVector)pdVector2, (double)d2);
            pdVectorArray3[0].leftMultMatrix(pdMatrix, pdVectorArrayArray[0][n4]);
            pdVectorArray3[1].leftMultMatrix(pdMatrix, pdVectorArrayArray[1][n4]);
            if (blArray[n4]) {
                d = Math.abs(PdVector.dot((PdVector)pdVectorArrayArray[0][n5], (PdVector)pdVectorArray3[0])) + Math.abs(PdVector.dot((PdVector)pdVectorArrayArray[1][n5], (PdVector)pdVectorArray3[1]));
                d4 = Math.abs(PdVector.dot((PdVector)pdVectorArrayArray[1][n5], (PdVector)pdVectorArray3[0])) + Math.abs(PdVector.dot((PdVector)pdVectorArrayArray[0][n5], (PdVector)pdVectorArray3[1]));
            } else {
                d4 = Math.abs(PdVector.dot((PdVector)pdVectorArrayArray[0][n5], (PdVector)pdVectorArray3[0])) + Math.abs(PdVector.dot((PdVector)pdVectorArrayArray[1][n5], (PdVector)pdVectorArray3[1]));
                d = Math.abs(PdVector.dot((PdVector)pdVectorArrayArray[1][n5], (PdVector)pdVectorArray3[0])) + Math.abs(PdVector.dot((PdVector)pdVectorArrayArray[0][n5], (PdVector)pdVectorArray3[1]));
            }
            if (d > d4) {
                blArray[n5] = true;
            }
            ++n18;
        }
        n18 = Math.max(n8 / 10, 50);
        boolean bl = true;
        int n19 = 0;
        while (bl && n19 < n18) {
            bl = false;
            ++n19;
            n3 = 0;
            while (n3 < n7) {
                int n20;
                n6 = piVectorArray3[n3].getSize();
                if (blArray[n3]) {
                    n5 = 1;
                    n20 = 0;
                } else {
                    n5 = 0;
                    n20 = 1;
                }
                double d5 = 0.0;
                d = 0.0;
                n2 = 0;
                while (n2 < n6) {
                    int n21;
                    n = piVectorArray3[n3].m_data[n2];
                    if (blArray[n]) {
                        n4 = 1;
                        n21 = 0;
                    } else {
                        n4 = 0;
                        n21 = 1;
                    }
                    pdVector2.cross(pdVectorArray4[n], pdVectorArray4[n3]);
                    d2 = PdVector.angleWithOrientation((PdVector)pdVectorArray4[n], (PdVector)pdVectorArray4[n3], (PdVector)pdVector2);
                    PuReflect.makeRotation((PdMatrix)pdMatrix, (PdVector)pdVector2, (double)d2);
                    pdVectorArray3[0].leftMultMatrix(pdMatrix, pdVectorArrayArray[0][n]);
                    pdVectorArray3[1].leftMultMatrix(pdMatrix, pdVectorArrayArray[1][n]);
                    d5 += Math.abs(PdVector.dot((PdVector)pdVectorArrayArray[n5][n3], (PdVector)pdVectorArray3[n4])) + Math.abs(PdVector.dot((PdVector)pdVectorArrayArray[n20][n3], (PdVector)pdVectorArray3[n21]));
                    d += Math.abs(PdVector.dot((PdVector)pdVectorArrayArray[n20][n3], (PdVector)pdVectorArray3[n4])) + Math.abs(PdVector.dot((PdVector)pdVectorArrayArray[n5][n3], (PdVector)pdVectorArray3[n21]));
                    ++n2;
                }
                if (d > d5) {
                    bl = true;
                    blArray[n3] = !blArray[n3];
                }
                ++n3;
            }
        }
        n3 = 0;
        while (n3 < n7) {
            if (blArray[n3]) {
                pdVector.copyArray(pdVectorArray[0][n3]);
                pdVectorArray[0][n3].copyArray(pdVectorArray[1][n3]);
                pdVectorArray[1][n3].copyArray(pdVector);
            }
            ++n3;
        }
        n3 = 1;
        while (n3 < n7) {
            n5 = nArray[n3];
            n4 = nArray2[n5];
            pdVector2.cross(pdVectorArray4[n4], pdVectorArray4[n5]);
            d2 = PdVector.angleWithOrientation((PdVector)pdVectorArray4[n4], (PdVector)pdVectorArray4[n5], (PdVector)pdVector2);
            PuReflect.makeRotation((PdMatrix)pdMatrix, (PdVector)pdVector2, (double)d2);
            pdVectorArray3[0].leftMultMatrix(pdMatrix, pdVectorArray[0][n4]);
            pdVectorArray3[1].leftMultMatrix(pdMatrix, pdVectorArray[1][n4]);
            if (PdVector.dot((PdVector)pdVectorArray[0][n5], (PdVector)pdVectorArray3[0]) < 0.0) {
                pdVectorArray[0][n5].multScalar(-1.0);
            }
            if (PdVector.dot((PdVector)pdVectorArray[1][n5], (PdVector)pdVectorArray3[1]) < 0.0) {
                pdVectorArray[1][n5].multScalar(-1.0);
            }
            ++n3;
        }
        n3 = 0;
        do {
            n2 = 0;
            while (n2 < n7) {
                pdVectorArrayArray[n3][n2].copyArray(pdVectorArray[n3][n2]);
                pdVectorArrayArray[n3][n2].normalize();
                ++n2;
            }
        } while (++n3 < 2);
        bl = true;
        n19 = 0;
        while (bl && n19 < n18) {
            bl = false;
            ++n19;
            int n22 = 0;
            while (n22 < n7) {
                n6 = piVectorArray3[n22].getSize();
                double d6 = 0.0;
                double d7 = 0.0;
                int n23 = 0;
                while (n23 < n6) {
                    n = piVectorArray3[n22].m_data[n23];
                    pdVector2.cross(pdVectorArray4[n], pdVectorArray4[n22]);
                    d2 = PdVector.angleWithOrientation((PdVector)pdVectorArray4[n], (PdVector)pdVectorArray4[n22], (PdVector)pdVector2);
                    PuReflect.makeRotation((PdMatrix)pdMatrix, (PdVector)pdVector2, (double)d2);
                    pdVectorArray3[0].leftMultMatrix(pdMatrix, pdVectorArrayArray[0][n]);
                    pdVectorArray3[1].leftMultMatrix(pdMatrix, pdVectorArrayArray[1][n]);
                    d6 += PdVector.dot((PdVector)pdVectorArrayArray[0][n22], (PdVector)pdVectorArray3[0]);
                    d7 += PdVector.dot((PdVector)pdVectorArrayArray[1][n22], (PdVector)pdVectorArray3[1]);
                    ++n23;
                }
                if (d6 < 0.0) {
                    bl = true;
                    pdVectorArray[0][n22].multScalar(-1.0);
                    pdVectorArrayArray[0][n22].multScalar(-1.0);
                }
                if (d7 < 0.0) {
                    bl = true;
                    pdVectorArray[1][n22].multScalar(-1.0);
                    pdVectorArrayArray[1][n22].multScalar(-1.0);
                }
                ++n22;
            }
        }
        return pdVectorArray;
    }

    public PwVectorField() {
        this((PvDisplayIf)null);
    }

    public PwVectorField(PvDisplayIf pvDisplayIf) {
        super(PsConfig.getMessage((int)51090));
        this.setName(PsConfig.getMessage((int)54215));
        this.m_centerIndex = new PuInteger(PsConfig.getMessage((int)54217), (PsUpdateIf)this);
        this.m_centerIndex.setEnabledConfigButton(false);
        this.m_slope = new PuDouble(PsConfig.getMessage((int)54218), (PsUpdateIf)this);
        this.m_slope2 = new PuDouble(PsConfig.getMessage((int)54218), (PsUpdateIf)this);
        this.m_principleA = new PuDouble(PsConfig.getMessage((int)54219), (PsUpdateIf)this);
        this.m_principleB = new PuDouble(PsConfig.getMessage((int)54220), (PsUpdateIf)this);
        this.m_angleExp = new PuDouble(PsConfig.getMessage((int)54179), (PsUpdateIf)this);
        this.m_centerInfluence = new PuDouble(PsConfig.getMessage((int)54307), (PsUpdateIf)this);
        this.m_angleStraight = new PuDouble(PsConfig.getMessage((int)54179), (PsUpdateIf)this);
        this.m_xStretch = new PuDouble(PsConfig.getMessage((int)54486), (PsUpdateIf)this);
        this.m_yStretch = new PuDouble(PsConfig.getMessage((int)54487), (PsUpdateIf)this);
        this.m_rotation = new PuDouble(PsConfig.getMessage((int)54488), (PsUpdateIf)this);
        this.m_sheer = new PuDouble(PsConfig.getMessage((int)54331), (PsUpdateIf)this);
        this.m_decay = new PuDouble(PsConfig.getMessage((int)54489), (PsUpdateIf)this);
        this.m_decInner = new PuDouble(PsConfig.getMessage((int)54490), (PsUpdateIf)this);
        this.m_zkFact = new PuDouble(PsConfig.getMessage((int)54225), (PsUpdateIf)this);
        this.m_power = new PuInteger(PsConfig.getMessage((int)54226), (PsUpdateIf)this);
        this.m_1_zkFact = new PuDouble(PsConfig.getMessage((int)54225), (PsUpdateIf)this);
        this.m_1_zkPower = new PuInteger(PsConfig.getMessage((int)54226), (PsUpdateIf)this);
        this.m_scale = new PuDouble(PsConfig.getMessage((int)54491), (PsUpdateIf)this);
        this.m_centers = new PgPointSet(3);
        this.setCenterGeometryProperties();
        this.m_centers.setParent((PsUpdateIf)this);
        this.m_centerType = new PiVector(0);
        this.m_centerType.setName(PsConfig.getMessage((int)45051));
        int n = 0;
        do {
            this.m_parameters[n] = new PdVector(0);
            this.m_parameters[n].setName(PsConfig.getMessage((int)45052) + " " + (n + 1));
        } while (++n < 17);
        this.setDisplay(pvDisplayIf);
        if (((Object)((Object)this)).getClass() == (class$jvx$geom$PwVectorField != null ? class$jvx$geom$PwVectorField : (class$jvx$geom$PwVectorField = PwVectorField.class$("jvx.geom.PwVectorField")))) {
            this.init();
        }
    }

    public PgVectorField getSelectedVF() {
        return this.m_VF;
    }

    public void setSelectedVF(int n) {
        if (this.m_pointSet == null) {
            PsDebug.warning((String)"No geometry set.");
            return;
        }
        if (n < 0 || n >= this.m_pointSet.getNumVectorFields()) {
            PsDebug.warning((String)("No valid vector field index = " + n + "."));
            return;
        }
        if (this.m_saveVF != null && this.m_VF != null) {
            this.m_VF.copy((PsObject)this.m_saveVF);
        }
        this.m_VF = this.m_pointSet.getVectorField(n);
        if (this.m_saveVF == null) {
            this.m_saveVF = new PgVectorField(this.m_dim);
        }
        this.m_saveVF.copy((PsObject)this.m_VF);
        this.m_pointSet.selectVectorField(this.m_VF);
    }

    public void setEnabledConvert(boolean bl) {
        this.m_bAllowConvert = bl;
    }

    public void selectCenter(int n) {
        this.m_centerIndex.setValue(n + 1);
    }

    public PgElementSet getElementSet() {
        return this.m_elemSet;
    }

    static {
        double[] dArray = new double[17];
        dArray[0] = 1.0;
        dArray[2] = 0.2;
        dArray[3] = 2.0;
        dArray[4] = 1.0;
        dArray[5] = 30.0;
        dArray[6] = 1.0;
        dArray[7] = 0.1;
        dArray[8] = 0.1;
        dArray[9] = 0.1;
        dArray[13] = 1.0;
        dArray[14] = 2.0;
        dArray[15] = 1.0;
        dArray[16] = 1.0;
        P_DEF_VALUES = dArray;
    }

    public void setGeometry(PgPointSet pgPointSet) {
        this.removeGeometry();
        super.setGeometry((PgGeometry)pgPointSet);
        if (pgPointSet instanceof PgElementSet) {
            this.m_elemSet = (PgElementSet)pgPointSet;
        } else {
            this.m_elemSet = null;
            this.m_bMakeTangential = false;
        }
        this.m_pointSet = pgPointSet;
        this.m_pointSet.addUpdateListener((PsUpdateIf)this);
        this.m_pointSet.showVectorArrows(true);
        this.updateStateFromGeometry();
        if (this.m_pointSet.getNumVectorFields() == 0) {
            this.makeNewVF(0);
            PdVector[] pdVectorArray = this.m_pointSet.getBounds();
            int n = this.m_pointSet.getDimOfVertices();
            double d = 0.0;
            PdVector pdVector = new PdVector(n);
            int n2 = 0;
            while (n2 < n) {
                double d2 = pdVectorArray[1].m_data[n2] - pdVectorArray[0].m_data[n2];
                pdVector.m_data[n2] = Math.random() * d2 / 2.0 + pdVectorArray[0].m_data[n2] + d2 / 4.0;
                if (Math.abs(d2) > d) {
                    d = Math.abs(d2);
                }
                ++n2;
            }
            if (d <= 0.0) {
                d = 0.001;
            }
            this.addCenter(pdVector, 0, Math.log(d));
        }
        if (this.m_disp != null) {
            this.m_disp.selectGeometry((PgGeometryIf)this.m_centers);
        }
    }

    public int getSelectedCenter() {
        return this.m_centerIndex.getValue() - 1;
    }

    public void removeCenter(int n) {
        if (this.m_centers == null) {
            PsDebug.warning((String)"No centers.");
            return;
        }
        if (n < 0 || n >= this.m_centers.getNumVertices()) {
            return;
        }
        this.m_centers.removeVertex(n);
        int n2 = this.m_centers.getNumVertices();
        int n3 = n;
        while (n3 < n2) {
            this.m_centers.getVertex(n3).setName("" + (n3 + 1));
            this.m_centerType.setEntry(n3, this.m_centerType.getEntry(n3 + 1));
            int n4 = 0;
            do {
                this.m_parameters[n4].setEntry(n3, this.m_parameters[n4].getEntry(n3 + 1));
            } while (++n4 < 17);
            ++n3;
        }
        this.m_centerType.setSize(n2);
        n3 = 0;
        do {
            this.m_parameters[n3].setSize(n2);
        } while (++n3 < 17);
        this.m_centerIndex.setBounds(1, n2, 1, 2);
        this.adaptParametersToSize();
    }

    public void setEnabledUpdates(boolean bl) {
        this.m_bUpdateSender = !bl;
    }

    private void setCenterGeometryProperties() {
        this.m_centers.setName(PsConfig.getMessage((int)45050));
        this.m_centers.setGlobalVertexSize(3.0);
        this.m_centers.setNumVertices(0);
        this.m_centers.showVertexColors(true);
        this.m_centers.showVertexLabels(true);
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void init() {
        int n = 1;
        if (this.m_centers.getNumVertices() == 0) {
            n = 0;
        }
        this.m_centerIndex.setDefBounds(n, this.m_centers.getNumVertices(), 1, 2);
        this.m_centerIndex.setDefValue(this.m_centers.getNumVertices());
        this.m_centerIndex.init();
        this.m_slope.setDefBounds(-2.0, 2.0, 0.05, 0.5);
        this.m_slope.setDefValue(0.3);
        this.m_slope.init();
        this.m_principleA.setDefBounds(0.01, 5.0, 0.1, 1.0);
        this.m_principleA.setDefValue(1.0);
        this.m_principleA.init();
        this.m_principleB.setDefBounds(0.01, 5.0, 0.1, 1.0);
        this.m_principleB.setDefValue(1.0);
        this.m_principleB.init();
        this.m_angleExp.setDefBounds(-180.0, 180.0, 1.0, 10.0);
        this.m_angleExp.setDefValue(0.0);
        this.m_angleExp.init();
        this.m_slope.setDefBounds(-2.0, 2.0, 0.05, 0.5);
        this.m_slope.setDefValue(0.1);
        this.m_slope.init();
        this.m_centerInfluence.setDefBounds(-5.0, 5.0, 0.1, 1.0);
        this.m_centerInfluence.setDefValue(1.0);
        this.m_centerInfluence.init();
        this.m_angleStraight.setDefBounds(-180.0, 180.0, 1.0, 10.0);
        this.m_angleStraight.setDefValue(0.0);
        this.m_angleStraight.init();
        this.m_xStretch.setDefBounds(-2.0, 2.0, 0.05, 0.5);
        this.m_xStretch.setDefValue(0.1);
        this.m_xStretch.init();
        this.m_yStretch.setDefBounds(-2.0, 2.0, 0.05, 0.5);
        this.m_yStretch.setDefValue(0.1);
        this.m_yStretch.init();
        this.m_rotation.setDefBounds(-2.0, 2.0, 0.05, 0.5);
        this.m_rotation.setDefValue(0.1);
        this.m_rotation.init();
        this.m_sheer.setDefBounds(-3.0, 3.0, 0.1, 0.5);
        this.m_sheer.setDefValue(0.0);
        this.m_sheer.init();
        this.m_decay.setDefBounds(0.0, 10.0, 0.1, 0.5);
        this.m_decay.setDefValue(P_DEF_VALUES[11]);
        this.m_decay.init();
        this.m_decInner.setDefBounds(0.0, 10.0, 0.1, 0.5);
        this.m_decInner.setDefValue(P_DEF_VALUES[12]);
        this.m_decInner.init();
        this.m_zkFact.setDefBounds(0.0, 3.0, 0.1, 0.5);
        this.m_zkFact.setDefValue(0.1);
        this.m_zkFact.init();
        this.m_power.setDefBounds(0, 6, 1, 2);
        this.m_power.setDefValue(2);
        this.m_power.init();
        this.m_1_zkFact.setDefBounds(0.0, 3.0, 0.1, 0.5);
        this.m_1_zkFact.setDefValue(0.1);
        this.m_1_zkFact.init();
        this.m_1_zkPower.setDefBounds(0, 6, 1, 2);
        this.m_1_zkPower.setDefValue(2);
        this.m_1_zkPower.init();
        this.m_scale.setDefBounds(0.0, 10.0, 0.1, 0.5);
        this.m_scale.setDefValue(1.0);
        this.m_scale.init();
    }

    protected void updateStateFromGeometry() {
        this.m_dim = this.m_pointSet.getDimOfVertices();
        if (this.m_centers == null || this.m_centers.getDimOfVertices() != this.m_dim) {
            if (this.m_centers != null && this.m_disp != null) {
                this.m_disp.removeGeometry((PgGeometryIf)this.m_centers);
            }
            this.m_centers = new PgPointSet(this.m_dim);
            this.setCenterGeometryProperties();
            this.m_centers.setParent((PsUpdateIf)this);
            if (this.m_disp != null) {
                this.m_disp.addGeometry((PgGeometryIf)this.m_centers);
            }
        }
        if (this.m_pointSet.getSelectedVectorField() != this.m_VF) {
            this.setSelectedVF(this.m_pointSet.getIndexOfVectorField(this.m_pointSet.getSelectedVectorField()));
        }
        if (this.m_elemSet != null) {
            this.m_elemSet.makeElementNormals();
            this.m_elemSet.makeVertexNormals();
        }
        if (this.m_pointSet.getDimOfVertices() > 2) {
            this.m_principleA.setEnabled(true);
            this.m_principleB.setEnabled(false);
            this.m_angleExp.setEnabled(false);
            this.TYPE_MAX = 2;
            return;
        }
        this.m_principleA.setEnabled(true);
        this.m_principleB.setEnabled(true);
        this.m_angleExp.setEnabled(true);
        this.TYPE_MAX = 5;
    }

    public void removeGeometry() {
        if (this.m_pointSet != null) {
            this.m_pointSet.removeUpdateListener((PsUpdateIf)this);
        }
        this.m_pointSet = null;
        this.m_elemSet = null;
        this.m_VF = null;
        super.removeGeometry();
    }

    public int getCenterType(int n) {
        if (this.m_centerType == null) {
            return -1;
        }
        return this.m_centerType.getEntry(n);
    }
}

