/*
 * Decompiled with CFR 0.152.
 */
package jvx.geom;

import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.number.PdVector_IP;
import jv.number.PuDouble;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PuReflect;
import jvx.project.PjWorkshop;

public class PwTransform
extends PjWorkshop {
    protected PuDouble[] m_scale;
    protected PuDouble[] m_trans;
    protected PuDouble[] m_rotate;
    protected PuDouble m_scaleAll;
    private double[] m_scaleOld;
    private double[] m_transOld;
    private double[] m_rotateOld;
    private double m_scaleAllOld;
    protected PgPointSet m_geom;
    protected int m_dim;
    protected boolean m_bWholeScene;
    protected boolean m_bSelectedGeometriesOnly;
    protected PgPointSet m_pCenter;
    protected boolean m_bUseBaryCenterOfGeom;
    protected boolean m_bSelectedVerticesOnly;
    protected PdVector_IP m_center_IP;
    private static /* synthetic */ Class class$jvx$geom$PwTransform;

    public static void scale(PgPointSet pgPointSet, double d, int n, PdVector pdVector, boolean bl) {
        if (pgPointSet == null) {
            PsDebug.warning((String)"Cannot scale geometry. Geometry s null.");
            return;
        }
        if (n < 0 || n >= pgPointSet.getDimOfVertices()) {
            PsDebug.warning((String)("Cannot scale geometry. Given coordinate " + n + " " + "is out of range."));
            return;
        }
        PdVector[] pdVectorArray = pgPointSet.getVertices();
        int n2 = pgPointSet.getNumVertices();
        double d2 = pdVector.m_data[n];
        if (!bl) {
            int n3 = 0;
            while (n3 < n2) {
                double d3 = pdVectorArray[n3].m_data[n] - d2;
                pdVectorArray[n3].m_data[n] = (d3 *= d) + d2;
                ++n3;
            }
            return;
        }
        int n4 = 0;
        while (n4 < n2) {
            if (pdVectorArray[n4].hasTag(1)) {
                double d4 = pdVectorArray[n4].m_data[n] - d2;
                pdVectorArray[n4].m_data[n] = (d4 *= d) + d2;
            }
            ++n4;
        }
    }

    public static void scale(PgPointSet pgPointSet, double d, int n) {
        PwTransform.scale(pgPointSet, d, n, pgPointSet.getCenterOfGravity(), false);
    }

    public void close() {
        if (this.m_display != null && this.m_pCenter.hasDisplay(this.m_display)) {
            this.m_display.removeGeometry((PgGeometryIf)this.m_pCenter);
            this.m_display.update((Object)this.m_display);
        }
        super.close();
    }

    public void reset() {
        super.reset();
        this.m_geom.copy((PsObject)this.m_geomSave);
        this.m_pCenter.getVertex(0).set(0.0, 0.0, 0.0);
        this.update(this.m_center_IP);
    }

    public PwTransform(PgPointSet pgPointSet) {
        this(pgPointSet.getDimOfVertices());
        this.setGeometry(pgPointSet);
    }

    public PwTransform(int n) {
        super(PsConfig.getMessage((int)48024));
        this.m_dim = n;
        this.m_scale = new PuDouble[n];
        this.m_trans = new PuDouble[n];
        this.m_rotate = new PuDouble[n];
        this.m_scaleOld = new double[n];
        this.m_transOld = new double[n];
        this.m_rotateOld = new double[n];
        int n2 = 0;
        while (n2 < n) {
            this.m_scale[n2] = new PuDouble(PsConfig.getMessage((int)54384) + " " + n2, (PsUpdateIf)this);
            this.m_rotate[n2] = new PuDouble(PsConfig.getMessage((int)54385) + " " + n2, (PsUpdateIf)this);
            this.m_trans[n2] = new PuDouble(PsConfig.getMessage((int)54386) + " " + n2, (PsUpdateIf)this);
            ++n2;
        }
        this.m_scaleAll = new PuDouble(PsConfig.getMessage((int)54470), (PsUpdateIf)this);
        this.m_pCenter = new PgPointSet(n);
        this.m_pCenter.setNumVertices(1);
        PdVector pdVector = this.m_pCenter.getVertex(0);
        pdVector.setName(PsConfig.getMessage((int)54471));
        this.m_pCenter.setName(pdVector.getName());
        this.m_pCenter.showVertexLabels(true);
        this.m_pCenter.addUpdateListener((PsUpdateIf)this);
        this.m_center_IP = new PdVector_IP();
        this.m_center_IP.setTitle("Origin");
        this.m_center_IP.setParent((PsUpdateIf)this);
        this.m_center_IP.setVector(this.m_pCenter.getVertex(0));
        if (((Object)((Object)this)).getClass() == (class$jvx$geom$PwTransform != null ? class$jvx$geom$PwTransform : (class$jvx$geom$PwTransform = PwTransform.class$("jvx.geom.PwTransform")))) {
            this.init();
        }
    }

    private void transformGeometry(PgPointSet pgPointSet, Object object) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n = Math.min(this.m_dim, pgPointSet.getDimOfVertices());
        if (object == this.m_scaleAll) {
            double d = this.m_scaleAll.getValue();
            if (this.m_bUseBaryCenterOfGeom) {
                PwTransform.scale(pgPointSet, d / this.m_scaleAllOld, pgPointSet.getCenterOfGravity(), this.m_bSelectedVerticesOnly);
            } else {
                PwTransform.scale(pgPointSet, d / this.m_scaleAllOld, this.m_pCenter.getVertex(0), this.m_bSelectedVerticesOnly);
            }
            pgPointSet.update((Object)pgPointSet);
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            double d;
            if (object == this.m_trans[n2]) {
                d = this.m_trans[n2].getValue();
                PwTransform.translate(pgPointSet, d - this.m_transOld[n2], n2, this.m_bSelectedVerticesOnly);
                bl = true;
                bl3 = true;
            } else if (object == this.m_scale[n2]) {
                d = this.m_scale[n2].getValue();
                if (this.m_bUseBaryCenterOfGeom) {
                    PwTransform.scale(pgPointSet, d / this.m_scaleOld[n2], n2, pgPointSet.getCenterOfGravity(), this.m_bSelectedVerticesOnly);
                } else {
                    PwTransform.scale(pgPointSet, d / this.m_scaleOld[n2], n2, this.m_pCenter.getVertex(0), this.m_bSelectedVerticesOnly);
                }
                bl2 = true;
                bl = true;
                bl3 = true;
            } else if (object == this.m_rotate[n2]) {
                d = this.m_rotate[n2].getValue();
                if (this.m_bUseBaryCenterOfGeom) {
                    PwTransform.rotate(pgPointSet, (d - this.m_rotateOld[n2]) * Math.PI / 180.0, n2, this.m_bSelectedVerticesOnly);
                } else if (this.m_pCenter != null && this.m_pCenter.getNumVertices() > 0) {
                    PwTransform.rotate(pgPointSet, (d - this.m_rotateOld[n2]) * Math.PI / 180.0, n2, this.m_pCenter.getVertex(0), this.m_bSelectedVerticesOnly);
                }
                bl2 = true;
                bl = true;
                bl3 = true;
            }
            ++n2;
        }
        if (bl2) {
            pgPointSet.makeVertexNormals();
            if (pgPointSet instanceof PgElementSet) {
                PgElementSet pgElementSet = (PgElementSet)pgPointSet;
                pgElementSet.makeElementNormals();
            }
        }
        if (bl) {
            pgPointSet.update((Object)pgPointSet);
        }
        if (bl3) {
            return;
        }
    }

    public static void translate(PgPointSet pgPointSet, double d, int n, boolean bl) {
        if (pgPointSet == null) {
            PsDebug.warning((String)"Cannot translate geometry. Geometry s null.");
            return;
        }
        if (n < 0 || n >= pgPointSet.getDimOfVertices()) {
            PsDebug.warning((String)("Cannot translate geometry. Given coordinate " + n + " " + "is out of range."));
            return;
        }
        PdVector[] pdVectorArray = pgPointSet.getVertices();
        int n2 = pgPointSet.getNumVertices();
        if (!bl) {
            int n3 = 0;
            while (n3 < n2) {
                int n4 = n;
                pdVectorArray[n3].m_data[n4] = pdVectorArray[n3].m_data[n4] + d;
                ++n3;
            }
            return;
        }
        int n5 = 0;
        while (n5 < n2) {
            if (pdVectorArray[n5].hasTag(1)) {
                int n6 = n;
                pdVectorArray[n5].m_data[n6] = pdVectorArray[n5].m_data[n6] + d;
            }
            ++n5;
        }
    }

    public static void translate(PgPointSet pgPointSet, double d, int n) {
        PwTransform.translate(pgPointSet, d, n, false);
    }

    public static void rotate(PgPointSet pgPointSet, double d, int n) {
        if (pgPointSet == null) {
            PsDebug.warning((String)"Cannot rotate geometry. Geometry s null.");
            return;
        }
        PdVector pdVector = pgPointSet.getCenterOfGravity();
        PwTransform.rotate(pgPointSet, d, n, pdVector, false);
    }

    public static void rotate(PgPointSet pgPointSet, double d, int n, boolean bl) {
        if (pgPointSet == null) {
            PsDebug.warning((String)"Cannot rotate geometry. Geometry s null.");
            return;
        }
        PdVector pdVector = pgPointSet.getCenterOfGravity();
        PwTransform.rotate(pgPointSet, d, n, pdVector, bl);
    }

    public static void rotate(PgPointSet pgPointSet, double d, int n, PdVector pdVector, boolean bl) {
        if (pgPointSet == null) {
            PsDebug.warning((String)"Cannot rotate geometry. Geometry is null.");
            return;
        }
        if (n < 0 || n >= pgPointSet.getDimOfVertices()) {
            PsDebug.warning((String)("Cannot rotate geometry. Given coordinate " + n + " " + "is out of range."));
            return;
        }
        if (pdVector == null || pdVector.getSize() != 3) {
            PsDebug.warning((String)"Cannot rotate geometry. Space dimension is not equal three.");
            return;
        }
        int n2 = pgPointSet.getDimOfVertices();
        PdVector pdVector2 = new PdVector(n2);
        pdVector2.m_data[n] = 1.0;
        PdMatrix pdMatrix = PuReflect.rotateLine((PdVector)pdVector, (PdVector)pdVector2, (double)d);
        int n3 = pgPointSet.getNumVertices();
        PdVector[] pdVectorArray = pgPointSet.getVertices();
        PdVector pdVector3 = new PdVector(n2);
        if (!bl) {
            int n4 = 0;
            while (n4 < n3) {
                pdVector3.copyArray(pdVectorArray[n4]);
                pdVectorArray[n4].leftMultAffin(pdMatrix, pdVector3, true);
                ++n4;
            }
            return;
        }
        int n5 = 0;
        while (n5 < n3) {
            if (pdVectorArray[n5].hasTag(1)) {
                pdVector3.copyArray(pdVectorArray[n5]);
                pdVectorArray[n5].leftMultAffin(pdMatrix, pdVector3, true);
            }
            ++n5;
        }
    }

    public static void rotate(PgPointSet pgPointSet, double d, int n, PdVector pdVector) {
        PwTransform.rotate(pgPointSet, d, n, pdVector, false);
    }

    public boolean update(Object object) {
        if (object == this.m_pCenter) {
            this.m_center_IP.update((Object)this.m_pCenter.getVertex(0));
            return true;
        }
        boolean bl = false;
        int n = this.m_dim;
        if (object == this.m_scaleAll) {
            bl = true;
        } else {
            int n2 = 0;
            while (n2 < n) {
                if (object == this.m_trans[n2] || object == this.m_scale[n2] || object == this.m_rotate[n2]) {
                    bl = true;
                    break;
                }
                ++n2;
            }
        }
        if (bl) {
            int n3;
            if (this.m_bWholeScene) {
                PgGeometryIf[] pgGeometryIfArray = this.m_display.getGeometries();
                n3 = 0;
                while (n3 < pgGeometryIfArray.length) {
                    if (pgGeometryIfArray[n3] instanceof PgPointSet && pgGeometryIfArray[n3] != this.m_pCenter) {
                        this.transformGeometry((PgPointSet)pgGeometryIfArray[n3], object);
                    }
                    ++n3;
                }
            } else if (this.m_bSelectedGeometriesOnly) {
                PgGeometryIf[] pgGeometryIfArray = this.m_display.getVisibleGeometries();
                n3 = 0;
                while (n3 < pgGeometryIfArray.length) {
                    if (pgGeometryIfArray[n3] instanceof PgPointSet && pgGeometryIfArray[n3] != this.m_pCenter) {
                        this.transformGeometry((PgPointSet)pgGeometryIfArray[n3], object);
                    }
                    ++n3;
                }
            } else {
                this.transformGeometry(this.m_geom, object);
            }
            this.m_scaleAllOld = this.m_scaleAll.getValue();
            int n4 = 0;
            while (n4 < n) {
                this.m_transOld[n4] = this.m_trans[n4].getValue();
                this.m_scaleOld[n4] = this.m_scale[n4].getValue();
                this.m_rotateOld[n4] = this.m_rotate[n4].getValue();
                ++n4;
            }
            return true;
        }
        if (object == this.m_center_IP) {
            this.m_pCenter.update((Object)this.m_pCenter);
            return true;
        }
        return super.update(object);
    }

    public void setGeometry(PgPointSet pgPointSet) {
        super.setGeometry((PgGeometry)pgPointSet);
        this.m_geom = pgPointSet;
        double d = this.m_geom.getDiameter();
        int n = 0;
        while (n < this.m_dim) {
            this.m_trans[n].setBounds(-3.0 * d, 3.0 * d, 0.01 * d, 0.1 * d);
            this.m_trans[n].update((Object)this.m_trans[n]);
            ++n;
        }
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void init() {
        super.init();
        int n = Math.max(this.m_dim, this.m_scale.length);
        int n2 = 0;
        while (n2 < n) {
            this.m_scaleOld[n2] = 1.0;
            this.m_transOld[n2] = 0.0;
            this.m_rotateOld[n2] = 0.0;
            this.m_scale[n2].setDefBounds(0.1, 10.0, 0.1, 1.0);
            this.m_scale[n2].setDefValue(1.0);
            this.m_scale[n2].init();
            this.m_trans[n2].setDefBounds(-10.0, 10.0, 0.1, 1.0);
            this.m_trans[n2].setDefValue(0.0);
            this.m_trans[n2].init();
            this.m_rotate[n2].setDefBounds(-360.0, 360.0, 1.0, 10.0);
            this.m_rotate[n2].setDefValue(0.0);
            this.m_rotate[n2].init();
            ++n2;
        }
        this.m_scaleAll.setDefBounds(0.1, 10.0, 0.1, 1.0);
        this.m_scaleAll.setDefValue(1.0);
        this.m_scaleAll.init();
        this.m_scaleAllOld = 1.0;
        this.m_bUseBaryCenterOfGeom = true;
        this.m_bWholeScene = false;
        this.m_bSelectedGeometriesOnly = false;
        this.m_bSelectedVerticesOnly = false;
    }

    public static void scale(PgPointSet pgPointSet, double d, PdVector pdVector, boolean bl) {
        if (pgPointSet == null) {
            PsDebug.warning((String)"Cannot scale geometry. Geometry s null.");
            return;
        }
        PdVector[] pdVectorArray = pgPointSet.getVertices();
        int n = pgPointSet.getNumVertices();
        int n2 = pgPointSet.getDimOfVertices();
        if (!bl) {
            int n3 = 0;
            while (n3 < n) {
                int n4 = 0;
                while (n4 < n2) {
                    double d2 = pdVectorArray[n3].m_data[n4] - pdVector.m_data[n4];
                    pdVectorArray[n3].m_data[n4] = (d2 *= d) + pdVector.m_data[n4];
                    ++n4;
                }
                ++n3;
            }
            return;
        }
        int n5 = 0;
        while (n5 < n) {
            int n6 = 0;
            while (n6 < n2) {
                if (pdVectorArray[n5].hasTag(1)) {
                    double d3 = pdVectorArray[n5].m_data[n6] - pdVector.m_data[n6];
                    pdVectorArray[n5].m_data[n6] = (d3 *= d) + pdVector.m_data[n6];
                }
                ++n6;
            }
            ++n5;
        }
    }

    public static void scale(PgPointSet pgPointSet, double d) {
        PwTransform.scale(pgPointSet, d, pgPointSet.getCenterOfGravity(), false);
    }
}

