/*
 * Decompiled with CFR 0.152.
 */
package jvx.geom;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.MemoryImageSource;
import jv.geom.PgElementSet;
import jv.geom.PgTexture;
import jv.number.PuInteger;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsUpdateIf;
import jv.objectGui.PsImage;
import jv.project.PgGeometry;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.viewer.PvDisplay;
import jvx.geom.PwGeodesic;
import jvx.numeric.PnLIC;
import jvx.project.PjWorkshop;

public class PwTexture
extends PjWorkshop {
    public static String m_defQuadTexture = "images/jvTextureSquareOpaque_sgl.gif";
    public static String m_defTriTexture = "images/jvTextureTriangleOpaque_med.jpg";
    public static String m_defDijkstraTexture = "images/jvTextureDijkstra.gif";
    protected PgElementSet m_geom;
    protected PuInteger m_LICSize;
    protected Dimension m_textureSize = new Dimension(0, 0);
    private static /* synthetic */ Class class$jvx$geom$PwTexture;

    public PwTexture() {
        super(PsConfig.getMessage((int)51050));
        this.m_LICSize = new PuInteger(PsConfig.getMessage((int)54110), (PsUpdateIf)this);
        if (((Object)((Object)this)).getClass() == (class$jvx$geom$PwTexture != null ? class$jvx$geom$PwTexture : (class$jvx$geom$PwTexture = PwTexture.class$("jvx.geom.PwTexture")))) {
            this.init();
        }
    }

    public static void makeDijkstraTexture(PgElementSet pgElementSet) {
        PgTexture pgTexture;
        if (pgElementSet.getDimOfElements() != 3) {
            PgElementSet.triangulate((PgElementSet)pgElementSet);
        }
        if ((pgTexture = pgElementSet.getTexture()) == null) {
            pgTexture = new PgTexture();
        }
        String string = PsConfig.getCodeBase() + m_defDijkstraTexture;
        pgTexture.setImageName(string);
        PsImage psImage = new PsImage(string);
        if (psImage != null) {
            psImage.loadImage();
            Image image = psImage.getImage();
            if (image != null) {
                pgTexture.setImage(image);
            }
        }
        pgElementSet.setTexture(pgTexture);
        pgElementSet.assureElementTextures();
        int n = pgElementSet.getNumElements();
        int n2 = pgElementSet.getNumVertices();
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            if (pgElementSet.hasTagVertex(n4, 1)) {
                ++n3;
            }
            ++n4;
        }
        PiVector piVector = new PiVector();
        if (n3 == 0) {
            piVector.setSize(1);
            piVector.m_data[0] = 0;
        } else {
            piVector.setSize(n3);
            int n5 = 0;
            int n6 = 0;
            while (n6 < n2) {
                if (pgElementSet.hasTagVertex(n6, 1)) {
                    piVector.m_data[n5] = n6;
                    ++n5;
                }
                ++n6;
            }
        }
        PdVector[][] pdVectorArray = pgElementSet.getElementTextures();
        PiVector piVector2 = PwGeodesic.getDijkstraDistance(pgElementSet, piVector);
        int n7 = 0;
        while (n7 < n) {
            PiVector piVector3 = pgElementSet.getElement(n7);
            int n8 = 0;
            if (piVector2.m_data[piVector3.m_data[1]] < piVector2.m_data[piVector3.m_data[n8]]) {
                n8 = 1;
            }
            if (piVector2.m_data[piVector3.m_data[2]] < piVector2.m_data[piVector3.m_data[n8]]) {
                n8 = 2;
            }
            int n9 = (n8 + 1) % 3;
            int n10 = (n8 + 2) % 3;
            if (piVector2.m_data[piVector3.m_data[n9]] == piVector2.m_data[piVector3.m_data[n8]] && piVector2.m_data[piVector3.m_data[n10]] == piVector2.m_data[piVector3.m_data[n8]]) {
                pdVectorArray[n7][n8].set(0.0, 0.0);
                pdVectorArray[n7][n9].set(0.5, 0.01);
                pdVectorArray[n7][n10].set(1.0, 0.0);
            } else if (piVector2.m_data[piVector3.m_data[n9]] == piVector2.m_data[piVector3.m_data[n8]]) {
                pdVectorArray[n7][n8].set(0.0, 0.0);
                pdVectorArray[n7][n9].set(1.0, 0.0);
                pdVectorArray[n7][n10].set(0.5, 1.0);
            } else if (piVector2.m_data[piVector3.m_data[n10]] == piVector2.m_data[piVector3.m_data[n8]]) {
                pdVectorArray[n7][n8].set(0.0, 0.0);
                pdVectorArray[n7][n9].set(0.5, 1.0);
                pdVectorArray[n7][n10].set(1.0, 0.0);
            } else {
                pdVectorArray[n7][n8].set(0.5, 0.0);
                pdVectorArray[n7][n9].set(1.0, 1.0);
                pdVectorArray[n7][n10].set(0.0, 1.0);
            }
            ++n7;
        }
        pgElementSet.showElementTexture(true);
    }

    public boolean update(Object object) {
        if (object == null) {
            super.update(null);
        } else if (object == this.m_LICSize) {
            return true;
        }
        return super.update(object);
    }

    public void setGeometry(PgElementSet pgElementSet) {
        super.setGeometry((PgGeometry)pgElementSet);
        if (pgElementSet.getDimOfElements() != 3) {
            PsDebug.warning((String)"geometry must be a triangulation");
            PgElementSet.triangulate((PgElementSet)pgElementSet);
        }
        this.m_geom = pgElementSet;
    }

    public void burn() {
        int n = this.m_LICSize.getValue();
        double[] dArray = PnLIC.makeElementTextureCoords(this.m_geom, n);
        if (dArray[0] < 1.0E-10) {
            return;
        }
        int n2 = (int)dArray[1];
        int n3 = (int)dArray[2];
        int[] nArray = new int[n2 * n3];
        PgTexture pgTexture = new PgTexture();
        pgTexture.setImage(PsConfig.getFrame().createImage(new MemoryImageSource(n2, n3, nArray, 0, n2)));
        this.m_geom.setTexture(pgTexture);
        this.m_geom.showElementTexture(true);
        this.m_geom.update((Object)this.m_geom);
        ((PvDisplay)this.getDisplay()).burn();
        ((PvDisplay)this.getDisplay()).repaint();
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public int getLicSize() {
        return this.m_LICSize.getValue();
    }

    public void setLicSize(int n) {
        this.m_LICSize.setValue(n);
    }

    public void init() {
        super.init();
        this.m_LICSize.setDefBounds(10, 500, 5, 50);
        this.m_LICSize.setDefValue(40);
        this.m_LICSize.init();
    }

    public static void makePatchTexture(PgElementSet pgElementSet) {
        Object object;
        PgTexture pgTexture = pgElementSet.getTexture();
        if (pgTexture == null) {
            pgTexture = new PgTexture();
            object = PsConfig.getCodeBase();
            object = pgElementSet.getDimOfElements() == 3 ? (String)object + m_defTriTexture : (String)object + m_defQuadTexture;
            pgTexture.setImageName((String)object);
            PsImage psImage = new PsImage((String)object);
            if (psImage != null) {
                psImage.loadImage();
                Image image = psImage.getImage();
                if (image != null) {
                    pgTexture.setImage(image);
                }
            }
            pgElementSet.setTexture(pgTexture);
        }
        pgElementSet.assureElementTextures();
        object = pgElementSet.getElementTextures();
        int n = pgElementSet.getNumElements();
        switch (pgElementSet.getDimOfElements()) {
            case 3: {
                int n2 = 0;
                while (n2 < n) {
                    object[n2][0].set(0.0, 0.0);
                    object[n2][1].set(1.0, 0.0);
                    object[n2][2].set(0.5, 1.0);
                    ++n2;
                }
                break;
            }
            case 4: {
                int n3 = 0;
                while (n3 < n) {
                    object[n3][0].set(1.0, 0.0);
                    object[n3][1].set(0.0, 0.0);
                    object[n3][2].set(0.0, 1.0);
                    object[n3][3].set(1.0, 1.0);
                    ++n3;
                }
                break;
            }
            case 5: {
                int n4 = 0;
                while (n4 < n) {
                    object[n4][0].set(0.3, 0.0);
                    object[n4][1].set(0.6, 0.0);
                    object[n4][2].set(1.0, 0.6);
                    object[n4][3].set(0.5, 1.0);
                    object[n4][4].set(0.0, 0.6);
                    ++n4;
                }
                break;
            }
            case 6: {
                int n5 = 0;
                while (n5 < n) {
                    object[n5][0].set(0.25, 0.0);
                    object[n5][1].set(0.75, 0.0);
                    object[n5][2].set(1.0, 0.5);
                    object[n5][3].set(0.75, 1.0);
                    object[n5][4].set(0.25, 1.0);
                    object[n5][5].set(0.0, 0.5);
                    ++n5;
                }
                break;
            }
            case 8: {
                int n6 = 0;
                while (n6 < n) {
                    object[n6][0].set(0.3, 0.0);
                    object[n6][1].set(0.6, 0.0);
                    object[n6][2].set(1.0, 0.3);
                    object[n6][3].set(1.0, 0.6);
                    object[n6][4].set(0.6, 1.0);
                    object[n6][5].set(0.3, 1.0);
                    object[n6][6].set(0.0, 0.6);
                    object[n6][7].set(0.0, 0.3);
                    ++n6;
                }
                break;
            }
            default: {
                int n7 = 0;
                while (n7 < n) {
                    int n8 = pgElementSet.getDimOfElement(n7);
                    if (n8 >= 3) {
                        if (n8 == 3) {
                            object[n7][0].set(1.0, 0.0);
                            object[n7][1].set(0.0, 0.0);
                            object[n7][2].set(0.0, 1.0);
                        } else {
                            object[n7][0].set(1.0, 0.0);
                            object[n7][1].set(0.0, 0.0);
                            object[n7][2].set(0.0, 1.0);
                            object[n7][3].set(1.0, 1.0);
                        }
                    }
                    ++n7;
                }
                break block0;
            }
        }
        pgElementSet.showElementTexture(true);
    }
}

