/*
 * Decompiled with CFR 0.152.
 */
package jvx.geom;

import java.awt.Color;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgVectorField;
import jv.number.PuDouble;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuVectorGeom;
import jv.viewer.PvViewer;
import jvx.numeric.PnBiconjugateGradient;
import jvx.numeric.PnMassMatrix;
import jvx.numeric.PnSparseMatrix;
import jvx.numeric.PnStiffAniso;
import jvx.project.PjWorkshop;

public class PwSmooth
extends PjWorkshop
implements Runnable {
    protected PgElementSet m_geom;
    protected int m_method;
    public static int METHOD_ANISOTROPIC = 0;
    public static int METHOD_ANSIO_PRECRIBED = 1;
    protected PuDouble m_featureDetect = new PuDouble(PsConfig.getMessage((int)54354), (PsUpdateIf)this);
    protected double m_stepwidth;
    protected int m_numOfStepBetweenUpdates;
    protected int m_currLoop;
    protected int m_maxNumLoops;
    protected boolean m_bkeepSelected;
    protected boolean m_bkeepBoundary;
    protected boolean m_bshowVertCol;
    protected boolean m_bUseRedGreen;
    protected boolean m_bImplicit;
    protected boolean m_bStepFunc;
    protected int m_prescSteps;
    protected double m_prescStepWidth;
    protected int m_prescRecompute;
    protected boolean m_bprescRecompute;
    protected boolean m_bUpdateElementNormals;
    protected boolean m_bUpdateVertexNormals;
    protected boolean m_bShowGradient;
    protected int m_methodDetect;
    protected boolean m_bMarkFeatures;
    protected boolean m_bFlip;
    protected PdVector[] anisoAreaGrad;
    protected PdVector[] volGrad;
    PgVectorField m_vf;
    double fac = 0.8;
    double val = 1.0;
    boolean b = true;
    private boolean btest = false;
    protected PdVector m_mean;
    protected PdVector[] aVolGrad;
    protected boolean[] onEdge;
    protected boolean m_useScaleColor = false;
    protected double m_scaleColor = 0.004;
    protected double colVal = 0.0;
    protected PnBiconjugateGradient m_solver;
    protected PdVector m_Coord;
    protected PdVector m_newCoord;
    protected PnStiffAniso m_A;
    private PnMassMatrix m_massMatrix;
    protected boolean m_bUseMassMatrix;
    protected boolean m_bUseLumpedMass;
    protected Thread m_thread;
    protected boolean m_bRunning = false;
    protected boolean m_bStopped = true;
    private boolean createImages = false;
    private int imagenr = 1;
    private String imagename = "d:\\_tmp\\geom";
    private int width = 1280;
    private int height = 1024;
    private int type = 54;
    private String fileExt = ".ppm";
    public PvViewer viewer;
    private boolean createModels = false;
    private boolean createDispFile = true;
    private int modelType = 48;
    private int dispFileType = 59;
    private String modelFileExt = ".obj";
    protected long m_time = 0L;
    protected double m_solverErr = 0.0;
    protected int m_solverIter = 0;
    private static /* synthetic */ Class class$jvx$geom$PwSmooth;

    public void stop() {
        if (this.m_bRunning) {
            this.m_bRunning = false;
            this.m_thread = null;
            this.updatePanels(this);
        }
    }

    public void smoothingStep() {
        if (this.m_bImplicit) {
            this.smoothImplicit();
        } else {
            this.moveVertices(this.computeGradient());
        }
        if (this.m_bUpdateElementNormals) {
            this.m_geom.makeElementNormals();
        }
        if (this.m_bUpdateVertexNormals) {
            this.m_geom.makeVertexNormals();
        }
    }

    public boolean isUsingImplicit() {
        return this.m_bImplicit;
    }

    protected void showNone() {
        this.m_geom.removeVectorField((PgGeometryIf)this.m_vf);
        this.m_vf = null;
    }

    private PdVector[] computeGradient() {
        int n;
        int n2;
        if (this.m_method == METHOD_ANISOTROPIC) {
            this.anisoAreaGrad();
        } else {
            if (this.m_bprescRecompute || this.aVolGrad == null) {
                this.aVolGrad();
                this.computeHE();
                this.smoothHE();
            } else {
                this.anisoAreaGrad();
            }
            n2 = this.m_geom.getNumVertices();
            n = this.m_geom.getDimOfVertices();
            int n3 = 0;
            while (n3 < n2) {
                int n4 = 0;
                while (n4 < n) {
                    int n5 = n4;
                    this.anisoAreaGrad[n3].m_data[n5] = this.anisoAreaGrad[n3].m_data[n5] + this.m_mean.m_data[n3] * this.aVolGrad[n3].m_data[n4];
                    ++n4;
                }
                ++n3;
            }
        }
        if (this.btest) {
            this.volGradient();
            n2 = this.m_geom.getNumVertices();
            n = 0;
            while (n < n2) {
                PsDebug.message((String)(n + " volgrad: " + 3.0 * this.anisoAreaGrad[n].length() / this.volGrad[n].length()));
                ++n;
            }
        }
        if (this.m_bUseMassMatrix) {
            if (this.m_massMatrix == null) {
                this.m_massMatrix = new PnMassMatrix(this.m_geom, this.m_bUseLumpedMass);
            } else {
                this.m_massMatrix.useLumpedMass(this.m_bUseLumpedMass);
                this.m_massMatrix.init(this.m_geom);
            }
            this.m_massMatrix.multInvMassMatrix(this.anisoAreaGrad);
        }
        if (this.btest) {
            n2 = this.m_geom.getNumVertices();
            n = 0;
            while (n < n2) {
                PsDebug.message((String)(n + " : " + this.anisoAreaGrad[n].length()));
                ++n;
            }
        }
        return this.anisoAreaGrad;
    }

    private void initImplicit() {
        int n = this.m_geom.getNumVertices();
        if (this.m_Coord == null) {
            this.m_Coord = new PdVector(3 * n);
        } else if (this.m_Coord.getSize() != 3 * n) {
            this.m_Coord.setSize(3 * n);
        }
        if (this.m_newCoord == null) {
            this.m_newCoord = new PdVector(3 * n);
        } else if (this.m_newCoord.getSize() != 3 * n) {
            this.m_newCoord.setSize(3 * n);
        }
        if (this.m_A == null) {
            this.m_A = new PnStiffAniso(this.m_geom);
        } else if (this.m_A.m_nop != n) {
            this.m_A = new PnStiffAniso(this.m_geom);
        }
        if (this.m_solver == null) {
            this.m_solver = new PnBiconjugateGradient();
            this.m_solver.setDimension(3);
        }
        if (this.m_bUseMassMatrix) {
            if (this.m_massMatrix == null) {
                this.m_massMatrix = new PnMassMatrix(this.m_geom);
                return;
            }
            if (this.m_massMatrix.m_nop != n) {
                this.m_massMatrix = new PnMassMatrix(this.m_geom);
            }
        }
    }

    public void setKeepBoundary(boolean bl) {
        this.m_bkeepBoundary = bl;
    }

    public boolean getKeepBoundary() {
        return this.m_bkeepBoundary;
    }

    private void computeHE() {
        if (this.m_geom == null) {
            PsDebug.warning((String)"gemetry is null.");
            return;
        }
        int n = this.m_geom.getNumVertices();
        if (this.m_mean == null || this.m_mean.getSize() < n) {
            this.m_mean = new PdVector(n);
        }
        int n2 = 0;
        while (n2 < n) {
            double d;
            this.m_mean.m_data[n2] = PdVector.dot((PdVector)this.volGrad[n2], (PdVector)this.anisoAreaGrad[n2]) < 0.0 ? this.anisoAreaGrad[n2].length() : -this.anisoAreaGrad[n2].length();
            double d2 = this.aVolGrad[n2].length();
            if (d > 1.0E-10) {
                int n3 = n2;
                this.m_mean.m_data[n3] = this.m_mean.m_data[n3] / d2;
            }
            ++n2;
        }
    }

    protected void adjustSlider() {
        int n = this.m_geom.getNumElements();
        PiVector[] piVectorArray = this.m_geom.getElements();
        PdVector[] pdVectorArray = this.m_geom.getVertices();
        PiVector[] piVectorArray2 = this.m_geom.getNeighbours();
        PdVector pdVector = new PdVector(3);
        PdVector pdVector2 = new PdVector(3);
        PdVector pdVector3 = new PdVector(3);
        PdVector pdVector4 = new PdVector(3);
        this.m_geom.makeElementNormals();
        PdVector[] pdVectorArray2 = this.m_geom.getElementNormals();
        double d = 0.0;
        int n2 = 0;
        double d2 = Double.POSITIVE_INFINITY;
        double d3 = Double.NEGATIVE_INFINITY;
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            do {
                if (piVectorArray2[n3].m_data[n4] < n3) continue;
                pdVector3.sub(pdVectorArray[piVectorArray[n3].m_data[(n4 + 2) % 3]], pdVectorArray[piVectorArray[n3].m_data[(n4 + 1) % 3]]);
                d += pdVector3.length();
                ++n2;
                pdVector.cross(pdVectorArray2[n3], pdVector3);
                pdVector3.multScalar(-1.0);
                pdVector2.cross(pdVectorArray2[piVectorArray2[n3].m_data[n4]], pdVector3);
                pdVector4.add(pdVector, pdVector2);
                double d4 = pdVector4.length() / 2.0;
                if (d2 > d4) {
                    d2 = d4;
                }
                if (!(d3 < d4)) continue;
                d3 = d4;
            } while (++n4 < 3);
            ++n3;
        }
        this.m_featureDetect.setBounds(d2 /= 2.0, d3 *= 2.0, (d3 - d2) / 100.0, (d3 - d2) / 10.0);
        this.m_featureDetect.setValue((d /= (double)n2) * 0.5);
        this.m_featureDetect.update((Object)this.m_featureDetect);
    }

    protected void resetVertices() {
        PdVector[] pdVectorArray = this.m_geom.getVertices();
        PgElementSet pgElementSet = (PgElementSet)this.m_geomSave;
        PdVector[] pdVectorArray2 = pgElementSet.getVertices();
        int n = this.m_geom.getNumVertices();
        int n2 = 0;
        while (n2 < n) {
            int n3 = 0;
            do {
                pdVectorArray[n2].m_data[n3] = pdVectorArray2[n2].m_data[n3];
            } while (++n3 < 3);
            ++n2;
        }
        if (this.m_bUpdateElementNormals) {
            this.m_geom.makeElementNormals();
        }
        if (this.m_bUpdateVertexNormals) {
            this.m_geom.makeVertexNormals();
        }
    }

    protected void detectEdges() {
        int n = this.m_geom.getNumVertices();
        if (this.onEdge == null || this.onEdge.length < n) {
            this.onEdge = new boolean[n];
        }
        int n2 = 0;
        while (n2 < n) {
            this.onEdge[n2] = false;
            ++n2;
        }
        int n3 = this.m_geom.getNumElements();
        PiVector[] piVectorArray = this.m_geom.getElements();
        PdVector[] pdVectorArray = this.m_geom.getVertices();
        PiVector[] piVectorArray2 = this.m_geom.getNeighbours();
        PdVector pdVector = new PdVector(3);
        PdVector pdVector2 = new PdVector(3);
        PdVector pdVector3 = new PdVector(3);
        PdVector pdVector4 = new PdVector(3);
        this.m_geom.makeElementNormals();
        PdVector[] pdVectorArray2 = this.m_geom.getElementNormals();
        double d = this.m_featureDetect.getValue();
        n2 = 0;
        while (n2 < n3) {
            int n4 = 0;
            do {
                if (piVectorArray2[n2].m_data[n4] < n2) continue;
                pdVector3.sub(pdVectorArray[piVectorArray[n2].m_data[(n4 + 2) % 3]], pdVectorArray[piVectorArray[n2].m_data[(n4 + 1) % 3]]);
                pdVector.cross(pdVectorArray2[n2], pdVector3);
                pdVector3.multScalar(-1.0);
                pdVector2.cross(pdVectorArray2[piVectorArray2[n2].m_data[n4]], pdVector3);
                pdVector4.add(pdVector, pdVector2);
                double d2 = pdVector4.length();
                if (!(d2 > d)) continue;
                this.onEdge[piVectorArray[n2].m_data[(n4 + 1) % 3]] = true;
                this.onEdge[piVectorArray[n2].m_data[(n4 + 2) % 3]] = true;
            } while (++n4 < 3);
            ++n2;
        }
    }

    public boolean update(Object object) {
        boolean bl = false;
        if (this.m_bShowGradient) {
            this.showGradient();
            bl = true;
        } else if (this.m_vf != null) {
            this.showNone();
            bl = true;
        }
        if (this.m_bshowVertCol) {
            this.updateColors();
            bl = true;
        }
        if (bl) {
            this.m_geom.update((Object)this.m_geom);
        }
        if (object == this.m_featureDetect) {
            return true;
        }
        return super.update(object);
    }

    public void setKeepSelected(boolean bl) {
        this.m_bkeepSelected = bl;
    }

    public boolean getKeepSelected() {
        return this.m_bkeepSelected;
    }

    public void start() {
        if (!this.m_bStopped || this.m_bRunning) {
            return;
        }
        this.m_currLoop = 0;
        this.m_bRunning = true;
        this.m_thread = new Thread((Runnable)this, "JavaView: Smooth Surface");
        this.m_thread.setPriority(5);
        this.m_thread.start();
    }

    protected void initImplicitEuler() {
        int n;
        this.m_A.init(this.m_geom);
        double d = this.m_stepwidth;
        if (this.m_bUseMassMatrix) {
            d *= 3.0 * this.m_geom.getArea() / (double)this.m_geom.getNumVertices();
        }
        int n2 = 0;
        while (n2 < this.m_A.m_nop) {
            n = 0;
            while (n < this.m_A.m_snoe.m_data[n2]) {
                int n3 = n++;
                this.m_A.m_stiff[n2].m_data[n3] = this.m_A.m_stiff[n2].m_data[n3] * d;
            }
            ++n2;
        }
        if (!this.m_bUseMassMatrix) {
            n2 = 0;
            while (n2 < this.m_A.m_nop) {
                if (this.m_A.m_snoe.m_data[n2] > 0) {
                    int n4 = this.m_A.getIndex(n2, n2);
                    this.m_A.m_stiff[n2].m_data[n4] = this.m_A.m_stiff[n2].m_data[n4] + 1.0;
                }
                ++n2;
            }
            return;
        }
        n2 = 0;
        while (n2 < this.m_massMatrix.m_nop) {
            n = 0;
            while (n < this.m_massMatrix.m_snoe.m_data[n2]) {
                if (this.m_massMatrix.m_sindx[n2].m_data[n] >= 0) {
                    int n5 = this.m_A.getIndex(n2, this.m_massMatrix.m_sindx[n2].m_data[n]);
                    this.m_A.m_stiff[n2].m_data[n5] = this.m_A.m_stiff[n2].m_data[n5] + this.m_massMatrix.m_stiff[n2].m_data[n];
                }
                ++n;
            }
            ++n2;
        }
    }

    public boolean isStopped() {
        return this.m_bStopped;
    }

    public void setStepWidth(double d) {
        this.m_stepwidth = d;
    }

    public double getStepWidth() {
        return this.m_stepwidth;
    }

    public boolean isRunning() {
        return this.m_bRunning;
    }

    public void cancel() {
        if (this.m_geomSave != null) {
            PgElementSet pgElementSet = (PgElementSet)this.m_geomSave;
            this.m_geom.showVertices(pgElementSet.isShowingVertices());
            this.m_geom.showVertexColors(pgElementSet.isShowingVectorColors());
            this.m_geom.showElementColors(pgElementSet.isShowingElementColors());
            this.m_geom.showElementFromVertexColors(pgElementSet.isShowingElementFromVertexColors());
            this.m_geom.showSmoothElementColors(pgElementSet.isShowingSmoothElementColors());
        }
        super.cancel();
    }

    public static Color colorMapGray(double d) {
        if (d < 0.0) {
            d = 0.0;
        }
        if (d > 1.0) {
            d = 1.0;
        }
        float f = (float)d;
        return new Color(f, f, f);
    }

    public static Color colorMap(double d) {
        float f;
        float f2;
        if (d < 0.0) {
            d = 0.0;
        }
        if (d > 1.0) {
            d = 1.0;
        }
        if (d > 0.2) {
            f2 = 1.0f;
            f = (float)(0.75 - (d -= 0.2));
            if (f < 0.0f) {
                f += 1.0f;
            }
        } else {
            f = 0.75f;
            d *= 5.0;
            d = d * d * d;
            f2 = (float)d;
        }
        return Color.getHSBColor(f, f2, 1.0f);
    }

    protected void updateColors() {
        int n = this.m_geom.getNumVertices();
        PdVector[] pdVectorArray = this.m_geom.getVertices();
        int n2 = this.m_geom.getNumElements();
        PiVector[] piVectorArray = this.m_geom.getElements();
        PiVector[] piVectorArray2 = this.m_geom.getNeighbours();
        int n3 = this.m_geom.getDimOfVertices();
        PdVector pdVector = new PdVector(n3);
        double[] dArray = new double[3];
        double d = this.m_useScaleColor ? this.m_scaleColor : this.m_featureDetect.getValue();
        double[] dArray2 = new double[3];
        double[] dArray3 = new double[n];
        double d2 = Double.NEGATIVE_INFINITY;
        double d3 = Double.POSITIVE_INFINITY;
        int n4 = 0;
        while (n4 < n2) {
            PiVector piVector = piVectorArray[n4];
            PuVectorGeom.ctg((double[])dArray, (PdVector)pdVectorArray[piVector.m_data[0]], (PdVector)pdVectorArray[piVector.m_data[1]], (PdVector)pdVectorArray[piVector.m_data[2]]);
            int n5 = 0;
            do {
                double d4;
                if (piVectorArray2[n4].m_data[n5] < n4) continue;
                PiVector piVector2 = piVectorArray[piVectorArray2[n4].m_data[n5]];
                PuVectorGeom.ctg((double[])dArray2, (PdVector)pdVectorArray[piVector2.m_data[0]], (PdVector)pdVectorArray[piVector2.m_data[1]], (PdVector)pdVectorArray[piVector2.m_data[2]]);
                int n6 = this.m_geom.getOppVertexLocInd(n4, n5);
                int n7 = piVector.m_data[n5];
                int n8 = piVector.m_data[(n5 + 1) % 3];
                int n9 = piVector.m_data[(n5 + 2) % 3];
                int n10 = piVector2.m_data[n6];
                int n11 = piVector2.m_data[(n6 + 1) % 3];
                int n12 = piVector2.m_data[(n6 + 2) % 3];
                int n13 = 0;
                while (n13 < n3) {
                    pdVector.m_data[n13] = 0.5 * (dArray[(n5 + 1) % 3] * (pdVectorArray[n9].m_data[n13] - pdVectorArray[n7].m_data[n13]) + dArray[(n5 + 2) % 3] * (pdVectorArray[n8].m_data[n13] - pdVectorArray[n7].m_data[n13]) + dArray2[(n6 + 1) % 3] * (pdVectorArray[n12].m_data[n13] - pdVectorArray[n10].m_data[n13]) + dArray2[(n6 + 2) % 3] * (pdVectorArray[n11].m_data[n13] - pdVectorArray[n10].m_data[n13]));
                    ++n13;
                }
                double d5 = pdVector.length();
                if (this.m_methodDetect == 1 && (d4 = PdVector.subNew((PdVector)pdVectorArray[n8], (PdVector)pdVectorArray[n9]).length()) > 1.0E-10) {
                    d5 /= d4;
                }
                if (d5 > d && !this.m_bStepFunc) {
                    pdVector.multScalar(d * d / (d * d + 10.0 * (d5 - d) * (d5 - d)));
                }
                if (dArray3[n8] < d5) {
                    dArray3[n8] = d5;
                }
                if (dArray3[n9] < d5) {
                    dArray3[n9] = d5;
                }
                if (d2 < d5) {
                    d2 = d5;
                }
                if (!(d3 > d5)) continue;
                d3 = d5;
            } while (++n5 < 3);
            ++n4;
        }
        if (this.m_bUseRedGreen) {
            n4 = 0;
            while (n4 < n) {
                if (dArray3[n4] > d) {
                    this.m_geom.setVertexColor(n4, Color.red);
                } else {
                    this.m_geom.setVertexColor(n4, Color.green);
                }
                ++n4;
            }
        } else {
            n4 = 0;
            while (n4 < n) {
                this.m_geom.setVertexColor(n4, PwSmooth.colorMap(dArray3[n4] / d));
                ++n4;
            }
        }
        if (this.m_bMarkFeatures) {
            n4 = 0;
            while (n4 < n) {
                if (dArray3[n4] > d) {
                    pdVectorArray[n4].setTag(1);
                } else {
                    pdVectorArray[n4].clearTag(1);
                }
                ++n4;
            }
        }
        if (this.m_bkeepBoundary) {
            n4 = 0;
            while (n4 < n) {
                if (pdVectorArray[n4].hasTag(14)) {
                    this.m_geom.setVertexColor(n4, Color.red);
                }
                ++n4;
            }
        }
    }

    public PwSmooth() {
        super(PsConfig.getMessage((int)48023));
        this.m_featureDetect.setDefBounds(0.0, 1.0, 0.01, 0.1);
        this.m_featureDetect.setDefValue(0.5);
        if (this.getClass() == (class$jvx$geom$PwSmooth != null ? class$jvx$geom$PwSmooth : (class$jvx$geom$PwSmooth = PwSmooth.class$("jvx.geom.PwSmooth")))) {
            this.init();
        }
    }

    protected void volGradient() {
        if (this.m_geom == null) {
            PsDebug.warning((String)"gemetry is null.");
            return;
        }
        int n = this.m_geom.getNumVertices();
        if (this.volGrad == null || this.volGrad.length < n) {
            this.volGrad = PdVector.realloc(null, (int)n, (int)3);
        }
        PdVector[] pdVectorArray = this.m_geom.getVertices();
        int n2 = this.m_geom.getNumElements();
        PiVector[] piVectorArray = this.m_geom.getElements();
        this.m_geom.makeElementNormals();
        PdVector[] pdVectorArray2 = this.m_geom.getElementNormals();
        PdVector pdVector = new PdVector(3);
        int n3 = 0;
        while (n3 < n) {
            this.volGrad[n3].setConstant(0.0);
            ++n3;
        }
        n3 = 0;
        while (n3 < n2) {
            double d = PdVector.area((PdVector)pdVectorArray[piVectorArray[n3].m_data[0]], (PdVector)pdVectorArray[piVectorArray[n3].m_data[1]], (PdVector)pdVectorArray[piVectorArray[n3].m_data[2]]);
            pdVector.copyArray(pdVectorArray2[n3]);
            pdVector.multScalar(d);
            int n4 = 0;
            do {
                this.volGrad[piVectorArray[n3].m_data[n4]].add(pdVector);
            } while (++n4 < 3);
            ++n3;
        }
    }

    protected void showGradient() {
        if (this.m_vf != null) {
            this.m_vf = this.m_geom.getVectorField(PsConfig.getMessage((int)45069));
        }
        if (this.m_vf == null) {
            this.m_vf = new PgVectorField(3);
            this.m_vf.setName(PsConfig.getMessage((int)45069));
            this.m_geom.addVectorField(this.m_vf);
        }
        this.m_vf.setGeometry((PgPointSet)this.m_geom);
        int n = this.m_geom.getNumVertices();
        PdVector[] pdVectorArray = this.m_vf.getVectors();
        boolean bl = this.m_bprescRecompute;
        this.m_bprescRecompute = true;
        this.computeGradient();
        this.m_bprescRecompute = bl;
        PdVector[] pdVectorArray2 = this.m_geom.getVertices();
        double d = 1.0;
        if (this.m_bUseMassMatrix) {
            d = 3.0 * this.m_geom.getArea() / (double)this.m_geom.getNumVertices();
        }
        int n2 = 0;
        while (n2 < n) {
            if (this.m_bkeepSelected && pdVectorArray2[n2].hasTag(1) || this.m_bkeepBoundary && pdVectorArray2[n2].hasTag(14)) {
                pdVectorArray[n2].setConstant(0.0);
            } else {
                int n3 = 0;
                do {
                    pdVectorArray[n2].m_data[n3] = -d * this.anisoAreaGrad[n2].m_data[n3];
                } while (++n3 < 3);
            }
            ++n2;
        }
    }

    private void aVolGrad() {
        int n;
        if (this.m_geom == null) {
            PsDebug.warning((String)"gemetry is null.");
            return;
        }
        int n2 = this.m_geom.getNumVertices();
        if (this.aVolGrad == null || this.aVolGrad.length < n2) {
            this.aVolGrad = PdVector.realloc(null, (int)n2, (int)3);
        }
        PdVector[] pdVectorArray = this.m_geom.getVertices();
        int n3 = this.m_geom.getNumElements();
        PiVector[] piVectorArray = this.m_geom.getElements();
        PdVector pdVector = new PdVector(3);
        this.anisoAreaGrad();
        this.volGradient();
        this.detectEdges();
        int n4 = 0;
        while (n4 < n2) {
            this.aVolGrad[n4].setConstant(0.0);
            ++n4;
        }
        double[] dArray = new double[3];
        n4 = 0;
        while (n4 < n3) {
            PdVector.angle((double[])dArray, (PdVector)pdVectorArray[piVectorArray[n4].m_data[0]], (PdVector)pdVectorArray[piVectorArray[n4].m_data[1]], (PdVector)pdVectorArray[piVectorArray[n4].m_data[2]]);
            n = 0;
            do {
                if (!this.onEdge[piVectorArray[n4].m_data[n]]) continue;
                pdVector.copyArray(this.anisoAreaGrad[piVectorArray[n4].m_data[(n + 1) % 3]]);
                pdVector.multScalar(dArray[n]);
                this.aVolGrad[piVectorArray[n4].m_data[n]].add(pdVector);
                pdVector.copyArray(this.anisoAreaGrad[piVectorArray[n4].m_data[(n + 2) % 3]]);
                pdVector.multScalar(dArray[n]);
                this.aVolGrad[piVectorArray[n4].m_data[n]].add(pdVector);
            } while (++n < 3);
            ++n4;
        }
        double d = 1.0;
        n4 = 0;
        while (n4 < n2) {
            if (this.onEdge[n4]) {
                this.aVolGrad[n4].normalize();
                pdVector.copyArray(this.anisoAreaGrad[n4]);
                pdVector.setLength(d);
                this.aVolGrad[n4].add(pdVector);
                this.aVolGrad[n4].normalize();
                if (PdVector.dot((PdVector)this.volGrad[n4], (PdVector)this.aVolGrad[n4]) < 0.0) {
                    this.aVolGrad[n4].multScalar(-1.0);
                }
            } else {
                this.aVolGrad[n4].copyArray(this.volGrad[n4]);
            }
            ++n4;
        }
        this.m_geom.makeElementNormals();
        PdVector[] pdVectorArray2 = this.m_geom.getElementNormals();
        double[] dArray2 = new double[n2];
        n4 = 0;
        while (n4 < n3) {
            double d2 = PdVector.area((PdVector)pdVectorArray[piVectorArray[n4].m_data[0]], (PdVector)pdVectorArray[piVectorArray[n4].m_data[1]], (PdVector)pdVectorArray[piVectorArray[n4].m_data[2]]);
            pdVector.copyArray(pdVectorArray2[n4]);
            pdVector.multScalar(d2);
            n = 0;
            do {
                if (!this.onEdge[piVectorArray[n4].m_data[n]]) continue;
                int n5 = piVectorArray[n4].m_data[n];
                dArray2[n5] = dArray2[n5] + d2 * Math.abs(PdVector.dot((PdVector)this.aVolGrad[piVectorArray[n4].m_data[n]], (PdVector)pdVectorArray2[n4]));
            } while (++n < 3);
            ++n4;
        }
        n4 = 0;
        while (n4 < n2) {
            if (this.onEdge[n4]) {
                this.aVolGrad[n4].multScalar(dArray2[n4]);
            }
            ++n4;
        }
    }

    public static boolean scaleGeomByVolume(PgElementSet pgElementSet, double d, double d2, int n) {
        PdVector pdVector = pgElementSet.getCenterOfGravity();
        double d3 = pgElementSet.getVolume();
        int n2 = pgElementSet.getNumVertices();
        PdVector[] pdVectorArray = pgElementSet.getVertices();
        PdVector pdVector2 = new PdVector(3);
        double d4 = 0.01;
        int n3 = 0;
        while (Math.abs(d3 - d) > d2 && n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                pdVector2.sub(pdVectorArray[n4], pdVector);
                pdVector2.multScalar(d4);
                pdVectorArray[n4].add(pdVector2);
                ++n4;
            }
            d3 = pgElementSet.getVolume();
        }
        return n3 != n;
    }

    public void setMethod(int n) {
        if (n < 0 || n > 1) {
            PsDebug.warning((String)("Cannot set Method. Method " + n + " is unknown."));
        }
        this.m_method = n;
    }

    public int getMethod() {
        return this.m_method;
    }

    public void useImplicit(boolean bl) {
    }

    protected void anisoAreaGrad() {
        int n;
        int n2 = this.m_geom.getNumVertices();
        if (this.anisoAreaGrad == null || this.anisoAreaGrad.length < n2) {
            this.anisoAreaGrad = PdVector.realloc(null, (int)n2, (int)3);
        } else {
            n = 0;
            while (n < n2) {
                this.anisoAreaGrad[n].setConstant(0.0);
                ++n;
            }
        }
        int n3 = this.m_geom.getNumElements();
        PiVector[] piVectorArray = this.m_geom.getElements();
        PiVector[] piVectorArray2 = this.m_geom.getNeighbours();
        PdVector[] pdVectorArray = this.m_geom.getVertices();
        int n4 = this.m_geom.getDimOfVertices();
        PdVector pdVector = new PdVector(n4);
        double[] dArray = new double[3];
        double d = this.m_featureDetect.getValue();
        double[] dArray2 = new double[3];
        n = 0;
        while (n < n3) {
            PiVector piVector = piVectorArray[n];
            PuVectorGeom.ctg((double[])dArray, (PdVector)pdVectorArray[piVector.m_data[0]], (PdVector)pdVectorArray[piVector.m_data[1]], (PdVector)pdVectorArray[piVector.m_data[2]]);
            int n5 = 0;
            do {
                double d2;
                if (piVectorArray2[n].m_data[n5] < n) continue;
                PiVector piVector2 = piVectorArray[piVectorArray2[n].m_data[n5]];
                PuVectorGeom.ctg((double[])dArray2, (PdVector)pdVectorArray[piVector2.m_data[0]], (PdVector)pdVectorArray[piVector2.m_data[1]], (PdVector)pdVectorArray[piVector2.m_data[2]]);
                int n6 = this.m_geom.getOppVertexLocInd(n, n5);
                int n7 = piVector.m_data[n5];
                int n8 = piVector.m_data[(n5 + 1) % 3];
                int n9 = piVector.m_data[(n5 + 2) % 3];
                int n10 = piVector2.m_data[n6];
                int n11 = piVector2.m_data[(n6 + 1) % 3];
                int n12 = piVector2.m_data[(n6 + 2) % 3];
                int n13 = 0;
                while (n13 < n4) {
                    pdVector.m_data[n13] = 0.5 * (dArray[(n5 + 1) % 3] * (pdVectorArray[n9].m_data[n13] - pdVectorArray[n7].m_data[n13]) + dArray[(n5 + 2) % 3] * (pdVectorArray[n8].m_data[n13] - pdVectorArray[n7].m_data[n13]) + dArray2[(n6 + 1) % 3] * (pdVectorArray[n12].m_data[n13] - pdVectorArray[n10].m_data[n13]) + dArray2[(n6 + 2) % 3] * (pdVectorArray[n11].m_data[n13] - pdVectorArray[n10].m_data[n13]));
                    ++n13;
                }
                double d3 = pdVector.length();
                if (this.btest) {
                    d2 = PdVector.area((PdVector)pdVectorArray[piVector.m_data[0]], (PdVector)pdVectorArray[piVector.m_data[1]], (PdVector)pdVectorArray[piVector.m_data[2]]);
                    d2 += PdVector.area((PdVector)pdVectorArray[piVector2.m_data[0]], (PdVector)pdVectorArray[piVector2.m_data[1]], (PdVector)pdVectorArray[piVector2.m_data[2]]);
                    PsDebug.message((String)(n + "," + n5 + " , " + d3 + " : " + d3 / (d2 /= 2.0)));
                }
                if (this.m_methodDetect == 1 && (d2 = PdVector.subNew((PdVector)pdVectorArray[n8], (PdVector)pdVectorArray[n9]).length()) > 1.0E-10) {
                    d3 /= d2;
                }
                if (d3 > d) {
                    if (this.m_bStepFunc) continue;
                    pdVector.multScalar(d * d / (d * d + 10.0 * (d3 - d) * (d3 - d)));
                }
                this.anisoAreaGrad[n8].sub(pdVector);
                this.anisoAreaGrad[n9].sub(pdVector);
            } while (++n5 < 3);
            ++n;
        }
    }

    protected void smoothImplicit() {
        int n;
        int n2;
        this.initImplicit();
        int n3 = this.m_geom.getNumVertices();
        PdVector[] pdVectorArray = this.m_geom.getVertices();
        if (this.m_bUseMassMatrix) {
            this.m_massMatrix.useLumpedMass(this.m_bUseLumpedMass);
            this.m_massMatrix.init(this.m_geom);
            n2 = 0;
            do {
                n = 0;
                while (n < n3) {
                    this.m_newCoord.m_data[3 * n + n2] = pdVectorArray[n].m_data[n2];
                    ++n;
                }
            } while (++n2 < 3);
            this.m_Coord = PnSparseMatrix.leftMult(this.m_massMatrix, this.m_newCoord, this.m_Coord, 3);
        } else {
            n = 0;
            while (n < n3) {
                n2 = 0;
                do {
                    this.m_Coord.m_data[3 * n + n2] = pdVectorArray[n].m_data[n2];
                } while (++n2 < 3);
                ++n;
            }
        }
        this.m_A.setFeatureDetect(this.m_featureDetect.getValue());
        this.m_A.useStepFunction(this.m_bStepFunc);
        this.initImplicitEuler();
        double d = this.m_stepwidth;
        if (this.m_method == METHOD_ANSIO_PRECRIBED) {
            this.aVolGrad();
            this.computeHE();
            this.smoothHE();
            if (this.m_bUseMassMatrix) {
                d *= 3.0 * this.m_geom.getArea() / (double)this.m_geom.getNumVertices();
            }
        }
        this.m_newCoord.copyArray(this.m_Coord);
        this.m_solver.linbcg(this.m_A, this.m_newCoord, this.m_Coord);
        this.m_solverErr = this.m_solver.getActualEstimatedError();
        this.m_solverIter = this.m_solver.getActualNumOfTakenIterations();
        n2 = 0;
        do {
            n = 0;
            while (n < n3) {
                if (!(this.m_bkeepBoundary && pdVectorArray[n].hasTag(14) || this.m_bkeepSelected && pdVectorArray[n].hasTag(1))) {
                    pdVectorArray[n].m_data[n2] = this.m_newCoord.m_data[3 * n + n2];
                }
                ++n;
            }
        } while (++n2 < 3);
        if (this.m_method == METHOD_ANSIO_PRECRIBED) {
            n = 0;
            while (n < n3) {
                this.aVolGrad[n].multScalar(this.m_mean.m_data[n]);
                ++n;
            }
            if (this.m_bUseMassMatrix) {
                this.m_massMatrix.multInvMassMatrix(this.aVolGrad);
            }
            n = 0;
            while (n < n3) {
                n2 = 0;
                do {
                    if (this.m_bkeepBoundary && pdVectorArray[n].hasTag(14) || this.m_bkeepSelected && pdVectorArray[n].hasTag(1)) continue;
                    int n4 = n2;
                    pdVectorArray[n].m_data[n4] = pdVectorArray[n].m_data[n4] + d * this.aVolGrad[n].m_data[n2];
                } while (++n2 < 3);
                ++n;
            }
        }
    }

    public void setMaxNumLoops(int n) {
        this.m_maxNumLoops = n;
    }

    public void setGeometry(PgElementSet pgElementSet) {
        super.setGeometry((PgGeometry)pgElementSet);
        this.m_geom = pgElementSet;
        if (this.m_geom.getDimOfElements() != 3) {
            PgElementSet.triangulate((PgElementSet)this.m_geom);
        }
        this.m_geom.markBoundary();
        this.adjustSlider();
        this.m_massMatrix = null;
        this.m_stepwidth = 0.01;
    }

    public int getMaxNumLoops() {
        return this.m_maxNumLoops;
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final void moveVertices(PdVector[] pdVectorArray) {
        double d = this.m_stepwidth;
        if (this.m_bUseMassMatrix) {
            d *= 3.0 * this.m_geom.getArea() / (double)this.m_geom.getNumVertices();
        }
        PdVector[] pdVectorArray2 = this.m_geom.getVertices();
        int n = this.m_geom.getNumVertices();
        if (!this.m_bkeepSelected) {
            if (!this.m_bkeepBoundary) {
                int n2 = 0;
                while (n2 < n) {
                    pdVectorArray2[n2].blendBase(pdVectorArray2[n2], d, pdVectorArray[n2]);
                    ++n2;
                }
                return;
            }
            int n3 = 0;
            while (n3 < n) {
                if (!pdVectorArray2[n3].hasTag(14)) {
                    pdVectorArray2[n3].blendBase(pdVectorArray2[n3], d, pdVectorArray[n3]);
                }
                ++n3;
            }
            return;
        }
        if (!this.m_bkeepBoundary) {
            int n4 = 0;
            while (n4 < n) {
                if (!pdVectorArray2[n4].hasTag(1)) {
                    pdVectorArray2[n4].blendBase(pdVectorArray2[n4], d, pdVectorArray[n4]);
                }
                ++n4;
            }
            return;
        }
        int n5 = 0;
        while (n5 < n) {
            if (!pdVectorArray2[n5].hasTag(1) && !pdVectorArray2[n5].hasTag(14)) {
                pdVectorArray2[n5].blendBase(pdVectorArray2[n5], d, pdVectorArray[n5]);
            }
            ++n5;
        }
    }

    public void setFeatureDetect(double d) {
        this.m_featureDetect.setValue(d);
    }

    public double getFeatureDetect() {
        return this.m_featureDetect.getValue();
    }

    public void run() {
        this.m_bStopped = false;
        while (this.m_thread != null && this.m_bRunning) {
            this.m_bprescRecompute = this.m_currLoop % this.m_prescRecompute == 0;
            this.m_time = -System.currentTimeMillis();
            this.smoothingStep();
            this.m_time += System.currentTimeMillis();
            ++this.m_currLoop;
            if ((this.m_maxNumLoops - this.m_currLoop) % this.m_numOfStepBetweenUpdates == 0) {
                this.update(this);
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
                if (this.viewer != null && (this.createImages || this.createModels)) {
                    if (this.imagenr < 10) {
                        if (this.createImages) {
                            this.viewer.export(this.type, this.imagename + ".000" + this.imagenr + this.fileExt, this.width, this.height);
                        }
                        if (this.createModels) {
                            this.viewer.export(this.modelType, this.imagename + ".000" + this.imagenr + this.modelFileExt);
                            if (this.createDispFile) {
                                this.viewer.export(this.dispFileType, this.imagename + ".000" + this.imagenr + ".jvd");
                            }
                        }
                    } else if (this.imagenr < 100) {
                        if (this.createImages) {
                            this.viewer.export(this.type, this.imagename + ".00" + this.imagenr + this.fileExt, this.width, this.height);
                        }
                        if (this.createModels) {
                            this.viewer.export(this.modelType, this.imagename + ".00" + this.imagenr + this.modelFileExt);
                            if (this.createDispFile) {
                                this.viewer.export(this.dispFileType, this.imagename + ".00" + this.imagenr + ".jvd");
                            }
                        }
                    } else if (this.imagenr < 1000) {
                        if (this.createImages) {
                            this.viewer.export(this.type, this.imagename + ".0" + this.imagenr + this.fileExt, this.width, this.height);
                        }
                        if (this.createModels) {
                            this.viewer.export(this.modelType, this.imagename + ".0" + this.imagenr + this.modelFileExt);
                            if (this.createDispFile) {
                                this.viewer.export(this.dispFileType, this.imagename + ".0" + this.imagenr + ".jvd");
                            }
                        }
                    } else {
                        if (this.createImages) {
                            this.viewer.export(this.type, this.imagename + "." + this.imagenr + this.fileExt, this.width, this.height);
                        }
                        if (this.createModels) {
                            this.viewer.export(this.modelType, this.imagename + "." + this.imagenr + this.modelFileExt);
                            if (this.createDispFile) {
                                this.viewer.export(this.dispFileType, this.imagename + "." + this.imagenr + ".jvd");
                            }
                        }
                    }
                    ++this.imagenr;
                }
            }
            if (this.m_currLoop < this.m_maxNumLoops) continue;
            this.stop();
        }
        this.m_bStopped = true;
        this.update(this);
    }

    public void init() {
        super.init();
        this.m_method = METHOD_ANISOTROPIC;
        this.m_stepwidth = 0.01;
        this.m_maxNumLoops = 100000;
        this.m_numOfStepBetweenUpdates = 10;
        this.m_currLoop = 1;
        this.m_bStepFunc = true;
        this.m_bImplicit = false;
        this.m_featureDetect.init();
        this.m_bkeepSelected = false;
        this.m_bkeepBoundary = true;
        this.m_bshowVertCol = false;
        this.m_bUseRedGreen = false;
        this.m_bUpdateElementNormals = true;
        this.m_bUpdateVertexNormals = true;
        this.m_bShowGradient = false;
        this.m_bUseMassMatrix = true;
        this.m_bUseLumpedMass = true;
        this.m_bFlip = false;
        this.m_prescSteps = 5;
        this.m_prescStepWidth = 0.4;
        this.m_prescRecompute = 1;
        this.m_bprescRecompute = true;
        this.m_methodDetect = 0;
    }

    protected void smoothHE() {
        int n;
        int n2;
        int n3;
        int n4 = this.m_geom.getNumVertices();
        int n5 = this.m_geom.getNumElements();
        PiVector[] piVectorArray = this.m_geom.getElements();
        PdVector[] pdVectorArray = this.m_geom.getVertices();
        PiVector[] piVectorArray2 = this.m_geom.getNeighbours();
        if (this.m_mean == null || this.m_mean.getSize() < n4) {
            this.computeHE();
        }
        PdVector pdVector = new PdVector(n4);
        double d = this.m_prescStepWidth;
        int n6 = this.m_prescSteps;
        int[][] nArrayArray = new int[n4][];
        int n7 = 0;
        int n8 = 0;
        int[] nArray = new int[n4];
        int n9 = 0;
        while (n9 < n4) {
            nArray[n9] = 0;
            ++n9;
        }
        n9 = 0;
        while (n9 < n5) {
            n3 = 0;
            do {
                if (piVectorArray2[n9].m_data[n3] < n9) continue;
                n2 = piVectorArray[n9].m_data[(n3 + 1) % 3];
                n = piVectorArray[n9].m_data[(n3 + 2) % 3];
                if (pdVectorArray[n2].hasTag(14)) continue;
                if (this.onEdge[n2]) {
                    if (pdVectorArray[n].hasTag(14) || !this.onEdge[n]) continue;
                    int n10 = n2;
                    nArray[n10] = nArray[n10] + 1;
                    int n11 = n;
                    nArray[n11] = nArray[n11] + 1;
                    continue;
                }
                if (pdVectorArray[n].hasTag(14) || this.onEdge[n]) continue;
                int n12 = n2;
                nArray[n12] = nArray[n12] + 1;
                int n13 = n;
                nArray[n13] = nArray[n13] + 1;
            } while (++n3 < 3);
            ++n9;
        }
        n9 = 0;
        while (n9 < n4) {
            if (!pdVectorArray[n9].hasTag(14)) {
                if (this.onEdge[n9]) {
                    ++n7;
                } else {
                    ++n8;
                }
            }
            ++n9;
        }
        int[] nArray2 = new int[n7];
        int[] nArray3 = new int[n8];
        n7 = 0;
        n8 = 0;
        n9 = 0;
        while (n9 < n4) {
            if (!pdVectorArray[n9].hasTag(14)) {
                if (this.onEdge[n9]) {
                    nArray2[n7] = n9;
                    ++n7;
                } else {
                    nArray3[n8] = n9;
                    ++n8;
                }
            }
            ++n9;
        }
        n9 = 0;
        while (n9 < n4) {
            nArrayArray[n9] = new int[nArray[n9]];
            nArray[n9] = 0;
            ++n9;
        }
        n9 = 0;
        while (n9 < n5) {
            n3 = 0;
            do {
                if (piVectorArray2[n9].m_data[n3] < n9) continue;
                n2 = piVectorArray[n9].m_data[(n3 + 1) % 3];
                n = piVectorArray[n9].m_data[(n3 + 2) % 3];
                if (pdVectorArray[n2].hasTag(14)) continue;
                if (this.onEdge[n2]) {
                    if (pdVectorArray[n].hasTag(14) || !this.onEdge[n]) continue;
                    nArrayArray[n2][nArray[n2]] = n;
                    int n14 = n2;
                    nArray[n14] = nArray[n14] + 1;
                    nArrayArray[n][nArray[n]] = n2;
                    int n15 = n;
                    nArray[n15] = nArray[n15] + 1;
                    continue;
                }
                if (pdVectorArray[n].hasTag(14) || this.onEdge[n]) continue;
                nArrayArray[n2][nArray[n2]] = n;
                int n16 = n2;
                nArray[n16] = nArray[n16] + 1;
                nArrayArray[n][nArray[n]] = n2;
                int n17 = n;
                nArray[n17] = nArray[n17] + 1;
            } while (++n3 < 3);
            ++n9;
        }
        int n18 = 0;
        while (n18 < n6) {
            pdVector.setConstant(0.0);
            n9 = 0;
            while (n9 < n8) {
                block33: {
                    block32: {
                        block31: {
                            n2 = nArray3[n9];
                            n3 = 0;
                            while (n3 < nArray[n2]) {
                                int n19 = n2;
                                pdVector.m_data[n19] = pdVector.m_data[n19] + this.m_mean.m_data[nArrayArray[n2][n3]];
                                ++n3;
                            }
                            if (nArray[n2] <= 1) break block31;
                            int n20 = n2;
                            pdVector.m_data[n20] = pdVector.m_data[n20] / (double)nArray[n2];
                            break block32;
                        }
                        if (nArray[n2] < 1) break block33;
                    }
                    int n21 = n2;
                    pdVector.m_data[n21] = pdVector.m_data[n21] - this.m_mean.m_data[n2];
                }
                ++n9;
            }
            n9 = 0;
            while (n9 < n8) {
                int n22 = nArray3[n9];
                this.m_mean.m_data[n22] = this.m_mean.m_data[n22] + d * pdVector.m_data[nArray3[n9]];
                ++n9;
            }
            ++n18;
        }
        n18 = 0;
        while (n18 < n6) {
            pdVector.setConstant(0.0);
            n9 = 0;
            while (n9 < n7) {
                block36: {
                    block35: {
                        block34: {
                            n2 = nArray2[n9];
                            n3 = 0;
                            while (n3 < nArray[n2]) {
                                int n23 = n2;
                                pdVector.m_data[n23] = pdVector.m_data[n23] + this.m_mean.m_data[nArrayArray[n2][n3]];
                                ++n3;
                            }
                            if (nArray[n2] <= 1) break block34;
                            int n24 = n2;
                            pdVector.m_data[n24] = pdVector.m_data[n24] / (double)nArray[n2];
                            break block35;
                        }
                        if (nArray[n2] < 1) break block36;
                    }
                    int n25 = n2;
                    pdVector.m_data[n25] = pdVector.m_data[n25] - this.m_mean.m_data[n2];
                }
                ++n9;
            }
            n9 = 0;
            while (n9 < n7) {
                int n26 = nArray2[n9];
                this.m_mean.m_data[n26] = this.m_mean.m_data[n26] + d * pdVector.m_data[nArray2[n9]];
                ++n9;
            }
            ++n18;
        }
    }
}

