/*
 * Decompiled with CFR 0.152.
 */
package jvx.geom;

import jv.geom.PgElementSet;
import jv.geom.PgPolygon;
import jv.geom.PgVectorField;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.project.PvDisplayIf;
import jv.project.PvPickEvent;
import jv.project.PvPickListenerIf;
import jv.vecmath.PdBary;
import jv.vecmath.PdVector;
import jvx.geom.PgPolygonOnElementSet;
import jvx.numeric.PnElementRK;
import jvx.numeric.PnGeodesicRK;
import jvx.numeric.PnVertexRK;
import jvx.numeric.PnVertexRKIgnoreDirection;
import jvx.project.PjWorkshop;

public class PwSingleIntegralLine
extends PjWorkshop
implements PvPickListenerIf {
    protected PuInteger m_vfIndex;
    protected PuDouble m_stepsize;
    protected PuInteger m_numSteps;
    protected boolean m_bFast = false;
    protected PgPolygon m_line = null;
    protected PgElementSet m_elemset = null;
    protected boolean m_bSwitchedElementsOff = false;
    protected boolean m_bSwitchedEdgesOn = false;
    protected int m_elemIndex = 0;
    protected PdBary m_bary = null;
    protected boolean m_bIgnoreDir = false;
    private boolean m_bSkipGeomUpdate = false;
    private static /* synthetic */ Class class$jvx$geom$PwSingleIntegralLine;

    public void removeIntegralLine() {
        if (this.m_line != null) {
            if (this.m_display != null) {
                this.m_display.removeGeometry((PgGeometryIf)this.m_line);
            }
            this.m_display.update(null);
            this.m_line = null;
            this.m_bary = null;
        }
    }

    public void setFast(boolean bl) {
        this.m_bFast = bl;
    }

    public boolean getFast() {
        return this.m_bFast;
    }

    public void setIgnoreDirection(boolean bl) {
        this.m_bIgnoreDir = bl;
        this.update((Object)this);
        this.recompute();
    }

    public boolean getIgnoreDirection() {
        return this.m_bIgnoreDir;
    }

    public boolean update(Object object) {
        if (object == null) {
            return true;
        }
        if (object == this.m_elemset) {
            if (this.m_bSkipGeomUpdate) {
                return true;
            }
            int n = this.m_elemset.getNumVectorFields();
            if (n > 0) {
                this.m_vfIndex.setBounds(1, n, 1, 2);
                this.m_vfIndex.update((Object)this.m_vfIndex);
            } else {
                this.m_vfIndex.setBounds(0, 0, 1, 2);
                this.m_vfIndex.setValue(0);
                this.m_vfIndex.update((Object)this.m_vfIndex);
            }
            return true;
        }
        if (object == this.m_vfIndex || object == this.m_numSteps || object == this.m_stepsize) {
            this.recompute();
            this.m_bSkipGeomUpdate = true;
            boolean bl = super.update((Object)this);
            this.m_bSkipGeomUpdate = false;
            return bl;
        }
        return false;
    }

    public PgPolygon computeIntegralLine(PgElementSet pgElementSet, int n, int n2, PdBary pdBary, int n3, double d, boolean bl, PgPolygon pgPolygon) {
        return this.computeIntegralLine(pgElementSet, n, n2, pdBary, n3, d, bl, pgPolygon, false);
    }

    public void dragInitial(PvPickEvent pvPickEvent) {
        this.pickInitial(pvPickEvent);
    }

    public PgPolygon computeIntegralLine(PgElementSet pgElementSet, int n, int n2, PdBary pdBary, int n3, double d, boolean bl, PgPolygon pgPolygon, boolean bl2) {
        PnGeodesicRK pnGeodesicRK;
        PgVectorField pgVectorField;
        if (pgElementSet == null) {
            return null;
        }
        if (pgElementSet.getNumVectorFields() <= n) {
            return null;
        }
        if (n < 0) {
            return null;
        }
        if (pgElementSet.getNumElements() <= n2) {
            return null;
        }
        if (pdBary == null || pdBary.getSize() != 3) {
            return null;
        }
        if (n3 < 0) {
            return null;
        }
        if (d <= 0.0) {
            return null;
        }
        if (pgPolygon == null) {
            pgPolygon = new PgPolygon(pgElementSet.getDimOfVertices());
            pgPolygon.setName(PsConfig.getMessage((int)45047) + "[" + PsObject.getNumObjects() + "]");
        }
        if ((pgVectorField = pgElementSet.getVectorField(n)).getBasedOn() == 0) {
            if (bl2) {
                pnGeodesicRK = new PnVertexRKIgnoreDirection(pgElementSet);
                ((PnVertexRKIgnoreDirection)pnGeodesicRK).setVectorField(pgVectorField);
            } else {
                pnGeodesicRK = new PnVertexRK(pgElementSet);
                ((PnVertexRK)pnGeodesicRK).setVectorField(pgVectorField);
            }
        } else {
            pnGeodesicRK = new PnElementRK(pgElementSet);
            ((PnElementRK)pnGeodesicRK).setVectorField(pgVectorField);
        }
        PgPolygonOnElementSet pgPolygonOnElementSet = new PgPolygonOnElementSet(pgElementSet);
        pnGeodesicRK.setFirstOrder(bl);
        pnGeodesicRK.solve(pgPolygonOnElementSet, n2, pdBary, d, n3);
        pgPolygonOnElementSet.getPolygon(pgPolygon);
        return pgPolygon;
    }

    public void setNumSteps(int n) {
        this.m_numSteps.setValue(n);
    }

    public int getNumSteps() {
        return this.m_numSteps.getValue();
    }

    public void dragVertex(PgGeometryIf pgGeometryIf, int n, PdVector pdVector) {
    }

    public void setStepSize(double d) {
        this.m_stepsize.setValue(d);
    }

    public double getStepSize() {
        return this.m_stepsize.getValue();
    }

    public void unmarkVertices(PvPickEvent pvPickEvent) {
    }

    public void pickInitial(PvPickEvent pvPickEvent) {
        if (pvPickEvent.getGeometry() != this.m_geom) {
            return;
        }
        this.m_bary = PdBary.copyNew((PdBary)pvPickEvent.getBary());
        this.m_elemIndex = pvPickEvent.getElementInd();
        this.recompute();
    }

    public void cancel() {
        this.removeIntegralLine();
        super.cancel();
    }

    public void markVertices(PvPickEvent pvPickEvent) {
    }

    public void close() {
        this.setDisplay(null);
        super.close();
    }

    public void setDisplay(PvDisplayIf pvDisplayIf) {
        if (this.m_display != null) {
            this.m_display.removePickListener((PvPickListenerIf)this);
        }
        super.setDisplay(pvDisplayIf);
        if (this.m_display != null) {
            this.m_display.addPickListener((PvPickListenerIf)this);
        }
        if (this.m_display != null && this.m_line != null) {
            this.m_display.addGeometry((PgGeometryIf)this.m_line);
        }
    }

    public PwSingleIntegralLine() {
        super(PsConfig.getMessage((int)51027));
        this.setModal(false);
        this.m_vfIndex = new PuInteger(PsConfig.getMessage((int)54096), (PsUpdateIf)this);
        this.m_stepsize = new PuDouble(PsConfig.getMessage((int)54097), (PsUpdateIf)this);
        this.m_numSteps = new PuInteger(PsConfig.getMessage((int)54098), (PsUpdateIf)this);
        if (((Object)((Object)this)).getClass() == (class$jvx$geom$PwSingleIntegralLine != null ? class$jvx$geom$PwSingleIntegralLine : (class$jvx$geom$PwSingleIntegralLine = PwSingleIntegralLine.class$("jvx.geom.PwSingleIntegralLine")))) {
            this.init();
        }
    }

    public void selectGeometry(PgGeometryIf pgGeometryIf) {
    }

    public void setGeometry(PgGeometry pgGeometry) {
        if (!(pgGeometry instanceof PgElementSet)) {
            PsDebug.warning((String)"Geometry is no element set");
            return;
        }
        PgElementSet pgElementSet = (PgElementSet)pgGeometry;
        if (pgElementSet != null && pgElementSet.getDimOfElements() != 3) {
            PsDebug.warning((String)"Geometry is not triangulated - aborted.");
            return;
        }
        if (this.m_elemset != null) {
            this.removeGeometry();
        }
        super.setGeometry((PgGeometry)pgElementSet);
        this.m_elemset = pgElementSet;
        if (this.m_elemset != null) {
            this.m_elemset.addUpdateListener((PsUpdateIf)this);
            if (this.m_elemset.isShowingElements()) {
                this.m_bSwitchedElementsOff = true;
                this.m_elemset.showElements(false);
            }
            if (!this.m_elemset.isShowingEdges()) {
                this.m_bSwitchedEdgesOn = true;
                this.m_elemset.showEdges(true);
            }
            this.update(this.m_elemset);
        }
    }

    public void setVectorFieldIndex(int n) {
        this.m_vfIndex.setValue(n + 1);
        this.update((Object)this);
    }

    public int getVectorFieldIndex() {
        return this.m_vfIndex.getValue() - 1;
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void dragDisplay(PvPickEvent pvPickEvent) {
    }

    public void pickDisplay(PvPickEvent pvPickEvent) {
    }

    public void init() {
        this.m_vfIndex.setDefBounds(0, 0, 1, 2);
        this.m_vfIndex.setDefValue(0);
        this.m_vfIndex.init();
        if (this.m_elemset != null) {
            this.update(this.m_elemset);
        }
        this.m_stepsize.setDefBounds(0.001, 1.0, 0.01, 0.1);
        this.m_stepsize.setDefValue(0.4);
        this.m_stepsize.init();
        this.m_numSteps.setDefBounds(1, 1000, 1, 25);
        this.m_numSteps.setDefValue(20);
        this.m_numSteps.init();
        this.removeIntegralLine();
    }

    public void removeGeometry() {
        this.m_elemset.removeUpdateListener((PsUpdateIf)this);
        if (this.m_bSwitchedElementsOff) {
            this.m_elemset.showElements(true);
            this.m_elemset.update(null);
        }
        if (this.m_bSwitchedEdgesOn) {
            this.m_elemset.showEdges(false);
            this.m_elemset.update(null);
        }
        super.removeGeometry();
    }

    public PgPolygon getIntegralLine() {
        return this.m_line;
    }

    private void recompute() {
        boolean bl;
        boolean bl2 = bl = this.m_line != null;
        if (this.m_elemset != null && this.m_elemset.getNumVectorFields() > 0 && this.m_bary != null) {
            this.m_line = this.computeIntegralLine(this.m_elemset, this.m_vfIndex.getValue() - 1, this.m_elemIndex, this.m_bary, this.m_numSteps.getValue(), this.m_stepsize.getValue(), this.m_bFast, this.m_line, this.m_bIgnoreDir);
            if (!bl && this.m_display != null) {
                this.m_display.addGeometry((PgGeometryIf)this.m_line);
            }
            this.m_line.update(null);
        }
    }

    public void pickVertex(PgGeometryIf pgGeometryIf, int n, PdVector pdVector) {
    }
}

