/*
 * Decompiled with CFR 0.152.
 */
package jvx.geom;

import java.util.Random;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsConfig;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.vecmath.PdVector;
import jv.vecmath.PuData;
import jvx.project.PjWorkshop;

public class PwNoise
extends PjWorkshop {
    protected PgPointSet m_pointSet;
    protected PgElementSet m_elemSet;
    protected PdVector[] m_vertices;
    protected PdVector[] m_normals;
    protected PdVector[] m_noise;
    protected boolean[] m_bNoise;
    protected PuInteger m_frequence = new PuInteger(PsConfig.getMessage((int)54311), (PsUpdateIf)this);
    protected PuDouble m_eps = new PuDouble(PsConfig.getMessage((int)54133), (PsUpdateIf)this);
    protected boolean m_bKeepBoundary = false;
    protected boolean m_bKeepSelected = false;
    protected boolean m_bTangential = false;
    protected boolean m_bNormal = true;
    protected boolean m_bUpdateNormals = true;
    protected boolean m_bHasElementNormals;
    protected boolean m_bHasVertexNormals;
    private static /* synthetic */ Class class$jvx$geom$PwNoise;

    public void close() {
        if (this.m_pointSet != null) {
            this.m_pointSet.removeUpdateListener((PsUpdateIf)this);
        }
        this.m_pointSet = null;
        this.m_elemSet = null;
        this.m_noise = null;
        this.m_normals = null;
        this.m_vertices = null;
    }

    public void reset() {
        super.reset();
        if (this.m_pointSet != null) {
            double d = this.m_pointSet.getDiameter();
            this.m_eps.setDefValue(0.0);
            this.m_eps.setDefBounds(0.0, d / 5.0, d / 1000.0, d / 100.0);
            this.m_eps.init();
            this.m_bHasVertexNormals = this.m_pointSet.hasVertexNormals();
            if (!this.m_bHasVertexNormals) {
                this.m_normals = null;
                this.m_bNormal = true;
                this.m_bTangential = true;
            }
        }
        this.m_bHasElementNormals = this.m_elemSet != null ? this.m_elemSet.hasElementNormals() : false;
        if (!this.m_bHasElementNormals && !this.m_bHasVertexNormals) {
            this.m_bUpdateNormals = false;
        }
        this.newNoise();
    }

    public boolean isEnabledNoiseTangential() {
        return this.m_bTangential;
    }

    public void setEnabledNoiseNormal(boolean bl) {
        this.m_bNormal = bl;
    }

    public PwNoise() {
        super(PsConfig.getMessage((int)54128));
        this.m_eps.setDefValue(0.0);
        this.m_eps.setDefBounds(0.0, 1.0, 0.001, 0.01);
        this.m_eps.init();
        if (((Object)((Object)this)).getClass() == (class$jvx$geom$PwNoise != null ? class$jvx$geom$PwNoise : (class$jvx$geom$PwNoise = PwNoise.class$("jvx.geom.PwNoise")))) {
            this.init();
        }
    }

    public void setEnabledKeepBoundary(boolean bl) {
        this.m_bKeepBoundary = bl;
    }

    public void setEnabledUpdateNormals(boolean bl) {
        this.m_bUpdateNormals = bl;
    }

    public void keepSelected(boolean bl) {
        this.m_bKeepSelected = bl;
    }

    public void noiseTangential(boolean bl) {
        this.m_bTangential = bl;
    }

    public void newFrequence() {
        int n;
        int n2 = this.m_pointSet.getNumVertices();
        if (n2 <= (n = n2 / this.m_frequence.getValue())) {
            int n3 = 0;
            while (n3 < n2) {
                this.m_bNoise[n3] = true;
                ++n3;
            }
            return;
        }
        Random random = new Random();
        int n4 = 0;
        while (n4 < n2) {
            this.m_bNoise[n4] = false;
            ++n4;
        }
        n4 = 0;
        while (n4 < n) {
            int n5 = Math.abs(random.nextInt()) % n2;
            while (this.m_bNoise[n5]) {
                n5 = Math.abs(random.nextInt()) % n2;
            }
            this.m_bNoise[n5] = true;
            ++n4;
        }
    }

    public void noise(double d, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
    }

    public void noise() {
        double d = this.m_eps.getValue();
        int n = this.m_pointSet.getDimOfVertices();
        PdVector pdVector = new PdVector(n);
        PdVector pdVector2 = new PdVector(n);
        boolean bl = this.m_bNormal && this.m_bTangential;
        int n2 = this.m_pointSet.getNumVertices();
        PdVector[] pdVectorArray = this.m_pointSet.getVertices();
        int n3 = 0;
        while (n3 < n2) {
            PdVector pdVector3;
            if (this.m_bNoise[n3]) {
                if (this.m_bKeepBoundary && this.m_pointSet.hasTagVertex(n3, 14) || this.m_bKeepSelected && this.m_pointSet.hasTagVertex(n3, 1) || this.m_pointSet.hasTagVertex(n3, 3)) {
                    pdVector3 = this.m_vertices[n3];
                } else if (bl || this.m_bNormal || this.m_bTangential) {
                    double d2;
                    if (bl) {
                        pdVector2.copyArray(this.m_noise[n3]);
                    } else if (this.m_bNormal) {
                        d2 = PdVector.dot((PdVector)this.m_normals[n3], (PdVector)this.m_noise[n3]);
                        pdVector2.multScalar(this.m_normals[n3], d2);
                    } else if (this.m_bTangential) {
                        d2 = PdVector.dot((PdVector)this.m_normals[n3], (PdVector)this.m_noise[n3]);
                        pdVector2.blendBase(this.m_noise[n3], -d2, this.m_normals[n3]);
                    }
                    pdVector.blendBase(this.m_vertices[n3], d, pdVector2);
                    pdVector3 = pdVector;
                } else {
                    pdVector3 = this.m_vertices[n3];
                }
            } else {
                pdVector3 = this.m_vertices[n3];
            }
            pdVectorArray[n3].copyArray(pdVector3);
            ++n3;
        }
        if (this.m_bUpdateNormals && this.m_bHasVertexNormals) {
            this.m_pointSet.makeVertexNormals();
        }
        if (this.m_bUpdateNormals && this.m_bHasElementNormals && this.m_elemSet != null) {
            this.m_elemSet.makeElementNormals();
        }
    }

    public void newNoise() {
        int n = this.m_pointSet.getNumVertices();
        int n2 = this.m_pointSet.getDimOfVertices();
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                this.m_noise[n3].m_data[n4] = (Math.random() - 0.5) * 2.0;
                ++n4;
            }
            ++n3;
        }
    }

    public boolean update(Object object) {
        if (object == this.m_pointSet) {
            if (this.isUpdateSender()) {
                return true;
            }
            if (this.isModal()) {
                return true;
            }
            this.setGeometry(this.m_pointSet);
            this.noise();
            return super.update((Object)this);
        }
        if (object == this.m_frequence) {
            this.newFrequence();
            this.noise();
            return super.update((Object)this);
        }
        if (object == this.m_eps) {
            this.noise();
            return super.update((Object)this);
        }
        return super.update(object);
    }

    public void setEnabledKeepSelected(boolean bl) {
        this.m_bKeepSelected = bl;
    }

    public boolean isEnabledNoiseNormal() {
        return this.m_bNormal;
    }

    public boolean isEnabledUpdateNormals() {
        return this.m_bUpdateNormals;
    }

    public void noiseNormal(boolean bl) {
        this.m_bNormal = bl;
    }

    public void setGeometry(PgPointSet pgPointSet) {
        super.setGeometry((PgGeometry)pgPointSet);
        this.m_pointSet = pgPointSet;
        this.m_pointSet.addUpdateListener((PsUpdateIf)this);
        int n = this.m_pointSet.getNumVertices();
        int n2 = this.m_pointSet.getDimOfVertices();
        this.m_vertices = PdVector.realloc((PdVector[])this.m_vertices, (int)n, (int)n2);
        PdVector.copy((PdVector[])this.m_vertices, (int)0, (PdVector[])pgPointSet.getVertices(), (int)0, (int)n);
        this.m_bHasVertexNormals = this.m_pointSet.hasVertexNormals();
        if (this.m_bHasVertexNormals) {
            this.m_normals = PdVector.realloc((PdVector[])this.m_normals, (int)n, (int)n2);
            PdVector.copy((PdVector[])this.m_normals, (int)0, (PdVector[])this.m_pointSet.getVertexNormals(), (int)0, (int)n);
        } else {
            this.m_normals = null;
            this.m_bNormal = true;
            this.m_bTangential = true;
        }
        this.m_noise = PdVector.realloc((PdVector[])this.m_noise, (int)n, (int)n2);
        this.m_bNoise = PuData.realloc((boolean[])this.m_bNoise, (int)n, (boolean)true);
        if (pgPointSet instanceof PgElementSet) {
            this.m_elemSet = (PgElementSet)pgPointSet;
            this.m_elemSet.markBoundary();
        } else {
            this.m_elemSet = null;
        }
        this.reset();
    }

    public boolean isEnabledKeepBoundary() {
        return this.m_bKeepBoundary;
    }

    public void updateNormals(boolean bl) {
        this.m_bUpdateNormals = bl;
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void init() {
        super.init();
        this.m_bKeepBoundary = false;
        this.m_bKeepSelected = false;
        this.m_bTangential = false;
        this.m_bNormal = true;
        this.m_bUpdateNormals = true;
        this.m_bHasElementNormals = false;
        this.m_bHasVertexNormals = false;
        this.m_frequence.setDefBounds(1, 10, 1, 2);
        this.m_frequence.setDefValue(1);
        this.m_frequence.init();
    }

    public boolean isEnabledKeepSelected() {
        return this.m_bKeepSelected;
    }

    public void keepBoundary(boolean bl) {
        this.m_bKeepBoundary = bl;
    }

    public void setEnabledNoiseTangential(boolean bl) {
        this.m_bTangential = bl;
    }
}

