/*
 * Decompiled with CFR 0.152.
 */
package jvx.geom;

import java.awt.Color;
import java.util.Vector;
import jv.geom.PgBndPolygon;
import jv.geom.PgElementSet;
import jv.geom.PgVectorField;
import jv.number.PdColor;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuMath;
import jvx.geom.PgVertexStar;
import jvx.geom.PwCurvature;
import jvx.project.PjWorkshop;

public class PwLocalButterfly
extends PjWorkshop {
    protected PgElementSet m_elementSet;
    private int m_noe;
    private int m_nov;
    private int m_novAll;
    private int m_origNoe;
    private Vector m_vertex = new Vector();
    private Vector m_vertexInfo = new Vector();
    private static int INDEX = 0;
    private static int REFINEMENT_GRADE = 1;
    private static int PARENT_EDGE_0 = 2;
    private static int PARENT_EDGE_1 = 3;
    private static int POSITION = 4;
    private static int BOUNDARY = 0;
    private static int INTERIOR = 1;
    private Vector m_triangleInfo = new Vector();
    private static int TRIANGLE_TYPE = 0;
    private static int START = 0;
    private static int RIGHT = 1;
    private static int LEFT = 2;
    private static int R_RIGHT = 3;
    private static int L_LEFT = 4;
    private boolean m_bHasBoundary;
    private PiVector[] m_boundary;
    private boolean m_bHasElementTexture;
    private Vector m_elementTexture = new Vector();
    private boolean m_bHasElementColors;
    private Vector m_elementColor = new Vector();
    private boolean m_bHasElementBackColors;
    private Vector m_elementBackColor = new Vector();
    private boolean m_bHasElementNormals;
    private Vector m_elementNormal = new Vector();
    private int m_numVectorFields;
    private Vector[] m_vectorField;
    private int[] m_vectorFieldIsBasedOn;
    private boolean m_bHasVertexTexture;
    private Vector m_vertexTexture = new Vector();
    private boolean m_bHasVertexColors;
    private Vector m_vertexColor = new Vector();
    private boolean m_bHasVertexNormals;
    private Vector m_vertexNormal = new Vector();
    public PuDouble m_tolerance = new PuDouble(PsConfig.getMessage((int)54434), (PsUpdateIf)this);
    public PuInteger m_maxNumSteps;
    public PuDouble m_percentage;
    public static final int HAND = 0;
    public static final int CURVATURE = 1;
    public static final int AREA = 2;
    public int m_markBy = 0;

    private int refineEdge(int n, int n2) {
        int n3;
        int[] nArray;
        int[] nArray2 = new int[]{n, n2};
        int[][] nArrayArray = new int[2][];
        int[] nArray3 = new int[2];
        int n4 = 0;
        do {
            nArrayArray[n4] = (int[])this.m_vertexInfo.elementAt(nArray2[n4]);
            nArray3[n4] = nArrayArray[n4].length;
        } while (++n4 < 2);
        boolean bl = true;
        n4 = 5;
        while (n4 < nArray3[0]) {
            if (nArrayArray[0][n4] == nArray2[1]) {
                bl = false;
                break;
            }
            ++n4;
        }
        int n5 = Math.max(nArrayArray[0][REFINEMENT_GRADE], nArrayArray[1][REFINEMENT_GRADE]) + 1;
        if (bl) {
            n4 = 5;
            while (n4 < nArray3[0]) {
                int n6 = nArrayArray[0][n4];
                if (n6 != -1) {
                    int[] nArray4 = (int[])this.m_vertexInfo.elementAt(n6);
                    while (nArray4[REFINEMENT_GRADE] > n5) {
                        n6 = ((int[])this.m_vertexInfo.elementAt(nArray4[PARENT_EDGE_0]))[REFINEMENT_GRADE] > ((int[])this.m_vertexInfo.elementAt(nArray4[PARENT_EDGE_1]))[REFINEMENT_GRADE] ? nArray4[PARENT_EDGE_0] : nArray4[PARENT_EDGE_1];
                        nArray4 = (int[])this.m_vertexInfo.elementAt(n6);
                    }
                    if (nArray4[PARENT_EDGE_0] == nArray2[0] && nArray4[PARENT_EDGE_1] == nArray2[1] || nArray4[PARENT_EDGE_0] == nArray2[1] && nArray4[PARENT_EDGE_1] == nArray2[0]) {
                        return n6;
                    }
                }
                ++n4;
            }
            PsDebug.warning((String)"Index of existing vertex not found.");
            return 0;
        }
        if (this.edgeIsBoundary(nArrayArray[0], nArray2[1])) {
            nArray = new int[9];
        } else {
            nArray = new int[11];
            nArray[PwLocalButterfly.POSITION] = INTERIOR;
        }
        nArray[PwLocalButterfly.INDEX] = -1;
        nArray[PwLocalButterfly.REFINEMENT_GRADE] = n5;
        nArray[PwLocalButterfly.PARENT_EDGE_0] = nArray2[0];
        nArray[PwLocalButterfly.PARENT_EDGE_1] = nArray2[1];
        nArray[5] = nArray2[0];
        nArray[8] = nArray2[1];
        int[] nArray5 = new int[2];
        n4 = 0;
        block4: do {
            nArray5[n4] = -1;
            n3 = 5;
            while (n3 < nArray3[n4]) {
                if (nArrayArray[n4][n3] == nArray2[1 - n4]) {
                    nArray5[n4] = n3;
                    continue block4;
                }
                ++n3;
            }
        } while (++n4 < 2);
        int[][] nArray6 = nArray[POSITION] == INTERIOR ? this.getButterflyVertices(nArray2, nArray5, nArrayArray, true) : this.getButterflyVertices(nArray2, nArray5, nArrayArray, false);
        n4 = 0;
        do {
            nArrayArray[n4][nArray5[n4]] = this.m_novAll;
        } while (++n4 < 2);
        if (nArray[POSITION] == BOUNDARY && this.m_bHasBoundary) {
            int n7 = this.m_boundary.length;
            boolean bl2 = false;
            n4 = 0;
            while (n4 < n7) {
                int n8 = this.m_boundary[n4].getSize();
                n3 = 0;
                while (n3 < n8 - 1) {
                    if (this.m_boundary[n4].m_data[n3] == nArray2[0] && this.m_boundary[n4].m_data[n3 + 1] == nArray2[1] || this.m_boundary[n4].m_data[n3] == nArray2[1] && this.m_boundary[n4].m_data[n3 + 1] == nArray2[0]) {
                        this.m_boundary[n4].setSize(n8 + 1);
                        int n9 = n8;
                        while (n9 > n3 + 1) {
                            this.m_boundary[n4].m_data[n9] = this.m_boundary[n4].m_data[n9 - 1];
                            --n9;
                        }
                        this.m_boundary[n4].m_data[n3 + 1] = this.m_novAll;
                        bl2 = true;
                        break;
                    }
                    ++n3;
                }
                if (bl2) break;
                ++n4;
            }
        }
        int[][] nArray7 = new int[2][2];
        n4 = 0;
        do {
            nArray7[n4][1] = nArray5[n4] == nArray3[n4] - 1 ? (nArray[POSITION] == INTERIOR ? 5 : -1) : nArray5[n4] + 1;
            if (nArray5[n4] == 5) {
                if (nArray[POSITION] == INTERIOR) {
                    nArray7[n4][0] = nArray3[n4] - 1;
                    continue;
                }
                nArray7[n4][0] = -1;
                continue;
            }
            nArray7[n4][0] = nArray5[n4] - 1;
        } while (++n4 < 2);
        n4 = 0;
        do {
            n3 = 0;
            do {
                if (nArray7[n4][n3] == -1) continue;
                nArray7[n4][n3] = nArrayArray[n4][nArray7[n4][n3]];
            } while (++n3 < 2);
        } while (++n4 < 2);
        int[][] nArray8 = new int[2][2];
        n4 = 0;
        do {
            n3 = 0;
            do {
                if (nArray7[n4][n3] != -1) {
                    int[] nArray9 = (int[])this.m_vertexInfo.elementAt(nArray7[n4][n3]);
                    while (nArray9[REFINEMENT_GRADE] > n5) {
                        nArray7[n4][n3] = nArray9[PARENT_EDGE_0] == nArray2[n4] ? nArray9[PARENT_EDGE_1] : nArray9[PARENT_EDGE_0];
                        nArray9 = (int[])this.m_vertexInfo.elementAt(nArray7[n4][n3]);
                    }
                    if (nArray9[REFINEMENT_GRADE] == n5) {
                        if (nArray9[PARENT_EDGE_0] == nArray2[n4]) {
                            nArray8[n4][n3] = nArray9[PARENT_EDGE_1];
                            continue;
                        }
                        nArray8[n4][n3] = nArray9[PARENT_EDGE_0];
                        continue;
                    }
                    nArray8[n4][n3] = nArray7[n4][n3];
                    nArray7[n4][n3] = -1;
                    continue;
                }
                nArray8[n4][n3] = -1;
            } while (++n3 < 2);
        } while (++n4 < 2);
        int[][] nArray10 = new int[2][2];
        n4 = 0;
        do {
            n3 = 0;
            do {
                nArray10[n4][n3] = -1;
            } while (++n3 < 2);
        } while (++n4 < 2);
        boolean bl3 = false;
        n4 = 0;
        do {
            n3 = 0;
            do {
                if (nArray8[0][n4] != nArray8[1][n3] || nArray8[0][n4] == -1) continue;
                if (bl3) {
                    nArray10[0][1] = nArray7[0][n4];
                    nArray10[1][1] = nArray7[1][n3];
                    continue;
                }
                bl3 = true;
                nArray10[0][0] = nArray7[0][n4];
                nArray10[1][0] = nArray7[1][n3];
            } while (++n3 < 2);
        } while (++n4 < 2);
        nArray[6] = nArray10[0][0];
        nArray[7] = nArray10[1][0];
        if (nArray[POSITION] == INTERIOR) {
            nArray[9] = nArray10[1][1];
            nArray[10] = nArray10[0][1];
        }
        n4 = 0;
        do {
            n3 = 0;
            do {
                if (n3 != 0 && nArray[POSITION] != INTERIOR || nArray10[n4][n3] == -1) continue;
                int[] nArray11 = (int[])this.m_vertexInfo.elementAt(nArray10[n4][n3]);
                if (nArray10[1 - n4][n3] == -1) {
                    if (nArray11[6] == -1 && nArray11[7] == -1) {
                        if (nArray11[PARENT_EDGE_0] == nArray2[n4]) {
                            nArray11[6] = this.m_novAll;
                            continue;
                        }
                        nArray11[7] = this.m_novAll;
                        continue;
                    }
                    if (nArray11[PARENT_EDGE_1] == nArray2[n4]) {
                        nArray11[9] = this.m_novAll;
                        continue;
                    }
                    nArray11[10] = this.m_novAll;
                    continue;
                }
                if (nArray11[PARENT_EDGE_0] == nArray2[n4]) {
                    if (nArray11[7] == nArray10[1 - n4][n3]) {
                        nArray11[6] = this.m_novAll;
                        continue;
                    }
                    nArray11[10] = this.m_novAll;
                    continue;
                }
                if (nArray11[6] == nArray10[1 - n4][n3]) {
                    nArray11[7] = this.m_novAll;
                    continue;
                }
                nArray11[9] = this.m_novAll;
            } while (++n3 < 2);
        } while (++n4 < 2);
        int n10 = this.m_novAll++;
        this.m_vertexInfo.addElement(nArray);
        if (nArray[POSITION] == INTERIOR) {
            this.computeVertex(nArray6, true);
        } else {
            this.computeVertex(nArray6, false);
        }
        return n10;
    }

    public void reset() {
        if (this.m_geom == null) {
            return;
        }
        this.m_geom.copy((PsObject)this.m_geomSave);
        this.init();
        if (this.m_markBy == 1) {
            this.update(this.m_tolerance);
            return;
        }
        if (this.m_markBy == 2) {
            this.update(this.m_percentage);
        }
    }

    public PwLocalButterfly() {
        super(PsConfig.getMessage((int)54433));
        this.m_tolerance.setDefBounds(0.0, 1.0, 0.01, 0.1);
        this.m_tolerance.init();
        this.m_tolerance.setValue(0.1);
        this.m_maxNumSteps = new PuInteger(PsConfig.getMessage((int)54435), (PsUpdateIf)this);
        this.m_maxNumSteps.setDefBounds(1, 20, 1, 5);
        this.m_maxNumSteps.init();
        this.m_maxNumSteps.setValue(5);
        this.m_percentage = new PuDouble(PsConfig.getMessage((int)54436), (PsUpdateIf)this);
        this.m_percentage.setDefBounds(0.0, 100.0, 1.0, 10.0);
        this.m_percentage.init();
        this.m_percentage.setValue(10.0);
    }

    public void refineByCurvature() {
        int n = 1;
        int n2 = 0;
        int n3 = this.m_maxNumSteps.getValue();
        while (n > 0 && n2 < n3) {
            this.refine();
            n = this.markByCurvature();
            ++n2;
        }
    }

    private int markByCurvature() {
        int n;
        double d = this.m_tolerance.getValue();
        PdVector pdVector = new PdVector(this.m_nov);
        PwCurvature.getGaussCurvature(this.m_elementSet, pdVector);
        this.m_elementSet.markBoundary();
        int n2 = 0;
        while (n2 < this.m_nov) {
            if (this.m_elementSet.hasTagVertex(n2, 14)) {
                int n3 = n2;
                pdVector.m_data[n3] = pdVector.m_data[n3] * 2.0;
            }
            ++n2;
        }
        if (this.m_bHasBoundary) {
            n = this.m_boundary.length;
            n2 = 0;
            while (n2 < n) {
                int n4 = this.m_boundary[n2].getSize();
                pdVector.m_data[this.m_boundary[n2].m_data[0]] = 0.0;
                pdVector.m_data[this.m_boundary[n2].m_data[n4 - 1]] = 0.0;
                ++n2;
            }
        }
        n2 = 0;
        while (n2 < this.m_noe) {
            this.m_elementSet.clearTagElement(n2, 1);
            ++n2;
        }
        n = 0;
        n2 = 0;
        while (n2 < this.m_noe) {
            if (Math.abs(pdVector.m_data[this.m_elementSet.getElement((int)n2).m_data[0]]) > d || Math.abs(pdVector.m_data[this.m_elementSet.getElement((int)n2).m_data[1]]) > d || Math.abs(pdVector.m_data[this.m_elementSet.getElement((int)n2).m_data[2]]) > d) {
                this.m_elementSet.setTagElement(n2, 1);
                ++n;
            }
            ++n2;
        }
        return n;
    }

    private boolean edgeIsBoundary(int[] nArray, int n) {
        return nArray[POSITION] == BOUNDARY && (nArray[5] == n || nArray[REFINEMENT_GRADE] == 0 && nArray[nArray.length - 1] == n || nArray[REFINEMENT_GRADE] > 0 && nArray[8] == n);
    }

    public boolean update(Object object) {
        if (object == this.m_percentage) {
            this.markBySize();
            return this.m_elementSet.update((Object)this.m_elementSet);
        }
        if (object == this.m_tolerance) {
            this.markByCurvature();
            return this.m_elementSet.update((Object)this.m_elementSet);
        }
        if (object == this.m_maxNumSteps) {
            return true;
        }
        return super.update(object);
    }

    public void setGeometry(PgElementSet pgElementSet) {
        super.setGeometry((PgGeometry)pgElementSet);
        this.m_elementSet = pgElementSet;
        this.init();
    }

    private int[][] getButterflyVertices(int[] nArray, int[] nArray2, int[][] nArray3, boolean bl) {
        int n;
        int n2;
        int[] nArray4;
        int[] nArray5;
        int n3;
        int n4;
        int[] nArray6 = new int[2];
        int n5 = 0;
        do {
            nArray6[n5] = nArray3[n5].length;
        } while (++n5 < 2);
        int[][] nArray7 = new int[2][4];
        n5 = 0;
        do {
            if (nArray2[n5] == 5) {
                if (bl) {
                    nArray7[n5][0] = nArray3[n5][nArray6[n5] - 2];
                    nArray7[n5][1] = nArray3[n5][nArray6[n5] - 1];
                } else {
                    nArray7[n5][0] = -2;
                    nArray7[n5][1] = -2;
                }
            } else if (nArray2[n5] == 6) {
                nArray7[n5][1] = nArray3[n5][5];
                nArray7[n5][0] = this.edgeIsBoundary(nArray3[n5], nArray7[n5][1]) ? -2 : nArray3[n5][nArray6[n5] - 1];
            } else {
                nArray7[n5][0] = nArray3[n5][nArray2[n5] - 2];
                nArray7[n5][1] = nArray3[n5][nArray2[n5] - 1];
            }
            if (nArray2[n5] == nArray6[n5] - 1) {
                if (bl) {
                    nArray7[n5][3] = nArray3[n5][6];
                    nArray7[n5][2] = nArray3[n5][5];
                    continue;
                }
                nArray7[n5][3] = -2;
                nArray7[n5][2] = -2;
                continue;
            }
            if (nArray2[n5] == nArray6[n5] - 2) {
                nArray7[n5][2] = nArray3[n5][nArray6[n5] - 1];
                if (this.edgeIsBoundary(nArray3[n5], nArray7[n5][2])) {
                    nArray7[n5][3] = -2;
                    continue;
                }
                nArray7[n5][3] = nArray3[n5][5];
                continue;
            }
            nArray7[n5][3] = nArray3[n5][nArray2[n5] + 2];
            nArray7[n5][2] = nArray3[n5][nArray2[n5] + 1];
        } while (++n5 < 2);
        if (nArray3[0][REFINEMENT_GRADE] == nArray3[1][REFINEMENT_GRADE]) {
            n5 = 0;
            do {
                n4 = 0;
                do {
                    if (nArray7[n4][n5] <= -1) continue;
                    n3 = nArray7[n4][n5];
                    nArray5 = (int[])this.m_vertexInfo.elementAt(n3);
                    while (nArray5[REFINEMENT_GRADE] > nArray3[0][REFINEMENT_GRADE]) {
                        n3 = nArray5[PARENT_EDGE_0] == nArray[n4] ? nArray5[PARENT_EDGE_1] : nArray5[PARENT_EDGE_0];
                        nArray5 = (int[])this.m_vertexInfo.elementAt(n3);
                    }
                    nArray7[n4][n5] = n3;
                } while (++n4 < 2);
            } while (++n5 < 4);
            if (nArray3[0][REFINEMENT_GRADE] != 0) {
                if (nArray7[0][1] == nArray7[1][1] && nArray7[0][1] == -1) {
                    nArray7[0][1] = this.refineEdge(nArray7[0][0], nArray7[1][0]);
                    nArray7[1][1] = nArray7[0][1];
                } else if (nArray7[0][1] == nArray7[1][2] && nArray7[0][1] == -1) {
                    nArray7[0][1] = this.refineEdge(nArray7[0][0], nArray7[1][3]);
                    nArray7[1][2] = nArray7[0][1];
                }
                if (nArray7[0][2] == nArray7[1][2] && nArray7[0][2] == -1) {
                    nArray7[0][2] = this.refineEdge(nArray7[0][3], nArray7[1][3]);
                    nArray7[1][2] = nArray7[0][2];
                } else if (nArray7[0][2] == nArray7[1][1] && nArray7[0][2] == -1) {
                    nArray7[0][2] = this.refineEdge(nArray7[0][3], nArray7[1][0]);
                    nArray7[1][1] = nArray7[0][2];
                }
                n4 = 0;
                do {
                    int n6 = 0;
                    do {
                        if (nArray7[n4][n6 * 3] != -1) continue;
                        int n7 = -1;
                        nArray5 = (int[])this.m_vertexInfo.elementAt(nArray7[n4][1 + n6]);
                        int n8 = nArray5.length;
                        if (n4 == 1 && n8 == 8 && nArray5[POSITION] == INTERIOR) {
                            if (nArray7[n4][1 + n6] == nArray7[(n4 + 1) % 2][1]) {
                                nArray7[n4][n6 * 3] = nArray7[(n4 + 1) % 2][0];
                                continue;
                            }
                            nArray7[n4][n6 * 3] = nArray7[(n4 + 1) % 2][3];
                            continue;
                        }
                        n5 = 5;
                        while (n5 < n8) {
                            n3 = nArray5[n5];
                            if (nArray5[n5] != -1) {
                                nArray4 = (int[])this.m_vertexInfo.elementAt(n3);
                                while (nArray4[REFINEMENT_GRADE] > nArray3[0][REFINEMENT_GRADE]) {
                                    n3 = nArray4[PARENT_EDGE_0] == nArray7[n4][1 + n6] ? nArray4[PARENT_EDGE_1] : nArray4[PARENT_EDGE_0];
                                    nArray4 = (int[])this.m_vertexInfo.elementAt(n3);
                                }
                            }
                            if (n3 == nArray[n4]) {
                                n7 = n5;
                                break;
                            }
                            ++n5;
                        }
                        n7 = n7 == 5 ? ((nArray4 = (int[])this.m_vertexInfo.elementAt(nArray5[6]))[REFINEMENT_GRADE] < nArray3[0][REFINEMENT_GRADE] ? 6 : n8 - 1) : ((nArray4 = (int[])this.m_vertexInfo.elementAt(nArray5[n7 - 1]))[REFINEMENT_GRADE] < nArray3[0][REFINEMENT_GRADE] ? --n7 : (n7 == n8 - 1 ? 5 : ++n7));
                        n7 = this.refineEdge(nArray7[n4][1 + n6], nArray5[n7]);
                        nArray5 = (int[])this.m_vertexInfo.elementAt(n7);
                        while (nArray5[REFINEMENT_GRADE] > nArray3[0][REFINEMENT_GRADE]) {
                            n7 = this.refineEdge(nArray7[n4][1 + n6], n7);
                            nArray5 = (int[])this.m_vertexInfo.elementAt(n7);
                        }
                        nArray7[n4][n6 * 3] = n7;
                    } while (++n6 < 2);
                } while (++n4 < 2);
            }
        } else {
            int n9;
            if (nArray3[0][REFINEMENT_GRADE] < nArray3[1][REFINEMENT_GRADE]) {
                n2 = 0;
                n9 = 1;
            } else {
                n2 = 1;
                n9 = 0;
            }
            n5 = 0;
            do {
                if (nArray7[n2][n5] == -2) continue;
                n3 = nArray7[n2][n5];
                nArray5 = (int[])this.m_vertexInfo.elementAt(n3);
                while (nArray5[REFINEMENT_GRADE] > nArray3[n9][REFINEMENT_GRADE]) {
                    n3 = nArray5[PARENT_EDGE_0] == nArray[n2] ? nArray5[PARENT_EDGE_1] : nArray5[PARENT_EDGE_0];
                    nArray5 = (int[])this.m_vertexInfo.elementAt(n3);
                }
                if (nArray5[REFINEMENT_GRADE] < nArray3[n9][REFINEMENT_GRADE]) {
                    n3 = this.refineEdge(n3, nArray[n2]);
                }
                nArray7[n2][n5] = n3;
            } while (++n5 < 4);
            n5 = 0;
            do {
                if (nArray7[n9][n5 * 3] <= -1) continue;
                n3 = nArray7[n9][n5 * 3];
                nArray5 = (int[])this.m_vertexInfo.elementAt(n3);
                while (nArray5[REFINEMENT_GRADE] > nArray3[n9][REFINEMENT_GRADE]) {
                    n3 = nArray5[PARENT_EDGE_0] == nArray[n9] ? nArray5[PARENT_EDGE_1] : nArray5[PARENT_EDGE_0];
                    nArray5 = (int[])this.m_vertexInfo.elementAt(n3);
                }
                nArray7[n9][n5 * 3] = n3;
            } while (++n5 < 2);
            if (nArray7[n9][0] == -1 || nArray7[n9][3] == -1) {
                nArray5 = (int[])this.m_vertexInfo.elementAt(nArray[n9]);
                int n10 = nArray5[PARENT_EDGE_0] == nArray[n2] ? nArray5[PARENT_EDGE_1] : nArray5[PARENT_EDGE_0];
                n = nArray7[n2][1] != -2 ? ((nArray5 = (int[])this.m_vertexInfo.elementAt(nArray7[n2][1]))[PARENT_EDGE_0] == nArray[n2] ? nArray5[PARENT_EDGE_1] : nArray5[PARENT_EDGE_0]) : -1;
                int n11 = nArray7[n2][2] != -2 ? ((nArray5 = (int[])this.m_vertexInfo.elementAt(nArray7[n2][2]))[PARENT_EDGE_0] == nArray[n2] ? nArray5[PARENT_EDGE_1] : nArray5[PARENT_EDGE_0]) : -1;
                if (nArray7[n9][0] > -1) {
                    nArray5 = (int[])this.m_vertexInfo.elementAt(nArray7[n9][0]);
                    nArray7[n9][3] = nArray5[PARENT_EDGE_0] == n || nArray5[PARENT_EDGE_1] == n ? this.refineEdge(n10, n11) : this.refineEdge(n10, n);
                } else if (nArray7[n9][3] > -1) {
                    nArray5 = (int[])this.m_vertexInfo.elementAt(nArray7[n9][3]);
                    nArray7[n9][0] = nArray5[PARENT_EDGE_0] == n || nArray5[PARENT_EDGE_1] == n ? this.refineEdge(n10, n11) : this.refineEdge(n10, n);
                } else {
                    if (nArray7[n9][3] != -2) {
                        nArray7[n9][3] = n11 != -1 ? this.refineEdge(n10, n11) : this.refineEdge(n10, n);
                    }
                    if (nArray7[n9][0] != -2) {
                        nArray7[n9][0] = n != -1 ? this.refineEdge(n10, n) : this.refineEdge(n10, n11);
                    }
                }
            }
            if (nArray7[n9][0] != -2) {
                nArray5 = (int[])this.m_vertexInfo.elementAt(nArray7[n9][0]);
                if (nArray7[n2][1] != -2) {
                    nArray4 = (int[])this.m_vertexInfo.elementAt(nArray7[n2][1]);
                    if (nArray5[PARENT_EDGE_0] == nArray4[PARENT_EDGE_0] || nArray5[PARENT_EDGE_1] == nArray4[PARENT_EDGE_0] || nArray5[PARENT_EDGE_0] == nArray4[PARENT_EDGE_1] || nArray5[PARENT_EDGE_1] == nArray4[PARENT_EDGE_1]) {
                        nArray7[n9][1] = nArray7[n2][1];
                        nArray7[n9][2] = nArray7[n2][2];
                    } else {
                        nArray7[n9][1] = nArray7[n2][2];
                        nArray7[n9][2] = nArray7[n2][1];
                    }
                } else {
                    nArray4 = (int[])this.m_vertexInfo.elementAt(nArray7[n2][2]);
                    if (nArray5[PARENT_EDGE_0] == nArray4[PARENT_EDGE_0] || nArray5[PARENT_EDGE_1] == nArray4[PARENT_EDGE_0] || nArray5[PARENT_EDGE_0] == nArray4[PARENT_EDGE_1] || nArray5[PARENT_EDGE_1] == nArray4[PARENT_EDGE_1]) {
                        nArray7[n9][1] = nArray7[n2][2];
                        nArray7[n9][2] = nArray7[n2][1];
                    } else {
                        nArray7[n9][1] = nArray7[n2][1];
                        nArray7[n9][2] = nArray7[n2][2];
                    }
                }
            } else if (nArray7[n9][3] != -2) {
                nArray5 = (int[])this.m_vertexInfo.elementAt(nArray7[n9][3]);
                if (nArray7[n2][1] != -2) {
                    nArray4 = (int[])this.m_vertexInfo.elementAt(nArray7[n2][1]);
                    if (nArray5[PARENT_EDGE_0] == nArray4[PARENT_EDGE_0] || nArray5[PARENT_EDGE_1] == nArray4[PARENT_EDGE_0] || nArray5[PARENT_EDGE_0] == nArray4[PARENT_EDGE_1] || nArray5[PARENT_EDGE_1] == nArray4[PARENT_EDGE_1]) {
                        nArray7[n9][1] = nArray7[n2][2];
                        nArray7[n9][2] = nArray7[n2][1];
                    } else {
                        nArray7[n9][1] = nArray7[n2][1];
                        nArray7[n9][2] = nArray7[n2][2];
                    }
                } else {
                    nArray4 = (int[])this.m_vertexInfo.elementAt(nArray7[n2][2]);
                    if (nArray5[PARENT_EDGE_0] == nArray4[PARENT_EDGE_0] || nArray5[PARENT_EDGE_1] == nArray4[PARENT_EDGE_0] || nArray5[PARENT_EDGE_0] == nArray4[PARENT_EDGE_1] || nArray5[PARENT_EDGE_1] == nArray4[PARENT_EDGE_1]) {
                        nArray7[n9][1] = nArray7[n2][1];
                        nArray7[n9][2] = nArray7[n2][2];
                    } else {
                        nArray7[n9][1] = nArray7[n2][2];
                        nArray7[n9][2] = nArray7[n2][1];
                    }
                }
            } else {
                nArray7[n9][1] = nArray7[n2][1];
                nArray7[n9][2] = nArray7[n2][2];
            }
        }
        int[][] nArrayArray = new int[2][];
        if (bl) {
            n5 = 0;
            do {
                if (nArray3[n5][REFINEMENT_GRADE] == 0 && nArray3[n5][POSITION] == INTERIOR) {
                    if (nArray3[n5].length == 8) {
                        nArrayArray[n5] = new int[3];
                        nArrayArray[n5][0] = nArray[(n5 + 1) % 2];
                        nArrayArray[n5][1] = nArray7[n5][1];
                        nArrayArray[n5][2] = nArray7[n5][2];
                        continue;
                    }
                    if (nArray3[n5].length == 9) {
                        nArrayArray[n5] = new int[4];
                        nArrayArray[n5][0] = nArray[(n5 + 1) % 2];
                        nArrayArray[n5][1] = nArray7[n5][1];
                        nArrayArray[n5][2] = nArray7[n5][0];
                        nArrayArray[n5][3] = nArray7[n5][2];
                        continue;
                    }
                    if (nArray3[n5].length == 10) {
                        nArrayArray[n5] = new int[5];
                        nArrayArray[n5][0] = nArray[(n5 + 1) % 2];
                        nArrayArray[n5][1] = nArray7[n5][2];
                        nArrayArray[n5][2] = nArray7[n5][3];
                        nArrayArray[n5][3] = nArray7[n5][0];
                        nArrayArray[n5][4] = nArray7[n5][1];
                        continue;
                    }
                    n2 = nArray3[n5].length - 5;
                    nArrayArray[n5] = new int[n2];
                    nArrayArray[n5][0] = nArray[(n5 + 1) % 2];
                    nArrayArray[n5][1] = nArray7[n5][2];
                    nArrayArray[n5][2] = nArray7[n5][3];
                    nArrayArray[n5][n2 - 2] = nArray7[n5][0];
                    nArrayArray[n5][n2 - 1] = nArray7[n5][1];
                    n4 = 3;
                    while (n4 < n2 - 2) {
                        nArrayArray[n5][n4] = nArray3[n5][5 + (nArray2[n5] - 5 + n4) % n2];
                        nArray4 = (int[])this.m_vertexInfo.elementAt(nArrayArray[n5][n4]);
                        while (nArray4[REFINEMENT_GRADE] > nArray3[(n5 + 1) % 2][REFINEMENT_GRADE]) {
                            nArrayArray[n5][n4] = nArray4[PARENT_EDGE_0] == nArray[n5] ? nArray4[PARENT_EDGE_1] : nArray4[PARENT_EDGE_0];
                            nArray4 = (int[])this.m_vertexInfo.elementAt(nArrayArray[n5][n4]);
                        }
                        while (nArray4[REFINEMENT_GRADE] < nArray3[(n5 + 1) % 2][REFINEMENT_GRADE]) {
                            nArrayArray[n5][n4] = this.refineEdge(nArrayArray[n5][n4], nArray[n5]);
                            nArray4 = (int[])this.m_vertexInfo.elementAt(nArrayArray[n5][n4]);
                        }
                        ++n4;
                    }
                } else {
                    nArrayArray[n5] = new int[5];
                    nArrayArray[n5][0] = nArray[(n5 + 1) % 2];
                    nArrayArray[n5][1] = nArray7[n5][2];
                    nArrayArray[n5][2] = nArray7[n5][3];
                    nArrayArray[n5][3] = nArray7[n5][0];
                    nArrayArray[n5][4] = nArray7[n5][1];
                }
            } while (++n5 < 2);
        } else {
            n5 = 0;
            do {
                nArrayArray[n5] = new int[2];
                nArrayArray[n5][0] = nArray[(n5 + 1) % 2];
                nArray4 = (int[])this.m_vertexInfo.elementAt(nArray[n5]);
                nArrayArray[n5][1] = nArray4[5] == nArray[(n5 + 1) % 2] ? nArray4[nArray4.length - 1] : nArray4[5];
                nArray5 = (int[])this.m_vertexInfo.elementAt(nArrayArray[n5][0]);
                if (nArray5[REFINEMENT_GRADE] < nArray4[REFINEMENT_GRADE]) {
                    n2 = 0;
                    n = nArray4[REFINEMENT_GRADE] - 1;
                } else {
                    n = n2 = nArray5[REFINEMENT_GRADE];
                }
                nArray5 = (int[])this.m_vertexInfo.elementAt(nArrayArray[n5][1]);
                while (nArray5[REFINEMENT_GRADE] > n) {
                    nArrayArray[n5][1] = nArray5[PARENT_EDGE_0] == nArray[n5] ? nArray5[PARENT_EDGE_1] : nArray5[PARENT_EDGE_0];
                    nArray5 = (int[])this.m_vertexInfo.elementAt(nArrayArray[n5][1]);
                }
                while (nArray5[REFINEMENT_GRADE] < n2) {
                    nArrayArray[n5][1] = this.refineEdge(nArrayArray[n5][1], nArray[n5]);
                    nArray5 = (int[])this.m_vertexInfo.elementAt(nArrayArray[n5][1]);
                }
            } while (++n5 < 2);
        }
        return nArrayArray;
    }

    public void markBySize() {
        int n = (int)(this.m_percentage.getValue() * (double)this.m_noe) / 100;
        if (n > this.m_noe) {
            n = this.m_noe;
        }
        if (n < 0) {
            n = 0;
        }
        double[] dArray = new double[this.m_noe];
        int n2 = 0;
        while (n2 < this.m_noe) {
            dArray[n2] = this.m_elementSet.getAreaOfElement(n2);
            ++n2;
        }
        int[] nArray = new int[this.m_noe];
        PuMath.heapsort((int)this.m_noe, (double[])dArray, (int[])nArray);
        n2 = this.m_noe - 1;
        while (n2 >= this.m_noe - n) {
            this.m_elementSet.setTagElement(nArray[n2], 1);
            --n2;
        }
        n2 = this.m_noe - n - 1;
        while (n2 >= 0) {
            this.m_elementSet.clearTagElement(nArray[n2], 1);
            --n2;
        }
    }

    public void unselectAllElements() {
        int n = 0;
        while (n < this.m_noe) {
            this.m_elementSet.clearTagElement(n, 1);
            ++n;
        }
    }

    public void ok() {
        int n = this.m_elementSet.getNumElements();
        int n2 = 0;
        while (n2 < n) {
            this.m_elementSet.clearTagElement(n2, 1);
            ++n2;
        }
        super.ok();
        this.m_elementSet.update((Object)this.m_elementSet);
    }

    public void init() {
        Object object;
        int n;
        int n2;
        Object object2;
        super.init();
        if (this.m_elementSet.getDimOfElements() != 3) {
            PgElementSet.triangulate((PgElementSet)this.m_elementSet);
        }
        if (!this.m_elementSet.checkNeighbour(false)) {
            PsDebug.warning((String)"Neighbourhood information not correct.");
            this.m_elementSet.makeNeighbour();
        }
        this.m_bHasBoundary = this.m_elementSet.hasBoundary();
        if (this.m_bHasBoundary) {
            object2 = this.m_elementSet.getBoundaries();
            int n3 = ((PgBndPolygon[])object2).length;
            this.m_boundary = new PiVector[n3];
            n2 = 0;
            while (n2 < n3) {
                this.m_boundary[n2] = PiVector.copyNew((PiVector)object2[n2].getVertexInd());
                this.m_boundary[n2].setSize(object2[n2].getNumVertices());
                ++n2;
            }
        }
        this.m_origNoe = this.m_noe = this.m_elementSet.getNumElements();
        this.m_novAll = this.m_nov = this.m_elementSet.getNumVertices();
        this.m_vertex.removeAllElements();
        this.m_vertexInfo.removeAllElements();
        this.m_triangleInfo.removeAllElements();
        object2 = new PgVertexStar();
        boolean[] blArray = new boolean[this.m_nov];
        n2 = 0;
        while (n2 < this.m_nov) {
            blArray[n2] = false;
            ++n2;
        }
        int[] nArray = new int[this.m_nov];
        n2 = 0;
        while (n2 < this.m_noe) {
            PiVector piVector = this.m_elementSet.getElement(n2);
            n = 0;
            do {
                if (blArray[piVector.m_data[n]]) continue;
                blArray[piVector.m_data[n]] = true;
                nArray[piVector.m_data[n]] = n2;
            } while (++n < 3);
            PiVector piVector2 = this.m_elementSet.getNeighbour(n2);
            object = new int[7];
            object[PwLocalButterfly.TRIANGLE_TYPE] = START;
            object[1] = piVector.m_data[0];
            object[2] = piVector.m_data[1];
            object[3] = piVector.m_data[2];
            object[4] = piVector2.m_data[0];
            object[5] = piVector2.m_data[1];
            object[6] = piVector2.m_data[2];
            this.m_triangleInfo.addElement(object);
            ++n2;
        }
        this.m_bHasElementTexture = this.m_elementSet.hasElementTextures();
        this.m_elementTexture.removeAllElements();
        if (this.m_bHasElementTexture) {
            n2 = 0;
            while (n2 < this.m_noe) {
                this.m_elementTexture.addElement(this.m_elementSet.getElementTexture(n2));
                ++n2;
            }
        }
        this.m_bHasElementColors = this.m_elementSet.hasElementColors();
        this.m_elementColor.removeAllElements();
        this.m_bHasElementBackColors = this.m_elementSet.hasElementBackColors();
        this.m_elementBackColor.removeAllElements();
        if (this.m_bHasElementColors) {
            n2 = 0;
            while (n2 < this.m_noe) {
                this.m_elementColor.addElement(this.m_elementSet.getElementColor(n2));
                ++n2;
            }
        }
        if (this.m_bHasElementBackColors) {
            n2 = 0;
            while (n2 < this.m_noe) {
                this.m_elementBackColor.addElement(this.m_elementSet.getElementBackColor(n2));
                ++n2;
            }
        }
        this.m_bHasElementNormals = this.m_elementSet.hasElementNormals();
        this.m_elementNormal.removeAllElements();
        if (this.m_bHasElementNormals) {
            n2 = 0;
            while (n2 < this.m_noe) {
                this.m_elementNormal.addElement(this.m_elementSet.getElementNormal(n2));
                ++n2;
            }
        }
        this.m_numVectorFields = this.m_elementSet.getNumVectorFields();
        this.m_vectorField = new Vector[this.m_numVectorFields];
        this.m_vectorFieldIsBasedOn = new int[this.m_numVectorFields];
        n2 = 0;
        while (n2 < this.m_numVectorFields) {
            object = this.m_elementSet.getVectorField(n2);
            this.m_vectorFieldIsBasedOn[n2] = object.getBasedOn();
            this.m_vectorField[n2] = new Vector();
            if (this.m_vectorFieldIsBasedOn[n2] == 1) {
                n = 0;
                while (n < this.m_noe) {
                    this.m_vectorField[n2].addElement(object.getVector(n));
                    ++n;
                }
            } else {
                n = 0;
                while (n < this.m_nov) {
                    this.m_vectorField[n2].addElement(object.getVector(n));
                    ++n;
                }
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < this.m_nov) {
            ((PgVertexStar)((Object)object2)).makeVertexStar(this.m_elementSet, n2, nArray[n2]);
            PiVector piVector = ((PgVertexStar)((Object)object2)).getLink();
            int n4 = piVector.getSize();
            object = new int[n4 + 5];
            object[PwLocalButterfly.INDEX] = n2;
            object[PwLocalButterfly.REFINEMENT_GRADE] = 0;
            object[PwLocalButterfly.PARENT_EDGE_0] = -1;
            object[PwLocalButterfly.PARENT_EDGE_1] = -1;
            object[PwLocalButterfly.POSITION] = ((PgVertexStar)((Object)object2)).isClosed() ? INTERIOR : BOUNDARY;
            n = 0;
            while (n < n4) {
                object[n + 5] = piVector.m_data[n];
                ++n;
            }
            this.m_vertexInfo.addElement(object);
            this.m_vertex.addElement(this.m_elementSet.getVertex(n2));
            ++n2;
        }
        this.m_bHasVertexTexture = this.m_elementSet.hasVertexTextures();
        this.m_vertexTexture.removeAllElements();
        if (this.m_bHasVertexTexture) {
            n2 = 0;
            while (n2 < this.m_nov) {
                this.m_vertexTexture.addElement(this.m_elementSet.getVertexTexture(n2));
                ++n2;
            }
        }
        this.m_bHasVertexColors = this.m_elementSet.hasVertexColors();
        this.m_vertexColor.removeAllElements();
        if (this.m_bHasVertexColors) {
            n2 = 0;
            while (n2 < this.m_nov) {
                this.m_vertexColor.addElement(this.m_elementSet.getVertexColor(n2));
                ++n2;
            }
        }
        this.m_bHasVertexNormals = this.m_elementSet.hasVertexNormals();
        this.m_vertexNormal.removeAllElements();
        if (this.m_bHasVertexNormals) {
            n2 = 0;
            while (n2 < this.m_nov) {
                this.m_vertexNormal.addElement(this.m_elementSet.getVertexNormal(n2));
                ++n2;
            }
        }
    }

    public void refine() {
        int n;
        int[] nArray;
        int n2 = 0;
        while (n2 < this.m_origNoe) {
            if (this.m_elementSet.hasTagElement(n2, 1)) {
                this.refineTriangle(n2);
            }
            ++n2;
        }
        this.m_elementSet.setNumElements(this.m_noe);
        PiVector[] piVectorArray = new PiVector[this.m_noe];
        PiVector[] piVectorArray2 = new PiVector[this.m_noe];
        n2 = 0;
        while (n2 < this.m_noe) {
            nArray = (int[])this.m_triangleInfo.elementAt(n2);
            piVectorArray[n2] = new PiVector(((int[])this.m_vertexInfo.elementAt(nArray[1]))[INDEX], ((int[])this.m_vertexInfo.elementAt(nArray[2]))[INDEX], ((int[])this.m_vertexInfo.elementAt(nArray[3]))[INDEX]);
            piVectorArray2[n2] = new PiVector(nArray[4], nArray[5], nArray[6]);
            ++n2;
        }
        this.m_elementSet.setElements(piVectorArray);
        this.m_elementSet.setNeighbours(piVectorArray2);
        this.m_elementSet.setNumVertices(this.m_nov);
        n2 = 0;
        while (n2 < this.m_novAll) {
            nArray = (int[])this.m_vertexInfo.elementAt(n2);
            if (nArray[INDEX] != -1) {
                this.m_elementSet.setVertex(nArray[INDEX], (PdVector)this.m_vertex.elementAt(n2));
            }
            ++n2;
        }
        if (this.m_bHasBoundary) {
            int n3 = this.m_boundary.length;
            PgBndPolygon[] pgBndPolygonArray = this.m_elementSet.getBoundaries();
            n2 = 0;
            while (n2 < n3) {
                int n4 = this.m_boundary[n2].getSize();
                int n5 = 0;
                n = 0;
                while (n < n4) {
                    if (((int[])this.m_vertexInfo.elementAt(this.m_boundary[n2].m_data[n]))[INDEX] > -1) {
                        ++n5;
                    }
                    ++n;
                }
                pgBndPolygonArray[n2].setNumVertices(n5);
                PiVector piVector = pgBndPolygonArray[n2].getVertexInd();
                n5 = 0;
                n = 0;
                while (n < n4) {
                    if (((int[])this.m_vertexInfo.elementAt(this.m_boundary[n2].m_data[n]))[INDEX] > -1) {
                        piVector.m_data[n5] = ((int[])this.m_vertexInfo.elementAt(this.m_boundary[n2].m_data[n]))[INDEX];
                        ++n5;
                    }
                    ++n;
                }
                pgBndPolygonArray[n2].assignVertices();
                pgBndPolygonArray[n2].makeElementInd();
                ++n2;
            }
        }
        if (this.m_bHasElementTexture) {
            n2 = 0;
            while (n2 < this.m_noe) {
                this.m_elementSet.setElementTexture(n2, (PdVector[])this.m_elementTexture.elementAt(n2));
                ++n2;
            }
        }
        if (this.m_bHasElementColors) {
            this.m_elementSet.assureElementColors();
            n2 = 0;
            while (n2 < this.m_noe) {
                this.m_elementSet.setElementColor(n2, (Color)this.m_elementColor.elementAt(n2));
                ++n2;
            }
        }
        if (this.m_bHasElementBackColors) {
            this.m_elementSet.assureElementBackColors();
            n2 = 0;
            while (n2 < this.m_noe) {
                this.m_elementSet.setElementBackColor(n2, (Color)this.m_elementBackColor.elementAt(n2));
                ++n2;
            }
        }
        if (this.m_bHasElementNormals) {
            this.m_elementSet.assureElementNormals();
            n2 = 0;
            while (n2 < this.m_noe) {
                this.m_elementSet.setElementNormal(n2, (PdVector)this.m_elementNormal.elementAt(n2));
                ++n2;
            }
        }
        n2 = 0;
        while (n2 < this.m_numVectorFields) {
            PgVectorField pgVectorField = this.m_elementSet.getVectorField(n2);
            if (this.m_vectorFieldIsBasedOn[n2] == 1) {
                pgVectorField.setNumVectors(this.m_noe);
                n = 0;
                while (n < this.m_noe) {
                    pgVectorField.setVector(n, (PdVector)this.m_vectorField[n2].elementAt(n));
                    ++n;
                }
            } else {
                pgVectorField.setNumVectors(this.m_nov);
                n = 0;
                while (n < this.m_novAll) {
                    nArray = (int[])this.m_vertexInfo.elementAt(n);
                    if (nArray[INDEX] != -1) {
                        pgVectorField.setVector(nArray[INDEX], (PdVector)this.m_vectorField[n2].elementAt(n));
                    }
                    ++n;
                }
            }
            ++n2;
        }
        if (this.m_bHasVertexTexture) {
            this.m_elementSet.assureVertexTextures();
            n2 = 0;
            while (n2 < this.m_novAll) {
                nArray = (int[])this.m_vertexInfo.elementAt(n2);
                if (nArray[INDEX] != -1) {
                    this.m_elementSet.setVertexTexture(nArray[INDEX], (PdVector)this.m_vertexTexture.elementAt(n2));
                }
                ++n2;
            }
        }
        if (this.m_bHasVertexColors) {
            this.m_elementSet.assureVertexColors();
            n2 = 0;
            while (n2 < this.m_novAll) {
                nArray = (int[])this.m_vertexInfo.elementAt(n2);
                if (nArray[INDEX] != -1) {
                    this.m_elementSet.setVertexColor(nArray[INDEX], (Color)this.m_vertexColor.elementAt(n2));
                }
                ++n2;
            }
        }
        if (this.m_bHasVertexNormals) {
            this.m_elementSet.assureVertexNormals();
            n2 = 0;
            while (n2 < this.m_novAll) {
                nArray = (int[])this.m_vertexInfo.elementAt(n2);
                if (nArray[INDEX] != -1) {
                    this.m_elementSet.setVertexNormal(nArray[INDEX], (PdVector)this.m_vertexNormal.elementAt(n2));
                }
                ++n2;
            }
        }
        this.m_elementSet.update((Object)this.m_elementSet);
        this.m_origNoe = this.m_noe;
    }

    public void cancel() {
        int n = this.m_elementSet.getNumElements();
        int n2 = 0;
        while (n2 < n) {
            this.m_elementSet.clearTagElement(n2, 1);
            ++n2;
        }
        super.cancel();
    }

    private void computeVertex(int[][] nArray, boolean bl) {
        int n;
        int n2;
        int n3;
        int n4;
        double[][] dArrayArray = new double[2][];
        if (bl) {
            n4 = 0;
            do {
                dArrayArray[n4] = new double[nArray[n4].length];
                int[] nArray2 = (int[])this.m_vertexInfo.elementAt(nArray[(n4 + 1) % 2][0]);
                if (nArray2[REFINEMENT_GRADE] == 0 && nArray2[POSITION] == INTERIOR) {
                    if (nArray[n4].length == 3) {
                        dArrayArray[n4][0] = 0.5833333333333334;
                        dArrayArray[n4][1] = -0.041666666666666664;
                        dArrayArray[n4][2] = -0.041666666666666664;
                        continue;
                    }
                    if (nArray[n4].length == 4) {
                        dArrayArray[n4][0] = 0.5625;
                        dArrayArray[n4][1] = 0.0;
                        dArrayArray[n4][2] = -0.0625;
                        dArrayArray[n4][3] = 0.0;
                        continue;
                    }
                    n3 = nArray[n4].length;
                    n2 = 0;
                    while (n2 < n3) {
                        dArrayArray[n4][n2] = (0.125 + Math.cos(Math.PI * 2 * (double)n2 / (double)n3) / 2.0 + Math.cos(Math.PI * 4 * (double)n2 / (double)n3) / 4.0) / (double)n3;
                        ++n2;
                    }
                    double[] dArray = dArrayArray[n4];
                    dArray[0] = dArray[0] + 0.375;
                    continue;
                }
                dArrayArray[n4][0] = 0.5;
                dArrayArray[n4][1] = 0.0625;
                dArrayArray[n4][2] = -0.0625;
                dArrayArray[n4][3] = -0.0625;
                dArrayArray[n4][4] = 0.0625;
                if (nArray[n4][2] < 0) {
                    double[] dArray = dArrayArray[n4];
                    dArray[1] = dArray[1] + dArrayArray[n4][2];
                }
                if (nArray[n4][3] < 0) {
                    double[] dArray = dArrayArray[n4];
                    dArray[4] = dArray[4] + dArrayArray[n4][3];
                }
                if (nArray[n4][1] < 0) {
                    double[] dArray = dArrayArray[n4];
                    dArray[4] = dArray[4] + dArrayArray[n4][1];
                }
                if (nArray[n4][4] >= 0) continue;
                double[] dArray = dArrayArray[n4];
                dArray[1] = dArray[1] + dArrayArray[n4][4];
            } while (++n4 < 2);
        } else {
            n4 = 0;
            do {
                dArrayArray[n4] = new double[2];
                dArrayArray[n4][0] = 0.5625;
                dArrayArray[n4][1] = -0.0625;
            } while (++n4 < 2);
            if (this.m_bHasBoundary) {
                n3 = this.m_boundary.length;
                n4 = 0;
                do {
                    n2 = 0;
                    while (n2 < n3) {
                        n = this.m_boundary[n2].getSize();
                        if (this.m_boundary[n2].m_data[0] == nArray[n4][0] || this.m_boundary[n2].m_data[n - 1] == nArray[n4][0]) {
                            double[] dArray = dArrayArray[n4];
                            dArray[0] = dArray[0] + dArrayArray[(n4 + 1) % 2][1];
                            dArrayArray[(n4 + 1) % 2][1] = 0.0;
                        }
                        ++n2;
                    }
                } while (++n4 < 2);
            }
        }
        PdVector pdVector = PdVector.blendNew((double)dArrayArray[0][0], (PdVector)((PdVector)this.m_vertex.elementAt(nArray[0][0])), (double)dArrayArray[1][0], (PdVector)((PdVector)this.m_vertex.elementAt(nArray[1][0])));
        n4 = 0;
        do {
            n2 = 1;
            while (n2 < nArray[n4].length) {
                if (nArray[n4][n2] > -1) {
                    pdVector.blendBase(pdVector, dArrayArray[n4][n2], (PdVector)this.m_vertex.elementAt(nArray[n4][n2]));
                }
                ++n2;
            }
        } while (++n4 < 2);
        this.m_vertex.addElement(pdVector);
        n = 0;
        while (n < this.m_numVectorFields) {
            if (this.m_vectorFieldIsBasedOn[n] == 0) {
                PdVector pdVector2 = PdVector.blendNew((double)dArrayArray[0][0], (PdVector)((PdVector)this.m_vectorField[n].elementAt(nArray[0][0])), (double)dArrayArray[1][0], (PdVector)((PdVector)this.m_vectorField[n].elementAt(nArray[1][0])));
                n4 = 0;
                do {
                    n2 = 1;
                    while (n2 < nArray[n4].length) {
                        if (nArray[n4][n2] > -1) {
                            pdVector2.blendBase(pdVector2, dArrayArray[n4][n2], (PdVector)this.m_vectorField[n].elementAt(nArray[n4][n2]));
                        }
                        ++n2;
                    }
                } while (++n4 < 2);
                this.m_vectorField[n].addElement(pdVector2);
            }
            ++n;
        }
        if (this.m_bHasVertexTexture) {
            PdVector pdVector3 = PdVector.blendNew((double)dArrayArray[0][0], (PdVector)((PdVector)this.m_vertexTexture.elementAt(nArray[0][0])), (double)dArrayArray[1][0], (PdVector)((PdVector)this.m_vertexTexture.elementAt(nArray[1][0])));
            n4 = 0;
            do {
                n2 = 1;
                while (n2 < nArray[n4].length) {
                    if (nArray[n4][n2] > -1) {
                        pdVector3.blendBase(pdVector3, dArrayArray[n4][n2], (PdVector)this.m_vertexTexture.elementAt(nArray[n4][n2]));
                    }
                    ++n2;
                }
            } while (++n4 < 2);
            this.m_vertexTexture.addElement(pdVector3);
        }
        if (this.m_bHasVertexColors) {
            Color color = PdColor.blend((double)dArrayArray[0][0], (Color)((Color)this.m_vertexColor.elementAt(nArray[0][0])), (double)dArrayArray[1][0], (Color)((Color)this.m_vertexColor.elementAt(nArray[1][0])));
            n4 = 0;
            do {
                n2 = 1;
                while (n2 < nArray[n4].length) {
                    if (nArray[n4][n2] > -1) {
                        color = PdColor.blend((double)1.0, (Color)color, (double)dArrayArray[n4][n2], (Color)((Color)this.m_vertexColor.elementAt(nArray[n4][n2])));
                    }
                    ++n2;
                }
            } while (++n4 < 2);
            this.m_vertexColor.addElement(color);
        }
        if (this.m_bHasVertexNormals) {
            PdVector pdVector4 = PdVector.blendNew((double)dArrayArray[0][0], (PdVector)((PdVector)this.m_vertexNormal.elementAt(nArray[0][0])), (double)dArrayArray[1][0], (PdVector)((PdVector)this.m_vertexNormal.elementAt(nArray[1][0])));
            n4 = 0;
            do {
                n2 = 1;
                while (n2 < nArray[n4].length) {
                    if (nArray[n4][n2] > -1) {
                        pdVector4.blendBase(pdVector4, dArrayArray[n4][n2], (PdVector)this.m_vertexNormal.elementAt(nArray[n4][n2]));
                    }
                    ++n2;
                }
            } while (++n4 < 2);
            this.m_vertexNormal.addElement(pdVector4);
        }
    }

    private void refineTriangle(int n) {
        PdVector[] pdVectorArray;
        Object[] objectArray;
        int n2;
        int[] nArray;
        int n3;
        int[] nArray2;
        int[] nArray3;
        int n4;
        if (n < this.m_origNoe) {
            this.m_elementSet.clearTagElement(n, 1);
        }
        if ((n4 = (nArray3 = (int[])this.m_triangleInfo.elementAt(n))[4]) != -1) {
            nArray2 = (int[])this.m_triangleInfo.elementAt(n4);
            if (nArray3[TRIANGLE_TYPE] == R_RIGHT && nArray2[TRIANGLE_TYPE] != L_LEFT || nArray3[TRIANGLE_TYPE] == L_LEFT && nArray2[TRIANGLE_TYPE] != R_RIGHT) {
                this.refineTriangle(n4);
                n4 = nArray3[4];
                nArray2 = (int[])this.m_triangleInfo.elementAt(n4);
            }
        }
        if (nArray3[TRIANGLE_TYPE] == R_RIGHT || nArray3[TRIANGLE_TYPE] == L_LEFT) {
            nArray2 = (int[])this.m_triangleInfo.elementAt(n4);
            n3 = this.refineEdge(nArray3[1], nArray2[1]);
        } else {
            n3 = this.refineEdge(nArray3[2], nArray3[3]);
        }
        ((int[])this.m_vertexInfo.elementAt((int)n3))[PwLocalButterfly.INDEX] = this.m_nov++;
        int n5 = n;
        int n6 = this.m_noe;
        Object[] objectArray2 = new int[7];
        if (nArray3[TRIANGLE_TYPE] == START) {
            nArray3[PwLocalButterfly.TRIANGLE_TYPE] = RIGHT;
            objectArray2[PwLocalButterfly.TRIANGLE_TYPE] = LEFT;
        } else if (nArray3[TRIANGLE_TYPE] == LEFT) {
            nArray3[PwLocalButterfly.TRIANGLE_TYPE] = START;
            objectArray2[PwLocalButterfly.TRIANGLE_TYPE] = L_LEFT;
        } else if (nArray3[TRIANGLE_TYPE] == RIGHT) {
            nArray3[PwLocalButterfly.TRIANGLE_TYPE] = R_RIGHT;
            objectArray2[PwLocalButterfly.TRIANGLE_TYPE] = START;
        } else if (nArray3[TRIANGLE_TYPE] == L_LEFT || nArray3[TRIANGLE_TYPE] == R_RIGHT) {
            nArray3[PwLocalButterfly.TRIANGLE_TYPE] = LEFT;
            objectArray2[PwLocalButterfly.TRIANGLE_TYPE] = RIGHT;
        }
        objectArray2[1] = n3;
        objectArray2[2] = nArray3[1];
        objectArray2[3] = nArray3[2];
        nArray3[2] = nArray3[3];
        nArray3[3] = nArray3[1];
        nArray3[1] = n3;
        if (nArray3[6] != -1) {
            nArray = (int[])this.m_triangleInfo.elementAt(nArray3[6]);
            n2 = 4;
            do {
                if (nArray[n2] != n5) continue;
                nArray[n2] = n6;
                break;
            } while (++n2 < 7);
        }
        objectArray2[4] = nArray3[6];
        nArray3[4] = nArray3[5];
        objectArray2[6] = n5;
        nArray3[5] = n6;
        this.m_triangleInfo.addElement(objectArray2);
        ++this.m_noe;
        if (this.m_bHasElementTexture) {
            objectArray = (PdVector[])this.m_elementTexture.elementAt(n);
            pdVectorArray = new PdVector[]{PdVector.blendNew((double)0.5, (PdVector)objectArray[1], (double)0.5, (PdVector)objectArray[2]), PdVector.copyNew((PdVector)objectArray[0]), objectArray[1]};
            objectArray[1] = objectArray[2];
            objectArray[2] = objectArray[0];
            objectArray[0] = PdVector.copyNew((PdVector)pdVectorArray[0]);
            this.m_elementTexture.addElement(pdVectorArray);
        }
        if (this.m_bHasElementColors) {
            this.m_elementColor.addElement(this.m_elementColor.elementAt(n));
        }
        if (this.m_bHasElementBackColors) {
            this.m_elementBackColor.addElement(this.m_elementBackColor.elementAt(n));
        }
        if (this.m_bHasElementNormals) {
            this.m_elementNormal.addElement(PdVector.copyNew((PdVector)((PdVector)this.m_elementNormal.elementAt(n))));
        }
        n2 = 0;
        while (n2 < this.m_numVectorFields) {
            if (this.m_vectorFieldIsBasedOn[n2] == 1) {
                this.m_vectorField[n2].addElement(PdVector.copyNew((PdVector)((PdVector)this.m_vectorField[n2].elementAt(n))));
            }
            ++n2;
        }
        while (true) {
            PdVector[] pdVectorArray2;
            PdVector[] pdVectorArray3;
            int n7;
            int n8;
            PdVector[] pdVectorArray4;
            int n9;
            int n10;
            int n11;
            if (n4 == -1) {
                if (nArray3[1] == n3) {
                    nArray3[6] = -1;
                } else {
                    nArray3[4] = -1;
                }
                if (objectArray2[1] == n3) {
                    objectArray2[5] = -1;
                    return;
                }
                objectArray2[4] = -1;
                return;
            }
            if (n4 < this.m_origNoe && this.m_elementSet.hasTagElement(n4, 1)) {
                this.m_elementSet.clearTagElement(n4, 1);
            }
            if ((n11 = (nArray2 = (int[])this.m_triangleInfo.elementAt(n4))[4]) == n5) {
                n10 = n4;
                n9 = this.m_noe;
                objectArray = new int[7];
                if (nArray2[TRIANGLE_TYPE] == START) {
                    nArray2[PwLocalButterfly.TRIANGLE_TYPE] = RIGHT;
                    objectArray[PwLocalButterfly.TRIANGLE_TYPE] = (PdVector)LEFT;
                } else if (nArray2[TRIANGLE_TYPE] == LEFT) {
                    nArray2[PwLocalButterfly.TRIANGLE_TYPE] = START;
                    objectArray[PwLocalButterfly.TRIANGLE_TYPE] = (PdVector)L_LEFT;
                } else if (nArray2[TRIANGLE_TYPE] == RIGHT) {
                    nArray2[PwLocalButterfly.TRIANGLE_TYPE] = R_RIGHT;
                    objectArray[PwLocalButterfly.TRIANGLE_TYPE] = (PdVector)START;
                } else if (nArray2[TRIANGLE_TYPE] == L_LEFT || nArray2[TRIANGLE_TYPE] == R_RIGHT) {
                    nArray2[PwLocalButterfly.TRIANGLE_TYPE] = LEFT;
                    objectArray[PwLocalButterfly.TRIANGLE_TYPE] = (PdVector)RIGHT;
                }
                objectArray[1] = (PdVector)n3;
                objectArray[2] = (PdVector)nArray2[1];
                objectArray[3] = (PdVector)nArray2[2];
                nArray2[2] = nArray2[3];
                nArray2[3] = nArray2[1];
                nArray2[1] = n3;
                if (nArray2[6] != -1) {
                    nArray = (int[])this.m_triangleInfo.elementAt(nArray2[6]);
                    n2 = 4;
                    do {
                        if (nArray[n2] != n4) continue;
                        nArray[n2] = n9;
                        break;
                    } while (++n2 < 7);
                }
                objectArray[4] = (PdVector)nArray2[6];
                nArray2[4] = nArray2[5];
                objectArray[6] = (PdVector)n10;
                nArray2[5] = n9;
                if (nArray3[2] == nArray2[2] || nArray3[3] == nArray2[2]) {
                    if (nArray3[1] == n3) {
                        nArray3[6] = n10;
                    } else {
                        nArray3[4] = n10;
                    }
                    if (objectArray2[1] == n3) {
                        objectArray2[5] = n9;
                    } else {
                        objectArray2[4] = n9;
                    }
                    nArray2[6] = n5;
                    objectArray[5] = (PdVector)n6;
                } else {
                    if (nArray3[1] == n3) {
                        nArray3[6] = n9;
                    } else {
                        nArray3[4] = n9;
                    }
                    if (objectArray2[1] == n3) {
                        objectArray2[5] = n10;
                    } else {
                        objectArray2[4] = n10;
                    }
                    nArray2[6] = n6;
                    objectArray[5] = (PdVector)n5;
                }
                this.m_triangleInfo.addElement(objectArray);
                ++this.m_noe;
                if (this.m_bHasElementTexture) {
                    pdVectorArray = (PdVector[])this.m_elementTexture.elementAt(n4);
                    pdVectorArray4 = new PdVector[]{PdVector.blendNew((double)0.5, (PdVector)pdVectorArray[1], (double)0.5, (PdVector)pdVectorArray[2]), PdVector.copyNew((PdVector)pdVectorArray[0]), pdVectorArray[1]};
                    pdVectorArray[1] = pdVectorArray[2];
                    pdVectorArray[2] = pdVectorArray[0];
                    pdVectorArray[0] = PdVector.copyNew((PdVector)pdVectorArray4[0]);
                    this.m_elementTexture.addElement(pdVectorArray4);
                }
                if (this.m_bHasElementColors) {
                    this.m_elementColor.addElement(this.m_elementColor.elementAt(n4));
                }
                if (this.m_bHasElementBackColors) {
                    this.m_elementBackColor.addElement(this.m_elementBackColor.elementAt(n4));
                }
                if (this.m_bHasElementNormals) {
                    this.m_elementNormal.addElement(PdVector.copyNew((PdVector)((PdVector)this.m_elementNormal.elementAt(n4))));
                }
                n2 = 0;
                while (n2 < this.m_numVectorFields) {
                    if (this.m_vectorFieldIsBasedOn[n2] == 1) {
                        this.m_vectorField[n2].addElement(PdVector.copyNew((PdVector)((PdVector)this.m_vectorField[n2].elementAt(n4))));
                    }
                    ++n2;
                }
                return;
            }
            if (nArray2[TRIANGLE_TYPE] == R_RIGHT || nArray2[TRIANGLE_TYPE] == L_LEFT) {
                objectArray = (int[])this.m_triangleInfo.elementAt(n11);
                Object object = objectArray[TRIANGLE_TYPE] != L_LEFT && objectArray[TRIANGLE_TYPE] != R_RIGHT ? (Object)this.refineEdge((int)objectArray[2], (int)objectArray[3]) : objectArray[1];
                n8 = this.refineEdge(nArray2[1], (int)object);
            } else {
                n8 = this.refineEdge(nArray2[2], nArray2[3]);
            }
            ((int[])this.m_vertexInfo.elementAt((int)n8))[PwLocalButterfly.INDEX] = this.m_nov++;
            if (nArray2[6] == n5) {
                n10 = n4;
                n9 = this.m_noe;
                n7 = this.m_noe + 1;
                objectArray = new int[7];
                int[] nArray4 = new int[7];
                if (nArray2[TRIANGLE_TYPE] == START) {
                    nArray2[PwLocalButterfly.TRIANGLE_TYPE] = RIGHT;
                    objectArray[PwLocalButterfly.TRIANGLE_TYPE] = (PdVector)START;
                    nArray4[PwLocalButterfly.TRIANGLE_TYPE] = L_LEFT;
                } else if (nArray2[TRIANGLE_TYPE] == LEFT) {
                    nArray2[PwLocalButterfly.TRIANGLE_TYPE] = START;
                    objectArray[PwLocalButterfly.TRIANGLE_TYPE] = (PdVector)LEFT;
                    nArray4[PwLocalButterfly.TRIANGLE_TYPE] = RIGHT;
                } else if (nArray2[TRIANGLE_TYPE] == RIGHT) {
                    nArray2[PwLocalButterfly.TRIANGLE_TYPE] = R_RIGHT;
                    objectArray[PwLocalButterfly.TRIANGLE_TYPE] = (PdVector)RIGHT;
                    nArray4[PwLocalButterfly.TRIANGLE_TYPE] = LEFT;
                } else if (nArray2[TRIANGLE_TYPE] == L_LEFT || nArray2[TRIANGLE_TYPE] == R_RIGHT) {
                    nArray2[PwLocalButterfly.TRIANGLE_TYPE] = LEFT;
                    objectArray[PwLocalButterfly.TRIANGLE_TYPE] = (PdVector)R_RIGHT;
                    nArray4[PwLocalButterfly.TRIANGLE_TYPE] = START;
                }
                objectArray[1] = (PdVector)n3;
                objectArray[2] = (PdVector)nArray2[2];
                objectArray[3] = (PdVector)n8;
                nArray4[1] = n3;
                nArray4[2] = n8;
                nArray4[3] = nArray2[1];
                nArray2[2] = nArray2[3];
                nArray2[3] = nArray2[1];
                nArray2[1] = n8;
                nArray4[4] = n10;
                nArray2[4] = nArray2[5];
                objectArray[5] = (PdVector)n7;
                nArray4[6] = n9;
                nArray2[5] = n7;
                if (nArray3[2] == nArray2[3] || nArray3[3] == nArray2[3]) {
                    if (nArray3[1] == n3) {
                        nArray3[6] = n7;
                    } else {
                        nArray3[4] = n7;
                    }
                    if (objectArray2[1] == n3) {
                        objectArray2[5] = n9;
                    } else {
                        objectArray2[4] = n9;
                    }
                    nArray4[5] = n5;
                    objectArray[6] = (PdVector)n6;
                } else {
                    if (nArray3[1] == n3) {
                        nArray3[6] = n9;
                    } else {
                        nArray3[4] = n9;
                    }
                    if (objectArray2[1] == n3) {
                        objectArray2[5] = n7;
                    } else {
                        objectArray2[4] = n7;
                    }
                    nArray4[5] = n6;
                    objectArray[6] = (PdVector)n5;
                }
                this.m_triangleInfo.addElement(objectArray);
                this.m_triangleInfo.addElement(nArray4);
                this.m_noe += 2;
                if (this.m_bHasElementTexture) {
                    pdVectorArray4 = (PdVector[])this.m_elementTexture.elementAt(n4);
                    pdVectorArray3 = new PdVector[3];
                    pdVectorArray2 = new PdVector[3];
                    pdVectorArray3[0] = PdVector.blendNew((double)0.5, (PdVector)pdVectorArray4[0], (double)0.5, (PdVector)pdVectorArray4[1]);
                    pdVectorArray3[1] = pdVectorArray4[1];
                    pdVectorArray3[2] = PdVector.blendNew((double)0.5, (PdVector)pdVectorArray4[1], (double)0.5, (PdVector)pdVectorArray4[2]);
                    pdVectorArray2[0] = PdVector.copyNew((PdVector)pdVectorArray3[0]);
                    pdVectorArray2[1] = PdVector.copyNew((PdVector)pdVectorArray3[2]);
                    pdVectorArray2[2] = PdVector.copyNew((PdVector)pdVectorArray4[0]);
                    pdVectorArray4[1] = pdVectorArray4[2];
                    pdVectorArray4[2] = pdVectorArray4[0];
                    pdVectorArray4[0] = PdVector.copyNew((PdVector)pdVectorArray3[2]);
                    this.m_elementTexture.addElement(pdVectorArray3);
                    this.m_elementTexture.addElement(pdVectorArray2);
                }
                if (this.m_bHasElementColors) {
                    this.m_elementColor.addElement(this.m_elementColor.elementAt(n4));
                    this.m_elementColor.addElement(this.m_elementColor.elementAt(n4));
                }
                if (this.m_bHasElementBackColors) {
                    this.m_elementBackColor.addElement(this.m_elementBackColor.elementAt(n4));
                    this.m_elementBackColor.addElement(this.m_elementBackColor.elementAt(n4));
                }
                if (this.m_bHasElementNormals) {
                    this.m_elementNormal.addElement(PdVector.copyNew((PdVector)((PdVector)this.m_elementNormal.elementAt(n4))));
                    this.m_elementNormal.addElement(PdVector.copyNew((PdVector)((PdVector)this.m_elementNormal.elementAt(n4))));
                }
                n2 = 0;
                while (n2 < this.m_numVectorFields) {
                    if (this.m_vectorFieldIsBasedOn[n2] == 1) {
                        this.m_vectorField[n2].addElement(PdVector.copyNew((PdVector)((PdVector)this.m_vectorField[n2].elementAt(n4))));
                        this.m_vectorField[n2].addElement(PdVector.copyNew((PdVector)((PdVector)this.m_vectorField[n2].elementAt(n4))));
                    }
                    ++n2;
                }
                n5 = n10;
                n6 = n9;
                nArray3 = nArray2;
                objectArray2 = objectArray;
            } else if (nArray2[5] == n5) {
                n10 = n4;
                n9 = this.m_noe;
                n7 = this.m_noe + 1;
                objectArray = new int[7];
                int[] nArray5 = new int[7];
                if (nArray2[TRIANGLE_TYPE] == START) {
                    nArray2[PwLocalButterfly.TRIANGLE_TYPE] = START;
                    objectArray[PwLocalButterfly.TRIANGLE_TYPE] = (PdVector)LEFT;
                    nArray5[PwLocalButterfly.TRIANGLE_TYPE] = R_RIGHT;
                } else if (nArray2[TRIANGLE_TYPE] == LEFT) {
                    nArray2[PwLocalButterfly.TRIANGLE_TYPE] = LEFT;
                    objectArray[PwLocalButterfly.TRIANGLE_TYPE] = (PdVector)L_LEFT;
                    nArray5[PwLocalButterfly.TRIANGLE_TYPE] = RIGHT;
                } else if (nArray2[TRIANGLE_TYPE] == RIGHT) {
                    nArray2[PwLocalButterfly.TRIANGLE_TYPE] = RIGHT;
                    objectArray[PwLocalButterfly.TRIANGLE_TYPE] = (PdVector)START;
                    nArray5[PwLocalButterfly.TRIANGLE_TYPE] = LEFT;
                } else if (nArray2[TRIANGLE_TYPE] == L_LEFT || nArray2[TRIANGLE_TYPE] == R_RIGHT) {
                    nArray2[PwLocalButterfly.TRIANGLE_TYPE] = L_LEFT;
                    objectArray[PwLocalButterfly.TRIANGLE_TYPE] = (PdVector)RIGHT;
                    nArray5[PwLocalButterfly.TRIANGLE_TYPE] = START;
                }
                objectArray[1] = (PdVector)n8;
                objectArray[2] = (PdVector)nArray2[1];
                objectArray[3] = (PdVector)nArray2[2];
                nArray5[1] = n3;
                nArray5[2] = nArray2[1];
                nArray5[3] = n8;
                nArray2[2] = n8;
                nArray2[1] = n3;
                nArray5[4] = n9;
                if (nArray2[6] != -1) {
                    nArray = (int[])this.m_triangleInfo.elementAt(nArray2[6]);
                    n2 = 4;
                    do {
                        if (nArray[n2] != n4) continue;
                        nArray[n2] = n9;
                        break;
                    } while (++n2 < 7);
                }
                objectArray[4] = (PdVector)nArray2[6];
                nArray2[6] = n7;
                objectArray[6] = (PdVector)n7;
                nArray5[5] = n10;
                if (nArray3[2] == nArray2[3] || nArray3[3] == nArray2[3]) {
                    if (nArray3[1] == n3) {
                        nArray3[6] = n10;
                    } else {
                        nArray3[4] = n10;
                    }
                    if (objectArray2[1] == n3) {
                        objectArray2[5] = n7;
                    } else {
                        objectArray2[4] = n7;
                    }
                    nArray5[6] = n6;
                    nArray2[5] = n5;
                } else {
                    if (nArray3[1] == n3) {
                        nArray3[6] = n7;
                    } else {
                        nArray3[4] = n7;
                    }
                    if (objectArray2[1] == n3) {
                        objectArray2[5] = n10;
                    } else {
                        objectArray2[4] = n10;
                    }
                    nArray5[6] = n5;
                    nArray2[5] = n6;
                }
                this.m_triangleInfo.addElement(objectArray);
                this.m_triangleInfo.addElement(nArray5);
                this.m_noe += 2;
                if (this.m_bHasElementTexture) {
                    pdVectorArray4 = (PdVector[])this.m_elementTexture.elementAt(n4);
                    pdVectorArray3 = new PdVector[3];
                    pdVectorArray2 = new PdVector[3];
                    pdVectorArray3[0] = PdVector.blendNew((double)0.5, (PdVector)pdVectorArray4[1], (double)0.5, (PdVector)pdVectorArray4[2]);
                    pdVectorArray3[1] = PdVector.copyNew((PdVector)pdVectorArray4[0]);
                    pdVectorArray3[2] = pdVectorArray4[1];
                    pdVectorArray2[0] = PdVector.blendNew((double)0.5, (PdVector)pdVectorArray4[0], (double)0.5, (PdVector)pdVectorArray4[2]);
                    pdVectorArray2[1] = pdVectorArray4[0];
                    pdVectorArray2[2] = PdVector.copyNew((PdVector)pdVectorArray3[0]);
                    pdVectorArray4[0] = PdVector.copyNew((PdVector)pdVectorArray2[0]);
                    pdVectorArray4[1] = PdVector.copyNew((PdVector)pdVectorArray2[2]);
                    this.m_elementTexture.addElement(pdVectorArray3);
                    this.m_elementTexture.addElement(pdVectorArray2);
                }
                if (this.m_bHasElementColors) {
                    this.m_elementColor.addElement(this.m_elementColor.elementAt(n4));
                    this.m_elementColor.addElement(this.m_elementColor.elementAt(n4));
                }
                if (this.m_bHasElementBackColors) {
                    this.m_elementBackColor.addElement(this.m_elementBackColor.elementAt(n4));
                    this.m_elementBackColor.addElement(this.m_elementBackColor.elementAt(n4));
                }
                if (this.m_bHasElementNormals) {
                    this.m_elementNormal.addElement(PdVector.copyNew((PdVector)((PdVector)this.m_elementNormal.elementAt(n4))));
                    this.m_elementNormal.addElement(PdVector.copyNew((PdVector)((PdVector)this.m_elementNormal.elementAt(n4))));
                }
                n2 = 0;
                while (n2 < this.m_numVectorFields) {
                    if (this.m_vectorFieldIsBasedOn[n2] == 1) {
                        this.m_vectorField[n2].addElement(PdVector.copyNew((PdVector)((PdVector)this.m_vectorField[n2].elementAt(n4))));
                        this.m_vectorField[n2].addElement(PdVector.copyNew((PdVector)((PdVector)this.m_vectorField[n2].elementAt(n4))));
                    }
                    ++n2;
                }
                n5 = n10;
                n6 = n9;
                nArray3 = nArray2;
                objectArray2 = objectArray;
            }
            n3 = n8;
            n4 = n11;
        }
    }
}

