/*
 * Decompiled with CFR 0.152.
 */
package jvx.geom;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.image.MemoryImageSource;
import java.util.Date;
import jv.geom.PgElementSet;
import jv.geom.PgTexture;
import jv.geom.PgVectorField;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.vecmath.PdBaryDir;
import jv.vecmath.PdVector;
import jvx.numeric.PnElementRK;
import jvx.numeric.PnGeodesicRK;
import jvx.numeric.PnLIC;
import jvx.numeric.PnVertexRK;
import jvx.numeric.PnVertexRKIgnoreDirection;
import jvx.project.PjWorkshop;

public class PwLIC
extends PjWorkshop
implements Runnable {
    protected PgElementSet m_geom = null;
    protected Thread m_LIC;
    protected PuInteger m_vfIndex;
    protected PuInteger m_LICSize;
    protected PuInteger m_conv;
    protected PuInteger m_minConv;
    protected PuDouble m_coarseness;
    protected PuDouble m_stepSize;
    protected boolean m_bFast = false;
    protected boolean m_bIgnoreDir = false;
    protected boolean m_bManyUpdates = false;
    protected PuDouble m_contrast;
    protected Dimension m_textureSize = new Dimension(0, 0);
    protected int m_workPercent = -1;
    protected long m_time = -1L;
    protected PnLIC m_pnLic;
    protected boolean m_preview = false;
    private static /* synthetic */ Class class$jvx$geom$PwLIC;

    public boolean isComputingLIC() {
        return this.m_LIC != null && this.m_LIC.isAlive();
    }

    public Dimension getTextureSize() {
        return this.m_textureSize;
    }

    public void setFast(boolean bl) {
        this.m_bFast = bl;
        this.update(this);
    }

    public boolean getFast() {
        return this.m_bFast;
    }

    public void setIgnoreDirection(boolean bl) {
        this.m_bIgnoreDir = bl;
        this.update(this);
    }

    public boolean getIgnoreDirection() {
        return this.m_bIgnoreDir;
    }

    public boolean update(Object object) {
        if (object == null) {
            super.update(null);
        } else {
            if (object == this.m_minConv) {
                if (this.m_minConv.getValue() > this.m_conv.getValue()) {
                    this.m_minConv.setValue(this.m_conv.getValue());
                }
                return true;
            }
            if (object == this.m_conv) {
                if (this.m_minConv.getValue() > this.m_conv.getValue()) {
                    this.m_minConv.setValue(this.m_conv.getValue());
                }
                return true;
            }
            if (object == this.m_geom) {
                int n = this.m_geom.getNumVectorFields();
                if (n == this.m_vfIndex.getMax()) {
                    return true;
                }
                if (n > 0) {
                    this.m_vfIndex.setBounds(1, n, 1, 2);
                    this.m_vfIndex.update((Object)this.m_vfIndex);
                } else {
                    this.m_vfIndex.setBounds(0, 0, 1, 2);
                    this.m_vfIndex.setValue(0);
                    this.m_vfIndex.update((Object)this.m_vfIndex);
                }
                return true;
            }
            if (object == this.m_LICSize) {
                this.m_textureSize = new Dimension(0, 0);
                this.update(this);
                return true;
            }
        }
        return super.update(object);
    }

    protected long getLICTime() {
        return this.m_time;
    }

    public void computeTextureSize() {
        if (this.m_pnLic != null) {
            this.m_pnLic.setSize(this.m_LICSize.getValue());
            this.m_textureSize = new Dimension(this.m_pnLic.getTextureWidth(), this.m_pnLic.getTextureHeight());
            this.update(this);
        }
    }

    public double getStepSize() {
        return this.m_stepSize.getValue();
    }

    public void startPreview() {
        this.m_preview = true;
        if (this.isComputingLIC()) {
            this.stopLIC();
        }
        this.m_LIC = new Thread(this);
        this.m_LIC.start();
    }

    public PnLIC getNumericLICInstance() {
        return this.m_pnLic;
    }

    public void close() {
        this.stopLIC();
        if (this.m_geom != null) {
            this.m_geom.removeUpdateListener((PsUpdateIf)this);
        }
    }

    public PwLIC() {
        super(PsConfig.getMessage((int)54109));
        this.m_LICSize = new PuInteger(PsConfig.getMessage((int)54110), (PsUpdateIf)this);
        this.m_conv = new PuInteger(PsConfig.getMessage((int)54111), (PsUpdateIf)this);
        this.m_minConv = new PuInteger(PsConfig.getMessage((int)54112), (PsUpdateIf)this);
        this.m_coarseness = new PuDouble(PsConfig.getMessage((int)54113), null);
        this.m_vfIndex = new PuInteger(PsConfig.getMessage((int)54096), null);
        this.m_stepSize = new PuDouble(PsConfig.getMessage((int)54114), null);
        this.m_contrast = new PuDouble(PsConfig.getMessage((int)54304), null);
        if (this.getClass() == (class$jvx$geom$PwLIC != null ? class$jvx$geom$PwLIC : (class$jvx$geom$PwLIC = PwLIC.class$("jvx.geom.PwLIC")))) {
            this.init();
        }
    }

    public void setSendManyUpdates(boolean bl) {
        this.m_bManyUpdates = bl;
    }

    public boolean getSendManyUpdates() {
        return this.m_bManyUpdates;
    }

    public void setLICSize(int n) {
        if (n > this.m_LICSize.getMax()) {
            this.m_LICSize.setBounds(this.m_LICSize.getMin(), n, this.m_LICSize.getLineIncr(), this.m_LICSize.getPageIncr());
        }
        this.m_LICSize.setValue(n);
        this.update(this.m_LICSize);
    }

    public int getLICSize() {
        return this.m_LICSize.getValue();
    }

    public void startLIC() {
        this.m_preview = false;
        if (this.isComputingLIC()) {
            this.stopLIC();
        }
        this.m_LIC = new Thread(this);
        this.m_LIC.start();
    }

    public void stopLIC() {
        if (this.m_LIC == null) {
            return;
        }
        this.m_LIC.interrupt();
        this.m_LIC = null;
        System.gc();
        this.m_workPercent = -1;
        this.update(this);
    }

    public double getContrast() {
        return this.m_contrast.getValue();
    }

    public void setGeometry(PgElementSet pgElementSet) {
        if (pgElementSet.getDimOfElements() != 3) {
            PsDebug.warning((String)"geometry must be a triangulation");
            PgElementSet.triangulate((PgElementSet)pgElementSet);
        }
        super.setGeometry((PgGeometry)pgElementSet);
        if (this.m_geom != null) {
            this.m_geom.removeUpdateListener((PsUpdateIf)this);
        }
        this.m_geom = pgElementSet;
        if (this.m_geom != null) {
            this.m_geom.addUpdateListener((PsUpdateIf)this);
            this.update(this.m_geom);
        }
        this.m_pnLic = new PnLIC(this.m_geom);
    }

    public PgGeometry getGeometry() {
        return this.m_geom;
    }

    public void setVectorFieldIndex(int n) {
        this.m_vfIndex.setValue(n + 1);
    }

    public int getVectorFieldIndex() {
        return this.m_vfIndex.getValue() - 1;
    }

    public void setConvolutionWidth(int n) {
        if (n > this.m_conv.getMax()) {
            this.m_conv.setBounds(this.m_conv.getMin(), n, this.m_conv.getLineIncr(), this.m_conv.getPageIncr());
        }
        this.m_conv.setValue(n);
        this.update(this.m_conv);
    }

    public int getConvolutionWidth() {
        return this.m_conv.getValue();
    }

    public double getCoarseness() {
        return this.m_coarseness.getValue();
    }

    public void setMinConvolutionWidth(int n) {
        if (n > this.m_minConv.getMax()) {
            this.m_minConv.setBounds(this.m_minConv.getMin(), n, this.m_minConv.getLineIncr(), this.m_minConv.getPageIncr());
        }
        this.m_minConv.setValue(n);
        this.update(this.m_minConv);
    }

    public int getMinConvolutionWidth() {
        return this.m_minConv.getValue();
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void run() {
        long l;
        PgElementSet pgElementSet = null;
        PgVectorField pgVectorField = null;
        PnLIC pnLIC = this.m_pnLic;
        pgElementSet = this.m_geom;
        if (this.m_vfIndex.getValue() <= 0 || this.m_vfIndex.getValue() > pgElementSet.getNumVectorFields()) {
            return;
        }
        pgVectorField = pgElementSet.getVectorField(this.m_vfIndex.getValue() - 1);
        long l2 = new Date().getTime();
        this.m_workPercent = 0;
        this.update(this);
        PnGeodesicRK pnGeodesicRK = null;
        if (pgVectorField.getBasedOn() == 1) {
            pnGeodesicRK = new PnElementRK(pgElementSet);
            ((PnElementRK)pnGeodesicRK).setVectorField(pgVectorField);
        } else if (this.m_bIgnoreDir) {
            pnGeodesicRK = new PnVertexRKIgnoreDirection(pgElementSet);
            ((PnVertexRKIgnoreDirection)pnGeodesicRK).setVectorField(pgVectorField);
        } else {
            pnGeodesicRK = new PnVertexRK(pgElementSet);
            ((PnVertexRK)pnGeodesicRK).setVectorField(pgVectorField);
        }
        pnGeodesicRK.setFirstOrder(this.m_bFast);
        if (pgElementSet.getTexture() == null) {
            pgElementSet.setTexture(new PgTexture());
        }
        PgTexture pgTexture = pgElementSet.getTexture();
        Frame frame = new Frame();
        double d = this.m_contrast.getValue();
        if (this.m_textureSize.width == 0 || this.m_textureSize.height == 0 || pgElementSet.getElementTextures() == null) {
            pnLIC.setSize(this.m_LICSize.getValue());
            this.m_textureSize = new Dimension(this.m_pnLic.getTextureWidth(), this.m_pnLic.getTextureHeight());
        }
        pnLIC.setRungeKutta(pnGeodesicRK);
        int[] nArray = null;
        int n = pnLIC.getTextureWidth();
        int n2 = pnLIC.getTextureHeight();
        pnLIC.setWorldConvolutionWidth((double)this.m_conv.getValue() / 100.0);
        pnLIC.setMinConvolutionWidth(this.m_minConv.getValue());
        pnLIC.setCoarseness(this.m_coarseness.getValue());
        pnLIC.setStepSize(this.m_stepSize.getValue());
        int n3 = pgElementSet.getNumElements();
        pnLIC.reset();
        PdVector[] pdVectorArray = new PdVector[n3];
        PdBaryDir[] pdBaryDirArray = new PdBaryDir[n3];
        double[] dArray = new double[n3];
        PdVector[] pdVectorArray2 = new PdVector[3 * n3];
        boolean[] blArray = new boolean[n3];
        boolean[] blArray2 = new boolean[n3];
        int n4 = 0;
        while (n4 < n3) {
            blArray[n4] = false;
            blArray2[n4] = false;
            ++n4;
        }
        n4 = n3 - 1;
        while (n4 >= 0) {
            if (this.m_preview) {
                pnLIC.makeFastElement(n4, pdVectorArray, pdBaryDirArray, dArray, pdVectorArray2, blArray, blArray2);
            } else {
                pnLIC.makeElement(n4);
            }
            if (!this.m_preview && (this.m_bManyUpdates || n3 >= 10 && n4 % (n3 / 10) == 0) && this.m_workPercent != -1) {
                this.m_workPercent = 100 - (int)((double)n4 / ((double)n3 / 10.0) * 10.0);
                nArray = pnLIC.getPixArray(nArray, d);
                pgTexture.setImage(frame.createImage(new MemoryImageSource(n, n2, nArray, 0, n)));
                pgElementSet.showElements(true);
                pgElementSet.showElementTexture(true);
                pgElementSet.update(null);
                this.update(this);
            } else if (!this.m_preview && n3 < 10 && this.m_workPercent != -1) {
                this.m_workPercent = (int)((double)(n3 - n4) * 100.0 / (double)n3);
                nArray = pnLIC.getPixArray(nArray, d);
                pgTexture.setImage(frame.createImage(new MemoryImageSource(n, n2, nArray, 0, n)));
                pgElementSet.showElements(true);
                pgElementSet.showElementTexture(true);
                pgElementSet.update(null);
                this.update(this);
            }
            if (this.m_LIC == null || this.m_LIC.isInterrupted()) {
                return;
            }
            --n4;
        }
        PwLIC pwLIC = this;
        synchronized (pwLIC) {
            nArray = pnLIC.getPixArray(nArray, d);
            pgTexture.setImage(frame.createImage(new MemoryImageSource(n, n2, nArray, 0, n)));
            pgElementSet.showElements(true);
            pgElementSet.showElementTexture(true);
            pgElementSet.update(null);
            nArray = null;
            System.gc();
            Object var23_22 = null;
        }
        this.m_workPercent = -1;
        this.m_time = l = new Date().getTime() - l2;
        this.m_LIC = null;
        System.gc();
        this.update(this);
    }

    public void init() {
        super.init();
        this.m_LICSize.setDefBounds(10, 500, 5, 50);
        this.m_LICSize.setDefValue(120);
        this.m_LICSize.init();
        this.m_conv.setDefBounds(2, 600, 1, 5);
        this.m_conv.setDefValue(100);
        this.m_conv.init();
        this.m_minConv.setDefBounds(1, 50, 1, 5);
        this.m_minConv.setDefValue(1);
        this.m_minConv.init();
        this.m_coarseness.setDefBounds(0.0, 1.0, 0.05, 0.1);
        this.m_coarseness.setDefValue(0.1);
        this.m_coarseness.init();
        this.m_vfIndex.setDefBounds(0, 0, 1, 2);
        this.m_vfIndex.setDefValue(0);
        this.m_vfIndex.init();
        this.m_stepSize.setDefBounds(0.001, 3.0, 0.05, 0.1);
        this.m_stepSize.setDefValue(0.1);
        this.m_stepSize.init();
        this.m_contrast.setDefBounds(0.0, 100.0, 1.0, 10.0);
        this.m_contrast.setDefValue(10.0);
        this.m_contrast.init();
        if (this.m_geom != null) {
            this.update(this.m_geom);
        }
    }

    protected int getWorkPercent() {
        return this.m_workPercent;
    }
}

