/*
 * Decompiled with CFR 0.152.
 */
package jvx.geom;

import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Insets;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgPolygonSet;
import jv.geom.PgVectorField;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.project.PvDisplayIf;
import jv.project.PvViewerIf;
import jv.vecmath.PdBary;
import jv.vecmath.PdBaryDir;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.viewer.PvDisplay;
import jvx.geom.PgVertexStar;
import jvx.geom.PwBary;
import jvx.numeric.PnEnergyMinimizer;
import jvx.numeric.PnHodgeU;
import jvx.numeric.PnHodgeW;
import jvx.project.PjWorkshop;
import jvx.surface.PgSurfaceGraph;

public class PwHodge
extends PjWorkshop {
    private static final int M_NUM_LOOPS = 1;
    protected int m_dimOfDomain = -1;
    protected PgElementSet m_domain = null;
    protected PgElementSet[] m_decDomain = null;
    protected PgVectorField m_vf = null;
    protected PnEnergyMinimizer m_diriU;
    protected PgElementSet m_u = new PgElementSet(1);
    protected PgSurfaceGraph m_uGraph;
    protected PgVectorField m_gradU;
    protected PnEnergyMinimizer m_diriW;
    protected PgElementSet m_w;
    protected PgSurfaceGraph m_wGraph;
    protected PgVectorField m_coGradW;
    protected PgVectorField m_v;
    protected PuInteger m_selectedVF;
    protected int m_numVF = 0;
    protected boolean m_bZeroBoundsU = false;
    protected boolean m_bZeroBoundsW = false;
    protected PnHodgeU m_hodgeUEnergy;
    protected PnHodgeW m_hodgeWEnergy;
    protected boolean m_bAutoUpdate = false;
    private boolean m_bUComputed = false;
    private boolean m_bWComputed = false;
    private boolean m_bLock = false;
    private boolean m_bMinimizing = false;
    private boolean m_bFirstTime = true;
    protected PvDisplayIf[] m_display;
    protected Frame[] m_frames;
    protected PgPolygonSet m_rotSing;
    protected PgPolygonSet m_divSing;
    protected PgPolygonSet m_rotIcon;
    protected PgPolygonSet m_divIcon;
    protected PgVectorField m_rotDir1;
    protected PgVectorField m_divDir1;
    protected PgVectorField m_rotDir2;
    protected PgVectorField m_divDir2;
    protected PuDouble m_offset;
    protected PuDouble m_scale;
    protected PuDouble m_scaleEmblem;
    private int m_detectionFlag = 0;
    public static int DETECT_SINKS_SOURCES = 1;
    public static int DETECT_VORTICES = 2;
    public static int DETECT_SADDLES = 4;
    private static /* synthetic */ Class class$jvx$geom$PwHodge;

    public void stop() {
        this.m_diriU.stop();
        this.m_diriW.stop();
        this.m_bMinimizing = false;
    }

    protected void computeFeatures(boolean bl) {
        if (bl) {
            this.computeFeatures(this.m_uGraph, this.m_decDomain[0], this.m_divSing, this.m_divIcon, this.m_divDir1, this.m_divDir2, true, this.m_detectionFlag);
            return;
        }
        this.computeFeatures(this.m_wGraph, this.m_decDomain[1], this.m_rotSing, this.m_rotIcon, this.m_rotDir1, this.m_rotDir2, false, this.m_detectionFlag);
    }

    private void computeFeatures(PgElementSet pgElementSet, PgElementSet pgElementSet2, PgPolygonSet pgPolygonSet, PgPolygonSet pgPolygonSet2, PgVectorField pgVectorField, PgVectorField pgVectorField2, boolean bl, int n) {
        boolean bl2;
        boolean bl3 = bl && (DETECT_SINKS_SOURCES & n) != 0 || !bl && (DETECT_VORTICES & n) != 0;
        boolean bl4 = bl2 = (DETECT_SADDLES & n) != 0;
        if (!bl3 && !bl2) {
            return;
        }
        int n2 = pgElementSet2.getDimOfVertices();
        PdVector[] pdVectorArray = pgElementSet.getVertices();
        PdVector[] pdVectorArray2 = pgElementSet2.getVertices();
        int n3 = pgElementSet2.getNumVertices();
        PdVector pdVector = new PdVector(n3);
        int n4 = 0;
        while (n4 < n3) {
            pdVector.m_data[n4] = pdVectorArray[n4].m_data[n2];
            ++n4;
        }
        PgVertexStar pgVertexStar = new PgVertexStar();
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        PiVector piVector = new PiVector();
        PdBaryDir pdBaryDir = new PdBaryDir(3);
        PdBaryDir pdBaryDir2 = new PdBaryDir(3);
        PdVector pdVector2 = new PdVector(n2);
        PdVector pdVector3 = new PdVector(n2 + 1);
        PdVector pdVector4 = new PdVector(n2 + 1);
        PdVector pdVector5 = new PdVector(n2 + 1);
        pgPolygonSet2.setNumPolygons(0);
        pgPolygonSet2.setNumVertices(0);
        pgPolygonSet2.showVertices(false);
        pgPolygonSet2.showPolygonColors(true);
        PdVector pdVector6 = new PdVector(n2 + 1);
        PdVector pdVector7 = new PdVector(n2 + 1);
        PdVector pdVector8 = new PdVector(n2 + 1);
        PiVector[] piVectorArray = this.computeSingularities(pgElementSet, pgPolygonSet, pdVector3, bl3, bl2);
        int n5 = piVectorArray[0].getSize();
        pgPolygonSet.removeAllVectorFields();
        pgElementSet.removeAllVectorFields();
        pgVectorField.setGeometry((PgPointSet)pgPolygonSet);
        pgVectorField2.setGeometry((PgPointSet)pgPolygonSet);
        int n6 = pgVectorField.getNumVectors();
        pdVector3.setConstant(0.0);
        int n7 = 0;
        while (n7 < n6) {
            pgVectorField.setVector(n7, pdVector3);
            pgVectorField2.setVector(n7, pdVector3);
            ++n7;
        }
        PgVectorField pgVectorField3 = new PgVectorField(3);
        pdVector5.setName("laplacian discrete");
        this.computeLaplacianNormalDiscrete(pgElementSet, pgVectorField3, pgVertexStar, pdVector3, pdVector4, pdVector6, pdVector7, pdVector8);
        PdVector pdVector9 = new PdVector(2);
        PdVector pdVector10 = new PdVector(2);
        PdVector pdVector11 = new PdVector(2);
        PdBaryDir[][] pdBaryDirArray = new PdBaryDir[2][n5];
        int[][] nArray = new int[2][n5];
        PdVector[] pdVectorArray3 = pgElementSet.getVertexNormals();
        PdVector[] pdVectorArray4 = PdVector.copyNew((PdVector[])pdVectorArray, (int)n3);
        double d4 = 1.0E-4;
        int n8 = 0;
        while (n8 < n3) {
            int n9 = n2;
            pdVectorArray[n8].m_data[n9] = pdVectorArray[n8].m_data[n9] * d4;
            ++n8;
        }
        n8 = 0;
        while (n8 < n5) {
            int n10;
            int n11 = piVectorArray[0].m_data[n8];
            pgVertexStar.makeVertexStar(pgElementSet2, piVectorArray[0].m_data[n8], -1);
            PiVector piVector2 = pgVertexStar.getLink();
            int n12 = piVector2.getSize();
            d = 0.0;
            d2 = 0.0;
            d3 = 0.0;
            PdVector pdVector12 = new PdVector(pgVertexStar.getSize());
            double d5 = PwBary.getVertexAngles(pgVertexStar, pgElementSet, pdVector12);
            double d6 = 1.5707963267948966;
            pdVector5.setConstant(0.0);
            int n13 = 1;
            int n14 = n12 - 1;
            int n15 = 0;
            while (n15 < n12) {
                this.rotate90(pdVectorArray[n11], pdVectorArray[piVector2.m_data[n15]], pdVectorArray[piVector2.m_data[n13]], pdVector7, pdVector3, pdVector4);
                this.rotate90(pdVectorArray[n11], pdVectorArray[piVector2.m_data[n15]], pdVectorArray[piVector2.m_data[n14]], pdVector8, pdVector3, pdVector4);
                pdVector4.add(pdVector7, pdVector8);
                pdVector4.multScalar(0.5);
                pdVector5.add(pdVector4);
                ++n14;
                if (++n13 == n12) {
                    n13 = 0;
                }
                if (n14 == n12) {
                    n14 = 0;
                }
                ++n15;
            }
            n13 = 1;
            n14 = n12 - 1;
            n15 = 0;
            while (n15 < n12) {
                this.rotate90(pdVectorArray[n11], pdVectorArray[piVector2.m_data[n15]], pdVectorArray[piVector2.m_data[n13]], pdVector7, pdVector3, pdVector4);
                this.rotate90(pdVectorArray[n11], pdVectorArray[piVector2.m_data[n15]], pdVectorArray[piVector2.m_data[n14]], pdVector8, pdVector3, pdVector4);
                pdVector4.add(pdVector7, pdVector8);
                pdVector4.multScalar(0.5);
                double d7 = pdVector4.length();
                pdVector4.normalize();
                pdVector3.copyArray(pdVector5);
                pdVector3.normalize();
                if (n2 == 2 && pdVectorArray3 != null && PdVector.dot((PdVector)pdVector3, (PdVector)pdVectorArray3[n11]) < 0.0) {
                    pdVector3.multScalar(-1.0);
                }
                double d8 = Math.cos(d6);
                double d9 = Math.sin(d6);
                d += d8 * d8 * (d7 *= PdVector.dot((PdVector)pdVector4, (PdVector)pdVector3));
                d2 += d9 * d8 * d7;
                d3 += d9 * d9 * d7;
                d6 += pdVector12.m_data[n15] / d5 * 2.0 * Math.PI;
                ++n14;
                if (++n13 == n12) {
                    n13 = 0;
                }
                if (n14 == n12) {
                    n14 = 0;
                }
                ++n15;
            }
            PwHodge.compute2DEV(d, d2, d3, pdVector2, pdVector9, pdVector10);
            double d10 = pdVector9.length();
            double d11 = pdVector10.length();
            if (!bl && piVectorArray[1].m_data[n8] > 1) {
                pdVector9.normalize();
                pdVector10.normalize();
                pdVector11.copy(pdVector9);
                pdVector9.blend(Math.sqrt(Math.abs(d11 / d10)), pdVector11, 1.0, pdVector10);
                pdVector10.blend(-Math.sqrt(Math.abs(d11 / d10)), pdVector11, 1.0, PdVector.copyNew((PdVector)pdVector10));
            }
            pdVector9.normalize();
            pdVector10.normalize();
            d6 = pdVector9.m_data[0] <= 1.0 ? Math.acos(pdVector9.m_data[0]) : 0.0;
            if (pdVector9.m_data[1] < 0.0) {
                d6 = -d6 + Math.PI * 2;
            }
            int n16 = pgVertexStar.getVertexLocInd().m_data[0];
            pdBaryDir.copyArray(PdBaryDir.TRIANGLE_EDGE[(n16 + 2) % 3]);
            int n17 = PwBary.rotateAtVertex(pgElementSet, pgVertexStar.getElement().m_data[0], n16, pdBaryDir, pdBaryDir2, new PdBary(3), d6);
            PiVector piVector3 = pgElementSet.getElement(n17);
            PdBaryDir.getVector((PdVector)pdVector2, (PdBaryDir)pdBaryDir2, (PdVector)pdVectorArray2[piVector3.m_data[0]], (PdVector)pdVectorArray2[piVector3.m_data[1]], (PdVector)pdVectorArray2[piVector3.m_data[2]]);
            pdVector3.copy(pdVector2);
            pdVector3.multScalar(Math.sqrt(Math.abs(d10) * this.m_scaleEmblem.getValue()) / pdVector3.length() / d4);
            pgVectorField.setVector(2 * n8 + 1, pdVector3);
            pdBaryDirArray[0][n8] = PdBaryDir.copyNew((PdBaryDir)pdBaryDir2);
            nArray[0][n8] = n17;
            d6 = pdVector10.m_data[0] <= 1.0 ? Math.acos(pdVector10.m_data[0]) : 0.0;
            if (pdVector10.m_data[1] < 0.0) {
                d6 = -d6 + Math.PI * 2;
            }
            n16 = pgVertexStar.getVertexLocInd().m_data[0];
            pdBaryDir.copyArray(PdBaryDir.TRIANGLE_EDGE[(n16 + 2) % 3]);
            n17 = PwBary.rotateAtVertex(pgElementSet, pgVertexStar.getElement().m_data[0], n16, pdBaryDir, pdBaryDir2, new PdBary(3), d6);
            piVector3 = pgElementSet.getElement(n17);
            PdBaryDir.getVector((PdVector)pdVector2, (PdBaryDir)pdBaryDir2, (PdVector)pdVectorArray2[piVector3.m_data[0]], (PdVector)pdVectorArray2[piVector3.m_data[1]], (PdVector)pdVectorArray2[piVector3.m_data[2]]);
            pdVector3.copy(pdVector2);
            pdVector3.multScalar(Math.sqrt(Math.abs(d11) * this.m_scaleEmblem.getValue()) / pdVector3.length() / d4);
            pgVectorField2.setVector(2 * n8 + 1, pdVector3);
            pdBaryDirArray[1][n8] = PdBaryDir.copyNew((PdBaryDir)pdBaryDir2);
            nArray[1][n8] = n17;
            if (n2 < 3 && (n10 = piVectorArray[1].m_data[n8]) <= 1) {
                pdVector2.copyArray(pdVectorArray2[n11]);
                pdVector9.copy(pgVectorField.getVector(2 * n8 + 1));
                pdVector10.copy(pgVectorField2.getVector(2 * n8 + 1));
                double d12 = pdVector9.length();
                double d13 = pdVector10.length();
                if (d12 > 1.0E-10 && d13 > 1.0E-10) {
                    if (d12 > d13) {
                        pdVector10.multScalar(d12 * d12 / d13 / d13);
                    } else {
                        pdVector9.multScalar(d13 * d13 / d12 / d12);
                    }
                }
                this.addEllipse(pgPolygonSet2, piVector, pdVectorArray2[n11], pdVector9, pdVector10, pdVector11, n10);
            }
            ++n8;
        }
        PdVector.copy((PdVector[])pdVectorArray, (int)0, (PdVector[])pdVectorArray4, (int)0, (int)n3);
        pgPolygonSet.addVectorField(pgVectorField);
        pgPolygonSet.addVectorField(pgVectorField2);
        pgPolygonSet.setGlobalVectorColor(Color.red);
        pgPolygonSet.setGlobalVectorSize(3.0);
        pgPolygonSet.showVectorArrows(true);
    }

    public PgElementSet getPotentialU() {
        return this.m_u;
    }

    private static void compute2DEV(double d, double d2, double d3, PdVector pdVector, PdVector pdVector2, PdVector pdVector3) {
        if (Math.abs(d2) < 1.0E-10) {
            if (Math.abs(d) >= Math.abs(d3)) {
                pdVector.set(d, 0.0);
                pdVector3.set(0.0, d3);
                return;
            }
            pdVector2.set(0.0, d3);
            pdVector3.set(d, 0.0);
            return;
        }
        double d4 = (d + d3) / 2.0;
        double d5 = d4 * d4 - d * d3 + d2 * d2;
        d5 = d5 < 0.0 ? 0.0 : Math.sqrt(d5);
        double d6 = d4 + d5;
        double d7 = d4 - d5;
        if (Math.abs(d6) < Math.abs(d7)) {
            d5 = d6;
            d6 = d7;
            d7 = d5;
        }
        pdVector2.set(-(d3 - d6) / d2, 1.0);
        pdVector3.set(1.0, -(d - d7) / d2);
        pdVector2.normalize();
        pdVector2.multScalar(d6);
        pdVector3.normalize();
        pdVector3.multScalar(d7);
    }

    public void setAutoUpdate(boolean bl) {
        this.m_bAutoUpdate = bl;
    }

    public boolean getAutoUpdate() {
        return this.m_bAutoUpdate;
    }

    protected void computeGradient() {
        PdVector[][] pdVectorArray = ((PnHodgeU)this.m_diriU.getEnergy()).getGradFi();
        if (pdVectorArray == null) {
            return;
        }
        int n = this.m_domain.getNumElements();
        PiVector[] piVectorArray = this.m_domain.getElements();
        PdVector[] pdVectorArray2 = this.m_u.getVertices();
        this.m_gradU.setNumVectors(n);
        PdVector[] pdVectorArray3 = this.m_gradU.getVectors();
        try {
            int n2 = 0;
            while (n2 < n) {
                pdVectorArray3[n2].setConstant(0.0);
                int n3 = 0;
                do {
                    int n4 = piVectorArray[n2].m_data[n3];
                    int n5 = 0;
                    while (n5 < this.m_dimOfDomain) {
                        int n6 = n5;
                        pdVectorArray3[n2].m_data[n6] = pdVectorArray3[n2].m_data[n6] + pdVectorArray2[n4].m_data[0] * pdVectorArray[n2][n3].m_data[n5];
                        ++n5;
                    }
                } while (++n3 < 3);
                ++n2;
            }
            return;
        }
        catch (NullPointerException nullPointerException) {
            PsDebug.warning((String)("Calculation aborted " + nullPointerException.toString()));
            return;
        }
    }

    protected void computeJGradient() {
        PdVector[][] pdVectorArray = ((PnHodgeW)this.m_diriW.getEnergy()).getJGradFi();
        if (pdVectorArray == null) {
            return;
        }
        int n = this.m_domain.getNumElements();
        PiVector[] piVectorArray = this.m_domain.getElements();
        PdVector[] pdVectorArray2 = this.m_w.getVertices();
        this.m_coGradW.setNumVectors(n);
        PdVector[] pdVectorArray3 = this.m_coGradW.getVectors();
        try {
            int n2 = 0;
            while (n2 < n) {
                pdVectorArray3[n2].setConstant(0.0);
                int n3 = 0;
                do {
                    int n4 = piVectorArray[n2].m_data[n3];
                    int n5 = 0;
                    while (n5 < this.m_dimOfDomain) {
                        int n6 = n5;
                        pdVectorArray3[n2].m_data[n6] = pdVectorArray3[n2].m_data[n6] + pdVectorArray2[n4].m_data[0] * pdVectorArray[n2][n3].m_data[n5];
                        ++n5;
                    }
                } while (++n3 < 3);
                ++n2;
            }
            return;
        }
        catch (NullPointerException nullPointerException) {
            PsDebug.warning((String)("Calculation aborted " + nullPointerException.toString()));
            return;
        }
    }

    protected void computeHarmonic() {
        int n = this.m_domain.getNumElements();
        this.m_v.setNumVectors(n);
        PdVector[] pdVectorArray = this.m_v.getVectors();
        try {
            int n2 = 0;
            while (n2 < n) {
                pdVectorArray[n2].sub(this.m_vf.getVector(n2), this.m_gradU.getVector(n2));
                pdVectorArray[n2].sub(this.m_coGradW.getVector(n2));
                ++n2;
            }
            return;
        }
        catch (NullPointerException nullPointerException) {
            PsDebug.warning((String)("Calculation aborted " + nullPointerException.toString()));
            return;
        }
    }

    public void setZeroBoundsW(boolean bl) {
        this.m_bZeroBoundsW = bl;
        this.m_hodgeWEnergy.setZeroGradientAtBounds(bl);
        if (bl) {
            int n = this.m_w.getNumVertices();
            int n2 = 0;
            while (n2 < n) {
                this.m_w.setVertex(n2, 0.0);
                ++n2;
            }
        }
        this.m_diriW.setSurface(this.m_domain, this.m_w);
        this.m_diriW.setEnergy(this.m_hodgeWEnergy);
    }

    public boolean getZeroBoundsW() {
        return this.m_bZeroBoundsW;
    }

    protected static PgPointSet createPointSetFromZMaxMinCrit(PgElementSet pgElementSet, Color color, Color color2, Color color3, double d) {
        if (pgElementSet.getDimOfVertices() < 3) {
            return null;
        }
        PgPointSet pgPointSet = new PgPointSet(pgElementSet.getDimOfVertices());
        pgPointSet.setModelMatrix(pgElementSet.getModelMatrix());
        pgPointSet.assureVertexColors();
        pgPointSet.showVertexColors(true);
        pgPointSet.setName(PsConfig.getMessage((int)45016) + " " + pgElementSet.getName());
        PdVector[] pdVectorArray = pgElementSet.getVertices();
        PdVector pdVector = new PdVector(pgElementSet.getDimOfVertices());
        PiVector[] piVectorArray = PwHodge.getZMaxMinCrit(pgElementSet, d);
        int n = piVectorArray[0].getSize();
        int n2 = 0;
        while (n2 < n) {
            pdVector.copy(pdVectorArray[piVectorArray[0].m_data[n2]]);
            if (piVectorArray[1].m_data[n2] == 1) {
                pdVector.setName(" +");
                pgPointSet.addVertex(pdVector);
                pgPointSet.setVertexColor(n2, color3);
            } else if (piVectorArray[1].m_data[n2] == -1) {
                pdVector.setName(" -");
                pgPointSet.addVertex(pdVector);
                pgPointSet.setVertexColor(n2, color);
            } else {
                pdVector.setName(" " + piVectorArray[1].m_data[n2]);
                pgPointSet.addVertex(pdVector);
                pgPointSet.setVertexColor(n2, color2);
            }
            ++n2;
        }
        return pgPointSet;
    }

    protected static PiVector[] getZMaxMinCrit(PgElementSet pgElementSet, double d) {
        if (pgElementSet.getDimOfVertices() < 3) {
            return null;
        }
        int n = pgElementSet.getDimOfVertices() - 1;
        int n2 = pgElementSet.getNumVertices();
        PiVector piVector = new PiVector();
        PiVector piVector2 = new PiVector();
        PgVertexStar pgVertexStar = new PgVertexStar();
        PdVector[] pdVectorArray = pgElementSet.getVertices();
        int n3 = 0;
        int[] nArray = new int[n2];
        int n4 = 0;
        while (n4 < nArray.length) {
            nArray[n4] = -1;
            ++n4;
        }
        PiVector[] piVectorArray = pgElementSet.getElements();
        int n5 = pgElementSet.getNumElements();
        int n6 = 0;
        while (n6 < n5) {
            int n7 = piVectorArray[n6].getSize();
            int n8 = 0;
            while (n8 < n7) {
                nArray[piVectorArray[n6].m_data[n8]] = n6;
                ++n8;
            }
            ++n6;
        }
        n6 = 0;
        while (n6 < n2) {
            pgVertexStar.makeVertexStar(pgElementSet, n6, nArray[n6]);
            PiVector piVector3 = pgVertexStar.getLink();
            if (pgVertexStar.isClosed()) {
                double d2 = pdVectorArray[n6].getEntry(n);
                double d3 = d2 - d;
                double d4 = d2 + d;
                int n9 = piVector3.getSize();
                boolean bl = true;
                boolean bl2 = true;
                int n10 = 0;
                int n11 = 0;
                int n12 = 0;
                int n13 = 0;
                while (n13 < n9) {
                    double d5 = pdVectorArray[piVector3.getEntry(n13)].getEntry(n);
                    if (d5 > d3) {
                        bl2 = false;
                    }
                    if (d5 < d4) {
                        bl = false;
                    }
                    if (d5 > d4 && n11 < 0) {
                        ++n10;
                        n11 = 1;
                    } else if (d5 < d3 && n11 > 0) {
                        ++n10;
                        n11 = -1;
                    } else if (n11 == 0) {
                        if (d5 > d4) {
                            n11 = 1;
                        } else if (d5 < d3) {
                            n11 = -1;
                        }
                        n12 = n11;
                    }
                    ++n13;
                }
                n13 = 3;
                if (n12 != n11) {
                    ++n10;
                }
                if (bl2 || bl || n10 >= n13) {
                    piVector.addEntry(n6);
                    if (bl2) {
                        piVector2.addEntry(1);
                    } else if (bl) {
                        piVector2.addEntry(-1);
                    } else {
                        piVector2.addEntry(n10);
                    }
                    ++n3;
                }
            }
            ++n6;
        }
        return new PiVector[]{piVector, piVector2};
    }

    protected boolean alreadyGotSomething() {
        return !this.m_bFirstTime;
    }

    private void completeDecomposition() {
        this.computeHarmonic();
        this.m_bMinimizing = false;
        this.m_bFirstTime = false;
    }

    private boolean allocateDisplays() {
        if (this.m_display[0] == null) {
            PvViewerIf pvViewerIf = this.getViewer();
            if (pvViewerIf == null) {
                PsDebug.warning((String)"workshop needs viewer to open displays (use setViewer)");
                return false;
            }
            this.m_display[0] = pvViewerIf.newDisplay(PsConfig.getMessage((int)54079), true);
            this.m_display[1] = pvViewerIf.newDisplay(PsConfig.getMessage((int)54080), true);
            this.m_display[2] = pvViewerIf.newDisplay(PsConfig.getMessage((int)54081), true);
            int n = 350;
            int n2 = 270;
            this.m_frames = new Frame[3];
            int n3 = 0;
            do {
                this.m_frames[n3] = this.m_display[n3].getFrame();
                ((Component)this.m_frames[n3]).setBounds(n3 % 3 * n + 10, n3 / 3 * n2 + 10, n, n2);
                ((Component)this.m_frames[n3]).setVisible(false);
            } while (++n3 < 3);
        }
        return true;
    }

    public PgVectorField getRotationFree() {
        return this.m_gradU;
    }

    public PgVectorField getDivergenceFree() {
        return this.m_coGradW;
    }

    public boolean update(Object object) {
        if (object == null || this.isUpdateSender()) {
            return super.update(null);
        }
        if (object == this) {
            this.setUpdateSender(true);
            if (this.m_uGraph != null) {
                this.m_uGraph.update(this.m_u);
            }
            if (this.m_wGraph != null) {
                this.m_wGraph.update(this.m_w);
            }
            int n = 0;
            do {
                if (this.m_decDomain[n] == null) continue;
                this.m_decDomain[n].update(null);
            } while (++n < 3);
            if (this.m_divSing != null) {
                this.m_divSing.update(null);
            }
            if (this.m_divIcon != null) {
                this.m_divIcon.update(null);
            }
            if (this.m_rotSing != null) {
                this.m_rotSing.update(null);
            }
            if (this.m_rotIcon != null) {
                this.m_rotIcon.update(null);
            }
            this.setUpdateSender(false);
        } else {
            if (object == this.m_diriU) {
                if (this.m_diriU.isStopped()) {
                    this.computeGradient();
                    this.computeFeatures(true);
                    this.m_bUComputed = true;
                    if (this.m_bWComputed) {
                        this.completeDecomposition();
                        this.update((Object)this);
                    }
                }
                return true;
            }
            if (object == this.m_diriW) {
                if (this.m_diriW.isStopped()) {
                    this.computeJGradient();
                    this.computeFeatures(false);
                    this.m_bWComputed = true;
                    if (this.m_bUComputed) {
                        this.completeDecomposition();
                        this.update((Object)this);
                    }
                }
                return true;
            }
            if (object == this.m_domain) {
                int n = this.m_domain.getNumVectorFields();
                if (this.m_numVF != n) {
                    this.m_numVF = n;
                    this.m_selectedVF.setBounds(1, this.m_numVF, 1, 2);
                    if (this.m_numVF < 1) {
                        this.m_selectedVF.setValue(0);
                    }
                    this.m_selectedVF.update(null);
                }
                return super.update(null);
            }
            if (object == this.m_vf) {
                if (this.m_bAutoUpdate) {
                    this.minimize();
                }
                return super.update(null);
            }
            if (object == this.m_selectedVF) {
                this.setVectorField(this.m_domain, this.m_selectedVF.getValue() - 1);
                if (this.m_bAutoUpdate) {
                    this.minimize();
                }
                return super.update(null);
            }
            if (object == this.m_offset) {
                if (this.m_uGraph != null) {
                    this.m_uGraph.setOffset(this.m_offset.getValue());
                    this.m_uGraph.update((Object)this.m_uGraph);
                }
                if (this.m_wGraph != null) {
                    this.m_wGraph.setOffset(this.m_offset.getValue());
                    this.m_wGraph.update((Object)this.m_wGraph);
                }
                return super.update(null);
            }
            if (object == this.m_scale) {
                if (this.m_uGraph != null) {
                    this.m_uGraph.setScalingFactor(this.m_scale.getValue());
                    this.m_uGraph.update((Object)this.m_uGraph);
                }
                if (this.m_wGraph != null) {
                    this.m_wGraph.setScalingFactor(this.m_scale.getValue());
                    this.m_wGraph.update((Object)this.m_wGraph);
                }
                return super.update(null);
            }
            if (object == this.m_uGraph) {
                if (this.alreadyGotSomething()) {
                    this.computeFeatures(true);
                    this.setUpdateSender(true);
                    this.m_divSing.update(null);
                    this.m_divIcon.update(null);
                    this.m_decDomain[0].update(null);
                    this.setUpdateSender(false);
                }
                this.m_display[0].fit();
                return super.update(null);
            }
            if (object == this.m_wGraph) {
                if (this.alreadyGotSomething()) {
                    this.computeFeatures(false);
                    this.setUpdateSender(true);
                    this.m_rotSing.update(null);
                    this.m_rotIcon.update(null);
                    this.m_decDomain[1].update(null);
                    this.setUpdateSender(false);
                }
                this.m_display[1].fit();
                return super.update(null);
            }
            if (object == this.m_scaleEmblem) {
                if (this.alreadyGotSomething()) {
                    this.computeFeatures(true);
                    this.computeFeatures(false);
                    this.setUpdateSender(true);
                    this.m_divSing.update(null);
                    this.m_divIcon.update(null);
                    this.m_rotSing.update(null);
                    this.m_rotIcon.update(null);
                    this.m_decDomain[0].update(null);
                    this.m_decDomain[1].update(null);
                    this.setUpdateSender(false);
                }
                this.m_display[0].fit();
                this.m_display[1].fit();
                return super.update(null);
            }
        }
        return super.update(object);
    }

    public PgSurfaceGraph getWGraph() {
        return this.m_wGraph;
    }

    public void setDisplaySize(int n, int n2, int n3) {
        this.allocateDisplays();
        Insets insets = this.m_frames[n].getInsets();
        ((Component)this.m_frames[n]).setSize(n2 + insets.left + insets.right, n3 + insets.top + insets.bottom);
    }

    public void minimize() {
        if (this.m_domain == null || this.m_vf == null) {
            PsDebug.warning((String)"No domain or vector field.");
            return;
        }
        if (this.m_bLock) {
            return;
        }
        if (this.m_bMinimizing) {
            return;
        }
        this.m_bMinimizing = true;
        this.m_bUComputed = false;
        this.m_bWComputed = false;
        this.m_diriU.minimize();
        this.m_diriW.minimize();
    }

    public void setVisibleFeat(int n, boolean bl) {
        if (n == 0) {
            this.m_divSing.setVisible(bl);
            this.m_divIcon.setVisible(bl);
            this.setUpdateSender(true);
            this.m_divSing.update(null);
            this.m_divIcon.update(null);
            this.setUpdateSender(false);
            return;
        }
        if (n == 1) {
            this.m_rotSing.setVisible(bl);
            this.m_rotIcon.setVisible(bl);
            this.setUpdateSender(true);
            this.m_rotSing.update(null);
            this.m_rotIcon.update(null);
            this.setUpdateSender(false);
        }
    }

    public boolean getVisibleFeat(int n) {
        if (n == 0) {
            return this.m_divSing.isVisible();
        }
        if (n == 1) {
            return this.m_rotSing.isVisible();
        }
        return false;
    }

    private PdVector rotate90(PdVector pdVector, PdVector pdVector2, PdVector pdVector3, PdVector pdVector4, PdVector pdVector5, PdVector pdVector6) {
        int n = pdVector.getSize();
        if (pdVector4 == null) {
            pdVector4 = new PdVector(n);
        }
        if (pdVector5 == null) {
            pdVector5 = new PdVector(n);
        }
        if (pdVector6 == null) {
            pdVector6 = new PdVector(n);
        }
        pdVector5.sub(pdVector3, pdVector2);
        pdVector6.sub(pdVector3, pdVector);
        pdVector4.sub(pdVector2, pdVector);
        double d = PdVector.angle((PdVector)pdVector6, (PdVector)pdVector4) * Math.PI / 180.0;
        pdVector4.multScalar(-1.0);
        double d2 = PdVector.angle((PdVector)pdVector5, (PdVector)pdVector4) * Math.PI / 180.0;
        pdVector5.multScalar(Math.cos(d) / Math.sin(d));
        pdVector6.multScalar(Math.cos(d2) / Math.sin(d2));
        pdVector4.add(pdVector5, pdVector6);
        return pdVector4;
    }

    protected static boolean inside2D(PgPolygonSet pgPolygonSet, int n, PdVector pdVector) {
        if (!pgPolygonSet.isClosed(n)) {
            return false;
        }
        int n2 = pgPolygonSet.getDimOfVertices();
        PdVector[] pdVectorArray = pgPolygonSet.getVertices();
        PiVector piVector = pgPolygonSet.getPolygon(n);
        int n3 = 0;
        int n4 = piVector.getSize() - 1;
        PdVector pdVector2 = new PdVector(n2);
        PdVector pdVector3 = new PdVector(n2);
        int n5 = 0;
        while (n5 < n4) {
            int n6 = n5 + 1;
            if (n6 >= n4) {
                n6 -= n4;
            }
            pdVector2.copyArray(pdVectorArray[piVector.m_data[n5]]);
            pdVector3.copyArray(pdVectorArray[piVector.m_data[n6]]);
            if (!(pdVector2.m_data[0] < pdVector.m_data[0] && pdVector3.m_data[0] < pdVector.m_data[0] || pdVector2.m_data[1] < pdVector.m_data[1] && pdVector3.m_data[1] < pdVector.m_data[1] || pdVector2.m_data[1] > pdVector.m_data[1] && pdVector3.m_data[1] > pdVector.m_data[1] || pdVector3.m_data[0] - (pdVector3.m_data[1] - pdVector.m_data[1]) / (pdVector3.m_data[1] - pdVector2.m_data[1]) * (pdVector3.m_data[0] - pdVector2.m_data[0]) < pdVector.m_data[0])) {
                ++n3;
            }
            ++n5;
        }
        return n3 % 2 != 0;
    }

    protected static boolean isOk2D(PgPolygonSet pgPolygonSet, int n, PgElementSet pgElementSet, PiVector piVector, int n2) {
        if (!PwHodge.inside2D(pgPolygonSet, n, pgElementSet.getVertex(piVector.m_data[n2]))) {
            return false;
        }
        int n3 = piVector.getSize();
        int n4 = 0;
        while (n4 < n3) {
            if (n4 != n2 && PwHodge.inside2D(pgPolygonSet, n, pgElementSet.getVertex(piVector.m_data[n4]))) {
                return false;
            }
            ++n4;
        }
        return true;
    }

    private void addEllipse(PgPolygonSet pgPolygonSet, PiVector piVector, PdVector pdVector, PdVector pdVector2, PdVector pdVector3, PdVector pdVector4, int n) {
        int n2 = pgPolygonSet.getNumVertices();
        piVector.setSize(41);
        int n3 = 0;
        do {
            piVector.m_data[n3] = n2++;
            double d = Math.cos((double)n3 * Math.PI / 20.0);
            double d2 = Math.sin((double)n3 * Math.PI / 20.0);
            pdVector4.m_data[0] = pdVector.m_data[0] + d * pdVector2.m_data[0] + d2 * pdVector3.m_data[0];
            pdVector4.m_data[1] = pdVector.m_data[1] + d * pdVector2.m_data[1] + d2 * pdVector3.m_data[1];
            pgPolygonSet.addVertex(pdVector4);
        } while (++n3 < 41);
        pgPolygonSet.addPolygon(piVector);
        piVector.setSize(2);
        piVector.m_data[0] = n2 - 1;
        piVector.m_data[1] = n2 - 1 - 20;
        pgPolygonSet.addPolygon(piVector);
        piVector.m_data[0] = n2 - 1 - 10;
        piVector.m_data[1] = n2 - 1 - 30;
        pgPolygonSet.addPolygon(piVector);
        Color color = Color.black;
        if (n == -1) {
            color = Color.red;
        } else if (n == 1) {
            color = Color.green;
        }
        pgPolygonSet.setPolygonColor(pgPolygonSet.getNumPolygons() - 3, color);
        pgPolygonSet.setPolygonColor(pgPolygonSet.getNumPolygons() - 2, color);
        pgPolygonSet.setPolygonColor(pgPolygonSet.getNumPolygons() - 1, color);
    }

    public PvDisplayIf getDisplay(int n) {
        this.allocateDisplays();
        return this.m_display[n];
    }

    public void close() {
        this.removeGeometry();
        PvViewerIf pvViewerIf = this.getViewer();
        int n = 0;
        do {
            if (this.m_display[n] != null) continue;
            Frame frame = ((PvDisplay)this.m_display[n]).getFrame();
            if (frame != null) {
                ((Component)frame).setVisible(false);
            }
            if (pvViewerIf != null) {
                pvViewerIf.removeDisplay(this.m_display[n]);
            }
            this.m_display[n] = null;
        } while (++n < 3);
        super.close();
    }

    public void setVisibleGraph(int n, boolean bl) {
        if (n == 0) {
            this.m_uGraph.setVisible(bl);
            this.setUpdateSender(true);
            this.m_uGraph.update(null);
            this.setUpdateSender(false);
            return;
        }
        if (n == 1) {
            this.m_wGraph.setVisible(bl);
            this.setUpdateSender(true);
            this.m_wGraph.update(null);
            this.setUpdateSender(false);
            return;
        }
        throw new ArrayIndexOutOfBoundsException("index = " + n);
    }

    public boolean getVisibleGraph(int n) {
        if (n == 0) {
            return this.m_uGraph.isVisible();
        }
        if (n == 1) {
            return this.m_wGraph.isVisible();
        }
        throw new ArrayIndexOutOfBoundsException("index = " + n);
    }

    public PgElementSet getPotentialW() {
        return this.m_w;
    }

    public void reset() {
    }

    public void setZeroBoundsU(boolean bl) {
        this.m_bZeroBoundsU = bl;
        this.m_hodgeUEnergy.setZeroGradientAtBounds(bl);
        int n = this.m_u.getNumVertices();
        int n2 = 0;
        while (n2 < n) {
            this.m_u.setVertex(n2, 0.0);
            ++n2;
        }
        this.m_diriU.setSurface(this.m_domain, this.m_u);
        this.m_diriU.setEnergy(this.m_hodgeUEnergy);
    }

    public boolean getZeroBoundsU() {
        return this.m_bZeroBoundsU;
    }

    public PwHodge() {
        super(PsConfig.getMessage((int)51021));
        this.m_u.setName("u");
        this.m_diriU = new PnEnergyMinimizer();
        this.m_diriU.setName("u " + PsConfig.getMessage((int)45010));
        this.m_diriU.setParent((PsUpdateIf)this);
        this.m_w = new PgElementSet(1);
        this.m_w.setName("w");
        this.m_diriW = new PnEnergyMinimizer();
        this.m_diriW.setName("w " + PsConfig.getMessage((int)45010));
        this.m_diriW.setParent((PsUpdateIf)this);
        this.m_decDomain = new PgElementSet[3];
        this.m_display = new PvDisplayIf[3];
        this.m_selectedVF = new PuInteger(PsConfig.getMessage((int)54078), (PsUpdateIf)this);
        this.m_offset = new PuDouble(PsConfig.getMessage((int)54419), (PsUpdateIf)this);
        this.m_scale = new PuDouble(PsConfig.getMessage((int)54420), (PsUpdateIf)this);
        this.m_scaleEmblem = new PuDouble(PsConfig.getMessage((int)54421), (PsUpdateIf)this);
        if (((Object)((Object)this)).getClass() == (class$jvx$geom$PwHodge != null ? class$jvx$geom$PwHodge : (class$jvx$geom$PwHodge = PwHodge.class$("jvx.geom.PwHodge")))) {
            this.init();
        }
    }

    public void setVisibleComponent(int n, boolean bl) {
        this.m_decDomain[n].setVisible(bl);
        this.setUpdateSender(true);
        this.m_decDomain[n].update(null);
        this.setUpdateSender(false);
    }

    public boolean getVisibleComponent(int n) {
        return this.m_decDomain[n].isVisible();
    }

    private void computeLaplacianNormalDiscrete(PgElementSet pgElementSet, PgVectorField pgVectorField, PgVertexStar pgVertexStar, PdVector pdVector, PdVector pdVector2, PdVector pdVector3, PdVector pdVector4, PdVector pdVector5) {
        PdVector[] pdVectorArray = pgElementSet.getVertices();
        int n = pgElementSet.getNumVertices();
        pgVectorField.setBasedOn(0);
        pgVectorField.setGeometry((PgPointSet)pgElementSet);
        int n2 = 0;
        while (n2 < n) {
            pgVertexStar.makeVertexStar(pgElementSet, n2, -1);
            if (pgVertexStar.isClosed()) {
                PiVector piVector = pgVertexStar.getLink();
                int n3 = piVector.getSize();
                int n4 = 1;
                int n5 = n3 - 1;
                pdVector3.setConstant(0.0);
                int n6 = 0;
                while (n6 < n3) {
                    this.rotate90(pdVectorArray[n2], pdVectorArray[piVector.m_data[n6]], pdVectorArray[piVector.m_data[n4]], pdVector4, pdVector, pdVector2);
                    this.rotate90(pdVectorArray[n2], pdVectorArray[piVector.m_data[n6]], pdVectorArray[piVector.m_data[n5]], pdVector5, pdVector, pdVector2);
                    pdVector2.add(pdVector4, pdVector5);
                    pdVector2.multScalar(0.5);
                    pdVector3.add(pdVector2);
                    ++n5;
                    if (++n4 == n3) {
                        n4 = 0;
                    }
                    if (n5 == n3) {
                        n5 = 0;
                    }
                    ++n6;
                }
                double d = pdVector3.length();
                if (d > 1.0E-10) {
                    pdVector3.multScalar(1.0 / d);
                }
                pgVectorField.setVector(n2, pdVector3);
            }
            ++n2;
        }
        pgVectorField.setGeometry((PgPointSet)pgElementSet);
        pgElementSet.addVectorField(pgVectorField);
        pgVectorField.setVisible(false);
        pgElementSet.setGlobalVectorSize(3.0);
        pgElementSet.showVectorArrows(true);
    }

    public void setIconScale(double d) {
        this.m_scaleEmblem.setValue(d);
    }

    public void setVectorField(PgElementSet pgElementSet, int n) {
        if (pgElementSet == null) {
            PsDebug.warning((String)"Missing surface.");
            return;
        }
        if (pgElementSet.getDimOfElements() != 3) {
            PsDebug.warning((String)"Domain is no triangulation.");
            return;
        }
        if (pgElementSet.getNumVectorFields() <= n || n < 0) {
            PsDebug.warning((String)("Wrong vector field, index=" + n + "."));
            return;
        }
        if (pgElementSet.getVectorField(n).getBasedOn() != 1) {
            PsDebug.warning((String)"Field parameter not element based.");
            return;
        }
        this.stop();
        this.m_bLock = true;
        this.m_bFirstTime = true;
        if (!this.allocateDisplays()) {
            return;
        }
        int n2 = 0;
        do {
            this.m_display[n2].removeGeometry((PgGeometryIf)this.m_decDomain[n2]);
        } while (++n2 < 3);
        this.m_display[0].removeGeometry((PgGeometryIf)this.m_uGraph);
        this.m_display[1].removeGeometry((PgGeometryIf)this.m_wGraph);
        this.m_display[0].removeGeometry((PgGeometryIf)this.m_divSing);
        this.m_display[1].removeGeometry((PgGeometryIf)this.m_rotSing);
        this.m_display[0].removeGeometry((PgGeometryIf)this.m_divIcon);
        this.m_display[1].removeGeometry((PgGeometryIf)this.m_rotIcon);
        if (this.m_domain != null && this.m_domain.hasUpdateListener((PsUpdateIf)this)) {
            this.m_domain.removeUpdateListener((PsUpdateIf)this);
        }
        if (this.m_vf != null && this.m_vf.hasUpdateListener((PsUpdateIf)this)) {
            this.m_vf.removeUpdateListener((PsUpdateIf)this);
        }
        this.m_dimOfDomain = pgElementSet.getDimOfVertices();
        this.m_domain = pgElementSet;
        if (!this.m_domain.hasUpdateListener((PsUpdateIf)this)) {
            this.m_domain.addUpdateListener((PsUpdateIf)this);
        }
        this.m_vf = this.m_domain.getVectorField(n);
        if (!this.m_vf.hasUpdateListener((PsUpdateIf)this)) {
            this.m_vf.addUpdateListener((PsUpdateIf)this);
        }
        this.m_numVF = this.m_domain.getNumVectorFields();
        this.m_selectedVF.setBounds(1, this.m_numVF, 1, 2);
        this.m_selectedVF.setValue(n + 1);
        this.m_hodgeUEnergy = new PnHodgeU();
        this.m_hodgeUEnergy.setVectorField(this.m_vf);
        this.m_hodgeUEnergy.setZeroGradientAtBounds(this.m_bZeroBoundsU);
        this.m_u.setNumVertices(this.m_domain.getNumVertices());
        this.m_u.copyElementSet(this.m_domain);
        this.m_diriU.setSurface(this.m_domain, this.m_u);
        this.m_diriU.setEnergy(this.m_hodgeUEnergy);
        this.m_diriU.enableUpdateDomain(false);
        this.m_diriU.setNumLoops(1);
        this.m_gradU = new PgVectorField(this.m_dimOfDomain);
        this.m_gradU.setBasedOn(1);
        this.m_gradU.setName(PsConfig.getMessage((int)45011) + " u");
        this.m_w.setNumVertices(this.m_domain.getNumVertices());
        this.m_w.copyElementSet(this.m_domain);
        this.m_hodgeWEnergy = new PnHodgeW();
        this.m_hodgeWEnergy.setVectorField(this.m_vf);
        this.m_hodgeWEnergy.setZeroGradientAtBounds(this.m_bZeroBoundsW);
        this.m_diriW.setSurface(this.m_domain, this.m_w);
        this.m_diriW.setEnergy(this.m_hodgeWEnergy);
        this.m_diriW.enableUpdateDomain(false);
        this.m_diriW.setNumLoops(1);
        this.m_coGradW = new PgVectorField(this.m_dimOfDomain);
        this.m_coGradW.setBasedOn(1);
        this.m_coGradW.setName(PsConfig.getMessage((int)45013) + " w");
        this.m_v = new PgVectorField(this.m_dimOfDomain);
        this.m_v.setBasedOn(1);
        this.m_v.setName(PsConfig.getMessage((int)45014) + " v");
        n2 = 0;
        do {
            this.m_decDomain[n2] = new PgElementSet(this.m_dimOfDomain);
            this.m_decDomain[n2].setName(PsConfig.getMessage((int)45015) + " " + n2);
            this.m_decDomain[n2].copy((PsObject)this.m_domain);
            this.m_decDomain[n2].removeAllVectorFields();
            this.m_decDomain[n2].showElements(false);
            this.m_decDomain[n2].showEdges(false);
            this.m_decDomain[n2].showVectorArrows(true);
            this.m_decDomain[n2].setGlobalVectorColor(Color.black);
            switch (n2) {
                case 0: {
                    this.m_decDomain[0].addVectorField(this.m_gradU);
                    this.m_gradU.setGeometry((PgPointSet)this.m_decDomain[0]);
                    break;
                }
                case 1: {
                    this.m_decDomain[1].addVectorField(this.m_coGradW);
                    this.m_coGradW.setGeometry((PgPointSet)this.m_decDomain[1]);
                    break;
                }
                case 2: {
                    this.m_decDomain[2].addVectorField(this.m_v);
                    this.m_v.setGeometry((PgPointSet)this.m_decDomain[2]);
                }
            }
            this.m_display[n2].addGeometry((PgGeometryIf)this.m_decDomain[n2]);
            this.m_display[n2].fit();
        } while (++n2 < 3);
        this.m_uGraph = new PgSurfaceGraph(this.m_dimOfDomain + 1);
        this.m_uGraph.setName(PsConfig.getMessage((int)45012) + " u");
        this.m_uGraph.addUpdateListener((PsUpdateIf)this);
        this.m_uGraph.setSurfaces(this.m_decDomain[0], this.m_u);
        if (this.m_dimOfDomain > 2) {
            this.m_uGraph.showAsNormalVariation(true);
        } else {
            this.m_uGraph.setOffset(4.0);
        }
        this.m_uGraph.showTransparency(true);
        this.m_wGraph = new PgSurfaceGraph(this.m_dimOfDomain + 1);
        this.m_wGraph.setName(PsConfig.getMessage((int)45012) + " w");
        this.m_wGraph.addUpdateListener((PsUpdateIf)this);
        this.m_wGraph.setSurfaces(this.m_decDomain[1], this.m_w);
        if (this.m_dimOfDomain > 2) {
            this.m_wGraph.showAsNormalVariation(true);
        } else {
            this.m_wGraph.setOffset(4.0);
        }
        this.m_wGraph.showTransparency(true);
        this.m_display[0].addGeometry((PgGeometryIf)this.m_uGraph);
        this.m_display[1].addGeometry((PgGeometryIf)this.m_wGraph);
        this.m_uGraph.setVisible(false);
        this.m_wGraph.setVisible(false);
        n2 = 0;
        do {
            this.m_decDomain[n2].setVisible(false);
        } while (++n2 < 3);
        this.m_rotSing = new PgPolygonSet(this.m_dimOfDomain + 1);
        this.m_rotSing.setName(PsConfig.getMessage((int)45060));
        this.m_rotSing.setVisible(false);
        this.m_divSing = new PgPolygonSet(this.m_dimOfDomain + 1);
        this.m_divSing.setName(PsConfig.getMessage((int)45061));
        this.m_divSing.setVisible(false);
        this.m_rotDir1 = new PgVectorField(this.m_dimOfDomain + 1);
        this.m_rotDir1.setName(PsConfig.getMessage((int)45062));
        this.m_rotDir1.setBasedOn(0);
        this.m_divDir1 = new PgVectorField(this.m_dimOfDomain + 1);
        this.m_divDir1.setName(PsConfig.getMessage((int)45063));
        this.m_divDir1.setBasedOn(0);
        this.m_rotDir2 = new PgVectorField(this.m_dimOfDomain + 1);
        this.m_rotDir2.setName(PsConfig.getMessage((int)45064));
        this.m_rotDir2.setBasedOn(0);
        this.m_divDir2 = new PgVectorField(this.m_dimOfDomain + 1);
        this.m_divDir2.setName(PsConfig.getMessage((int)45065));
        this.m_divDir2.setBasedOn(0);
        this.m_rotIcon = new PgPolygonSet(this.m_dimOfDomain);
        this.m_rotIcon.setName(PsConfig.getMessage((int)45066));
        this.m_rotIcon.setVisible(false);
        this.m_divIcon = new PgPolygonSet(this.m_dimOfDomain);
        this.m_divIcon.setName(PsConfig.getMessage((int)45067));
        this.m_divIcon.setVisible(false);
        this.m_display[0].addGeometry((PgGeometryIf)this.m_divSing);
        this.m_display[0].addGeometry((PgGeometryIf)this.m_divIcon);
        this.m_display[1].addGeometry((PgGeometryIf)this.m_rotSing);
        this.m_display[1].addGeometry((PgGeometryIf)this.m_rotIcon);
        this.m_display[0].fit();
        this.m_display[1].fit();
        this.m_bLock = false;
    }

    private PiVector[] computeSingularities(PgElementSet pgElementSet, PgPolygonSet pgPolygonSet, PdVector pdVector, boolean bl, boolean bl2) {
        PdVector[] pdVectorArray = pgElementSet.getVertices();
        PiVector[] piVectorArray = PwHodge.getZMaxMinCrit(pgElementSet, 1.0E-10);
        int n = piVectorArray[0].getSize();
        PiVector[] piVectorArray2 = new PiVector[]{new PiVector(n), new PiVector(n)};
        int n2 = 0;
        pgPolygonSet.setNumVertices(n * 2);
        pgPolygonSet.setNumPolygons(n);
        pgPolygonSet.assurePolygonColors();
        pgPolygonSet.assureVertexColors();
        pgPolygonSet.setGlobalVertexSize(3.0);
        pgPolygonSet.showVertexColors(true);
        pgPolygonSet.showPolygonColors(true);
        pgPolygonSet.showVertexLabels(true);
        int n3 = 0;
        while (n3 < n) {
            block4: {
                String string;
                Color color;
                block5: {
                    block6: {
                        block3: {
                            if (piVectorArray[1].m_data[n3] != -1) break block3;
                            if (!bl) break block4;
                            color = Color.red;
                            string = " -";
                            break block5;
                        }
                        if (piVectorArray[1].m_data[n3] != 1) break block6;
                        if (!bl) break block4;
                        color = Color.green;
                        string = " +";
                        break block5;
                    }
                    if (!bl2) break block4;
                    color = Color.blue;
                    string = " " + piVectorArray[1].m_data[n3];
                }
                pgPolygonSet.setPolygonColor(n2, color);
                pgPolygonSet.setVertexColor(2 * n2, color);
                pgPolygonSet.setVertexColor(2 * n2 + 1, color);
                pdVector.copyArray(pdVectorArray[piVectorArray[0].m_data[n3]]);
                pdVector.setName(string);
                pgPolygonSet.setVertex(2 * n2, pdVector);
                pdVector.setEntry(pdVector.getSize() - 1, 0);
                pgPolygonSet.setVertex(2 * n2 + 1, pdVector);
                pgPolygonSet.setPolygon(n2, new PiVector(2 * n2, 2 * n2 + 1));
                piVectorArray2[0].m_data[n2] = piVectorArray[0].m_data[n3];
                piVectorArray2[1].m_data[n2] = piVectorArray[1].m_data[n3];
                ++n2;
            }
            ++n3;
        }
        pgPolygonSet.setNumPolygons(n2);
        pgPolygonSet.setNumVertices(2 * n2);
        piVectorArray2[0].setSize(n2);
        piVectorArray2[1].setSize(n2);
        return piVectorArray2;
    }

    public void setZeroBounds(boolean bl) {
        this.m_bZeroBoundsU = bl;
        this.m_bZeroBoundsW = bl;
        this.m_hodgeUEnergy.setZeroGradientAtBounds(bl);
        this.m_hodgeWEnergy.setZeroGradientAtBounds(bl);
        int n = this.m_u.getNumVertices();
        int n2 = 0;
        while (n2 < n) {
            this.m_u.setVertex(n2, 0.0);
            ++n2;
        }
        this.m_diriU.setSurface(this.m_domain, this.m_u);
        this.m_diriU.setEnergy(this.m_hodgeUEnergy);
        n = this.m_w.getNumVertices();
        n2 = 0;
        while (n2 < n) {
            this.m_w.setVertex(n2, 0.0);
            ++n2;
        }
        this.m_diriW.setSurface(this.m_domain, this.m_w);
        this.m_diriW.setEnergy(this.m_hodgeWEnergy);
    }

    public PgVectorField getHarmonic() {
        return this.m_v;
    }

    protected boolean isMinimizing() {
        return this.m_bMinimizing;
    }

    public void setGeometry(PgGeometry pgGeometry) {
        if (!(pgGeometry instanceof PgElementSet)) {
            PsDebug.warning((String)"argument geom is no PgElementSet");
            return;
        }
        PgElementSet pgElementSet = (PgElementSet)pgGeometry;
        if (pgElementSet.getNumVectorFields() <= 0) {
            PsDebug.warning((String)"argument geom has no vector field");
            return;
        }
        int n = 0;
        while (n < pgElementSet.getNumVectorFields() && pgElementSet.getVectorField(n).getBasedOn() != 1) {
            ++n;
        }
        if (n >= pgElementSet.getNumVectorFields()) {
            PsDebug.warning((String)"argument geom has no element based vector field");
            return;
        }
        this.setVectorField(pgElementSet, n);
        super.setGeometry(pgGeometry);
    }

    public int getVectorFieldIndex() {
        if (this.m_vf == null || this.m_domain == null) {
            return -1;
        }
        return this.m_domain.getIndexOfVectorField(this.m_vf);
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void setDisplayVisibility(int n, boolean bl) {
        if (bl) {
            ((Component)this.m_frames[n]).setVisible(true);
            this.m_display[n].update((Object)this.m_display[n]);
            this.m_display[n].fit();
            this.m_frames[n].toFront();
            return;
        }
        ((Component)this.m_frames[n]).setVisible(false);
        this.m_frames[n].dispose();
    }

    public boolean getDisplayVisibility(int n) {
        return this.m_frames[n].isVisible();
    }

    public PgSurfaceGraph getUGraph() {
        return this.m_uGraph;
    }

    public void init() {
        this.m_selectedVF.setDefBounds(1, this.m_numVF, 1, 2);
        this.m_selectedVF.setDefValue(this.m_numVF);
        this.m_selectedVF.init();
        this.m_offset.setDefBounds(-50.0, 50.0, 1.0, 5.0);
        this.m_offset.setDefValue(4.0);
        this.m_offset.init();
        this.m_scale.setDefBounds(0.0, 10.0, 0.001, 0.5);
        this.m_scale.setDefValue(1.0);
        this.m_scale.init();
        this.m_scaleEmblem.setDefBounds(0.0, 10.0, 0.1, 0.5);
        this.m_scaleEmblem.setDefValue(1.0);
        this.m_scaleEmblem.init();
        super.init();
    }

    public void removeGeometry() {
        if (this.m_domain != null) {
            this.m_domain.removeUpdateListener((PsUpdateIf)this);
        }
        if (this.m_vf != null) {
            this.m_vf.removeUpdateListener((PsUpdateIf)this);
        }
        this.m_domain = null;
        super.removeGeometry();
    }

    public void setDetectionFlags(int n) {
        this.m_detectionFlag = n;
    }

    public int getDetectionFlags() {
        return this.m_detectionFlag;
    }
}

