/*
 * Decompiled with CFR 0.152.
 */
package jvx.geom;

import java.awt.Color;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgPolygon;
import jv.geom.PgPolygonSet;
import jv.number.PdColor;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.geom.PgFrame;

public class PgTube
extends PgElementSet {
    protected boolean m_bEnabled;
    protected PgElementSet m_elementSet;
    protected PgPolygon m_polygon;
    protected PgPolygonSet m_polygonSet;
    protected boolean[] m_bNotDegenerated;
    protected int m_numFrames;
    protected PgFrame[] m_frame;
    protected PuInteger m_discr;
    private int m_defDiscr = 5;
    private int[] m_defDiscrBounds = new int[]{1, 20, 1, 2};
    protected PuDouble m_thickness;
    private double m_defThick = 0.5;
    private double[] m_defThickBounds = new double[]{0.01, 5.0, 0.1, 1.0};
    protected PuDouble m_arrowThickness;
    private double m_defArrThick = 180.0;
    private double[] m_defArrThickBounds = new double[]{100.0, 300.0, 5.0, 10.0};
    protected PuDouble m_arrowLength;
    private double m_defArrLen = 125.0;
    private double[] m_defArrLenBounds = new double[]{50.0, 300.0, 5.0, 10.0};
    protected boolean m_bShowStartArrow;
    protected boolean m_bShowEndArrow;
    protected boolean m_bInduceColors;
    protected boolean m_bEnabledArrowPanel;
    private static /* synthetic */ Class class$jvx$geom$PgTube;

    public boolean isEnabledStartArrow() {
        return this.m_bShowStartArrow;
    }

    public void removePolygonSet() {
        if (this.m_polygonSet == null) {
            return;
        }
        this.m_polygonSet.removeUpdateListener((PsUpdateIf)this);
        this.m_polygonSet = null;
    }

    public void setDefArrowLength(double d) {
        this.m_defArrLen = d;
    }

    public void setDefArrowThickness(double d) {
        this.m_defArrThick = d;
    }

    public PgFrame[] generatePolygonSetFrames() {
        int n;
        PiVector piVector;
        if (this.m_polygonSet == null) {
            PsDebug.warning((String)"missing polygonSet");
            return null;
        }
        int n2 = this.m_polygonSet.getNumPolygons();
        int n3 = 0;
        this.m_numFrames = 0;
        int n4 = 0;
        while (n4 < n2) {
            piVector = this.m_polygonSet.getPolygon(n4);
            n = piVector.getSize();
            this.m_numFrames += n;
            ++n4;
        }
        this.m_frame = PgFrame.realloc(this.m_frame, this.m_numFrames, ((PgGeometry)this).m_dim);
        this.m_bNotDegenerated = new boolean[n2];
        n4 = 0;
        while (n4 < n2) {
            piVector = this.m_polygonSet.getPolygon(n4);
            int n5 = n = piVector.getSize();
            boolean bl = piVector.m_data[0] == piVector.m_data[n - 1];
            PdVector pdVector = new PdVector(((PgGeometry)this).m_dim);
            PgFrame pgFrame = new PgFrame(((PgGeometry)this).m_dim);
            PgFrame pgFrame2 = new PgFrame(((PgGeometry)this).m_dim);
            PdVector[] pdVectorArray = this.m_polygonSet.getVertices();
            double d = 0.0;
            int n6 = 1;
            while (n6 < n) {
                pdVector.sub(pdVectorArray[piVector.m_data[n6]], pdVectorArray[piVector.m_data[n6 - 1]]);
                d = pdVector.length();
                if (d > 0.0) break;
                ++n6;
            }
            if (d == 0.0) {
                this.m_bNotDegenerated[n4] = false;
                this.m_numFrames -= n5;
                this.m_frame = PgFrame.realloc(this.m_frame, this.m_numFrames, ((PgGeometry)this).m_dim);
            } else {
                this.m_bNotDegenerated[n4] = true;
                pgFrame.e1.copy(pdVector);
                pgFrame.e1.normalize();
                pgFrame.e2.normalToVector(pgFrame.e1);
                pgFrame.e3.cross(pgFrame.e1, pgFrame.e2);
                pgFrame.base.copy(pdVectorArray[piVector.m_data[0]]);
                this.m_frame[n3].copy(pgFrame);
                n6 = 1;
                while (n6 < n5 - 1) {
                    int n7 = (n6 + 1) % n;
                    pdVector.sub(pdVectorArray[piVector.m_data[n7]], pdVectorArray[piVector.m_data[n6]]);
                    pgFrame2.parallelTranslate(pgFrame, this.m_frame[n3 + n6], pdVectorArray[piVector.m_data[n6]], pdVector);
                    pgFrame.copy(pgFrame2);
                    ++n6;
                }
                if (bl) {
                    pgFrame2.parallelTranslate(pgFrame, this.m_frame[n3 + n5 - 1], pdVectorArray[piVector.m_data[0]], this.m_frame[n3].e1);
                    pgFrame.copy(this.m_frame[n3]);
                    n6 = n5 - 1;
                    while (n6 > 0) {
                        pdVector.sub(pdVectorArray[piVector.m_data[n6]], pdVectorArray[piVector.m_data[n6 - 1]]);
                        d = pdVector.length();
                        if (d > 0.0) break;
                        --n6;
                    }
                    pgFrame2.parallelTranslate(pgFrame, this.m_frame[n3], pdVectorArray[piVector.m_data[0]], pdVector);
                    PdVector pdVector2 = PdVector.crossNew((PdVector)this.m_frame[n3].e2, (PdVector)pdVector);
                    PdVector pdVector3 = PdVector.crossNew((PdVector)this.m_frame[n3 + n5 - 1].e2, (PdVector)pdVector);
                    if (!pdVector2.normalize()) {
                        pdVector2 = PdVector.crossNew((PdVector)this.m_frame[n3].e3, (PdVector)pdVector);
                        pdVector3 = PdVector.crossNew((PdVector)this.m_frame[n3 + n5 - 1].e3, (PdVector)pdVector);
                    }
                    double d2 = PdVector.angleWithOrientation((PdVector)pdVector2, (PdVector)pdVector3, (PdVector)pdVector) / (double)(n5 - 1);
                    n6 = 1;
                    while (n6 < n5) {
                        double d3 = Math.cos((double)n6 * d2);
                        double d4 = Math.sin((double)n6 * d2);
                        PdVector pdVector4 = PdVector.blendNew((double)d3, (PdVector)this.m_frame[n3 + n6].e2, (double)(-d4), (PdVector)this.m_frame[n3 + n6].e3);
                        PdVector pdVector5 = PdVector.blendNew((double)d4, (PdVector)this.m_frame[n3 + n6].e2, (double)d3, (PdVector)this.m_frame[n3 + n6].e3);
                        this.m_frame[n3 + n6].e2 = pdVector4;
                        this.m_frame[n3 + n6].e3 = pdVector5;
                        ++n6;
                    }
                } else {
                    pgFrame.base.copy(pdVectorArray[piVector.m_data[n5 - 1]]);
                    this.m_frame[n3 + n5 - 1].copy(pgFrame);
                }
                n3 += n5;
            }
            ++n4;
        }
        return this.m_frame;
    }

    public boolean update(Object object) {
        if (object != null && object == this.m_elementSet) {
            this.computeTube();
            return super.update((Object)this);
        }
        if (object != null && object == this.m_polygon) {
            this.generateFrames();
            this.computeTube();
            return super.update((Object)this);
        }
        if (object != null && object == this.m_polygonSet) {
            this.generatePolygonSetFrames();
            this.computeTube();
            return super.update((Object)this);
        }
        if (object == this.m_discr) {
            this.computeTube();
            return super.update((Object)this);
        }
        if (object == this.m_thickness) {
            this.computeTube();
            return super.update((Object)this);
        }
        if (object == this.m_arrowThickness) {
            this.computeTube();
            return super.update((Object)this);
        }
        if (object == this.m_arrowLength) {
            this.computeTube();
            return super.update((Object)this);
        }
        return super.update(object);
    }

    public PuInteger getDiscr() {
        return this.m_discr;
    }

    public void setDiscr(int n) {
        this.m_discr.setValue(n);
    }

    public boolean isEnabledInduceColors() {
        return this.m_bInduceColors;
    }

    public void generateTube() {
        int n;
        int n2;
        if (this.m_polygon == null && this.m_polygonSet == null) {
            PsDebug.warning((String)"missing polygon resp. polygonSet");
            return;
        }
        if (this.m_polygon != null && this.m_polygon.getDimOfVertices() != 3) {
            PsDebug.warning((String)"dimension of polygon must be 3, no tube computed.");
            return;
        }
        if (this.m_polygonSet != null && this.m_polygonSet.getDimOfVertices() != 3) {
            PsDebug.warning((String)"dimension of polygonSet must be 3, no tube computed.");
            return;
        }
        double d = this.m_thickness.getValue();
        int n3 = this.m_discr.getValue();
        this.setNumVertices(this.m_numFrames * n3);
        this.assureVertexNormals();
        double[] dArray = new double[n3];
        double[] dArray2 = new double[n3];
        double d2 = Math.PI * 2 / (double)n3;
        int n4 = 0;
        while (n4 < n3) {
            double d3 = d2 * (double)n4;
            dArray[n4] = Math.cos(d3);
            dArray2[n4] = Math.sin(d3);
            ++n4;
        }
        n4 = 0;
        int n5 = 0;
        while (n5 < this.m_numFrames) {
            n2 = 0;
            while (n2 < n3) {
                ((PgPointSet)this).m_vertexNormal[n4].blend(dArray[n2], this.m_frame[n5].e2, dArray2[n2], this.m_frame[n5].e3);
                ((PgPointSet)this).m_vertex[n4].blend(1.0, this.m_frame[n5].base, d, ((PgPointSet)this).m_vertexNormal[n4]);
                ++n4;
                ++n2;
            }
            ++n5;
        }
        this.makeCylinderConn(this.m_numFrames, n3);
        if (this.m_bShowStartArrow && (this.m_polygonSet == null || this.m_polygonSet.getNumPolygons() > 0 && this.m_bNotDegenerated[0])) {
            this.addArrow(0, -1, 0);
        }
        if (this.m_bShowEndArrow && (this.m_polygonSet == null || this.m_polygonSet.getNumPolygons() > 0 && this.m_bNotDegenerated[this.m_polygonSet.getNumPolygons() - 1])) {
            this.addArrow(this.m_numFrames - 1, 1, this.m_polygonSet == null ? this.m_numFrames - 2 : this.m_polygonSet.getNumPolygons() - 1);
        }
        if (this.m_polygon != null && (this.m_bShowStartArrow || this.m_bShowEndArrow)) {
            this.makeNeighbour();
        }
        if (this.m_polygon != null && this.m_bInduceColors) {
            this.setGlobalElementColor(this.m_polygon.getGlobalEdgeColor());
            if (this.m_polygon.hasEdgeColors()) {
                this.assureElementColors();
                Color[] colorArray = this.m_polygon.getEdgeColors();
                n4 = 0;
                n2 = 0;
                while (n2 < this.m_numFrames - 1) {
                    n = 0;
                    while (n < n3) {
                        this.setElementColor(n4, colorArray[n2]);
                        ++n4;
                        ++n;
                    }
                    ++n2;
                }
            }
            this.showElementColors(this.m_polygon.isShowingEdgeColors());
            this.showSmoothElementColors(this.m_polygon.isShowingSmoothEdgeColors());
        }
        if (this.m_polygonSet != null) {
            int n6;
            int n7;
            int n8 = this.m_polygonSet.getNumPolygons();
            n = 0;
            int n9 = 0;
            if (this.m_polygonSet.hasPolygonColors() && this.m_bInduceColors) {
                this.assureElementColors();
                if (this.m_polygonSet.isShowingPolygonColors()) {
                    this.showElementColors(true);
                } else {
                    this.showElementColors(false);
                }
            }
            int n10 = 0;
            while (n10 < n8 - 1) {
                PiVector piVector = this.m_polygonSet.getPolygon(n10);
                n7 = piVector.getSize();
                if (this.m_bNotDegenerated[n10]) {
                    n6 = 0;
                    while (n6 < n3) {
                        this.setTagElement(n + (n7 - 1) * n3 + n6, 2);
                        ++n6;
                    }
                    n9 += n7;
                    if (this.m_bShowEndArrow) {
                        this.addArrow(n9 - 1, 1, n10);
                    }
                    if (this.m_bNotDegenerated[n10 + 1] && this.m_bShowStartArrow) {
                        this.addArrow(n9, -1, n10 + 1);
                    }
                    if (this.m_polygonSet.hasPolygonColors() && this.m_bInduceColors) {
                        n6 = 0;
                        while (n6 < n3) {
                            int n11 = 0;
                            while (n11 < n7 - 1) {
                                this.setElementColor(n + n11 * n3 + n6, this.m_polygonSet.getPolygonColor(n10));
                                ++n11;
                            }
                            ++n6;
                        }
                    }
                    n += n7 * n3;
                }
                ++n10;
            }
            if (this.m_polygonSet.hasPolygonColors() && this.m_bInduceColors) {
                PiVector piVector = this.m_polygonSet.getPolygon(n8 - 1);
                n10 = piVector.getSize();
                n7 = 0;
                while (n7 < n3) {
                    n6 = 0;
                    while (n6 < n10 - 1) {
                        this.setElementColor(n + n6 * n3 + n7, this.m_polygonSet.getPolygonColor(n8 - 1));
                        ++n6;
                    }
                    ++n7;
                }
            }
            if (this.m_bShowStartArrow || this.m_bShowEndArrow) {
                this.makeNeighbour();
            }
            this.removeMarkedElements();
        }
        this.makeElementNormals();
    }

    public void setEnabledEndArrow(boolean bl) {
        this.m_bShowEndArrow = bl;
    }

    public void setPolygon(PgPolygon pgPolygon) {
        if (pgPolygon == null) {
            PsDebug.warning((String)"missing polygon");
            return;
        }
        if (this.m_polygon == pgPolygon) {
            return;
        }
        this.removePolygon();
        this.m_polygon = pgPolygon;
        this.m_polygon.addUpdateListener((PsUpdateIf)this);
    }

    public void setDefArrowLengthBounds(double d, double d2, double d3, double d4) {
        this.m_defArrLenBounds[0] = d;
        this.m_defArrLenBounds[1] = d2;
        this.m_defArrLenBounds[2] = d3;
        this.m_defArrLenBounds[3] = d4;
    }

    public Object clone() {
        PgTube pgTube = (PgTube)((Object)super.clone());
        if (pgTube == null) {
            return null;
        }
        if (this.m_elementSet != null) {
            pgTube.setElementSet(this.m_elementSet);
        }
        if (this.m_polygon != null) {
            pgTube.setPolygon(this.m_polygon);
        }
        if (this.m_polygonSet != null) {
            pgTube.setPolygonSet(this.m_polygonSet);
        }
        pgTube.m_discr = (PuInteger)this.m_discr.clone();
        pgTube.m_thickness = (PuDouble)this.m_thickness.clone();
        pgTube.m_arrowLength = (PuDouble)this.m_arrowLength.clone();
        pgTube.m_arrowThickness = (PuDouble)this.m_arrowThickness.clone();
        return pgTube;
    }

    public void removeElementSet() {
        if (this.m_elementSet == null) {
            return;
        }
        this.m_elementSet.removeUpdateListener((PsUpdateIf)this);
        this.m_elementSet = null;
    }

    public void setPolygonSet(PgPolygonSet pgPolygonSet) {
        if (pgPolygonSet == null) {
            PsDebug.warning((String)"missing polygonSet");
            return;
        }
        if (this.m_polygonSet == pgPolygonSet) {
            return;
        }
        this.removePolygonSet();
        this.m_polygonSet = pgPolygonSet;
        this.m_polygonSet.addUpdateListener((PsUpdateIf)this);
    }

    public void setDefDiscr(int n) {
        this.m_defDiscr = n;
    }

    public void removePolygon() {
        if (this.m_polygon == null) {
            return;
        }
        this.m_polygon.removeUpdateListener((PsUpdateIf)this);
        this.m_polygon = null;
    }

    public PuDouble getThickness() {
        return this.m_thickness;
    }

    public void setThickness(double d) {
        this.m_thickness.setValue(d);
    }

    public boolean isEnabled() {
        return this.m_bEnabled;
    }

    public void setEnabledInduceColors(boolean bl) {
        if (this.m_bInduceColors == bl) {
            return;
        }
        this.m_bInduceColors = bl;
        if (!bl) {
            this.removeVertexColors();
            this.removeElementColors();
        }
        this.showElementColors(bl);
    }

    public PgTube(int n) {
        super(n);
        if (n != 3) {
            PsDebug.warning((String)"dimension of tube must be 3.");
        }
        this.setTag(7);
        this.m_discr = new PuInteger(PsConfig.getMessage((int)54003), (PsUpdateIf)this);
        this.m_thickness = new PuDouble(PsConfig.getMessage((int)54004), (PsUpdateIf)this);
        this.m_arrowThickness = new PuDouble(PsConfig.getMessage((int)54196), (PsUpdateIf)this);
        this.m_arrowLength = new PuDouble(PsConfig.getMessage((int)54221), (PsUpdateIf)this);
        this.m_bEnabled = true;
        this.m_bEnabledArrowPanel = true;
        this.m_bShowStartArrow = false;
        this.m_bShowEndArrow = false;
        this.m_bInduceColors = false;
        if (((Object)((Object)this)).getClass() == (class$jvx$geom$PgTube != null ? class$jvx$geom$PgTube : (class$jvx$geom$PgTube = PgTube.class$("jvx.geom.PgTube")))) {
            this.init();
        }
    }

    public void computeTube() {
        if (this.m_polygon != null) {
            this.generateTube();
        }
        if (this.m_polygonSet != null) {
            this.generateTube();
            return;
        }
        if (this.m_elementSet != null) {
            this.generateThickEdges();
        }
    }

    public void setDefDiscrBounds(int n, int n2, int n3, int n4) {
        this.m_defDiscrBounds[0] = n;
        this.m_defDiscrBounds[1] = n2;
        this.m_defDiscrBounds[2] = n3;
        this.m_defDiscrBounds[3] = n4;
    }

    public void setDefArrowThicknessBounds(double d, double d2, double d3, double d4) {
        this.m_defArrThickBounds[0] = d;
        this.m_defArrThickBounds[1] = d2;
        this.m_defArrThickBounds[2] = d3;
        this.m_defArrThickBounds[3] = d4;
    }

    public void setElementSet(PgElementSet pgElementSet) {
        if (pgElementSet == null) {
            PsDebug.warning((String)"missing elementSet");
            return;
        }
        if (this.m_elementSet == pgElementSet) {
            return;
        }
        this.removeElementSet();
        this.m_elementSet = pgElementSet;
        this.m_elementSet.addUpdateListener((PsUpdateIf)this);
    }

    public void setEnabledArrowPanel(boolean bl) {
        this.m_bEnabledArrowPanel = bl;
    }

    public PuDouble getArrowLength() {
        return this.m_arrowLength;
    }

    public void setDefThickness(double d) {
        this.m_defThick = d;
    }

    public void setArrowLength(double d) {
        this.m_arrowLength.setValue(d);
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public PgFrame[] generateFrames() {
        int n;
        if (this.m_polygon == null) {
            PsDebug.warning((String)"missing polygon");
            return null;
        }
        if (this.m_polygon.getDimOfVertices() != 3) {
            PsDebug.warning((String)"dimension of polygon must be 3, no tube computed.");
            return null;
        }
        this.m_numFrames = n = this.m_polygon.getNumVertices();
        if (this.m_polygon.isClosed()) {
            ++this.m_numFrames;
        }
        this.m_frame = PgFrame.realloc(this.m_frame, this.m_numFrames, ((PgGeometry)this).m_dim);
        PdVector pdVector = new PdVector(((PgGeometry)this).m_dim);
        PgFrame pgFrame = new PgFrame(((PgGeometry)this).m_dim);
        PgFrame pgFrame2 = new PgFrame(((PgGeometry)this).m_dim);
        PdVector[] pdVectorArray = this.m_polygon.getVertices();
        double d = 0.0;
        int n2 = 1;
        while (n2 < n) {
            pdVector.sub(pdVectorArray[n2], pdVectorArray[n2 - 1]);
            d = pdVector.length();
            if (d > 0.0) break;
            ++n2;
        }
        if (d == 0.0) {
            return null;
        }
        pgFrame.e1.copy(pdVector);
        pgFrame.e1.normalize();
        pgFrame.e2.normalToVector(pgFrame.e1);
        pgFrame.e3.cross(pgFrame.e1, pgFrame.e2);
        pgFrame.base.copy(pdVectorArray[0]);
        this.m_frame[0].copy(pgFrame);
        n2 = 1;
        while (n2 < this.m_numFrames - 1) {
            int n3 = (n2 + 1) % n;
            pdVector.sub(pdVectorArray[n3], pdVectorArray[n2]);
            pgFrame2.parallelTranslate(pgFrame, this.m_frame[n2], pdVectorArray[n2], pdVector);
            pgFrame.copy(pgFrame2);
            ++n2;
        }
        if (this.m_polygon.isClosed()) {
            pgFrame2.parallelTranslate(pgFrame, this.m_frame[this.m_numFrames - 1], pdVectorArray[0], this.m_frame[0].e1);
            pgFrame.copy(this.m_frame[0]);
            n2 = n;
            while (n2 > 0) {
                pdVector.sub(pdVectorArray[n2 % n], pdVectorArray[n2 - 1]);
                d = pdVector.length();
                if (d > 0.0) break;
                --n2;
            }
            pgFrame2.parallelTranslate(pgFrame, this.m_frame[0], pdVectorArray[0], pdVector);
            PdVector pdVector2 = PdVector.crossNew((PdVector)this.m_frame[0].e2, (PdVector)pdVector);
            PdVector pdVector3 = PdVector.crossNew((PdVector)this.m_frame[this.m_numFrames - 1].e2, (PdVector)pdVector);
            if (!pdVector2.normalize()) {
                pdVector2 = PdVector.crossNew((PdVector)this.m_frame[0].e3, (PdVector)pdVector);
                pdVector3 = PdVector.crossNew((PdVector)this.m_frame[this.m_numFrames - 1].e3, (PdVector)pdVector);
            }
            double d2 = PdVector.angleWithOrientation((PdVector)pdVector2, (PdVector)pdVector3, (PdVector)pdVector) / (double)(this.m_numFrames - 1);
            n2 = 1;
            while (n2 < this.m_numFrames) {
                double d3 = Math.cos((double)n2 * d2);
                double d4 = Math.sin((double)n2 * d2);
                PdVector pdVector4 = PdVector.blendNew((double)d3, (PdVector)this.m_frame[n2].e2, (double)(-d4), (PdVector)this.m_frame[n2].e3);
                PdVector pdVector5 = PdVector.blendNew((double)d4, (PdVector)this.m_frame[n2].e2, (double)d3, (PdVector)this.m_frame[n2].e3);
                this.m_frame[n2].e2 = pdVector4;
                this.m_frame[n2].e3 = pdVector5;
                ++n2;
            }
        } else {
            pgFrame.base.copy(pdVectorArray[(this.m_numFrames - 1) % n]);
            this.m_frame[this.m_numFrames - 1].copy(pgFrame);
        }
        return this.m_frame;
    }

    public void setDefThicknessBounds(double d, double d2, double d3, double d4) {
        this.m_defThickBounds[0] = d;
        this.m_defThickBounds[1] = d2;
        this.m_defThickBounds[2] = d3;
        this.m_defThickBounds[3] = d4;
    }

    public void setEnabledStartArrow(boolean bl) {
        this.m_bShowStartArrow = bl;
    }

    public void init() {
        super.init();
        this.m_discr.setDefBounds(this.m_defDiscrBounds[0], this.m_defDiscrBounds[1], this.m_defDiscrBounds[2], this.m_defDiscrBounds[3]);
        this.m_discr.setDefValue(this.m_defDiscr);
        this.m_discr.init();
        this.m_thickness.setDefBounds(this.m_defThickBounds[0], this.m_defThickBounds[1], this.m_defThickBounds[2], this.m_defThickBounds[3]);
        this.m_thickness.setDefValue(this.m_defThick);
        this.m_thickness.init();
        this.m_arrowThickness.setDefBounds(this.m_defArrThickBounds[0], this.m_defArrThickBounds[1], this.m_defArrThickBounds[2], this.m_defArrThickBounds[3]);
        this.m_arrowThickness.setDefValue(this.m_defArrThick);
        this.m_arrowThickness.init();
        this.m_arrowLength.setDefBounds(this.m_defArrLenBounds[0], this.m_defArrLenBounds[1], this.m_defArrLenBounds[2], this.m_defArrLenBounds[3]);
        this.m_arrowLength.setDefValue(this.m_defArrLen);
        this.m_arrowLength.init();
        this.m_bNotDegenerated = new boolean[0];
        if (this.m_polygon != null) {
            this.update(this.m_polygon);
            return;
        }
        if (this.m_elementSet != null) {
            this.update(this.m_elementSet);
            return;
        }
        if (this.m_polygonSet != null) {
            this.update(this.m_polygonSet);
            return;
        }
        this.m_frame = null;
        this.m_numFrames = 0;
    }

    public void setEnabled(boolean bl) {
        if (this.m_bEnabled == bl) {
            return;
        }
        this.m_bEnabled = bl;
        this.m_discr.setEnabled(bl);
        this.m_thickness.setEnabled(bl);
        this.m_arrowThickness.setEnabled(bl);
        this.m_arrowLength.setEnabled(bl);
    }

    public boolean isEnabledArrowPanel() {
        return this.m_bEnabledArrowPanel;
    }

    public boolean isEnabledEndArrow() {
        return this.m_bShowEndArrow;
    }

    private void addArrow(int n, int n2, int n3) {
        if (this.getDimOfElements() != -1) {
            this.setDimOfElements(-1);
        }
        int n4 = this.getNumVertices();
        int n5 = this.m_discr.getValue();
        double d = this.m_thickness.getValue();
        double d2 = d * this.m_arrowThickness.getValue() / 100.0;
        this.setNumVertices(n4 + n5 + 1);
        this.assureVertexNormals();
        int n6 = n4;
        int n7 = n * n5;
        int n8 = 0;
        while (n8 < n5) {
            ((PgPointSet)this).m_vertex[n6].blend(1.0, this.m_frame[n].base, d2, ((PgPointSet)this).m_vertexNormal[n7 + n8]);
            ((PgPointSet)this).m_vertexNormal[n6].copy(((PgPointSet)this).m_vertexNormal[n8]);
            ++n6;
            ++n8;
        }
        ((PgPointSet)this).m_vertex[n6].blend(1.0, this.m_frame[n].base, (double)(n2 * 2) * d2 * this.m_arrowLength.getValue() / 100.0, this.m_frame[n].e1);
        ((PgPointSet)this).m_vertexNormal[n6].copy(this.m_frame[n].base);
        ((PgPointSet)this).m_vertexNormal[n6].multScalar(-1.0);
        n8 = this.getNumElements();
        this.setNumElements(n8 + 2 * n5);
        n6 = n8;
        int n9 = 0;
        while (n9 < n5) {
            this.m_element[n6].setSize(4);
            this.m_element[n6].set(n7 + n9, n7 + (n9 + 1) % n5, n4 + (n9 + 1) % n5, n4 + n9);
            this.m_element[n6 + n5].setSize(3);
            this.m_element[n6 + n5].set(n4 + n9, n4 + (n9 + 1) % n5, n4 + n5);
            if (n2 > 0) {
                this.m_element[n6].invert();
                this.m_element[n6 + n5].invert();
            }
            ++n6;
            ++n9;
        }
        if (this.m_polygonSet != null && this.m_polygonSet.hasPolygonColors() && this.m_bInduceColors) {
            n9 = n8 + 2 * n5 - 1;
            while (n9 >= n8) {
                this.setElementColor(n9, this.m_polygonSet.getPolygonColor(n3));
                --n9;
            }
        }
        if (this.m_polygon != null && this.m_polygon.hasEdgeColors() && this.m_bInduceColors) {
            n9 = n8 + 2 * n5 - 1;
            while (n9 >= n8) {
                this.setElementColor(n9, this.m_polygon.getEdgeColors()[n3]);
                --n9;
            }
        }
    }

    public void generateThickEdges() {
        int n;
        double d;
        Object object;
        Object object2;
        if (this.m_elementSet == null) {
            PsDebug.warning((String)"missing elementSet");
            return;
        }
        PgElementSet pgElementSet = this.m_elementSet;
        if (pgElementSet.getDimOfVertices() != 3) {
            PsDebug.warning((String)"dimension of surface must be 3, no thick edges computed.");
            return;
        }
        int n2 = pgElementSet.getNumElements();
        if (n2 == 0) {
            PsDebug.warning((String)"missing elements in surface, no thick edges computed.");
            return;
        }
        int n3 = pgElementSet.getNumVertices();
        PdVector[] pdVectorArray = pgElementSet.getVertices();
        PiVector[] piVectorArray = pgElementSet.getElements();
        PdVector[] pdVectorArray2 = null;
        if (pgElementSet.hasVertexNormals()) {
            pdVectorArray2 = pgElementSet.getVertexNormals();
        } else {
            pgElementSet.makeVertexNormals();
            pdVectorArray2 = pgElementSet.getVertexNormals();
            pgElementSet.removeVertexNormals();
        }
        double d2 = this.m_thickness.getValue();
        int n4 = this.m_discr.getValue();
        PdVector pdVector = new PdVector(3);
        PdVector pdVector2 = new PdVector(3);
        PdVector pdVector3 = new PdVector(3);
        PdVector pdVector4 = new PdVector(3);
        PdVector pdVector5 = new PdVector(3);
        PdVector pdVector6 = new PdVector(3);
        PdVector pdVector7 = new PdVector(3);
        int n5 = 2 * n3;
        int n6 = 0;
        while (n6 < n2) {
            n5 += n4 * piVectorArray[n6].getSize();
            ++n6;
        }
        this.setNumVertices(n5);
        this.assureVertexNormals();
        n6 = 0;
        while (n6 < n3) {
            object2 = pdVectorArray2[n6];
            object = pdVectorArray[n6];
            ((PgPointSet)this).m_vertexNormal[n6].copyArray((PdVector)object2);
            ((PgPointSet)this).m_vertexNormal[n6 + n3].copyArray((PdVector)object2);
            ((PgPointSet)this).m_vertexNormal[n6 + n3].multScalar(-1.0);
            ((PgPointSet)this).m_vertex[n6].blendBase((PdVector)object, d2, (PdVector)object2);
            ((PgPointSet)this).m_vertex[n6 + n3].blendBase((PdVector)object, -d2, (PdVector)object2);
            ++n6;
        }
        object2 = new double[n4];
        object = new double[n4];
        double d3 = Math.PI / (double)(n4 + 1);
        int n7 = 0;
        while (n7 < n4) {
            d = d3 * (double)(n7 + 1);
            object2[n7] = Math.cos(d);
            object[n7] = Math.sin(d);
            ++n7;
        }
        n5 = 2 * n3;
        int n8 = 0;
        while (n8 < n2) {
            n = piVectorArray[n8].getSize();
            n6 = 0;
            while (n6 < n) {
                int n9 = piVectorArray[n8].m_data[n6];
                int n10 = piVectorArray[n8].m_data[(n6 + 1) % n];
                int n11 = piVectorArray[n8].m_data[(n6 + 2) % n];
                pdVector4.sub(pdVectorArray[n11], pdVectorArray[n10]);
                pdVector4.normalize();
                pdVector5.sub(pdVectorArray[n9], pdVectorArray[n10]);
                pdVector5.normalize();
                pdVector6.cross(pdVector5, pdVector4);
                pdVector6.setLength(1.0);
                d = PdVector.dot((PdVector)pdVectorArray2[n10], (PdVector)pdVector6);
                if (d < 0.0) {
                    pdVector6.multScalar(-1.0);
                    d = -d;
                }
                pdVector7.add(pdVector4, pdVector5);
                double d4 = PdVector.angle((PdVector)pdVector4, (PdVector)pdVector5);
                if (Math.abs(d4) > 179.999) break;
                if (Math.abs(d4) > 1.0E-10) {
                    pdVector7.setLength(1.0 / Math.sin(d4 / 2.0 * Math.PI / 180.0));
                } else {
                    pdVector7.setLength(1.0);
                }
                double d5 = Math.atan(PdVector.dot((PdVector)pdVectorArray2[n10], (PdVector)pdVector7) / d / pdVector7.sqrLength());
                n7 = 0;
                while (n7 < n4) {
                    double d6 = d3 * (double)(n7 + 1);
                    object2[n7] = Math.cos(d5 + d6);
                    object[n7] = Math.sin(d5 + d6);
                    pdVector.blend(object2[n7], pdVector6, object[n7], pdVector7);
                    ((PgPointSet)this).m_vertex[n5].blendBase(pdVectorArray[n10], d2, pdVector);
                    ++n5;
                    ++n7;
                }
                pdVector.blend(Math.cos(d5), pdVector6, Math.sin(d5), pdVector7);
                ((PgPointSet)this).m_vertex[n10].blendBase(pdVectorArray[n10], d2, pdVector);
                ((PgPointSet)this).m_vertex[n10 + n3].blendBase(pdVectorArray[n10], -d2, pdVector);
                ++n6;
            }
            ++n8;
        }
        n5 = 0;
        n6 = 0;
        while (n6 < n2) {
            n5 += (n4 + 1) * piVectorArray[n6].getSize();
            ++n6;
        }
        this.setNumElements(n5);
        this.setDimOfElements(4);
        if (this.m_bInduceColors) {
            this.setGlobalElementBackColor(pgElementSet.getGlobalElementBackColor());
            this.setGlobalElementColor(pgElementSet.getGlobalElementColor());
            if (pgElementSet.hasVertexColors()) {
                Color[] colorArray = new Color[n5];
                n5 = 0;
                n8 = 0;
                while (n8 < n2) {
                    n = piVectorArray[n8].getSize();
                    n6 = 0;
                    while (n6 < n) {
                        n7 = 0;
                        while (n7 < n4 + 1) {
                            colorArray[n5] = PdColor.blend((double)0.5, (Color)pgElementSet.getVertexColor(piVectorArray[n8].m_data[(n6 + 1) % n]), (double)0.5, (Color)pgElementSet.getVertexColor(piVectorArray[n8].m_data[(n6 + 2) % n]));
                            ++n5;
                            ++n7;
                        }
                        ++n6;
                    }
                    ++n8;
                }
                this.setElementColors(colorArray);
                this.showElementColors(true);
            } else if (pgElementSet.hasElementColors()) {
                Color[] colorArray = new Color[n5];
                n5 = 0;
                n8 = 0;
                while (n8 < n2) {
                    n = piVectorArray[n8].getSize();
                    n6 = 0;
                    while (n6 < n) {
                        n7 = 0;
                        while (n7 < n4 + 1) {
                            colorArray[n5] = pgElementSet.getElementColor(n8);
                            ++n5;
                            ++n7;
                        }
                        ++n6;
                    }
                    ++n8;
                }
                this.setElementColors(colorArray);
                this.showElementColors(true);
            }
        }
        n5 = 0;
        int n12 = 2 * n3;
        n8 = 0;
        while (n8 < n2) {
            int n13;
            int n14;
            n = piVectorArray[n8].getSize();
            int n15 = n12;
            n6 = 0;
            while (n6 < n - 1) {
                n14 = piVectorArray[n8].m_data[(n6 + 1) % n];
                n13 = piVectorArray[n8].m_data[(n6 + 2) % n];
                this.m_element[n5].m_data[0] = n14;
                this.m_element[n5].m_data[1] = n13;
                this.m_element[n5].m_data[2] = n12 + n4;
                this.m_element[n5].m_data[3] = n12++;
                ++n5;
                n7 = 0;
                while (n7 < n4 - 1) {
                    this.m_element[n5].m_data[0] = n12 - 1;
                    this.m_element[n5].m_data[1] = n12 + n4 - 1;
                    this.m_element[n5].m_data[2] = n12 + n4;
                    this.m_element[n5].m_data[3] = n12++;
                    ++n5;
                    ++n7;
                }
                this.m_element[n5].m_data[0] = n12 - 1;
                this.m_element[n5].m_data[1] = n12 + n4 - 1;
                this.m_element[n5].m_data[2] = n13 + n3;
                this.m_element[n5].m_data[3] = n14 + n3;
                ++n5;
                ++n6;
            }
            n14 = piVectorArray[n8].m_data[(n6 + 1) % n];
            n13 = piVectorArray[n8].m_data[(n6 + 2) % n];
            this.m_element[n5].m_data[0] = n14;
            this.m_element[n5].m_data[1] = n13;
            this.m_element[n5].m_data[2] = n15++;
            this.m_element[n5].m_data[3] = n12++;
            ++n5;
            n7 = 0;
            while (n7 < n4 - 1) {
                this.m_element[n5].m_data[0] = n12 - 1;
                this.m_element[n5].m_data[1] = n15 - 1;
                this.m_element[n5].m_data[2] = n15++;
                this.m_element[n5].m_data[3] = n12++;
                ++n5;
                ++n7;
            }
            this.m_element[n5].m_data[0] = n12 - 1;
            this.m_element[n5].m_data[1] = n15 - 1;
            this.m_element[n5].m_data[2] = n13 + n3;
            this.m_element[n5].m_data[3] = n14 + n3;
            ++n5;
            ++n8;
        }
        this.makeNeighbour();
        this.makeElementNormals();
        this.makeVertexNormals();
    }

    public PuDouble getArrowThickness() {
        return this.m_arrowThickness;
    }

    public void setArrowThickness(double d) {
        this.m_arrowThickness.setValue(d);
    }
}

