/*
 * Decompiled with CFR 0.152.
 */
package jvx.geom;

import java.awt.Color;
import jv.geom.PgPointSet;
import jv.geom.PgPolygon;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.project.PgGeometry;
import jv.vecmath.PdVector;

public class PgBezierCurve
extends PgPolygon {
    protected int m_degree;
    protected int m_numControlPoints;
    protected PdVector[] m_controlPoint;
    protected boolean m_bShowControlPoints;
    protected boolean m_bShowTaggedControlPoints;
    protected boolean m_bShowControlPolygon;
    protected boolean m_bShowConvexHull;
    protected Color m_globalControlPointColor;
    protected Color m_globalTaggedControlPointColor;
    protected Color m_globalControlPolygonColor;
    private static /* synthetic */ Class class$jvx$geom$PgBezierCurve;

    public void setNumVertices(int n) {
        super.setNumVertices(n);
    }

    public void computeVertices() {
        if (((PgPointSet)this).m_numVertices == 0) {
            return;
        }
        double d = 0.0;
        double d2 = 1.0 / ((double)((PgPointSet)this).m_numVertices - 1.0);
        int n = 0;
        while (n < ((PgPointSet)this).m_numVertices) {
            this.eval(((PgPointSet)this).m_vertex[n], d);
            d += d2;
            ++n;
        }
    }

    public PgBezierCurve(int n) {
        super(n);
        if (((Object)((Object)this)).getClass() == (class$jvx$geom$PgBezierCurve != null ? class$jvx$geom$PgBezierCurve : (class$jvx$geom$PgBezierCurve = PgBezierCurve.class$("jvx.geom.PgBezierCurve")))) {
            this.init();
        }
    }

    protected int getDegree() {
        return this.m_degree;
    }

    protected void setDegree(int n) {
        if (n > this.m_degree) {
            this.setNumControlPoints(n + 1);
        }
    }

    public void addControlPoint(PdVector pdVector) {
        this.setNumControlPoints(this.m_numControlPoints + 1);
        this.setControlPoint(this.m_numControlPoints - 1, pdVector);
    }

    public boolean update(Object object) {
        if (object == null) {
            return super.update(null);
        }
        if (object == this) {
            this.computeVertices();
            return super.update(null);
        }
        return super.update(object);
    }

    public void copy(PsObject psObject) {
        super.copy(psObject);
        if (!(psObject instanceof PgBezierCurve)) {
            return;
        }
        PgBezierCurve pgBezierCurve = (PgBezierCurve)psObject;
        this.setNumControlPoints(pgBezierCurve.getNumControlPoints());
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public int getNumControlPoints() {
        return this.m_numControlPoints;
    }

    public void setNumControlPoints(int n) {
        if (this.m_numControlPoints == n) {
            return;
        }
        this.m_numControlPoints = n;
        this.m_degree = this.m_numControlPoints - 1;
        this.m_controlPoint = PdVector.realloc((PdVector[])this.m_controlPoint, (int)this.m_numControlPoints, (int)((PgGeometry)this).m_dim);
    }

    public void init() {
        super.init();
        this.setNumControlPoints(0);
        this.m_bShowControlPoints = true;
        this.m_bShowTaggedControlPoints = true;
        this.m_bShowControlPolygon = true;
        this.m_bShowConvexHull = false;
        this.m_globalControlPointColor = Color.blue;
        this.m_globalTaggedControlPointColor = Color.magenta;
        this.m_globalControlPolygonColor = Color.blue;
    }

    public PdVector[] getControlPoint() {
        return this.m_controlPoint;
    }

    public void setControlPoint(int n, PdVector pdVector) {
        if (n < 0 || pdVector == null) {
            PsDebug.warning((String)"index out of range, corrupt argument");
            return;
        }
        if (n > this.m_numControlPoints - 1) {
            PsDebug.warning((String)("index=" + n + " > " + (this.m_numControlPoints - 1) + "=m_numControlPoints-1, bad programming style"));
            this.setNumControlPoints(n + 1);
        }
        this.m_controlPoint[n].copy(pdVector);
    }

    public void eval(PdVector pdVector, double d) {
        PdVector[] pdVectorArray = this.m_controlPoint;
        if (pdVectorArray == null) {
            return;
        }
        double d2 = 1.0 - d;
        double d3 = 1.0;
        double d4 = d;
        int n = 0;
        while (n < ((PgGeometry)this).m_dim) {
            pdVector.m_data[n] = pdVectorArray[0].m_data[n] * d2;
            ++n;
        }
        n = 1;
        while (n < this.m_degree) {
            d3 = d3 * (double)(this.m_degree - n + 1) / (double)n;
            int n2 = 0;
            while (n2 < ((PgGeometry)this).m_dim) {
                pdVector.m_data[n2] = (pdVector.m_data[n2] + pdVectorArray[n].m_data[n2] * d3 * d4) * d2;
                ++n2;
            }
            d4 *= d;
            ++n;
        }
        n = 0;
        while (n < ((PgGeometry)this).m_dim) {
            int n3 = n;
            pdVector.m_data[n3] = pdVector.m_data[n3] + pdVectorArray[this.m_degree].m_data[n] * d4;
            ++n;
        }
    }
}

