/*
 * Decompiled with CFR 0.152.
 */
package jv.viewer;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.MenuBar;
import java.awt.Panel;
import java.awt.Point;
import java.awt.PrintJob;
import java.awt.Rectangle;
import java.awt.TextArea;
import java.awt.TextComponent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import jv.anim.PsAnimation;
import jv.anim.PsKeyframe;
import jv.anim.PsTimeListenerIf;
import jv.loader.PSGr;
import jv.loader.PgFileDialog;
import jv.loader.PgLoader;
import jv.loader.PjImportModel;
import jv.loader.PjImportModel_Dialog;
import jv.loader.PsCategoryList_IP;
import jv.loader.PsXmlLoader;
import jv.loader.PvDisplayOption;
import jv.number.PdColor;
import jv.number.PuString;
import jv.object.PsConfig;
import jv.object.PsConsole;
import jv.object.PsDebug;
import jv.object.PsDialog;
import jv.object.PsMainFrame;
import jv.object.PsObject;
import jv.object.PsPanel;
import jv.object.PsStackLayout;
import jv.object.PsUpdateIf;
import jv.object.PsUtil;
import jv.objectGui.PsMultiLineLabel;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.project.PjProject;
import jv.project.PjWorkshopIf;
import jv.project.PvDisplayIf;
import jv.project.PvViewerIf;
import jv.rsrc.PsAuthorInfo;
import jv.rsrc.PsJavaView;
import jv.rsrc.PsJavaView_IP;
import jv.rsrc.PsLicense;
import jv.vecmath.PdVector;
import jv.viewer.PvControl;
import jv.viewer.PvControlMenu;
import jv.viewer.PvDisplay;

public final class PvViewer
extends PsObject
implements PvViewerIf,
ActionListener,
KeyListener,
WindowListener,
Serializable {
    protected PsAuthorInfo m_jvAuthor;
    protected PsJavaView m_jvRsrc;
    protected PsLicense m_jvLic;
    protected Applet m_applet;
    protected Frame m_frame;
    protected String[][] m_parm;
    protected Vector m_displayVector;
    protected PvDisplayIf m_mainDisplay;
    protected PvDisplayIf m_display;
    protected PvControl m_control;
    protected Vector m_menuBars = new Vector();
    protected transient Dialog m_help;
    protected String m_serialDirName = null;
    protected Hashtable m_geometryCategory;
    protected Hashtable m_geometryClass;
    protected Hashtable m_projectCategory;
    protected Hashtable m_projectList;
    protected Hashtable m_projectClass;
    protected Hashtable m_projectParms;
    protected PjProject m_currentProject;
    protected PgGeometryIf m_currentGeometry;
    private int m_showPanel = 21;
    private boolean m_bShowingDialog = false;
    private boolean m_bStarted = false;
    protected Vector m_frameVector;
    protected static boolean m_bHasArchiveJvx = false;
    private PsDialog wsDialogPlatonic = null;
    private PgGeometryIf wsGeometry = null;
    private boolean m_bEmbedded = false;
    private boolean m_bShiftDown = false;

    public boolean showDialog(int n) {
        Serializable serializable;
        Point point;
        PgFileDialog pgFileDialog = null;
        String string = null;
        String string2 = null;
        int[] nArray = PsJavaView.getWindowSize(2);
        int[] nArray2 = PsJavaView.getWindowSize(1);
        int[] nArray3 = PsJavaView.getWindowSize(4);
        int[] nArray4 = PsJavaView.getWindowSize(6);
        if (this.m_control != null && this.m_control.isShowing()) {
            point = this.m_control.getLocation();
            nArray2[0] = point.x;
            nArray2[1] = point.y;
            serializable = this.m_control.getSize();
            nArray2[2] = ((Dimension)serializable).width;
            nArray2[3] = ((Dimension)serializable).height;
        } else {
            point = new Point(nArray2[0], nArray2[1]);
        }
        this.m_bShowingDialog = true;
        switch (n) {
            case 31: {
                serializable = PvViewer.getAboutDialog();
                ((Component)serializable).setLocation(point.x + nArray[0], point.y + nArray[1]);
                ((Component)serializable).setSize(nArray[2], nArray[3]);
                ((Container)serializable).validate();
                ((Dialog)serializable).setModal(true);
                ((Component)serializable).setVisible(true);
                break;
            }
            case 32: {
                Dialog dialog = PvViewer.getAboutAppletDialog();
                ((Component)dialog).setLocation(point.x + nArray[0] + 20, point.y + nArray[1] + 20);
                ((Component)dialog).setSize(nArray[2], nArray[3]);
                dialog.validate();
                dialog.setModal(true);
                ((Component)dialog).setVisible(true);
                break;
            }
            case 30: {
                PsJavaView_IP psJavaView_IP = (PsJavaView_IP)this.m_jvRsrc.getInfoPanel();
                psJavaView_IP.setParent(this.m_jvRsrc);
                psJavaView_IP.update(this.m_jvRsrc);
                PsDialog psDialog = new PsDialog(PsConfig.getFrame(), psJavaView_IP.getDialogTitle(), true);
                psDialog.addActionListener(psJavaView_IP);
                psDialog.setLayout(new BorderLayout());
                psDialog.add((Component)psJavaView_IP, "Center");
                psDialog.add((Component)psDialog.getBottomButtons(psJavaView_IP.getDialogButtons()), "South");
                ((Component)psDialog).setLocation(point.x + nArray2[0] + 20, point.y + nArray2[1] + 20);
                ((Component)psDialog).setSize(psJavaView_IP.getDialogSize());
                psDialog.validate();
                ((Component)psDialog).setVisible(true);
                break;
            }
            case 29: {
                if (this.m_jvLic == null) {
                    this.m_jvLic = new PsLicense();
                }
                this.m_jvLic.showInfoPanel();
                break;
            }
            case 33: {
                Object object;
                PsDialog psDialog = null;
                if (this.m_currentProject != null && this.m_currentProject.hasAnimation()) {
                    psDialog = this.m_currentProject.getAnimation().getAnimationPanel();
                }
                if (psDialog == null && this.m_currentGeometry != null) {
                    PsTimeListenerIf psTimeListenerIf;
                    object = this.m_currentGeometry;
                    while (object != null && !(object instanceof PsTimeListenerIf)) {
                        object = object.getFather();
                    }
                    if (object != null && (psTimeListenerIf = (PsTimeListenerIf)object).hasAnimation()) {
                        psDialog = psTimeListenerIf.getAnimation().getAnimationPanel();
                    }
                }
                if (psDialog == null) {
                    PsDebug.warning("missing animation");
                    this.m_bShowingDialog = false;
                    return false;
                }
                object = PsJavaView.getWindowSize(5);
                ((Component)psDialog).setLocation(point.x, point.y + nArray2[3] - object[3]);
                ((Component)psDialog).setSize((int)object[2], (int)object[3]);
                ((Component)psDialog).setVisible(true);
                break;
            }
            case 35: {
                boolean bl = PsDebug.hasConsole();
                PsConsole psConsole = PsDebug.getConsole();
                if (psConsole == null) {
                    PsDebug.error("missing console panel", this);
                    this.m_bShowingDialog = false;
                    return false;
                }
                if (!bl) {
                    ((Component)psConsole).setLocation(nArray3[0], nArray3[1]);
                    ((Component)psConsole).setSize(nArray3[2], nArray3[3]);
                }
                ((Component)psConsole).setVisible(true);
                break;
            }
            case 34: {
                if (this.m_control == null) {
                    this.m_control = this.getControl();
                    if (this.m_control == null) {
                        PsDebug.warning("missing control panel");
                        this.m_bShowingDialog = false;
                        return false;
                    }
                }
                this.m_control.setVisible(true);
                this.m_control.requestFocus();
                break;
            }
            case 36: {
                if (!PsConfig.isApplication() && this.m_applet != null) {
                    try {
                        URL uRL = new URL(PsConfig.getCodeBase() + "jars/help.html");
                        uRL.openConnection();
                        uRL.openStream();
                        this.m_applet.getAppletContext().showDocument(uRL, "Help on Viewer");
                        break;
                    }
                    catch (Exception exception) {
                        PsDebug.warning("file not found = " + "jars/help.html");
                    }
                }
                if (this.m_help == null) {
                    this.m_help = PvViewer.getHelpDialog();
                }
                ((Component)this.m_help).setLocation(point.x + nArray3[2] / 2, point.y + nArray3[3] / 5);
                int[] nArray5 = PsJavaView.getWindowSize(3);
                ((Component)this.m_help).setSize(nArray5[2], nArray5[3]);
                ((Component)this.m_help).setVisible(true);
                break;
            }
            case 37: {
                String[] stringArray = PvViewer.getCategories(this.m_projectCategory);
                String[][] stringArray2 = PvViewer.getEntries(this.m_projectCategory, stringArray);
                if (stringArray2 == null) {
                    PsDebug.warning("no registered projects");
                    break;
                }
                PsCategoryList_IP psCategoryList_IP = new PsCategoryList_IP();
                psCategoryList_IP.addProjectCheckboxes();
                psCategoryList_IP.setCategories(stringArray, stringArray2);
                psCategoryList_IP.setTitle(PsConfig.getMessage(24312));
                PsDialog psDialog = new PsDialog(PsConfig.getFrame(), PsConfig.getMessage(24311), true);
                psDialog.setLayout(new BorderLayout());
                psDialog.add((Component)psCategoryList_IP, "Center");
                psDialog.add((Component)psDialog.getBottomButtons(5), "South");
                ((Component)psDialog).setLocation(point.x + nArray4[0], point.y + nArray4[1]);
                ((Component)psDialog).setSize(nArray4[2], nArray4[3]);
                psDialog.validate();
                ((Component)psDialog).setVisible(true);
                int n2 = psDialog.getUserAction();
                if (n2 != 4) {
                    this.m_bShowingDialog = false;
                    return false;
                }
                String string3 = psCategoryList_IP.getSelectedEntry();
                if (PuString.isEmpty(string3)) {
                    this.m_bShowingDialog = false;
                    return false;
                }
                if (psCategoryList_IP.isClosing()) {
                    this.reset();
                }
                if (!this.selectProject(string3)) {
                    this.m_bShowingDialog = false;
                    return false;
                }
                if (!PsConfig.isApplication()) break;
                Enumeration enumeration = this.m_frameVector.elements();
                while (enumeration.hasMoreElements()) {
                    Frame frame = (Frame)enumeration.nextElement();
                    PvDisplayIf pvDisplayIf = this.getDisplayOfFrame(frame);
                    if (pvDisplayIf == null || pvDisplayIf != this.m_mainDisplay) continue;
                    frame.setTitle(PsConfig.getProgram() + " v" + PsConfig.getVersion() + ": " + this.m_currentProject.getName());
                }
                break;
            }
            case 39: 
            case 40: {
                String[] stringArray = PvViewer.getCategories(this.m_geometryCategory);
                String[][] stringArray3 = PvViewer.getEntries(this.m_geometryCategory, stringArray);
                if (stringArray3 == null) {
                    PsDebug.warning("no registered geometrys");
                    break;
                }
                PsCategoryList_IP psCategoryList_IP = new PsCategoryList_IP();
                psCategoryList_IP.addProjectCheckboxes();
                psCategoryList_IP.setCategories(stringArray, stringArray3);
                psCategoryList_IP.setTitle(PsConfig.getMessage(24316));
                PsDialog psDialog = new PsDialog(PsConfig.getFrame(), PsConfig.getMessage(24315), true);
                psDialog.setLayout(new BorderLayout());
                psDialog.add((Component)psCategoryList_IP, "Center");
                psDialog.add((Component)psDialog.getBottomButtons(5), "South");
                ((Component)psDialog).setLocation(point.x + nArray4[0], point.y + nArray4[1]);
                ((Component)psDialog).setSize(nArray4[2], nArray4[3]);
                psDialog.validate();
                ((Component)psDialog).setVisible(true);
                int n3 = psDialog.getUserAction();
                if (n3 != 4) {
                    this.m_bShowingDialog = false;
                    return false;
                }
                String string4 = psCategoryList_IP.getSelectedEntry();
                if (PuString.isEmpty(string4)) {
                    this.m_bShowingDialog = false;
                    return false;
                }
                PgGeometryIf pgGeometryIf = this.getGeometry(string4);
                if (pgGeometryIf == null) {
                    PsDebug.warning("failed to create geometry.");
                    this.m_bShowingDialog = false;
                    return false;
                }
                if (this.m_display == null) {
                    PsDebug.warning("missing display.");
                    this.newDisplay(pgGeometryIf.getName());
                }
                if (psCategoryList_IP.isClosing()) {
                    this.reset();
                }
                if (this.m_currentProject != null) {
                    this.m_currentProject.setParent(pgGeometryIf);
                    this.m_currentProject.addGeometry(pgGeometryIf);
                }
                this.m_display.addGeometry(pgGeometryIf);
                this.m_display.selectGeometry(pgGeometryIf);
                pgGeometryIf.update(pgGeometryIf);
                if (psCategoryList_IP.isClosing()) {
                    this.m_display.fit();
                }
                if (!((PgGeometry)pgGeometryIf).hasTag(7)) break;
                this.showPanel(16);
                break;
            }
            case 41: {
                PjImportModel pjImportModel = new PjImportModel();
                pjImportModel.setVisibleReplaceChoice(true);
                PjImportModel_Dialog pjImportModel_Dialog = new PjImportModel_Dialog(PsConfig.getFrame());
                ((PsDialog)pjImportModel_Dialog).setParent(pjImportModel);
                ((PsDialog)pjImportModel_Dialog).update(pjImportModel);
                int[] nArray6 = PsJavaView.getWindowSize(7);
                ((Component)pjImportModel_Dialog).setLocation(point.x + nArray6[0], point.y + nArray6[1]);
                ((Component)pjImportModel_Dialog).setSize(nArray6[2], nArray6[3]);
                if (this.m_currentProject != null) {
                    pjImportModel.setParentProject(this.m_currentProject);
                    ((Component)pjImportModel_Dialog).setVisible(true);
                    if (pjImportModel_Dialog.getUserAction() != 0) break;
                    PsJavaView.setFullFileName(4, pjImportModel.getFileName());
                    break;
                }
                if (this.m_display == null || pjImportModel.getGeometry() == null) {
                    PsDebug.warning("no project or display available to add geometry.");
                    this.m_bShowingDialog = false;
                    return false;
                }
                PgGeometryIf[] pgGeometryIfArray = this.m_display.getGeometries();
                pjImportModel_Dialog.setModal(true);
                pjImportModel.setDisplay(this.m_display);
                ((Component)pjImportModel_Dialog).setVisible(true);
                if (pjImportModel.getConfirm() == 0) {
                    PsTimeListenerIf psTimeListenerIf;
                    this.m_display.selectGeometry(pjImportModel.getGeometry(0));
                    PsUpdateIf psUpdateIf = pjImportModel.getGeometry(0);
                    while (psUpdateIf != null && !(psUpdateIf instanceof PsTimeListenerIf)) {
                        psUpdateIf = psUpdateIf.getFather();
                    }
                    if (psUpdateIf != null && (psTimeListenerIf = (PsTimeListenerIf)((Object)psUpdateIf)).hasAnimation()) {
                        this.setEnabledMenu(40, true);
                    }
                    if (pjImportModel.isEnabledRemoveGeometry() && pgGeometryIfArray != null) {
                        int n4 = 0;
                        while (n4 < pgGeometryIfArray.length) {
                            this.m_display.removeGeometry(pgGeometryIfArray[n4]);
                            ++n4;
                        }
                        this.m_display.fit();
                    }
                    PsJavaView.setFullFileName(4, pjImportModel.getFileName());
                } else {
                    pjImportModel.removeGeometries();
                }
                PsConfig.runGC();
                pjImportModel.removeDisplay(this.m_display);
                this.m_display.update(this.m_display);
                break;
            }
            case 42: 
            case 412: {
                Object object;
                string2 = n == 412 ? "jvd" : "*";
                pgFileDialog = new PgFileDialog(PsConfig.getFrame(), PsConfig.getMessage(24113), 0);
                pgFileDialog.setDirectory(PsJavaView.getDirectory(4));
                pgFileDialog.setExtension(string2);
                pgFileDialog.show();
                if (!pgFileDialog.isFileSelected()) break;
                string = pgFileDialog.getFullFileName();
                if (string.endsWith("jvd")) {
                    PgLoader pgLoader = new PgLoader();
                    PvDisplayOption[] pvDisplayOptionArray = pgLoader.loadDisplay(string);
                    if (pvDisplayOptionArray == null) {
                        PsDebug.warning("error when reading file = " + string);
                        break;
                    }
                    PsJavaView.setFullFileName(4, string);
                    if (this.m_display == null) break;
                    pvDisplayOptionArray[0].configure(this.m_display);
                    this.m_display.update(this.m_display);
                    break;
                }
                PjImportModel pjImportModel = new PjImportModel();
                pjImportModel.removeGeometries();
                if (this.m_currentProject != null) {
                    pjImportModel.setParentProject(this.m_currentProject);
                }
                if (this.m_bShiftDown) {
                    pjImportModel.setEnabledLoadCamera(true);
                }
                boolean bl = pjImportModel.load(string);
                PvDisplayOption[] pvDisplayOptionArray = null;
                if (bl) {
                    PsJavaView.setFullFileName(4, string);
                    if (this.m_bShiftDown) {
                        String string5;
                        if (pjImportModel.getDisplayOption() != null) {
                            pvDisplayOptionArray = pjImportModel.getDisplayOption();
                        }
                        if (pvDisplayOptionArray == null && (pvDisplayOptionArray = ((PgLoader)(object = new PgLoader())).loadDisplay(string5 = PsUtil.getFilePathAndBaseName(string) + ".jvd")) == null) {
                            PsDebug.warning("error when reading file = " + string5);
                        }
                    }
                }
                if (bl && this.m_display != null) {
                    int n5 = pjImportModel.getNumGeometries();
                    if (this.m_currentProject == null) {
                        int n6 = 0;
                        while (n6 < n5) {
                            this.m_display.addGeometry(pjImportModel.getGeometry(n6));
                            ++n6;
                        }
                        if (n5 != 0) {
                            this.m_display.selectGeometry(pjImportModel.getGeometry(0));
                        }
                    }
                    if (!this.m_bShiftDown && this.m_display.getNumGeometries() == 1) {
                        this.m_display.fit();
                    } else if (pvDisplayOptionArray != null) {
                        pvDisplayOptionArray[0].configure(this.m_display);
                    }
                    this.m_display.update(this.m_display);
                    if (n5 > 0) {
                        PsTimeListenerIf psTimeListenerIf;
                        object = pjImportModel.getGeometry(0);
                        while (object != null && !(object instanceof PsTimeListenerIf)) {
                            object = object.getFather();
                        }
                        if (object != null && (psTimeListenerIf = (PsTimeListenerIf)object).hasAnimation()) {
                            this.setEnabledMenu(40, true);
                        }
                    }
                }
                pjImportModel = null;
                PsConfig.runGC();
                break;
            }
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 59: 
            case 60: {
                string2 = n == 43 ? "byu" : (n == 44 ? "fe" : (n == 45 ? "jvx" : (n == 46 ? "mgs" : (n == 47 ? "mpl" : (n == 48 ? "obj" : (n == 49 ? "off" : (n == 50 ? "stl" : (n == 51 ? "wrl" : (n == 59 ? "jvd" : (n == 60 ? "html" : "jvx"))))))))));
                if (PsConfig.isApplication()) {
                    pgFileDialog = new PgFileDialog(PsConfig.getFrame(), PsConfig.getMessage(24141), 1);
                    pgFileDialog.setDirectory(PsJavaView.getDirectory(4));
                    pgFileDialog.setExtension(string2);
                    pgFileDialog.show();
                    string = pgFileDialog.getFullFileName();
                    if (string == null) {
                        this.m_bShowingDialog = false;
                        return false;
                    }
                }
                if (string == null) {
                    string = "javaview." + string2;
                }
                if (!this.export(n, string) || !PsConfig.isApplication()) break;
                PsJavaView.setFullFileName(4, string);
                if (n != 60) break;
                try {
                    String string6 = pgFileDialog.getDirectory();
                    String string7 = string6 + "jars" + PsConfig.getFileSeparator() + "javaview.jar";
                    File file = new File(string7);
                    if (!file.exists()) {
                        if (PsConfig.getOSId() == 0) {
                            Runtime runtime = Runtime.getRuntime();
                            runtime.exec("mkdir " + string6 + "jars");
                            Thread.sleep(500L);
                            runtime.exec("xcopy /Y " + PsConfig.getCodeBase() + "\\jars\\javaview.jar " + string6 + "\\jars");
                            Thread.sleep(500L);
                        } else if (PsConfig.getOSId() == 3 || PsConfig.getOSId() == 2 || PsConfig.getOSId() == 1) {
                            Runtime runtime = Runtime.getRuntime();
                            runtime.exec("mkdir " + string6 + "jars");
                            Thread.sleep(500L);
                            runtime.exec("cp -r " + PsConfig.getCodeBase() + "/jars " + string6);
                            Thread.sleep(500L);
                        } else {
                            PsDebug.warning("Must assure existence of JavaView archive: " + string7);
                        }
                    }
                    if (file.exists()) {
                        PsDebug.message("JavaView archive copied to HTML destination: " + string7, true);
                        break;
                    }
                    PsDebug.message("Failed to copy JavaView archive to HTML destination: " + string7, true);
                }
                catch (IOException iOException) {
                    PsDebug.warning("failed to copy JavaView jar archives to HTML destination. Must copy by hand.");
                }
                catch (SecurityException securityException) {
                    PsDebug.warning("failed to copy JavaView jar archives to HTML destination. Must copy by hand.");
                }
                catch (InterruptedException interruptedException) {}
                break;
            }
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                if (!PsConfig.isApplication()) {
                    PsDebug.warning("cannot export image in applet mode.");
                    this.m_bShowingDialog = false;
                    return false;
                }
            }
            case 57: 
            case 58: {
                string2 = n == 52 ? "gif" : (n == 53 ? "001.gif" : (n == 54 ? "ppm" : (n == 55 ? "001.ppm" : (n == 58 ? "ps" : (n == 57 ? "eps" : "ppm")))));
                if (PsConfig.isApplication()) {
                    pgFileDialog = new PgFileDialog(PsConfig.getFrame(), PsConfig.getMessage(24319), 1);
                    pgFileDialog.setDirectory(PsJavaView.getDirectory(5));
                    pgFileDialog.setExtension(string2);
                    pgFileDialog.show();
                    string = pgFileDialog.getFullFileName();
                    if (string == null) {
                        this.m_bShowingDialog = false;
                        return false;
                    }
                }
                if (string == null) {
                    string = "javaview." + string2;
                }
                if (n != 53 && n != 55) {
                    boolean bl = this.export(n, string);
                    if (bl && PsConfig.isApplication()) {
                        PsJavaView.setFullFileName(5, string);
                    }
                    this.m_bShowingDialog = false;
                    return bl;
                }
                PsAnimation psAnimation = null;
                if (this.m_currentProject != null && this.m_currentProject.hasAnimation()) {
                    psAnimation = this.m_currentProject.getAnimation();
                }
                if (psAnimation == null && this.m_currentGeometry != null) {
                    PsUpdateIf psUpdateIf = this.m_currentGeometry;
                    while (psUpdateIf != null && !(psUpdateIf instanceof PsTimeListenerIf)) {
                        psUpdateIf = psUpdateIf.getFather();
                    }
                    if (psUpdateIf != null) {
                        PsTimeListenerIf psTimeListenerIf = (PsTimeListenerIf)((Object)psUpdateIf);
                        psAnimation = psTimeListenerIf.getAnimation();
                    }
                }
                if (psAnimation != null && psAnimation.isRunning()) {
                    psAnimation.stop();
                }
                double d = 0.0;
                double d2 = 1.0;
                int n7 = 100;
                if (psAnimation != null) {
                    double d3 = psAnimation.getMinTime();
                    double d4 = psAnimation.getMaxTime();
                    d2 = psAnimation.getTimePageIncr();
                    d = d3;
                    n7 = 1 + (int)((d4 - d3) / d2);
                    if (n7 > 999) {
                        PsDebug.warning("too many images, 999 < num = " + n7);
                        this.m_bShowingDialog = false;
                        return false;
                    }
                } else if (this.m_display == null) {
                    PsDebug.warning("missing display");
                    this.m_bShowingDialog = false;
                    return false;
                }
                string2 = n == 53 ? "gif" : "ppm";
                String string8 = PsUtil.getFileBaseName(string);
                if (string8.endsWith("001")) {
                    string8 = PsUtil.getFileBaseName(string8);
                }
                String string9 = PsUtil.getFilePath(string);
                string8 = string9 + string8;
                int n8 = 0;
                while (n8 < n7) {
                    if (psAnimation != null) {
                        psAnimation.setTime(d);
                        d += d2;
                    } else if (this.m_display != null) {
                        this.m_display.incrementAutoRotation();
                    }
                    string = n8 < 9 ? string8 + ".00" + (n8 + 1) + "." + string2 : (n8 < 99 ? string8 + ".0" + (n8 + 1) + "." + string2 : string8 + "." + (n8 + 1) + "." + string2);
                    if (!this.export(n, string)) {
                        PsDebug.warning("error during animation export.");
                        this.m_bShowingDialog = false;
                        return false;
                    }
                    ++n8;
                }
                if (!PsConfig.isApplication()) break;
                PsJavaView.setFullFileName(5, string);
                break;
            }
            case 70: {
                this.export(n, null);
                break;
            }
            default: {
                PsDebug.warning("invalid dialog index = " + n);
                this.m_bShowingDialog = false;
                return false;
            }
        }
        this.m_bShowingDialog = false;
        return true;
    }

    public PsDialog getDialog(int n) {
        switch (n) {
            case 33: {
                PsDialog psDialog = null;
                if (this.m_currentProject != null && this.m_currentProject.getAnimation() != null) {
                    psDialog = this.m_currentProject.getAnimation().getAnimationPanel();
                }
                return psDialog;
            }
            case 35: {
                return PsDebug.getConsole();
            }
        }
        PsDebug.warning("invalid dialog index = " + n);
        return null;
    }

    private static String[][] getEntries(Hashtable hashtable, String[] stringArray) {
        if (hashtable == null || stringArray == null) {
            return null;
        }
        int n = stringArray.length;
        String[][] stringArray2 = new String[n][];
        int n2 = hashtable.size();
        int n3 = 0;
        while (n3 < n) {
            String[] stringArray3 = new String[n2];
            int n4 = 0;
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = (String)hashtable.get(string);
                if (!string2.equals(stringArray[n3]) || string.startsWith("jvx") && !PsConfig.hasArchive(1)) continue;
                stringArray3[n4++] = string;
            }
            stringArray2[n3] = new String[n4];
            if (n4 != 0) {
                int n5 = 0;
                while (n5 < n4) {
                    stringArray2[n3][n5] = stringArray3[n5];
                    ++n5;
                }
                PuString.sort(stringArray2[n3]);
            }
            ++n3;
        }
        return stringArray2;
    }

    private int getNumDisplays() {
        if (this.m_displayVector == null) {
            return 0;
        }
        return this.m_displayVector.size();
    }

    protected static Dialog getAboutDialog() {
        PsDialog psDialog = new PsDialog(PsConfig.getFrame(), PsConfig.getMessage(24318) + " " + PsConfig.getProgram(), true);
        psDialog.setLayout(new BorderLayout());
        Panel panel = new Panel(new PsStackLayout(2));
        Component component = new Label("\u00a9  " + PsConfig.getProgram() + " - " + PsConfig.getMessage(12016) + " " + PsConfig.getVersion(), 1);
        component.setFont(PsConfig.getFont(3));
        panel.add(component);
        Component component2 = new PsMultiLineLabel();
        ((PsMultiLineLabel)component2).setText(PsConfig.getHomepage() + "\n" + PsConfig.getEmail() + "\n\n\n");
        ((PsMultiLineLabel)component2).setAlignment(1);
        panel.add(component2);
        psDialog.add((Component)panel, "North");
        component = new PsPanel(new BorderLayout());
        ((PsPanel)component).setInsetSizeHorizontal(5);
        component2 = new Panel(new PsStackLayout(2));
        Component component3 = new Label(PsConfig.getMessage(12017), 1);
        component3.setFont(PsConfig.getFont(3));
        ((Container)component2).add(component3);
        String[] stringArray = new Panel(new GridLayout(2, 2));
        int n = 0;
        while (n < PsConfig.AUTHOR.length) {
            stringArray.add(new Label(PsConfig.AUTHOR[n], 1));
            ++n;
        }
        ((Container)component2).add((Component)stringArray);
        ((Container)component2).add(new Label(""));
        Label label = new Label(PsConfig.getMessage(12018), 1);
        label.setFont(PsConfig.getFont(3));
        ((Container)component2).add(label);
        ((Container)component).add(component2, "North");
        component3 = new TextArea("", 10, 80);
        ((TextComponent)component3).setEditable(false);
        stringArray = PsConfig.getContributors();
        if (stringArray != null) {
            int n2 = 0;
            while (n2 < stringArray.length) {
                ((TextArea)component3).append(stringArray[n2] + "\n");
                ++n2;
            }
        }
        ((Container)component).add(component3, "Center");
        psDialog.add(component, "Center");
        psDialog.add((Component)psDialog.getBottomButtons(2), "South");
        psDialog.pack();
        return psDialog;
    }

    public boolean hideDialog(int n) {
        switch (n) {
            case 33: {
                Component component = null;
                if (this.m_currentProject != null && this.m_currentProject.getAnimation() != null) {
                    component = this.m_currentProject.getAnimation().getAnimationPanel();
                }
                if (component == null) {
                    return true;
                }
                component.setVisible(false);
                return true;
            }
            case 35: {
                if (PsDebug.hasConsole()) {
                    ((Component)PsDebug.getConsole()).setVisible(false);
                }
                return true;
            }
            case 34: {
                if (this.m_control != null) {
                    this.m_control.setVisible(false);
                }
                return true;
            }
            case 36: {
                if (this.m_help != null) {
                    ((Component)this.m_help).setVisible(false);
                }
                return true;
            }
        }
        return false;
    }

    protected static Dialog getAboutAppletDialog() {
        PsDialog psDialog = new PsDialog(PsConfig.getFrame(), PsConfig.getMessage(24317), true);
        psDialog.setLayout(new BorderLayout());
        Panel panel = new Panel(new GridLayout(4, 1));
        Object object = new Label("\u00a9  " + PsConfig.getProgram() + " " + PsConfig.getMessage(13002), 1);
        ((Component)object).setFont(PsConfig.getFont(3));
        panel.add((Component)object);
        object = new Label(PsConfig.getProject(), 1);
        ((Component)object).setFont(PsConfig.getFont(3));
        panel.add((Component)object);
        Component component = new Label(PsConfig.getMessage(12016) + " " + PsConfig.getVersion(), 1);
        panel.add(component);
        panel.add(new Label("", 1));
        psDialog.add((Component)panel, "North");
        object = null;
        if (PsConfig.getApplet() != null) {
            object = PsConfig.getApplet().getAppletInfo();
        }
        if (object == null) {
            PsDebug.warning("missing applet info");
            object = PsConfig.getMessage(28006);
        }
        if (object != null) {
            object = ((String)object).replace('\r', ' ');
        }
        component = new PsMultiLineLabel((String)object);
        PsPanel psPanel = new PsPanel();
        psPanel.setInsetSizeHorizontal(5);
        psPanel.add(component);
        psDialog.add((Component)psPanel, "Center");
        psDialog.add((Component)psDialog.getBottomButtons(2), "South");
        psDialog.pack();
        return psDialog;
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 17 || n == 16 || n == 18) {
            return;
        }
        if (keyEvent.isAltDown()) {
            return;
        }
        switch (n) {
            case 112: {
                this.showDialog(34);
                return;
            }
            case 113: {
                this.hideDialog(34);
                return;
            }
            case 114: {
                this.showDialog(35);
                return;
            }
            case 115: {
                this.showDialog(33);
                return;
            }
        }
        if (!keyEvent.isControlDown()) {
            return;
        }
        if (n == 89 && keyEvent.isShiftDown()) {
            this.reset();
            return;
        }
        if (n == 88 && keyEvent.isShiftDown()) {
            block52: {
                if (!PsConfig.isApplication()) {
                    this.destroy();
                    return;
                }
                try {
                    this.destroy();
                    if (!this.isEmbedded()) {
                        System.exit(0);
                        return;
                    }
                }
                catch (Exception exception) {
                    if (this.isEmbedded()) break block52;
                    System.exit(0);
                }
            }
            return;
        }
        this.m_bShiftDown = keyEvent.isShiftDown();
        switch (n) {
            case 65: {
                this.showDialog(33);
                return;
            }
            case 66: {
                if (!this.isEnabledPanel(17)) break;
                this.showPanel(17);
                this.showDialog(34);
                return;
            }
            case 67: {
                this.showPanel(20);
                this.showDialog(34);
                return;
            }
            case 68: {
                this.showDialog(35);
                return;
            }
            case 69: {
                if (!this.isEnabledPanel(15)) break;
                this.showPanel(15);
                this.showDialog(34);
                return;
            }
            case 70: {
                if (!this.isEnabledPanel(16)) break;
                this.showPanel(16);
                this.showDialog(34);
                return;
            }
            case 73: {
                if (!this.isEnabledPanel(12)) break;
                this.showPanel(12);
                this.showDialog(34);
                return;
            }
            case 75: {
                if (this.m_currentGeometry == null) break;
                PsKeyframe psKeyframe = null;
                PgGeometry pgGeometry = (PgGeometry)this.m_currentGeometry;
                PsUpdateIf psUpdateIf = pgGeometry.getFather();
                if (psUpdateIf == null || !(psUpdateIf instanceof PsKeyframe)) {
                    psKeyframe = new PsKeyframe();
                    psKeyframe.setTime(0.0);
                    psKeyframe.addKey((PgGeometry)pgGeometry.clone(), 0.0);
                    psKeyframe.setDynamic(pgGeometry);
                    String string = PsConfig.getMessage(15043) + " " + pgGeometry.getName();
                    if (this.m_currentProject == null) {
                        this.addProject(new PjProject(string));
                        this.selectProject(string);
                    }
                    this.m_currentProject.addGeometry(psKeyframe);
                    PsAnimation psAnimation = null;
                    if (this.m_currentProject.hasAnimation()) {
                        psAnimation = this.m_currentProject.getAnimation();
                    } else {
                        psAnimation = new PsAnimation();
                        psAnimation.setName(string);
                        this.m_currentProject.setAnimation(psAnimation);
                        this.setEnabledMenu(40, true);
                    }
                    psAnimation.addTimeListener(psKeyframe);
                    psAnimation.enableKeys(true);
                    this.showDialog(33);
                    return;
                }
                psKeyframe = (PsKeyframe)psUpdateIf;
                psKeyframe.addKey((PgGeometry)pgGeometry.clone(), psKeyframe.getAnimation().getTime());
                return;
            }
            case 76: {
                this.showPanel(18);
                this.showDialog(34);
                return;
            }
            case 77: {
                if (!this.isEnabledPanel(13)) break;
                this.showPanel(13);
                this.showDialog(34);
                return;
            }
            case 78: {
                if (keyEvent.isShiftDown()) {
                    String string = PsJavaView.getFullFileName(4);
                    if (string == null) {
                        PsDebug.warning("missing recent geometry file");
                        return;
                    }
                    PvDisplayOption[] pvDisplayOptionArray = null;
                    PgLoader pgLoader = new PgLoader();
                    String string2 = PsUtil.getFilePathAndBaseName(string) + ".jvd";
                    pvDisplayOptionArray = pgLoader.loadDisplay(string2);
                    if (pvDisplayOptionArray == null) {
                        PsDebug.warning("error when reading file = " + string2);
                        return;
                    }
                    if (this.m_display == null) break;
                    pvDisplayOptionArray[0].configure(this.m_display);
                    this.m_display.update(this.m_display);
                    return;
                }
                this.showDialog(39);
                return;
            }
            case 79: {
                if (PsConfig.isApplication()) {
                    this.showDialog(42);
                    return;
                }
                this.showDialog(41);
                return;
            }
            case 80: {
                if (keyEvent.isShiftDown() && this.m_control != null) {
                    this.m_control.releasePanel(10);
                    return;
                }
                if (!this.isEnabledPanel(10)) break;
                this.showPanel(10);
                this.showDialog(34);
                return;
            }
            case 82: {
                String string = PsJavaView.getFullFileName(4);
                if (string == null) {
                    PsDebug.warning("missing recent geometry file");
                    return;
                }
                PgLoader pgLoader = new PgLoader();
                PgGeometry[] pgGeometryArray = pgLoader.loadGeometry((PgGeometry[])null, string);
                if (pgGeometryArray == null || pgGeometryArray.length == 0 || pgGeometryArray[0] == null) {
                    PsDebug.warning("loading failed of recent file = " + string);
                    return;
                }
                this.m_display.removeGeometries();
                int n2 = 0;
                while (n2 < pgGeometryArray.length) {
                    this.m_display.addGeometry(pgGeometryArray[n2]);
                    ++n2;
                }
                if (this.m_frame != null) {
                    this.m_frame.setTitle(PsConfig.getProgram() + " v" + PsConfig.getVersion() + ": " + string);
                }
                this.m_display.update(this.m_display);
                return;
            }
            case 83: {
                if (this.saveFiles()) break;
                this.showDialog(45);
                return;
            }
            case 84: {
                if (!this.isEnabledPanel(14)) break;
                this.showPanel(14);
                this.showDialog(34);
                return;
            }
            case 85: {
                if (this.burnTexture()) break;
                this.showDialog(45);
                return;
            }
            case 86: {
                if (!this.isEnabledPanel(21)) break;
                this.showPanel(21);
                this.showDialog(34);
                return;
            }
            case 88: {
                if (!this.isEnabledPanel(19)) break;
                this.showPanel(19);
                this.showDialog(34);
                return;
            }
            case 49: {
                if (!this.isEnabledPanel(22)) break;
                this.showPanel(22);
                this.showDialog(34);
                return;
            }
            case 50: {
                if (!this.isEnabledPanel(23)) break;
                this.showPanel(23);
                this.showDialog(34);
                return;
            }
            case 51: {
                if (!this.isEnabledPanel(24)) break;
                this.showPanel(24);
                this.showDialog(34);
                return;
            }
            default: {
                return;
            }
        }
    }

    private PvDisplayIf getDisplayOfFrame(Frame frame) {
        Component[] componentArray = frame.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n] instanceof PvDisplayIf) {
                return (PvDisplayIf)((Object)componentArray[n]);
            }
            if (componentArray[n] instanceof Applet) {
                Component[] componentArray2 = ((Applet)componentArray[n]).getComponents();
                int n2 = 0;
                while (n2 < componentArray2.length) {
                    if (componentArray2[n2] instanceof PvDisplayIf) {
                        return (PvDisplayIf)((Object)componentArray2[n2]);
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return null;
    }

    private static final void setAutoFocus(PvDisplayIf pvDisplayIf, boolean bl, boolean bl2) {
        if (pvDisplayIf == null) {
            return;
        }
        pvDisplayIf.setPaintTag(0x20000000L, bl2);
        ((PvDisplay)pvDisplayIf).repaint();
    }

    public boolean hasProject(String string) {
        return this.m_projectList.containsKey(string);
    }

    public boolean removeProject(String string) {
        if (string == null) {
            PsDebug.warning("missing project name");
            return false;
        }
        if (this.m_currentProject == null) {
            return false;
        }
        PjProject pjProject = this.getProject(string);
        if (pjProject == null) {
            PsDebug.warning("missing project = " + string);
            return false;
        }
        return this.removeProject(pjProject);
    }

    public boolean removeProject(PjProject pjProject) {
        if (pjProject == null) {
            return true;
        }
        if (this.m_currentProject == pjProject) {
            if (this.m_control != null) {
                this.m_control.setProject(null);
            }
            this.m_currentProject = null;
            this.setEnabledMenu(21, false);
            this.setEnabledMenu(40, false);
        }
        if (this.m_projectList.contains(pjProject)) {
            Enumeration enumeration = this.m_projectList.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (this.m_projectList.get(string) != pjProject) continue;
                this.m_projectList.remove(string);
                break;
            }
        }
        return true;
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
        if (!(windowEvent.getSource() instanceof Frame)) {
            return;
        }
        Frame frame = (Frame)windowEvent.getSource();
        if (frame == this.m_control || this.m_bShowingDialog) {
            return;
        }
        PvDisplayIf pvDisplayIf = this.getDisplayOfFrame(frame);
        if (pvDisplayIf == null) {
            return;
        }
        if (this.m_display != pvDisplayIf && this.hasDisplay(pvDisplayIf) && pvDisplayIf.hasPaintTag(0x10000000L)) {
            this.selectDisplay(pvDisplayIf);
        }
    }

    protected void setEnabledMenu(int n, boolean bl) {
        if (this.m_menuBars == null || this.m_menuBars.size() == 0) {
            return;
        }
        Enumeration enumeration = this.m_menuBars.elements();
        while (enumeration.hasMoreElements()) {
            PvControlMenu pvControlMenu = (PvControlMenu)enumeration.nextElement();
            pvControlMenu.setEnabledMenu(n, bl);
            if (this.m_currentGeometry == null || n != 3) continue;
            if (bl) {
                this.m_currentGeometry.fillMethodMenu(pvControlMenu.m_mMethod, this);
                continue;
            }
            this.m_currentGeometry.removeMethodMenus();
        }
    }

    protected boolean saveFiles() {
        if (!PsConfig.hasArchive(1)) {
            PsDebug.warning("missing archive jvx.jar");
            return false;
        }
        PjWorkshopIf pjWorkshopIf = (PjWorkshopIf)PsUtil.newInstance("jvx.loader.PsExportInfo");
        if (pjWorkshopIf == null) {
            PsDebug.warning("missing class PsExportInfo, probably jvx.jar not available.");
            return false;
        }
        pjWorkshopIf.setViewer(this);
        PsDialog psDialog = (PsDialog)PsUtil.newInstance("jvx.project.PjWorkshop_Dialog");
        if (psDialog != null) {
            psDialog.setParent(pjWorkshopIf);
            psDialog.update(pjWorkshopIf);
            ((Component)psDialog).setLocation(50, 50);
            psDialog.setModal(true);
            psDialog.show();
        }
        return true;
    }

    protected void serialize(String string) {
        if (!PsConfig.isApplication()) {
            return;
        }
        Object object = null;
        if (string.equalsIgnoreCase(PsConfig.getMessage(21147))) {
            object = this.getDisplay();
        } else if (string.equalsIgnoreCase(PsConfig.getMessage(21121))) {
            object = this.getDisplay().getSelectedGeometry();
        } else if (string.equalsIgnoreCase(PsConfig.getMessage(21146))) {
            object = this.getApplet();
        } else if (string.equalsIgnoreCase(PsConfig.getMessage(21120))) {
            object = this.m_currentProject;
        } else {
            PsDebug.warning("Serialization target not found, name = " + string);
            return;
        }
        if (object == null) {
            PsDebug.warning("missing object to serialize.");
            return;
        }
        PgFileDialog pgFileDialog = new PgFileDialog(PsConfig.getFrame(), PsConfig.getMessage(24321), 1);
        pgFileDialog.setFile(object.getClass().getName() + ".ser");
        if (this.m_serialDirName == null) {
            this.m_serialDirName = PsConfig.getCodeBase() + "dev/models/serialized/";
        }
        pgFileDialog.setDirectory(this.m_serialDirName);
        pgFileDialog.setExtension("ser");
        pgFileDialog.show();
        String string2 = pgFileDialog.getFullFileName();
        if (string2 == null) {
            return;
        }
        this.m_serialDirName = pgFileDialog.getDirectory();
        PsObject psObject = null;
        PsUpdateIf psUpdateIf = null;
        if (object instanceof PsObject) {
            psObject = (PsObject)object;
            psUpdateIf = psObject.getFather();
            psObject.setParent(null);
        }
        PvDisplay pvDisplay = null;
        if (object instanceof PvDisplay) {
            pvDisplay = (PvDisplay)object;
            pvDisplay.removeKeyListener(this);
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
            objectOutputStream.close();
            fileOutputStream.close();
        }
        catch (NotSerializableException notSerializableException) {
            PsDebug.message(notSerializableException.toString());
        }
        catch (IOException iOException) {
            PsDebug.message(iOException.toString());
        }
        if (pvDisplay != null) {
            pvDisplay.addKeyListener(this);
        }
        if (psObject != null && psUpdateIf != null) {
            psObject.setParent(psUpdateIf);
        }
    }

    public boolean isEmbedded() {
        return this.m_bEmbedded;
    }

    public boolean export(int n, String string) {
        if (this.m_display == null) {
            PsDebug.warning("missing display, no geometry available");
            return false;
        }
        PvDisplayOption pvDisplayOption = null;
        switch (n) {
            case 49: 
            case 59: 
            case 60: {
                if (this.m_display == null) break;
                pvDisplayOption = new PvDisplayOption();
                pvDisplayOption.setOptions(this.m_display);
            }
        }
        PgLoader pgLoader = new PgLoader();
        switch (n) {
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 60: {
                PgGeometryIf pgGeometryIf;
                pgLoader.setDisplayOption(pvDisplayOption);
                PgGeometryIf[] pgGeometryIfArray = this.m_display.getGeometries();
                if (pgGeometryIfArray != null && pgGeometryIfArray.length > 1 && pgGeometryIfArray[0] != (pgGeometryIf = this.m_display.getSelectedGeometry())) {
                    int n2 = 0;
                    while (n2 < pgGeometryIfArray.length) {
                        if (pgGeometryIfArray[n2] == pgGeometryIf) {
                            PgGeometryIf pgGeometryIf2 = pgGeometryIfArray[0];
                            pgGeometryIfArray[0] = pgGeometryIf;
                            pgGeometryIfArray[n2] = pgGeometryIf2;
                            break;
                        }
                        ++n2;
                    }
                }
                pgLoader.saveGeometry(pgGeometryIfArray, string);
                break;
            }
            case 59: {
                pgLoader.saveDisplay(new PvDisplayOption[]{pvDisplayOption}, string);
                break;
            }
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 57: 
            case 58: 
            case 70: {
                Dimension dimension = this.m_display.getSize();
                this.export(n, string, dimension.width, dimension.height);
                break;
            }
            default: {
                PsDebug.warning("invalid dialog index = " + n);
                return false;
            }
        }
        return true;
    }

    public boolean export(int n, String string, int n2, int n3) {
        if (this.m_display == null) {
            PsDebug.warning("missing display, no geometry available");
            return false;
        }
        PvDisplay pvDisplay = (PvDisplay)this.m_display;
        boolean bl = this.m_display.hasPaintTag(4L);
        this.m_display.setPaintTag(4L, false);
        boolean bl2 = this.m_display.hasPaintTag(0x20000000L);
        this.m_display.setPaintTag(0x20000000L, false);
        boolean bl3 = this.m_display.isEnabledZBuffer() || this.m_display.isEnabledClip() || this.m_display.isShowingBackgroundImage() && this.m_display.getBackgroundImage() != null || this.m_display.isShowingForegroundImage() && this.m_display.getForegroundImage() != null;
        PgLoader pgLoader = new PgLoader();
        switch (n) {
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                pvDisplay.setEnabledExternalRendering(true);
                pvDisplay.setExternalRenderSize(n2, n3);
                pvDisplay.update(this.m_display.getGraphics());
                Image image = this.m_display.getImage();
                pvDisplay.setEnabledExternalRendering(false);
                pgLoader.saveImage(image, string);
                break;
            }
            case 57: 
            case 58: {
                String string2 = null;
                string2 = this.m_currentGeometry != null ? this.m_currentGeometry.getName() : PsConfig.getProgram();
                PSGr pSGr = new PSGr(this.m_display.getGraphics(), string2, n2, n3);
                if (!bl3) {
                    this.m_display.setPaintTag(8L, true);
                    PvDisplay cfr_ignored_0 = (PvDisplay)this.m_display;
                    pSGr.setZoom(PvDisplay.PS_ZOOM);
                    this.print(pSGr, bl3, n2, n3);
                    this.m_display.setPaintTag(8L, false);
                    pSGr.setZoom(1.0f);
                } else {
                    this.print(pSGr, bl3, n2, n3);
                }
                String string3 = pSGr.toString();
                if (n == 58) {
                    string3 = string3 + "showpage";
                }
                pgLoader.saveString(string3, string);
                break;
            }
            case 70: {
                try {
                    PrintJob printJob = pvDisplay.getToolkit().getPrintJob(PsConfig.getFrame(), "JavaView Print Job", null);
                    if (printJob == null) {
                        return true;
                    }
                    Graphics graphics = printJob.getGraphics();
                    Dimension dimension = printJob.getPageDimension();
                    double d = (double)n2 / (double)n3;
                    double d2 = (double)dimension.width / (double)dimension.height;
                    if (d > d2) {
                        n2 = dimension.width;
                        n3 = (int)((double)dimension.width / d);
                    } else {
                        n2 = (int)((double)dimension.height * d);
                        n3 = dimension.height;
                    }
                    boolean bl4 = this.m_display.isEnabledAntiAlias();
                    if (bl4) {
                        this.m_display.setEnabledAntiAlias(false);
                    }
                    this.print(graphics, bl3, n2, n3);
                    if (bl4) {
                        this.m_display.setEnabledAntiAlias(true);
                    }
                    graphics.dispose();
                    printJob.end();
                }
                catch (Exception exception) {
                    PsDebug.warning("printing failed in Java.");
                }
                break;
            }
            default: {
                PsDebug.warning("invalid dialog index = " + n);
                return false;
            }
        }
        this.m_display.setPaintTag(0x20000000L, bl2);
        this.m_display.setPaintTag(4L, bl);
        pvDisplay.render();
        return true;
    }

    protected boolean isEnabledMenu(int n) {
        if (this.m_menuBars == null || this.m_menuBars.size() == 0) {
            return false;
        }
        PvControlMenu pvControlMenu = (PvControlMenu)this.m_menuBars.elementAt(0);
        if (pvControlMenu == null) {
            return false;
        }
        return pvControlMenu.isMenuEnabled(n);
    }

    private static String[][] getDefaultProjects() {
        String[][] stringArray = new String[][]{{PsConfig.getMessage(18000), PsConfig.getMessage(18036), "vgp.curve.surface.PjSurfCurve"}, {PsConfig.getMessage(18000), PsConfig.getMessage(18037), "vgp.curve.geodesic.PjGeodesic"}, {PsConfig.getMessage(18000), PsConfig.getMessage(18038), "vgp.tutor.torusknot.PjTorusKnot"}, {PsConfig.getMessage(18000), PsConfig.getMessage(18039), "vgp.curve.cycloid.PjCycloid"}, {PsConfig.getMessage(18000), PsConfig.getMessage(18040), "vgp.curve.elastic.PjElasticCurve"}, {PsConfig.getMessage(18000), PsConfig.getMessage(18041), "vgp.tutor.parmCurve.PjParmCurve"}, {PsConfig.getMessage(18001), PsConfig.getMessage(18042), "vgp.game.life.PjLife"}, {PsConfig.getMessage(18001), PsConfig.getMessage(18043), "vgp.game.mines.PjMinesweeper"}, {PsConfig.getMessage(18002), PsConfig.getMessage(18044), "vgp.tutor.fractal.PjFractalImage"}, {PsConfig.getMessage(18002), PsConfig.getMessage(18045), "vgp.tutor.texture.PjTextureCube"}, {PsConfig.getMessage(18003), PsConfig.getMessage(18010), "vgp.discrete.conformal.PjConformal"}, {PsConfig.getMessage(18003), PsConfig.getMessage(18011), "vgp.discrete.conjugate.PjConjugate"}, {PsConfig.getMessage(18003), PsConfig.getMessage(18012), "vgp.discrete.harmonic.PjHarmonic"}, {PsConfig.getMessage(18004), PsConfig.getMessage(18005), "jv.loader.PjImportModel"}, {PsConfig.getMessage(18004), PsConfig.getMessage(18013), "vgp.tutor.model.PjModel"}, {PsConfig.getMessage(18004), PsConfig.getMessage(18014), "vgp.tutor.key.PjKeyframe"}, {PsConfig.getMessage(18006), PsConfig.getMessage(18015), "vgp.tutor.ode.PjExprOde"}, {PsConfig.getMessage(18006), PsConfig.getMessage(18016), "vgp.discrete.harmonic.PjHarmonic"}, {PsConfig.getMessage(18006), PsConfig.getMessage(18017), "vgp.tutor.rootFinder.PjRootFinder"}, {PsConfig.getMessage(18007), PsConfig.getMessage(18018), "vgp.surface.common.PjSurface"}, {PsConfig.getMessage(18007), PsConfig.getMessage(18047), "vgp.surface.rotation.PjRotation"}, {PsConfig.getMessage(18007), PsConfig.getMessage(18019), "vgp.discrete.catenoid.PjCatenoid"}, {PsConfig.getMessage(18007), PsConfig.getMessage(18020), "vgp.minimal.weier.PjWeierstrass"}, {PsConfig.getMessage(18007), PsConfig.getMessage(18021), "vgp.tutor.parm.PjParmSurface"}, {PsConfig.getMessage(18007), PsConfig.getMessage(18022), "vgp.discrete.platonic.PjPlatonic"}, {PsConfig.getMessage(18007), PsConfig.getMessage(18046), "vgp.surface.klein.PjKleinBottle"}, {PsConfig.getMessage(18008), PsConfig.getMessage(18023), "vgp.tutor.firstProject.MyProject"}, {PsConfig.getMessage(18008), PsConfig.getMessage(18024), "vgp.tutor.lsystem.PjLSystem"}, {PsConfig.getMessage(18008), PsConfig.getMessage(18026), "vgp.tutor.pick.PjPickEvent"}, {PsConfig.getMessage(18008), PsConfig.getMessage(18027), "vgp.tutor.polygonSet.PjPolygonSet"}, {PsConfig.getMessage(18008), PsConfig.getMessage(18028), "vgp.tutor.rivara.PjRivara"}, {PsConfig.getMessage(18008), PsConfig.getMessage(18029), "vgp.tutor.height.PjHeight"}, {PsConfig.getMessage(18008), PsConfig.getMessage(18030), "vgp.tutor.texture.PjTexturedSurface"}, {PsConfig.getMessage(18008), PsConfig.getMessage(18031), "vgp.tutor.transform.PjTransform"}, {PsConfig.getMessage(18008), PsConfig.getMessage(18032), "vgp.tutor.vectorField.PjVectorField"}, {PsConfig.getMessage(18009), PsConfig.getMessage(18033), "vgp.vector.vectorField.PjVectorField"}, {PsConfig.getMessage(18009), PsConfig.getMessage(18034), "vgp.vector.hodge.PjHodge"}, {PsConfig.getMessage(18009), PsConfig.getMessage(18035), "vgp.vector.lic.PjLIC"}, {PsConfig.getMessage(18007), PsConfig.getMessage(true, 18000, "Level Surfaces"), "vgp.volume.mc.PjMarchingCubes"}};
        return stringArray;
    }

    public Hashtable getProjectClasses() {
        return this.m_projectClass;
    }

    public PvDisplayIf getDisplay() {
        if (this.m_display == null) {
            this.m_display = new PvDisplay(this);
            this.addDisplay(PsConfig.getMessage(24320), this.m_display);
            if (this.m_currentProject != null && !this.m_currentProject.hasDisplay(this.m_display)) {
                this.m_currentProject.setDisplay(this.m_display);
            }
            this.selectDisplay(this.m_display);
        }
        return this.m_display;
    }

    public boolean selectDisplay(PvDisplayIf pvDisplayIf) {
        if (pvDisplayIf != null && !this.hasDisplay(pvDisplayIf)) {
            PsDebug.warning("display with name = " + pvDisplayIf.getName() + " not found.");
            return false;
        }
        PvDisplayIf pvDisplayIf2 = this.m_display;
        this.m_display = pvDisplayIf;
        if (this.m_control != null) {
            this.m_control.setDisplay(this.m_display);
        }
        if (this.m_display == null) {
            this.m_mainDisplay = null;
            this.setGeometry(null);
        } else {
            if (this.m_display.getSelectedGeometry() != null && this.m_display.getSelectedGeometry() != this.m_currentGeometry) {
                this.setGeometry(this.m_display.getSelectedGeometry());
            }
            if (this.m_mainDisplay == null) {
                this.m_mainDisplay = this.m_display;
            }
        }
        boolean bl = this.m_display != null;
        this.setEnabledMenu(24, bl);
        this.setEnabledMenu(25, bl);
        this.setEnabledMenu(23, bl);
        this.setEnabledMenu(26, bl);
        if (pvDisplayIf2 != null && pvDisplayIf2 != this.m_display) {
            PvViewer.setAutoFocus(pvDisplayIf2, false, false);
        }
        if (this.m_display != null) {
            PvViewer.setAutoFocus(this.m_display, true, this.getNumDisplays() > 1);
            ((PvDisplay)this.m_display).requestFocus();
        }
        return true;
    }

    public PvDisplayIf[] getDisplays() {
        if (this.m_displayVector == null) {
            return null;
        }
        PvDisplayIf[] pvDisplayIfArray = new PvDisplayIf[this.m_displayVector.size()];
        int n = 0;
        Enumeration enumeration = this.m_displayVector.elements();
        while (enumeration.hasMoreElements()) {
            pvDisplayIfArray[n++] = (PvDisplayIf)enumeration.nextElement();
        }
        return pvDisplayIfArray;
    }

    public Applet getApplet() {
        return this.m_applet;
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public synchronized void destroy() {
        block8: {
            try {
                this.stop();
                if (this.m_currentProject != null) {
                    this.m_currentProject.dispose();
                    this.m_currentProject = null;
                }
                if (this.m_frameVector != null) {
                    Enumeration enumeration = this.m_frameVector.elements();
                    while (enumeration.hasMoreElements()) {
                        Frame frame = (Frame)enumeration.nextElement();
                        ((Component)frame).setVisible(false);
                        if (!this.isEmbedded()) {
                            frame.dispose();
                            continue;
                        }
                        ((Component)frame).setVisible(false);
                    }
                }
                if (!this.isEmbedded()) {
                    PsDebug.disposeConsole();
                }
                if (PsConfig.isApplication() && !this.isEmbedded()) {
                    System.exit(0);
                    return;
                }
            }
            catch (Exception exception) {
                if (!PsConfig.isApplication() || this.isEmbedded()) break block8;
                System.exit(0);
            }
        }
    }

    private static String[][] getDefaultGeometries() {
        String[][] stringArray = new String[][]{{PsConfig.getMessage(15046), PsConfig.getMessage(15045), "jv.geom.PgPointSet"}, {PsConfig.getMessage(15038), PsConfig.getMessage(15047), "jv.geom.PgPolygon"}, {PsConfig.getMessage(15038), PsConfig.getMessage(15048), "jv.geom.PgPolygonSet"}, {PsConfig.getMessage(15038), PsConfig.getMessage(15039), "jvx.geom.PgParmCurve"}, {PsConfig.getMessage(15040), PsConfig.getMessage(15049), "jv.geom.PgElementSet"}, {PsConfig.getMessage(15040), PsConfig.getMessage(15030), "jvx.surface.PgDomain"}, {PsConfig.getMessage(15040), PsConfig.getMessage(15031), "jvx.surface.PgGraph"}, {PsConfig.getMessage(15040), PsConfig.getMessage(15041), "jvx.geom.PwPlatonic"}, {PsConfig.getMessage(15040), PsConfig.getMessage(15042), "jvx.surface.PgParmSurface"}, {PsConfig.getMessage(15040), PsConfig.getMessage(15050), "jvx.surface.PgGenusSurface"}, {PsConfig.getMessage(15040), PsConfig.getMessage(15028), "jvx.surface.PgSurfaceOfRotation"}};
        return stringArray;
    }

    public Frame getFrame() {
        return this.m_frame;
    }

    private static String[] getCategories(Hashtable hashtable) {
        int n;
        if (hashtable == null || hashtable.size() == 0) {
            return null;
        }
        int n2 = hashtable.size();
        String[] stringArray = new String[n2];
        int n3 = 0;
        String[] stringArray2 = hashtable.elements();
        while (stringArray2.hasMoreElements()) {
            String string = (String)stringArray2.nextElement();
            boolean bl = false;
            n = 0;
            while (n < n3) {
                if (stringArray[n].equals(string)) {
                    bl = true;
                    break;
                }
                ++n;
            }
            if (bl) continue;
            stringArray[n3++] = string;
        }
        if (n3 == 0) {
            return null;
        }
        stringArray2 = new String[n3];
        n = 0;
        while (n < n3) {
            stringArray2[n] = stringArray[n];
            ++n;
        }
        PuString.sort(stringArray2);
        return stringArray2;
    }

    protected boolean selectFrame(Frame frame) {
        if (!this.hasFrame(frame)) {
            PsDebug.warning("frame not found.");
            return false;
        }
        PvDisplayIf pvDisplayIf = this.getDisplayOfFrame(frame);
        if (pvDisplayIf != null && this.hasDisplay(pvDisplayIf)) {
            this.selectDisplay(pvDisplayIf);
        }
        return true;
    }

    protected void setLanguage(String string) {
        PsConfig.setLanguage(string);
        if (this.m_control != null) {
            this.m_control.setLanguage(string);
        }
        if (this.m_menuBars != null) {
            int n = this.m_menuBars.size();
            Vector vector = (Vector)this.m_menuBars.clone();
            this.m_menuBars.removeAllElements();
            int n2 = 0;
            while (n2 < n) {
                PvControlMenu pvControlMenu = (PvControlMenu)vector.elementAt(n2);
                Frame frame = pvControlMenu.m_frame;
                PvControlMenu pvControlMenu2 = this.newMenuBar(frame);
                frame.setMenuBar(pvControlMenu2);
                ++n2;
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void setGeometry(PgGeometryIf pgGeometryIf) {
        if (pgGeometryIf == null) {
            // empty if block
        }
        if (this.m_control != null) {
            this.m_control.setGeometry(pgGeometryIf);
        }
        if (pgGeometryIf == null) {
            this.setEnabledMenu(3, false);
            this.setEnabledMenu(22, false);
            if (this.m_currentProject == null) {
                this.setEnabledMenu(40, false);
            }
            this.m_currentGeometry = null;
            return;
        }
        if (this.m_currentGeometry == pgGeometryIf) {
            return;
        }
        this.m_currentGeometry = pgGeometryIf;
        this.setEnabledMenu(3, true);
        this.setEnabledMenu(22, true);
        this.setEnabledMenu(220, this.m_currentGeometry.isConfigurable(4));
        this.setEnabledMenu(221, this.m_currentGeometry.isConfigurable(5));
        this.setEnabledMenu(222, this.m_currentGeometry.isConfigurable(6));
        this.setEnabledMenu(223, this.m_currentGeometry.isConfigurable(8));
        this.setEnabledMenu(224, this.m_currentGeometry.isConfigurable(9));
        this.setEnabledMenu(225, this.m_currentGeometry.isConfigurable(7));
    }

    public PgGeometryIf getGeometry(String string) {
        PgGeometryIf pgGeometryIf = null;
        String string2 = (String)this.m_geometryClass.get(string);
        if (string2 == null) {
            PsDebug.warning("missing class, could not create instance of " + string);
            return null;
        }
        if (string2.startsWith("jvx.") && !PsConfig.hasArchive(1)) {
            PsDebug.warning("missing archive jvx.jar, could not create instance of class = " + string2);
            return null;
        }
        if (string2.startsWith("jvx.geom.PwPlatonic")) {
            PjWorkshopIf pjWorkshopIf = (PjWorkshopIf)PsUtil.newInstance(string2);
            if (pjWorkshopIf != null) {
                pgGeometryIf = pjWorkshopIf.getGeometry();
                PsDialog psDialog = (PsDialog)PsUtil.newInstance("jvx.project.PjWorkshop_Dialog");
                if (psDialog != null) {
                    psDialog.addActionListener(this);
                    psDialog.setParent(pjWorkshopIf);
                    psDialog.update(pjWorkshopIf);
                    psDialog.show();
                }
                this.wsDialogPlatonic = psDialog;
                this.wsGeometry = pgGeometryIf;
            }
        } else {
            pgGeometryIf = (PgGeometryIf)PsUtil.newInstance(string2);
            if (pgGeometryIf != null) {
                pgGeometryIf.setName(string + "[" + PsObject.getNumObjects() + "]");
            }
        }
        if (pgGeometryIf == null) {
            PsDebug.warning("could not create instance of class = " + string2);
            return null;
        }
        return pgGeometryIf;
    }

    public PgGeometryIf getGeometry() {
        return this.m_currentGeometry;
    }

    public void printParameter() {
        if (this.m_parm == null) {
            this.getParameter("Nothing");
        }
        if (this.m_parm == null) {
            PsDebug.message("empty parameter list.");
            return;
        }
        PsDebug.message("parameter list:");
        int n = 0;
        while (n < this.m_parm.length) {
            PsDebug.message("\t Parameter = " + this.m_parm[n][0] + ", Value = " + this.getParameter(this.m_parm[n][0]));
            ++n;
        }
    }

    public boolean addProject(String string, String string2, String[] stringArray) {
        return this.addProject(null, string, string2, stringArray);
    }

    public boolean addProject(String string, String string2, String string3, String[] stringArray) {
        if (string2 == null || string3 == null) {
            PsDebug.warning("missing name or class");
            return false;
        }
        if (this.m_projectClass.containsKey(string2)) {
            PsDebug.warning("project name already exists, name = " + string2 + "\n\texisting name belong to class = " + (String)this.m_projectClass.get(string2));
            return false;
        }
        if (string == null) {
            string = "Default";
        }
        this.m_projectCategory.put(string2, string);
        this.m_projectClass.put(string2, string3);
        this.setEnabledMenu(100, true);
        if (stringArray != null) {
            this.m_projectParms.put(string2, stringArray);
        }
        return true;
    }

    public boolean addProject(PjProject pjProject) {
        if (pjProject == null) {
            PsDebug.warning("missing project");
            return false;
        }
        String string = pjProject.getName();
        if (string == null) {
            PsDebug.warning("missing project name");
            return false;
        }
        if (this.hasProject(string) || this.m_projectList.contains(pjProject)) {
            PsDebug.warning("project already available, use selectProject, name = " + string);
            return false;
        }
        this.m_projectList.put(string, pjProject);
        pjProject.setViewer(this);
        return true;
    }

    public void init() {
        int n;
        Object object;
        String string;
        super.init();
        if (this.m_displayVector != null) {
            this.m_displayVector.removeAllElements();
        }
        if (this.m_frameVector != null) {
            this.m_frameVector.removeAllElements();
        }
        if (this.m_frame != null) {
            this.addFrame(this.m_frame);
        }
        if (PsConfig.isApplication()) {
            PvDisplay.m_bLicenseChecked = true;
            PvDisplay.m_license = "license validation failed";
            if (this.m_jvLic == null) {
                this.m_jvLic = new PsLicense();
            }
            if ((string = this.getParameter("jv-lic")) == null) {
                string = "rsrc/jv-lic.lic";
            }
            if (!PsUtil.isAbsolutePath(string = PsUtil.assureFileSeparator(string, false))) {
                string = PsConfig.getCodeBase() + string;
            }
            PsJavaView.setFullFileName(1, string);
            try {
                object = new File(string);
                if (!((File)object).exists()) {
                    PsDebug.message("Missing: license file = " + string, false);
                    PsDebug.message("\tusing default license: type = evaluation, id = " + this.m_jvLic.getLicenseId(), false);
                    PvDisplay.m_license = "missing license, cannot find = " + string;
                } else {
                    String string2;
                    PsDebug.message("Found: license file = " + string, false);
                    if (!this.m_jvLic.read(string)) {
                        PsDebug.message("\tfailed reading license file = " + string, false);
                        PvDisplay.m_license = "void license file = " + string;
                    }
                    boolean bl = false;
                    n = 1;
                    String string3 = this.m_jvLic.getLicenseId();
                    String string4 = this.m_jvLic.getLicenseType();
                    String string5 = this.m_jvLic.getLicensee();
                    Date date = new Date();
                    Date date2 = null;
                    if (string3 != null && (string2 = string3.substring(2)) != null) {
                        String[] stringArray = PuString.splitString(string2, '.');
                        string2 = PuString.mergeStrings(stringArray, "");
                        long l = Long.parseLong(string2);
                        if (string3.startsWith("30")) {
                            date2 = new Date(103, 11, 31, 23, 59, 59);
                            bl = true;
                        } else if (string3.startsWith("31")) {
                            date2 = new Date(104, 5, 30, 23, 59, 59);
                            bl = l / 17L * 17L == l;
                        } else if (string3.startsWith("32")) {
                            date2 = new Date(104, 11, 31, 23, 59, 59);
                            bl = l / 23L * 23L == l;
                        } else if (string3.startsWith("33")) {
                            date2 = new Date(105, 5, 30, 23, 59, 59);
                            bl = l / 29L * 29L == l;
                        } else if (string3.startsWith("34")) {
                            date2 = new Date(105, 11, 31, 23, 59, 59);
                            bl = l / 31L * 31L == l;
                        } else if (string3.startsWith("35")) {
                            date2 = new Date(106, 5, 30, 23, 59, 59);
                            bl = l / 37L * 37L == l;
                        } else if (string3.startsWith("36")) {
                            date2 = new Date(106, 11, 31, 23, 59, 59);
                            bl = l / 41L * 41L == l;
                        } else if (string3.startsWith("37")) {
                            date2 = new Date(107, 5, 30, 23, 59, 59);
                            bl = l / 43L * 43L == l;
                        } else if (string3.startsWith("38")) {
                            date2 = new Date(107, 11, 31, 23, 59, 59);
                            boolean bl2 = bl = l / 47L * 47L == l;
                        }
                        if (string3.startsWith("4711")) {
                            bl = true;
                            n = 0;
                        } else if (date2 != null) {
                            n = date.after(date2) ? 1 : 0;
                        }
                    }
                    if (bl && n == 0) {
                        PsDebug.message("\tlicensed to " + string5, false);
                        PsDebug.message("\ttype = " + string4 + ", id = " + string3, false);
                        PvDisplay.m_license = null;
                    } else if (bl && n != 0) {
                        PsDebug.message("\t!!! Expired license, id = " + string3, true);
                        string2 = String.valueOf(date2.getYear() + 1900) + "-" + String.valueOf(date2.getMonth() + 1) + "-" + String.valueOf(date2.getDate());
                        PsDebug.message("\t!!! Expiration date = " + string2, true);
                        PvDisplay.m_license = "expired license id = " + string3 + ", date = " + string2;
                    } else {
                        PsDebug.message("\t!!! Void license, id = " + string3, true);
                        PvDisplay.m_license = "void license id = " + string3;
                    }
                }
            }
            catch (SecurityException securityException) {}
        }
        string = this.getParameter("jv-rsrc");
        if ((string = PsUtil.assureFileSeparator(string, false)) != null) {
            if (!PsUtil.isAbsolutePath(string)) {
                string = PsConfig.getCodeBase() + string;
            }
            PsJavaView.setFullFileName(2, string);
            PsDebug.message("Argument: resource file = " + string, false);
            if (!this.m_jvRsrc.read(string)) {
                PsDebug.message("Failed: loading resource file = " + string, true);
            }
        }
        if ("Show".equalsIgnoreCase(this.getParameter("Console"))) {
            this.showDialog(35);
        }
        if (this.m_geometryCategory != null) {
            this.m_geometryCategory.clear();
        }
        if (this.m_geometryClass != null) {
            this.m_geometryClass.clear();
        }
        if (this.m_projectCategory != null) {
            this.m_projectCategory.clear();
        }
        if (this.m_projectClass != null) {
            this.m_projectClass.clear();
        }
        if (this.m_projectList != null) {
            this.m_projectList.clear();
        }
        if (this.m_projectParms != null) {
            this.m_projectParms.clear();
        }
        if (PsConfig.hasArchive(2)) {
            object = this.getParameter("menu-new-project");
            String[][] stringArray = PvViewer.getDefaultProjects();
            if (stringArray != null && (PsConfig.isApplication() || object != null && ((String)object).equalsIgnoreCase("enable"))) {
                n = 0;
                while (n < stringArray.length) {
                    this.addProject(stringArray[n][0], stringArray[n][1], stringArray[n][2], null);
                    ++n;
                }
            }
        }
        if ((object = PvViewer.getDefaultGeometries()) != null) {
            boolean bl = PsConfig.hasArchive(1);
            n = 0;
            while (n < ((String[][])object).length) {
                if (bl || !((String)object[n][2]).startsWith("jvx.")) {
                    this.addGeometry((String)object[n][0], (String)object[n][1], (String)object[n][2]);
                }
                ++n;
            }
        }
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public boolean showPanel(int n) {
        this.m_showPanel = n;
        if (this.m_control != null) {
            return this.m_control.showPanel(n);
        }
        return true;
    }

    public boolean setEnabledPanel(int n, boolean bl) {
        if (this.m_control == null) {
            return true;
        }
        return this.m_control.setEnabledPanel(n, true);
    }

    public Panel getPanel(int n) {
        if (this.m_control == null) {
            this.m_control = this.getControl();
        }
        return this.m_control.getPanel(n);
    }

    private void print(Graphics graphics, boolean bl, int n, int n2) {
        PvDisplay pvDisplay = (PvDisplay)this.m_display;
        if (bl) {
            Color color = pvDisplay.getBackgroundColor();
            pvDisplay.setBackgroundColor(Color.white);
            pvDisplay.setEnabledExternalRendering(true);
            pvDisplay.setExternalRenderSize(n, n2);
            pvDisplay.render();
            Image image = this.m_display.getImage();
            pvDisplay.setEnabledExternalRendering(false);
            graphics.drawImage(image, 0, 0, n, n2, null);
            pvDisplay.drawOverlayText(graphics, n, n2, 1);
            pvDisplay.setBackgroundColor(color);
            pvDisplay.render();
            return;
        }
        boolean bl2 = this.m_display.isEnabledAntiAlias();
        if (bl2) {
            this.m_display.setEnabledAntiAlias(false);
        }
        pvDisplay.setExternalRenderSize(n, n2);
        pvDisplay.setEnabledExternalRendering(true);
        pvDisplay.paintGeom(graphics);
        pvDisplay.setEnabledExternalRendering(false);
        if (bl2) {
            this.m_display.setEnabledAntiAlias(true);
        }
    }

    protected boolean burnTexture() {
        ((PvDisplay)this.m_display).burn();
        return true;
    }

    public PjProject getCurrentProject() {
        return this.m_currentProject;
    }

    public synchronized void stop() {
        this.m_bStarted = false;
        if (this.m_help != null) {
            this.m_help.dispose();
            this.m_help = null;
        }
        if (this.m_control != null) {
            this.m_control.dispose();
            this.m_control = null;
        }
        if (this.m_currentProject != null) {
            this.m_currentProject.stop();
        }
        if (PsDebug.hasConsole()) {
            ((Component)PsDebug.getConsole()).setVisible(false);
        }
    }

    public int getNumFrames() {
        return this.m_frameVector.size();
    }

    private PvControl getControl() {
        if (this.m_control != null) {
            return this.m_control;
        }
        this.m_control = new PvControl(this);
        if (this.m_control == null) {
            PsDebug.error("missing control panel", this);
            return null;
        }
        if (!PsConfig.hasArchive(1)) {
            this.setEnabledMenu(15, false);
        }
        this.m_control.addWindowListener(this);
        if (this.m_display != null) {
            this.m_control.setDisplay(this.m_display);
        }
        this.m_control.setProject(this.m_currentProject);
        if (this.m_currentGeometry == null && this.m_display != null) {
            this.setGeometry(this.m_display.getSelectedGeometry());
        }
        this.m_control.setGeometry(this.m_currentGeometry);
        if (this.m_showPanel != -1) {
            this.m_control.showPanel(this.m_showPanel);
        }
        return this.m_control;
    }

    public void windowClosing(WindowEvent windowEvent) {
        if (!(windowEvent.getSource() instanceof Frame)) {
            return;
        }
        Frame frame = (Frame)windowEvent.getSource();
        if (frame == this.m_control) {
            this.removeControl();
        } else {
            Enumeration enumeration = this.m_frameVector.elements();
            while (enumeration.hasMoreElements()) {
                if (frame != (Frame)enumeration.nextElement()) continue;
                this.removeFrame(frame);
                if (!this.isEmbedded()) {
                    frame.dispose();
                    break;
                }
                ((Component)frame).setVisible(false);
                break;
            }
        }
        if (PsConfig.isApplication() && this.getNumFrames() == 0 && (this.m_control == null || !this.m_control.isShowing())) {
            this.destroy();
        }
    }

    public boolean hasDisplay(PvDisplayIf pvDisplayIf) {
        if (this.m_displayVector == null) {
            return false;
        }
        return this.m_displayVector.contains(pvDisplayIf);
    }

    public boolean removeDisplay(PvDisplayIf pvDisplayIf) {
        if (pvDisplayIf == null) {
            PsDebug.warning("missing argument display");
            return false;
        }
        if (!this.hasDisplay(pvDisplayIf)) {
            PsDebug.warning("display with name = " + pvDisplayIf.getName() + " not found.");
            return false;
        }
        this.m_displayVector.removeElement(pvDisplayIf);
        ((PvDisplay)pvDisplayIf).removeGeometriesDoIt();
        pvDisplayIf.setParent(null);
        pvDisplayIf.setViewer(null);
        pvDisplayIf.removeKeyListener(this);
        if (this.m_display == pvDisplayIf) {
            PvDisplayIf pvDisplayIf2 = null;
            if (this.m_displayVector.size() > 0) {
                pvDisplayIf2 = (PvDisplayIf)this.m_displayVector.firstElement();
            }
            this.selectDisplay(pvDisplayIf2);
        } else if (this.getNumDisplays() == 1) {
            PvViewer.setAutoFocus(this.m_display, true, false);
        }
        if (this.m_mainDisplay == pvDisplayIf) {
            this.m_mainDisplay = this.m_display;
        }
        return true;
    }

    public PvDisplayIf getSelectedDisplay() {
        return this.m_display;
    }

    public boolean update(Object object) {
        if (object == this.m_currentProject) {
            return true;
        }
        return super.update(object);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object != null && object == this.wsDialogPlatonic) {
            if (actionEvent.getID() == 1 && this.m_display != null && this.wsGeometry != null) {
                this.m_display.removeGeometry(this.wsGeometry);
                this.m_display.update(this.m_display);
            }
            this.wsDialogPlatonic = null;
            this.wsGeometry = null;
        }
    }

    public String getRecentGeometryFile() {
        return PsJavaView.getFullFileName(4);
    }

    public void setRecentGeometryFile(String string) {
        PsJavaView.setFullFileName(4, string);
    }

    public synchronized void start() {
        Object object;
        this.m_bStarted = true;
        if (this.m_display != null) {
            ((PvDisplay)this.m_display).requestFocus();
        }
        if (this.m_currentProject != null) {
            this.m_currentProject.start();
            object = this.m_mainDisplay.getCamera();
            if (object.isEnabledSceneRatio() && object.getProjectionMode() == 1) {
                ((PvDisplay)this.m_mainDisplay).selectCamera(1);
            }
        }
        if ((object = this.getParameter("Animation")) != null && ((String)object).equalsIgnoreCase("Show")) {
            this.showDialog(33);
        }
        if ((object = this.getParameter("Panel")) != null) {
            this.showPanel(PvViewer.getPanelId((String)object));
        }
        if ((object = this.getParameter("Control")) != null && ((String)object).equalsIgnoreCase("Show")) {
            this.showDialog(34);
        }
        if ((object = this.getParameter("Embedded")) != null) {
            this.setEmbedded(((String)object).equalsIgnoreCase("True"));
        }
        if ((object = this.getParameter("FastZBuffer")) != null) {
            ((PvDisplay)this.m_mainDisplay).setEnabledFastZBuffer(((String)object).equalsIgnoreCase("Show"));
        }
        if ((object = this.getParameter("Workshop.Backup")) != null) {
            PsJavaView.setEnabledWorkshopBackup(((String)object).equalsIgnoreCase("enable"));
        }
        boolean bl = this.parseDisplayParameters(this.m_mainDisplay);
        ((PvDisplay)this.m_mainDisplay).saveCameraDefaults();
        if (bl) {
            this.m_mainDisplay.update(this.m_mainDisplay.getCamera());
        }
        if (this.m_mainDisplay != null && this.m_mainDisplay.isShowingAxes()) {
            ((PvDisplay)this.m_mainDisplay).updateCameraListener(101);
        }
        if ((object = this.getParameter("AutoRotate")) != null) {
            String string = this.getParameter("RotDir");
            if (string != null) {
                PdVector pdVector = PsXmlLoader.parsePdVector(string);
                if (pdVector != null) {
                    this.m_mainDisplay.setAutoRotation(pdVector, 0.06283185307179587);
                }
            } else {
                this.m_mainDisplay.setAutoRotation(new PdVector(0.0, 1.0, 0.0), 0.06283185307179587);
            }
            if (((String)object).equalsIgnoreCase("Show")) {
                this.m_mainDisplay.setEnabledAnimation(true);
                this.m_mainDisplay.start();
            }
        }
    }

    protected boolean hasFrame(Frame frame) {
        return this.m_frameVector != null && this.m_frameVector.contains(frame);
    }

    protected boolean removeFrame(Frame frame) {
        PvDisplayIf pvDisplayIf;
        if (!this.hasFrame(frame)) {
            PsDebug.warning("frame not found.");
            return false;
        }
        frame.removeWindowListener(this);
        if (frame instanceof PsMainFrame) {
            frame.addWindowListener((PsMainFrame)frame);
        }
        this.m_frameVector.removeElement(frame);
        MenuBar menuBar = frame.getMenuBar();
        if (menuBar != null && this.m_menuBars != null && this.m_menuBars.contains(menuBar)) {
            this.m_menuBars.removeElement(menuBar);
        }
        if ((pvDisplayIf = this.getDisplayOfFrame(frame)) != null && this.m_displayVector.contains(pvDisplayIf)) {
            pvDisplayIf.setFrame(null);
            this.removeDisplay(pvDisplayIf);
        }
        return true;
    }

    public String getParameter(String string) {
        String string2;
        int n;
        string = string.toLowerCase();
        if (this.m_parm == null && this.m_applet != null && (this.m_parm = this.m_applet.getParameterInfo()) != null) {
            n = 0;
            while (n < this.m_parm.length) {
                this.m_parm[n][0] = this.m_parm[n][0].toLowerCase();
                ++n;
            }
            if (!PsConfig.isApplication()) {
                n = 0;
                while (n < this.m_parm.length) {
                    string2 = this.m_applet.getParameter(this.m_parm[n][0]);
                    if (string2 != null) {
                        this.m_parm[n][2] = string2;
                    }
                    ++n;
                }
            } else {
                n = 0;
                while (n < this.m_parm.length) {
                    string2 = System.getProperty(this.m_parm[n][0]);
                    if (string2 != null) {
                        this.m_parm[n][2] = string2;
                    }
                    ++n;
                }
            }
        }
        if (this.m_parm != null) {
            n = 0;
            while (n < this.m_parm.length) {
                if (this.m_parm[n][0].equalsIgnoreCase(string)) {
                    return this.m_parm[n][2].trim();
                }
                ++n;
            }
        }
        if (!PsConfig.isApplication() && this.m_applet != null && (string2 = this.m_applet.getParameter(string)) != null) {
            return string2;
        }
        if (PsConfig.isApplication() && (string2 = System.getProperty(string)) != null) {
            if (string2.startsWith("\"")) {
                string2 = string2.substring(1);
            }
            if (string2.endsWith("\"")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            return string2;
        }
        return null;
    }

    protected static Dialog getHelpDialog() {
        PsDialog psDialog = new PsDialog(PsConfig.getFrame(), PsConfig.getProgram() + ": " + PsConfig.getMessage(24314), false);
        psDialog.setLayout(new BorderLayout());
        Panel panel = new Panel(new GridLayout(2, 1));
        Component component = new Label(PsConfig.getMessage(24313), 0);
        component.setFont(PsConfig.getFont(3));
        panel.add(component);
        component = new Label(PsConfig.getMessage(28007), 0);
        panel.add(component);
        psDialog.add((Component)panel, "North");
        component = new TextArea();
        ((TextComponent)component).setEditable(false);
        ((TextComponent)component).setText(PsConfig.getMessage(28008));
        psDialog.add(component, "Center");
        psDialog.add((Component)psDialog.getBottomButtons(2), "South");
        psDialog.pack();
        return psDialog;
    }

    protected void submit() {
        if (!PsConfig.hasArchive(1)) {
            PsDebug.warning("missing archive jvx.jar");
            return;
        }
        PjWorkshopIf pjWorkshopIf = (PjWorkshopIf)PsUtil.newInstance("jvx.rsrc.PsModelInfo");
        if (pjWorkshopIf == null) {
            PsDebug.warning("missing class PsModelInfo, probably jvx.jar not available.");
            return;
        }
        pjWorkshopIf.setViewer(this);
        PsDialog psDialog = (PsDialog)PsUtil.newInstance("jvx.project.PjWorkshop_Dialog");
        if (psDialog != null) {
            psDialog.setParent(pjWorkshopIf);
            ((Component)psDialog).setLocation(5, 5);
            psDialog.update(pjWorkshopIf);
            psDialog.setModal(true);
            psDialog.show();
        }
    }

    public boolean addGeometry(String string, String string2, String string3) {
        if (string2 == null || string3 == null) {
            PsDebug.warning("missing name or class");
            return false;
        }
        if (this.m_geometryCategory == null) {
            this.m_geometryCategory = new Hashtable();
        }
        if (this.m_geometryClass == null) {
            this.m_geometryClass = new Hashtable();
        }
        if (this.m_geometryClass.containsKey(string2)) {
            PsDebug.warning("geometry name already exists, name = " + string2 + "\n\texisting name belong to class = " + (String)this.m_geometryClass.get(string2));
            return false;
        }
        if (string == null) {
            string = "Default";
        }
        this.m_geometryCategory.put(string2, string);
        this.m_geometryClass.put(string2, string3);
        return true;
    }

    public boolean isEnabledPanel(int n) {
        if (this.m_control == null) {
            return true;
        }
        return this.m_control.isEnabledPanel(n);
    }

    public boolean selectProject(String string) {
        PjProject pjProject;
        if (string == null) {
            PsDebug.warning("missing project name");
            return false;
        }
        if (this.m_currentProject != null) {
            if (string.equals(this.m_currentProject.getName())) {
                return true;
            }
            this.m_currentProject.stop();
        }
        if ((pjProject = this.getProject(string)) == null) {
            PsDebug.error("could not find project " + string, this);
            return false;
        }
        if (this.m_applet != null) {
            pjProject.setParameter(this.m_applet.getParameterInfo());
        }
        this.selectProject(pjProject);
        return true;
    }

    public PjProject getProject(String string) {
        PjProject pjProject = (PjProject)this.m_projectList.get(string);
        if (pjProject == null) {
            String string2 = (String)this.m_projectClass.get(string);
            if (string2 != null) {
                pjProject = (PjProject)PsUtil.newInstance(string2);
            }
            if (pjProject == null) {
                PsDebug.warning("could not create instance of " + string, this);
                return null;
            }
            pjProject.setViewer(this);
            this.m_projectList.put(string, pjProject);
        }
        return pjProject;
    }

    public boolean selectProject(PjProject pjProject) {
        if (pjProject == null) {
            PsDebug.warning("missing project");
            return false;
        }
        if (!this.m_projectList.contains(pjProject)) {
            PsDebug.warning("project not available in viewer, must be added before selecting.");
            return false;
        }
        if (this.m_currentProject != null) {
            if (this.m_currentProject == pjProject) {
                return true;
            }
            this.m_currentProject.stop();
        }
        this.m_currentProject = pjProject;
        this.m_currentProject.setParent(this);
        if (this.m_display != null) {
            if (this.m_currentProject.hasDisplay(this.m_display)) {
                this.m_currentProject.selectDisplay(this.m_display);
            } else {
                this.m_currentProject.setDisplay(this.m_display);
            }
        }
        if (this.m_control != null) {
            this.m_control.setProject(this.m_currentProject);
        }
        if (this.m_bStarted) {
            this.m_currentProject.start();
        }
        this.setEnabledMenu(21, true);
        this.setEnabledMenu(40, this.m_currentProject.hasAnimation());
        return true;
    }

    protected synchronized void reset() {
        PsUpdateIf psUpdateIf;
        Enumeration<Object> enumeration = this.m_projectList.elements();
        while (enumeration.hasMoreElements()) {
            psUpdateIf = (PjProject)enumeration.nextElement();
            psUpdateIf.removeGeometries();
            this.removeProject((PjProject)psUpdateIf);
            psUpdateIf.dispose();
        }
        if (this.m_displayVector != null) {
            enumeration = this.m_displayVector.elements();
            while (enumeration.hasMoreElements()) {
                psUpdateIf = (PvDisplayIf)enumeration.nextElement();
                if (this.m_mainDisplay != null && this.m_mainDisplay == psUpdateIf) {
                    this.selectDisplay((PvDisplayIf)psUpdateIf);
                    this.m_mainDisplay.init();
                    continue;
                }
                this.removeDisplay((PvDisplayIf)psUpdateIf);
            }
        }
        if (this.m_currentGeometry != null) {
            this.setGeometry(null);
        }
    }

    public PvViewer() {
        this(null, null);
        this.m_bStarted = true;
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public PvViewer(Applet applet, Frame frame) {
        this.m_applet = applet;
        this.m_frame = frame;
        PsConfig.init(applet, this, frame);
        this.m_jvRsrc = new PsJavaView();
        this.m_projectCategory = new Hashtable();
        this.m_projectClass = new Hashtable();
        this.m_projectList = new Hashtable();
        this.m_projectParms = new Hashtable();
        this.setName(PsConfig.getMessage(12015) + " " + PsConfig.getProgram());
        if (frame != null) {
            PvDisplay.setDefaultSize(frame.getSize());
        } else if (applet != null) {
            PvDisplay.setDefaultSize(applet.getSize());
        }
        if (PsDebug.isNotify()) {
            this.printParameter();
        }
        this.m_displayVector = new Vector();
        this.m_frameVector = new Vector();
        this.init();
    }

    protected static int getPanelId(String string) {
        if ("Project".equalsIgnoreCase(string)) {
            return 10;
        }
        if ("Info".equalsIgnoreCase(string)) {
            return 12;
        }
        if ("Material".equalsIgnoreCase(string)) {
            return 13;
        }
        if ("Texture".equalsIgnoreCase(string)) {
            return 14;
        }
        if ("Vector".equalsIgnoreCase(string)) {
            return 15;
        }
        if ("Label".equalsIgnoreCase(string)) {
            return 17;
        }
        if ("Config".equalsIgnoreCase(string)) {
            return 16;
        }
        if ("Axis".equalsIgnoreCase(string)) {
            return 19;
        }
        if ("Light".equalsIgnoreCase(string)) {
            return 18;
        }
        if ("Camera".equalsIgnoreCase(string)) {
            return 20;
        }
        if ("Display".equalsIgnoreCase(string)) {
            return 21;
        }
        PsDebug.warning("panel not found = " + string);
        return -1;
    }

    public PvControlMenu newMenuBar(Frame frame) {
        String string;
        PvControlMenu pvControlMenu = new PvControlMenu(this, frame);
        if (frame != null && frame == this.m_frame) {
            pvControlMenu.m_mFile.remove(pvControlMenu.m_mFile_Close);
        }
        pvControlMenu.setEnabledMenu(21, this.m_currentProject != null);
        pvControlMenu.setEnabledMenu(22, this.m_currentGeometry != null);
        pvControlMenu.setEnabledMenu(3, this.m_currentGeometry != null);
        if (this.m_currentGeometry != null) {
            this.m_currentGeometry.fillMethodMenu(pvControlMenu.m_mMethod, this);
            pvControlMenu.setEnabledMenu(220, this.m_currentGeometry.isConfigurable(4));
            pvControlMenu.setEnabledMenu(221, this.m_currentGeometry.isConfigurable(5));
            pvControlMenu.setEnabledMenu(222, this.m_currentGeometry.isConfigurable(6));
            pvControlMenu.setEnabledMenu(223, this.m_currentGeometry.isConfigurable(8));
            pvControlMenu.setEnabledMenu(224, this.m_currentGeometry.isConfigurable(9));
            pvControlMenu.setEnabledMenu(225, this.m_currentGeometry.isConfigurable(7));
        }
        boolean bl = this.m_currentProject != null && this.m_currentProject.hasAnimation();
        pvControlMenu.setEnabledMenu(40, bl);
        if (this.m_projectClass != null && this.m_projectClass.size() > 0 && ((string = this.getParameter("menu-new-project")) == null || "enable".equalsIgnoreCase(string))) {
            pvControlMenu.setEnabledMenu(100, true);
        }
        if (this.m_menuBars == null) {
            this.m_menuBars = new Vector();
        }
        this.m_menuBars.addElement(pvControlMenu);
        return pvControlMenu;
    }

    private void removeControl() {
        this.m_control.removeWindowListener(this);
        MenuBar menuBar = this.m_control.getMenuBar();
        if (menuBar != null && this.m_menuBars != null && this.m_menuBars.contains(menuBar)) {
            this.m_menuBars.removeElement(menuBar);
        }
        this.m_control.dispose();
        this.m_control = null;
    }

    public void setEmbedded(boolean bl) {
        this.m_bEmbedded = bl;
    }

    private boolean parseDisplayParameters(PvDisplayIf pvDisplayIf) {
        PdVector pdVector;
        boolean bl = false;
        String string = this.getParameter("Antialias");
        if (string != null) {
            pvDisplayIf.setEnabledAntiAlias(string.equalsIgnoreCase("Show"));
            bl = true;
        }
        if ((string = this.getParameter("Axes")) != null) {
            pvDisplayIf.showAxes(string.equalsIgnoreCase("Show"));
            bl = true;
        }
        if ((string = this.getParameter("Background")) != null) {
            pvDisplayIf.setBackgroundColor(PdColor.parseColor(string));
            bl = true;
        } else {
            string = this.getParameter("BGCOLOR");
            if (string != null) {
                pvDisplayIf.setBackgroundColor(PdColor.parseColor(string));
                bl = true;
            }
        }
        string = this.getParameter("BackgroundImage");
        if (string != null) {
            pvDisplayIf.setBackgroundImageFile(string);
            string = this.getParameter("BackgroundImageFit");
            if (string != null) {
                if (string.equalsIgnoreCase("center")) {
                    pvDisplayIf.setBackgroundImageFit(0);
                } else if (string.equalsIgnoreCase("fit")) {
                    pvDisplayIf.setBackgroundImageFit(1);
                } else if (string.equalsIgnoreCase("resize")) {
                    pvDisplayIf.setBackgroundImageFit(2);
                } else if (string.equalsIgnoreCase("tesselate")) {
                    pvDisplayIf.setBackgroundImageFit(3);
                } else {
                    PsDebug.warning("unknown applet parameter = " + string);
                }
            }
            pvDisplayIf.showBackgroundImage(true);
            bl = true;
        }
        if ((string = this.getParameter("Border")) != null) {
            pvDisplayIf.setPaintTag(4L, string.equalsIgnoreCase("Show"));
            bl = true;
        }
        if ((string = this.getParameter("BoundingBox")) != null) {
            pvDisplayIf.showBndBox(string.equalsIgnoreCase("Show"));
            bl = true;
        }
        if ((string = this.getParameter("Copyright")) != null) {
            ((PvDisplay)pvDisplayIf).showCopyright(string.equalsIgnoreCase("Show"));
            bl = true;
        }
        if ((string = this.getParameter("Depthcue")) != null) {
            pvDisplayIf.showDepthcue(string.equalsIgnoreCase("Show"));
            bl = true;
        }
        if ((string = this.getParameter("EdgeAura")) != null) {
            pvDisplayIf.showEdgeAura(string.equalsIgnoreCase("Show"));
            bl = true;
        }
        if ((string = this.getParameter("ForegroundImage")) != null) {
            pvDisplayIf.setForegroundImageFile(string);
            string = this.getParameter("ForegroundImageFit");
            if (string != null) {
                if (string.equalsIgnoreCase("center")) {
                    pvDisplayIf.setForegroundImageFit(0);
                } else if (string.equalsIgnoreCase("fit")) {
                    pvDisplayIf.setForegroundImageFit(1);
                } else if (string.equalsIgnoreCase("resize")) {
                    pvDisplayIf.setForegroundImageFit(2);
                } else if (string.equalsIgnoreCase("tesselate")) {
                    pvDisplayIf.setForegroundImageFit(3);
                } else {
                    PsDebug.warning("unknown value of applet parameter = " + string);
                }
            }
            pvDisplayIf.showForegroundImage(true);
            bl = true;
        }
        if ((string = this.getParameter("Frame")) != null) {
            pvDisplayIf.showFrame(string.equalsIgnoreCase("Show"));
            bl = true;
        }
        if ((string = this.getParameter("Sorting")) != null) {
            pvDisplayIf.setEnabledPainters(string.equalsIgnoreCase("Show"));
            bl = true;
        }
        if ((string = this.getParameter("Interest")) != null) {
            pdVector = PsXmlLoader.parsePdVector(string);
            if (pdVector != null) {
                pvDisplayIf.getCamera().setInterest(pdVector);
            }
            bl = true;
        }
        if ((string = this.getParameter("ViewDir")) != null) {
            pdVector = PsXmlLoader.parsePdVector(string);
            if (pdVector != null) {
                pvDisplayIf.getCamera().setViewDir(pdVector);
            }
            bl = true;
        }
        if ((string = this.getParameter("UpDir")) != null) {
            pdVector = PsXmlLoader.parsePdVector(string);
            if (pdVector != null && pdVector.normalize()) {
                pvDisplayIf.getCamera().setUpVector(pdVector);
            }
            bl = true;
        }
        if ((string = this.getParameter("Roll")) != null) {
            double d = PgLoader.parseDouble(string);
            if (d != 0.0) {
                pvDisplayIf.getCamera().setRoll(d);
            }
            bl = true;
        }
        if ((string = this.getParameter("Distance")) != null) {
            double d = PgLoader.parseDouble(string);
            if (d != 0.0) {
                pvDisplayIf.getCamera().setDist(d);
            }
            bl = true;
        }
        if ((string = this.getParameter("Perspective")) != null) {
            double d = PgLoader.parseDouble(string);
            pvDisplayIf.getCamera().setFieldOfView(d);
            bl = true;
        }
        if ((string = this.getParameter("Title")) != null) {
            pvDisplayIf.setName(string);
            pvDisplayIf.showTitle(true);
            bl = true;
        }
        if ((string = this.getParameter("ZBuffer")) != null) {
            pvDisplayIf.setEnabledZBuffer(string.equalsIgnoreCase("Show"));
            bl = true;
        }
        if ((string = this.getParameter("MajorMode")) != null) {
            if (string.equalsIgnoreCase("rotate")) {
                pvDisplayIf.setMajorMode(0);
            } else if (string.equalsIgnoreCase("rotate-xy")) {
                pvDisplayIf.setMajorMode(17);
            } else if (string.equalsIgnoreCase("scale")) {
                pvDisplayIf.setMajorMode(1);
            } else if (string.equalsIgnoreCase("translate")) {
                pvDisplayIf.setMajorMode(3);
            } else if (string.equalsIgnoreCase("translate-z")) {
                pvDisplayIf.setMajorMode(4);
            } else if (string.equalsIgnoreCase("initial")) {
                pvDisplayIf.setMajorMode(6);
            } else if (string.equalsIgnoreCase("pick")) {
                pvDisplayIf.setMajorMode(5);
            } else {
                PsDebug.warning("unknown parameter value: MajorMode = " + string);
            }
        }
        if ((string = this.getParameter("DirectSelect")) != null) {
            if (string.equalsIgnoreCase("show")) {
                pvDisplayIf.setEnabledDirectSelect(true);
            } else {
                PsDebug.warning("unknown parameter value: DirectSelect = " + string);
            }
        }
        if ((string = this.getParameter("LocalTransform")) != null) {
            if (string.equalsIgnoreCase("show")) {
                pvDisplayIf.setEnabledLocalTransform(true);
            } else {
                PsDebug.warning("unknown parameter value: LocalTransform = " + string);
            }
        }
        return bl;
    }

    public void addProjects() {
        String string;
        int n = 1;
        while ((string = this.getParameter("Project" + n)) != null) {
            ++n;
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            int n2 = stringTokenizer.countTokens() - 2;
            String[] stringArray = new String[n2];
            String string2 = stringTokenizer.nextToken();
            string2 = string2.trim();
            String string3 = stringTokenizer.nextToken();
            string3 = string3.trim();
            int n3 = 0;
            while (n3 < n2) {
                stringArray[n3] = stringTokenizer.nextToken();
                stringArray[n3] = stringArray[n3].trim();
                ++n3;
            }
            this.addProject(string2, string3, stringArray);
        }
        string = this.getParameter("Select");
        if (string != null) {
            this.selectProject(string);
        }
    }

    public Hashtable getProjectInstances() {
        return this.m_projectList;
    }

    public String newDisplay() {
        PvDisplayIf pvDisplayIf = this.m_display;
        PvDisplayIf pvDisplayIf2 = this.newDisplay(null);
        if (pvDisplayIf2 == null) {
            return null;
        }
        if (this.m_currentProject != null) {
            PvDisplayIf pvDisplayIf3 = this.m_currentProject.getDisplay();
            this.m_currentProject.setDisplay(pvDisplayIf2);
            if (pvDisplayIf3 != null) {
                this.m_currentProject.selectDisplay(pvDisplayIf3);
            }
        }
        if (pvDisplayIf != null) {
            ((PvDisplay)pvDisplayIf).configure(pvDisplayIf2);
        }
        pvDisplayIf2.update(pvDisplayIf2);
        return pvDisplayIf2.getName();
    }

    public PvDisplayIf newDisplay(String string) {
        PvDisplayIf pvDisplayIf = this.newDisplay(string, true);
        Frame frame = pvDisplayIf.getFrame();
        int n = this.getNumDisplays() - 1;
        Insets insets = frame.getInsets();
        int n2 = 320 + insets.left + insets.right;
        int n3 = 256 + insets.bottom + insets.top;
        if (n > 0) {
            ((Component)frame).setBounds(new Rectangle(5 + n2 * ((n - 1) % 3), 5 + n3 * ((n - 1) / 3), n2, n3));
        } else {
            ((Component)frame).setBounds(new Rectangle(50, 50, n2, n3));
        }
        ((Component)frame).setVisible(true);
        return pvDisplayIf;
    }

    public PvDisplayIf newDisplay(String string, boolean bl, boolean bl2) {
        int n = this.getNumDisplays();
        if (string == null) {
            string = PsConfig.getMessage(24320) + String.valueOf(n);
        }
        PvDisplay pvDisplay = new PvDisplay(this);
        this.addDisplay(string, pvDisplay);
        if (bl2) {
            this.selectDisplay(pvDisplay);
        }
        if (bl) {
            PsMainFrame psMainFrame = new PsMainFrame(pvDisplay, string, null);
            psMainFrame.setMenuBar(this.newMenuBar(psMainFrame));
            psMainFrame.pack();
            psMainFrame.setInnerBounds(new Rectangle(50, 50, 320, 256));
            pvDisplay.setFrame(psMainFrame);
            this.addFrame(psMainFrame);
        }
        return pvDisplay;
    }

    public PvDisplayIf newDisplay(String string, boolean bl) {
        return this.newDisplay(string, bl, true);
    }

    public boolean addDisplay(String string, PvDisplayIf pvDisplayIf) {
        if (pvDisplayIf == null) {
            PsDebug.warning("missing argument display");
            return false;
        }
        if (this.m_displayVector == null) {
            PsDebug.error("missing instance variable m_displayVector.", this);
            return false;
        }
        if (this.hasDisplay(pvDisplayIf)) {
            PsDebug.warning("display with name = " + string + " already registered.");
        }
        pvDisplayIf.setParent(this);
        pvDisplayIf.setViewer(this);
        pvDisplayIf.addKeyListener(this);
        pvDisplayIf.setName(string);
        this.m_displayVector.addElement(pvDisplayIf);
        return true;
    }

    protected void deserialize() {
        Object object;
        Object object2;
        PgFileDialog pgFileDialog = new PgFileDialog(PsConfig.getFrame(), PsConfig.getMessage(24322), 0);
        if (this.m_serialDirName == null) {
            this.m_serialDirName = PsConfig.getCodeBase() + "dev/models/serialized/";
        }
        pgFileDialog.setDirectory(this.m_serialDirName);
        pgFileDialog.setExtension("ser");
        pgFileDialog.show();
        String string = pgFileDialog.getFullFileName();
        if (string == null) {
            return;
        }
        this.m_serialDirName = pgFileDialog.getDirectory();
        Object object3 = null;
        try {
            object2 = new FileInputStream(string);
            object = new ObjectInputStream((InputStream)object2);
            object3 = ((ObjectInputStream)object).readObject();
        }
        catch (Exception exception) {
            PsDebug.message(exception.toString());
        }
        if (object3 == null) {
            PsDebug.warning("object not loaded.");
            return;
        }
        object2 = pgFileDialog.getFile();
        if (object3 instanceof PvDisplay) {
            object = (PvDisplayIf)object3;
            Dimension dimension = object.getSize();
            object.setName((String)object2);
            this.addDisplay((String)object2, (PvDisplayIf)object);
            this.selectDisplay((PvDisplayIf)object);
            PsMainFrame psMainFrame = new PsMainFrame((String)object2, null);
            psMainFrame.setMenuBar(this.newMenuBar(psMainFrame));
            psMainFrame.add((Component)object, "Center");
            object.setFrame(psMainFrame);
            psMainFrame.pack();
            if (dimension != null) {
                psMainFrame.setInnerBounds(50, 50, dimension.width, dimension.height);
            } else {
                psMainFrame.setInnerBounds(50, 50, 320, 256);
            }
            ((Component)psMainFrame).setVisible(true);
            this.addFrame(psMainFrame);
            return;
        }
        if (object3 instanceof PgGeometryIf) {
            object = (PgGeometryIf)object3;
            object.setName((String)object2);
            PvDisplayIf pvDisplayIf = this.getDisplay();
            pvDisplayIf.addGeometry((PgGeometryIf)object);
            pvDisplayIf.selectGeometry((PgGeometryIf)object);
            pvDisplayIf.update(pvDisplayIf);
            return;
        }
        if (object3 instanceof Applet) {
            object = (Applet)object3;
            ((Component)object).setName((String)object2);
            PsMainFrame psMainFrame = new PsMainFrame((Component)object, (String)object2, null);
            ((Applet)object).init();
            String string2 = System.getProperty("os.name");
            if (string2 != null) {
                if (string2.toLowerCase().startsWith("win")) {
                    ((Component)psMainFrame).setBounds(new Rectangle(420, 5, 640, 550));
                } else {
                    ((Component)psMainFrame).setSize(640, 550);
                }
            }
            ((Component)psMainFrame).setVisible(true);
            return;
        }
        if (object3 instanceof PjProject) {
            object = (PjProject)object3;
            ((PsObject)object).setName((String)object2);
            this.addProject((PjProject)object);
            this.selectProject((String)object2);
        }
    }

    protected boolean addFrame(Frame frame) {
        if (this.hasFrame(frame)) {
            PsDebug.warning("frame already used.");
            return false;
        }
        this.m_frameVector.addElement(frame);
        frame.addWindowListener(this);
        if (frame instanceof PsMainFrame) {
            frame.removeWindowListener((PsMainFrame)frame);
        }
        return true;
    }
}

